/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2022 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */

 (function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();/*
	else if(typeof define === 'function' && define.amd)
		define("pdfjs-dist/build/pdf.worker", [], factory);
	else if(typeof exports === 'object')
		exports["pdfjs-dist/build/pdf.worker"] = factory();*/
	else
		root["pdfjs-dist/build/pdf.worker"] = root.pdfjsWorker = factory();
})(this, function() {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WorkerTask = exports.WorkerMessageHandler = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _primitives = __w_pdfjs_require__(147);

var _pdf_manager = __w_pdfjs_require__(148);

var _cleanup_helper = __w_pdfjs_require__(208);

var _writer = __w_pdfjs_require__(214);

var _is_node = __w_pdfjs_require__(6);

var _message_handler = __w_pdfjs_require__(242);

var _worker_stream = __w_pdfjs_require__(243);

var _core_utils = __w_pdfjs_require__(150);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var WorkerTask = /*#__PURE__*/function () {
  function WorkerTask(name) {
    _classCallCheck(this, WorkerTask);

    this.name = name;
    this.terminated = false;
    this._capability = (0, _util.createPromiseCapability)();
  }

  _createClass(WorkerTask, [{
    key: "finished",
    get: function get() {
      return this._capability.promise;
    }
  }, {
    key: "finish",
    value: function finish() {
      this._capability.resolve();
    }
  }, {
    key: "terminate",
    value: function terminate() {
      this.terminated = true;
    }
  }, {
    key: "ensureNotTerminated",
    value: function ensureNotTerminated() {
      if (this.terminated) {
        throw new Error("Worker task was terminated");
      }
    }
  }]);

  return WorkerTask;
}();

exports.WorkerTask = WorkerTask;

var WorkerMessageHandler = /*#__PURE__*/function () {
  function WorkerMessageHandler() {
    _classCallCheck(this, WorkerMessageHandler);
  }

  _createClass(WorkerMessageHandler, null, [{
    key: "setup",
    value: function setup(handler, port) {
      var testMessageProcessed = false;
      handler.on("test", function wphSetupTest(data) {
        if (testMessageProcessed) {
          return;
        }

        testMessageProcessed = true;
        handler.send("test", data instanceof Uint8Array && data[0] === 255);
      });
      handler.on("configure", function wphConfigure(data) {
        (0, _util.setVerbosityLevel)(data.verbosity);
      });
      handler.on("GetDocRequest", function wphSetupDoc(data) {
        return WorkerMessageHandler.createDocumentHandler(data, port);
      });
    }
  }, {
    key: "createDocumentHandler",
    value: function createDocumentHandler(docParams, port) {
      var pdfManager;
      var terminated = false;
      var cancelXHRs = null;
      var WorkerTasks = [];
      var verbosity = (0, _util.getVerbosityLevel)();
      var apiVersion = docParams.apiVersion;
      var workerVersion = '2.14.34';

      if (apiVersion !== workerVersion) {
        throw new Error("The API version \"".concat(apiVersion, "\" does not match ") + "the Worker version \"".concat(workerVersion, "\"."));
      }

      var enumerableProperties = [];

      for (var property in []) {
        enumerableProperties.push(property);
      }

      if (enumerableProperties.length) {
        throw new Error("The `Array.prototype` contains unexpected enumerable properties: " + enumerableProperties.join(", ") + "; thus breaking e.g. `for...in` iteration of `Array`s.");
      }

      if (typeof ReadableStream === "undefined") {
        var partialMsg = "The browser/environment lacks native support for critical " + "functionality used by the PDF.js library (e.g. `ReadableStream`); ";

        if (_is_node.isNodeJS) {
          throw new Error(partialMsg + "please use a `legacy`-build instead.");
        }

        throw new Error(partialMsg + "please update to a supported browser.");
      }

      var docId = docParams.docId;
      var docBaseUrl = docParams.docBaseUrl;
      var workerHandlerName = docParams.docId + "_worker";
      var handler = new _message_handler.MessageHandler(workerHandlerName, docId, port);

      function ensureNotTerminated() {
        if (terminated) {
          throw new Error("Worker was terminated");
        }
      }

      function startWorkerTask(task) {
        WorkerTasks.push(task);
      }

      function finishWorkerTask(task) {
        task.finish();
        var i = WorkerTasks.indexOf(task);
        WorkerTasks.splice(i, 1);
      }

      function loadDocument(_x) {
        return _loadDocument.apply(this, arguments);
      }

      function _loadDocument() {
        _loadDocument = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(recoveryMode) {
          var isPureXfa, task, _yield$Promise$all, _yield$Promise$all2, numPages, fingerprints, htmlForXfa;

          return _regenerator["default"].wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  _context.next = 2;
                  return pdfManager.ensureDoc("checkHeader");

                case 2:
                  _context.next = 4;
                  return pdfManager.ensureDoc("parseStartXRef");

                case 4:
                  _context.next = 6;
                  return pdfManager.ensureDoc("parse", [recoveryMode]);

                case 6:
                  _context.next = 8;
                  return pdfManager.ensureDoc("checkFirstPage", [recoveryMode]);

                case 8:
                  _context.next = 10;
                  return pdfManager.ensureDoc("checkLastPage", [recoveryMode]);

                case 10:
                  _context.next = 12;
                  return pdfManager.ensureDoc("isPureXfa");

                case 12:
                  isPureXfa = _context.sent;

                  if (!isPureXfa) {
                    _context.next = 18;
                    break;
                  }

                  task = new WorkerTask("loadXfaFonts");
                  startWorkerTask(task);
                  _context.next = 18;
                  return Promise.all([pdfManager.loadXfaFonts(handler, task)["catch"](function (reason) {}).then(function () {
                    return finishWorkerTask(task);
                  }), pdfManager.loadXfaImages()]);

                case 18:
                  _context.next = 20;
                  return Promise.all([pdfManager.ensureDoc("numPages"), pdfManager.ensureDoc("fingerprints")]);

                case 20:
                  _yield$Promise$all = _context.sent;
                  _yield$Promise$all2 = _slicedToArray(_yield$Promise$all, 2);
                  numPages = _yield$Promise$all2[0];
                  fingerprints = _yield$Promise$all2[1];

                  if (!isPureXfa) {
                    _context.next = 30;
                    break;
                  }

                  _context.next = 27;
                  return pdfManager.ensureDoc("htmlForXfa");

                case 27:
                  _context.t0 = _context.sent;
                  _context.next = 31;
                  break;

                case 30:
                  _context.t0 = null;

                case 31:
                  htmlForXfa = _context.t0;
                  return _context.abrupt("return", {
                    numPages: numPages,
                    fingerprints: fingerprints,
                    htmlForXfa: htmlForXfa
                  });

                case 33:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));
        return _loadDocument.apply(this, arguments);
      }

      function getPdfManager(data, evaluatorOptions, enableXfa) {
        var pdfManagerCapability = (0, _util.createPromiseCapability)();
        var newPdfManager;
        var source = data.source;

        if (source.data) {
          try {
            newPdfManager = new _pdf_manager.LocalPdfManager(docId, source.data, source.password, handler, evaluatorOptions, enableXfa, docBaseUrl);
            pdfManagerCapability.resolve(newPdfManager);
          } catch (ex) {
            pdfManagerCapability.reject(ex);
          }

          return pdfManagerCapability.promise;
        }

        var pdfStream,
            cachedChunks = [];

        try {
          pdfStream = new _worker_stream.PDFWorkerStream(handler);
        } catch (ex) {
          pdfManagerCapability.reject(ex);
          return pdfManagerCapability.promise;
        }

        var fullRequest = pdfStream.getFullReader();
        fullRequest.headersReady.then(function () {
          if (!fullRequest.isRangeSupported) {
            return;
          }

          var disableAutoFetch = source.disableAutoFetch || fullRequest.isStreamingSupported;
          newPdfManager = new _pdf_manager.NetworkPdfManager(docId, pdfStream, {
            msgHandler: handler,
            password: source.password,
            length: fullRequest.contentLength,
            disableAutoFetch: disableAutoFetch,
            rangeChunkSize: source.rangeChunkSize
          }, evaluatorOptions, enableXfa, docBaseUrl);

          for (var i = 0; i < cachedChunks.length; i++) {
            newPdfManager.sendProgressiveData(cachedChunks[i]);
          }

          cachedChunks = [];
          pdfManagerCapability.resolve(newPdfManager);
          cancelXHRs = null;
        })["catch"](function (reason) {
          pdfManagerCapability.reject(reason);
          cancelXHRs = null;
        });
        var loaded = 0;

        var flushChunks = function flushChunks() {
          var pdfFile = (0, _util.arraysToBytes)(cachedChunks);

          if (source.length && pdfFile.length !== source.length) {
            (0, _util.warn)("reported HTTP length is different from actual");
          }

          try {
            newPdfManager = new _pdf_manager.LocalPdfManager(docId, pdfFile, source.password, handler, evaluatorOptions, enableXfa, docBaseUrl);
            pdfManagerCapability.resolve(newPdfManager);
          } catch (ex) {
            pdfManagerCapability.reject(ex);
          }

          cachedChunks = [];
        };

        var readPromise = new Promise(function (resolve, reject) {
          var readChunk = function readChunk(_ref) {
            var value = _ref.value,
                done = _ref.done;

            try {
              ensureNotTerminated();

              if (done) {
                if (!newPdfManager) {
                  flushChunks();
                }

                cancelXHRs = null;
                return;
              }

              loaded += (0, _util.arrayByteLength)(value);

              if (!fullRequest.isStreamingSupported) {
                handler.send("DocProgress", {
                  loaded: loaded,
                  total: Math.max(loaded, fullRequest.contentLength || 0)
                });
              }

              if (newPdfManager) {
                newPdfManager.sendProgressiveData(value);
              } else {
                cachedChunks.push(value);
              }

              fullRequest.read().then(readChunk, reject);
            } catch (e) {
              reject(e);
            }
          };

          fullRequest.read().then(readChunk, reject);
        });
        readPromise["catch"](function (e) {
          pdfManagerCapability.reject(e);
          cancelXHRs = null;
        });

        cancelXHRs = function cancelXHRs(reason) {
          pdfStream.cancelAllRequests(reason);
        };

        return pdfManagerCapability.promise;
      }

      function setupDoc(data) {
        function onSuccess(doc) {
          ensureNotTerminated();
          handler.send("GetDoc", {
            pdfInfo: doc
          });
        }

        function onFailure(ex) {
          ensureNotTerminated();

          if (ex instanceof _util.PasswordException) {
            var task = new WorkerTask("PasswordException: response ".concat(ex.code));
            startWorkerTask(task);
            handler.sendWithPromise("PasswordRequest", ex).then(function (_ref2) {
              var password = _ref2.password;
              finishWorkerTask(task);
              pdfManager.updatePassword(password);
              pdfManagerReady();
            })["catch"](function () {
              finishWorkerTask(task);
              handler.send("DocException", ex);
            });
          } else if (ex instanceof _util.InvalidPDFException || ex instanceof _util.MissingPDFException || ex instanceof _util.UnexpectedResponseException || ex instanceof _util.UnknownErrorException) {
            handler.send("DocException", ex);
          } else {
            handler.send("DocException", new _util.UnknownErrorException(ex.message, ex.toString()));
          }
        }

        function pdfManagerReady() {
          ensureNotTerminated();
          loadDocument(false).then(onSuccess, function (reason) {
            ensureNotTerminated();

            if (!(reason instanceof _core_utils.XRefParseException)) {
              onFailure(reason);
              return;
            }

            pdfManager.requestLoadedStream();
            pdfManager.onLoadedStream().then(function () {
              ensureNotTerminated();
              loadDocument(true).then(onSuccess, onFailure);
            });
          });
        }

        ensureNotTerminated();
        var evaluatorOptions = {
          maxImageSize: data.maxImageSize,
          disableFontFace: data.disableFontFace,
          ignoreErrors: data.ignoreErrors,
          isEvalSupported: data.isEvalSupported,
          fontExtraProperties: data.fontExtraProperties,
          useSystemFonts: data.useSystemFonts,
          cMapUrl: data.cMapUrl,
          standardFontDataUrl: data.standardFontDataUrl
        };
        getPdfManager(data, evaluatorOptions, data.enableXfa).then(function (newPdfManager) {
          if (terminated) {
            newPdfManager.terminate(new _util.AbortException("Worker was terminated."));
            throw new Error("Worker was terminated");
          }

          pdfManager = newPdfManager;
          pdfManager.onLoadedStream().then(function (stream) {
            handler.send("DataLoaded", {
              length: stream.bytes.byteLength
            });
          });
        }).then(pdfManagerReady, onFailure);
      }

      handler.on("GetPage", function wphSetupGetPage(data) {
        return pdfManager.getPage(data.pageIndex).then(function (page) {
          return Promise.all([pdfManager.ensure(page, "rotate"), pdfManager.ensure(page, "ref"), pdfManager.ensure(page, "userUnit"), pdfManager.ensure(page, "view")]).then(function (_ref3) {
            var _ref4 = _slicedToArray(_ref3, 4),
                rotate = _ref4[0],
                ref = _ref4[1],
                userUnit = _ref4[2],
                view = _ref4[3];

            return {
              rotate: rotate,
              ref: ref,
              userUnit: userUnit,
              view: view
            };
          });
        });
      });
      handler.on("GetPageIndex", function wphSetupGetPageIndex(data) {
        var pageRef = _primitives.Ref.get(data.num, data.gen);

        return pdfManager.ensureCatalog("getPageIndex", [pageRef]);
      });
      handler.on("GetDestinations", function wphSetupGetDestinations(data) {
        return pdfManager.ensureCatalog("destinations");
      });
      handler.on("GetDestination", function wphSetupGetDestination(data) {
        return pdfManager.ensureCatalog("getDestination", [data.id]);
      });
      handler.on("GetPageLabels", function wphSetupGetPageLabels(data) {
        return pdfManager.ensureCatalog("pageLabels");
      });
      handler.on("GetPageLayout", function wphSetupGetPageLayout(data) {
        return pdfManager.ensureCatalog("pageLayout");
      });
      handler.on("GetPageMode", function wphSetupGetPageMode(data) {
        return pdfManager.ensureCatalog("pageMode");
      });
      handler.on("GetViewerPreferences", function (data) {
        return pdfManager.ensureCatalog("viewerPreferences");
      });
      handler.on("GetOpenAction", function (data) {
        return pdfManager.ensureCatalog("openAction");
      });
      handler.on("GetAttachments", function wphSetupGetAttachments(data) {
        return pdfManager.ensureCatalog("attachments");
      });
      handler.on("GetJavaScript", function wphSetupGetJavaScript(data) {
        return pdfManager.ensureCatalog("javaScript");
      });
      handler.on("GetDocJSActions", function wphSetupGetDocJSActions(data) {
        return pdfManager.ensureCatalog("jsActions");
      });
      handler.on("GetPageJSActions", function (_ref5) {
        var pageIndex = _ref5.pageIndex;
        return pdfManager.getPage(pageIndex).then(function (page) {
          return pdfManager.ensure(page, "jsActions");
        });
      });
      handler.on("GetOutline", function wphSetupGetOutline(data) {
        return pdfManager.ensureCatalog("documentOutline");
      });
      handler.on("GetOptionalContentConfig", function (data) {
        return pdfManager.ensureCatalog("optionalContentConfig");
      });
      handler.on("GetPermissions", function (data) {
        return pdfManager.ensureCatalog("permissions");
      });
      handler.on("GetMetadata", function wphSetupGetMetadata(data) {
        return Promise.all([pdfManager.ensureDoc("documentInfo"), pdfManager.ensureCatalog("metadata")]);
      });
      handler.on("GetMarkInfo", function wphSetupGetMarkInfo(data) {
        return pdfManager.ensureCatalog("markInfo");
      });
      handler.on("GetData", function wphSetupGetData(data) {
        pdfManager.requestLoadedStream();
        return pdfManager.onLoadedStream().then(function (stream) {
          return stream.bytes;
        });
      });
      handler.on("GetAnnotations", function (_ref6) {
        var pageIndex = _ref6.pageIndex,
            intent = _ref6.intent;
        return pdfManager.getPage(pageIndex).then(function (page) {
          return page.getAnnotationsData(intent);
        });
      });
      handler.on("GetFieldObjects", function (data) {
        return pdfManager.ensureDoc("fieldObjects");
      });
      handler.on("HasJSActions", function (data) {
        return pdfManager.ensureDoc("hasJSActions");
      });
      handler.on("GetCalculationOrderIds", function (data) {
        return pdfManager.ensureDoc("calculationOrderIds");
      });
      handler.on("SaveDocument", function (_ref7) {
        var isPureXfa = _ref7.isPureXfa,
            numPages = _ref7.numPages,
            annotationStorage = _ref7.annotationStorage,
            filename = _ref7.filename;
        pdfManager.requestLoadedStream();
        var promises = [pdfManager.onLoadedStream(), pdfManager.ensureCatalog("acroForm"), pdfManager.ensureCatalog("acroFormRef"), pdfManager.ensureDoc("xref"), pdfManager.ensureDoc("startXRef")];

        if (isPureXfa) {
          promises.push(pdfManager.serializeXfaData(annotationStorage));
        } else {
          var _loop = function _loop(pageIndex) {
            promises.push(pdfManager.getPage(pageIndex).then(function (page) {
              var task = new WorkerTask("Save: page ".concat(pageIndex));
              return page.save(handler, task, annotationStorage)["finally"](function () {
                finishWorkerTask(task);
              });
            }));
          };

          for (var pageIndex = 0; pageIndex < numPages; pageIndex++) {
            _loop(pageIndex);
          }
        }

        return Promise.all(promises).then(function (_ref8) {
          var _ref9 = _toArray(_ref8),
              stream = _ref9[0],
              acroForm = _ref9[1],
              acroFormRef = _ref9[2],
              xref = _ref9[3],
              startXRef = _ref9[4],
              refs = _ref9.slice(5);

          var newRefs = [];
          var xfaData = null;

          if (isPureXfa) {
            xfaData = refs[0];

            if (!xfaData) {
              return stream.bytes;
            }
          } else {
            var _iterator = _createForOfIteratorHelper(refs),
                _step;

            try {
              for (_iterator.s(); !(_step = _iterator.n()).done;) {
                var ref = _step.value;
                newRefs = ref.filter(function (x) {
                  return x !== null;
                }).reduce(function (a, b) {
                  return a.concat(b);
                }, newRefs);
              }
            } catch (err) {
              _iterator.e(err);
            } finally {
              _iterator.f();
            }

            if (newRefs.length === 0) {
              return stream.bytes;
            }
          }

          var xfa = acroForm instanceof _primitives.Dict && acroForm.get("XFA") || null;
          var xfaDatasetsRef = null;
          var hasXfaDatasetsEntry = false;

          if (Array.isArray(xfa)) {
            for (var i = 0, ii = xfa.length; i < ii; i += 2) {
              if (xfa[i] === "datasets") {
                xfaDatasetsRef = xfa[i + 1];
                acroFormRef = null;
                hasXfaDatasetsEntry = true;
              }
            }

            if (xfaDatasetsRef === null) {
              xfaDatasetsRef = xref.getNewRef();
            }
          } else if (xfa) {
            acroFormRef = null;
            (0, _util.warn)("Unsupported XFA type.");
          }

          var newXrefInfo = Object.create(null);

          if (xref.trailer) {
            var infoObj = Object.create(null);
            var xrefInfo = xref.trailer.get("Info") || null;

            if (xrefInfo instanceof _primitives.Dict) {
              xrefInfo.forEach(function (key, value) {
                if (typeof value === "string") {
                  infoObj[key] = (0, _util.stringToPDFString)(value);
                }
              });
            }

            newXrefInfo = {
              rootRef: xref.trailer.getRaw("Root") || null,
              encryptRef: xref.trailer.getRaw("Encrypt") || null,
              newRef: xref.getNewRef(),
              infoRef: xref.trailer.getRaw("Info") || null,
              info: infoObj,
              fileIds: xref.trailer.get("ID") || null,
              startXRef: startXRef,
              filename: filename
            };
          }

          xref.resetNewRef();
          return (0, _writer.incrementalUpdate)({
            originalData: stream.bytes,
            xrefInfo: newXrefInfo,
            newRefs: newRefs,
            xref: xref,
            hasXfa: !!xfa,
            xfaDatasetsRef: xfaDatasetsRef,
            hasXfaDatasetsEntry: hasXfaDatasetsEntry,
            acroFormRef: acroFormRef,
            acroForm: acroForm,
            xfaData: xfaData
          });
        });
      });
      handler.on("GetOperatorList", function wphSetupRenderPage(data, sink) {
        var pageIndex = data.pageIndex;
        pdfManager.getPage(pageIndex).then(function (page) {
          var task = new WorkerTask("GetOperatorList: page ".concat(pageIndex));
          startWorkerTask(task);
          var start = verbosity >= _util.VerbosityLevel.INFOS ? Date.now() : 0;
          page.getOperatorList({
            handler: handler,
            sink: sink,
            task: task,
            intent: data.intent,
            cacheKey: data.cacheKey,
            annotationStorage: data.annotationStorage
          }).then(function (operatorListInfo) {
            finishWorkerTask(task);

            if (start) {
              (0, _util.info)("page=".concat(pageIndex + 1, " - getOperatorList: time=") + "".concat(Date.now() - start, "ms, len=").concat(operatorListInfo.length));
            }

            sink.close();
          }, function (reason) {
            finishWorkerTask(task);

            if (task.terminated) {
              return;
            }

            handler.send("UnsupportedFeature", {
              featureId: _util.UNSUPPORTED_FEATURES.errorOperatorList
            });
            sink.error(reason);
          });
        });
      });
      handler.on("GetTextContent", function wphExtractText(data, sink) {
        var pageIndex = data.pageIndex;
        pdfManager.getPage(pageIndex).then(function (page) {
          var task = new WorkerTask("GetTextContent: page " + pageIndex);
          startWorkerTask(task);
          var start = verbosity >= _util.VerbosityLevel.INFOS ? Date.now() : 0;
          page.extractTextContent({
            handler: handler,
            task: task,
            sink: sink,
            includeMarkedContent: data.includeMarkedContent,
            combineTextItems: data.combineTextItems
          }).then(function () {
            finishWorkerTask(task);

            if (start) {
              (0, _util.info)("page=".concat(pageIndex + 1, " - getTextContent: time=") + "".concat(Date.now() - start, "ms"));
            }

            sink.close();
          }, function (reason) {
            finishWorkerTask(task);

            if (task.terminated) {
              return;
            }

            sink.error(reason);
          });
        });
      });
      handler.on("GetStructTree", function wphGetStructTree(data) {
        return pdfManager.getPage(data.pageIndex).then(function (page) {
          return pdfManager.ensure(page, "getStructTree");
        });
      });
      handler.on("FontFallback", function (data) {
        return pdfManager.fontFallback(data.id, handler);
      });
      handler.on("Cleanup", function wphCleanup(data) {
        return pdfManager.cleanup(true);
      });
      handler.on("Terminate", function wphTerminate(data) {
        terminated = true;
        var waitOn = [];

        if (pdfManager) {
          pdfManager.terminate(new _util.AbortException("Worker was terminated."));
          var cleanupPromise = pdfManager.cleanup();
          waitOn.push(cleanupPromise);
          pdfManager = null;
        } else {
          (0, _cleanup_helper.clearGlobalCaches)();
        }

        if (cancelXHRs) {
          cancelXHRs(new _util.AbortException("Worker was terminated."));
        }

        var _iterator2 = _createForOfIteratorHelper(WorkerTasks),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var task = _step2.value;
            waitOn.push(task.finished);
            task.terminate();
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }

        return Promise.all(waitOn).then(function () {
          handler.destroy();
          handler = null;
        });
      });
      handler.on("Ready", function wphReady(data) {
        setupDoc(docParams);
        docParams = null;
      });
      return workerHandlerName;
    }
  }, {
    key: "initializeFromPort",
    value: function initializeFromPort(port) {
      var handler = new _message_handler.MessageHandler("worker", "main", port);
      WorkerMessageHandler.setup(handler, port);
      handler.send("ready", null);
    }
  }]);

  return WorkerMessageHandler;
}();

exports.WorkerMessageHandler = WorkerMessageHandler;

function isMessagePort(maybePort) {
  return typeof maybePort.postMessage === "function" && "onmessage" in maybePort;
}

if (typeof window === "undefined" && !_is_node.isNodeJS && typeof self !== "undefined" && isMessagePort(self)) {
  WorkerMessageHandler.initializeFromPort(self);
}

/***/ }),
/* 2 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";


module.exports = __w_pdfjs_require__(3);

/***/ }),
/* 3 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";
/* module decorator */ module = __w_pdfjs_require__.nmd(module);


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var runtime = function (exports) {
  "use strict";

  var Op = Object.prototype;
  var hasOwn = Op.hasOwnProperty;
  var undefined;
  var $Symbol = typeof Symbol === "function" ? Symbol : {};
  var iteratorSymbol = $Symbol.iterator || "@@iterator";
  var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
  var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

  function define(obj, key, value) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
    return obj[key];
  }

  try {
    define({}, "");
  } catch (err) {
    define = function define(obj, key, value) {
      return obj[key] = value;
    };
  }

  function wrap(innerFn, outerFn, self, tryLocsList) {
    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
    var generator = Object.create(protoGenerator.prototype);
    var context = new Context(tryLocsList || []);
    generator._invoke = makeInvokeMethod(innerFn, self, context);
    return generator;
  }

  exports.wrap = wrap;

  function tryCatch(fn, obj, arg) {
    try {
      return {
        type: "normal",
        arg: fn.call(obj, arg)
      };
    } catch (err) {
      return {
        type: "throw",
        arg: err
      };
    }
  }

  var GenStateSuspendedStart = "suspendedStart";
  var GenStateSuspendedYield = "suspendedYield";
  var GenStateExecuting = "executing";
  var GenStateCompleted = "completed";
  var ContinueSentinel = {};

  function Generator() {}

  function GeneratorFunction() {}

  function GeneratorFunctionPrototype() {}

  var IteratorPrototype = {};
  define(IteratorPrototype, iteratorSymbol, function () {
    return this;
  });
  var getProto = Object.getPrototypeOf;
  var NativeIteratorPrototype = getProto && getProto(getProto(values([])));

  if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
    IteratorPrototype = NativeIteratorPrototype;
  }

  var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
  GeneratorFunction.prototype = GeneratorFunctionPrototype;
  define(Gp, "constructor", GeneratorFunctionPrototype);
  define(GeneratorFunctionPrototype, "constructor", GeneratorFunction);
  GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction");

  function defineIteratorMethods(prototype) {
    ["next", "throw", "return"].forEach(function (method) {
      define(prototype, method, function (arg) {
        return this._invoke(method, arg);
      });
    });
  }

  exports.isGeneratorFunction = function (genFun) {
    var ctor = typeof genFun === "function" && genFun.constructor;
    return ctor ? ctor === GeneratorFunction || (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
  };

  exports.mark = function (genFun) {
    if (Object.setPrototypeOf) {
      Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
    } else {
      genFun.__proto__ = GeneratorFunctionPrototype;
      define(genFun, toStringTagSymbol, "GeneratorFunction");
    }

    genFun.prototype = Object.create(Gp);
    return genFun;
  };

  exports.awrap = function (arg) {
    return {
      __await: arg
    };
  };

  function AsyncIterator(generator, PromiseImpl) {
    function invoke(method, arg, resolve, reject) {
      var record = tryCatch(generator[method], generator, arg);

      if (record.type === "throw") {
        reject(record.arg);
      } else {
        var result = record.arg;
        var value = result.value;

        if (value && _typeof(value) === "object" && hasOwn.call(value, "__await")) {
          return PromiseImpl.resolve(value.__await).then(function (value) {
            invoke("next", value, resolve, reject);
          }, function (err) {
            invoke("throw", err, resolve, reject);
          });
        }

        return PromiseImpl.resolve(value).then(function (unwrapped) {
          result.value = unwrapped;
          resolve(result);
        }, function (error) {
          return invoke("throw", error, resolve, reject);
        });
      }
    }

    var previousPromise;

    function enqueue(method, arg) {
      function callInvokeWithMethodAndArg() {
        return new PromiseImpl(function (resolve, reject) {
          invoke(method, arg, resolve, reject);
        });
      }

      return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
    }

    this._invoke = enqueue;
  }

  defineIteratorMethods(AsyncIterator.prototype);
  define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
    return this;
  });
  exports.AsyncIterator = AsyncIterator;

  exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
    if (PromiseImpl === void 0) PromiseImpl = Promise;
    var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
    return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
      return result.done ? result.value : iter.next();
    });
  };

  function makeInvokeMethod(innerFn, self, context) {
    var state = GenStateSuspendedStart;
    return function invoke(method, arg) {
      if (state === GenStateExecuting) {
        throw new Error("Generator is already running");
      }

      if (state === GenStateCompleted) {
        if (method === "throw") {
          throw arg;
        }

        return doneResult();
      }

      context.method = method;
      context.arg = arg;

      while (true) {
        var delegate = context.delegate;

        if (delegate) {
          var delegateResult = maybeInvokeDelegate(delegate, context);

          if (delegateResult) {
            if (delegateResult === ContinueSentinel) continue;
            return delegateResult;
          }
        }

        if (context.method === "next") {
          context.sent = context._sent = context.arg;
        } else if (context.method === "throw") {
          if (state === GenStateSuspendedStart) {
            state = GenStateCompleted;
            throw context.arg;
          }

          context.dispatchException(context.arg);
        } else if (context.method === "return") {
          context.abrupt("return", context.arg);
        }

        state = GenStateExecuting;
        var record = tryCatch(innerFn, self, context);

        if (record.type === "normal") {
          state = context.done ? GenStateCompleted : GenStateSuspendedYield;

          if (record.arg === ContinueSentinel) {
            continue;
          }

          return {
            value: record.arg,
            done: context.done
          };
        } else if (record.type === "throw") {
          state = GenStateCompleted;
          context.method = "throw";
          context.arg = record.arg;
        }
      }
    };
  }

  function maybeInvokeDelegate(delegate, context) {
    var method = delegate.iterator[context.method];

    if (method === undefined) {
      context.delegate = null;

      if (context.method === "throw") {
        if (delegate.iterator["return"]) {
          context.method = "return";
          context.arg = undefined;
          maybeInvokeDelegate(delegate, context);

          if (context.method === "throw") {
            return ContinueSentinel;
          }
        }

        context.method = "throw";
        context.arg = new TypeError("The iterator does not provide a 'throw' method");
      }

      return ContinueSentinel;
    }

    var record = tryCatch(method, delegate.iterator, context.arg);

    if (record.type === "throw") {
      context.method = "throw";
      context.arg = record.arg;
      context.delegate = null;
      return ContinueSentinel;
    }

    var info = record.arg;

    if (!info) {
      context.method = "throw";
      context.arg = new TypeError("iterator result is not an object");
      context.delegate = null;
      return ContinueSentinel;
    }

    if (info.done) {
      context[delegate.resultName] = info.value;
      context.next = delegate.nextLoc;

      if (context.method !== "return") {
        context.method = "next";
        context.arg = undefined;
      }
    } else {
      return info;
    }

    context.delegate = null;
    return ContinueSentinel;
  }

  defineIteratorMethods(Gp);
  define(Gp, toStringTagSymbol, "Generator");
  define(Gp, iteratorSymbol, function () {
    return this;
  });
  define(Gp, "toString", function () {
    return "[object Generator]";
  });

  function pushTryEntry(locs) {
    var entry = {
      tryLoc: locs[0]
    };

    if (1 in locs) {
      entry.catchLoc = locs[1];
    }

    if (2 in locs) {
      entry.finallyLoc = locs[2];
      entry.afterLoc = locs[3];
    }

    this.tryEntries.push(entry);
  }

  function resetTryEntry(entry) {
    var record = entry.completion || {};
    record.type = "normal";
    delete record.arg;
    entry.completion = record;
  }

  function Context(tryLocsList) {
    this.tryEntries = [{
      tryLoc: "root"
    }];
    tryLocsList.forEach(pushTryEntry, this);
    this.reset(true);
  }

  exports.keys = function (object) {
    var keys = [];

    for (var key in object) {
      keys.push(key);
    }

    keys.reverse();
    return function next() {
      while (keys.length) {
        var key = keys.pop();

        if (key in object) {
          next.value = key;
          next.done = false;
          return next;
        }
      }

      next.done = true;
      return next;
    };
  };

  function values(iterable) {
    if (iterable) {
      var iteratorMethod = iterable[iteratorSymbol];

      if (iteratorMethod) {
        return iteratorMethod.call(iterable);
      }

      if (typeof iterable.next === "function") {
        return iterable;
      }

      if (!isNaN(iterable.length)) {
        var i = -1,
            next = function next() {
          while (++i < iterable.length) {
            if (hasOwn.call(iterable, i)) {
              next.value = iterable[i];
              next.done = false;
              return next;
            }
          }

          next.value = undefined;
          next.done = true;
          return next;
        };

        return next.next = next;
      }
    }

    return {
      next: doneResult
    };
  }

  exports.values = values;

  function doneResult() {
    return {
      value: undefined,
      done: true
    };
  }

  Context.prototype = {
    constructor: Context,
    reset: function reset(skipTempReset) {
      this.prev = 0;
      this.next = 0;
      this.sent = this._sent = undefined;
      this.done = false;
      this.delegate = null;
      this.method = "next";
      this.arg = undefined;
      this.tryEntries.forEach(resetTryEntry);

      if (!skipTempReset) {
        for (var name in this) {
          if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
            this[name] = undefined;
          }
        }
      }
    },
    stop: function stop() {
      this.done = true;
      var rootEntry = this.tryEntries[0];
      var rootRecord = rootEntry.completion;

      if (rootRecord.type === "throw") {
        throw rootRecord.arg;
      }

      return this.rval;
    },
    dispatchException: function dispatchException(exception) {
      if (this.done) {
        throw exception;
      }

      var context = this;

      function handle(loc, caught) {
        record.type = "throw";
        record.arg = exception;
        context.next = loc;

        if (caught) {
          context.method = "next";
          context.arg = undefined;
        }

        return !!caught;
      }

      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        var record = entry.completion;

        if (entry.tryLoc === "root") {
          return handle("end");
        }

        if (entry.tryLoc <= this.prev) {
          var hasCatch = hasOwn.call(entry, "catchLoc");
          var hasFinally = hasOwn.call(entry, "finallyLoc");

          if (hasCatch && hasFinally) {
            if (this.prev < entry.catchLoc) {
              return handle(entry.catchLoc, true);
            } else if (this.prev < entry.finallyLoc) {
              return handle(entry.finallyLoc);
            }
          } else if (hasCatch) {
            if (this.prev < entry.catchLoc) {
              return handle(entry.catchLoc, true);
            }
          } else if (hasFinally) {
            if (this.prev < entry.finallyLoc) {
              return handle(entry.finallyLoc);
            }
          } else {
            throw new Error("try statement without catch or finally");
          }
        }
      }
    },
    abrupt: function abrupt(type, arg) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];

        if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
          var finallyEntry = entry;
          break;
        }
      }

      if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
        finallyEntry = null;
      }

      var record = finallyEntry ? finallyEntry.completion : {};
      record.type = type;
      record.arg = arg;

      if (finallyEntry) {
        this.method = "next";
        this.next = finallyEntry.finallyLoc;
        return ContinueSentinel;
      }

      return this.complete(record);
    },
    complete: function complete(record, afterLoc) {
      if (record.type === "throw") {
        throw record.arg;
      }

      if (record.type === "break" || record.type === "continue") {
        this.next = record.arg;
      } else if (record.type === "return") {
        this.rval = this.arg = record.arg;
        this.method = "return";
        this.next = "end";
      } else if (record.type === "normal" && afterLoc) {
        this.next = afterLoc;
      }

      return ContinueSentinel;
    },
    finish: function finish(finallyLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];

        if (entry.finallyLoc === finallyLoc) {
          this.complete(entry.completion, entry.afterLoc);
          resetTryEntry(entry);
          return ContinueSentinel;
        }
      }
    },
    "catch": function _catch(tryLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];

        if (entry.tryLoc === tryLoc) {
          var record = entry.completion;

          if (record.type === "throw") {
            var thrown = record.arg;
            resetTryEntry(entry);
          }

          return thrown;
        }
      }

      throw new Error("illegal catch attempt");
    },
    delegateYield: function delegateYield(iterable, resultName, nextLoc) {
      this.delegate = {
        iterator: values(iterable),
        resultName: resultName,
        nextLoc: nextLoc
      };

      if (this.method === "next") {
        this.arg = undefined;
      }

      return ContinueSentinel;
    }
  };
  return exports;
}(( false ? 0 : _typeof(module)) === "object" ? module.exports : {});

try {
  regeneratorRuntime = runtime;
} catch (accidentalStrictMode) {
  if ((typeof globalThis === "undefined" ? "undefined" : _typeof(globalThis)) === "object") {
    globalThis.regeneratorRuntime = runtime;
  } else {
    Function("r", "regeneratorRuntime = r")(runtime);
  }
}

/***/ }),
/* 4 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.VerbosityLevel = exports.Util = exports.UnknownErrorException = exports.UnexpectedResponseException = exports.UNSUPPORTED_FEATURES = exports.TextRenderingMode = exports.StreamType = exports.RenderingIntentFlag = exports.PermissionFlag = exports.PasswordResponses = exports.PasswordException = exports.PageActionEventType = exports.OPS = exports.MissingPDFException = exports.IsLittleEndianCached = exports.IsEvalSupportedCached = exports.InvalidPDFException = exports.ImageKind = exports.IDENTITY_MATRIX = exports.FormatError = exports.FontType = exports.FONT_IDENTITY_MATRIX = exports.DocumentActionEventType = exports.CMapCompressionType = exports.BaseException = exports.AnnotationType = exports.AnnotationStateModelType = exports.AnnotationReviewState = exports.AnnotationReplyType = exports.AnnotationMode = exports.AnnotationMarkedState = exports.AnnotationFlag = exports.AnnotationFieldFlag = exports.AnnotationBorderStyleType = exports.AnnotationActionEventType = exports.AbortException = void 0;
exports.arrayByteLength = arrayByteLength;
exports.arraysToBytes = arraysToBytes;
exports.assert = assert;
exports.bytesToString = bytesToString;
exports.createPromiseCapability = createPromiseCapability;
exports.createValidAbsoluteUrl = createValidAbsoluteUrl;
exports.escapeString = escapeString;
exports.getModificationDate = getModificationDate;
exports.getVerbosityLevel = getVerbosityLevel;
exports.info = info;
exports.isArrayBuffer = isArrayBuffer;
exports.isArrayEqual = isArrayEqual;
exports.isAscii = isAscii;
exports.isSameOrigin = isSameOrigin;
exports.objectFromMap = objectFromMap;
exports.objectSize = objectSize;
exports.setVerbosityLevel = setVerbosityLevel;
exports.shadow = shadow;
exports.string32 = string32;
exports.stringToBytes = stringToBytes;
exports.stringToPDFString = stringToPDFString;
exports.stringToUTF16BEString = stringToUTF16BEString;
exports.stringToUTF8String = stringToUTF8String;
exports.unreachable = unreachable;
exports.utf8StringToString = utf8StringToString;
exports.warn = warn;

__w_pdfjs_require__(5);

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var IDENTITY_MATRIX = [1, 0, 0, 1, 0, 0];
exports.IDENTITY_MATRIX = IDENTITY_MATRIX;
var FONT_IDENTITY_MATRIX = [0.001, 0, 0, 0.001, 0, 0];
exports.FONT_IDENTITY_MATRIX = FONT_IDENTITY_MATRIX;
var RenderingIntentFlag = {
  ANY: 0x01,
  DISPLAY: 0x02,
  PRINT: 0x04,
  ANNOTATIONS_FORMS: 0x10,
  ANNOTATIONS_STORAGE: 0x20,
  ANNOTATIONS_DISABLE: 0x40,
  OPLIST: 0x100
};
exports.RenderingIntentFlag = RenderingIntentFlag;
var AnnotationMode = {
  DISABLE: 0,
  ENABLE: 1,
  ENABLE_FORMS: 2,
  ENABLE_STORAGE: 3
};
exports.AnnotationMode = AnnotationMode;
var PermissionFlag = {
  PRINT: 0x04,
  MODIFY_CONTENTS: 0x08,
  COPY: 0x10,
  MODIFY_ANNOTATIONS: 0x20,
  FILL_INTERACTIVE_FORMS: 0x100,
  COPY_FOR_ACCESSIBILITY: 0x200,
  ASSEMBLE: 0x400,
  PRINT_HIGH_QUALITY: 0x800
};
exports.PermissionFlag = PermissionFlag;
var TextRenderingMode = {
  FILL: 0,
  STROKE: 1,
  FILL_STROKE: 2,
  INVISIBLE: 3,
  FILL_ADD_TO_PATH: 4,
  STROKE_ADD_TO_PATH: 5,
  FILL_STROKE_ADD_TO_PATH: 6,
  ADD_TO_PATH: 7,
  FILL_STROKE_MASK: 3,
  ADD_TO_PATH_FLAG: 4
};
exports.TextRenderingMode = TextRenderingMode;
var ImageKind = {
  GRAYSCALE_1BPP: 1,
  RGB_24BPP: 2,
  RGBA_32BPP: 3
};
exports.ImageKind = ImageKind;
var AnnotationType = {
  TEXT: 1,
  LINK: 2,
  FREETEXT: 3,
  LINE: 4,
  SQUARE: 5,
  CIRCLE: 6,
  POLYGON: 7,
  POLYLINE: 8,
  HIGHLIGHT: 9,
  UNDERLINE: 10,
  SQUIGGLY: 11,
  STRIKEOUT: 12,
  STAMP: 13,
  CARET: 14,
  INK: 15,
  POPUP: 16,
  FILEATTACHMENT: 17,
  SOUND: 18,
  MOVIE: 19,
  WIDGET: 20,
  SCREEN: 21,
  PRINTERMARK: 22,
  TRAPNET: 23,
  WATERMARK: 24,
  THREED: 25,
  REDACT: 26
};
exports.AnnotationType = AnnotationType;
var AnnotationStateModelType = {
  MARKED: "Marked",
  REVIEW: "Review"
};
exports.AnnotationStateModelType = AnnotationStateModelType;
var AnnotationMarkedState = {
  MARKED: "Marked",
  UNMARKED: "Unmarked"
};
exports.AnnotationMarkedState = AnnotationMarkedState;
var AnnotationReviewState = {
  ACCEPTED: "Accepted",
  REJECTED: "Rejected",
  CANCELLED: "Cancelled",
  COMPLETED: "Completed",
  NONE: "None"
};
exports.AnnotationReviewState = AnnotationReviewState;
var AnnotationReplyType = {
  GROUP: "Group",
  REPLY: "R"
};
exports.AnnotationReplyType = AnnotationReplyType;
var AnnotationFlag = {
  INVISIBLE: 0x01,
  HIDDEN: 0x02,
  PRINT: 0x04,
  NOZOOM: 0x08,
  NOROTATE: 0x10,
  NOVIEW: 0x20,
  READONLY: 0x40,
  LOCKED: 0x80,
  TOGGLENOVIEW: 0x100,
  LOCKEDCONTENTS: 0x200
};
exports.AnnotationFlag = AnnotationFlag;
var AnnotationFieldFlag = {
  READONLY: 0x0000001,
  REQUIRED: 0x0000002,
  NOEXPORT: 0x0000004,
  MULTILINE: 0x0001000,
  PASSWORD: 0x0002000,
  NOTOGGLETOOFF: 0x0004000,
  RADIO: 0x0008000,
  PUSHBUTTON: 0x0010000,
  COMBO: 0x0020000,
  EDIT: 0x0040000,
  SORT: 0x0080000,
  FILESELECT: 0x0100000,
  MULTISELECT: 0x0200000,
  DONOTSPELLCHECK: 0x0400000,
  DONOTSCROLL: 0x0800000,
  COMB: 0x1000000,
  RICHTEXT: 0x2000000,
  RADIOSINUNISON: 0x2000000,
  COMMITONSELCHANGE: 0x4000000
};
exports.AnnotationFieldFlag = AnnotationFieldFlag;
var AnnotationBorderStyleType = {
  SOLID: 1,
  DASHED: 2,
  BEVELED: 3,
  INSET: 4,
  UNDERLINE: 5
};
exports.AnnotationBorderStyleType = AnnotationBorderStyleType;
var AnnotationActionEventType = {
  E: "Mouse Enter",
  X: "Mouse Exit",
  D: "Mouse Down",
  U: "Mouse Up",
  Fo: "Focus",
  Bl: "Blur",
  PO: "PageOpen",
  PC: "PageClose",
  PV: "PageVisible",
  PI: "PageInvisible",
  K: "Keystroke",
  F: "Format",
  V: "Validate",
  C: "Calculate"
};
exports.AnnotationActionEventType = AnnotationActionEventType;
var DocumentActionEventType = {
  WC: "WillClose",
  WS: "WillSave",
  DS: "DidSave",
  WP: "WillPrint",
  DP: "DidPrint"
};
exports.DocumentActionEventType = DocumentActionEventType;
var PageActionEventType = {
  O: "PageOpen",
  C: "PageClose"
};
exports.PageActionEventType = PageActionEventType;
var StreamType = {
  UNKNOWN: "UNKNOWN",
  FLATE: "FLATE",
  LZW: "LZW",
  DCT: "DCT",
  JPX: "JPX",
  JBIG: "JBIG",
  A85: "A85",
  AHX: "AHX",
  CCF: "CCF",
  RLX: "RLX"
};
exports.StreamType = StreamType;
var FontType = {
  UNKNOWN: "UNKNOWN",
  TYPE1: "TYPE1",
  TYPE1STANDARD: "TYPE1STANDARD",
  TYPE1C: "TYPE1C",
  CIDFONTTYPE0: "CIDFONTTYPE0",
  CIDFONTTYPE0C: "CIDFONTTYPE0C",
  TRUETYPE: "TRUETYPE",
  CIDFONTTYPE2: "CIDFONTTYPE2",
  TYPE3: "TYPE3",
  OPENTYPE: "OPENTYPE",
  TYPE0: "TYPE0",
  MMTYPE1: "MMTYPE1"
};
exports.FontType = FontType;
var VerbosityLevel = {
  ERRORS: 0,
  WARNINGS: 1,
  INFOS: 5
};
exports.VerbosityLevel = VerbosityLevel;
var CMapCompressionType = {
  NONE: 0,
  BINARY: 1,
  STREAM: 2
};
exports.CMapCompressionType = CMapCompressionType;
var OPS = {
  dependency: 1,
  setLineWidth: 2,
  setLineCap: 3,
  setLineJoin: 4,
  setMiterLimit: 5,
  setDash: 6,
  setRenderingIntent: 7,
  setFlatness: 8,
  setGState: 9,
  save: 10,
  restore: 11,
  transform: 12,
  moveTo: 13,
  lineTo: 14,
  curveTo: 15,
  curveTo2: 16,
  curveTo3: 17,
  closePath: 18,
  rectangle: 19,
  stroke: 20,
  closeStroke: 21,
  fill: 22,
  eoFill: 23,
  fillStroke: 24,
  eoFillStroke: 25,
  closeFillStroke: 26,
  closeEOFillStroke: 27,
  endPath: 28,
  clip: 29,
  eoClip: 30,
  beginText: 31,
  endText: 32,
  setCharSpacing: 33,
  setWordSpacing: 34,
  setHScale: 35,
  setLeading: 36,
  setFont: 37,
  setTextRenderingMode: 38,
  setTextRise: 39,
  moveText: 40,
  setLeadingMoveText: 41,
  setTextMatrix: 42,
  nextLine: 43,
  showText: 44,
  showSpacedText: 45,
  nextLineShowText: 46,
  nextLineSetSpacingShowText: 47,
  setCharWidth: 48,
  setCharWidthAndBounds: 49,
  setStrokeColorSpace: 50,
  setFillColorSpace: 51,
  setStrokeColor: 52,
  setStrokeColorN: 53,
  setFillColor: 54,
  setFillColorN: 55,
  setStrokeGray: 56,
  setFillGray: 57,
  setStrokeRGBColor: 58,
  setFillRGBColor: 59,
  setStrokeCMYKColor: 60,
  setFillCMYKColor: 61,
  shadingFill: 62,
  beginInlineImage: 63,
  beginImageData: 64,
  endInlineImage: 65,
  paintXObject: 66,
  markPoint: 67,
  markPointProps: 68,
  beginMarkedContent: 69,
  beginMarkedContentProps: 70,
  endMarkedContent: 71,
  beginCompat: 72,
  endCompat: 73,
  paintFormXObjectBegin: 74,
  paintFormXObjectEnd: 75,
  beginGroup: 76,
  endGroup: 77,
  beginAnnotations: 78,
  endAnnotations: 79,
  beginAnnotation: 80,
  endAnnotation: 81,
  paintJpegXObject: 82,
  paintImageMaskXObject: 83,
  paintImageMaskXObjectGroup: 84,
  paintImageXObject: 85,
  paintInlineImageXObject: 86,
  paintInlineImageXObjectGroup: 87,
  paintImageXObjectRepeat: 88,
  paintImageMaskXObjectRepeat: 89,
  paintSolidColorImageMask: 90,
  constructPath: 91
};
exports.OPS = OPS;
var UNSUPPORTED_FEATURES = {
  unknown: "unknown",
  forms: "forms",
  javaScript: "javaScript",
  signatures: "signatures",
  smask: "smask",
  shadingPattern: "shadingPattern",
  font: "font",
  errorTilingPattern: "errorTilingPattern",
  errorExtGState: "errorExtGState",
  errorXObject: "errorXObject",
  errorFontLoadType3: "errorFontLoadType3",
  errorFontState: "errorFontState",
  errorFontMissing: "errorFontMissing",
  errorFontTranslate: "errorFontTranslate",
  errorColorSpace: "errorColorSpace",
  errorOperatorList: "errorOperatorList",
  errorFontToUnicode: "errorFontToUnicode",
  errorFontLoadNative: "errorFontLoadNative",
  errorFontBuildPath: "errorFontBuildPath",
  errorFontGetPath: "errorFontGetPath",
  errorMarkedContent: "errorMarkedContent",
  errorContentSubStream: "errorContentSubStream"
};
exports.UNSUPPORTED_FEATURES = UNSUPPORTED_FEATURES;
var PasswordResponses = {
  NEED_PASSWORD: 1,
  INCORRECT_PASSWORD: 2
};
exports.PasswordResponses = PasswordResponses;
var verbosity = VerbosityLevel.WARNINGS;

function setVerbosityLevel(level) {
  if (Number.isInteger(level)) {
    verbosity = level;
  }
}

function getVerbosityLevel() {
  return verbosity;
}

function info(msg) {
  if (verbosity >= VerbosityLevel.INFOS) {
    console.log("Info: ".concat(msg));
  }
}

function warn(msg) {
  if (verbosity >= VerbosityLevel.WARNINGS) {
    console.log("Warning: ".concat(msg));
  }
}

function unreachable(msg) {
  throw new Error(msg);
}

function assert(cond, msg) {
  if (!cond) {
    unreachable(msg);
  }
}

function isSameOrigin(baseUrl, otherUrl) {
  var base;

  try {
    base = new URL(baseUrl);

    if (!base.origin || base.origin === "null") {
      return false;
    }
  } catch (e) {
    return false;
  }

  var other = new URL(otherUrl, base);
  return base.origin === other.origin;
}

function _isValidProtocol(url) {
  if (!url) {
    return false;
  }

  switch (url.protocol) {
    case "http:":
    case "https:":
    case "ftp:":
    case "mailto:":
    case "tel:":
      return true;

    default:
      return false;
  }
}

function createValidAbsoluteUrl(url) {
  var baseUrl = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

  if (!url) {
    return null;
  }

  try {
    if (options && typeof url === "string") {
      if (options.addDefaultProtocol && url.startsWith("www.")) {
        var dots = url.match(/\./g);

        if (dots && dots.length >= 2) {
          url = "http://".concat(url);
        }
      }

      if (options.tryConvertEncoding) {
        try {
          url = stringToUTF8String(url);
        } catch (ex) {}
      }
    }

    var absoluteUrl = baseUrl ? new URL(url, baseUrl) : new URL(url);

    if (_isValidProtocol(absoluteUrl)) {
      return absoluteUrl;
    }
  } catch (ex) {}

  return null;
}

function shadow(obj, prop, value) {
  Object.defineProperty(obj, prop, {
    value: value,
    enumerable: true,
    configurable: true,
    writable: false
  });
  return value;
}

var BaseException = function BaseExceptionClosure() {
  function BaseException(message, name) {
    if (this.constructor === BaseException) {
      unreachable("Cannot initialize BaseException.");
    }

    this.message = message;
    this.name = name;
  }

  BaseException.prototype = new Error();
  BaseException.constructor = BaseException;
  return BaseException;
}();

exports.BaseException = BaseException;

var PasswordException = /*#__PURE__*/function (_BaseException) {
  _inherits(PasswordException, _BaseException);

  var _super = _createSuper(PasswordException);

  function PasswordException(msg, code) {
    var _this;

    _classCallCheck(this, PasswordException);

    _this = _super.call(this, msg, "PasswordException");
    _this.code = code;
    return _this;
  }

  return _createClass(PasswordException);
}(BaseException);

exports.PasswordException = PasswordException;

var UnknownErrorException = /*#__PURE__*/function (_BaseException2) {
  _inherits(UnknownErrorException, _BaseException2);

  var _super2 = _createSuper(UnknownErrorException);

  function UnknownErrorException(msg, details) {
    var _this2;

    _classCallCheck(this, UnknownErrorException);

    _this2 = _super2.call(this, msg, "UnknownErrorException");
    _this2.details = details;
    return _this2;
  }

  return _createClass(UnknownErrorException);
}(BaseException);

exports.UnknownErrorException = UnknownErrorException;

var InvalidPDFException = /*#__PURE__*/function (_BaseException3) {
  _inherits(InvalidPDFException, _BaseException3);

  var _super3 = _createSuper(InvalidPDFException);

  function InvalidPDFException(msg) {
    _classCallCheck(this, InvalidPDFException);

    return _super3.call(this, msg, "InvalidPDFException");
  }

  return _createClass(InvalidPDFException);
}(BaseException);

exports.InvalidPDFException = InvalidPDFException;

var MissingPDFException = /*#__PURE__*/function (_BaseException4) {
  _inherits(MissingPDFException, _BaseException4);

  var _super4 = _createSuper(MissingPDFException);

  function MissingPDFException(msg) {
    _classCallCheck(this, MissingPDFException);

    return _super4.call(this, msg, "MissingPDFException");
  }

  return _createClass(MissingPDFException);
}(BaseException);

exports.MissingPDFException = MissingPDFException;

var UnexpectedResponseException = /*#__PURE__*/function (_BaseException5) {
  _inherits(UnexpectedResponseException, _BaseException5);

  var _super5 = _createSuper(UnexpectedResponseException);

  function UnexpectedResponseException(msg, status) {
    var _this3;

    _classCallCheck(this, UnexpectedResponseException);

    _this3 = _super5.call(this, msg, "UnexpectedResponseException");
    _this3.status = status;
    return _this3;
  }

  return _createClass(UnexpectedResponseException);
}(BaseException);

exports.UnexpectedResponseException = UnexpectedResponseException;

var FormatError = /*#__PURE__*/function (_BaseException6) {
  _inherits(FormatError, _BaseException6);

  var _super6 = _createSuper(FormatError);

  function FormatError(msg) {
    _classCallCheck(this, FormatError);

    return _super6.call(this, msg, "FormatError");
  }

  return _createClass(FormatError);
}(BaseException);

exports.FormatError = FormatError;

var AbortException = /*#__PURE__*/function (_BaseException7) {
  _inherits(AbortException, _BaseException7);

  var _super7 = _createSuper(AbortException);

  function AbortException(msg) {
    _classCallCheck(this, AbortException);

    return _super7.call(this, msg, "AbortException");
  }

  return _createClass(AbortException);
}(BaseException);

exports.AbortException = AbortException;

function bytesToString(bytes) {
  if (_typeof(bytes) !== "object" || bytes === null || bytes.length === undefined) {
    unreachable("Invalid argument for bytesToString");
  }

  var length = bytes.length;
  var MAX_ARGUMENT_COUNT = 8192;

  if (length < MAX_ARGUMENT_COUNT) {
    return String.fromCharCode.apply(null, bytes);
  }

  var strBuf = [];

  for (var i = 0; i < length; i += MAX_ARGUMENT_COUNT) {
    var chunkEnd = Math.min(i + MAX_ARGUMENT_COUNT, length);
    var chunk = bytes.subarray(i, chunkEnd);
    strBuf.push(String.fromCharCode.apply(null, chunk));
  }

  return strBuf.join("");
}

function stringToBytes(str) {
  if (typeof str !== "string") {
    unreachable("Invalid argument for stringToBytes");
  }

  var length = str.length;
  var bytes = new Uint8Array(length);

  for (var i = 0; i < length; ++i) {
    bytes[i] = str.charCodeAt(i) & 0xff;
  }

  return bytes;
}

function arrayByteLength(arr) {
  if (arr.length !== undefined) {
    return arr.length;
  }

  if (arr.byteLength !== undefined) {
    return arr.byteLength;
  }

  unreachable("Invalid argument for arrayByteLength");
}

function arraysToBytes(arr) {
  var length = arr.length;

  if (length === 1 && arr[0] instanceof Uint8Array) {
    return arr[0];
  }

  var resultLength = 0;

  for (var i = 0; i < length; i++) {
    resultLength += arrayByteLength(arr[i]);
  }

  var pos = 0;
  var data = new Uint8Array(resultLength);

  for (var _i = 0; _i < length; _i++) {
    var item = arr[_i];

    if (!(item instanceof Uint8Array)) {
      if (typeof item === "string") {
        item = stringToBytes(item);
      } else {
        item = new Uint8Array(item);
      }
    }

    var itemLength = item.byteLength;
    data.set(item, pos);
    pos += itemLength;
  }

  return data;
}

function string32(value) {
  return String.fromCharCode(value >> 24 & 0xff, value >> 16 & 0xff, value >> 8 & 0xff, value & 0xff);
}

function objectSize(obj) {
  return Object.keys(obj).length;
}

function objectFromMap(map) {
  var obj = Object.create(null);

  var _iterator = _createForOfIteratorHelper(map),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var _step$value = _slicedToArray(_step.value, 2),
          key = _step$value[0],
          value = _step$value[1];

      obj[key] = value;
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return obj;
}

function isLittleEndian() {
  var buffer8 = new Uint8Array(4);
  buffer8[0] = 1;
  var view32 = new Uint32Array(buffer8.buffer, 0, 1);
  return view32[0] === 1;
}

var IsLittleEndianCached = {
  get value() {
    return shadow(this, "value", isLittleEndian());
  }

};
exports.IsLittleEndianCached = IsLittleEndianCached;

function isEvalSupported() {
  try {
    new Function("");
    return true;
  } catch (e) {
    return false;
  }
}

var IsEvalSupportedCached = {
  get value() {
    return shadow(this, "value", isEvalSupported());
  }

};
exports.IsEvalSupportedCached = IsEvalSupportedCached;

var hexNumbers = _toConsumableArray(Array(256).keys()).map(function (n) {
  return n.toString(16).padStart(2, "0");
});

var Util = /*#__PURE__*/function () {
  function Util() {
    _classCallCheck(this, Util);
  }

  _createClass(Util, null, [{
    key: "makeHexColor",
    value: function makeHexColor(r, g, b) {
      return "#".concat(hexNumbers[r]).concat(hexNumbers[g]).concat(hexNumbers[b]);
    }
  }, {
    key: "transform",
    value: function transform(m1, m2) {
      return [m1[0] * m2[0] + m1[2] * m2[1], m1[1] * m2[0] + m1[3] * m2[1], m1[0] * m2[2] + m1[2] * m2[3], m1[1] * m2[2] + m1[3] * m2[3], m1[0] * m2[4] + m1[2] * m2[5] + m1[4], m1[1] * m2[4] + m1[3] * m2[5] + m1[5]];
    }
  }, {
    key: "applyTransform",
    value: function applyTransform(p, m) {
      var xt = p[0] * m[0] + p[1] * m[2] + m[4];
      var yt = p[0] * m[1] + p[1] * m[3] + m[5];
      return [xt, yt];
    }
  }, {
    key: "applyInverseTransform",
    value: function applyInverseTransform(p, m) {
      var d = m[0] * m[3] - m[1] * m[2];
      var xt = (p[0] * m[3] - p[1] * m[2] + m[2] * m[5] - m[4] * m[3]) / d;
      var yt = (-p[0] * m[1] + p[1] * m[0] + m[4] * m[1] - m[5] * m[0]) / d;
      return [xt, yt];
    }
  }, {
    key: "getAxialAlignedBoundingBox",
    value: function getAxialAlignedBoundingBox(r, m) {
      var p1 = Util.applyTransform(r, m);
      var p2 = Util.applyTransform(r.slice(2, 4), m);
      var p3 = Util.applyTransform([r[0], r[3]], m);
      var p4 = Util.applyTransform([r[2], r[1]], m);
      return [Math.min(p1[0], p2[0], p3[0], p4[0]), Math.min(p1[1], p2[1], p3[1], p4[1]), Math.max(p1[0], p2[0], p3[0], p4[0]), Math.max(p1[1], p2[1], p3[1], p4[1])];
    }
  }, {
    key: "inverseTransform",
    value: function inverseTransform(m) {
      var d = m[0] * m[3] - m[1] * m[2];
      return [m[3] / d, -m[1] / d, -m[2] / d, m[0] / d, (m[2] * m[5] - m[4] * m[3]) / d, (m[4] * m[1] - m[5] * m[0]) / d];
    }
  }, {
    key: "apply3dTransform",
    value: function apply3dTransform(m, v) {
      return [m[0] * v[0] + m[1] * v[1] + m[2] * v[2], m[3] * v[0] + m[4] * v[1] + m[5] * v[2], m[6] * v[0] + m[7] * v[1] + m[8] * v[2]];
    }
  }, {
    key: "singularValueDecompose2dScale",
    value: function singularValueDecompose2dScale(m) {
      var transpose = [m[0], m[2], m[1], m[3]];
      var a = m[0] * transpose[0] + m[1] * transpose[2];
      var b = m[0] * transpose[1] + m[1] * transpose[3];
      var c = m[2] * transpose[0] + m[3] * transpose[2];
      var d = m[2] * transpose[1] + m[3] * transpose[3];
      var first = (a + d) / 2;
      var second = Math.sqrt(Math.pow(a + d, 2) - 4 * (a * d - c * b)) / 2;
      var sx = first + second || 1;
      var sy = first - second || 1;
      return [Math.sqrt(sx), Math.sqrt(sy)];
    }
  }, {
    key: "normalizeRect",
    value: function normalizeRect(rect) {
      var r = rect.slice(0);

      if (rect[0] > rect[2]) {
        r[0] = rect[2];
        r[2] = rect[0];
      }

      if (rect[1] > rect[3]) {
        r[1] = rect[3];
        r[3] = rect[1];
      }

      return r;
    }
  }, {
    key: "intersect",
    value: function intersect(rect1, rect2) {
      function compare(a, b) {
        return a - b;
      }

      var orderedX = [rect1[0], rect1[2], rect2[0], rect2[2]].sort(compare);
      var orderedY = [rect1[1], rect1[3], rect2[1], rect2[3]].sort(compare);
      var result = [];
      rect1 = Util.normalizeRect(rect1);
      rect2 = Util.normalizeRect(rect2);

      if (orderedX[0] === rect1[0] && orderedX[1] === rect2[0] || orderedX[0] === rect2[0] && orderedX[1] === rect1[0]) {
        result[0] = orderedX[1];
        result[2] = orderedX[2];
      } else {
        return null;
      }

      if (orderedY[0] === rect1[1] && orderedY[1] === rect2[1] || orderedY[0] === rect2[1] && orderedY[1] === rect1[1]) {
        result[1] = orderedY[1];
        result[3] = orderedY[2];
      } else {
        return null;
      }

      return result;
    }
  }, {
    key: "bezierBoundingBox",
    value: function bezierBoundingBox(x0, y0, x1, y1, x2, y2, x3, y3) {
      var tvalues = [],
          bounds = [[], []];
      var a, b, c, t, t1, t2, b2ac, sqrtb2ac;

      for (var i = 0; i < 2; ++i) {
        if (i === 0) {
          b = 6 * x0 - 12 * x1 + 6 * x2;
          a = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;
          c = 3 * x1 - 3 * x0;
        } else {
          b = 6 * y0 - 12 * y1 + 6 * y2;
          a = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;
          c = 3 * y1 - 3 * y0;
        }

        if (Math.abs(a) < 1e-12) {
          if (Math.abs(b) < 1e-12) {
            continue;
          }

          t = -c / b;

          if (0 < t && t < 1) {
            tvalues.push(t);
          }

          continue;
        }

        b2ac = b * b - 4 * c * a;
        sqrtb2ac = Math.sqrt(b2ac);

        if (b2ac < 0) {
          continue;
        }

        t1 = (-b + sqrtb2ac) / (2 * a);

        if (0 < t1 && t1 < 1) {
          tvalues.push(t1);
        }

        t2 = (-b - sqrtb2ac) / (2 * a);

        if (0 < t2 && t2 < 1) {
          tvalues.push(t2);
        }
      }

      var j = tvalues.length,
          mt;
      var jlen = j;

      while (j--) {
        t = tvalues[j];
        mt = 1 - t;
        bounds[0][j] = mt * mt * mt * x0 + 3 * mt * mt * t * x1 + 3 * mt * t * t * x2 + t * t * t * x3;
        bounds[1][j] = mt * mt * mt * y0 + 3 * mt * mt * t * y1 + 3 * mt * t * t * y2 + t * t * t * y3;
      }

      bounds[0][jlen] = x0;
      bounds[1][jlen] = y0;
      bounds[0][jlen + 1] = x3;
      bounds[1][jlen + 1] = y3;
      bounds[0].length = bounds[1].length = jlen + 2;
      return [Math.min.apply(Math, _toConsumableArray(bounds[0])), Math.min.apply(Math, _toConsumableArray(bounds[1])), Math.max.apply(Math, _toConsumableArray(bounds[0])), Math.max.apply(Math, _toConsumableArray(bounds[1]))];
    }
  }]);

  return Util;
}();

exports.Util = Util;
var PDFStringTranslateTable = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2d8, 0x2c7, 0x2c6, 0x2d9, 0x2dd, 0x2db, 0x2da, 0x2dc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2022, 0x2020, 0x2021, 0x2026, 0x2014, 0x2013, 0x192, 0x2044, 0x2039, 0x203a, 0x2212, 0x2030, 0x201e, 0x201c, 0x201d, 0x2018, 0x2019, 0x201a, 0x2122, 0xfb01, 0xfb02, 0x141, 0x152, 0x160, 0x178, 0x17d, 0x131, 0x142, 0x153, 0x161, 0x17e, 0, 0x20ac];

function stringToPDFString(str) {
  if (str[0] >= "\xEF") {
    var encoding;

    if (str[0] === "\xFE" && str[1] === "\xFF") {
      encoding = "utf-16be";
    } else if (str[0] === "\xFF" && str[1] === "\xFE") {
      encoding = "utf-16le";
    } else if (str[0] === "\xEF" && str[1] === "\xBB" && str[2] === "\xBF") {
      encoding = "utf-8";
    }

    if (encoding) {
      try {
        var decoder = new TextDecoder(encoding, {
          fatal: true
        });
        var buffer = stringToBytes(str);
        return decoder.decode(buffer);
      } catch (ex) {
        warn("stringToPDFString: \"".concat(ex, "\"."));
      }
    }
  }

  var strBuf = [];

  for (var i = 0, ii = str.length; i < ii; i++) {
    var code = PDFStringTranslateTable[str.charCodeAt(i)];
    strBuf.push(code ? String.fromCharCode(code) : str.charAt(i));
  }

  return strBuf.join("");
}

function escapeString(str) {
  return str.replace(/([()\\\n\r])/g, function (match) {
    if (match === "\n") {
      return "\\n";
    } else if (match === "\r") {
      return "\\r";
    }

    return "\\".concat(match);
  });
}

function isAscii(str) {
  return /^[\x00-\x7F]*$/.test(str);
}

function stringToUTF16BEString(str) {
  var buf = ["\xFE\xFF"];

  for (var i = 0, ii = str.length; i < ii; i++) {
    var _char = str.charCodeAt(i);

    buf.push(String.fromCharCode(_char >> 8 & 0xff), String.fromCharCode(_char & 0xff));
  }

  return buf.join("");
}

function stringToUTF8String(str) {
  return decodeURIComponent(escape(str));
}

function utf8StringToString(str) {
  return unescape(encodeURIComponent(str));
}

function isArrayBuffer(v) {
  return _typeof(v) === "object" && v !== null && v.byteLength !== undefined;
}

function isArrayEqual(arr1, arr2) {
  if (arr1.length !== arr2.length) {
    return false;
  }

  for (var i = 0, ii = arr1.length; i < ii; i++) {
    if (arr1[i] !== arr2[i]) {
      return false;
    }
  }

  return true;
}

function getModificationDate() {
  var date = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Date();
  var buffer = [date.getUTCFullYear().toString(), (date.getUTCMonth() + 1).toString().padStart(2, "0"), date.getUTCDate().toString().padStart(2, "0"), date.getUTCHours().toString().padStart(2, "0"), date.getUTCMinutes().toString().padStart(2, "0"), date.getUTCSeconds().toString().padStart(2, "0")];
  return buffer.join("");
}

function createPromiseCapability() {
  var capability = Object.create(null);
  var isSettled = false;
  Object.defineProperty(capability, "settled", {
    get: function get() {
      return isSettled;
    }
  });
  capability.promise = new Promise(function (resolve, reject) {
    capability.resolve = function (data) {
      isSettled = true;
      resolve(data);
    };

    capability.reject = function (reason) {
      isSettled = true;
      reject(reason);
    };
  });
  return capability;
}

/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";


var _is_node = __w_pdfjs_require__(6);

if (!globalThis._pdfjsCompatibilityChecked) {
  globalThis._pdfjsCompatibilityChecked = true;

  (function checkNodeBtoa() {
    if (globalThis.btoa || !_is_node.isNodeJS) {
      return;
    }

    globalThis.btoa = function (chars) {
      return Buffer.from(chars, "binary").toString("base64");
    };
  })();

  (function checkNodeAtob() {
    if (globalThis.atob || !_is_node.isNodeJS) {
      return;
    }

    globalThis.atob = function (input) {
      return Buffer.from(input, "base64").toString("binary");
    };
  })();

  (function checkDOMMatrix() {
    if (globalThis.DOMMatrix || !_is_node.isNodeJS) {
      return;
    }

    globalThis.DOMMatrix = __w_pdfjs_require__(7);
  })();

  (function checkPromise() {
    if (globalThis.Promise.allSettled) {
      return;
    }

    globalThis.Promise = __w_pdfjs_require__(8);
  })();

  (function checkReadableStream() {
    if (globalThis.ReadableStream || !_is_node.isNodeJS) {
      return;
    }

    globalThis.ReadableStream = require("web-streams-polyfill/dist/ponyfill.js").ReadableStream;
  })();

  (function checkStructuredClone() {
    if (globalThis.structuredClone) {
      return;
    }

    __w_pdfjs_require__(132);
  })();
}

/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isNodeJS = void 0;

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

var isNodeJS = (typeof process === "undefined" ? "undefined" : _typeof(process)) === "object" && process + "" === "[object process]" && !process.versions.nw && !(process.versions.electron && process.type && process.type !== "browser");
exports.isNodeJS = isNodeJS;

/***/ }),
/* 7 */
/***/ ((module, exports, __w_pdfjs_require__) => {

"use strict";
var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

(function (global, factory) {
  ( false ? 0 : _typeof(exports)) === 'object' && "object" !== 'undefined' ? module.exports = factory() :  true ? !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __w_pdfjs_require__, exports, module)) :
		__WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : (0);
})(void 0, function () {
  'use strict';

  function fromArray(array) {
    var m = new CSSMatrix();
    var a = Array.from(array);

    if (!a.every(function (n) {
      return !Number.isNaN(n);
    })) {
      throw TypeError("CSSMatrix: \"" + array + "\" must only have numbers.");
    }

    if (a.length === 16) {
      var m11 = a[0];
      var m12 = a[1];
      var m13 = a[2];
      var m14 = a[3];
      var m21 = a[4];
      var m22 = a[5];
      var m23 = a[6];
      var m24 = a[7];
      var m31 = a[8];
      var m32 = a[9];
      var m33 = a[10];
      var m34 = a[11];
      var m41 = a[12];
      var m42 = a[13];
      var m43 = a[14];
      var m44 = a[15];
      m.m11 = m11;
      m.a = m11;
      m.m21 = m21;
      m.c = m21;
      m.m31 = m31;
      m.m41 = m41;
      m.e = m41;
      m.m12 = m12;
      m.b = m12;
      m.m22 = m22;
      m.d = m22;
      m.m32 = m32;
      m.m42 = m42;
      m.f = m42;
      m.m13 = m13;
      m.m23 = m23;
      m.m33 = m33;
      m.m43 = m43;
      m.m14 = m14;
      m.m24 = m24;
      m.m34 = m34;
      m.m44 = m44;
    } else if (a.length === 6) {
      var M11 = a[0];
      var M12 = a[1];
      var M21 = a[2];
      var M22 = a[3];
      var M41 = a[4];
      var M42 = a[5];
      m.m11 = M11;
      m.a = M11;
      m.m12 = M12;
      m.b = M12;
      m.m21 = M21;
      m.c = M21;
      m.m22 = M22;
      m.d = M22;
      m.m41 = M41;
      m.e = M41;
      m.m42 = M42;
      m.f = M42;
    } else {
      throw new TypeError('CSSMatrix: expecting an Array of 6/16 values.');
    }

    return m;
  }

  function fromMatrix(m) {
    var keys = Object.keys(new CSSMatrix());

    if (_typeof(m) === 'object' && keys.every(function (k) {
      return k in m;
    })) {
      return fromArray([m.m11, m.m12, m.m13, m.m14, m.m21, m.m22, m.m23, m.m24, m.m31, m.m32, m.m33, m.m34, m.m41, m.m42, m.m43, m.m44]);
    }

    throw TypeError("CSSMatrix: \"" + m + "\" is not a DOMMatrix / CSSMatrix / JSON compatible object.");
  }

  function fromString(source) {
    if (typeof source !== 'string') {
      throw TypeError("CSSMatrix: \"" + source + "\" is not a string.");
    }

    var str = String(source).replace(/\s/g, '');
    var m = new CSSMatrix();
    var invalidStringError = "CSSMatrix: invalid transform string \"" + source + "\"";
    str.split(')').filter(function (f) {
      return f;
    }).forEach(function (tf) {
      var ref = tf.split('(');
      var prop = ref[0];
      var value = ref[1];

      if (!value) {
        throw TypeError(invalidStringError);
      }

      var components = value.split(',').map(function (n) {
        return n.includes('rad') ? parseFloat(n) * (180 / Math.PI) : parseFloat(n);
      });
      var x = components[0];
      var y = components[1];
      var z = components[2];
      var a = components[3];
      var xyz = [x, y, z];
      var xyza = [x, y, z, a];

      if (prop === 'perspective' && x && [y, z].every(function (n) {
        return n === undefined;
      })) {
        m.m34 = -1 / x;
      } else if (prop.includes('matrix') && [6, 16].includes(components.length) && components.every(function (n) {
        return !Number.isNaN(+n);
      })) {
        var values = components.map(function (n) {
          return Math.abs(n) < 1e-6 ? 0 : n;
        });
        m = m.multiply(fromArray(values));
      } else if (prop === 'translate3d' && xyz.every(function (n) {
        return !Number.isNaN(+n);
      })) {
        m = m.translate(x, y, z);
      } else if (prop === 'translate' && x && z === undefined) {
        m = m.translate(x, y || 0, 0);
      } else if (prop === 'rotate3d' && xyza.every(function (n) {
        return !Number.isNaN(+n);
      }) && a) {
        m = m.rotateAxisAngle(x, y, z, a);
      } else if (prop === 'rotate' && x && [y, z].every(function (n) {
        return n === undefined;
      })) {
        m = m.rotate(0, 0, x);
      } else if (prop === 'scale3d' && xyz.every(function (n) {
        return !Number.isNaN(+n);
      }) && xyz.some(function (n) {
        return n !== 1;
      })) {
        m = m.scale(x, y, z);
      } else if (prop === 'scale' && !Number.isNaN(x) && x !== 1 && z === undefined) {
        var nosy = Number.isNaN(+y);
        var sy = nosy ? x : y;
        m = m.scale(x, sy, 1);
      } else if (prop === 'skew' && x && z === undefined) {
        m = m.skewX(x);
        m = y ? m.skewY(y) : m;
      } else if (/[XYZ]/.test(prop) && x && [y, z].every(function (n) {
        return n === undefined;
      }) && ['translate', 'rotate', 'scale', 'skew'].some(function (p) {
        return prop.includes(p);
      })) {
        if (['skewX', 'skewY'].includes(prop)) {
          m = m[prop](x);
        } else {
          var fn = prop.replace(/[XYZ]/, '');
          var axis = prop.replace(fn, '');
          var idx = ['X', 'Y', 'Z'].indexOf(axis);
          var axeValues = [idx === 0 ? x : 0, idx === 1 ? x : 0, idx === 2 ? x : 0];
          m = m[fn].apply(m, axeValues);
        }
      } else {
        throw TypeError(invalidStringError);
      }
    });
    return m;
  }

  function Translate(x, y, z) {
    var m = new CSSMatrix();
    m.m41 = x;
    m.e = x;
    m.m42 = y;
    m.f = y;
    m.m43 = z;
    return m;
  }

  function Rotate(rx, ry, rz) {
    var m = new CSSMatrix();
    var degToRad = Math.PI / 180;
    var radX = rx * degToRad;
    var radY = ry * degToRad;
    var radZ = rz * degToRad;
    var cosx = Math.cos(radX);
    var sinx = -Math.sin(radX);
    var cosy = Math.cos(radY);
    var siny = -Math.sin(radY);
    var cosz = Math.cos(radZ);
    var sinz = -Math.sin(radZ);
    var m11 = cosy * cosz;
    var m12 = -cosy * sinz;
    m.m11 = m11;
    m.a = m11;
    m.m12 = m12;
    m.b = m12;
    m.m13 = siny;
    var m21 = sinx * siny * cosz + cosx * sinz;
    m.m21 = m21;
    m.c = m21;
    var m22 = cosx * cosz - sinx * siny * sinz;
    m.m22 = m22;
    m.d = m22;
    m.m23 = -sinx * cosy;
    m.m31 = sinx * sinz - cosx * siny * cosz;
    m.m32 = sinx * cosz + cosx * siny * sinz;
    m.m33 = cosx * cosy;
    return m;
  }

  function RotateAxisAngle(x, y, z, alpha) {
    var m = new CSSMatrix();
    var angle = alpha * (Math.PI / 360);
    var sinA = Math.sin(angle);
    var cosA = Math.cos(angle);
    var sinA2 = sinA * sinA;
    var length = Math.sqrt(x * x + y * y + z * z);
    var X = x;
    var Y = y;
    var Z = z;

    if (length === 0) {
      X = 0;
      Y = 0;
      Z = 1;
    } else {
      X /= length;
      Y /= length;
      Z /= length;
    }

    var x2 = X * X;
    var y2 = Y * Y;
    var z2 = Z * Z;
    var m11 = 1 - 2 * (y2 + z2) * sinA2;
    m.m11 = m11;
    m.a = m11;
    var m12 = 2 * (X * Y * sinA2 + Z * sinA * cosA);
    m.m12 = m12;
    m.b = m12;
    m.m13 = 2 * (X * Z * sinA2 - Y * sinA * cosA);
    var m21 = 2 * (Y * X * sinA2 - Z * sinA * cosA);
    m.m21 = m21;
    m.c = m21;
    var m22 = 1 - 2 * (z2 + x2) * sinA2;
    m.m22 = m22;
    m.d = m22;
    m.m23 = 2 * (Y * Z * sinA2 + X * sinA * cosA);
    m.m31 = 2 * (Z * X * sinA2 + Y * sinA * cosA);
    m.m32 = 2 * (Z * Y * sinA2 - X * sinA * cosA);
    m.m33 = 1 - 2 * (x2 + y2) * sinA2;
    return m;
  }

  function Scale(x, y, z) {
    var m = new CSSMatrix();
    m.m11 = x;
    m.a = x;
    m.m22 = y;
    m.d = y;
    m.m33 = z;
    return m;
  }

  function SkewX(angle) {
    var m = new CSSMatrix();
    var radA = angle * Math.PI / 180;
    var t = Math.tan(radA);
    m.m21 = t;
    m.c = t;
    return m;
  }

  function SkewY(angle) {
    var m = new CSSMatrix();
    var radA = angle * Math.PI / 180;
    var t = Math.tan(radA);
    m.m12 = t;
    m.b = t;
    return m;
  }

  function Multiply(m1, m2) {
    var m11 = m2.m11 * m1.m11 + m2.m12 * m1.m21 + m2.m13 * m1.m31 + m2.m14 * m1.m41;
    var m12 = m2.m11 * m1.m12 + m2.m12 * m1.m22 + m2.m13 * m1.m32 + m2.m14 * m1.m42;
    var m13 = m2.m11 * m1.m13 + m2.m12 * m1.m23 + m2.m13 * m1.m33 + m2.m14 * m1.m43;
    var m14 = m2.m11 * m1.m14 + m2.m12 * m1.m24 + m2.m13 * m1.m34 + m2.m14 * m1.m44;
    var m21 = m2.m21 * m1.m11 + m2.m22 * m1.m21 + m2.m23 * m1.m31 + m2.m24 * m1.m41;
    var m22 = m2.m21 * m1.m12 + m2.m22 * m1.m22 + m2.m23 * m1.m32 + m2.m24 * m1.m42;
    var m23 = m2.m21 * m1.m13 + m2.m22 * m1.m23 + m2.m23 * m1.m33 + m2.m24 * m1.m43;
    var m24 = m2.m21 * m1.m14 + m2.m22 * m1.m24 + m2.m23 * m1.m34 + m2.m24 * m1.m44;
    var m31 = m2.m31 * m1.m11 + m2.m32 * m1.m21 + m2.m33 * m1.m31 + m2.m34 * m1.m41;
    var m32 = m2.m31 * m1.m12 + m2.m32 * m1.m22 + m2.m33 * m1.m32 + m2.m34 * m1.m42;
    var m33 = m2.m31 * m1.m13 + m2.m32 * m1.m23 + m2.m33 * m1.m33 + m2.m34 * m1.m43;
    var m34 = m2.m31 * m1.m14 + m2.m32 * m1.m24 + m2.m33 * m1.m34 + m2.m34 * m1.m44;
    var m41 = m2.m41 * m1.m11 + m2.m42 * m1.m21 + m2.m43 * m1.m31 + m2.m44 * m1.m41;
    var m42 = m2.m41 * m1.m12 + m2.m42 * m1.m22 + m2.m43 * m1.m32 + m2.m44 * m1.m42;
    var m43 = m2.m41 * m1.m13 + m2.m42 * m1.m23 + m2.m43 * m1.m33 + m2.m44 * m1.m43;
    var m44 = m2.m41 * m1.m14 + m2.m42 * m1.m24 + m2.m43 * m1.m34 + m2.m44 * m1.m44;
    return fromArray([m11, m12, m13, m14, m21, m22, m23, m24, m31, m32, m33, m34, m41, m42, m43, m44]);
  }

  var CSSMatrix = function CSSMatrix() {
    var args = [],
        len = arguments.length;

    while (len--) {
      args[len] = arguments[len];
    }

    var m = this;
    m.a = 1;
    m.b = 0;
    m.c = 0;
    m.d = 1;
    m.e = 0;
    m.f = 0;
    m.m11 = 1;
    m.m12 = 0;
    m.m13 = 0;
    m.m14 = 0;
    m.m21 = 0;
    m.m22 = 1;
    m.m23 = 0;
    m.m24 = 0;
    m.m31 = 0;
    m.m32 = 0;
    m.m33 = 1;
    m.m34 = 0;
    m.m41 = 0;
    m.m42 = 0;
    m.m43 = 0;
    m.m44 = 1;

    if (args && args.length) {
      var ARGS = [16, 6].some(function (l) {
        return l === args.length;
      }) ? args : args[0];
      return m.setMatrixValue(ARGS);
    }

    return m;
  };

  var prototypeAccessors = {
    isIdentity: {
      configurable: true
    },
    is2D: {
      configurable: true
    }
  };

  prototypeAccessors.isIdentity.set = function (value) {
    this.isIdentity = value;
  };

  prototypeAccessors.isIdentity.get = function () {
    var m = this;
    return m.m11 === 1 && m.m12 === 0 && m.m13 === 0 && m.m14 === 0 && m.m21 === 0 && m.m22 === 1 && m.m23 === 0 && m.m24 === 0 && m.m31 === 0 && m.m32 === 0 && m.m33 === 1 && m.m34 === 0 && m.m41 === 0 && m.m42 === 0 && m.m43 === 0 && m.m44 === 1;
  };

  prototypeAccessors.is2D.get = function () {
    var m = this;
    return m.m31 === 0 && m.m32 === 0 && m.m33 === 1 && m.m34 === 0 && m.m43 === 0 && m.m44 === 1;
  };

  prototypeAccessors.is2D.set = function (value) {
    this.is2D = value;
  };

  CSSMatrix.prototype.setMatrixValue = function setMatrixValue(source) {
    var m = this;

    if ([Array, Float64Array, Float32Array].some(function (a) {
      return source instanceof a;
    })) {
      return fromArray(source);
    }

    if (typeof source === 'string' && source.length && source !== 'none') {
      return fromString(source);
    }

    if (_typeof(source) === 'object') {
      return fromMatrix(source);
    }

    return m;
  };

  CSSMatrix.prototype.toArray = function toArray() {
    var m = this;
    var pow = Math.pow(10, 6);
    var result;

    if (m.is2D) {
      result = [m.a, m.b, m.c, m.d, m.e, m.f];
    } else {
      result = [m.m11, m.m12, m.m13, m.m14, m.m21, m.m22, m.m23, m.m24, m.m31, m.m32, m.m33, m.m34, m.m41, m.m42, m.m43, m.m44];
    }

    return result.map(function (n) {
      return Math.abs(n) < 1e-6 ? 0 : (n * pow >> 0) / pow;
    });
  };

  CSSMatrix.prototype.toString = function toString() {
    var m = this;
    var values = m.toArray();
    var type = m.is2D ? 'matrix' : 'matrix3d';
    return type + "(" + values + ")";
  };

  CSSMatrix.prototype.toJSON = function toJSON() {
    var m = this;
    var is2D = m.is2D;
    var isIdentity = m.isIdentity;
    return Object.assign({}, m, {
      is2D: is2D,
      isIdentity: isIdentity
    });
  };

  CSSMatrix.prototype.multiply = function multiply(m2) {
    return Multiply(this, m2);
  };

  CSSMatrix.prototype.translate = function translate(x, y, z) {
    var X = x;
    var Y = y;
    var Z = z;

    if (Z === undefined) {
      Z = 0;
    }

    if (Y === undefined) {
      Y = 0;
    }

    return Multiply(this, Translate(X, Y, Z));
  };

  CSSMatrix.prototype.scale = function scale(x, y, z) {
    var X = x;
    var Y = y;
    var Z = z;

    if (Y === undefined) {
      Y = x;
    }

    if (Z === undefined) {
      Z = 1;
    }

    return Multiply(this, Scale(X, Y, Z));
  };

  CSSMatrix.prototype.rotate = function rotate(rx, ry, rz) {
    var RX = rx;
    var RY = ry;
    var RZ = rz;

    if (RY === undefined) {
      RY = 0;
    }

    if (RZ === undefined) {
      RZ = RX;
      RX = 0;
    }

    return Multiply(this, Rotate(RX, RY, RZ));
  };

  CSSMatrix.prototype.rotateAxisAngle = function rotateAxisAngle(x, y, z, angle) {
    if ([x, y, z, angle].some(function (n) {
      return Number.isNaN(n);
    })) {
      throw new TypeError('CSSMatrix: expecting 4 values');
    }

    return Multiply(this, RotateAxisAngle(x, y, z, angle));
  };

  CSSMatrix.prototype.skewX = function skewX(angle) {
    return Multiply(this, SkewX(angle));
  };

  CSSMatrix.prototype.skewY = function skewY(angle) {
    return Multiply(this, SkewY(angle));
  };

  CSSMatrix.prototype.transformPoint = function transformPoint(v) {
    var M = this;
    var m = Translate(v.x, v.y, v.z);
    m.m44 = v.w || 1;
    m = M.multiply(m);
    return {
      x: m.m41,
      y: m.m42,
      z: m.m43,
      w: m.m44
    };
  };

  CSSMatrix.prototype.transform = function transform(t) {
    var m = this;
    var x = m.m11 * t.x + m.m12 * t.y + m.m13 * t.z + m.m14 * t.w;
    var y = m.m21 * t.x + m.m22 * t.y + m.m23 * t.z + m.m24 * t.w;
    var z = m.m31 * t.x + m.m32 * t.y + m.m33 * t.z + m.m34 * t.w;
    var w = m.m41 * t.x + m.m42 * t.y + m.m43 * t.z + m.m44 * t.w;
    return {
      x: x / w,
      y: y / w,
      z: z / w,
      w: w
    };
  };

  Object.defineProperties(CSSMatrix.prototype, prototypeAccessors);
  Object.assign(CSSMatrix, {
    Translate: Translate,
    Rotate: Rotate,
    RotateAxisAngle: RotateAxisAngle,
    Scale: Scale,
    SkewX: SkewX,
    SkewY: SkewY,
    Multiply: Multiply,
    fromArray: fromArray,
    fromMatrix: fromMatrix,
    fromString: fromString
  });
  var version = "0.0.24";
  var Version = version;
  Object.assign(CSSMatrix, {
    Version: Version
  });
  return CSSMatrix;
});

/***/ }),
/* 8 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(9);
__w_pdfjs_require__(94);
__w_pdfjs_require__(100);
__w_pdfjs_require__(102);
__w_pdfjs_require__(126);
__w_pdfjs_require__(127);
__w_pdfjs_require__(128);
__w_pdfjs_require__(129);
var path = __w_pdfjs_require__(131);
module.exports = path.Promise;

/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(10);
var global = __w_pdfjs_require__(11);
var isPrototypeOf = __w_pdfjs_require__(30);
var getPrototypeOf = __w_pdfjs_require__(72);
var setPrototypeOf = __w_pdfjs_require__(74);
var copyConstructorProperties = __w_pdfjs_require__(60);
var create = __w_pdfjs_require__(76);
var createNonEnumerableProperty = __w_pdfjs_require__(49);
var createPropertyDescriptor = __w_pdfjs_require__(18);
var clearErrorStack = __w_pdfjs_require__(80);
var installErrorCause = __w_pdfjs_require__(81);
var iterate = __w_pdfjs_require__(82);
var normalizeStringArgument = __w_pdfjs_require__(91);
var wellKnownSymbol = __w_pdfjs_require__(39);
var ERROR_STACK_INSTALLABLE = __w_pdfjs_require__(93);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var Error = global.Error;
var push = [].push;
var $AggregateError = function AggregateError(errors, message) {
 var options = arguments.length > 2 ? arguments[2] : undefined;
 var isInstance = isPrototypeOf(AggregateErrorPrototype, this);
 var that;
 if (setPrototypeOf) {
  that = setPrototypeOf(new Error(), isInstance ? getPrototypeOf(this) : AggregateErrorPrototype);
 } else {
  that = isInstance ? this : create(AggregateErrorPrototype);
  createNonEnumerableProperty(that, TO_STRING_TAG, 'Error');
 }
 if (message !== undefined)
  createNonEnumerableProperty(that, 'message', normalizeStringArgument(message));
 if (ERROR_STACK_INSTALLABLE)
  createNonEnumerableProperty(that, 'stack', clearErrorStack(that.stack, 1));
 installErrorCause(that, options);
 var errorsArray = [];
 iterate(errors, push, { that: errorsArray });
 createNonEnumerableProperty(that, 'errors', errorsArray);
 return that;
};
if (setPrototypeOf)
 setPrototypeOf($AggregateError, Error);
else
 copyConstructorProperties($AggregateError, Error, { name: true });
var AggregateErrorPrototype = $AggregateError.prototype = create(Error.prototype, {
 constructor: createPropertyDescriptor(1, $AggregateError),
 message: createPropertyDescriptor(1, ''),
 name: createPropertyDescriptor(1, 'AggregateError')
});
$({ global: true }, { AggregateError: $AggregateError });

/***/ }),
/* 10 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var getOwnPropertyDescriptor = (__w_pdfjs_require__(12).f);
var createNonEnumerableProperty = __w_pdfjs_require__(49);
var redefine = __w_pdfjs_require__(53);
var setGlobal = __w_pdfjs_require__(43);
var copyConstructorProperties = __w_pdfjs_require__(60);
var isForced = __w_pdfjs_require__(71);
module.exports = function (options, source) {
 var TARGET = options.target;
 var GLOBAL = options.global;
 var STATIC = options.stat;
 var FORCED, target, key, targetProperty, sourceProperty, descriptor;
 if (GLOBAL) {
  target = global;
 } else if (STATIC) {
  target = global[TARGET] || setGlobal(TARGET, {});
 } else {
  target = (global[TARGET] || {}).prototype;
 }
 if (target)
  for (key in source) {
   sourceProperty = source[key];
   if (options.noTargetGet) {
    descriptor = getOwnPropertyDescriptor(target, key);
    targetProperty = descriptor && descriptor.value;
   } else
    targetProperty = target[key];
   FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
   if (!FORCED && targetProperty !== undefined) {
    if (typeof sourceProperty == typeof targetProperty)
     continue;
    copyConstructorProperties(sourceProperty, targetProperty);
   }
   if (options.sham || targetProperty && targetProperty.sham) {
    createNonEnumerableProperty(sourceProperty, 'sham', true);
   }
   redefine(target, key, sourceProperty, options);
  }
};

/***/ }),
/* 11 */
/***/ ((module) => {

var check = function (it) {
 return it && it.Math == Math && it;
};
module.exports = check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || check(typeof self == 'object' && self) || check(typeof global == 'object' && global) || (function () {
 return this;
}()) || Function('return this')();

/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(13);
var call = __w_pdfjs_require__(15);
var propertyIsEnumerableModule = __w_pdfjs_require__(17);
var createPropertyDescriptor = __w_pdfjs_require__(18);
var toIndexedObject = __w_pdfjs_require__(19);
var toPropertyKey = __w_pdfjs_require__(24);
var hasOwn = __w_pdfjs_require__(44);
var IE8_DOM_DEFINE = __w_pdfjs_require__(47);
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
 O = toIndexedObject(O);
 P = toPropertyKey(P);
 if (IE8_DOM_DEFINE)
  try {
   return $getOwnPropertyDescriptor(O, P);
  } catch (error) {
  }
 if (hasOwn(O, P))
  return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
};

/***/ }),
/* 13 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(14);
module.exports = !fails(function () {
 return Object.defineProperty({}, 1, {
  get: function () {
   return 7;
  }
 })[1] != 7;
});

/***/ }),
/* 14 */
/***/ ((module) => {

module.exports = function (exec) {
 try {
  return !!exec();
 } catch (error) {
  return true;
 }
};

/***/ }),
/* 15 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var NATIVE_BIND = __w_pdfjs_require__(16);
var call = Function.prototype.call;
module.exports = NATIVE_BIND ? call.bind(call) : function () {
 return call.apply(call, arguments);
};

/***/ }),
/* 16 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(14);
module.exports = !fails(function () {
 var test = function () {
 }.bind();
 return typeof test != 'function' || test.hasOwnProperty('prototype');
});

/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

var $propertyIsEnumerable = {}.propertyIsEnumerable;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
 var descriptor = getOwnPropertyDescriptor(this, V);
 return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;

/***/ }),
/* 18 */
/***/ ((module) => {

module.exports = function (bitmap, value) {
 return {
  enumerable: !(bitmap & 1),
  configurable: !(bitmap & 2),
  writable: !(bitmap & 4),
  value: value
 };
};

/***/ }),
/* 19 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var IndexedObject = __w_pdfjs_require__(20);
var requireObjectCoercible = __w_pdfjs_require__(23);
module.exports = function (it) {
 return IndexedObject(requireObjectCoercible(it));
};

/***/ }),
/* 20 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var uncurryThis = __w_pdfjs_require__(21);
var fails = __w_pdfjs_require__(14);
var classof = __w_pdfjs_require__(22);
var Object = global.Object;
var split = uncurryThis(''.split);
module.exports = fails(function () {
 return !Object('z').propertyIsEnumerable(0);
}) ? function (it) {
 return classof(it) == 'String' ? split(it, '') : Object(it);
} : Object;

/***/ }),
/* 21 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var NATIVE_BIND = __w_pdfjs_require__(16);
var FunctionPrototype = Function.prototype;
var bind = FunctionPrototype.bind;
var call = FunctionPrototype.call;
var uncurryThis = NATIVE_BIND && bind.bind(call, call);
module.exports = NATIVE_BIND ? function (fn) {
 return fn && uncurryThis(fn);
} : function (fn) {
 return fn && function () {
  return call.apply(fn, arguments);
 };
};

/***/ }),
/* 22 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var toString = uncurryThis({}.toString);
var stringSlice = uncurryThis(''.slice);
module.exports = function (it) {
 return stringSlice(toString(it), 8, -1);
};

/***/ }),
/* 23 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var TypeError = global.TypeError;
module.exports = function (it) {
 if (it == undefined)
  throw TypeError("Can't call method on " + it);
 return it;
};

/***/ }),
/* 24 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toPrimitive = __w_pdfjs_require__(25);
var isSymbol = __w_pdfjs_require__(28);
module.exports = function (argument) {
 var key = toPrimitive(argument, 'string');
 return isSymbol(key) ? key : key + '';
};

/***/ }),
/* 25 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var call = __w_pdfjs_require__(15);
var isObject = __w_pdfjs_require__(26);
var isSymbol = __w_pdfjs_require__(28);
var getMethod = __w_pdfjs_require__(35);
var ordinaryToPrimitive = __w_pdfjs_require__(38);
var wellKnownSymbol = __w_pdfjs_require__(39);
var TypeError = global.TypeError;
var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
module.exports = function (input, pref) {
 if (!isObject(input) || isSymbol(input))
  return input;
 var exoticToPrim = getMethod(input, TO_PRIMITIVE);
 var result;
 if (exoticToPrim) {
  if (pref === undefined)
   pref = 'default';
  result = call(exoticToPrim, input, pref);
  if (!isObject(result) || isSymbol(result))
   return result;
  throw TypeError("Can't convert object to primitive value");
 }
 if (pref === undefined)
  pref = 'number';
 return ordinaryToPrimitive(input, pref);
};

/***/ }),
/* 26 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var isCallable = __w_pdfjs_require__(27);
module.exports = function (it) {
 return typeof it == 'object' ? it !== null : isCallable(it);
};

/***/ }),
/* 27 */
/***/ ((module) => {

module.exports = function (argument) {
 return typeof argument == 'function';
};

/***/ }),
/* 28 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var getBuiltIn = __w_pdfjs_require__(29);
var isCallable = __w_pdfjs_require__(27);
var isPrototypeOf = __w_pdfjs_require__(30);
var USE_SYMBOL_AS_UID = __w_pdfjs_require__(31);
var Object = global.Object;
module.exports = USE_SYMBOL_AS_UID ? function (it) {
 return typeof it == 'symbol';
} : function (it) {
 var $Symbol = getBuiltIn('Symbol');
 return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, Object(it));
};

/***/ }),
/* 29 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var isCallable = __w_pdfjs_require__(27);
var aFunction = function (argument) {
 return isCallable(argument) ? argument : undefined;
};
module.exports = function (namespace, method) {
 return arguments.length < 2 ? aFunction(global[namespace]) : global[namespace] && global[namespace][method];
};

/***/ }),
/* 30 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
module.exports = uncurryThis({}.isPrototypeOf);

/***/ }),
/* 31 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var NATIVE_SYMBOL = __w_pdfjs_require__(32);
module.exports = NATIVE_SYMBOL && !Symbol.sham && typeof Symbol.iterator == 'symbol';

/***/ }),
/* 32 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var V8_VERSION = __w_pdfjs_require__(33);
var fails = __w_pdfjs_require__(14);
module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
 var symbol = Symbol();
 return !String(symbol) || !(Object(symbol) instanceof Symbol) || !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});

/***/ }),
/* 33 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var userAgent = __w_pdfjs_require__(34);
var process = global.process;
var Deno = global.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;
if (v8) {
 match = v8.split('.');
 version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}
if (!version && userAgent) {
 match = userAgent.match(/Edge\/(\d+)/);
 if (!match || match[1] >= 74) {
  match = userAgent.match(/Chrome\/(\d+)/);
  if (match)
   version = +match[1];
 }
}
module.exports = version;

/***/ }),
/* 34 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var getBuiltIn = __w_pdfjs_require__(29);
module.exports = getBuiltIn('navigator', 'userAgent') || '';

/***/ }),
/* 35 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var aCallable = __w_pdfjs_require__(36);
module.exports = function (V, P) {
 var func = V[P];
 return func == null ? undefined : aCallable(func);
};

/***/ }),
/* 36 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var isCallable = __w_pdfjs_require__(27);
var tryToString = __w_pdfjs_require__(37);
var TypeError = global.TypeError;
module.exports = function (argument) {
 if (isCallable(argument))
  return argument;
 throw TypeError(tryToString(argument) + ' is not a function');
};

/***/ }),
/* 37 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var String = global.String;
module.exports = function (argument) {
 try {
  return String(argument);
 } catch (error) {
  return 'Object';
 }
};

/***/ }),
/* 38 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var call = __w_pdfjs_require__(15);
var isCallable = __w_pdfjs_require__(27);
var isObject = __w_pdfjs_require__(26);
var TypeError = global.TypeError;
module.exports = function (input, pref) {
 var fn, val;
 if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input)))
  return val;
 if (isCallable(fn = input.valueOf) && !isObject(val = call(fn, input)))
  return val;
 if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input)))
  return val;
 throw TypeError("Can't convert object to primitive value");
};

/***/ }),
/* 39 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var shared = __w_pdfjs_require__(40);
var hasOwn = __w_pdfjs_require__(44);
var uid = __w_pdfjs_require__(46);
var NATIVE_SYMBOL = __w_pdfjs_require__(32);
var USE_SYMBOL_AS_UID = __w_pdfjs_require__(31);
var WellKnownSymbolsStore = shared('wks');
var Symbol = global.Symbol;
var symbolFor = Symbol && Symbol['for'];
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol : Symbol && Symbol.withoutSetter || uid;
module.exports = function (name) {
 if (!hasOwn(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == 'string')) {
  var description = 'Symbol.' + name;
  if (NATIVE_SYMBOL && hasOwn(Symbol, name)) {
   WellKnownSymbolsStore[name] = Symbol[name];
  } else if (USE_SYMBOL_AS_UID && symbolFor) {
   WellKnownSymbolsStore[name] = symbolFor(description);
  } else {
   WellKnownSymbolsStore[name] = createWellKnownSymbol(description);
  }
 }
 return WellKnownSymbolsStore[name];
};

/***/ }),
/* 40 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var IS_PURE = __w_pdfjs_require__(41);
var store = __w_pdfjs_require__(42);
(module.exports = function (key, value) {
 return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
 version: '3.21.1',
 mode: IS_PURE ? 'pure' : 'global',
 copyright: '© 2014-2022 Denis Pushkarev (zloirock.ru)',
 license: 'https://github.com/zloirock/core-js/blob/v3.21.1/LICENSE',
 source: 'https://github.com/zloirock/core-js'
});

/***/ }),
/* 41 */
/***/ ((module) => {

module.exports = false;

/***/ }),
/* 42 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var setGlobal = __w_pdfjs_require__(43);
var SHARED = '__core-js_shared__';
var store = global[SHARED] || setGlobal(SHARED, {});
module.exports = store;

/***/ }),
/* 43 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var defineProperty = Object.defineProperty;
module.exports = function (key, value) {
 try {
  defineProperty(global, key, {
   value: value,
   configurable: true,
   writable: true
  });
 } catch (error) {
  global[key] = value;
 }
 return value;
};

/***/ }),
/* 44 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var toObject = __w_pdfjs_require__(45);
var hasOwnProperty = uncurryThis({}.hasOwnProperty);
module.exports = Object.hasOwn || function hasOwn(it, key) {
 return hasOwnProperty(toObject(it), key);
};

/***/ }),
/* 45 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var requireObjectCoercible = __w_pdfjs_require__(23);
var Object = global.Object;
module.exports = function (argument) {
 return Object(requireObjectCoercible(argument));
};

/***/ }),
/* 46 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var id = 0;
var postfix = Math.random();
var toString = uncurryThis(1.0.toString);
module.exports = function (key) {
 return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
};

/***/ }),
/* 47 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(13);
var fails = __w_pdfjs_require__(14);
var createElement = __w_pdfjs_require__(48);
module.exports = !DESCRIPTORS && !fails(function () {
 return Object.defineProperty(createElement('div'), 'a', {
  get: function () {
   return 7;
  }
 }).a != 7;
});

/***/ }),
/* 48 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var isObject = __w_pdfjs_require__(26);
var document = global.document;
var EXISTS = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
 return EXISTS ? document.createElement(it) : {};
};

/***/ }),
/* 49 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(13);
var definePropertyModule = __w_pdfjs_require__(50);
var createPropertyDescriptor = __w_pdfjs_require__(18);
module.exports = DESCRIPTORS ? function (object, key, value) {
 return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
 object[key] = value;
 return object;
};

/***/ }),
/* 50 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var DESCRIPTORS = __w_pdfjs_require__(13);
var IE8_DOM_DEFINE = __w_pdfjs_require__(47);
var V8_PROTOTYPE_DEFINE_BUG = __w_pdfjs_require__(51);
var anObject = __w_pdfjs_require__(52);
var toPropertyKey = __w_pdfjs_require__(24);
var TypeError = global.TypeError;
var $defineProperty = Object.defineProperty;
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE = 'configurable';
var WRITABLE = 'writable';
exports.f = DESCRIPTORS ? V8_PROTOTYPE_DEFINE_BUG ? function defineProperty(O, P, Attributes) {
 anObject(O);
 P = toPropertyKey(P);
 anObject(Attributes);
 if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
  var current = $getOwnPropertyDescriptor(O, P);
  if (current && current[WRITABLE]) {
   O[P] = Attributes.value;
   Attributes = {
    configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
    enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
    writable: false
   };
  }
 }
 return $defineProperty(O, P, Attributes);
} : $defineProperty : function defineProperty(O, P, Attributes) {
 anObject(O);
 P = toPropertyKey(P);
 anObject(Attributes);
 if (IE8_DOM_DEFINE)
  try {
   return $defineProperty(O, P, Attributes);
  } catch (error) {
  }
 if ('get' in Attributes || 'set' in Attributes)
  throw TypeError('Accessors not supported');
 if ('value' in Attributes)
  O[P] = Attributes.value;
 return O;
};

/***/ }),
/* 51 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(13);
var fails = __w_pdfjs_require__(14);
module.exports = DESCRIPTORS && fails(function () {
 return Object.defineProperty(function () {
 }, 'prototype', {
  value: 42,
  writable: false
 }).prototype != 42;
});

/***/ }),
/* 52 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var isObject = __w_pdfjs_require__(26);
var String = global.String;
var TypeError = global.TypeError;
module.exports = function (argument) {
 if (isObject(argument))
  return argument;
 throw TypeError(String(argument) + ' is not an object');
};

/***/ }),
/* 53 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var isCallable = __w_pdfjs_require__(27);
var hasOwn = __w_pdfjs_require__(44);
var createNonEnumerableProperty = __w_pdfjs_require__(49);
var setGlobal = __w_pdfjs_require__(43);
var inspectSource = __w_pdfjs_require__(54);
var InternalStateModule = __w_pdfjs_require__(55);
var CONFIGURABLE_FUNCTION_NAME = (__w_pdfjs_require__(59).CONFIGURABLE);
var getInternalState = InternalStateModule.get;
var enforceInternalState = InternalStateModule.enforce;
var TEMPLATE = String(String).split('String');
(module.exports = function (O, key, value, options) {
 var unsafe = options ? !!options.unsafe : false;
 var simple = options ? !!options.enumerable : false;
 var noTargetGet = options ? !!options.noTargetGet : false;
 var name = options && options.name !== undefined ? options.name : key;
 var state;
 if (isCallable(value)) {
  if (String(name).slice(0, 7) === 'Symbol(') {
   name = '[' + String(name).replace(/^Symbol\(([^)]*)\)/, '$1') + ']';
  }
  if (!hasOwn(value, 'name') || CONFIGURABLE_FUNCTION_NAME && value.name !== name) {
   createNonEnumerableProperty(value, 'name', name);
  }
  state = enforceInternalState(value);
  if (!state.source) {
   state.source = TEMPLATE.join(typeof name == 'string' ? name : '');
  }
 }
 if (O === global) {
  if (simple)
   O[key] = value;
  else
   setGlobal(key, value);
  return;
 } else if (!unsafe) {
  delete O[key];
 } else if (!noTargetGet && O[key]) {
  simple = true;
 }
 if (simple)
  O[key] = value;
 else
  createNonEnumerableProperty(O, key, value);
})(Function.prototype, 'toString', function toString() {
 return isCallable(this) && getInternalState(this).source || inspectSource(this);
});

/***/ }),
/* 54 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var isCallable = __w_pdfjs_require__(27);
var store = __w_pdfjs_require__(42);
var functionToString = uncurryThis(Function.toString);
if (!isCallable(store.inspectSource)) {
 store.inspectSource = function (it) {
  return functionToString(it);
 };
}
module.exports = store.inspectSource;

/***/ }),
/* 55 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var NATIVE_WEAK_MAP = __w_pdfjs_require__(56);
var global = __w_pdfjs_require__(11);
var uncurryThis = __w_pdfjs_require__(21);
var isObject = __w_pdfjs_require__(26);
var createNonEnumerableProperty = __w_pdfjs_require__(49);
var hasOwn = __w_pdfjs_require__(44);
var shared = __w_pdfjs_require__(42);
var sharedKey = __w_pdfjs_require__(57);
var hiddenKeys = __w_pdfjs_require__(58);
var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError = global.TypeError;
var WeakMap = global.WeakMap;
var set, get, has;
var enforce = function (it) {
 return has(it) ? get(it) : set(it, {});
};
var getterFor = function (TYPE) {
 return function (it) {
  var state;
  if (!isObject(it) || (state = get(it)).type !== TYPE) {
   throw TypeError('Incompatible receiver, ' + TYPE + ' required');
  }
  return state;
 };
};
if (NATIVE_WEAK_MAP || shared.state) {
 var store = shared.state || (shared.state = new WeakMap());
 var wmget = uncurryThis(store.get);
 var wmhas = uncurryThis(store.has);
 var wmset = uncurryThis(store.set);
 set = function (it, metadata) {
  if (wmhas(store, it))
   throw new TypeError(OBJECT_ALREADY_INITIALIZED);
  metadata.facade = it;
  wmset(store, it, metadata);
  return metadata;
 };
 get = function (it) {
  return wmget(store, it) || {};
 };
 has = function (it) {
  return wmhas(store, it);
 };
} else {
 var STATE = sharedKey('state');
 hiddenKeys[STATE] = true;
 set = function (it, metadata) {
  if (hasOwn(it, STATE))
   throw new TypeError(OBJECT_ALREADY_INITIALIZED);
  metadata.facade = it;
  createNonEnumerableProperty(it, STATE, metadata);
  return metadata;
 };
 get = function (it) {
  return hasOwn(it, STATE) ? it[STATE] : {};
 };
 has = function (it) {
  return hasOwn(it, STATE);
 };
}
module.exports = {
 set: set,
 get: get,
 has: has,
 enforce: enforce,
 getterFor: getterFor
};

/***/ }),
/* 56 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var isCallable = __w_pdfjs_require__(27);
var inspectSource = __w_pdfjs_require__(54);
var WeakMap = global.WeakMap;
module.exports = isCallable(WeakMap) && /native code/.test(inspectSource(WeakMap));

/***/ }),
/* 57 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var shared = __w_pdfjs_require__(40);
var uid = __w_pdfjs_require__(46);
var keys = shared('keys');
module.exports = function (key) {
 return keys[key] || (keys[key] = uid(key));
};

/***/ }),
/* 58 */
/***/ ((module) => {

module.exports = {};

/***/ }),
/* 59 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(13);
var hasOwn = __w_pdfjs_require__(44);
var FunctionPrototype = Function.prototype;
var getDescriptor = DESCRIPTORS && Object.getOwnPropertyDescriptor;
var EXISTS = hasOwn(FunctionPrototype, 'name');
var PROPER = EXISTS && function something() {
}.name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS || DESCRIPTORS && getDescriptor(FunctionPrototype, 'name').configurable);
module.exports = {
 EXISTS: EXISTS,
 PROPER: PROPER,
 CONFIGURABLE: CONFIGURABLE
};

/***/ }),
/* 60 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var hasOwn = __w_pdfjs_require__(44);
var ownKeys = __w_pdfjs_require__(61);
var getOwnPropertyDescriptorModule = __w_pdfjs_require__(12);
var definePropertyModule = __w_pdfjs_require__(50);
module.exports = function (target, source, exceptions) {
 var keys = ownKeys(source);
 var defineProperty = definePropertyModule.f;
 var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
 for (var i = 0; i < keys.length; i++) {
  var key = keys[i];
  if (!hasOwn(target, key) && !(exceptions && hasOwn(exceptions, key))) {
   defineProperty(target, key, getOwnPropertyDescriptor(source, key));
  }
 }
};

/***/ }),
/* 61 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var getBuiltIn = __w_pdfjs_require__(29);
var uncurryThis = __w_pdfjs_require__(21);
var getOwnPropertyNamesModule = __w_pdfjs_require__(62);
var getOwnPropertySymbolsModule = __w_pdfjs_require__(70);
var anObject = __w_pdfjs_require__(52);
var concat = uncurryThis([].concat);
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
 var keys = getOwnPropertyNamesModule.f(anObject(it));
 var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
 return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
};

/***/ }),
/* 62 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

var internalObjectKeys = __w_pdfjs_require__(63);
var enumBugKeys = __w_pdfjs_require__(69);
var hiddenKeys = enumBugKeys.concat('length', 'prototype');
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
 return internalObjectKeys(O, hiddenKeys);
};

/***/ }),
/* 63 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var hasOwn = __w_pdfjs_require__(44);
var toIndexedObject = __w_pdfjs_require__(19);
var indexOf = (__w_pdfjs_require__(64).indexOf);
var hiddenKeys = __w_pdfjs_require__(58);
var push = uncurryThis([].push);
module.exports = function (object, names) {
 var O = toIndexedObject(object);
 var i = 0;
 var result = [];
 var key;
 for (key in O)
  !hasOwn(hiddenKeys, key) && hasOwn(O, key) && push(result, key);
 while (names.length > i)
  if (hasOwn(O, key = names[i++])) {
   ~indexOf(result, key) || push(result, key);
  }
 return result;
};

/***/ }),
/* 64 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toIndexedObject = __w_pdfjs_require__(19);
var toAbsoluteIndex = __w_pdfjs_require__(65);
var lengthOfArrayLike = __w_pdfjs_require__(67);
var createMethod = function (IS_INCLUDES) {
 return function ($this, el, fromIndex) {
  var O = toIndexedObject($this);
  var length = lengthOfArrayLike(O);
  var index = toAbsoluteIndex(fromIndex, length);
  var value;
  if (IS_INCLUDES && el != el)
   while (length > index) {
    value = O[index++];
    if (value != value)
     return true;
   }
  else
   for (; length > index; index++) {
    if ((IS_INCLUDES || index in O) && O[index] === el)
     return IS_INCLUDES || index || 0;
   }
  return !IS_INCLUDES && -1;
 };
};
module.exports = {
 includes: createMethod(true),
 indexOf: createMethod(false)
};

/***/ }),
/* 65 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toIntegerOrInfinity = __w_pdfjs_require__(66);
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
 var integer = toIntegerOrInfinity(index);
 return integer < 0 ? max(integer + length, 0) : min(integer, length);
};

/***/ }),
/* 66 */
/***/ ((module) => {

var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (argument) {
 var number = +argument;
 return number !== number || number === 0 ? 0 : (number > 0 ? floor : ceil)(number);
};

/***/ }),
/* 67 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toLength = __w_pdfjs_require__(68);
module.exports = function (obj) {
 return toLength(obj.length);
};

/***/ }),
/* 68 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toIntegerOrInfinity = __w_pdfjs_require__(66);
var min = Math.min;
module.exports = function (argument) {
 return argument > 0 ? min(toIntegerOrInfinity(argument), 0x1FFFFFFFFFFFFF) : 0;
};

/***/ }),
/* 69 */
/***/ ((module) => {

module.exports = [
 'constructor',
 'hasOwnProperty',
 'isPrototypeOf',
 'propertyIsEnumerable',
 'toLocaleString',
 'toString',
 'valueOf'
];

/***/ }),
/* 70 */
/***/ ((__unused_webpack_module, exports) => {

exports.f = Object.getOwnPropertySymbols;

/***/ }),
/* 71 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(14);
var isCallable = __w_pdfjs_require__(27);
var replacement = /#|\.prototype\./;
var isForced = function (feature, detection) {
 var value = data[normalize(feature)];
 return value == POLYFILL ? true : value == NATIVE ? false : isCallable(detection) ? fails(detection) : !!detection;
};
var normalize = isForced.normalize = function (string) {
 return String(string).replace(replacement, '.').toLowerCase();
};
var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';
module.exports = isForced;

/***/ }),
/* 72 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var hasOwn = __w_pdfjs_require__(44);
var isCallable = __w_pdfjs_require__(27);
var toObject = __w_pdfjs_require__(45);
var sharedKey = __w_pdfjs_require__(57);
var CORRECT_PROTOTYPE_GETTER = __w_pdfjs_require__(73);
var IE_PROTO = sharedKey('IE_PROTO');
var Object = global.Object;
var ObjectPrototype = Object.prototype;
module.exports = CORRECT_PROTOTYPE_GETTER ? Object.getPrototypeOf : function (O) {
 var object = toObject(O);
 if (hasOwn(object, IE_PROTO))
  return object[IE_PROTO];
 var constructor = object.constructor;
 if (isCallable(constructor) && object instanceof constructor) {
  return constructor.prototype;
 }
 return object instanceof Object ? ObjectPrototype : null;
};

/***/ }),
/* 73 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(14);
module.exports = !fails(function () {
 function F() {
 }
 F.prototype.constructor = null;
 return Object.getPrototypeOf(new F()) !== F.prototype;
});

/***/ }),
/* 74 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var anObject = __w_pdfjs_require__(52);
var aPossiblePrototype = __w_pdfjs_require__(75);
module.exports = Object.setPrototypeOf || ('__proto__' in {} ? (function () {
 var CORRECT_SETTER = false;
 var test = {};
 var setter;
 try {
  setter = uncurryThis(Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set);
  setter(test, []);
  CORRECT_SETTER = test instanceof Array;
 } catch (error) {
 }
 return function setPrototypeOf(O, proto) {
  anObject(O);
  aPossiblePrototype(proto);
  if (CORRECT_SETTER)
   setter(O, proto);
  else
   O.__proto__ = proto;
  return O;
 };
}()) : undefined);

/***/ }),
/* 75 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var isCallable = __w_pdfjs_require__(27);
var String = global.String;
var TypeError = global.TypeError;
module.exports = function (argument) {
 if (typeof argument == 'object' || isCallable(argument))
  return argument;
 throw TypeError("Can't set " + String(argument) + ' as a prototype');
};

/***/ }),
/* 76 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var anObject = __w_pdfjs_require__(52);
var definePropertiesModule = __w_pdfjs_require__(77);
var enumBugKeys = __w_pdfjs_require__(69);
var hiddenKeys = __w_pdfjs_require__(58);
var html = __w_pdfjs_require__(79);
var documentCreateElement = __w_pdfjs_require__(48);
var sharedKey = __w_pdfjs_require__(57);
var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey('IE_PROTO');
var EmptyConstructor = function () {
};
var scriptTag = function (content) {
 return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};
var NullProtoObjectViaActiveX = function (activeXDocument) {
 activeXDocument.write(scriptTag(''));
 activeXDocument.close();
 var temp = activeXDocument.parentWindow.Object;
 activeXDocument = null;
 return temp;
};
var NullProtoObjectViaIFrame = function () {
 var iframe = documentCreateElement('iframe');
 var JS = 'java' + SCRIPT + ':';
 var iframeDocument;
 iframe.style.display = 'none';
 html.appendChild(iframe);
 iframe.src = String(JS);
 iframeDocument = iframe.contentWindow.document;
 iframeDocument.open();
 iframeDocument.write(scriptTag('document.F=Object'));
 iframeDocument.close();
 return iframeDocument.F;
};
var activeXDocument;
var NullProtoObject = function () {
 try {
  activeXDocument = new ActiveXObject('htmlfile');
 } catch (error) {
 }
 NullProtoObject = typeof document != 'undefined' ? document.domain && activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame() : NullProtoObjectViaActiveX(activeXDocument);
 var length = enumBugKeys.length;
 while (length--)
  delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
 return NullProtoObject();
};
hiddenKeys[IE_PROTO] = true;
module.exports = Object.create || function create(O, Properties) {
 var result;
 if (O !== null) {
  EmptyConstructor[PROTOTYPE] = anObject(O);
  result = new EmptyConstructor();
  EmptyConstructor[PROTOTYPE] = null;
  result[IE_PROTO] = O;
 } else
  result = NullProtoObject();
 return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
};

/***/ }),
/* 77 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(13);
var V8_PROTOTYPE_DEFINE_BUG = __w_pdfjs_require__(51);
var definePropertyModule = __w_pdfjs_require__(50);
var anObject = __w_pdfjs_require__(52);
var toIndexedObject = __w_pdfjs_require__(19);
var objectKeys = __w_pdfjs_require__(78);
exports.f = DESCRIPTORS && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
 anObject(O);
 var props = toIndexedObject(Properties);
 var keys = objectKeys(Properties);
 var length = keys.length;
 var index = 0;
 var key;
 while (length > index)
  definePropertyModule.f(O, key = keys[index++], props[key]);
 return O;
};

/***/ }),
/* 78 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var internalObjectKeys = __w_pdfjs_require__(63);
var enumBugKeys = __w_pdfjs_require__(69);
module.exports = Object.keys || function keys(O) {
 return internalObjectKeys(O, enumBugKeys);
};

/***/ }),
/* 79 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var getBuiltIn = __w_pdfjs_require__(29);
module.exports = getBuiltIn('document', 'documentElement');

/***/ }),
/* 80 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var replace = uncurryThis(''.replace);
var TEST = function (arg) {
 return String(Error(arg).stack);
}('zxcasd');
var V8_OR_CHAKRA_STACK_ENTRY = /\n\s*at [^:]*:[^\n]*/;
var IS_V8_OR_CHAKRA_STACK = V8_OR_CHAKRA_STACK_ENTRY.test(TEST);
module.exports = function (stack, dropEntries) {
 if (IS_V8_OR_CHAKRA_STACK && typeof stack == 'string') {
  while (dropEntries--)
   stack = replace(stack, V8_OR_CHAKRA_STACK_ENTRY, '');
 }
 return stack;
};

/***/ }),
/* 81 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var isObject = __w_pdfjs_require__(26);
var createNonEnumerableProperty = __w_pdfjs_require__(49);
module.exports = function (O, options) {
 if (isObject(options) && 'cause' in options) {
  createNonEnumerableProperty(O, 'cause', options.cause);
 }
};

/***/ }),
/* 82 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var bind = __w_pdfjs_require__(83);
var call = __w_pdfjs_require__(15);
var anObject = __w_pdfjs_require__(52);
var tryToString = __w_pdfjs_require__(37);
var isArrayIteratorMethod = __w_pdfjs_require__(84);
var lengthOfArrayLike = __w_pdfjs_require__(67);
var isPrototypeOf = __w_pdfjs_require__(30);
var getIterator = __w_pdfjs_require__(86);
var getIteratorMethod = __w_pdfjs_require__(87);
var iteratorClose = __w_pdfjs_require__(90);
var TypeError = global.TypeError;
var Result = function (stopped, result) {
 this.stopped = stopped;
 this.result = result;
};
var ResultPrototype = Result.prototype;
module.exports = function (iterable, unboundFunction, options) {
 var that = options && options.that;
 var AS_ENTRIES = !!(options && options.AS_ENTRIES);
 var IS_ITERATOR = !!(options && options.IS_ITERATOR);
 var INTERRUPTED = !!(options && options.INTERRUPTED);
 var fn = bind(unboundFunction, that);
 var iterator, iterFn, index, length, result, next, step;
 var stop = function (condition) {
  if (iterator)
   iteratorClose(iterator, 'normal', condition);
  return new Result(true, condition);
 };
 var callFn = function (value) {
  if (AS_ENTRIES) {
   anObject(value);
   return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
  }
  return INTERRUPTED ? fn(value, stop) : fn(value);
 };
 if (IS_ITERATOR) {
  iterator = iterable;
 } else {
  iterFn = getIteratorMethod(iterable);
  if (!iterFn)
   throw TypeError(tryToString(iterable) + ' is not iterable');
  if (isArrayIteratorMethod(iterFn)) {
   for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
    result = callFn(iterable[index]);
    if (result && isPrototypeOf(ResultPrototype, result))
     return result;
   }
   return new Result(false);
  }
  iterator = getIterator(iterable, iterFn);
 }
 next = iterator.next;
 while (!(step = call(next, iterator)).done) {
  try {
   result = callFn(step.value);
  } catch (error) {
   iteratorClose(iterator, 'throw', error);
  }
  if (typeof result == 'object' && result && isPrototypeOf(ResultPrototype, result))
   return result;
 }
 return new Result(false);
};

/***/ }),
/* 83 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var aCallable = __w_pdfjs_require__(36);
var NATIVE_BIND = __w_pdfjs_require__(16);
var bind = uncurryThis(uncurryThis.bind);
module.exports = function (fn, that) {
 aCallable(fn);
 return that === undefined ? fn : NATIVE_BIND ? bind(fn, that) : function () {
  return fn.apply(that, arguments);
 };
};

/***/ }),
/* 84 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var wellKnownSymbol = __w_pdfjs_require__(39);
var Iterators = __w_pdfjs_require__(85);
var ITERATOR = wellKnownSymbol('iterator');
var ArrayPrototype = Array.prototype;
module.exports = function (it) {
 return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
};

/***/ }),
/* 85 */
/***/ ((module) => {

module.exports = {};

/***/ }),
/* 86 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var call = __w_pdfjs_require__(15);
var aCallable = __w_pdfjs_require__(36);
var anObject = __w_pdfjs_require__(52);
var tryToString = __w_pdfjs_require__(37);
var getIteratorMethod = __w_pdfjs_require__(87);
var TypeError = global.TypeError;
module.exports = function (argument, usingIterator) {
 var iteratorMethod = arguments.length < 2 ? getIteratorMethod(argument) : usingIterator;
 if (aCallable(iteratorMethod))
  return anObject(call(iteratorMethod, argument));
 throw TypeError(tryToString(argument) + ' is not iterable');
};

/***/ }),
/* 87 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var classof = __w_pdfjs_require__(88);
var getMethod = __w_pdfjs_require__(35);
var Iterators = __w_pdfjs_require__(85);
var wellKnownSymbol = __w_pdfjs_require__(39);
var ITERATOR = wellKnownSymbol('iterator');
module.exports = function (it) {
 if (it != undefined)
  return getMethod(it, ITERATOR) || getMethod(it, '@@iterator') || Iterators[classof(it)];
};

/***/ }),
/* 88 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(89);
var isCallable = __w_pdfjs_require__(27);
var classofRaw = __w_pdfjs_require__(22);
var wellKnownSymbol = __w_pdfjs_require__(39);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var Object = global.Object;
var CORRECT_ARGUMENTS = classofRaw((function () {
 return arguments;
}())) == 'Arguments';
var tryGet = function (it, key) {
 try {
  return it[key];
 } catch (error) {
 }
};
module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
 var O, tag, result;
 return it === undefined ? 'Undefined' : it === null ? 'Null' : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG)) == 'string' ? tag : CORRECT_ARGUMENTS ? classofRaw(O) : (result = classofRaw(O)) == 'Object' && isCallable(O.callee) ? 'Arguments' : result;
};

/***/ }),
/* 89 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var wellKnownSymbol = __w_pdfjs_require__(39);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var test = {};
test[TO_STRING_TAG] = 'z';
module.exports = String(test) === '[object z]';

/***/ }),
/* 90 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var call = __w_pdfjs_require__(15);
var anObject = __w_pdfjs_require__(52);
var getMethod = __w_pdfjs_require__(35);
module.exports = function (iterator, kind, value) {
 var innerResult, innerError;
 anObject(iterator);
 try {
  innerResult = getMethod(iterator, 'return');
  if (!innerResult) {
   if (kind === 'throw')
    throw value;
   return value;
  }
  innerResult = call(innerResult, iterator);
 } catch (error) {
  innerError = true;
  innerResult = error;
 }
 if (kind === 'throw')
  throw value;
 if (innerError)
  throw innerResult;
 anObject(innerResult);
 return value;
};

/***/ }),
/* 91 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toString = __w_pdfjs_require__(92);
module.exports = function (argument, $default) {
 return argument === undefined ? arguments.length < 2 ? '' : $default : toString(argument);
};

/***/ }),
/* 92 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var classof = __w_pdfjs_require__(88);
var String = global.String;
module.exports = function (argument) {
 if (classof(argument) === 'Symbol')
  throw TypeError('Cannot convert a Symbol value to a string');
 return String(argument);
};

/***/ }),
/* 93 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(14);
var createPropertyDescriptor = __w_pdfjs_require__(18);
module.exports = !fails(function () {
 var error = Error('a');
 if (!('stack' in error))
  return true;
 Object.defineProperty(error, 'stack', createPropertyDescriptor(1, 7));
 return error.stack !== 7;
});

/***/ }),
/* 94 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var toIndexedObject = __w_pdfjs_require__(19);
var addToUnscopables = __w_pdfjs_require__(95);
var Iterators = __w_pdfjs_require__(85);
var InternalStateModule = __w_pdfjs_require__(55);
var defineProperty = (__w_pdfjs_require__(50).f);
var defineIterator = __w_pdfjs_require__(96);
var IS_PURE = __w_pdfjs_require__(41);
var DESCRIPTORS = __w_pdfjs_require__(13);
var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);
module.exports = defineIterator(Array, 'Array', function (iterated, kind) {
 setInternalState(this, {
  type: ARRAY_ITERATOR,
  target: toIndexedObject(iterated),
  index: 0,
  kind: kind
 });
}, function () {
 var state = getInternalState(this);
 var target = state.target;
 var kind = state.kind;
 var index = state.index++;
 if (!target || index >= target.length) {
  state.target = undefined;
  return {
   value: undefined,
   done: true
  };
 }
 if (kind == 'keys')
  return {
   value: index,
   done: false
  };
 if (kind == 'values')
  return {
   value: target[index],
   done: false
  };
 return {
  value: [
   index,
   target[index]
  ],
  done: false
 };
}, 'values');
var values = Iterators.Arguments = Iterators.Array;
addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');
if (!IS_PURE && DESCRIPTORS && values.name !== 'values')
 try {
  defineProperty(values, 'name', { value: 'values' });
 } catch (error) {
 }

/***/ }),
/* 95 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var wellKnownSymbol = __w_pdfjs_require__(39);
var create = __w_pdfjs_require__(76);
var definePropertyModule = __w_pdfjs_require__(50);
var UNSCOPABLES = wellKnownSymbol('unscopables');
var ArrayPrototype = Array.prototype;
if (ArrayPrototype[UNSCOPABLES] == undefined) {
 definePropertyModule.f(ArrayPrototype, UNSCOPABLES, {
  configurable: true,
  value: create(null)
 });
}
module.exports = function (key) {
 ArrayPrototype[UNSCOPABLES][key] = true;
};

/***/ }),
/* 96 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(10);
var call = __w_pdfjs_require__(15);
var IS_PURE = __w_pdfjs_require__(41);
var FunctionName = __w_pdfjs_require__(59);
var isCallable = __w_pdfjs_require__(27);
var createIteratorConstructor = __w_pdfjs_require__(97);
var getPrototypeOf = __w_pdfjs_require__(72);
var setPrototypeOf = __w_pdfjs_require__(74);
var setToStringTag = __w_pdfjs_require__(99);
var createNonEnumerableProperty = __w_pdfjs_require__(49);
var redefine = __w_pdfjs_require__(53);
var wellKnownSymbol = __w_pdfjs_require__(39);
var Iterators = __w_pdfjs_require__(85);
var IteratorsCore = __w_pdfjs_require__(98);
var PROPER_FUNCTION_NAME = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR = wellKnownSymbol('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';
var returnThis = function () {
 return this;
};
module.exports = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
 createIteratorConstructor(IteratorConstructor, NAME, next);
 var getIterationMethod = function (KIND) {
  if (KIND === DEFAULT && defaultIterator)
   return defaultIterator;
  if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype)
   return IterablePrototype[KIND];
  switch (KIND) {
  case KEYS:
   return function keys() {
    return new IteratorConstructor(this, KIND);
   };
  case VALUES:
   return function values() {
    return new IteratorConstructor(this, KIND);
   };
  case ENTRIES:
   return function entries() {
    return new IteratorConstructor(this, KIND);
   };
  }
  return function () {
   return new IteratorConstructor(this);
  };
 };
 var TO_STRING_TAG = NAME + ' Iterator';
 var INCORRECT_VALUES_NAME = false;
 var IterablePrototype = Iterable.prototype;
 var nativeIterator = IterablePrototype[ITERATOR] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
 var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
 var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
 var CurrentIteratorPrototype, methods, KEY;
 if (anyNativeIterator) {
  CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
  if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
   if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
    if (setPrototypeOf) {
     setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
    } else if (!isCallable(CurrentIteratorPrototype[ITERATOR])) {
     redefine(CurrentIteratorPrototype, ITERATOR, returnThis);
    }
   }
   setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
   if (IS_PURE)
    Iterators[TO_STRING_TAG] = returnThis;
  }
 }
 if (PROPER_FUNCTION_NAME && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
  if (!IS_PURE && CONFIGURABLE_FUNCTION_NAME) {
   createNonEnumerableProperty(IterablePrototype, 'name', VALUES);
  } else {
   INCORRECT_VALUES_NAME = true;
   defaultIterator = function values() {
    return call(nativeIterator, this);
   };
  }
 }
 if (DEFAULT) {
  methods = {
   values: getIterationMethod(VALUES),
   keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
   entries: getIterationMethod(ENTRIES)
  };
  if (FORCED)
   for (KEY in methods) {
    if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
     redefine(IterablePrototype, KEY, methods[KEY]);
    }
   }
  else
   $({
    target: NAME,
    proto: true,
    forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME
   }, methods);
 }
 if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
  redefine(IterablePrototype, ITERATOR, defaultIterator, { name: DEFAULT });
 }
 Iterators[NAME] = defaultIterator;
 return methods;
};

/***/ }),
/* 97 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var IteratorPrototype = (__w_pdfjs_require__(98).IteratorPrototype);
var create = __w_pdfjs_require__(76);
var createPropertyDescriptor = __w_pdfjs_require__(18);
var setToStringTag = __w_pdfjs_require__(99);
var Iterators = __w_pdfjs_require__(85);
var returnThis = function () {
 return this;
};
module.exports = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
 var TO_STRING_TAG = NAME + ' Iterator';
 IteratorConstructor.prototype = create(IteratorPrototype, { next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next) });
 setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
 Iterators[TO_STRING_TAG] = returnThis;
 return IteratorConstructor;
};

/***/ }),
/* 98 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var fails = __w_pdfjs_require__(14);
var isCallable = __w_pdfjs_require__(27);
var create = __w_pdfjs_require__(76);
var getPrototypeOf = __w_pdfjs_require__(72);
var redefine = __w_pdfjs_require__(53);
var wellKnownSymbol = __w_pdfjs_require__(39);
var IS_PURE = __w_pdfjs_require__(41);
var ITERATOR = wellKnownSymbol('iterator');
var BUGGY_SAFARI_ITERATORS = false;
var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;
if ([].keys) {
 arrayIterator = [].keys();
 if (!('next' in arrayIterator))
  BUGGY_SAFARI_ITERATORS = true;
 else {
  PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
  if (PrototypeOfArrayIteratorPrototype !== Object.prototype)
   IteratorPrototype = PrototypeOfArrayIteratorPrototype;
 }
}
var NEW_ITERATOR_PROTOTYPE = IteratorPrototype == undefined || fails(function () {
 var test = {};
 return IteratorPrototype[ITERATOR].call(test) !== test;
});
if (NEW_ITERATOR_PROTOTYPE)
 IteratorPrototype = {};
else if (IS_PURE)
 IteratorPrototype = create(IteratorPrototype);
if (!isCallable(IteratorPrototype[ITERATOR])) {
 redefine(IteratorPrototype, ITERATOR, function () {
  return this;
 });
}
module.exports = {
 IteratorPrototype: IteratorPrototype,
 BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
};

/***/ }),
/* 99 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var defineProperty = (__w_pdfjs_require__(50).f);
var hasOwn = __w_pdfjs_require__(44);
var wellKnownSymbol = __w_pdfjs_require__(39);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
module.exports = function (target, TAG, STATIC) {
 if (target && !STATIC)
  target = target.prototype;
 if (target && !hasOwn(target, TO_STRING_TAG)) {
  defineProperty(target, TO_STRING_TAG, {
   configurable: true,
   value: TAG
  });
 }
};

/***/ }),
/* 100 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(89);
var redefine = __w_pdfjs_require__(53);
var toString = __w_pdfjs_require__(101);
if (!TO_STRING_TAG_SUPPORT) {
 redefine(Object.prototype, 'toString', toString, { unsafe: true });
}

/***/ }),
/* 101 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(89);
var classof = __w_pdfjs_require__(88);
module.exports = TO_STRING_TAG_SUPPORT ? {}.toString : function toString() {
 return '[object ' + classof(this) + ']';
};

/***/ }),
/* 102 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(10);
var IS_PURE = __w_pdfjs_require__(41);
var global = __w_pdfjs_require__(11);
var getBuiltIn = __w_pdfjs_require__(29);
var call = __w_pdfjs_require__(15);
var NativePromise = __w_pdfjs_require__(103);
var redefine = __w_pdfjs_require__(53);
var redefineAll = __w_pdfjs_require__(104);
var setPrototypeOf = __w_pdfjs_require__(74);
var setToStringTag = __w_pdfjs_require__(99);
var setSpecies = __w_pdfjs_require__(105);
var aCallable = __w_pdfjs_require__(36);
var isCallable = __w_pdfjs_require__(27);
var isObject = __w_pdfjs_require__(26);
var anInstance = __w_pdfjs_require__(106);
var inspectSource = __w_pdfjs_require__(54);
var iterate = __w_pdfjs_require__(82);
var checkCorrectnessOfIteration = __w_pdfjs_require__(107);
var speciesConstructor = __w_pdfjs_require__(108);
var task = (__w_pdfjs_require__(111).set);
var microtask = __w_pdfjs_require__(117);
var promiseResolve = __w_pdfjs_require__(120);
var hostReportErrors = __w_pdfjs_require__(122);
var newPromiseCapabilityModule = __w_pdfjs_require__(121);
var perform = __w_pdfjs_require__(123);
var Queue = __w_pdfjs_require__(124);
var InternalStateModule = __w_pdfjs_require__(55);
var isForced = __w_pdfjs_require__(71);
var wellKnownSymbol = __w_pdfjs_require__(39);
var IS_BROWSER = __w_pdfjs_require__(125);
var IS_NODE = __w_pdfjs_require__(116);
var V8_VERSION = __w_pdfjs_require__(33);
var SPECIES = wellKnownSymbol('species');
var PROMISE = 'Promise';
var getInternalState = InternalStateModule.getterFor(PROMISE);
var setInternalState = InternalStateModule.set;
var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
var NativePromisePrototype = NativePromise && NativePromise.prototype;
var PromiseConstructor = NativePromise;
var PromisePrototype = NativePromisePrototype;
var TypeError = global.TypeError;
var document = global.document;
var process = global.process;
var newPromiseCapability = newPromiseCapabilityModule.f;
var newGenericPromiseCapability = newPromiseCapability;
var DISPATCH_EVENT = !!(document && document.createEvent && global.dispatchEvent);
var NATIVE_REJECTION_EVENT = isCallable(global.PromiseRejectionEvent);
var UNHANDLED_REJECTION = 'unhandledrejection';
var REJECTION_HANDLED = 'rejectionhandled';
var PENDING = 0;
var FULFILLED = 1;
var REJECTED = 2;
var HANDLED = 1;
var UNHANDLED = 2;
var SUBCLASSING = false;
var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;
var FORCED = isForced(PROMISE, function () {
 var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(PromiseConstructor);
 var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(PromiseConstructor);
 if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66)
  return true;
 if (IS_PURE && !PromisePrototype['finally'])
  return true;
 if (V8_VERSION >= 51 && /native code/.test(PROMISE_CONSTRUCTOR_SOURCE))
  return false;
 var promise = new PromiseConstructor(function (resolve) {
  resolve(1);
 });
 var FakePromise = function (exec) {
  exec(function () {
  }, function () {
  });
 };
 var constructor = promise.constructor = {};
 constructor[SPECIES] = FakePromise;
 SUBCLASSING = promise.then(function () {
 }) instanceof FakePromise;
 if (!SUBCLASSING)
  return true;
 return !GLOBAL_CORE_JS_PROMISE && IS_BROWSER && !NATIVE_REJECTION_EVENT;
});
var INCORRECT_ITERATION = FORCED || !checkCorrectnessOfIteration(function (iterable) {
 PromiseConstructor.all(iterable)['catch'](function () {
 });
});
var isThenable = function (it) {
 var then;
 return isObject(it) && isCallable(then = it.then) ? then : false;
};
var callReaction = function (reaction, state) {
 var value = state.value;
 var ok = state.state == FULFILLED;
 var handler = ok ? reaction.ok : reaction.fail;
 var resolve = reaction.resolve;
 var reject = reaction.reject;
 var domain = reaction.domain;
 var result, then, exited;
 try {
  if (handler) {
   if (!ok) {
    if (state.rejection === UNHANDLED)
     onHandleUnhandled(state);
    state.rejection = HANDLED;
   }
   if (handler === true)
    result = value;
   else {
    if (domain)
     domain.enter();
    result = handler(value);
    if (domain) {
     domain.exit();
     exited = true;
    }
   }
   if (result === reaction.promise) {
    reject(TypeError('Promise-chain cycle'));
   } else if (then = isThenable(result)) {
    call(then, result, resolve, reject);
   } else
    resolve(result);
  } else
   reject(value);
 } catch (error) {
  if (domain && !exited)
   domain.exit();
  reject(error);
 }
};
var notify = function (state, isReject) {
 if (state.notified)
  return;
 state.notified = true;
 microtask(function () {
  var reactions = state.reactions;
  var reaction;
  while (reaction = reactions.get()) {
   callReaction(reaction, state);
  }
  state.notified = false;
  if (isReject && !state.rejection)
   onUnhandled(state);
 });
};
var dispatchEvent = function (name, promise, reason) {
 var event, handler;
 if (DISPATCH_EVENT) {
  event = document.createEvent('Event');
  event.promise = promise;
  event.reason = reason;
  event.initEvent(name, false, true);
  global.dispatchEvent(event);
 } else
  event = {
   promise: promise,
   reason: reason
  };
 if (!NATIVE_REJECTION_EVENT && (handler = global['on' + name]))
  handler(event);
 else if (name === UNHANDLED_REJECTION)
  hostReportErrors('Unhandled promise rejection', reason);
};
var onUnhandled = function (state) {
 call(task, global, function () {
  var promise = state.facade;
  var value = state.value;
  var IS_UNHANDLED = isUnhandled(state);
  var result;
  if (IS_UNHANDLED) {
   result = perform(function () {
    if (IS_NODE) {
     process.emit('unhandledRejection', value, promise);
    } else
     dispatchEvent(UNHANDLED_REJECTION, promise, value);
   });
   state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
   if (result.error)
    throw result.value;
  }
 });
};
var isUnhandled = function (state) {
 return state.rejection !== HANDLED && !state.parent;
};
var onHandleUnhandled = function (state) {
 call(task, global, function () {
  var promise = state.facade;
  if (IS_NODE) {
   process.emit('rejectionHandled', promise);
  } else
   dispatchEvent(REJECTION_HANDLED, promise, state.value);
 });
};
var bind = function (fn, state, unwrap) {
 return function (value) {
  fn(state, value, unwrap);
 };
};
var internalReject = function (state, value, unwrap) {
 if (state.done)
  return;
 state.done = true;
 if (unwrap)
  state = unwrap;
 state.value = value;
 state.state = REJECTED;
 notify(state, true);
};
var internalResolve = function (state, value, unwrap) {
 if (state.done)
  return;
 state.done = true;
 if (unwrap)
  state = unwrap;
 try {
  if (state.facade === value)
   throw TypeError("Promise can't be resolved itself");
  var then = isThenable(value);
  if (then) {
   microtask(function () {
    var wrapper = { done: false };
    try {
     call(then, value, bind(internalResolve, wrapper, state), bind(internalReject, wrapper, state));
    } catch (error) {
     internalReject(wrapper, error, state);
    }
   });
  } else {
   state.value = value;
   state.state = FULFILLED;
   notify(state, false);
  }
 } catch (error) {
  internalReject({ done: false }, error, state);
 }
};
if (FORCED) {
 PromiseConstructor = function Promise(executor) {
  anInstance(this, PromisePrototype);
  aCallable(executor);
  call(Internal, this);
  var state = getInternalState(this);
  try {
   executor(bind(internalResolve, state), bind(internalReject, state));
  } catch (error) {
   internalReject(state, error);
  }
 };
 PromisePrototype = PromiseConstructor.prototype;
 Internal = function Promise(executor) {
  setInternalState(this, {
   type: PROMISE,
   done: false,
   notified: false,
   parent: false,
   reactions: new Queue(),
   rejection: false,
   state: PENDING,
   value: undefined
  });
 };
 Internal.prototype = redefineAll(PromisePrototype, {
  then: function then(onFulfilled, onRejected) {
   var state = getInternalPromiseState(this);
   var reaction = newPromiseCapability(speciesConstructor(this, PromiseConstructor));
   state.parent = true;
   reaction.ok = isCallable(onFulfilled) ? onFulfilled : true;
   reaction.fail = isCallable(onRejected) && onRejected;
   reaction.domain = IS_NODE ? process.domain : undefined;
   if (state.state == PENDING)
    state.reactions.add(reaction);
   else
    microtask(function () {
     callReaction(reaction, state);
    });
   return reaction.promise;
  },
  'catch': function (onRejected) {
   return this.then(undefined, onRejected);
  }
 });
 OwnPromiseCapability = function () {
  var promise = new Internal();
  var state = getInternalState(promise);
  this.promise = promise;
  this.resolve = bind(internalResolve, state);
  this.reject = bind(internalReject, state);
 };
 newPromiseCapabilityModule.f = newPromiseCapability = function (C) {
  return C === PromiseConstructor || C === PromiseWrapper ? new OwnPromiseCapability(C) : newGenericPromiseCapability(C);
 };
 if (!IS_PURE && isCallable(NativePromise) && NativePromisePrototype !== Object.prototype) {
  nativeThen = NativePromisePrototype.then;
  if (!SUBCLASSING) {
   redefine(NativePromisePrototype, 'then', function then(onFulfilled, onRejected) {
    var that = this;
    return new PromiseConstructor(function (resolve, reject) {
     call(nativeThen, that, resolve, reject);
    }).then(onFulfilled, onRejected);
   }, { unsafe: true });
   redefine(NativePromisePrototype, 'catch', PromisePrototype['catch'], { unsafe: true });
  }
  try {
   delete NativePromisePrototype.constructor;
  } catch (error) {
  }
  if (setPrototypeOf) {
   setPrototypeOf(NativePromisePrototype, PromisePrototype);
  }
 }
}
$({
 global: true,
 wrap: true,
 forced: FORCED
}, { Promise: PromiseConstructor });
setToStringTag(PromiseConstructor, PROMISE, false, true);
setSpecies(PROMISE);
PromiseWrapper = getBuiltIn(PROMISE);
$({
 target: PROMISE,
 stat: true,
 forced: FORCED
}, {
 reject: function reject(r) {
  var capability = newPromiseCapability(this);
  call(capability.reject, undefined, r);
  return capability.promise;
 }
});
$({
 target: PROMISE,
 stat: true,
 forced: IS_PURE || FORCED
}, {
 resolve: function resolve(x) {
  return promiseResolve(IS_PURE && this === PromiseWrapper ? PromiseConstructor : this, x);
 }
});
$({
 target: PROMISE,
 stat: true,
 forced: INCORRECT_ITERATION
}, {
 all: function all(iterable) {
  var C = this;
  var capability = newPromiseCapability(C);
  var resolve = capability.resolve;
  var reject = capability.reject;
  var result = perform(function () {
   var $promiseResolve = aCallable(C.resolve);
   var values = [];
   var counter = 0;
   var remaining = 1;
   iterate(iterable, function (promise) {
    var index = counter++;
    var alreadyCalled = false;
    remaining++;
    call($promiseResolve, C, promise).then(function (value) {
     if (alreadyCalled)
      return;
     alreadyCalled = true;
     values[index] = value;
     --remaining || resolve(values);
    }, reject);
   });
   --remaining || resolve(values);
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 },
 race: function race(iterable) {
  var C = this;
  var capability = newPromiseCapability(C);
  var reject = capability.reject;
  var result = perform(function () {
   var $promiseResolve = aCallable(C.resolve);
   iterate(iterable, function (promise) {
    call($promiseResolve, C, promise).then(capability.resolve, reject);
   });
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 }
});

/***/ }),
/* 103 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
module.exports = global.Promise;

/***/ }),
/* 104 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var redefine = __w_pdfjs_require__(53);
module.exports = function (target, src, options) {
 for (var key in src)
  redefine(target, key, src[key], options);
 return target;
};

/***/ }),
/* 105 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var getBuiltIn = __w_pdfjs_require__(29);
var definePropertyModule = __w_pdfjs_require__(50);
var wellKnownSymbol = __w_pdfjs_require__(39);
var DESCRIPTORS = __w_pdfjs_require__(13);
var SPECIES = wellKnownSymbol('species');
module.exports = function (CONSTRUCTOR_NAME) {
 var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
 var defineProperty = definePropertyModule.f;
 if (DESCRIPTORS && Constructor && !Constructor[SPECIES]) {
  defineProperty(Constructor, SPECIES, {
   configurable: true,
   get: function () {
    return this;
   }
  });
 }
};

/***/ }),
/* 106 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var isPrototypeOf = __w_pdfjs_require__(30);
var TypeError = global.TypeError;
module.exports = function (it, Prototype) {
 if (isPrototypeOf(Prototype, it))
  return it;
 throw TypeError('Incorrect invocation');
};

/***/ }),
/* 107 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var wellKnownSymbol = __w_pdfjs_require__(39);
var ITERATOR = wellKnownSymbol('iterator');
var SAFE_CLOSING = false;
try {
 var called = 0;
 var iteratorWithReturn = {
  next: function () {
   return { done: !!called++ };
  },
  'return': function () {
   SAFE_CLOSING = true;
  }
 };
 iteratorWithReturn[ITERATOR] = function () {
  return this;
 };
 Array.from(iteratorWithReturn, function () {
  throw 2;
 });
} catch (error) {
}
module.exports = function (exec, SKIP_CLOSING) {
 if (!SKIP_CLOSING && !SAFE_CLOSING)
  return false;
 var ITERATION_SUPPORT = false;
 try {
  var object = {};
  object[ITERATOR] = function () {
   return {
    next: function () {
     return { done: ITERATION_SUPPORT = true };
    }
   };
  };
  exec(object);
 } catch (error) {
 }
 return ITERATION_SUPPORT;
};

/***/ }),
/* 108 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var anObject = __w_pdfjs_require__(52);
var aConstructor = __w_pdfjs_require__(109);
var wellKnownSymbol = __w_pdfjs_require__(39);
var SPECIES = wellKnownSymbol('species');
module.exports = function (O, defaultConstructor) {
 var C = anObject(O).constructor;
 var S;
 return C === undefined || (S = anObject(C)[SPECIES]) == undefined ? defaultConstructor : aConstructor(S);
};

/***/ }),
/* 109 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var isConstructor = __w_pdfjs_require__(110);
var tryToString = __w_pdfjs_require__(37);
var TypeError = global.TypeError;
module.exports = function (argument) {
 if (isConstructor(argument))
  return argument;
 throw TypeError(tryToString(argument) + ' is not a constructor');
};

/***/ }),
/* 110 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var fails = __w_pdfjs_require__(14);
var isCallable = __w_pdfjs_require__(27);
var classof = __w_pdfjs_require__(88);
var getBuiltIn = __w_pdfjs_require__(29);
var inspectSource = __w_pdfjs_require__(54);
var noop = function () {
};
var empty = [];
var construct = getBuiltIn('Reflect', 'construct');
var constructorRegExp = /^\s*(?:class|function)\b/;
var exec = uncurryThis(constructorRegExp.exec);
var INCORRECT_TO_STRING = !constructorRegExp.exec(noop);
var isConstructorModern = function isConstructor(argument) {
 if (!isCallable(argument))
  return false;
 try {
  construct(noop, empty, argument);
  return true;
 } catch (error) {
  return false;
 }
};
var isConstructorLegacy = function isConstructor(argument) {
 if (!isCallable(argument))
  return false;
 switch (classof(argument)) {
 case 'AsyncFunction':
 case 'GeneratorFunction':
 case 'AsyncGeneratorFunction':
  return false;
 }
 try {
  return INCORRECT_TO_STRING || !!exec(constructorRegExp, inspectSource(argument));
 } catch (error) {
  return true;
 }
};
isConstructorLegacy.sham = true;
module.exports = !construct || fails(function () {
 var called;
 return isConstructorModern(isConstructorModern.call) || !isConstructorModern(Object) || !isConstructorModern(function () {
  called = true;
 }) || called;
}) ? isConstructorLegacy : isConstructorModern;

/***/ }),
/* 111 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var apply = __w_pdfjs_require__(112);
var bind = __w_pdfjs_require__(83);
var isCallable = __w_pdfjs_require__(27);
var hasOwn = __w_pdfjs_require__(44);
var fails = __w_pdfjs_require__(14);
var html = __w_pdfjs_require__(79);
var arraySlice = __w_pdfjs_require__(113);
var createElement = __w_pdfjs_require__(48);
var validateArgumentsLength = __w_pdfjs_require__(114);
var IS_IOS = __w_pdfjs_require__(115);
var IS_NODE = __w_pdfjs_require__(116);
var set = global.setImmediate;
var clear = global.clearImmediate;
var process = global.process;
var Dispatch = global.Dispatch;
var Function = global.Function;
var MessageChannel = global.MessageChannel;
var String = global.String;
var counter = 0;
var queue = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var location, defer, channel, port;
try {
 location = global.location;
} catch (error) {
}
var run = function (id) {
 if (hasOwn(queue, id)) {
  var fn = queue[id];
  delete queue[id];
  fn();
 }
};
var runner = function (id) {
 return function () {
  run(id);
 };
};
var listener = function (event) {
 run(event.data);
};
var post = function (id) {
 global.postMessage(String(id), location.protocol + '//' + location.host);
};
if (!set || !clear) {
 set = function setImmediate(handler) {
  validateArgumentsLength(arguments.length, 1);
  var fn = isCallable(handler) ? handler : Function(handler);
  var args = arraySlice(arguments, 1);
  queue[++counter] = function () {
   apply(fn, undefined, args);
  };
  defer(counter);
  return counter;
 };
 clear = function clearImmediate(id) {
  delete queue[id];
 };
 if (IS_NODE) {
  defer = function (id) {
   process.nextTick(runner(id));
  };
 } else if (Dispatch && Dispatch.now) {
  defer = function (id) {
   Dispatch.now(runner(id));
  };
 } else if (MessageChannel && !IS_IOS) {
  channel = new MessageChannel();
  port = channel.port2;
  channel.port1.onmessage = listener;
  defer = bind(port.postMessage, port);
 } else if (global.addEventListener && isCallable(global.postMessage) && !global.importScripts && location && location.protocol !== 'file:' && !fails(post)) {
  defer = post;
  global.addEventListener('message', listener, false);
 } else if (ONREADYSTATECHANGE in createElement('script')) {
  defer = function (id) {
   html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
    html.removeChild(this);
    run(id);
   };
  };
 } else {
  defer = function (id) {
   setTimeout(runner(id), 0);
  };
 }
}
module.exports = {
 set: set,
 clear: clear
};

/***/ }),
/* 112 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var NATIVE_BIND = __w_pdfjs_require__(16);
var FunctionPrototype = Function.prototype;
var apply = FunctionPrototype.apply;
var call = FunctionPrototype.call;
module.exports = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND ? call.bind(apply) : function () {
 return call.apply(apply, arguments);
});

/***/ }),
/* 113 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
module.exports = uncurryThis([].slice);

/***/ }),
/* 114 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var TypeError = global.TypeError;
module.exports = function (passed, required) {
 if (passed < required)
  throw TypeError('Not enough arguments');
 return passed;
};

/***/ }),
/* 115 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var userAgent = __w_pdfjs_require__(34);
module.exports = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent);

/***/ }),
/* 116 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var classof = __w_pdfjs_require__(22);
var global = __w_pdfjs_require__(11);
module.exports = classof(global.process) == 'process';

/***/ }),
/* 117 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var bind = __w_pdfjs_require__(83);
var getOwnPropertyDescriptor = (__w_pdfjs_require__(12).f);
var macrotask = (__w_pdfjs_require__(111).set);
var IS_IOS = __w_pdfjs_require__(115);
var IS_IOS_PEBBLE = __w_pdfjs_require__(118);
var IS_WEBOS_WEBKIT = __w_pdfjs_require__(119);
var IS_NODE = __w_pdfjs_require__(116);
var MutationObserver = global.MutationObserver || global.WebKitMutationObserver;
var document = global.document;
var process = global.process;
var Promise = global.Promise;
var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global, 'queueMicrotask');
var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
var flush, head, last, notify, toggle, node, promise, then;
if (!queueMicrotask) {
 flush = function () {
  var parent, fn;
  if (IS_NODE && (parent = process.domain))
   parent.exit();
  while (head) {
   fn = head.fn;
   head = head.next;
   try {
    fn();
   } catch (error) {
    if (head)
     notify();
    else
     last = undefined;
    throw error;
   }
  }
  last = undefined;
  if (parent)
   parent.enter();
 };
 if (!IS_IOS && !IS_NODE && !IS_WEBOS_WEBKIT && MutationObserver && document) {
  toggle = true;
  node = document.createTextNode('');
  new MutationObserver(flush).observe(node, { characterData: true });
  notify = function () {
   node.data = toggle = !toggle;
  };
 } else if (!IS_IOS_PEBBLE && Promise && Promise.resolve) {
  promise = Promise.resolve(undefined);
  promise.constructor = Promise;
  then = bind(promise.then, promise);
  notify = function () {
   then(flush);
  };
 } else if (IS_NODE) {
  notify = function () {
   process.nextTick(flush);
  };
 } else {
  macrotask = bind(macrotask, global);
  notify = function () {
   macrotask(flush);
  };
 }
}
module.exports = queueMicrotask || function (fn) {
 var task = {
  fn: fn,
  next: undefined
 };
 if (last)
  last.next = task;
 if (!head) {
  head = task;
  notify();
 }
 last = task;
};

/***/ }),
/* 118 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var userAgent = __w_pdfjs_require__(34);
var global = __w_pdfjs_require__(11);
module.exports = /ipad|iphone|ipod/i.test(userAgent) && global.Pebble !== undefined;

/***/ }),
/* 119 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var userAgent = __w_pdfjs_require__(34);
module.exports = /web0s(?!.*chrome)/i.test(userAgent);

/***/ }),
/* 120 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var anObject = __w_pdfjs_require__(52);
var isObject = __w_pdfjs_require__(26);
var newPromiseCapability = __w_pdfjs_require__(121);
module.exports = function (C, x) {
 anObject(C);
 if (isObject(x) && x.constructor === C)
  return x;
 var promiseCapability = newPromiseCapability.f(C);
 var resolve = promiseCapability.resolve;
 resolve(x);
 return promiseCapability.promise;
};

/***/ }),
/* 121 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var aCallable = __w_pdfjs_require__(36);
var PromiseCapability = function (C) {
 var resolve, reject;
 this.promise = new C(function ($$resolve, $$reject) {
  if (resolve !== undefined || reject !== undefined)
   throw TypeError('Bad Promise constructor');
  resolve = $$resolve;
  reject = $$reject;
 });
 this.resolve = aCallable(resolve);
 this.reject = aCallable(reject);
};
module.exports.f = function (C) {
 return new PromiseCapability(C);
};

/***/ }),
/* 122 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
module.exports = function (a, b) {
 var console = global.console;
 if (console && console.error) {
  arguments.length == 1 ? console.error(a) : console.error(a, b);
 }
};

/***/ }),
/* 123 */
/***/ ((module) => {

module.exports = function (exec) {
 try {
  return {
   error: false,
   value: exec()
  };
 } catch (error) {
  return {
   error: true,
   value: error
  };
 }
};

/***/ }),
/* 124 */
/***/ ((module) => {

var Queue = function () {
 this.head = null;
 this.tail = null;
};
Queue.prototype = {
 add: function (item) {
  var entry = {
   item: item,
   next: null
  };
  if (this.head)
   this.tail.next = entry;
  else
   this.head = entry;
  this.tail = entry;
 },
 get: function () {
  var entry = this.head;
  if (entry) {
   this.head = entry.next;
   if (this.tail === entry)
    this.tail = null;
   return entry.item;
  }
 }
};
module.exports = Queue;

/***/ }),
/* 125 */
/***/ ((module) => {

module.exports = typeof window == 'object';

/***/ }),
/* 126 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(10);
var call = __w_pdfjs_require__(15);
var aCallable = __w_pdfjs_require__(36);
var newPromiseCapabilityModule = __w_pdfjs_require__(121);
var perform = __w_pdfjs_require__(123);
var iterate = __w_pdfjs_require__(82);
$({
 target: 'Promise',
 stat: true
}, {
 allSettled: function allSettled(iterable) {
  var C = this;
  var capability = newPromiseCapabilityModule.f(C);
  var resolve = capability.resolve;
  var reject = capability.reject;
  var result = perform(function () {
   var promiseResolve = aCallable(C.resolve);
   var values = [];
   var counter = 0;
   var remaining = 1;
   iterate(iterable, function (promise) {
    var index = counter++;
    var alreadyCalled = false;
    remaining++;
    call(promiseResolve, C, promise).then(function (value) {
     if (alreadyCalled)
      return;
     alreadyCalled = true;
     values[index] = {
      status: 'fulfilled',
      value: value
     };
     --remaining || resolve(values);
    }, function (error) {
     if (alreadyCalled)
      return;
     alreadyCalled = true;
     values[index] = {
      status: 'rejected',
      reason: error
     };
     --remaining || resolve(values);
    });
   });
   --remaining || resolve(values);
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 }
});

/***/ }),
/* 127 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(10);
var aCallable = __w_pdfjs_require__(36);
var getBuiltIn = __w_pdfjs_require__(29);
var call = __w_pdfjs_require__(15);
var newPromiseCapabilityModule = __w_pdfjs_require__(121);
var perform = __w_pdfjs_require__(123);
var iterate = __w_pdfjs_require__(82);
var PROMISE_ANY_ERROR = 'No one promise resolved';
$({
 target: 'Promise',
 stat: true
}, {
 any: function any(iterable) {
  var C = this;
  var AggregateError = getBuiltIn('AggregateError');
  var capability = newPromiseCapabilityModule.f(C);
  var resolve = capability.resolve;
  var reject = capability.reject;
  var result = perform(function () {
   var promiseResolve = aCallable(C.resolve);
   var errors = [];
   var counter = 0;
   var remaining = 1;
   var alreadyResolved = false;
   iterate(iterable, function (promise) {
    var index = counter++;
    var alreadyRejected = false;
    remaining++;
    call(promiseResolve, C, promise).then(function (value) {
     if (alreadyRejected || alreadyResolved)
      return;
     alreadyResolved = true;
     resolve(value);
    }, function (error) {
     if (alreadyRejected || alreadyResolved)
      return;
     alreadyRejected = true;
     errors[index] = error;
     --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
    });
   });
   --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 }
});

/***/ }),
/* 128 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(10);
var IS_PURE = __w_pdfjs_require__(41);
var NativePromise = __w_pdfjs_require__(103);
var fails = __w_pdfjs_require__(14);
var getBuiltIn = __w_pdfjs_require__(29);
var isCallable = __w_pdfjs_require__(27);
var speciesConstructor = __w_pdfjs_require__(108);
var promiseResolve = __w_pdfjs_require__(120);
var redefine = __w_pdfjs_require__(53);
var NON_GENERIC = !!NativePromise && fails(function () {
 NativePromise.prototype['finally'].call({
  then: function () {
  }
 }, function () {
 });
});
$({
 target: 'Promise',
 proto: true,
 real: true,
 forced: NON_GENERIC
}, {
 'finally': function (onFinally) {
  var C = speciesConstructor(this, getBuiltIn('Promise'));
  var isFunction = isCallable(onFinally);
  return this.then(isFunction ? function (x) {
   return promiseResolve(C, onFinally()).then(function () {
    return x;
   });
  } : onFinally, isFunction ? function (e) {
   return promiseResolve(C, onFinally()).then(function () {
    throw e;
   });
  } : onFinally);
 }
});
if (!IS_PURE && isCallable(NativePromise)) {
 var method = getBuiltIn('Promise').prototype['finally'];
 if (NativePromise.prototype['finally'] !== method) {
  redefine(NativePromise.prototype, 'finally', method, { unsafe: true });
 }
}

/***/ }),
/* 129 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var charAt = (__w_pdfjs_require__(130).charAt);
var toString = __w_pdfjs_require__(92);
var InternalStateModule = __w_pdfjs_require__(55);
var defineIterator = __w_pdfjs_require__(96);
var STRING_ITERATOR = 'String Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);
defineIterator(String, 'String', function (iterated) {
 setInternalState(this, {
  type: STRING_ITERATOR,
  string: toString(iterated),
  index: 0
 });
}, function next() {
 var state = getInternalState(this);
 var string = state.string;
 var index = state.index;
 var point;
 if (index >= string.length)
  return {
   value: undefined,
   done: true
  };
 point = charAt(string, index);
 state.index += point.length;
 return {
  value: point,
  done: false
 };
});

/***/ }),
/* 130 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var uncurryThis = __w_pdfjs_require__(21);
var toIntegerOrInfinity = __w_pdfjs_require__(66);
var toString = __w_pdfjs_require__(92);
var requireObjectCoercible = __w_pdfjs_require__(23);
var charAt = uncurryThis(''.charAt);
var charCodeAt = uncurryThis(''.charCodeAt);
var stringSlice = uncurryThis(''.slice);
var createMethod = function (CONVERT_TO_STRING) {
 return function ($this, pos) {
  var S = toString(requireObjectCoercible($this));
  var position = toIntegerOrInfinity(pos);
  var size = S.length;
  var first, second;
  if (position < 0 || position >= size)
   return CONVERT_TO_STRING ? '' : undefined;
  first = charCodeAt(S, position);
  return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? charAt(S, position) : first : CONVERT_TO_STRING ? stringSlice(S, position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
 };
};
module.exports = {
 codeAt: createMethod(false),
 charAt: createMethod(true)
};

/***/ }),
/* 131 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
module.exports = global;

/***/ }),
/* 132 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(94);
__w_pdfjs_require__(100);
__w_pdfjs_require__(133);
__w_pdfjs_require__(144);
__w_pdfjs_require__(145);
var path = __w_pdfjs_require__(131);
module.exports = path.structuredClone;

/***/ }),
/* 133 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var collection = __w_pdfjs_require__(134);
var collectionStrong = __w_pdfjs_require__(143);
collection('Map', function (init) {
 return function Map() {
  return init(this, arguments.length ? arguments[0] : undefined);
 };
}, collectionStrong);

/***/ }),
/* 134 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(10);
var global = __w_pdfjs_require__(11);
var uncurryThis = __w_pdfjs_require__(21);
var isForced = __w_pdfjs_require__(71);
var redefine = __w_pdfjs_require__(53);
var InternalMetadataModule = __w_pdfjs_require__(135);
var iterate = __w_pdfjs_require__(82);
var anInstance = __w_pdfjs_require__(106);
var isCallable = __w_pdfjs_require__(27);
var isObject = __w_pdfjs_require__(26);
var fails = __w_pdfjs_require__(14);
var checkCorrectnessOfIteration = __w_pdfjs_require__(107);
var setToStringTag = __w_pdfjs_require__(99);
var inheritIfRequired = __w_pdfjs_require__(142);
module.exports = function (CONSTRUCTOR_NAME, wrapper, common) {
 var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
 var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
 var ADDER = IS_MAP ? 'set' : 'add';
 var NativeConstructor = global[CONSTRUCTOR_NAME];
 var NativePrototype = NativeConstructor && NativeConstructor.prototype;
 var Constructor = NativeConstructor;
 var exported = {};
 var fixMethod = function (KEY) {
  var uncurriedNativeMethod = uncurryThis(NativePrototype[KEY]);
  redefine(NativePrototype, KEY, KEY == 'add' ? function add(value) {
   uncurriedNativeMethod(this, value === 0 ? 0 : value);
   return this;
  } : KEY == 'delete' ? function (key) {
   return IS_WEAK && !isObject(key) ? false : uncurriedNativeMethod(this, key === 0 ? 0 : key);
  } : KEY == 'get' ? function get(key) {
   return IS_WEAK && !isObject(key) ? undefined : uncurriedNativeMethod(this, key === 0 ? 0 : key);
  } : KEY == 'has' ? function has(key) {
   return IS_WEAK && !isObject(key) ? false : uncurriedNativeMethod(this, key === 0 ? 0 : key);
  } : function set(key, value) {
   uncurriedNativeMethod(this, key === 0 ? 0 : key, value);
   return this;
  });
 };
 var REPLACE = isForced(CONSTRUCTOR_NAME, !isCallable(NativeConstructor) || !(IS_WEAK || NativePrototype.forEach && !fails(function () {
  new NativeConstructor().entries().next();
 })));
 if (REPLACE) {
  Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
  InternalMetadataModule.enable();
 } else if (isForced(CONSTRUCTOR_NAME, true)) {
  var instance = new Constructor();
  var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance;
  var THROWS_ON_PRIMITIVES = fails(function () {
   instance.has(1);
  });
  var ACCEPT_ITERABLES = checkCorrectnessOfIteration(function (iterable) {
   new NativeConstructor(iterable);
  });
  var BUGGY_ZERO = !IS_WEAK && fails(function () {
   var $instance = new NativeConstructor();
   var index = 5;
   while (index--)
    $instance[ADDER](index, index);
   return !$instance.has(-0);
  });
  if (!ACCEPT_ITERABLES) {
   Constructor = wrapper(function (dummy, iterable) {
    anInstance(dummy, NativePrototype);
    var that = inheritIfRequired(new NativeConstructor(), dummy, Constructor);
    if (iterable != undefined)
     iterate(iterable, that[ADDER], {
      that: that,
      AS_ENTRIES: IS_MAP
     });
    return that;
   });
   Constructor.prototype = NativePrototype;
   NativePrototype.constructor = Constructor;
  }
  if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
   fixMethod('delete');
   fixMethod('has');
   IS_MAP && fixMethod('get');
  }
  if (BUGGY_ZERO || HASNT_CHAINING)
   fixMethod(ADDER);
  if (IS_WEAK && NativePrototype.clear)
   delete NativePrototype.clear;
 }
 exported[CONSTRUCTOR_NAME] = Constructor;
 $({
  global: true,
  forced: Constructor != NativeConstructor
 }, exported);
 setToStringTag(Constructor, CONSTRUCTOR_NAME);
 if (!IS_WEAK)
  common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
 return Constructor;
};

/***/ }),
/* 135 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var $ = __w_pdfjs_require__(10);
var uncurryThis = __w_pdfjs_require__(21);
var hiddenKeys = __w_pdfjs_require__(58);
var isObject = __w_pdfjs_require__(26);
var hasOwn = __w_pdfjs_require__(44);
var defineProperty = (__w_pdfjs_require__(50).f);
var getOwnPropertyNamesModule = __w_pdfjs_require__(62);
var getOwnPropertyNamesExternalModule = __w_pdfjs_require__(136);
var isExtensible = __w_pdfjs_require__(139);
var uid = __w_pdfjs_require__(46);
var FREEZING = __w_pdfjs_require__(141);
var REQUIRED = false;
var METADATA = uid('meta');
var id = 0;
var setMetadata = function (it) {
 defineProperty(it, METADATA, {
  value: {
   objectID: 'O' + id++,
   weakData: {}
  }
 });
};
var fastKey = function (it, create) {
 if (!isObject(it))
  return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
 if (!hasOwn(it, METADATA)) {
  if (!isExtensible(it))
   return 'F';
  if (!create)
   return 'E';
  setMetadata(it);
 }
 return it[METADATA].objectID;
};
var getWeakData = function (it, create) {
 if (!hasOwn(it, METADATA)) {
  if (!isExtensible(it))
   return true;
  if (!create)
   return false;
  setMetadata(it);
 }
 return it[METADATA].weakData;
};
var onFreeze = function (it) {
 if (FREEZING && REQUIRED && isExtensible(it) && !hasOwn(it, METADATA))
  setMetadata(it);
 return it;
};
var enable = function () {
 meta.enable = function () {
 };
 REQUIRED = true;
 var getOwnPropertyNames = getOwnPropertyNamesModule.f;
 var splice = uncurryThis([].splice);
 var test = {};
 test[METADATA] = 1;
 if (getOwnPropertyNames(test).length) {
  getOwnPropertyNamesModule.f = function (it) {
   var result = getOwnPropertyNames(it);
   for (var i = 0, length = result.length; i < length; i++) {
    if (result[i] === METADATA) {
     splice(result, i, 1);
     break;
    }
   }
   return result;
  };
  $({
   target: 'Object',
   stat: true,
   forced: true
  }, { getOwnPropertyNames: getOwnPropertyNamesExternalModule.f });
 }
};
var meta = module.exports = {
 enable: enable,
 fastKey: fastKey,
 getWeakData: getWeakData,
 onFreeze: onFreeze
};
hiddenKeys[METADATA] = true;

/***/ }),
/* 136 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var classof = __w_pdfjs_require__(22);
var toIndexedObject = __w_pdfjs_require__(19);
var $getOwnPropertyNames = (__w_pdfjs_require__(62).f);
var arraySlice = __w_pdfjs_require__(137);
var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];
var getWindowNames = function (it) {
 try {
  return $getOwnPropertyNames(it);
 } catch (error) {
  return arraySlice(windowNames);
 }
};
module.exports.f = function getOwnPropertyNames(it) {
 return windowNames && classof(it) == 'Window' ? getWindowNames(it) : $getOwnPropertyNames(toIndexedObject(it));
};

/***/ }),
/* 137 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(11);
var toAbsoluteIndex = __w_pdfjs_require__(65);
var lengthOfArrayLike = __w_pdfjs_require__(67);
var createProperty = __w_pdfjs_require__(138);
var Array = global.Array;
var max = Math.max;
module.exports = function (O, start, end) {
 var length = lengthOfArrayLike(O);
 var k = toAbsoluteIndex(start, length);
 var fin = toAbsoluteIndex(end === undefined ? length : end, length);
 var result = Array(max(fin - k, 0));
 for (var n = 0; k < fin; k++, n++)
  createProperty(result, n, O[k]);
 result.length = n;
 return result;
};

/***/ }),
/* 138 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var toPropertyKey = __w_pdfjs_require__(24);
var definePropertyModule = __w_pdfjs_require__(50);
var createPropertyDescriptor = __w_pdfjs_require__(18);
module.exports = function (object, key, value) {
 var propertyKey = toPropertyKey(key);
 if (propertyKey in object)
  definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
 else
  object[propertyKey] = value;
};

/***/ }),
/* 139 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(14);
var isObject = __w_pdfjs_require__(26);
var classof = __w_pdfjs_require__(22);
var ARRAY_BUFFER_NON_EXTENSIBLE = __w_pdfjs_require__(140);
var $isExtensible = Object.isExtensible;
var FAILS_ON_PRIMITIVES = fails(function () {
 $isExtensible(1);
});
module.exports = FAILS_ON_PRIMITIVES || ARRAY_BUFFER_NON_EXTENSIBLE ? function isExtensible(it) {
 if (!isObject(it))
  return false;
 if (ARRAY_BUFFER_NON_EXTENSIBLE && classof(it) == 'ArrayBuffer')
  return false;
 return $isExtensible ? $isExtensible(it) : true;
} : $isExtensible;

/***/ }),
/* 140 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(14);
module.exports = fails(function () {
 if (typeof ArrayBuffer == 'function') {
  var buffer = new ArrayBuffer(8);
  if (Object.isExtensible(buffer))
   Object.defineProperty(buffer, 'a', { value: 8 });
 }
});

/***/ }),
/* 141 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(14);
module.exports = !fails(function () {
 return Object.isExtensible(Object.preventExtensions({}));
});

/***/ }),
/* 142 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var isCallable = __w_pdfjs_require__(27);
var isObject = __w_pdfjs_require__(26);
var setPrototypeOf = __w_pdfjs_require__(74);
module.exports = function ($this, dummy, Wrapper) {
 var NewTarget, NewTargetPrototype;
 if (setPrototypeOf && isCallable(NewTarget = dummy.constructor) && NewTarget !== Wrapper && isObject(NewTargetPrototype = NewTarget.prototype) && NewTargetPrototype !== Wrapper.prototype)
  setPrototypeOf($this, NewTargetPrototype);
 return $this;
};

/***/ }),
/* 143 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var defineProperty = (__w_pdfjs_require__(50).f);
var create = __w_pdfjs_require__(76);
var redefineAll = __w_pdfjs_require__(104);
var bind = __w_pdfjs_require__(83);
var anInstance = __w_pdfjs_require__(106);
var iterate = __w_pdfjs_require__(82);
var defineIterator = __w_pdfjs_require__(96);
var setSpecies = __w_pdfjs_require__(105);
var DESCRIPTORS = __w_pdfjs_require__(13);
var fastKey = (__w_pdfjs_require__(135).fastKey);
var InternalStateModule = __w_pdfjs_require__(55);
var setInternalState = InternalStateModule.set;
var internalStateGetterFor = InternalStateModule.getterFor;
module.exports = {
 getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
  var Constructor = wrapper(function (that, iterable) {
   anInstance(that, Prototype);
   setInternalState(that, {
    type: CONSTRUCTOR_NAME,
    index: create(null),
    first: undefined,
    last: undefined,
    size: 0
   });
   if (!DESCRIPTORS)
    that.size = 0;
   if (iterable != undefined)
    iterate(iterable, that[ADDER], {
     that: that,
     AS_ENTRIES: IS_MAP
    });
  });
  var Prototype = Constructor.prototype;
  var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);
  var define = function (that, key, value) {
   var state = getInternalState(that);
   var entry = getEntry(that, key);
   var previous, index;
   if (entry) {
    entry.value = value;
   } else {
    state.last = entry = {
     index: index = fastKey(key, true),
     key: key,
     value: value,
     previous: previous = state.last,
     next: undefined,
     removed: false
    };
    if (!state.first)
     state.first = entry;
    if (previous)
     previous.next = entry;
    if (DESCRIPTORS)
     state.size++;
    else
     that.size++;
    if (index !== 'F')
     state.index[index] = entry;
   }
   return that;
  };
  var getEntry = function (that, key) {
   var state = getInternalState(that);
   var index = fastKey(key);
   var entry;
   if (index !== 'F')
    return state.index[index];
   for (entry = state.first; entry; entry = entry.next) {
    if (entry.key == key)
     return entry;
   }
  };
  redefineAll(Prototype, {
   clear: function clear() {
    var that = this;
    var state = getInternalState(that);
    var data = state.index;
    var entry = state.first;
    while (entry) {
     entry.removed = true;
     if (entry.previous)
      entry.previous = entry.previous.next = undefined;
     delete data[entry.index];
     entry = entry.next;
    }
    state.first = state.last = undefined;
    if (DESCRIPTORS)
     state.size = 0;
    else
     that.size = 0;
   },
   'delete': function (key) {
    var that = this;
    var state = getInternalState(that);
    var entry = getEntry(that, key);
    if (entry) {
     var next = entry.next;
     var prev = entry.previous;
     delete state.index[entry.index];
     entry.removed = true;
     if (prev)
      prev.next = next;
     if (next)
      next.previous = prev;
     if (state.first == entry)
      state.first = next;
     if (state.last == entry)
      state.last = prev;
     if (DESCRIPTORS)
      state.size--;
     else
      that.size--;
    }
    return !!entry;
   },
   forEach: function forEach(callbackfn) {
    var state = getInternalState(this);
    var boundFunction = bind(callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    var entry;
    while (entry = entry ? entry.next : state.first) {
     boundFunction(entry.value, entry.key, this);
     while (entry && entry.removed)
      entry = entry.previous;
    }
   },
   has: function has(key) {
    return !!getEntry(this, key);
   }
  });
  redefineAll(Prototype, IS_MAP ? {
   get: function get(key) {
    var entry = getEntry(this, key);
    return entry && entry.value;
   },
   set: function set(key, value) {
    return define(this, key === 0 ? 0 : key, value);
   }
  } : {
   add: function add(value) {
    return define(this, value = value === 0 ? 0 : value, value);
   }
  });
  if (DESCRIPTORS)
   defineProperty(Prototype, 'size', {
    get: function () {
     return getInternalState(this).size;
    }
   });
  return Constructor;
 },
 setStrong: function (Constructor, CONSTRUCTOR_NAME, IS_MAP) {
  var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
  var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
  var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME);
  defineIterator(Constructor, CONSTRUCTOR_NAME, function (iterated, kind) {
   setInternalState(this, {
    type: ITERATOR_NAME,
    target: iterated,
    state: getInternalCollectionState(iterated),
    kind: kind,
    last: undefined
   });
  }, function () {
   var state = getInternalIteratorState(this);
   var kind = state.kind;
   var entry = state.last;
   while (entry && entry.removed)
    entry = entry.previous;
   if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
    state.target = undefined;
    return {
     value: undefined,
     done: true
    };
   }
   if (kind == 'keys')
    return {
     value: entry.key,
     done: false
    };
   if (kind == 'values')
    return {
     value: entry.value,
     done: false
    };
   return {
    value: [
     entry.key,
     entry.value
    ],
    done: false
   };
  }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);
  setSpecies(CONSTRUCTOR_NAME);
 }
};

/***/ }),
/* 144 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var collection = __w_pdfjs_require__(134);
var collectionStrong = __w_pdfjs_require__(143);
collection('Set', function (init) {
 return function Set() {
  return init(this, arguments.length ? arguments[0] : undefined);
 };
}, collectionStrong);

/***/ }),
/* 145 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

var IS_PURE = __w_pdfjs_require__(41);
var $ = __w_pdfjs_require__(10);
var global = __w_pdfjs_require__(11);
var getBuiltin = __w_pdfjs_require__(29);
var uncurryThis = __w_pdfjs_require__(21);
var fails = __w_pdfjs_require__(14);
var uid = __w_pdfjs_require__(46);
var isCallable = __w_pdfjs_require__(27);
var isConstructor = __w_pdfjs_require__(110);
var isObject = __w_pdfjs_require__(26);
var isSymbol = __w_pdfjs_require__(28);
var iterate = __w_pdfjs_require__(82);
var anObject = __w_pdfjs_require__(52);
var classof = __w_pdfjs_require__(88);
var hasOwn = __w_pdfjs_require__(44);
var createProperty = __w_pdfjs_require__(138);
var createNonEnumerableProperty = __w_pdfjs_require__(49);
var lengthOfArrayLike = __w_pdfjs_require__(67);
var validateArgumentsLength = __w_pdfjs_require__(114);
var regExpFlags = __w_pdfjs_require__(146);
var ERROR_STACK_INSTALLABLE = __w_pdfjs_require__(93);
var Object = global.Object;
var Date = global.Date;
var Error = global.Error;
var EvalError = global.EvalError;
var RangeError = global.RangeError;
var ReferenceError = global.ReferenceError;
var SyntaxError = global.SyntaxError;
var TypeError = global.TypeError;
var URIError = global.URIError;
var PerformanceMark = global.PerformanceMark;
var WebAssembly = global.WebAssembly;
var CompileError = WebAssembly && WebAssembly.CompileError || Error;
var LinkError = WebAssembly && WebAssembly.LinkError || Error;
var RuntimeError = WebAssembly && WebAssembly.RuntimeError || Error;
var DOMException = getBuiltin('DOMException');
var Set = getBuiltin('Set');
var Map = getBuiltin('Map');
var MapPrototype = Map.prototype;
var mapHas = uncurryThis(MapPrototype.has);
var mapGet = uncurryThis(MapPrototype.get);
var mapSet = uncurryThis(MapPrototype.set);
var setAdd = uncurryThis(Set.prototype.add);
var objectKeys = getBuiltin('Object', 'keys');
var push = uncurryThis([].push);
var booleanValueOf = uncurryThis(true.valueOf);
var numberValueOf = uncurryThis(1.0.valueOf);
var stringValueOf = uncurryThis(''.valueOf);
var getFlags = uncurryThis(regExpFlags);
var getTime = uncurryThis(Date.prototype.getTime);
var PERFORMANCE_MARK = uid('structuredClone');
var DATA_CLONE_ERROR = 'DataCloneError';
var TRANSFERRING = 'Transferring';
var checkBasicSemantic = function (structuredCloneImplementation) {
 return !fails(function () {
  var set1 = new global.Set([7]);
  var set2 = structuredCloneImplementation(set1);
  var number = structuredCloneImplementation(Object(7));
  return set2 == set1 || !set2.has(7) || typeof number != 'object' || number != 7;
 }) && structuredCloneImplementation;
};
var checkNewErrorsSemantic = function (structuredCloneImplementation) {
 return !fails(function () {
  var test = structuredCloneImplementation(new global.AggregateError([1], PERFORMANCE_MARK, { cause: 3 }));
  return test.name != 'AggregateError' || test.errors[0] != 1 || test.message != PERFORMANCE_MARK || test.cause != 3;
 }) && structuredCloneImplementation;
};
var nativeStructuredClone = global.structuredClone;
var FORCED_REPLACEMENT = IS_PURE || !checkNewErrorsSemantic(nativeStructuredClone);
var structuredCloneFromMark = !nativeStructuredClone && checkBasicSemantic(function (value) {
 return new PerformanceMark(PERFORMANCE_MARK, { detail: value }).detail;
});
var nativeRestrictedStructuredClone = checkBasicSemantic(nativeStructuredClone) || structuredCloneFromMark;
var throwUncloneable = function (type) {
 throw new DOMException('Uncloneable type: ' + type, DATA_CLONE_ERROR);
};
var throwUnpolyfillable = function (type, kind) {
 throw new DOMException((kind || 'Cloning') + ' of ' + type + ' cannot be properly polyfilled in this engine', DATA_CLONE_ERROR);
};
var structuredCloneInternal = function (value, map) {
 if (isSymbol(value))
  throwUncloneable('Symbol');
 if (!isObject(value))
  return value;
 if (map) {
  if (mapHas(map, value))
   return mapGet(map, value);
 } else
  map = new Map();
 var type = classof(value);
 var deep = false;
 var C, name, cloned, dataTransfer, i, length, keys, key, source, target;
 switch (type) {
 case 'Array':
  cloned = [];
  deep = true;
  break;
 case 'Object':
  cloned = {};
  deep = true;
  break;
 case 'Map':
  cloned = new Map();
  deep = true;
  break;
 case 'Set':
  cloned = new Set();
  deep = true;
  break;
 case 'RegExp':
  cloned = new RegExp(value.source, 'flags' in value ? value.flags : getFlags(value));
  break;
 case 'Error':
  name = value.name;
  switch (name) {
  case 'AggregateError':
   cloned = getBuiltin('AggregateError')([]);
   break;
  case 'EvalError':
   cloned = EvalError();
   break;
  case 'RangeError':
   cloned = RangeError();
   break;
  case 'ReferenceError':
   cloned = ReferenceError();
   break;
  case 'SyntaxError':
   cloned = SyntaxError();
   break;
  case 'TypeError':
   cloned = TypeError();
   break;
  case 'URIError':
   cloned = URIError();
   break;
  case 'CompileError':
   cloned = CompileError();
   break;
  case 'LinkError':
   cloned = LinkError();
   break;
  case 'RuntimeError':
   cloned = RuntimeError();
   break;
  default:
   cloned = Error();
  }
  deep = true;
  break;
 case 'DOMException':
  cloned = new DOMException(value.message, value.name);
  deep = true;
  break;
 case 'DataView':
 case 'Int8Array':
 case 'Uint8Array':
 case 'Uint8ClampedArray':
 case 'Int16Array':
 case 'Uint16Array':
 case 'Int32Array':
 case 'Uint32Array':
 case 'Float32Array':
 case 'Float64Array':
 case 'BigInt64Array':
 case 'BigUint64Array':
  C = global[type];
  if (!isObject(C))
   throwUnpolyfillable(type);
  cloned = new C(structuredCloneInternal(value.buffer, map), value.byteOffset, type === 'DataView' ? value.byteLength : value.length);
  break;
 case 'DOMQuad':
  try {
   cloned = new DOMQuad(structuredCloneInternal(value.p1, map), structuredCloneInternal(value.p2, map), structuredCloneInternal(value.p3, map), structuredCloneInternal(value.p4, map));
  } catch (error) {
   if (nativeRestrictedStructuredClone) {
    cloned = nativeRestrictedStructuredClone(value);
   } else
    throwUnpolyfillable(type);
  }
  break;
 case 'FileList':
  C = global.DataTransfer;
  if (isConstructor(C)) {
   dataTransfer = new C();
   for (i = 0, length = lengthOfArrayLike(value); i < length; i++) {
    dataTransfer.items.add(structuredCloneInternal(value[i], map));
   }
   cloned = dataTransfer.files;
  } else if (nativeRestrictedStructuredClone) {
   cloned = nativeRestrictedStructuredClone(value);
  } else
   throwUnpolyfillable(type);
  break;
 case 'ImageData':
  try {
   cloned = new ImageData(structuredCloneInternal(value.data, map), value.width, value.height, { colorSpace: value.colorSpace });
  } catch (error) {
   if (nativeRestrictedStructuredClone) {
    cloned = nativeRestrictedStructuredClone(value);
   } else
    throwUnpolyfillable(type);
  }
  break;
 default:
  if (nativeRestrictedStructuredClone) {
   cloned = nativeRestrictedStructuredClone(value);
  } else
   switch (type) {
   case 'BigInt':
    cloned = Object(value.valueOf());
    break;
   case 'Boolean':
    cloned = Object(booleanValueOf(value));
    break;
   case 'Number':
    cloned = Object(numberValueOf(value));
    break;
   case 'String':
    cloned = Object(stringValueOf(value));
    break;
   case 'Date':
    cloned = new Date(getTime(value));
    break;
   case 'ArrayBuffer':
    C = global.DataView;
    if (!C && typeof value.slice != 'function')
     throwUnpolyfillable(type);
    try {
     if (typeof value.slice == 'function') {
      cloned = value.slice(0);
     } else {
      length = value.byteLength;
      cloned = new ArrayBuffer(length);
      source = new C(value);
      target = new C(cloned);
      for (i = 0; i < length; i++) {
       target.setUint8(i, source.getUint8(i));
      }
     }
    } catch (error) {
     throw new DOMException('ArrayBuffer is detached', DATA_CLONE_ERROR);
    }
    break;
   case 'SharedArrayBuffer':
    cloned = value;
    break;
   case 'Blob':
    try {
     cloned = value.slice(0, value.size, value.type);
    } catch (error) {
     throwUnpolyfillable(type);
    }
    break;
   case 'DOMPoint':
   case 'DOMPointReadOnly':
    C = global[type];
    try {
     cloned = C.fromPoint ? C.fromPoint(value) : new C(value.x, value.y, value.z, value.w);
    } catch (error) {
     throwUnpolyfillable(type);
    }
    break;
   case 'DOMRect':
   case 'DOMRectReadOnly':
    C = global[type];
    try {
     cloned = C.fromRect ? C.fromRect(value) : new C(value.x, value.y, value.width, value.height);
    } catch (error) {
     throwUnpolyfillable(type);
    }
    break;
   case 'DOMMatrix':
   case 'DOMMatrixReadOnly':
    C = global[type];
    try {
     cloned = C.fromMatrix ? C.fromMatrix(value) : new C(value);
    } catch (error) {
     throwUnpolyfillable(type);
    }
    break;
   case 'AudioData':
   case 'VideoFrame':
    if (!isCallable(value.clone))
     throwUnpolyfillable(type);
    try {
     cloned = value.clone();
    } catch (error) {
     throwUncloneable(type);
    }
    break;
   case 'File':
    try {
     cloned = new File([value], value.name, value);
    } catch (error) {
     throwUnpolyfillable(type);
    }
    break;
   case 'CryptoKey':
   case 'GPUCompilationMessage':
   case 'GPUCompilationInfo':
   case 'ImageBitmap':
   case 'RTCCertificate':
   case 'WebAssembly.Module':
    throwUnpolyfillable(type);
   default:
    throwUncloneable(type);
   }
 }
 mapSet(map, value, cloned);
 if (deep)
  switch (type) {
  case 'Array':
  case 'Object':
   keys = objectKeys(value);
   for (i = 0, length = lengthOfArrayLike(keys); i < length; i++) {
    key = keys[i];
    createProperty(cloned, key, structuredCloneInternal(value[key], map));
   }
   break;
  case 'Map':
   value.forEach(function (v, k) {
    mapSet(cloned, structuredCloneInternal(k, map), structuredCloneInternal(v, map));
   });
   break;
  case 'Set':
   value.forEach(function (v) {
    setAdd(cloned, structuredCloneInternal(v, map));
   });
   break;
  case 'Error':
   createNonEnumerableProperty(cloned, 'message', structuredCloneInternal(value.message, map));
   if (hasOwn(value, 'cause')) {
    createNonEnumerableProperty(cloned, 'cause', structuredCloneInternal(value.cause, map));
   }
   if (name == 'AggregateError') {
    cloned.errors = structuredCloneInternal(value.errors, map);
   }
  case 'DOMException':
   if (ERROR_STACK_INSTALLABLE) {
    createNonEnumerableProperty(cloned, 'stack', structuredCloneInternal(value.stack, map));
   }
  }
 return cloned;
};
var PROPER_TRANSFER = nativeStructuredClone && !fails(function () {
 var buffer = new ArrayBuffer(8);
 var clone = nativeStructuredClone(buffer, { transfer: [buffer] });
 return buffer.byteLength != 0 || clone.byteLength != 8;
});
var tryToTransfer = function (rawTransfer, map) {
 if (!isObject(rawTransfer))
  throw TypeError('Transfer option cannot be converted to a sequence');
 var transfer = [];
 iterate(rawTransfer, function (value) {
  push(transfer, anObject(value));
 });
 var i = 0;
 var length = lengthOfArrayLike(transfer);
 var value, type, C, transferredArray, transferred, canvas, context;
 if (PROPER_TRANSFER) {
  transferredArray = nativeStructuredClone(transfer, { transfer: transfer });
  while (i < length)
   mapSet(map, transfer[i], transferredArray[i++]);
 } else
  while (i < length) {
   value = transfer[i++];
   if (mapHas(map, value))
    throw new DOMException('Duplicate transferable', DATA_CLONE_ERROR);
   type = classof(value);
   switch (type) {
   case 'ImageBitmap':
    C = global.OffscreenCanvas;
    if (!isConstructor(C))
     throwUnpolyfillable(type, TRANSFERRING);
    try {
     canvas = new C(value.width, value.height);
     context = canvas.getContext('bitmaprenderer');
     context.transferFromImageBitmap(value);
     transferred = canvas.transferToImageBitmap();
    } catch (error) {
    }
    break;
   case 'AudioData':
   case 'VideoFrame':
    if (!isCallable(value.clone) || !isCallable(value.close))
     throwUnpolyfillable(type, TRANSFERRING);
    try {
     transferred = value.clone();
     value.close();
    } catch (error) {
    }
    break;
   case 'ArrayBuffer':
   case 'MessagePort':
   case 'OffscreenCanvas':
   case 'ReadableStream':
   case 'TransformStream':
   case 'WritableStream':
    throwUnpolyfillable(type, TRANSFERRING);
   }
   if (transferred === undefined)
    throw new DOMException('This object cannot be transferred: ' + type, DATA_CLONE_ERROR);
   mapSet(map, value, transferred);
  }
};
$({
 global: true,
 enumerable: true,
 sham: !PROPER_TRANSFER,
 forced: FORCED_REPLACEMENT
}, {
 structuredClone: function structuredClone(value) {
  var options = validateArgumentsLength(arguments.length, 1) > 1 ? anObject(arguments[1]) : undefined;
  var transfer = options ? options.transfer : undefined;
  var map;
  if (transfer !== undefined) {
   map = new Map();
   tryToTransfer(transfer, map);
  }
  return structuredCloneInternal(value, map);
 }
});

/***/ }),
/* 146 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var anObject = __w_pdfjs_require__(52);
module.exports = function () {
 var that = anObject(this);
 var result = '';
 if (that.global)
  result += 'g';
 if (that.ignoreCase)
  result += 'i';
 if (that.multiline)
  result += 'm';
 if (that.dotAll)
  result += 's';
 if (that.unicode)
  result += 'u';
 if (that.sticky)
  result += 'y';
 return result;
};

/***/ }),
/* 147 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.RefSetCache = exports.RefSet = exports.Ref = exports.Name = exports.EOF = exports.Dict = exports.Cmd = exports.CIRCULAR_REF = void 0;
exports.clearPrimitiveCaches = clearPrimitiveCaches;
exports.isCmd = isCmd;
exports.isDict = isDict;
exports.isName = isName;
exports.isRefsEqual = isRefsEqual;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var CIRCULAR_REF = Symbol("CIRCULAR_REF");
exports.CIRCULAR_REF = CIRCULAR_REF;
var EOF = Symbol("EOF");
exports.EOF = EOF;

var Name = function NameClosure() {
  var nameCache = Object.create(null);

  var Name = /*#__PURE__*/function () {
    function Name(name) {
      _classCallCheck(this, Name);

      this.name = name;
    }

    _createClass(Name, null, [{
      key: "get",
      value: function get(name) {
        var nameValue = nameCache[name];
        return nameValue ? nameValue : nameCache[name] = new Name(name);
      }
    }, {
      key: "_clearCache",
      value: function _clearCache() {
        nameCache = Object.create(null);
      }
    }]);

    return Name;
  }();

  return Name;
}();

exports.Name = Name;

var Cmd = function CmdClosure() {
  var cmdCache = Object.create(null);

  var Cmd = /*#__PURE__*/function () {
    function Cmd(cmd) {
      _classCallCheck(this, Cmd);

      this.cmd = cmd;
    }

    _createClass(Cmd, null, [{
      key: "get",
      value: function get(cmd) {
        var cmdValue = cmdCache[cmd];
        return cmdValue ? cmdValue : cmdCache[cmd] = new Cmd(cmd);
      }
    }, {
      key: "_clearCache",
      value: function _clearCache() {
        cmdCache = Object.create(null);
      }
    }]);

    return Cmd;
  }();

  return Cmd;
}();

exports.Cmd = Cmd;

var nonSerializable = function nonSerializableClosure() {
  return nonSerializable;
};

var Dict = /*#__PURE__*/function () {
  function Dict() {
    var xref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    _classCallCheck(this, Dict);

    this._map = Object.create(null);
    this.xref = xref;
    this.objId = null;
    this.suppressEncryption = false;
    this.__nonSerializable__ = nonSerializable;
  }

  _createClass(Dict, [{
    key: "assignXref",
    value: function assignXref(newXref) {
      this.xref = newXref;
    }
  }, {
    key: "size",
    get: function get() {
      return Object.keys(this._map).length;
    }
  }, {
    key: "get",
    value: function get(key1, key2, key3) {
      var value = this._map[key1];

      if (value === undefined && key2 !== undefined) {
        value = this._map[key2];

        if (value === undefined && key3 !== undefined) {
          value = this._map[key3];
        }
      }

      if (value instanceof Ref && this.xref) {
        return this.xref.fetch(value, this.suppressEncryption);
      }

      return value;
    }
  }, {
    key: "getAsync",
    value: function () {
      var _getAsync = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(key1, key2, key3) {
        var value;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                value = this._map[key1];

                if (value === undefined && key2 !== undefined) {
                  value = this._map[key2];

                  if (value === undefined && key3 !== undefined) {
                    value = this._map[key3];
                  }
                }

                if (!(value instanceof Ref && this.xref)) {
                  _context.next = 4;
                  break;
                }

                return _context.abrupt("return", this.xref.fetchAsync(value, this.suppressEncryption));

              case 4:
                return _context.abrupt("return", value);

              case 5:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function getAsync(_x, _x2, _x3) {
        return _getAsync.apply(this, arguments);
      }

      return getAsync;
    }()
  }, {
    key: "getArray",
    value: function getArray(key1, key2, key3) {
      var value = this._map[key1];

      if (value === undefined && key2 !== undefined) {
        value = this._map[key2];

        if (value === undefined && key3 !== undefined) {
          value = this._map[key3];
        }
      }

      if (value instanceof Ref && this.xref) {
        value = this.xref.fetch(value, this.suppressEncryption);
      }

      if (Array.isArray(value)) {
        value = value.slice();

        for (var i = 0, ii = value.length; i < ii; i++) {
          if (value[i] instanceof Ref && this.xref) {
            value[i] = this.xref.fetch(value[i], this.suppressEncryption);
          }
        }
      }

      return value;
    }
  }, {
    key: "getRaw",
    value: function getRaw(key) {
      return this._map[key];
    }
  }, {
    key: "getKeys",
    value: function getKeys() {
      return Object.keys(this._map);
    }
  }, {
    key: "getRawValues",
    value: function getRawValues() {
      return Object.values(this._map);
    }
  }, {
    key: "set",
    value: function set(key, value) {
      this._map[key] = value;
    }
  }, {
    key: "has",
    value: function has(key) {
      return this._map[key] !== undefined;
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      for (var key in this._map) {
        callback(key, this.get(key));
      }
    }
  }], [{
    key: "empty",
    get: function get() {
      var emptyDict = new Dict(null);

      emptyDict.set = function (key, value) {
        (0, _util.unreachable)("Should not call `set` on the empty dictionary.");
      };

      return (0, _util.shadow)(this, "empty", emptyDict);
    }
  }, {
    key: "merge",
    value: function merge(_ref) {
      var xref = _ref.xref,
          dictArray = _ref.dictArray,
          _ref$mergeSubDicts = _ref.mergeSubDicts,
          mergeSubDicts = _ref$mergeSubDicts === void 0 ? false : _ref$mergeSubDicts;
      var mergedDict = new Dict(xref),
          properties = new Map();

      var _iterator = _createForOfIteratorHelper(dictArray),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var dict = _step.value;

          if (!(dict instanceof Dict)) {
            continue;
          }

          for (var _i = 0, _Object$entries = Object.entries(dict._map); _i < _Object$entries.length; _i++) {
            var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
                key = _Object$entries$_i[0],
                value = _Object$entries$_i[1];

            var property = properties.get(key);

            if (property === undefined) {
              property = [];
              properties.set(key, property);
            } else if (!mergeSubDicts || !(value instanceof Dict)) {
              continue;
            }

            property.push(value);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      var _iterator2 = _createForOfIteratorHelper(properties),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _step2$value = _slicedToArray(_step2.value, 2),
              name = _step2$value[0],
              values = _step2$value[1];

          if (values.length === 1 || !(values[0] instanceof Dict)) {
            mergedDict._map[name] = values[0];
            continue;
          }

          var subDict = new Dict(xref);

          var _iterator3 = _createForOfIteratorHelper(values),
              _step3;

          try {
            for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
              var _dict = _step3.value;

              for (var _i2 = 0, _Object$entries2 = Object.entries(_dict._map); _i2 < _Object$entries2.length; _i2++) {
                var _Object$entries2$_i = _slicedToArray(_Object$entries2[_i2], 2),
                    _key = _Object$entries2$_i[0],
                    _value = _Object$entries2$_i[1];

                if (subDict._map[_key] === undefined) {
                  subDict._map[_key] = _value;
                }
              }
            }
          } catch (err) {
            _iterator3.e(err);
          } finally {
            _iterator3.f();
          }

          if (subDict.size > 0) {
            mergedDict._map[name] = subDict;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      properties.clear();
      return mergedDict.size > 0 ? mergedDict : Dict.empty;
    }
  }]);

  return Dict;
}();

exports.Dict = Dict;

var Ref = function RefClosure() {
  var refCache = Object.create(null);

  var Ref = /*#__PURE__*/function () {
    function Ref(num, gen) {
      _classCallCheck(this, Ref);

      this.num = num;
      this.gen = gen;
    }

    _createClass(Ref, [{
      key: "toString",
      value: function toString() {
        if (this.gen === 0) {
          return "".concat(this.num, "R");
        }

        return "".concat(this.num, "R").concat(this.gen);
      }
    }], [{
      key: "get",
      value: function get(num, gen) {
        var key = gen === 0 ? "".concat(num, "R") : "".concat(num, "R").concat(gen);
        var refValue = refCache[key];
        return refValue ? refValue : refCache[key] = new Ref(num, gen);
      }
    }, {
      key: "_clearCache",
      value: function _clearCache() {
        refCache = Object.create(null);
      }
    }]);

    return Ref;
  }();

  return Ref;
}();

exports.Ref = Ref;

var RefSet = /*#__PURE__*/function () {
  function RefSet() {
    var parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    _classCallCheck(this, RefSet);

    this._set = new Set(parent && parent._set);
  }

  _createClass(RefSet, [{
    key: "has",
    value: function has(ref) {
      return this._set.has(ref.toString());
    }
  }, {
    key: "put",
    value: function put(ref) {
      this._set.add(ref.toString());
    }
  }, {
    key: "remove",
    value: function remove(ref) {
      this._set["delete"](ref.toString());
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      var _iterator4 = _createForOfIteratorHelper(this._set.values()),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var ref = _step4.value;
          callback(ref);
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this._set.clear();
    }
  }]);

  return RefSet;
}();

exports.RefSet = RefSet;

var RefSetCache = /*#__PURE__*/function () {
  function RefSetCache() {
    _classCallCheck(this, RefSetCache);

    this._map = new Map();
  }

  _createClass(RefSetCache, [{
    key: "size",
    get: function get() {
      return this._map.size;
    }
  }, {
    key: "get",
    value: function get(ref) {
      return this._map.get(ref.toString());
    }
  }, {
    key: "has",
    value: function has(ref) {
      return this._map.has(ref.toString());
    }
  }, {
    key: "put",
    value: function put(ref, obj) {
      this._map.set(ref.toString(), obj);
    }
  }, {
    key: "putAlias",
    value: function putAlias(ref, aliasRef) {
      this._map.set(ref.toString(), this.get(aliasRef));
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      var _iterator5 = _createForOfIteratorHelper(this._map.values()),
          _step5;

      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var value = _step5.value;
          callback(value);
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this._map.clear();
    }
  }]);

  return RefSetCache;
}();

exports.RefSetCache = RefSetCache;

function isName(v, name) {
  return v instanceof Name && (name === undefined || v.name === name);
}

function isCmd(v, cmd) {
  return v instanceof Cmd && (cmd === undefined || v.cmd === cmd);
}

function isDict(v, type) {
  return v instanceof Dict && (type === undefined || isName(v.get("Type"), type));
}

function isRefsEqual(v1, v2) {
  return v1.num === v2.num && v1.gen === v2.gen;
}

function clearPrimitiveCaches() {
  Cmd._clearCache();

  Name._clearCache();

  Ref._clearCache();
}

/***/ }),
/* 148 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.NetworkPdfManager = exports.LocalPdfManager = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _chunked_stream = __w_pdfjs_require__(149);

var _core_utils = __w_pdfjs_require__(150);

var _document = __w_pdfjs_require__(153);

var _stream = __w_pdfjs_require__(152);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function parseDocBaseUrl(url) {
  if (url) {
    var absoluteUrl = (0, _util.createValidAbsoluteUrl)(url);

    if (absoluteUrl) {
      return absoluteUrl.href;
    }

    (0, _util.warn)("Invalid absolute docBaseUrl: \"".concat(url, "\"."));
  }

  return null;
}

var BasePdfManager = /*#__PURE__*/function () {
  function BasePdfManager() {
    _classCallCheck(this, BasePdfManager);

    if (this.constructor === BasePdfManager) {
      (0, _util.unreachable)("Cannot initialize BasePdfManager.");
    }
  }

  _createClass(BasePdfManager, [{
    key: "docId",
    get: function get() {
      return this._docId;
    }
  }, {
    key: "password",
    get: function get() {
      return this._password;
    }
  }, {
    key: "docBaseUrl",
    get: function get() {
      return this._docBaseUrl;
    }
  }, {
    key: "onLoadedStream",
    value: function onLoadedStream() {
      (0, _util.unreachable)("Abstract method `onLoadedStream` called");
    }
  }, {
    key: "ensureDoc",
    value: function ensureDoc(prop, args) {
      return this.ensure(this.pdfDocument, prop, args);
    }
  }, {
    key: "ensureXRef",
    value: function ensureXRef(prop, args) {
      return this.ensure(this.pdfDocument.xref, prop, args);
    }
  }, {
    key: "ensureCatalog",
    value: function ensureCatalog(prop, args) {
      return this.ensure(this.pdfDocument.catalog, prop, args);
    }
  }, {
    key: "getPage",
    value: function getPage(pageIndex) {
      return this.pdfDocument.getPage(pageIndex);
    }
  }, {
    key: "fontFallback",
    value: function fontFallback(id, handler) {
      return this.pdfDocument.fontFallback(id, handler);
    }
  }, {
    key: "loadXfaFonts",
    value: function loadXfaFonts(handler, task) {
      return this.pdfDocument.loadXfaFonts(handler, task);
    }
  }, {
    key: "loadXfaImages",
    value: function loadXfaImages() {
      return this.pdfDocument.loadXfaImages();
    }
  }, {
    key: "serializeXfaData",
    value: function serializeXfaData(annotationStorage) {
      return this.pdfDocument.serializeXfaData(annotationStorage);
    }
  }, {
    key: "cleanup",
    value: function cleanup() {
      var manuallyTriggered = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      return this.pdfDocument.cleanup(manuallyTriggered);
    }
  }, {
    key: "ensure",
    value: function () {
      var _ensure = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(obj, prop, args) {
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                (0, _util.unreachable)("Abstract method `ensure` called");

              case 1:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function ensure(_x, _x2, _x3) {
        return _ensure.apply(this, arguments);
      }

      return ensure;
    }()
  }, {
    key: "requestRange",
    value: function requestRange(begin, end) {
      (0, _util.unreachable)("Abstract method `requestRange` called");
    }
  }, {
    key: "requestLoadedStream",
    value: function requestLoadedStream() {
      (0, _util.unreachable)("Abstract method `requestLoadedStream` called");
    }
  }, {
    key: "sendProgressiveData",
    value: function sendProgressiveData(chunk) {
      (0, _util.unreachable)("Abstract method `sendProgressiveData` called");
    }
  }, {
    key: "updatePassword",
    value: function updatePassword(password) {
      this._password = password;
    }
  }, {
    key: "terminate",
    value: function terminate(reason) {
      (0, _util.unreachable)("Abstract method `terminate` called");
    }
  }]);

  return BasePdfManager;
}();

var LocalPdfManager = /*#__PURE__*/function (_BasePdfManager) {
  _inherits(LocalPdfManager, _BasePdfManager);

  var _super = _createSuper(LocalPdfManager);

  function LocalPdfManager(docId, data, password, msgHandler, evaluatorOptions, enableXfa, docBaseUrl) {
    var _this;

    _classCallCheck(this, LocalPdfManager);

    _this = _super.call(this);
    _this._docId = docId;
    _this._password = password;
    _this._docBaseUrl = parseDocBaseUrl(docBaseUrl);
    _this.msgHandler = msgHandler;
    _this.evaluatorOptions = evaluatorOptions;
    _this.enableXfa = enableXfa;
    var stream = new _stream.Stream(data);
    _this.pdfDocument = new _document.PDFDocument(_assertThisInitialized(_this), stream);
    _this._loadedStreamPromise = Promise.resolve(stream);
    return _this;
  }

  _createClass(LocalPdfManager, [{
    key: "ensure",
    value: function () {
      var _ensure2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee2(obj, prop, args) {
        var value;
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                value = obj[prop];

                if (!(typeof value === "function")) {
                  _context2.next = 3;
                  break;
                }

                return _context2.abrupt("return", value.apply(obj, args));

              case 3:
                return _context2.abrupt("return", value);

              case 4:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function ensure(_x4, _x5, _x6) {
        return _ensure2.apply(this, arguments);
      }

      return ensure;
    }()
  }, {
    key: "requestRange",
    value: function requestRange(begin, end) {
      return Promise.resolve();
    }
  }, {
    key: "requestLoadedStream",
    value: function requestLoadedStream() {}
  }, {
    key: "onLoadedStream",
    value: function onLoadedStream() {
      return this._loadedStreamPromise;
    }
  }, {
    key: "terminate",
    value: function terminate(reason) {}
  }]);

  return LocalPdfManager;
}(BasePdfManager);

exports.LocalPdfManager = LocalPdfManager;

var NetworkPdfManager = /*#__PURE__*/function (_BasePdfManager2) {
  _inherits(NetworkPdfManager, _BasePdfManager2);

  var _super2 = _createSuper(NetworkPdfManager);

  function NetworkPdfManager(docId, pdfNetworkStream, args, evaluatorOptions, enableXfa, docBaseUrl) {
    var _this2;

    _classCallCheck(this, NetworkPdfManager);

    _this2 = _super2.call(this);
    _this2._docId = docId;
    _this2._password = args.password;
    _this2._docBaseUrl = parseDocBaseUrl(docBaseUrl);
    _this2.msgHandler = args.msgHandler;
    _this2.evaluatorOptions = evaluatorOptions;
    _this2.enableXfa = enableXfa;
    _this2.streamManager = new _chunked_stream.ChunkedStreamManager(pdfNetworkStream, {
      msgHandler: args.msgHandler,
      length: args.length,
      disableAutoFetch: args.disableAutoFetch,
      rangeChunkSize: args.rangeChunkSize
    });
    _this2.pdfDocument = new _document.PDFDocument(_assertThisInitialized(_this2), _this2.streamManager.getStream());
    return _this2;
  }

  _createClass(NetworkPdfManager, [{
    key: "ensure",
    value: function () {
      var _ensure3 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee3(obj, prop, args) {
        var value;
        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.prev = 0;
                value = obj[prop];

                if (!(typeof value === "function")) {
                  _context3.next = 4;
                  break;
                }

                return _context3.abrupt("return", value.apply(obj, args));

              case 4:
                return _context3.abrupt("return", value);

              case 7:
                _context3.prev = 7;
                _context3.t0 = _context3["catch"](0);

                if (_context3.t0 instanceof _core_utils.MissingDataException) {
                  _context3.next = 11;
                  break;
                }

                throw _context3.t0;

              case 11:
                _context3.next = 13;
                return this.requestRange(_context3.t0.begin, _context3.t0.end);

              case 13:
                return _context3.abrupt("return", this.ensure(obj, prop, args));

              case 14:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this, [[0, 7]]);
      }));

      function ensure(_x7, _x8, _x9) {
        return _ensure3.apply(this, arguments);
      }

      return ensure;
    }()
  }, {
    key: "requestRange",
    value: function requestRange(begin, end) {
      return this.streamManager.requestRange(begin, end);
    }
  }, {
    key: "requestLoadedStream",
    value: function requestLoadedStream() {
      this.streamManager.requestAllChunks();
    }
  }, {
    key: "sendProgressiveData",
    value: function sendProgressiveData(chunk) {
      this.streamManager.onReceiveData({
        chunk: chunk
      });
    }
  }, {
    key: "onLoadedStream",
    value: function onLoadedStream() {
      return this.streamManager.onLoadedStream();
    }
  }, {
    key: "terminate",
    value: function terminate(reason) {
      this.streamManager.abort(reason);
    }
  }]);

  return NetworkPdfManager;
}(BasePdfManager);

exports.NetworkPdfManager = NetworkPdfManager;

/***/ }),
/* 149 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ChunkedStreamManager = exports.ChunkedStream = void 0;

var _util = __w_pdfjs_require__(4);

var _core_utils = __w_pdfjs_require__(150);

var _stream = __w_pdfjs_require__(152);

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var ChunkedStream = /*#__PURE__*/function (_Stream) {
  _inherits(ChunkedStream, _Stream);

  var _super = _createSuper(ChunkedStream);

  function ChunkedStream(length, chunkSize, manager) {
    var _this;

    _classCallCheck(this, ChunkedStream);

    _this = _super.call(this, new Uint8Array(length), 0, length, null);
    _this.chunkSize = chunkSize;
    _this._loadedChunks = new Set();
    _this.numChunks = Math.ceil(length / chunkSize);
    _this.manager = manager;
    _this.progressiveDataLength = 0;
    _this.lastSuccessfulEnsureByteChunk = -1;
    return _this;
  }

  _createClass(ChunkedStream, [{
    key: "getMissingChunks",
    value: function getMissingChunks() {
      var chunks = [];

      for (var chunk = 0, n = this.numChunks; chunk < n; ++chunk) {
        if (!this._loadedChunks.has(chunk)) {
          chunks.push(chunk);
        }
      }

      return chunks;
    }
  }, {
    key: "numChunksLoaded",
    get: function get() {
      return this._loadedChunks.size;
    }
  }, {
    key: "isDataLoaded",
    get: function get() {
      return this.numChunksLoaded === this.numChunks;
    }
  }, {
    key: "onReceiveData",
    value: function onReceiveData(begin, chunk) {
      var chunkSize = this.chunkSize;

      if (begin % chunkSize !== 0) {
        throw new Error("Bad begin offset: ".concat(begin));
      }

      var end = begin + chunk.byteLength;

      if (end % chunkSize !== 0 && end !== this.bytes.length) {
        throw new Error("Bad end offset: ".concat(end));
      }

      this.bytes.set(new Uint8Array(chunk), begin);
      var beginChunk = Math.floor(begin / chunkSize);
      var endChunk = Math.floor((end - 1) / chunkSize) + 1;

      for (var curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
        this._loadedChunks.add(curChunk);
      }
    }
  }, {
    key: "onReceiveProgressiveData",
    value: function onReceiveProgressiveData(data) {
      var position = this.progressiveDataLength;
      var beginChunk = Math.floor(position / this.chunkSize);
      this.bytes.set(new Uint8Array(data), position);
      position += data.byteLength;
      this.progressiveDataLength = position;
      var endChunk = position >= this.end ? this.numChunks : Math.floor(position / this.chunkSize);

      for (var curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
        this._loadedChunks.add(curChunk);
      }
    }
  }, {
    key: "ensureByte",
    value: function ensureByte(pos) {
      if (pos < this.progressiveDataLength) {
        return;
      }

      var chunk = Math.floor(pos / this.chunkSize);

      if (chunk > this.numChunks) {
        return;
      }

      if (chunk === this.lastSuccessfulEnsureByteChunk) {
        return;
      }

      if (!this._loadedChunks.has(chunk)) {
        throw new _core_utils.MissingDataException(pos, pos + 1);
      }

      this.lastSuccessfulEnsureByteChunk = chunk;
    }
  }, {
    key: "ensureRange",
    value: function ensureRange(begin, end) {
      if (begin >= end) {
        return;
      }

      if (end <= this.progressiveDataLength) {
        return;
      }

      var beginChunk = Math.floor(begin / this.chunkSize);

      if (beginChunk > this.numChunks) {
        return;
      }

      var endChunk = Math.min(Math.floor((end - 1) / this.chunkSize) + 1, this.numChunks);

      for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
        if (!this._loadedChunks.has(chunk)) {
          throw new _core_utils.MissingDataException(begin, end);
        }
      }
    }
  }, {
    key: "nextEmptyChunk",
    value: function nextEmptyChunk(beginChunk) {
      var numChunks = this.numChunks;

      for (var i = 0; i < numChunks; ++i) {
        var chunk = (beginChunk + i) % numChunks;

        if (!this._loadedChunks.has(chunk)) {
          return chunk;
        }
      }

      return null;
    }
  }, {
    key: "hasChunk",
    value: function hasChunk(chunk) {
      return this._loadedChunks.has(chunk);
    }
  }, {
    key: "getByte",
    value: function getByte() {
      var pos = this.pos;

      if (pos >= this.end) {
        return -1;
      }

      if (pos >= this.progressiveDataLength) {
        this.ensureByte(pos);
      }

      return this.bytes[this.pos++];
    }
  }, {
    key: "getBytes",
    value: function getBytes(length) {
      var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var bytes = this.bytes;
      var pos = this.pos;
      var strEnd = this.end;

      if (!length) {
        if (strEnd > this.progressiveDataLength) {
          this.ensureRange(pos, strEnd);
        }

        var _subarray = bytes.subarray(pos, strEnd);

        return forceClamped ? new Uint8ClampedArray(_subarray) : _subarray;
      }

      var end = pos + length;

      if (end > strEnd) {
        end = strEnd;
      }

      if (end > this.progressiveDataLength) {
        this.ensureRange(pos, end);
      }

      this.pos = end;
      var subarray = bytes.subarray(pos, end);
      return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
    }
  }, {
    key: "getByteRange",
    value: function getByteRange(begin, end) {
      if (begin < 0) {
        begin = 0;
      }

      if (end > this.end) {
        end = this.end;
      }

      if (end > this.progressiveDataLength) {
        this.ensureRange(begin, end);
      }

      return this.bytes.subarray(begin, end);
    }
  }, {
    key: "makeSubStream",
    value: function makeSubStream(start, length) {
      var dict = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      if (length) {
        if (start + length > this.progressiveDataLength) {
          this.ensureRange(start, start + length);
        }
      } else {
        if (start >= this.progressiveDataLength) {
          this.ensureByte(start);
        }
      }

      function ChunkedStreamSubstream() {}

      ChunkedStreamSubstream.prototype = Object.create(this);

      ChunkedStreamSubstream.prototype.getMissingChunks = function () {
        var chunkSize = this.chunkSize;
        var beginChunk = Math.floor(this.start / chunkSize);
        var endChunk = Math.floor((this.end - 1) / chunkSize) + 1;
        var missingChunks = [];

        for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
          if (!this._loadedChunks.has(chunk)) {
            missingChunks.push(chunk);
          }
        }

        return missingChunks;
      };

      Object.defineProperty(ChunkedStreamSubstream.prototype, "isDataLoaded", {
        get: function get() {
          if (this.numChunksLoaded === this.numChunks) {
            return true;
          }

          return this.getMissingChunks().length === 0;
        },
        configurable: true
      });
      var subStream = new ChunkedStreamSubstream();
      subStream.pos = subStream.start = start;
      subStream.end = start + length || this.end;
      subStream.dict = dict;
      return subStream;
    }
  }, {
    key: "getBaseStreams",
    value: function getBaseStreams() {
      return [this];
    }
  }]);

  return ChunkedStream;
}(_stream.Stream);

exports.ChunkedStream = ChunkedStream;

var ChunkedStreamManager = /*#__PURE__*/function () {
  function ChunkedStreamManager(pdfNetworkStream, args) {
    _classCallCheck(this, ChunkedStreamManager);

    this.length = args.length;
    this.chunkSize = args.rangeChunkSize;
    this.stream = new ChunkedStream(this.length, this.chunkSize, this);
    this.pdfNetworkStream = pdfNetworkStream;
    this.disableAutoFetch = args.disableAutoFetch;
    this.msgHandler = args.msgHandler;
    this.currRequestId = 0;
    this._chunksNeededByRequest = new Map();
    this._requestsByChunk = new Map();
    this._promisesByRequest = new Map();
    this.progressiveDataLength = 0;
    this.aborted = false;
    this._loadedStreamCapability = (0, _util.createPromiseCapability)();
  }

  _createClass(ChunkedStreamManager, [{
    key: "onLoadedStream",
    value: function onLoadedStream() {
      return this._loadedStreamCapability.promise;
    }
  }, {
    key: "sendRequest",
    value: function sendRequest(begin, end) {
      var _this2 = this;

      var rangeReader = this.pdfNetworkStream.getRangeReader(begin, end);

      if (!rangeReader.isStreamingSupported) {
        rangeReader.onProgress = this.onProgress.bind(this);
      }

      var chunks = [],
          loaded = 0;
      return new Promise(function (resolve, reject) {
        var readChunk = function readChunk(chunk) {
          try {
            if (!chunk.done) {
              var data = chunk.value;
              chunks.push(data);
              loaded += (0, _util.arrayByteLength)(data);

              if (rangeReader.isStreamingSupported) {
                _this2.onProgress({
                  loaded: loaded
                });
              }

              rangeReader.read().then(readChunk, reject);
              return;
            }

            var chunkData = (0, _util.arraysToBytes)(chunks);
            chunks = null;
            resolve(chunkData);
          } catch (e) {
            reject(e);
          }
        };

        rangeReader.read().then(readChunk, reject);
      }).then(function (data) {
        if (_this2.aborted) {
          return;
        }

        _this2.onReceiveData({
          chunk: data,
          begin: begin
        });
      });
    }
  }, {
    key: "requestAllChunks",
    value: function requestAllChunks() {
      var missingChunks = this.stream.getMissingChunks();

      this._requestChunks(missingChunks);

      return this._loadedStreamCapability.promise;
    }
  }, {
    key: "_requestChunks",
    value: function _requestChunks(chunks) {
      var _this3 = this;

      var requestId = this.currRequestId++;
      var chunksNeeded = new Set();

      this._chunksNeededByRequest.set(requestId, chunksNeeded);

      var _iterator = _createForOfIteratorHelper(chunks),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var chunk = _step.value;

          if (!this.stream.hasChunk(chunk)) {
            chunksNeeded.add(chunk);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      if (chunksNeeded.size === 0) {
        return Promise.resolve();
      }

      var capability = (0, _util.createPromiseCapability)();

      this._promisesByRequest.set(requestId, capability);

      var chunksToRequest = [];

      var _iterator2 = _createForOfIteratorHelper(chunksNeeded),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _chunk = _step2.value;

          var requestIds = this._requestsByChunk.get(_chunk);

          if (!requestIds) {
            requestIds = [];

            this._requestsByChunk.set(_chunk, requestIds);

            chunksToRequest.push(_chunk);
          }

          requestIds.push(requestId);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      if (chunksToRequest.length > 0) {
        var groupedChunksToRequest = this.groupChunks(chunksToRequest);

        var _iterator3 = _createForOfIteratorHelper(groupedChunksToRequest),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var groupedChunk = _step3.value;
            var begin = groupedChunk.beginChunk * this.chunkSize;
            var end = Math.min(groupedChunk.endChunk * this.chunkSize, this.length);
            this.sendRequest(begin, end)["catch"](capability.reject);
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      }

      return capability.promise["catch"](function (reason) {
        if (_this3.aborted) {
          return;
        }

        throw reason;
      });
    }
  }, {
    key: "getStream",
    value: function getStream() {
      return this.stream;
    }
  }, {
    key: "requestRange",
    value: function requestRange(begin, end) {
      end = Math.min(end, this.length);
      var beginChunk = this.getBeginChunk(begin);
      var endChunk = this.getEndChunk(end);
      var chunks = [];

      for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
        chunks.push(chunk);
      }

      return this._requestChunks(chunks);
    }
  }, {
    key: "requestRanges",
    value: function requestRanges() {
      var ranges = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var chunksToRequest = [];

      var _iterator4 = _createForOfIteratorHelper(ranges),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var range = _step4.value;
          var beginChunk = this.getBeginChunk(range.begin);
          var endChunk = this.getEndChunk(range.end);

          for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
            if (!chunksToRequest.includes(chunk)) {
              chunksToRequest.push(chunk);
            }
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }

      chunksToRequest.sort(function (a, b) {
        return a - b;
      });
      return this._requestChunks(chunksToRequest);
    }
  }, {
    key: "groupChunks",
    value: function groupChunks(chunks) {
      var groupedChunks = [];
      var beginChunk = -1;
      var prevChunk = -1;

      for (var i = 0, ii = chunks.length; i < ii; ++i) {
        var chunk = chunks[i];

        if (beginChunk < 0) {
          beginChunk = chunk;
        }

        if (prevChunk >= 0 && prevChunk + 1 !== chunk) {
          groupedChunks.push({
            beginChunk: beginChunk,
            endChunk: prevChunk + 1
          });
          beginChunk = chunk;
        }

        if (i + 1 === chunks.length) {
          groupedChunks.push({
            beginChunk: beginChunk,
            endChunk: chunk + 1
          });
        }

        prevChunk = chunk;
      }

      return groupedChunks;
    }
  }, {
    key: "onProgress",
    value: function onProgress(args) {
      this.msgHandler.send("DocProgress", {
        loaded: this.stream.numChunksLoaded * this.chunkSize + args.loaded,
        total: this.length
      });
    }
  }, {
    key: "onReceiveData",
    value: function onReceiveData(args) {
      var chunk = args.chunk;
      var isProgressive = args.begin === undefined;
      var begin = isProgressive ? this.progressiveDataLength : args.begin;
      var end = begin + chunk.byteLength;
      var beginChunk = Math.floor(begin / this.chunkSize);
      var endChunk = end < this.length ? Math.floor(end / this.chunkSize) : Math.ceil(end / this.chunkSize);

      if (isProgressive) {
        this.stream.onReceiveProgressiveData(chunk);
        this.progressiveDataLength = end;
      } else {
        this.stream.onReceiveData(begin, chunk);
      }

      if (this.stream.isDataLoaded) {
        this._loadedStreamCapability.resolve(this.stream);
      }

      var loadedRequests = [];

      for (var curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
        var requestIds = this._requestsByChunk.get(curChunk);

        if (!requestIds) {
          continue;
        }

        this._requestsByChunk["delete"](curChunk);

        var _iterator5 = _createForOfIteratorHelper(requestIds),
            _step5;

        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var requestId = _step5.value;

            var chunksNeeded = this._chunksNeededByRequest.get(requestId);

            if (chunksNeeded.has(curChunk)) {
              chunksNeeded["delete"](curChunk);
            }

            if (chunksNeeded.size > 0) {
              continue;
            }

            loadedRequests.push(requestId);
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }
      }

      if (!this.disableAutoFetch && this._requestsByChunk.size === 0) {
        var nextEmptyChunk;

        if (this.stream.numChunksLoaded === 1) {
          var lastChunk = this.stream.numChunks - 1;

          if (!this.stream.hasChunk(lastChunk)) {
            nextEmptyChunk = lastChunk;
          }
        } else {
          nextEmptyChunk = this.stream.nextEmptyChunk(endChunk);
        }

        if (Number.isInteger(nextEmptyChunk)) {
          this._requestChunks([nextEmptyChunk]);
        }
      }

      for (var _i = 0, _loadedRequests = loadedRequests; _i < _loadedRequests.length; _i++) {
        var _requestId = _loadedRequests[_i];

        var capability = this._promisesByRequest.get(_requestId);

        this._promisesByRequest["delete"](_requestId);

        capability.resolve();
      }

      this.msgHandler.send("DocProgress", {
        loaded: this.stream.numChunksLoaded * this.chunkSize,
        total: this.length
      });
    }
  }, {
    key: "onError",
    value: function onError(err) {
      this._loadedStreamCapability.reject(err);
    }
  }, {
    key: "getBeginChunk",
    value: function getBeginChunk(begin) {
      return Math.floor(begin / this.chunkSize);
    }
  }, {
    key: "getEndChunk",
    value: function getEndChunk(end) {
      return Math.floor((end - 1) / this.chunkSize) + 1;
    }
  }, {
    key: "abort",
    value: function abort(reason) {
      this.aborted = true;

      if (this.pdfNetworkStream) {
        this.pdfNetworkStream.cancelAllRequests(reason);
      }

      var _iterator6 = _createForOfIteratorHelper(this._promisesByRequest.values()),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var capability = _step6.value;
          capability.reject(reason);
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
    }
  }]);

  return ChunkedStreamManager;
}();

exports.ChunkedStreamManager = ChunkedStreamManager;

/***/ }),
/* 150 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.XRefParseException = exports.XRefEntryException = exports.ParserEOFException = exports.MissingDataException = exports.DocStats = void 0;
exports.collectActions = collectActions;
exports.encodeToXmlString = encodeToXmlString;
exports.escapePDFName = escapePDFName;
exports.getArrayLookupTableFactory = getArrayLookupTableFactory;
exports.getInheritableProperty = getInheritableProperty;
exports.getLookupTableFactory = getLookupTableFactory;
exports.isWhiteSpace = isWhiteSpace;
exports.log2 = log2;
exports.parseXFAPath = parseXFAPath;
exports.readInt8 = readInt8;
exports.readUint16 = readUint16;
exports.readUint32 = readUint32;
exports.recoverJsURL = recoverJsURL;
exports.toRomanNumerals = toRomanNumerals;
exports.validateCSSFont = validateCSSFont;

var _util = __w_pdfjs_require__(4);

var _primitives = __w_pdfjs_require__(147);

var _base_stream = __w_pdfjs_require__(151);

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function getLookupTableFactory(initializer) {
  var lookup;
  return function () {
    if (initializer) {
      lookup = Object.create(null);
      initializer(lookup);
      initializer = null;
    }

    return lookup;
  };
}

function getArrayLookupTableFactory(initializer) {
  var lookup;
  return function () {
    if (initializer) {
      var arr = initializer();
      initializer = null;
      lookup = Object.create(null);

      for (var i = 0, ii = arr.length; i < ii; i += 2) {
        lookup[arr[i]] = arr[i + 1];
      }

      arr = null;
    }

    return lookup;
  };
}

var MissingDataException = /*#__PURE__*/function (_BaseException) {
  _inherits(MissingDataException, _BaseException);

  var _super = _createSuper(MissingDataException);

  function MissingDataException(begin, end) {
    var _this;

    _classCallCheck(this, MissingDataException);

    _this = _super.call(this, "Missing data [".concat(begin, ", ").concat(end, ")"), "MissingDataException");
    _this.begin = begin;
    _this.end = end;
    return _this;
  }

  return _createClass(MissingDataException);
}(_util.BaseException);

exports.MissingDataException = MissingDataException;

var ParserEOFException = /*#__PURE__*/function (_BaseException2) {
  _inherits(ParserEOFException, _BaseException2);

  var _super2 = _createSuper(ParserEOFException);

  function ParserEOFException(msg) {
    _classCallCheck(this, ParserEOFException);

    return _super2.call(this, msg, "ParserEOFException");
  }

  return _createClass(ParserEOFException);
}(_util.BaseException);

exports.ParserEOFException = ParserEOFException;

var XRefEntryException = /*#__PURE__*/function (_BaseException3) {
  _inherits(XRefEntryException, _BaseException3);

  var _super3 = _createSuper(XRefEntryException);

  function XRefEntryException(msg) {
    _classCallCheck(this, XRefEntryException);

    return _super3.call(this, msg, "XRefEntryException");
  }

  return _createClass(XRefEntryException);
}(_util.BaseException);

exports.XRefEntryException = XRefEntryException;

var XRefParseException = /*#__PURE__*/function (_BaseException4) {
  _inherits(XRefParseException, _BaseException4);

  var _super4 = _createSuper(XRefParseException);

  function XRefParseException(msg) {
    _classCallCheck(this, XRefParseException);

    return _super4.call(this, msg, "XRefParseException");
  }

  return _createClass(XRefParseException);
}(_util.BaseException);

exports.XRefParseException = XRefParseException;

var DocStats = /*#__PURE__*/function () {
  function DocStats(handler) {
    _classCallCheck(this, DocStats);

    this._handler = handler;
    this._streamTypes = new Set();
    this._fontTypes = new Set();
  }

  _createClass(DocStats, [{
    key: "_send",
    value: function _send() {
      var streamTypes = Object.create(null),
          fontTypes = Object.create(null);

      var _iterator = _createForOfIteratorHelper(this._streamTypes),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var type = _step.value;
          streamTypes[type] = true;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      var _iterator2 = _createForOfIteratorHelper(this._fontTypes),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _type = _step2.value;
          fontTypes[_type] = true;
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      this._handler.send("DocStats", {
        streamTypes: streamTypes,
        fontTypes: fontTypes
      });
    }
  }, {
    key: "addStreamType",
    value: function addStreamType(type) {
      if (this._streamTypes.has(type)) {
        return;
      }

      this._streamTypes.add(type);

      this._send();
    }
  }, {
    key: "addFontType",
    value: function addFontType(type) {
      if (this._fontTypes.has(type)) {
        return;
      }

      this._fontTypes.add(type);

      this._send();
    }
  }]);

  return DocStats;
}();

exports.DocStats = DocStats;

function getInheritableProperty(_ref) {
  var dict = _ref.dict,
      key = _ref.key,
      _ref$getArray = _ref.getArray,
      getArray = _ref$getArray === void 0 ? false : _ref$getArray,
      _ref$stopWhenFound = _ref.stopWhenFound,
      stopWhenFound = _ref$stopWhenFound === void 0 ? true : _ref$stopWhenFound;
  var values;
  var visited = new _primitives.RefSet();

  while (dict instanceof _primitives.Dict && !(dict.objId && visited.has(dict.objId))) {
    if (dict.objId) {
      visited.put(dict.objId);
    }

    var value = getArray ? dict.getArray(key) : dict.get(key);

    if (value !== undefined) {
      if (stopWhenFound) {
        return value;
      }

      if (!values) {
        values = [];
      }

      values.push(value);
    }

    dict = dict.get("Parent");
  }

  return values;
}

var ROMAN_NUMBER_MAP = ["", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM", "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC", "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"];

function toRomanNumerals(number) {
  var lowerCase = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  (0, _util.assert)(Number.isInteger(number) && number > 0, "The number should be a positive integer.");
  var romanBuf = [];
  var pos;

  while (number >= 1000) {
    number -= 1000;
    romanBuf.push("M");
  }

  pos = number / 100 | 0;
  number %= 100;
  romanBuf.push(ROMAN_NUMBER_MAP[pos]);
  pos = number / 10 | 0;
  number %= 10;
  romanBuf.push(ROMAN_NUMBER_MAP[10 + pos]);
  romanBuf.push(ROMAN_NUMBER_MAP[20 + number]);
  var romanStr = romanBuf.join("");
  return lowerCase ? romanStr.toLowerCase() : romanStr;
}

function log2(x) {
  if (x <= 0) {
    return 0;
  }

  return Math.ceil(Math.log2(x));
}

function readInt8(data, offset) {
  return data[offset] << 24 >> 24;
}

function readUint16(data, offset) {
  return data[offset] << 8 | data[offset + 1];
}

function readUint32(data, offset) {
  return (data[offset] << 24 | data[offset + 1] << 16 | data[offset + 2] << 8 | data[offset + 3]) >>> 0;
}

function isWhiteSpace(ch) {
  return ch === 0x20 || ch === 0x09 || ch === 0x0d || ch === 0x0a;
}

function parseXFAPath(path) {
  var positionPattern = /(.+)\[(\d+)\]$/;
  return path.split(".").map(function (component) {
    var m = component.match(positionPattern);

    if (m) {
      return {
        name: m[1],
        pos: parseInt(m[2], 10)
      };
    }

    return {
      name: component,
      pos: 0
    };
  });
}

function escapePDFName(str) {
  var buffer = [];
  var start = 0;

  for (var i = 0, ii = str.length; i < ii; i++) {
    var _char = str.charCodeAt(i);

    if (_char < 0x21 || _char > 0x7e || _char === 0x23 || _char === 0x28 || _char === 0x29 || _char === 0x3c || _char === 0x3e || _char === 0x5b || _char === 0x5d || _char === 0x7b || _char === 0x7d || _char === 0x2f || _char === 0x25) {
      if (start < i) {
        buffer.push(str.substring(start, i));
      }

      buffer.push("#".concat(_char.toString(16)));
      start = i + 1;
    }
  }

  if (buffer.length === 0) {
    return str;
  }

  if (start < str.length) {
    buffer.push(str.substring(start, str.length));
  }

  return buffer.join("");
}

function _collectJS(entry, xref, list, parents) {
  if (!entry) {
    return;
  }

  var parent = null;

  if (entry instanceof _primitives.Ref) {
    if (parents.has(entry)) {
      return;
    }

    parent = entry;
    parents.put(parent);
    entry = xref.fetch(entry);
  }

  if (Array.isArray(entry)) {
    var _iterator3 = _createForOfIteratorHelper(entry),
        _step3;

    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var element = _step3.value;

        _collectJS(element, xref, list, parents);
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }
  } else if (entry instanceof _primitives.Dict) {
    if ((0, _primitives.isName)(entry.get("S"), "JavaScript")) {
      var js = entry.get("JS");
      var code;

      if (js instanceof _base_stream.BaseStream) {
        code = js.getString();
      } else if (typeof js === "string") {
        code = js;
      }

      code = code && (0, _util.stringToPDFString)(code);

      if (code) {
        list.push(code);
      }
    }

    _collectJS(entry.getRaw("Next"), xref, list, parents);
  }

  if (parent) {
    parents.remove(parent);
  }
}

function collectActions(xref, dict, eventType) {
  var actions = Object.create(null);
  var additionalActionsDicts = getInheritableProperty({
    dict: dict,
    key: "AA",
    stopWhenFound: false
  });

  if (additionalActionsDicts) {
    for (var i = additionalActionsDicts.length - 1; i >= 0; i--) {
      var additionalActions = additionalActionsDicts[i];

      if (!(additionalActions instanceof _primitives.Dict)) {
        continue;
      }

      var _iterator4 = _createForOfIteratorHelper(additionalActions.getKeys()),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var key = _step4.value;
          var action = eventType[key];

          if (!action) {
            continue;
          }

          var actionDict = additionalActions.getRaw(key);
          var parents = new _primitives.RefSet();
          var list = [];

          _collectJS(actionDict, xref, list, parents);

          if (list.length > 0) {
            actions[action] = list;
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
    }
  }

  if (dict.has("A")) {
    var _actionDict = dict.get("A");

    var _parents = new _primitives.RefSet();

    var _list = [];

    _collectJS(_actionDict, xref, _list, _parents);

    if (_list.length > 0) {
      actions.Action = _list;
    }
  }

  return (0, _util.objectSize)(actions) > 0 ? actions : null;
}

var XMLEntities = {
  0x3c: "&lt;",
  0x3e: "&gt;",
  0x26: "&amp;",
  0x22: "&quot;",
  0x27: "&apos;"
};

function encodeToXmlString(str) {
  var buffer = [];
  var start = 0;

  for (var i = 0, ii = str.length; i < ii; i++) {
    var _char2 = str.codePointAt(i);

    if (0x20 <= _char2 && _char2 <= 0x7e) {
      var entity = XMLEntities[_char2];

      if (entity) {
        if (start < i) {
          buffer.push(str.substring(start, i));
        }

        buffer.push(entity);
        start = i + 1;
      }
    } else {
      if (start < i) {
        buffer.push(str.substring(start, i));
      }

      buffer.push("&#x".concat(_char2.toString(16).toUpperCase(), ";"));

      if (_char2 > 0xd7ff && (_char2 < 0xe000 || _char2 > 0xfffd)) {
        i++;
      }

      start = i + 1;
    }
  }

  if (buffer.length === 0) {
    return str;
  }

  if (start < str.length) {
    buffer.push(str.substring(start, str.length));
  }

  return buffer.join("");
}

function validateCSSFont(cssFontInfo) {
  var DEFAULT_CSS_FONT_OBLIQUE = "14";
  var DEFAULT_CSS_FONT_WEIGHT = "400";
  var CSS_FONT_WEIGHT_VALUES = new Set(["100", "200", "300", "400", "500", "600", "700", "800", "900", "1000", "normal", "bold", "bolder", "lighter"]);
  var fontFamily = cssFontInfo.fontFamily,
      fontWeight = cssFontInfo.fontWeight,
      italicAngle = cssFontInfo.italicAngle;

  if (/^".*"$/.test(fontFamily)) {
    if (/[^\\]"/.test(fontFamily.slice(1, fontFamily.length - 1))) {
      (0, _util.warn)("XFA - FontFamily contains some unescaped \": ".concat(fontFamily, "."));
      return false;
    }
  } else if (/^'.*'$/.test(fontFamily)) {
    if (/[^\\]'/.test(fontFamily.slice(1, fontFamily.length - 1))) {
      (0, _util.warn)("XFA - FontFamily contains some unescaped ': ".concat(fontFamily, "."));
      return false;
    }
  } else {
    var _iterator5 = _createForOfIteratorHelper(fontFamily.split(/[ \t]+/)),
        _step5;

    try {
      for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
        var ident = _step5.value;

        if (/^(\d|(-(\d|-)))/.test(ident) || !/^[\w-\\]+$/.test(ident)) {
          (0, _util.warn)("XFA - FontFamily contains some invalid <custom-ident>: ".concat(fontFamily, "."));
          return false;
        }
      }
    } catch (err) {
      _iterator5.e(err);
    } finally {
      _iterator5.f();
    }
  }

  var weight = fontWeight ? fontWeight.toString() : "";
  cssFontInfo.fontWeight = CSS_FONT_WEIGHT_VALUES.has(weight) ? weight : DEFAULT_CSS_FONT_WEIGHT;
  var angle = parseFloat(italicAngle);
  cssFontInfo.italicAngle = isNaN(angle) || angle < -90 || angle > 90 ? DEFAULT_CSS_FONT_OBLIQUE : italicAngle.toString();
  return true;
}

function recoverJsURL(str) {
  var URL_OPEN_METHODS = ["app.launchURL", "window.open", "xfa.host.gotoURL"];
  var regex = new RegExp("^\\s*(" + URL_OPEN_METHODS.join("|").split(".").join("\\.") + ")\\((?:'|\")([^'\"]*)(?:'|\")(?:,\\s*(\\w+)\\)|\\))", "i");
  var jsUrl = regex.exec(str);

  if (jsUrl && jsUrl[2]) {
    var url = jsUrl[2];
    var newWindow = false;

    if (jsUrl[3] === "true" && jsUrl[1] === "app.launchURL") {
      newWindow = true;
    }

    return {
      url: url,
      newWindow: newWindow
    };
  }

  return null;
}

/***/ }),
/* 151 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.BaseStream = void 0;

var _util = __w_pdfjs_require__(4);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var BaseStream = /*#__PURE__*/function () {
  function BaseStream() {
    _classCallCheck(this, BaseStream);

    if (this.constructor === BaseStream) {
      (0, _util.unreachable)("Cannot initialize BaseStream.");
    }
  }

  _createClass(BaseStream, [{
    key: "length",
    get: function get() {
      (0, _util.unreachable)("Abstract getter `length` accessed");
    }
  }, {
    key: "isEmpty",
    get: function get() {
      (0, _util.unreachable)("Abstract getter `isEmpty` accessed");
    }
  }, {
    key: "isDataLoaded",
    get: function get() {
      return (0, _util.shadow)(this, "isDataLoaded", true);
    }
  }, {
    key: "getByte",
    value: function getByte() {
      (0, _util.unreachable)("Abstract method `getByte` called");
    }
  }, {
    key: "getBytes",
    value: function getBytes(length) {
      var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      (0, _util.unreachable)("Abstract method `getBytes` called");
    }
  }, {
    key: "peekByte",
    value: function peekByte() {
      var peekedByte = this.getByte();

      if (peekedByte !== -1) {
        this.pos--;
      }

      return peekedByte;
    }
  }, {
    key: "peekBytes",
    value: function peekBytes(length) {
      var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var bytes = this.getBytes(length, forceClamped);
      this.pos -= bytes.length;
      return bytes;
    }
  }, {
    key: "getUint16",
    value: function getUint16() {
      var b0 = this.getByte();
      var b1 = this.getByte();

      if (b0 === -1 || b1 === -1) {
        return -1;
      }

      return (b0 << 8) + b1;
    }
  }, {
    key: "getInt32",
    value: function getInt32() {
      var b0 = this.getByte();
      var b1 = this.getByte();
      var b2 = this.getByte();
      var b3 = this.getByte();
      return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }
  }, {
    key: "getByteRange",
    value: function getByteRange(begin, end) {
      (0, _util.unreachable)("Abstract method `getByteRange` called");
    }
  }, {
    key: "getString",
    value: function getString(length) {
      return (0, _util.bytesToString)(this.getBytes(length, false));
    }
  }, {
    key: "skip",
    value: function skip(n) {
      this.pos += n || 1;
    }
  }, {
    key: "reset",
    value: function reset() {
      (0, _util.unreachable)("Abstract method `reset` called");
    }
  }, {
    key: "moveStart",
    value: function moveStart() {
      (0, _util.unreachable)("Abstract method `moveStart` called");
    }
  }, {
    key: "makeSubStream",
    value: function makeSubStream(start, length) {
      var dict = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      (0, _util.unreachable)("Abstract method `makeSubStream` called");
    }
  }, {
    key: "getBaseStreams",
    value: function getBaseStreams() {
      return null;
    }
  }]);

  return BaseStream;
}();

exports.BaseStream = BaseStream;

/***/ }),
/* 152 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.StringStream = exports.Stream = exports.NullStream = void 0;

var _base_stream = __w_pdfjs_require__(151);

var _util = __w_pdfjs_require__(4);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Stream = /*#__PURE__*/function (_BaseStream) {
  _inherits(Stream, _BaseStream);

  var _super = _createSuper(Stream);

  function Stream(arrayBuffer, start, length, dict) {
    var _this;

    _classCallCheck(this, Stream);

    _this = _super.call(this);
    _this.bytes = arrayBuffer instanceof Uint8Array ? arrayBuffer : new Uint8Array(arrayBuffer);
    _this.start = start || 0;
    _this.pos = _this.start;
    _this.end = start + length || _this.bytes.length;
    _this.dict = dict;
    return _this;
  }

  _createClass(Stream, [{
    key: "length",
    get: function get() {
      return this.end - this.start;
    }
  }, {
    key: "isEmpty",
    get: function get() {
      return this.length === 0;
    }
  }, {
    key: "getByte",
    value: function getByte() {
      if (this.pos >= this.end) {
        return -1;
      }

      return this.bytes[this.pos++];
    }
  }, {
    key: "getBytes",
    value: function getBytes(length) {
      var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var bytes = this.bytes;
      var pos = this.pos;
      var strEnd = this.end;

      if (!length) {
        var _subarray = bytes.subarray(pos, strEnd);

        return forceClamped ? new Uint8ClampedArray(_subarray) : _subarray;
      }

      var end = pos + length;

      if (end > strEnd) {
        end = strEnd;
      }

      this.pos = end;
      var subarray = bytes.subarray(pos, end);
      return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
    }
  }, {
    key: "getByteRange",
    value: function getByteRange(begin, end) {
      if (begin < 0) {
        begin = 0;
      }

      if (end > this.end) {
        end = this.end;
      }

      return this.bytes.subarray(begin, end);
    }
  }, {
    key: "reset",
    value: function reset() {
      this.pos = this.start;
    }
  }, {
    key: "moveStart",
    value: function moveStart() {
      this.start = this.pos;
    }
  }, {
    key: "makeSubStream",
    value: function makeSubStream(start, length) {
      var dict = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      return new Stream(this.bytes.buffer, start, length, dict);
    }
  }]);

  return Stream;
}(_base_stream.BaseStream);

exports.Stream = Stream;

var StringStream = /*#__PURE__*/function (_Stream) {
  _inherits(StringStream, _Stream);

  var _super2 = _createSuper(StringStream);

  function StringStream(str) {
    _classCallCheck(this, StringStream);

    return _super2.call(this, (0, _util.stringToBytes)(str));
  }

  return _createClass(StringStream);
}(Stream);

exports.StringStream = StringStream;

var NullStream = /*#__PURE__*/function (_Stream2) {
  _inherits(NullStream, _Stream2);

  var _super3 = _createSuper(NullStream);

  function NullStream() {
    _classCallCheck(this, NullStream);

    return _super3.call(this, new Uint8Array(0));
  }

  return _createClass(NullStream);
}(Stream);

exports.NullStream = NullStream;

/***/ }),
/* 153 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Page = exports.PDFDocument = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _core_utils = __w_pdfjs_require__(150);

var _primitives = __w_pdfjs_require__(147);

var _xfa_fonts = __w_pdfjs_require__(154);

var _stream = __w_pdfjs_require__(152);

var _annotation = __w_pdfjs_require__(164);

var _base_stream = __w_pdfjs_require__(151);

var _crypto = __w_pdfjs_require__(215);

var _catalog = __w_pdfjs_require__(206);

var _cleanup_helper = __w_pdfjs_require__(208);

var _parser = __w_pdfjs_require__(169);

var _object_loader = __w_pdfjs_require__(213);

var _operator_list = __w_pdfjs_require__(204);

var _evaluator = __w_pdfjs_require__(167);

var _decode_stream = __w_pdfjs_require__(171);

var _struct_tree = __w_pdfjs_require__(212);

var _factory = __w_pdfjs_require__(217);

var _xref = __w_pdfjs_require__(241);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var DEFAULT_USER_UNIT = 1.0;
var LETTER_SIZE_MEDIABOX = [0, 0, 612, 792];

var Page = /*#__PURE__*/function () {
  function Page(_ref) {
    var pdfManager = _ref.pdfManager,
        xref = _ref.xref,
        pageIndex = _ref.pageIndex,
        pageDict = _ref.pageDict,
        ref = _ref.ref,
        globalIdFactory = _ref.globalIdFactory,
        fontCache = _ref.fontCache,
        builtInCMapCache = _ref.builtInCMapCache,
        standardFontDataCache = _ref.standardFontDataCache,
        globalImageCache = _ref.globalImageCache,
        nonBlendModesSet = _ref.nonBlendModesSet,
        xfaFactory = _ref.xfaFactory;

    _classCallCheck(this, Page);

    this.pdfManager = pdfManager;
    this.pageIndex = pageIndex;
    this.pageDict = pageDict;
    this.xref = xref;
    this.ref = ref;
    this.fontCache = fontCache;
    this.builtInCMapCache = builtInCMapCache;
    this.standardFontDataCache = standardFontDataCache;
    this.globalImageCache = globalImageCache;
    this.nonBlendModesSet = nonBlendModesSet;
    this.evaluatorOptions = pdfManager.evaluatorOptions;
    this.resourcesPromise = null;
    this.xfaFactory = xfaFactory;
    var idCounters = {
      obj: 0
    };

    this._localIdFactory = /*#__PURE__*/function (_globalIdFactory) {
      _inherits(_class, _globalIdFactory);

      var _super = _createSuper(_class);

      function _class() {
        _classCallCheck(this, _class);

        return _super.apply(this, arguments);
      }

      _createClass(_class, null, [{
        key: "createObjId",
        value: function createObjId() {
          return "p".concat(pageIndex, "_").concat(++idCounters.obj);
        }
      }, {
        key: "getPageObjId",
        value: function getPageObjId() {
          return "page".concat(ref.toString());
        }
      }]);

      return _class;
    }(globalIdFactory);
  }

  _createClass(Page, [{
    key: "_getInheritableProperty",
    value: function _getInheritableProperty(key) {
      var getArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var value = (0, _core_utils.getInheritableProperty)({
        dict: this.pageDict,
        key: key,
        getArray: getArray,
        stopWhenFound: false
      });

      if (!Array.isArray(value)) {
        return value;
      }

      if (value.length === 1 || !(value[0] instanceof _primitives.Dict)) {
        return value[0];
      }

      return _primitives.Dict.merge({
        xref: this.xref,
        dictArray: value
      });
    }
  }, {
    key: "content",
    get: function get() {
      return this.pageDict.getArray("Contents");
    }
  }, {
    key: "resources",
    get: function get() {
      return (0, _util.shadow)(this, "resources", this._getInheritableProperty("Resources") || _primitives.Dict.empty);
    }
  }, {
    key: "_getBoundingBox",
    value: function _getBoundingBox(name) {
      if (this.xfaData) {
        return this.xfaData.bbox;
      }

      var box = this._getInheritableProperty(name, true);

      if (Array.isArray(box) && box.length === 4) {
        if (box[2] - box[0] !== 0 && box[3] - box[1] !== 0) {
          return box;
        }

        (0, _util.warn)("Empty /".concat(name, " entry."));
      }

      return null;
    }
  }, {
    key: "mediaBox",
    get: function get() {
      return (0, _util.shadow)(this, "mediaBox", this._getBoundingBox("MediaBox") || LETTER_SIZE_MEDIABOX);
    }
  }, {
    key: "cropBox",
    get: function get() {
      return (0, _util.shadow)(this, "cropBox", this._getBoundingBox("CropBox") || this.mediaBox);
    }
  }, {
    key: "userUnit",
    get: function get() {
      var obj = this.pageDict.get("UserUnit");

      if (typeof obj !== "number" || obj <= 0) {
        obj = DEFAULT_USER_UNIT;
      }

      return (0, _util.shadow)(this, "userUnit", obj);
    }
  }, {
    key: "view",
    get: function get() {
      var cropBox = this.cropBox,
          mediaBox = this.mediaBox;
      var view;

      if (cropBox === mediaBox || (0, _util.isArrayEqual)(cropBox, mediaBox)) {
        view = mediaBox;
      } else {
        var box = _util.Util.intersect(cropBox, mediaBox);

        if (box && box[2] - box[0] !== 0 && box[3] - box[1] !== 0) {
          view = box;
        } else {
          (0, _util.warn)("Empty /CropBox and /MediaBox intersection.");
        }
      }

      return (0, _util.shadow)(this, "view", view || mediaBox);
    }
  }, {
    key: "rotate",
    get: function get() {
      var rotate = this._getInheritableProperty("Rotate") || 0;

      if (rotate % 90 !== 0) {
        rotate = 0;
      } else if (rotate >= 360) {
        rotate %= 360;
      } else if (rotate < 0) {
        rotate = (rotate % 360 + 360) % 360;
      }

      return (0, _util.shadow)(this, "rotate", rotate);
    }
  }, {
    key: "_onSubStreamError",
    value: function _onSubStreamError(handler, reason, objId) {
      if (this.evaluatorOptions.ignoreErrors) {
        handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorContentSubStream
        });
        (0, _util.warn)("getContentStream - ignoring sub-stream (".concat(objId, "): \"").concat(reason, "\"."));
        return;
      }

      throw reason;
    }
  }, {
    key: "getContentStream",
    value: function getContentStream(handler) {
      var _this = this;

      return this.pdfManager.ensure(this, "content").then(function (content) {
        if (content instanceof _base_stream.BaseStream) {
          return content;
        }

        if (Array.isArray(content)) {
          return new _decode_stream.StreamsSequenceStream(content, _this._onSubStreamError.bind(_this, handler));
        }

        return new _stream.NullStream();
      });
    }
  }, {
    key: "xfaData",
    get: function get() {
      return (0, _util.shadow)(this, "xfaData", this.xfaFactory ? {
        bbox: this.xfaFactory.getBoundingBox(this.pageIndex)
      } : null);
    }
  }, {
    key: "save",
    value: function save(handler, task, annotationStorage) {
      var partialEvaluator = new _evaluator.PartialEvaluator({
        xref: this.xref,
        handler: handler,
        pageIndex: this.pageIndex,
        idFactory: this._localIdFactory,
        fontCache: this.fontCache,
        builtInCMapCache: this.builtInCMapCache,
        standardFontDataCache: this.standardFontDataCache,
        globalImageCache: this.globalImageCache,
        options: this.evaluatorOptions
      });
      return this._parsedAnnotations.then(function (annotations) {
        var newRefsPromises = [];

        var _iterator = _createForOfIteratorHelper(annotations),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var annotation = _step.value;

            if (!annotation.mustBePrinted(annotationStorage)) {
              continue;
            }

            newRefsPromises.push(annotation.save(partialEvaluator, task, annotationStorage)["catch"](function (reason) {
              (0, _util.warn)("save - ignoring annotation data during " + "\"".concat(task.name, "\" task: \"").concat(reason, "\"."));
              return null;
            }));
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        return Promise.all(newRefsPromises);
      });
    }
  }, {
    key: "loadResources",
    value: function loadResources(keys) {
      var _this2 = this;

      if (!this.resourcesPromise) {
        this.resourcesPromise = this.pdfManager.ensure(this, "resources");
      }

      return this.resourcesPromise.then(function () {
        var objectLoader = new _object_loader.ObjectLoader(_this2.resources, keys, _this2.xref);
        return objectLoader.load();
      });
    }
  }, {
    key: "getOperatorList",
    value: function getOperatorList(_ref2) {
      var _this3 = this;

      var handler = _ref2.handler,
          sink = _ref2.sink,
          task = _ref2.task,
          intent = _ref2.intent,
          cacheKey = _ref2.cacheKey,
          _ref2$annotationStora = _ref2.annotationStorage,
          annotationStorage = _ref2$annotationStora === void 0 ? null : _ref2$annotationStora;
      var contentStreamPromise = this.getContentStream(handler);
      var resourcesPromise = this.loadResources(["ColorSpace", "ExtGState", "Font", "Pattern", "Properties", "Shading", "XObject"]);
      var partialEvaluator = new _evaluator.PartialEvaluator({
        xref: this.xref,
        handler: handler,
        pageIndex: this.pageIndex,
        idFactory: this._localIdFactory,
        fontCache: this.fontCache,
        builtInCMapCache: this.builtInCMapCache,
        standardFontDataCache: this.standardFontDataCache,
        globalImageCache: this.globalImageCache,
        options: this.evaluatorOptions
      });
      var dataPromises = Promise.all([contentStreamPromise, resourcesPromise]);
      var pageListPromise = dataPromises.then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 1),
            contentStream = _ref4[0];

        var opList = new _operator_list.OperatorList(intent, sink);
        handler.send("StartRenderPage", {
          transparency: partialEvaluator.hasBlendModes(_this3.resources, _this3.nonBlendModesSet),
          pageIndex: _this3.pageIndex,
          cacheKey: cacheKey
        });
        return partialEvaluator.getOperatorList({
          stream: contentStream,
          task: task,
          resources: _this3.resources,
          operatorList: opList
        }).then(function () {
          return opList;
        });
      });
      return Promise.all([pageListPromise, this._parsedAnnotations]).then(function (_ref5) {
        var _ref6 = _slicedToArray(_ref5, 2),
            pageOpList = _ref6[0],
            annotations = _ref6[1];

        if (annotations.length === 0 || intent & _util.RenderingIntentFlag.ANNOTATIONS_DISABLE) {
          pageOpList.flush(true);
          return {
            length: pageOpList.totalLength
          };
        }

        var renderForms = !!(intent & _util.RenderingIntentFlag.ANNOTATIONS_FORMS),
            intentAny = !!(intent & _util.RenderingIntentFlag.ANY),
            intentDisplay = !!(intent & _util.RenderingIntentFlag.DISPLAY),
            intentPrint = !!(intent & _util.RenderingIntentFlag.PRINT);
        var opListPromises = [];

        var _iterator2 = _createForOfIteratorHelper(annotations),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var annotation = _step2.value;

            if (intentAny || intentDisplay && annotation.mustBeViewed(annotationStorage) || intentPrint && annotation.mustBePrinted(annotationStorage)) {
              opListPromises.push(annotation.getOperatorList(partialEvaluator, task, intent, renderForms, annotationStorage)["catch"](function (reason) {
                (0, _util.warn)("getOperatorList - ignoring annotation data during " + "\"".concat(task.name, "\" task: \"").concat(reason, "\"."));
                return null;
              }));
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }

        return Promise.all(opListPromises).then(function (opLists) {
          pageOpList.addOp(_util.OPS.beginAnnotations, []);

          var _iterator3 = _createForOfIteratorHelper(opLists),
              _step3;

          try {
            for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
              var opList = _step3.value;
              pageOpList.addOpList(opList);
            }
          } catch (err) {
            _iterator3.e(err);
          } finally {
            _iterator3.f();
          }

          pageOpList.addOp(_util.OPS.endAnnotations, []);
          pageOpList.flush(true);
          return {
            length: pageOpList.totalLength
          };
        });
      });
    }
  }, {
    key: "extractTextContent",
    value: function extractTextContent(_ref7) {
      var _this4 = this;

      var handler = _ref7.handler,
          task = _ref7.task,
          includeMarkedContent = _ref7.includeMarkedContent,
          sink = _ref7.sink,
          combineTextItems = _ref7.combineTextItems;
      var contentStreamPromise = this.getContentStream(handler);
      var resourcesPromise = this.loadResources(["ExtGState", "Font", "Properties", "XObject"]);
      var dataPromises = Promise.all([contentStreamPromise, resourcesPromise]);
      return dataPromises.then(function (_ref8) {
        var _ref9 = _slicedToArray(_ref8, 1),
            contentStream = _ref9[0];

        var partialEvaluator = new _evaluator.PartialEvaluator({
          xref: _this4.xref,
          handler: handler,
          pageIndex: _this4.pageIndex,
          idFactory: _this4._localIdFactory,
          fontCache: _this4.fontCache,
          builtInCMapCache: _this4.builtInCMapCache,
          standardFontDataCache: _this4.standardFontDataCache,
          globalImageCache: _this4.globalImageCache,
          options: _this4.evaluatorOptions
        });
        return partialEvaluator.getTextContent({
          stream: contentStream,
          task: task,
          resources: _this4.resources,
          includeMarkedContent: includeMarkedContent,
          combineTextItems: combineTextItems,
          sink: sink,
          viewBox: _this4.view
        });
      });
    }
  }, {
    key: "getStructTree",
    value: function () {
      var _getStructTree = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
        var structTreeRoot, structTree;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return this.pdfManager.ensureCatalog("structTreeRoot");

              case 2:
                structTreeRoot = _context.sent;

                if (structTreeRoot) {
                  _context.next = 5;
                  break;
                }

                return _context.abrupt("return", null);

              case 5:
                _context.next = 7;
                return this.pdfManager.ensure(this, "_parseStructTree", [structTreeRoot]);

              case 7:
                structTree = _context.sent;
                return _context.abrupt("return", structTree.serializable);

              case 9:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function getStructTree() {
        return _getStructTree.apply(this, arguments);
      }

      return getStructTree;
    }()
  }, {
    key: "_parseStructTree",
    value: function _parseStructTree(structTreeRoot) {
      var tree = new _struct_tree.StructTreePage(structTreeRoot, this.pageDict);
      tree.parse();
      return tree;
    }
  }, {
    key: "getAnnotationsData",
    value: function getAnnotationsData(intent) {
      return this._parsedAnnotations.then(function (annotations) {
        var annotationsData = [];

        if (annotations.length === 0) {
          return annotationsData;
        }

        var intentAny = !!(intent & _util.RenderingIntentFlag.ANY),
            intentDisplay = !!(intent & _util.RenderingIntentFlag.DISPLAY),
            intentPrint = !!(intent & _util.RenderingIntentFlag.PRINT);

        var _iterator4 = _createForOfIteratorHelper(annotations),
            _step4;

        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var annotation = _step4.value;

            if (intentAny || intentDisplay && annotation.viewable || intentPrint && annotation.printable) {
              annotationsData.push(annotation.data);
            }
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }

        return annotationsData;
      });
    }
  }, {
    key: "annotations",
    get: function get() {
      var annots = this._getInheritableProperty("Annots");

      return (0, _util.shadow)(this, "annotations", Array.isArray(annots) ? annots : []);
    }
  }, {
    key: "_parsedAnnotations",
    get: function get() {
      var _this5 = this;

      var parsedAnnotations = this.pdfManager.ensure(this, "annotations").then(function () {
        var annotationPromises = [];

        var _iterator5 = _createForOfIteratorHelper(_this5.annotations),
            _step5;

        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var annotationRef = _step5.value;
            annotationPromises.push(_annotation.AnnotationFactory.create(_this5.xref, annotationRef, _this5.pdfManager, _this5._localIdFactory, false)["catch"](function (reason) {
              (0, _util.warn)("_parsedAnnotations: \"".concat(reason, "\"."));
              return null;
            }));
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }

        return Promise.all(annotationPromises).then(function (annotations) {
          return annotations.filter(function (annotation) {
            return !!annotation;
          });
        });
      });
      return (0, _util.shadow)(this, "_parsedAnnotations", parsedAnnotations);
    }
  }, {
    key: "jsActions",
    get: function get() {
      var actions = (0, _core_utils.collectActions)(this.xref, this.pageDict, _util.PageActionEventType);
      return (0, _util.shadow)(this, "jsActions", actions);
    }
  }]);

  return Page;
}();

exports.Page = Page;
var PDF_HEADER_SIGNATURE = new Uint8Array([0x25, 0x50, 0x44, 0x46, 0x2d]);
var STARTXREF_SIGNATURE = new Uint8Array([0x73, 0x74, 0x61, 0x72, 0x74, 0x78, 0x72, 0x65, 0x66]);
var ENDOBJ_SIGNATURE = new Uint8Array([0x65, 0x6e, 0x64, 0x6f, 0x62, 0x6a]);
var FINGERPRINT_FIRST_BYTES = 1024;
var EMPTY_FINGERPRINT = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
var PDF_HEADER_VERSION_REGEXP = /^[1-9]\.\d$/;

function find(stream, signature) {
  var limit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1024;
  var backwards = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  var signatureLength = signature.length;
  var scanBytes = stream.peekBytes(limit);
  var scanLength = scanBytes.length - signatureLength;

  if (scanLength <= 0) {
    return false;
  }

  if (backwards) {
    var signatureEnd = signatureLength - 1;
    var pos = scanBytes.length - 1;

    while (pos >= signatureEnd) {
      var j = 0;

      while (j < signatureLength && scanBytes[pos - j] === signature[signatureEnd - j]) {
        j++;
      }

      if (j >= signatureLength) {
        stream.pos += pos - signatureEnd;
        return true;
      }

      pos--;
    }
  } else {
    var _pos = 0;

    while (_pos <= scanLength) {
      var _j = 0;

      while (_j < signatureLength && scanBytes[_pos + _j] === signature[_j]) {
        _j++;
      }

      if (_j >= signatureLength) {
        stream.pos += _pos;
        return true;
      }

      _pos++;
    }
  }

  return false;
}

var PDFDocument = /*#__PURE__*/function () {
  function PDFDocument(pdfManager, arg) {
    _classCallCheck(this, PDFDocument);

    var stream;

    if (arg instanceof _base_stream.BaseStream) {
      stream = arg;
    } else if ((0, _util.isArrayBuffer)(arg)) {
      stream = new _stream.Stream(arg);
    } else {
      throw new Error("PDFDocument: Unknown argument type");
    }

    if (stream.length <= 0) {
      throw new _util.InvalidPDFException("The PDF file is empty, i.e. its size is zero bytes.");
    }

    this.pdfManager = pdfManager;
    this.stream = stream;
    this.xref = new _xref.XRef(stream, pdfManager);
    this._pagePromises = new Map();
    this._version = null;
    var idCounters = {
      font: 0
    };

    this._globalIdFactory = /*#__PURE__*/function () {
      function _class2() {
        _classCallCheck(this, _class2);
      }

      _createClass(_class2, null, [{
        key: "getDocId",
        value: function getDocId() {
          return "g_".concat(pdfManager.docId);
        }
      }, {
        key: "createFontId",
        value: function createFontId() {
          return "f".concat(++idCounters.font);
        }
      }, {
        key: "createObjId",
        value: function createObjId() {
          (0, _util.unreachable)("Abstract method `createObjId` called.");
        }
      }, {
        key: "getPageObjId",
        value: function getPageObjId() {
          (0, _util.unreachable)("Abstract method `getPageObjId` called.");
        }
      }]);

      return _class2;
    }();
  }

  _createClass(PDFDocument, [{
    key: "parse",
    value: function parse(recoveryMode) {
      this.xref.parse(recoveryMode);
      this.catalog = new _catalog.Catalog(this.pdfManager, this.xref);

      if (this.catalog.version) {
        this._version = this.catalog.version;
      }
    }
  }, {
    key: "linearization",
    get: function get() {
      var linearization = null;

      try {
        linearization = _parser.Linearization.create(this.stream);
      } catch (err) {
        if (err instanceof _core_utils.MissingDataException) {
          throw err;
        }

        (0, _util.info)(err);
      }

      return (0, _util.shadow)(this, "linearization", linearization);
    }
  }, {
    key: "startXRef",
    get: function get() {
      var stream = this.stream;
      var startXRef = 0;

      if (this.linearization) {
        stream.reset();

        if (find(stream, ENDOBJ_SIGNATURE)) {
          startXRef = stream.pos + 6 - stream.start;
        }
      } else {
        var step = 1024;
        var startXRefLength = STARTXREF_SIGNATURE.length;
        var found = false,
            pos = stream.end;

        while (!found && pos > 0) {
          pos -= step - startXRefLength;

          if (pos < 0) {
            pos = 0;
          }

          stream.pos = pos;
          found = find(stream, STARTXREF_SIGNATURE, step, true);
        }

        if (found) {
          stream.skip(9);
          var ch;

          do {
            ch = stream.getByte();
          } while ((0, _core_utils.isWhiteSpace)(ch));

          var str = "";

          while (ch >= 0x20 && ch <= 0x39) {
            str += String.fromCharCode(ch);
            ch = stream.getByte();
          }

          startXRef = parseInt(str, 10);

          if (isNaN(startXRef)) {
            startXRef = 0;
          }
        }
      }

      return (0, _util.shadow)(this, "startXRef", startXRef);
    }
  }, {
    key: "checkHeader",
    value: function checkHeader() {
      var stream = this.stream;
      stream.reset();

      if (!find(stream, PDF_HEADER_SIGNATURE)) {
        return;
      }

      stream.moveStart();
      var MAX_PDF_VERSION_LENGTH = 12;
      var version = "",
          ch;

      while ((ch = stream.getByte()) > 0x20) {
        if (version.length >= MAX_PDF_VERSION_LENGTH) {
          break;
        }

        version += String.fromCharCode(ch);
      }

      if (!this._version) {
        this._version = version.substring(5);
      }
    }
  }, {
    key: "parseStartXRef",
    value: function parseStartXRef() {
      this.xref.setStartXRef(this.startXRef);
    }
  }, {
    key: "numPages",
    get: function get() {
      var num = 0;

      if (this.catalog.hasActualNumPages) {
        num = this.catalog.numPages;
      } else if (this.xfaFactory) {
        num = this.xfaFactory.getNumPages();
      } else if (this.linearization) {
        num = this.linearization.numPages;
      } else {
        num = this.catalog.numPages;
      }

      return (0, _util.shadow)(this, "numPages", num);
    }
  }, {
    key: "_hasOnlyDocumentSignatures",
    value: function _hasOnlyDocumentSignatures(fields) {
      var _this6 = this;

      var recursionDepth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var RECURSION_LIMIT = 10;

      if (!Array.isArray(fields)) {
        return false;
      }

      return fields.every(function (field) {
        field = _this6.xref.fetchIfRef(field);

        if (!(field instanceof _primitives.Dict)) {
          return false;
        }

        if (field.has("Kids")) {
          if (++recursionDepth > RECURSION_LIMIT) {
            (0, _util.warn)("_hasOnlyDocumentSignatures: maximum recursion depth reached");
            return false;
          }

          return _this6._hasOnlyDocumentSignatures(field.get("Kids"), recursionDepth);
        }

        var isSignature = (0, _primitives.isName)(field.get("FT"), "Sig");
        var rectangle = field.get("Rect");
        var isInvisible = Array.isArray(rectangle) && rectangle.every(function (value) {
          return value === 0;
        });
        return isSignature && isInvisible;
      });
    }
  }, {
    key: "xfaData",
    get: function get() {
      var acroForm = this.catalog.acroForm;

      if (!acroForm) {
        return null;
      }

      var xfa = acroForm.get("XFA");
      var entries = {
        "xdp:xdp": "",
        template: "",
        datasets: "",
        config: "",
        connectionSet: "",
        localeSet: "",
        stylesheet: "",
        "/xdp:xdp": ""
      };

      if (xfa instanceof _base_stream.BaseStream && !xfa.isEmpty) {
        try {
          entries["xdp:xdp"] = (0, _util.stringToUTF8String)(xfa.getString());
          return entries;
        } catch (_) {
          (0, _util.warn)("XFA - Invalid utf-8 string.");
          return null;
        }
      }

      if (!Array.isArray(xfa) || xfa.length === 0) {
        return null;
      }

      for (var i = 0, ii = xfa.length; i < ii; i += 2) {
        var name = void 0;

        if (i === 0) {
          name = "xdp:xdp";
        } else if (i === ii - 2) {
          name = "/xdp:xdp";
        } else {
          name = xfa[i];
        }

        if (!entries.hasOwnProperty(name)) {
          continue;
        }

        var data = this.xref.fetchIfRef(xfa[i + 1]);

        if (!(data instanceof _base_stream.BaseStream) || data.isEmpty) {
          continue;
        }

        try {
          entries[name] = (0, _util.stringToUTF8String)(data.getString());
        } catch (_) {
          (0, _util.warn)("XFA - Invalid utf-8 string.");
          return null;
        }
      }

      return entries;
    }
  }, {
    key: "xfaFactory",
    get: function get() {
      var data;

      if (this.pdfManager.enableXfa && this.catalog.needsRendering && this.formInfo.hasXfa && !this.formInfo.hasAcroForm) {
        data = this.xfaData;
      }

      return (0, _util.shadow)(this, "xfaFactory", data ? new _factory.XFAFactory(data) : null);
    }
  }, {
    key: "isPureXfa",
    get: function get() {
      return this.xfaFactory ? this.xfaFactory.isValid() : false;
    }
  }, {
    key: "htmlForXfa",
    get: function get() {
      return this.xfaFactory ? this.xfaFactory.getPages() : null;
    }
  }, {
    key: "loadXfaImages",
    value: function () {
      var _loadXfaImages = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee2() {
        var xfaImagesDict, keys, objectLoader, xfaImages, _iterator6, _step6, key, stream;

        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return this.pdfManager.ensureCatalog("xfaImages");

              case 2:
                xfaImagesDict = _context2.sent;

                if (xfaImagesDict) {
                  _context2.next = 5;
                  break;
                }

                return _context2.abrupt("return");

              case 5:
                keys = xfaImagesDict.getKeys();
                objectLoader = new _object_loader.ObjectLoader(xfaImagesDict, keys, this.xref);
                _context2.next = 9;
                return objectLoader.load();

              case 9:
                xfaImages = new Map();
                _iterator6 = _createForOfIteratorHelper(keys);

                try {
                  for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
                    key = _step6.value;
                    stream = xfaImagesDict.get(key);

                    if (stream instanceof _base_stream.BaseStream) {
                      xfaImages.set(key, stream.getBytes());
                    }
                  }
                } catch (err) {
                  _iterator6.e(err);
                } finally {
                  _iterator6.f();
                }

                this.xfaFactory.setImages(xfaImages);

              case 13:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function loadXfaImages() {
        return _loadXfaImages.apply(this, arguments);
      }

      return loadXfaImages;
    }()
  }, {
    key: "loadXfaFonts",
    value: function () {
      var _loadXfaFonts = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee3(handler, task) {
        var acroForm, resources, objectLoader, fontRes, options, partialEvaluator, operatorList, pdfFonts, initialState, fonts, promises, _iterator7, _step7, _step7$value, fontName, font, descriptor, fontFamily, fontWeight, italicAngle, cssFontInfo, missingFonts, reallyMissingFonts, _iterator8, _step8, missing, _iterator9, _step9, _missing, _i2, _arr2, fontInfo, name, dict;

        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return this.pdfManager.ensureCatalog("acroForm");

              case 2:
                acroForm = _context3.sent;

                if (acroForm) {
                  _context3.next = 5;
                  break;
                }

                return _context3.abrupt("return");

              case 5:
                _context3.next = 7;
                return acroForm.getAsync("DR");

              case 7:
                resources = _context3.sent;

                if (resources instanceof _primitives.Dict) {
                  _context3.next = 10;
                  break;
                }

                return _context3.abrupt("return");

              case 10:
                objectLoader = new _object_loader.ObjectLoader(resources, ["Font"], this.xref);
                _context3.next = 13;
                return objectLoader.load();

              case 13:
                fontRes = resources.get("Font");

                if (fontRes instanceof _primitives.Dict) {
                  _context3.next = 16;
                  break;
                }

                return _context3.abrupt("return");

              case 16:
                options = Object.assign(Object.create(null), this.pdfManager.evaluatorOptions);
                options.useSystemFonts = false;
                partialEvaluator = new _evaluator.PartialEvaluator({
                  xref: this.xref,
                  handler: handler,
                  pageIndex: -1,
                  idFactory: this._globalIdFactory,
                  fontCache: this.catalog.fontCache,
                  builtInCMapCache: this.catalog.builtInCMapCache,
                  standardFontDataCache: this.catalog.standardFontDataCache,
                  options: options
                });
                operatorList = new _operator_list.OperatorList();
                pdfFonts = [];

                _context3.t0 = function clone() {
                  return this;
                };

                initialState = {
                  get font() {
                    return pdfFonts[pdfFonts.length - 1];
                  },

                  set font(font) {
                    pdfFonts.push(font);
                  },

                  clone: _context3.t0
                };
                fonts = new Map();
                fontRes.forEach(function (fontName, font) {
                  fonts.set(fontName, font);
                });
                promises = [];
                _iterator7 = _createForOfIteratorHelper(fonts);
                _context3.prev = 27;

                _iterator7.s();

              case 29:
                if ((_step7 = _iterator7.n()).done) {
                  _context3.next = 44;
                  break;
                }

                _step7$value = _slicedToArray(_step7.value, 2), fontName = _step7$value[0], font = _step7$value[1];
                descriptor = font.get("FontDescriptor");

                if (descriptor instanceof _primitives.Dict) {
                  _context3.next = 34;
                  break;
                }

                return _context3.abrupt("continue", 42);

              case 34:
                fontFamily = descriptor.get("FontFamily");
                fontFamily = fontFamily.replace(/[ ]+(\d)/g, "$1");
                fontWeight = descriptor.get("FontWeight");
                italicAngle = -descriptor.get("ItalicAngle");
                cssFontInfo = {
                  fontFamily: fontFamily,
                  fontWeight: fontWeight,
                  italicAngle: italicAngle
                };

                if ((0, _core_utils.validateCSSFont)(cssFontInfo)) {
                  _context3.next = 41;
                  break;
                }

                return _context3.abrupt("continue", 42);

              case 41:
                promises.push(partialEvaluator.handleSetFont(resources, [_primitives.Name.get(fontName), 1], null, operatorList, task, initialState, null, cssFontInfo)["catch"](function (reason) {
                  (0, _util.warn)("loadXfaFonts: \"".concat(reason, "\"."));
                  return null;
                }));

              case 42:
                _context3.next = 29;
                break;

              case 44:
                _context3.next = 49;
                break;

              case 46:
                _context3.prev = 46;
                _context3.t1 = _context3["catch"](27);

                _iterator7.e(_context3.t1);

              case 49:
                _context3.prev = 49;

                _iterator7.f();

                return _context3.finish(49);

              case 52:
                _context3.next = 54;
                return Promise.all(promises);

              case 54:
                missingFonts = this.xfaFactory.setFonts(pdfFonts);

                if (missingFonts) {
                  _context3.next = 57;
                  break;
                }

                return _context3.abrupt("return");

              case 57:
                options.ignoreErrors = true;
                promises.length = 0;
                pdfFonts.length = 0;
                reallyMissingFonts = new Set();
                _iterator8 = _createForOfIteratorHelper(missingFonts);

                try {
                  for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
                    missing = _step8.value;

                    if (!(0, _xfa_fonts.getXfaFontName)("".concat(missing, "-Regular"))) {
                      reallyMissingFonts.add(missing);
                    }
                  }
                } catch (err) {
                  _iterator8.e(err);
                } finally {
                  _iterator8.f();
                }

                if (reallyMissingFonts.size) {
                  missingFonts.push("PdfJS-Fallback");
                }

                _iterator9 = _createForOfIteratorHelper(missingFonts);
                _context3.prev = 65;

                _iterator9.s();

              case 67:
                if ((_step9 = _iterator9.n()).done) {
                  _context3.next = 74;
                  break;
                }

                _missing = _step9.value;

                if (!reallyMissingFonts.has(_missing)) {
                  _context3.next = 71;
                  break;
                }

                return _context3.abrupt("continue", 72);

              case 71:
                for (_i2 = 0, _arr2 = [{
                  name: "Regular",
                  fontWeight: 400,
                  italicAngle: 0
                }, {
                  name: "Bold",
                  fontWeight: 700,
                  italicAngle: 0
                }, {
                  name: "Italic",
                  fontWeight: 400,
                  italicAngle: 12
                }, {
                  name: "BoldItalic",
                  fontWeight: 700,
                  italicAngle: 12
                }]; _i2 < _arr2.length; _i2++) {
                  fontInfo = _arr2[_i2];
                  name = "".concat(_missing, "-").concat(fontInfo.name);
                  dict = (0, _xfa_fonts.getXfaFontDict)(name);
                  promises.push(partialEvaluator.handleSetFont(resources, [_primitives.Name.get(name), 1], null, operatorList, task, initialState, dict, {
                    fontFamily: _missing,
                    fontWeight: fontInfo.fontWeight,
                    italicAngle: fontInfo.italicAngle
                  })["catch"](function (reason) {
                    (0, _util.warn)("loadXfaFonts: \"".concat(reason, "\"."));
                    return null;
                  }));
                }

              case 72:
                _context3.next = 67;
                break;

              case 74:
                _context3.next = 79;
                break;

              case 76:
                _context3.prev = 76;
                _context3.t2 = _context3["catch"](65);

                _iterator9.e(_context3.t2);

              case 79:
                _context3.prev = 79;

                _iterator9.f();

                return _context3.finish(79);

              case 82:
                _context3.next = 84;
                return Promise.all(promises);

              case 84:
                this.xfaFactory.appendFonts(pdfFonts, reallyMissingFonts);

              case 85:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this, [[27, 46, 49, 52], [65, 76, 79, 82]]);
      }));

      function loadXfaFonts(_x, _x2) {
        return _loadXfaFonts.apply(this, arguments);
      }

      return loadXfaFonts;
    }()
  }, {
    key: "serializeXfaData",
    value: function () {
      var _serializeXfaData = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee4(annotationStorage) {
        return _regenerator["default"].wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                return _context4.abrupt("return", this.xfaFactory ? this.xfaFactory.serializeData(annotationStorage) : null);

              case 1:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function serializeXfaData(_x3) {
        return _serializeXfaData.apply(this, arguments);
      }

      return serializeXfaData;
    }()
  }, {
    key: "formInfo",
    get: function get() {
      var formInfo = {
        hasFields: false,
        hasAcroForm: false,
        hasXfa: false,
        hasSignatures: false
      };
      var acroForm = this.catalog.acroForm;

      if (!acroForm) {
        return (0, _util.shadow)(this, "formInfo", formInfo);
      }

      try {
        var fields = acroForm.get("Fields");
        var hasFields = Array.isArray(fields) && fields.length > 0;
        formInfo.hasFields = hasFields;
        var xfa = acroForm.get("XFA");
        formInfo.hasXfa = Array.isArray(xfa) && xfa.length > 0 || xfa instanceof _base_stream.BaseStream && !xfa.isEmpty;
        var sigFlags = acroForm.get("SigFlags");
        var hasSignatures = !!(sigFlags & 0x1);

        var hasOnlyDocumentSignatures = hasSignatures && this._hasOnlyDocumentSignatures(fields);

        formInfo.hasAcroForm = hasFields && !hasOnlyDocumentSignatures;
        formInfo.hasSignatures = hasSignatures;
      } catch (ex) {
        if (ex instanceof _core_utils.MissingDataException) {
          throw ex;
        }

        (0, _util.warn)("Cannot fetch form information: \"".concat(ex, "\"."));
      }

      return (0, _util.shadow)(this, "formInfo", formInfo);
    }
  }, {
    key: "documentInfo",
    get: function get() {
      var version = this._version;

      if (typeof version !== "string" || !PDF_HEADER_VERSION_REGEXP.test(version)) {
        (0, _util.warn)("Invalid PDF header version number: ".concat(version));
        version = null;
      }

      var docInfo = {
        PDFFormatVersion: version,
        Language: this.catalog.lang,
        EncryptFilterName: this.xref.encrypt ? this.xref.encrypt.filterName : null,
        IsLinearized: !!this.linearization,
        IsAcroFormPresent: this.formInfo.hasAcroForm,
        IsXFAPresent: this.formInfo.hasXfa,
        IsCollectionPresent: !!this.catalog.collection,
        IsSignaturesPresent: this.formInfo.hasSignatures
      };
      var infoDict;

      try {
        infoDict = this.xref.trailer.get("Info");
      } catch (err) {
        if (err instanceof _core_utils.MissingDataException) {
          throw err;
        }

        (0, _util.info)("The document information dictionary is invalid.");
      }

      if (!(infoDict instanceof _primitives.Dict)) {
        return (0, _util.shadow)(this, "documentInfo", docInfo);
      }

      var _iterator10 = _createForOfIteratorHelper(infoDict.getKeys()),
          _step10;

      try {
        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
          var key = _step10.value;
          var value = infoDict.get(key);

          switch (key) {
            case "Title":
            case "Author":
            case "Subject":
            case "Keywords":
            case "Creator":
            case "Producer":
            case "CreationDate":
            case "ModDate":
              if (typeof value === "string") {
                docInfo[key] = (0, _util.stringToPDFString)(value);
                continue;
              }

              break;

            case "Trapped":
              if (value instanceof _primitives.Name) {
                docInfo[key] = value;
                continue;
              }

              break;

            default:
              var customValue = void 0;

              switch (_typeof(value)) {
                case "string":
                  customValue = (0, _util.stringToPDFString)(value);
                  break;

                case "number":
                case "boolean":
                  customValue = value;
                  break;

                default:
                  if (value instanceof _primitives.Name) {
                    customValue = value;
                  }

                  break;
              }

              if (customValue === undefined) {
                (0, _util.warn)("Bad value, for custom key \"".concat(key, "\", in Info: ").concat(value, "."));
                continue;
              }

              if (!docInfo.Custom) {
                docInfo.Custom = Object.create(null);
              }

              docInfo.Custom[key] = customValue;
              continue;
          }

          (0, _util.warn)("Bad value, for key \"".concat(key, "\", in Info: ").concat(value, "."));
        }
      } catch (err) {
        _iterator10.e(err);
      } finally {
        _iterator10.f();
      }

      return (0, _util.shadow)(this, "documentInfo", docInfo);
    }
  }, {
    key: "fingerprints",
    get: function get() {
      function validate(data) {
        return typeof data === "string" && data.length > 0 && data !== EMPTY_FINGERPRINT;
      }

      function hexString(hash) {
        var buf = [];

        for (var i = 0, ii = hash.length; i < ii; i++) {
          var hex = hash[i].toString(16);
          buf.push(hex.padStart(2, "0"));
        }

        return buf.join("");
      }

      var idArray = this.xref.trailer.get("ID");
      var hashOriginal, hashModified;

      if (Array.isArray(idArray) && validate(idArray[0])) {
        hashOriginal = (0, _util.stringToBytes)(idArray[0]);

        if (idArray[1] !== idArray[0] && validate(idArray[1])) {
          hashModified = (0, _util.stringToBytes)(idArray[1]);
        }
      } else {
        hashOriginal = (0, _crypto.calculateMD5)(this.stream.getByteRange(0, FINGERPRINT_FIRST_BYTES), 0, FINGERPRINT_FIRST_BYTES);
      }

      return (0, _util.shadow)(this, "fingerprints", [hexString(hashOriginal), hashModified ? hexString(hashModified) : null]);
    }
  }, {
    key: "_getLinearizationPage",
    value: function () {
      var _getLinearizationPage2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee5(pageIndex) {
        var catalog, linearization, xref, ref, obj, type;
        return _regenerator["default"].wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                catalog = this.catalog, linearization = this.linearization, xref = this.xref;
                ref = _primitives.Ref.get(linearization.objectNumberFirst, 0);
                _context5.prev = 2;
                _context5.next = 5;
                return xref.fetchAsync(ref);

              case 5:
                obj = _context5.sent;

                if (!(obj instanceof _primitives.Dict)) {
                  _context5.next = 16;
                  break;
                }

                type = obj.getRaw("Type");

                if (!(type instanceof _primitives.Ref)) {
                  _context5.next = 12;
                  break;
                }

                _context5.next = 11;
                return xref.fetchAsync(type);

              case 11:
                type = _context5.sent;

              case 12:
                if (!((0, _primitives.isName)(type, "Page") || !obj.has("Type") && !obj.has("Kids"))) {
                  _context5.next = 16;
                  break;
                }

                if (!catalog.pageKidsCountCache.has(ref)) {
                  catalog.pageKidsCountCache.put(ref, 1);
                }

                if (!catalog.pageIndexCache.has(ref)) {
                  catalog.pageIndexCache.put(ref, 0);
                }

                return _context5.abrupt("return", [obj, ref]);

              case 16:
                throw new _util.FormatError("The Linearization dictionary doesn't point to a valid Page dictionary.");

              case 19:
                _context5.prev = 19;
                _context5.t0 = _context5["catch"](2);
                (0, _util.warn)("_getLinearizationPage: \"".concat(_context5.t0.message, "\"."));
                return _context5.abrupt("return", catalog.getPageDict(pageIndex));

              case 23:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this, [[2, 19]]);
      }));

      function _getLinearizationPage(_x4) {
        return _getLinearizationPage2.apply(this, arguments);
      }

      return _getLinearizationPage;
    }()
  }, {
    key: "getPage",
    value: function getPage(pageIndex) {
      var _this7 = this;

      var cachedPromise = this._pagePromises.get(pageIndex);

      if (cachedPromise) {
        return cachedPromise;
      }

      var catalog = this.catalog,
          linearization = this.linearization,
          xfaFactory = this.xfaFactory;
      var promise;

      if (xfaFactory) {
        promise = Promise.resolve([_primitives.Dict.empty, null]);
      } else if (linearization && linearization.pageFirst === pageIndex) {
        promise = this._getLinearizationPage(pageIndex);
      } else {
        promise = catalog.getPageDict(pageIndex);
      }

      promise = promise.then(function (_ref10) {
        var _ref11 = _slicedToArray(_ref10, 2),
            pageDict = _ref11[0],
            ref = _ref11[1];

        return new Page({
          pdfManager: _this7.pdfManager,
          xref: _this7.xref,
          pageIndex: pageIndex,
          pageDict: pageDict,
          ref: ref,
          globalIdFactory: _this7._globalIdFactory,
          fontCache: catalog.fontCache,
          builtInCMapCache: catalog.builtInCMapCache,
          standardFontDataCache: catalog.standardFontDataCache,
          globalImageCache: catalog.globalImageCache,
          nonBlendModesSet: catalog.nonBlendModesSet,
          xfaFactory: xfaFactory
        });
      });

      this._pagePromises.set(pageIndex, promise);

      return promise;
    }
  }, {
    key: "checkFirstPage",
    value: function () {
      var _checkFirstPage = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee6() {
        var recoveryMode,
            _args6 = arguments;
        return _regenerator["default"].wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                recoveryMode = _args6.length > 0 && _args6[0] !== undefined ? _args6[0] : false;

                if (!recoveryMode) {
                  _context6.next = 3;
                  break;
                }

                return _context6.abrupt("return");

              case 3:
                _context6.prev = 3;
                _context6.next = 6;
                return this.getPage(0);

              case 6:
                _context6.next = 15;
                break;

              case 8:
                _context6.prev = 8;
                _context6.t0 = _context6["catch"](3);

                if (!(_context6.t0 instanceof _core_utils.XRefEntryException)) {
                  _context6.next = 15;
                  break;
                }

                this._pagePromises["delete"](0);

                _context6.next = 14;
                return this.cleanup();

              case 14:
                throw new _core_utils.XRefParseException();

              case 15:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6, this, [[3, 8]]);
      }));

      function checkFirstPage() {
        return _checkFirstPage.apply(this, arguments);
      }

      return checkFirstPage;
    }()
  }, {
    key: "checkLastPage",
    value: function () {
      var _checkLastPage = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee7() {
        var recoveryMode,
            catalog,
            pdfManager,
            numPages,
            pagesTree,
            _iterator11,
            _step11,
            _step11$value,
            pageIndex,
            _step11$value$,
            pageDict,
            ref,
            promise,
            _args7 = arguments;

        return _regenerator["default"].wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                recoveryMode = _args7.length > 0 && _args7[0] !== undefined ? _args7[0] : false;
                catalog = this.catalog, pdfManager = this.pdfManager;
                catalog.setActualNumPages();
                _context7.prev = 3;
                _context7.next = 6;
                return Promise.all([pdfManager.ensureDoc("xfaFactory"), pdfManager.ensureDoc("linearization"), pdfManager.ensureCatalog("numPages")]);

              case 6:
                if (!this.xfaFactory) {
                  _context7.next = 10;
                  break;
                }

                return _context7.abrupt("return");

              case 10:
                if (this.linearization) {
                  numPages = this.linearization.numPages;
                } else {
                  numPages = catalog.numPages;
                }

              case 11:
                if (Number.isInteger(numPages)) {
                  _context7.next = 15;
                  break;
                }

                throw new _util.FormatError("Page count is not an integer.");

              case 15:
                if (!(numPages <= 1)) {
                  _context7.next = 17;
                  break;
                }

                return _context7.abrupt("return");

              case 17:
                _context7.next = 19;
                return this.getPage(numPages - 1);

              case 19:
                _context7.next = 44;
                break;

              case 21:
                _context7.prev = 21;
                _context7.t0 = _context7["catch"](3);

                this._pagePromises["delete"](numPages - 1);

                _context7.next = 26;
                return this.cleanup();

              case 26:
                if (!(_context7.t0 instanceof _core_utils.XRefEntryException && !recoveryMode)) {
                  _context7.next = 28;
                  break;
                }

                throw new _core_utils.XRefParseException();

              case 28:
                (0, _util.warn)("checkLastPage - invalid /Pages tree /Count: ".concat(numPages, "."));
                _context7.prev = 29;
                _context7.next = 32;
                return catalog.getAllPageDicts(recoveryMode);

              case 32:
                pagesTree = _context7.sent;
                _context7.next = 41;
                break;

              case 35:
                _context7.prev = 35;
                _context7.t1 = _context7["catch"](29);

                if (!(_context7.t1 instanceof _core_utils.XRefEntryException && !recoveryMode)) {
                  _context7.next = 39;
                  break;
                }

                throw new _core_utils.XRefParseException();

              case 39:
                catalog.setActualNumPages(1);
                return _context7.abrupt("return");

              case 41:
                _iterator11 = _createForOfIteratorHelper(pagesTree);

                try {
                  for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
                    _step11$value = _slicedToArray(_step11.value, 2), pageIndex = _step11$value[0], _step11$value$ = _slicedToArray(_step11$value[1], 2), pageDict = _step11$value$[0], ref = _step11$value$[1];
                    promise = void 0;

                    if (pageDict instanceof Error) {
                      promise = Promise.reject(pageDict);
                      promise["catch"](function () {});
                    } else {
                      promise = Promise.resolve(new Page({
                        pdfManager: pdfManager,
                        xref: this.xref,
                        pageIndex: pageIndex,
                        pageDict: pageDict,
                        ref: ref,
                        globalIdFactory: this._globalIdFactory,
                        fontCache: catalog.fontCache,
                        builtInCMapCache: catalog.builtInCMapCache,
                        standardFontDataCache: catalog.standardFontDataCache,
                        globalImageCache: catalog.globalImageCache,
                        nonBlendModesSet: catalog.nonBlendModesSet,
                        xfaFactory: null
                      }));
                    }

                    this._pagePromises.set(pageIndex, promise);
                  }
                } catch (err) {
                  _iterator11.e(err);
                } finally {
                  _iterator11.f();
                }

                catalog.setActualNumPages(pagesTree.size);

              case 44:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this, [[3, 21], [29, 35]]);
      }));

      function checkLastPage() {
        return _checkLastPage.apply(this, arguments);
      }

      return checkLastPage;
    }()
  }, {
    key: "fontFallback",
    value: function fontFallback(id, handler) {
      return this.catalog.fontFallback(id, handler);
    }
  }, {
    key: "cleanup",
    value: function () {
      var _cleanup = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee8() {
        var manuallyTriggered,
            _args8 = arguments;
        return _regenerator["default"].wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                manuallyTriggered = _args8.length > 0 && _args8[0] !== undefined ? _args8[0] : false;
                return _context8.abrupt("return", this.catalog ? this.catalog.cleanup(manuallyTriggered) : (0, _cleanup_helper.clearGlobalCaches)());

              case 2:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, this);
      }));

      function cleanup() {
        return _cleanup.apply(this, arguments);
      }

      return cleanup;
    }()
  }, {
    key: "_collectFieldObjects",
    value: function _collectFieldObjects(name, fieldRef, promises) {
      var field = this.xref.fetchIfRef(fieldRef);

      if (field.has("T")) {
        var partName = (0, _util.stringToPDFString)(field.get("T"));

        if (name === "") {
          name = partName;
        } else {
          name = "".concat(name, ".").concat(partName);
        }
      }

      if (!promises.has(name)) {
        promises.set(name, []);
      }

      promises.get(name).push(_annotation.AnnotationFactory.create(this.xref, fieldRef, this.pdfManager, this._localIdFactory, true).then(function (annotation) {
        return annotation && annotation.getFieldObject();
      })["catch"](function (reason) {
        (0, _util.warn)("_collectFieldObjects: \"".concat(reason, "\"."));
        return null;
      }));

      if (field.has("Kids")) {
        var kids = field.get("Kids");

        var _iterator12 = _createForOfIteratorHelper(kids),
            _step12;

        try {
          for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
            var kid = _step12.value;

            this._collectFieldObjects(name, kid, promises);
          }
        } catch (err) {
          _iterator12.e(err);
        } finally {
          _iterator12.f();
        }
      }
    }
  }, {
    key: "fieldObjects",
    get: function get() {
      if (!this.formInfo.hasFields) {
        return (0, _util.shadow)(this, "fieldObjects", Promise.resolve(null));
      }

      var allFields = Object.create(null);
      var fieldPromises = new Map();

      var _iterator13 = _createForOfIteratorHelper(this.catalog.acroForm.get("Fields")),
          _step13;

      try {
        for (_iterator13.s(); !(_step13 = _iterator13.n()).done;) {
          var fieldRef = _step13.value;

          this._collectFieldObjects("", fieldRef, fieldPromises);
        }
      } catch (err) {
        _iterator13.e(err);
      } finally {
        _iterator13.f();
      }

      var allPromises = [];

      var _iterator14 = _createForOfIteratorHelper(fieldPromises),
          _step14;

      try {
        var _loop = function _loop() {
          var _step14$value = _slicedToArray(_step14.value, 2),
              name = _step14$value[0],
              promises = _step14$value[1];

          allPromises.push(Promise.all(promises).then(function (fields) {
            fields = fields.filter(function (field) {
              return !!field;
            });

            if (fields.length > 0) {
              allFields[name] = fields;
            }
          }));
        };

        for (_iterator14.s(); !(_step14 = _iterator14.n()).done;) {
          _loop();
        }
      } catch (err) {
        _iterator14.e(err);
      } finally {
        _iterator14.f();
      }

      return (0, _util.shadow)(this, "fieldObjects", Promise.all(allPromises).then(function () {
        return allFields;
      }));
    }
  }, {
    key: "hasJSActions",
    get: function get() {
      var promise = this.pdfManager.ensureDoc("_parseHasJSActions");
      return (0, _util.shadow)(this, "hasJSActions", promise);
    }
  }, {
    key: "_parseHasJSActions",
    value: function () {
      var _parseHasJSActions2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee9() {
        var _yield$Promise$all, _yield$Promise$all2, catalogJsActions, fieldObjects;

        return _regenerator["default"].wrap(function _callee9$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                _context9.next = 2;
                return Promise.all([this.pdfManager.ensureCatalog("jsActions"), this.pdfManager.ensureDoc("fieldObjects")]);

              case 2:
                _yield$Promise$all = _context9.sent;
                _yield$Promise$all2 = _slicedToArray(_yield$Promise$all, 2);
                catalogJsActions = _yield$Promise$all2[0];
                fieldObjects = _yield$Promise$all2[1];

                if (!catalogJsActions) {
                  _context9.next = 8;
                  break;
                }

                return _context9.abrupt("return", true);

              case 8:
                if (!fieldObjects) {
                  _context9.next = 10;
                  break;
                }

                return _context9.abrupt("return", Object.values(fieldObjects).some(function (fieldObject) {
                  return fieldObject.some(function (object) {
                    return object.actions !== null;
                  });
                }));

              case 10:
                return _context9.abrupt("return", false);

              case 11:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee9, this);
      }));

      function _parseHasJSActions() {
        return _parseHasJSActions2.apply(this, arguments);
      }

      return _parseHasJSActions;
    }()
  }, {
    key: "calculationOrderIds",
    get: function get() {
      var acroForm = this.catalog.acroForm;

      if (!acroForm || !acroForm.has("CO")) {
        return (0, _util.shadow)(this, "calculationOrderIds", null);
      }

      var calculationOrder = acroForm.get("CO");

      if (!Array.isArray(calculationOrder) || calculationOrder.length === 0) {
        return (0, _util.shadow)(this, "calculationOrderIds", null);
      }

      var ids = [];

      var _iterator15 = _createForOfIteratorHelper(calculationOrder),
          _step15;

      try {
        for (_iterator15.s(); !(_step15 = _iterator15.n()).done;) {
          var id = _step15.value;

          if (id instanceof _primitives.Ref) {
            ids.push(id.toString());
          }
        }
      } catch (err) {
        _iterator15.e(err);
      } finally {
        _iterator15.f();
      }

      if (ids.length === 0) {
        return (0, _util.shadow)(this, "calculationOrderIds", null);
      }

      return (0, _util.shadow)(this, "calculationOrderIds", ids);
    }
  }]);

  return PDFDocument;
}();

exports.PDFDocument = PDFDocument;

/***/ }),
/* 154 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getXfaFontDict = getXfaFontDict;
exports.getXfaFontName = getXfaFontName;

var _calibri_factors = __w_pdfjs_require__(155);

var _primitives = __w_pdfjs_require__(147);

var _helvetica_factors = __w_pdfjs_require__(156);

var _liberationsans_widths = __w_pdfjs_require__(157);

var _myriadpro_factors = __w_pdfjs_require__(158);

var _segoeui_factors = __w_pdfjs_require__(159);

var _core_utils = __w_pdfjs_require__(150);

var _fonts_utils = __w_pdfjs_require__(160);

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var getXFAFontMap = (0, _core_utils.getLookupTableFactory)(function (t) {
  t["MyriadPro-Regular"] = t["PdfJS-Fallback-Regular"] = {
    name: "LiberationSans-Regular",
    factors: _myriadpro_factors.MyriadProRegularFactors,
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping,
    metrics: _myriadpro_factors.MyriadProRegularMetrics
  };
  t["MyriadPro-Bold"] = t["PdfJS-Fallback-Bold"] = {
    name: "LiberationSans-Bold",
    factors: _myriadpro_factors.MyriadProBoldFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping,
    metrics: _myriadpro_factors.MyriadProBoldMetrics
  };
  t["MyriadPro-It"] = t["MyriadPro-Italic"] = t["PdfJS-Fallback-Italic"] = {
    name: "LiberationSans-Italic",
    factors: _myriadpro_factors.MyriadProItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping,
    metrics: _myriadpro_factors.MyriadProItalicMetrics
  };
  t["MyriadPro-BoldIt"] = t["MyriadPro-BoldItalic"] = t["PdfJS-Fallback-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    factors: _myriadpro_factors.MyriadProBoldItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping,
    metrics: _myriadpro_factors.MyriadProBoldItalicMetrics
  };
  t.ArialMT = t.Arial = t["Arial-Regular"] = {
    name: "LiberationSans-Regular",
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping
  };
  t["Arial-BoldMT"] = t["Arial-Bold"] = {
    name: "LiberationSans-Bold",
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping
  };
  t["Arial-ItalicMT"] = t["Arial-Italic"] = {
    name: "LiberationSans-Italic",
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping
  };
  t["Arial-BoldItalicMT"] = t["Arial-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping
  };
  t["Calibri-Regular"] = {
    name: "LiberationSans-Regular",
    factors: _calibri_factors.CalibriRegularFactors,
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping,
    metrics: _calibri_factors.CalibriRegularMetrics
  };
  t["Calibri-Bold"] = {
    name: "LiberationSans-Bold",
    factors: _calibri_factors.CalibriBoldFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping,
    metrics: _calibri_factors.CalibriBoldMetrics
  };
  t["Calibri-Italic"] = {
    name: "LiberationSans-Italic",
    factors: _calibri_factors.CalibriItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping,
    metrics: _calibri_factors.CalibriItalicMetrics
  };
  t["Calibri-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    factors: _calibri_factors.CalibriBoldItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping,
    metrics: _calibri_factors.CalibriBoldItalicMetrics
  };
  t["Segoeui-Regular"] = {
    name: "LiberationSans-Regular",
    factors: _segoeui_factors.SegoeuiRegularFactors,
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping,
    metrics: _segoeui_factors.SegoeuiRegularMetrics
  };
  t["Segoeui-Bold"] = {
    name: "LiberationSans-Bold",
    factors: _segoeui_factors.SegoeuiBoldFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping,
    metrics: _segoeui_factors.SegoeuiBoldMetrics
  };
  t["Segoeui-Italic"] = {
    name: "LiberationSans-Italic",
    factors: _segoeui_factors.SegoeuiItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping,
    metrics: _segoeui_factors.SegoeuiItalicMetrics
  };
  t["Segoeui-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    factors: _segoeui_factors.SegoeuiBoldItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping,
    metrics: _segoeui_factors.SegoeuiBoldItalicMetrics
  };
  t["Helvetica-Regular"] = t.Helvetica = {
    name: "LiberationSans-Regular",
    factors: _helvetica_factors.HelveticaRegularFactors,
    baseWidths: _liberationsans_widths.LiberationSansRegularWidths,
    baseMapping: _liberationsans_widths.LiberationSansRegularMapping,
    metrics: _helvetica_factors.HelveticaRegularMetrics
  };
  t["Helvetica-Bold"] = {
    name: "LiberationSans-Bold",
    factors: _helvetica_factors.HelveticaBoldFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldMapping,
    metrics: _helvetica_factors.HelveticaBoldMetrics
  };
  t["Helvetica-Italic"] = {
    name: "LiberationSans-Italic",
    factors: _helvetica_factors.HelveticaItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansItalicMapping,
    metrics: _helvetica_factors.HelveticaItalicMetrics
  };
  t["Helvetica-BoldItalic"] = {
    name: "LiberationSans-BoldItalic",
    factors: _helvetica_factors.HelveticaBoldItalicFactors,
    baseWidths: _liberationsans_widths.LiberationSansBoldItalicWidths,
    baseMapping: _liberationsans_widths.LiberationSansBoldItalicMapping,
    metrics: _helvetica_factors.HelveticaBoldItalicMetrics
  };
});

function getXfaFontName(name) {
  var fontName = (0, _fonts_utils.normalizeFontName)(name);
  var fontMap = getXFAFontMap();
  return fontMap[fontName];
}

function getXfaFontWidths(name) {
  var info = getXfaFontName(name);

  if (!info) {
    return null;
  }

  var baseWidths = info.baseWidths,
      baseMapping = info.baseMapping,
      factors = info.factors;
  var rescaledBaseWidths;

  if (!factors) {
    rescaledBaseWidths = baseWidths;
  } else {
    rescaledBaseWidths = baseWidths.map(function (w, i) {
      return w * factors[i];
    });
  }

  var currentCode = -2;
  var currentArray;
  var newWidths = [];

  var _iterator = _createForOfIteratorHelper(baseMapping.map(function (charUnicode, index) {
    return [charUnicode, index];
  }).sort(function (_ref, _ref2) {
    var _ref3 = _slicedToArray(_ref, 1),
        unicode1 = _ref3[0];

    var _ref4 = _slicedToArray(_ref2, 1),
        unicode2 = _ref4[0];

    return unicode1 - unicode2;
  })),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var _step$value = _slicedToArray(_step.value, 2),
          unicode = _step$value[0],
          glyphIndex = _step$value[1];

      if (unicode === -1) {
        continue;
      }

      if (unicode === currentCode + 1) {
        currentArray.push(rescaledBaseWidths[glyphIndex]);
        currentCode += 1;
      } else {
        currentCode = unicode;
        currentArray = [rescaledBaseWidths[glyphIndex]];
        newWidths.push(unicode, currentArray);
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return newWidths;
}

function getXfaFontDict(name) {
  var widths = getXfaFontWidths(name);
  var dict = new _primitives.Dict(null);
  dict.set("BaseFont", _primitives.Name.get(name));
  dict.set("Type", _primitives.Name.get("Font"));
  dict.set("Subtype", _primitives.Name.get("CIDFontType2"));
  dict.set("Encoding", _primitives.Name.get("Identity-H"));
  dict.set("CIDToGIDMap", _primitives.Name.get("Identity"));
  dict.set("W", widths);
  dict.set("FirstChar", widths[0]);
  dict.set("LastChar", widths[widths.length - 2] + widths[widths.length - 1].length - 1);
  var descriptor = new _primitives.Dict(null);
  dict.set("FontDescriptor", descriptor);
  var systemInfo = new _primitives.Dict(null);
  systemInfo.set("Ordering", "Identity");
  systemInfo.set("Registry", "Adobe");
  systemInfo.set("Supplement", 0);
  dict.set("CIDSystemInfo", systemInfo);
  return dict;
}

/***/ }),
/* 155 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CalibriRegularMetrics = exports.CalibriRegularFactors = exports.CalibriItalicMetrics = exports.CalibriItalicFactors = exports.CalibriBoldMetrics = exports.CalibriBoldItalicMetrics = exports.CalibriBoldItalicFactors = exports.CalibriBoldFactors = void 0;
var CalibriBoldFactors = [1.3877, 1, 1, 1, 0.97801, 0.92482, 0.89552, 0.91133, 0.81988, 0.97566, 0.98152, 0.93548, 0.93548, 1.2798, 0.85284, 0.92794, 1, 0.96134, 1.54657, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.82845, 0.82845, 0.85284, 0.85284, 0.85284, 0.75859, 0.92138, 0.83908, 0.7762, 0.73293, 0.87289, 0.73133, 0.7514, 0.81921, 0.87356, 0.95958, 0.59526, 0.75727, 0.69225, 1.04924, 0.9121, 0.86943, 0.79795, 0.88198, 0.77958, 0.70864, 0.81055, 0.90399, 0.88653, 0.96017, 0.82577, 0.77892, 0.78257, 0.97507, 1.54657, 0.97507, 0.85284, 0.89552, 0.90176, 0.88762, 0.8785, 0.75241, 0.8785, 0.90518, 0.95015, 0.77618, 0.8785, 0.88401, 0.91916, 0.86304, 0.88401, 0.91488, 0.8785, 0.8801, 0.8785, 0.8785, 0.91343, 0.7173, 1.04106, 0.8785, 0.85075, 0.95794, 0.82616, 0.85162, 0.79492, 0.88331, 1.69808, 0.88331, 0.85284, 0.97801, 0.89552, 0.91133, 0.89552, 0.91133, 1.7801, 0.89552, 1.24487, 1.13254, 1.12401, 0.96839, 0.85284, 0.68787, 0.70645, 0.85592, 0.90747, 1.01466, 1.0088, 0.90323, 1, 1.07463, 1, 0.91056, 0.75806, 1.19118, 0.96839, 0.78864, 0.82845, 0.84133, 0.75859, 0.83908, 0.83908, 0.83908, 0.83908, 0.83908, 0.83908, 0.77539, 0.73293, 0.73133, 0.73133, 0.73133, 0.73133, 0.95958, 0.95958, 0.95958, 0.95958, 0.88506, 0.9121, 0.86943, 0.86943, 0.86943, 0.86943, 0.86943, 0.85284, 0.87508, 0.90399, 0.90399, 0.90399, 0.90399, 0.77892, 0.79795, 0.90807, 0.88762, 0.88762, 0.88762, 0.88762, 0.88762, 0.88762, 0.8715, 0.75241, 0.90518, 0.90518, 0.90518, 0.90518, 0.88401, 0.88401, 0.88401, 0.88401, 0.8785, 0.8785, 0.8801, 0.8801, 0.8801, 0.8801, 0.8801, 0.90747, 0.89049, 0.8785, 0.8785, 0.8785, 0.8785, 0.85162, 0.8785, 0.85162, 0.83908, 0.88762, 0.83908, 0.88762, 0.83908, 0.88762, 0.73293, 0.75241, 0.73293, 0.75241, 0.73293, 0.75241, 0.73293, 0.75241, 0.87289, 0.83016, 0.88506, 0.93125, 0.73133, 0.90518, 0.73133, 0.90518, 0.73133, 0.90518, 0.73133, 0.90518, 0.73133, 0.90518, 0.81921, 0.77618, 0.81921, 0.77618, 0.81921, 0.77618, 1, 1, 0.87356, 0.8785, 0.91075, 0.89608, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.76229, 0.90167, 0.59526, 0.91916, 1, 1, 0.86304, 0.69225, 0.88401, 1, 1, 0.70424, 0.79468, 0.91926, 0.88175, 0.70823, 0.94903, 0.9121, 0.8785, 1, 1, 0.9121, 0.8785, 0.87802, 0.88656, 0.8785, 0.86943, 0.8801, 0.86943, 0.8801, 0.86943, 0.8801, 0.87402, 0.89291, 0.77958, 0.91343, 1, 1, 0.77958, 0.91343, 0.70864, 0.7173, 0.70864, 0.7173, 0.70864, 0.7173, 0.70864, 0.7173, 1, 1, 0.81055, 0.75841, 0.81055, 1.06452, 0.90399, 0.8785, 0.90399, 0.8785, 0.90399, 0.8785, 0.90399, 0.8785, 0.90399, 0.8785, 0.90399, 0.8785, 0.96017, 0.95794, 0.77892, 0.85162, 0.77892, 0.78257, 0.79492, 0.78257, 0.79492, 0.78257, 0.79492, 0.9297, 0.56892, 0.83908, 0.88762, 0.77539, 0.8715, 0.87508, 0.89049, 1, 1, 0.81055, 1.04106, 1.20528, 1.20528, 1, 1.15543, 0.70674, 0.98387, 0.94721, 1.33431, 1.45894, 0.95161, 1.06303, 0.83908, 0.80352, 0.57184, 0.6965, 0.56289, 0.82001, 0.56029, 0.81235, 1.02988, 0.83908, 0.7762, 0.68156, 0.80367, 0.73133, 0.78257, 0.87356, 0.86943, 0.95958, 0.75727, 0.89019, 1.04924, 0.9121, 0.7648, 0.86943, 0.87356, 0.79795, 0.78275, 0.81055, 0.77892, 0.9762, 0.82577, 0.99819, 0.84896, 0.95958, 0.77892, 0.96108, 1.01407, 0.89049, 1.02988, 0.94211, 0.96108, 0.8936, 0.84021, 0.87842, 0.96399, 0.79109, 0.89049, 1.00813, 1.02988, 0.86077, 0.87445, 0.92099, 0.84723, 0.86513, 0.8801, 0.75638, 0.85714, 0.78216, 0.79586, 0.87965, 0.94211, 0.97747, 0.78287, 0.97926, 0.84971, 1.02988, 0.94211, 0.8801, 0.94211, 0.84971, 0.73133, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90264, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90518, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90548, 1, 1, 1, 1, 1, 1, 0.96017, 0.95794, 0.96017, 0.95794, 0.96017, 0.95794, 0.77892, 0.85162, 1, 1, 0.89552, 0.90527, 1, 0.90363, 0.92794, 0.92794, 0.92794, 0.92794, 0.87012, 0.87012, 0.87012, 0.89552, 0.89552, 1.42259, 0.71143, 1.06152, 1, 1, 1.03372, 1.03372, 0.97171, 1.4956, 2.2807, 0.93835, 0.83406, 0.91133, 0.84107, 0.91133, 1, 1, 1, 0.72021, 1, 1.23108, 0.83489, 0.88525, 0.88525, 0.81499, 0.90527, 1.81055, 0.90527, 1.81055, 1.31006, 1.53711, 0.94434, 1.08696, 1, 0.95018, 0.77192, 0.85284, 0.90747, 1.17534, 0.69825, 0.9716, 1.37077, 0.90747, 0.90747, 0.85356, 0.90747, 0.90747, 1.44947, 0.85284, 0.8941, 0.8941, 0.70572, 0.8, 0.70572, 0.70572, 0.70572, 0.70572, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.99862, 0.99862, 1, 1, 1, 1, 1, 1.08004, 0.91027, 1, 1, 1, 0.99862, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90727, 0.90727, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.CalibriBoldFactors = CalibriBoldFactors;
var CalibriBoldMetrics = {
  lineHeight: 1.2207,
  lineGap: 0.2207
};
exports.CalibriBoldMetrics = CalibriBoldMetrics;
var CalibriBoldItalicFactors = [1.3877, 1, 1, 1, 0.97801, 0.92482, 0.89552, 0.91133, 0.81988, 0.97566, 0.98152, 0.93548, 0.93548, 1.2798, 0.85284, 0.92794, 1, 0.96134, 1.56239, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.82845, 0.82845, 0.85284, 0.85284, 0.85284, 0.75859, 0.92138, 0.83908, 0.7762, 0.71805, 0.87289, 0.73133, 0.7514, 0.81921, 0.87356, 0.95958, 0.59526, 0.75727, 0.69225, 1.04924, 0.90872, 0.85938, 0.79795, 0.87068, 0.77958, 0.69766, 0.81055, 0.90399, 0.88653, 0.96068, 0.82577, 0.77892, 0.78257, 0.97507, 1.529, 0.97507, 0.85284, 0.89552, 0.90176, 0.94908, 0.86411, 0.74012, 0.86411, 0.88323, 0.95015, 0.86411, 0.86331, 0.88401, 0.91916, 0.86304, 0.88401, 0.9039, 0.86331, 0.86331, 0.86411, 0.86411, 0.90464, 0.70852, 1.04106, 0.86331, 0.84372, 0.95794, 0.82616, 0.84548, 0.79492, 0.88331, 1.69808, 0.88331, 0.85284, 0.97801, 0.89552, 0.91133, 0.89552, 0.91133, 1.7801, 0.89552, 1.24487, 1.13254, 1.19129, 0.96839, 0.85284, 0.68787, 0.70645, 0.85592, 0.90747, 1.01466, 1.0088, 0.90323, 1, 1.07463, 1, 0.91056, 0.75806, 1.19118, 0.96839, 0.78864, 0.82845, 0.84133, 0.75859, 0.83908, 0.83908, 0.83908, 0.83908, 0.83908, 0.83908, 0.77539, 0.71805, 0.73133, 0.73133, 0.73133, 0.73133, 0.95958, 0.95958, 0.95958, 0.95958, 0.88506, 0.90872, 0.85938, 0.85938, 0.85938, 0.85938, 0.85938, 0.85284, 0.87068, 0.90399, 0.90399, 0.90399, 0.90399, 0.77892, 0.79795, 0.90807, 0.94908, 0.94908, 0.94908, 0.94908, 0.94908, 0.94908, 0.85887, 0.74012, 0.88323, 0.88323, 0.88323, 0.88323, 0.88401, 0.88401, 0.88401, 0.88401, 0.8785, 0.86331, 0.86331, 0.86331, 0.86331, 0.86331, 0.86331, 0.90747, 0.89049, 0.86331, 0.86331, 0.86331, 0.86331, 0.84548, 0.86411, 0.84548, 0.83908, 0.94908, 0.83908, 0.94908, 0.83908, 0.94908, 0.71805, 0.74012, 0.71805, 0.74012, 0.71805, 0.74012, 0.71805, 0.74012, 0.87289, 0.79538, 0.88506, 0.92726, 0.73133, 0.88323, 0.73133, 0.88323, 0.73133, 0.88323, 0.73133, 0.88323, 0.73133, 0.88323, 0.81921, 0.86411, 0.81921, 0.86411, 0.81921, 0.86411, 1, 1, 0.87356, 0.86331, 0.91075, 0.8777, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.95958, 0.88401, 0.76467, 0.90167, 0.59526, 0.91916, 1, 1, 0.86304, 0.69225, 0.88401, 1, 1, 0.70424, 0.77312, 0.91926, 0.88175, 0.70823, 0.94903, 0.90872, 0.86331, 1, 1, 0.90872, 0.86331, 0.86906, 0.88116, 0.86331, 0.85938, 0.86331, 0.85938, 0.86331, 0.85938, 0.86331, 0.87402, 0.86549, 0.77958, 0.90464, 1, 1, 0.77958, 0.90464, 0.69766, 0.70852, 0.69766, 0.70852, 0.69766, 0.70852, 0.69766, 0.70852, 1, 1, 0.81055, 0.75841, 0.81055, 1.06452, 0.90399, 0.86331, 0.90399, 0.86331, 0.90399, 0.86331, 0.90399, 0.86331, 0.90399, 0.86331, 0.90399, 0.86331, 0.96068, 0.95794, 0.77892, 0.84548, 0.77892, 0.78257, 0.79492, 0.78257, 0.79492, 0.78257, 0.79492, 0.9297, 0.56892, 0.83908, 0.94908, 0.77539, 0.85887, 0.87068, 0.89049, 1, 1, 0.81055, 1.04106, 1.20528, 1.20528, 1, 1.15543, 0.70088, 0.98387, 0.94721, 1.33431, 1.45894, 0.95161, 1.48387, 0.83908, 0.80352, 0.57118, 0.6965, 0.56347, 0.79179, 0.55853, 0.80346, 1.02988, 0.83908, 0.7762, 0.67174, 0.86036, 0.73133, 0.78257, 0.87356, 0.86441, 0.95958, 0.75727, 0.89019, 1.04924, 0.90872, 0.74889, 0.85938, 0.87891, 0.79795, 0.7957, 0.81055, 0.77892, 0.97447, 0.82577, 0.97466, 0.87179, 0.95958, 0.77892, 0.94252, 0.95612, 0.8753, 1.02988, 0.92733, 0.94252, 0.87411, 0.84021, 0.8728, 0.95612, 0.74081, 0.8753, 1.02189, 1.02988, 0.84814, 0.87445, 0.91822, 0.84723, 0.85668, 0.86331, 0.81344, 0.87581, 0.76422, 0.82046, 0.96057, 0.92733, 0.99375, 0.78022, 0.95452, 0.86015, 1.02988, 0.92733, 0.86331, 0.92733, 0.86015, 0.73133, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90631, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.88323, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.85174, 1, 1, 1, 1, 1, 1, 0.96068, 0.95794, 0.96068, 0.95794, 0.96068, 0.95794, 0.77892, 0.84548, 1, 1, 0.89552, 0.90527, 1, 0.90363, 0.92794, 0.92794, 0.92794, 0.89807, 0.87012, 0.87012, 0.87012, 0.89552, 0.89552, 1.42259, 0.71094, 1.06152, 1, 1, 1.03372, 1.03372, 0.97171, 1.4956, 2.2807, 0.92972, 0.83406, 0.91133, 0.83326, 0.91133, 1, 1, 1, 0.72021, 1, 1.23108, 0.83489, 0.88525, 0.88525, 0.81499, 0.90616, 1.81055, 0.90527, 1.81055, 1.3107, 1.53711, 0.94434, 1.08696, 1, 0.95018, 0.77192, 0.85284, 0.90747, 1.17534, 0.69825, 0.9716, 1.37077, 0.90747, 0.90747, 0.85356, 0.90747, 0.90747, 1.44947, 0.85284, 0.8941, 0.8941, 0.70572, 0.8, 0.70572, 0.70572, 0.70572, 0.70572, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.99862, 0.99862, 1, 1, 1, 1, 1, 1.08004, 0.91027, 1, 1, 1, 0.99862, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90727, 0.90727, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.CalibriBoldItalicFactors = CalibriBoldItalicFactors;
var CalibriBoldItalicMetrics = {
  lineHeight: 1.2207,
  lineGap: 0.2207
};
exports.CalibriBoldItalicMetrics = CalibriBoldItalicMetrics;
var CalibriItalicFactors = [1.3877, 1, 1, 1, 1.17223, 1.1293, 0.89552, 0.91133, 0.80395, 1.02269, 1.15601, 0.91056, 0.91056, 1.2798, 0.85284, 0.89807, 1, 0.90861, 1.39543, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.96309, 0.96309, 0.85284, 0.85284, 0.85284, 0.83319, 0.88071, 0.8675, 0.81552, 0.72346, 0.85193, 0.73206, 0.7522, 0.81105, 0.86275, 0.90685, 0.6377, 0.77892, 0.75593, 1.02638, 0.89249, 0.84118, 0.77452, 0.85374, 0.75186, 0.67789, 0.79776, 0.88844, 0.85066, 0.94309, 0.77818, 0.7306, 0.76659, 1.10369, 1.38313, 1.10369, 1.06139, 0.89552, 0.8739, 0.9245, 0.9245, 0.83203, 0.9245, 0.85865, 1.09842, 0.9245, 0.9245, 1.03297, 1.07692, 0.90918, 1.03297, 0.94959, 0.9245, 0.92274, 0.9245, 0.9245, 1.02933, 0.77832, 1.20562, 0.9245, 0.8916, 0.98986, 0.86621, 0.89453, 0.79004, 0.94152, 1.77256, 0.94152, 0.85284, 0.97801, 0.89552, 0.91133, 0.89552, 0.91133, 1.91729, 0.89552, 1.17889, 1.13254, 1.16359, 0.92098, 0.85284, 0.68787, 0.71353, 0.84737, 0.90747, 1.0088, 1.0044, 0.87683, 1, 1.09091, 1, 0.92229, 0.739, 1.15642, 0.92098, 0.76288, 0.80504, 0.80972, 0.75859, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.76318, 0.72346, 0.73206, 0.73206, 0.73206, 0.73206, 0.90685, 0.90685, 0.90685, 0.90685, 0.86477, 0.89249, 0.84118, 0.84118, 0.84118, 0.84118, 0.84118, 0.85284, 0.84557, 0.88844, 0.88844, 0.88844, 0.88844, 0.7306, 0.77452, 0.86331, 0.9245, 0.9245, 0.9245, 0.9245, 0.9245, 0.9245, 0.84843, 0.83203, 0.85865, 0.85865, 0.85865, 0.85865, 0.82601, 0.82601, 0.82601, 0.82601, 0.94469, 0.9245, 0.92274, 0.92274, 0.92274, 0.92274, 0.92274, 0.90747, 0.86651, 0.9245, 0.9245, 0.9245, 0.9245, 0.89453, 0.9245, 0.89453, 0.8675, 0.9245, 0.8675, 0.9245, 0.8675, 0.9245, 0.72346, 0.83203, 0.72346, 0.83203, 0.72346, 0.83203, 0.72346, 0.83203, 0.85193, 0.8875, 0.86477, 0.99034, 0.73206, 0.85865, 0.73206, 0.85865, 0.73206, 0.85865, 0.73206, 0.85865, 0.73206, 0.85865, 0.81105, 0.9245, 0.81105, 0.9245, 0.81105, 0.9245, 1, 1, 0.86275, 0.9245, 0.90872, 0.93591, 0.90685, 0.82601, 0.90685, 0.82601, 0.90685, 0.82601, 0.90685, 1.03297, 0.90685, 0.82601, 0.77896, 1.05611, 0.6377, 1.07692, 1, 1, 0.90918, 0.75593, 1.03297, 1, 1, 0.76032, 0.9375, 0.98156, 0.93407, 0.77261, 1.11429, 0.89249, 0.9245, 1, 1, 0.89249, 0.9245, 0.92534, 0.86698, 0.9245, 0.84118, 0.92274, 0.84118, 0.92274, 0.84118, 0.92274, 0.8667, 0.86291, 0.75186, 1.02933, 1, 1, 0.75186, 1.02933, 0.67789, 0.77832, 0.67789, 0.77832, 0.67789, 0.77832, 0.67789, 0.77832, 1, 1, 0.79776, 0.97655, 0.79776, 1.23023, 0.88844, 0.9245, 0.88844, 0.9245, 0.88844, 0.9245, 0.88844, 0.9245, 0.88844, 0.9245, 0.88844, 0.9245, 0.94309, 0.98986, 0.7306, 0.89453, 0.7306, 0.76659, 0.79004, 0.76659, 0.79004, 0.76659, 0.79004, 1.09231, 0.54873, 0.8675, 0.9245, 0.76318, 0.84843, 0.84557, 0.86651, 1, 1, 0.79776, 1.20562, 1.18622, 1.18622, 1, 1.1437, 0.67009, 0.96334, 0.93695, 1.35191, 1.40909, 0.95161, 1.48387, 0.8675, 0.90861, 0.6192, 0.7363, 0.64824, 0.82411, 0.56321, 0.85696, 1.23516, 0.8675, 0.81552, 0.7286, 0.84134, 0.73206, 0.76659, 0.86275, 0.84369, 0.90685, 0.77892, 0.85871, 1.02638, 0.89249, 0.75828, 0.84118, 0.85984, 0.77452, 0.76466, 0.79776, 0.7306, 0.90782, 0.77818, 0.903, 0.87291, 0.90685, 0.7306, 0.99058, 1.03667, 0.94635, 1.23516, 0.9849, 0.99058, 0.92393, 0.8916, 0.942, 1.03667, 0.75026, 0.94635, 1.0297, 1.23516, 0.90918, 0.94048, 0.98217, 0.89746, 0.84153, 0.92274, 0.82507, 0.88832, 0.84438, 0.88178, 1.03525, 0.9849, 1.00225, 0.78086, 0.97248, 0.89404, 1.23516, 0.9849, 0.92274, 0.9849, 0.89404, 0.73206, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.89693, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.85865, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.90933, 1, 1, 1, 1, 1, 1, 0.94309, 0.98986, 0.94309, 0.98986, 0.94309, 0.98986, 0.7306, 0.89453, 1, 1, 0.89552, 0.90527, 1, 0.90186, 1.12308, 1.12308, 1.12308, 1.12308, 1.2566, 1.2566, 1.2566, 0.89552, 0.89552, 1.42259, 0.68994, 1.03809, 1, 1, 1.0176, 1.0176, 1.11523, 1.4956, 2.01462, 0.97858, 0.82616, 0.91133, 0.83437, 0.91133, 1, 1, 1, 0.70508, 1, 1.23108, 0.79801, 0.84426, 0.84426, 0.774, 0.90572, 1.81055, 0.90749, 1.81055, 1.28809, 1.55469, 0.94434, 1.07806, 1, 0.97094, 0.7589, 0.85284, 0.90747, 1.19658, 0.69825, 0.97622, 1.33512, 0.90747, 0.90747, 0.85284, 0.90747, 0.90747, 1.44947, 0.85284, 0.8941, 0.8941, 0.70572, 0.8, 0.70572, 0.70572, 0.70572, 0.70572, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.99862, 0.99862, 1, 1, 1, 1, 1, 1.0336, 0.91027, 1, 1, 1, 0.99862, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05859, 1.05859, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.CalibriItalicFactors = CalibriItalicFactors;
var CalibriItalicMetrics = {
  lineHeight: 1.2207,
  lineGap: 0.2207
};
exports.CalibriItalicMetrics = CalibriItalicMetrics;
var CalibriRegularFactors = [1.3877, 1, 1, 1, 1.17223, 1.1293, 0.89552, 0.91133, 0.80395, 1.02269, 1.15601, 0.91056, 0.91056, 1.2798, 0.85284, 0.89807, 1, 0.90861, 1.39016, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.91133, 0.96309, 0.96309, 0.85284, 0.85284, 0.85284, 0.83319, 0.88071, 0.8675, 0.81552, 0.73834, 0.85193, 0.73206, 0.7522, 0.81105, 0.86275, 0.90685, 0.6377, 0.77892, 0.75593, 1.02638, 0.89385, 0.85122, 0.77452, 0.86503, 0.75186, 0.68887, 0.79776, 0.88844, 0.85066, 0.94258, 0.77818, 0.7306, 0.76659, 1.10369, 1.39016, 1.10369, 1.06139, 0.89552, 0.8739, 0.86128, 0.94469, 0.8457, 0.94469, 0.89464, 1.09842, 0.84636, 0.94469, 1.03297, 1.07692, 0.90918, 1.03297, 0.95897, 0.94469, 0.9482, 0.94469, 0.94469, 1.04692, 0.78223, 1.20562, 0.94469, 0.90332, 0.98986, 0.86621, 0.90527, 0.79004, 0.94152, 1.77256, 0.94152, 0.85284, 0.97801, 0.89552, 0.91133, 0.89552, 0.91133, 1.91729, 0.89552, 1.17889, 1.13254, 1.08707, 0.92098, 0.85284, 0.68787, 0.71353, 0.84737, 0.90747, 1.0088, 1.0044, 0.87683, 1, 1.09091, 1, 0.92229, 0.739, 1.15642, 0.92098, 0.76288, 0.80504, 0.80972, 0.75859, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.76318, 0.73834, 0.73206, 0.73206, 0.73206, 0.73206, 0.90685, 0.90685, 0.90685, 0.90685, 0.86477, 0.89385, 0.85122, 0.85122, 0.85122, 0.85122, 0.85122, 0.85284, 0.85311, 0.88844, 0.88844, 0.88844, 0.88844, 0.7306, 0.77452, 0.86331, 0.86128, 0.86128, 0.86128, 0.86128, 0.86128, 0.86128, 0.8693, 0.8457, 0.89464, 0.89464, 0.89464, 0.89464, 0.82601, 0.82601, 0.82601, 0.82601, 0.94469, 0.94469, 0.9482, 0.9482, 0.9482, 0.9482, 0.9482, 0.90747, 0.86651, 0.94469, 0.94469, 0.94469, 0.94469, 0.90527, 0.94469, 0.90527, 0.8675, 0.86128, 0.8675, 0.86128, 0.8675, 0.86128, 0.73834, 0.8457, 0.73834, 0.8457, 0.73834, 0.8457, 0.73834, 0.8457, 0.85193, 0.92454, 0.86477, 0.9921, 0.73206, 0.89464, 0.73206, 0.89464, 0.73206, 0.89464, 0.73206, 0.89464, 0.73206, 0.89464, 0.81105, 0.84636, 0.81105, 0.84636, 0.81105, 0.84636, 1, 1, 0.86275, 0.94469, 0.90872, 0.95786, 0.90685, 0.82601, 0.90685, 0.82601, 0.90685, 0.82601, 0.90685, 1.03297, 0.90685, 0.82601, 0.77741, 1.05611, 0.6377, 1.07692, 1, 1, 0.90918, 0.75593, 1.03297, 1, 1, 0.76032, 0.90452, 0.98156, 1.11842, 0.77261, 1.11429, 0.89385, 0.94469, 1, 1, 0.89385, 0.94469, 0.95877, 0.86901, 0.94469, 0.85122, 0.9482, 0.85122, 0.9482, 0.85122, 0.9482, 0.8667, 0.90016, 0.75186, 1.04692, 1, 1, 0.75186, 1.04692, 0.68887, 0.78223, 0.68887, 0.78223, 0.68887, 0.78223, 0.68887, 0.78223, 1, 1, 0.79776, 0.92188, 0.79776, 1.23023, 0.88844, 0.94469, 0.88844, 0.94469, 0.88844, 0.94469, 0.88844, 0.94469, 0.88844, 0.94469, 0.88844, 0.94469, 0.94258, 0.98986, 0.7306, 0.90527, 0.7306, 0.76659, 0.79004, 0.76659, 0.79004, 0.76659, 0.79004, 1.09231, 0.54873, 0.8675, 0.86128, 0.76318, 0.8693, 0.85311, 0.86651, 1, 1, 0.79776, 1.20562, 1.18622, 1.18622, 1, 1.1437, 0.67742, 0.96334, 0.93695, 1.35191, 1.40909, 0.95161, 1.48387, 0.86686, 0.90861, 0.62267, 0.74359, 0.65649, 0.85498, 0.56963, 0.88254, 1.23516, 0.8675, 0.81552, 0.75443, 0.84503, 0.73206, 0.76659, 0.86275, 0.85122, 0.90685, 0.77892, 0.85746, 1.02638, 0.89385, 0.75657, 0.85122, 0.86275, 0.77452, 0.74171, 0.79776, 0.7306, 0.95165, 0.77818, 0.89772, 0.88831, 0.90685, 0.7306, 0.98142, 1.02191, 0.96576, 1.23516, 0.99018, 0.98142, 0.9236, 0.89258, 0.94035, 1.02191, 0.78848, 0.96576, 0.9561, 1.23516, 0.90918, 0.92578, 0.95424, 0.89746, 0.83969, 0.9482, 0.80113, 0.89442, 0.85208, 0.86155, 0.98022, 0.99018, 1.00452, 0.81209, 0.99247, 0.89181, 1.23516, 0.99018, 0.9482, 0.99018, 0.89181, 0.73206, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.88844, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.89464, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.96766, 1, 1, 1, 1, 1, 1, 0.94258, 0.98986, 0.94258, 0.98986, 0.94258, 0.98986, 0.7306, 0.90527, 1, 1, 0.89552, 0.90527, 1, 0.90186, 1.12308, 1.12308, 1.12308, 1.12308, 1.2566, 1.2566, 1.2566, 0.89552, 0.89552, 1.42259, 0.69043, 1.03809, 1, 1, 1.0176, 1.0176, 1.11523, 1.4956, 2.01462, 0.99331, 0.82616, 0.91133, 0.84286, 0.91133, 1, 1, 1, 0.70508, 1, 1.23108, 0.79801, 0.84426, 0.84426, 0.774, 0.90527, 1.81055, 0.90527, 1.81055, 1.28809, 1.55469, 0.94434, 1.07806, 1, 0.97094, 0.7589, 0.85284, 0.90747, 1.19658, 0.69825, 0.97622, 1.33512, 0.90747, 0.90747, 0.85356, 0.90747, 0.90747, 1.44947, 0.85284, 0.8941, 0.8941, 0.70572, 0.8, 0.70572, 0.70572, 0.70572, 0.70572, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.99862, 0.99862, 1, 1, 1, 1, 1, 1.0336, 0.91027, 1, 1, 1, 0.99862, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05859, 1.05859, 1, 1, 1, 1.07185, 0.99413, 0.96334, 1.08065, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.CalibriRegularFactors = CalibriRegularFactors;
var CalibriRegularMetrics = {
  lineHeight: 1.2207,
  lineGap: 0.2207
};
exports.CalibriRegularMetrics = CalibriRegularMetrics;

/***/ }),
/* 156 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.HelveticaRegularMetrics = exports.HelveticaRegularFactors = exports.HelveticaItalicMetrics = exports.HelveticaItalicFactors = exports.HelveticaBoldMetrics = exports.HelveticaBoldItalicMetrics = exports.HelveticaBoldItalicFactors = exports.HelveticaBoldFactors = void 0;
var HelveticaBoldFactors = [0.76116, 1, 1, 1.0006, 0.99998, 0.99974, 0.99973, 0.99973, 0.99982, 0.99977, 1.00087, 0.99998, 0.99998, 0.99959, 1.00003, 1.0006, 0.99998, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99998, 1, 1.00003, 1.00003, 1.00003, 1.00026, 0.9999, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00026, 1.00022, 0.99977, 1.0006, 0.99973, 0.99977, 1.00026, 0.99999, 0.99977, 1.00022, 1.00001, 1.00022, 0.99977, 1.00001, 1.00026, 0.99977, 1.00001, 1.00016, 1.00001, 1.00001, 1.00026, 0.99998, 1.0006, 0.99998, 1.00003, 0.99973, 0.99998, 0.99973, 1.00026, 0.99973, 1.00026, 0.99973, 0.99998, 1.00026, 1.00026, 1.0006, 1.0006, 0.99973, 1.0006, 0.99982, 1.00026, 1.00026, 1.00026, 1.00026, 0.99959, 0.99973, 0.99998, 1.00026, 0.99973, 1.00022, 0.99973, 0.99973, 1, 0.99959, 1.00077, 0.99959, 1.00003, 0.99998, 0.99973, 0.99973, 0.99973, 0.99973, 1.00077, 0.99973, 0.99998, 1.00025, 0.99968, 0.99973, 1.00003, 1.00025, 0.60299, 1.00024, 1.06409, 1, 1, 0.99998, 1, 0.99973, 1.0006, 0.99998, 1, 0.99936, 0.99973, 1.00002, 1.00002, 1.00002, 1.00026, 0.99977, 0.99977, 0.99977, 0.99977, 0.99977, 0.99977, 1, 0.99977, 1.00001, 1.00001, 1.00001, 1.00001, 1.0006, 1.0006, 1.0006, 1.0006, 0.99977, 0.99977, 1.00022, 1.00022, 1.00022, 1.00022, 1.00022, 1.00003, 1.00022, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00001, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99982, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.06409, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 0.99973, 1.00026, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 1.03374, 0.99977, 1.00026, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.00042, 0.99973, 0.99973, 1.0006, 0.99977, 0.99973, 0.99973, 1.00026, 1.0006, 1.00026, 1.0006, 1.00026, 1.03828, 1.00026, 0.99999, 1.00026, 1.0006, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.9993, 0.9998, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1, 1.00016, 0.99977, 0.99959, 0.99977, 0.99959, 0.99977, 0.99959, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00026, 0.99998, 1.00026, 0.8121, 1.00026, 0.99998, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 1.00016, 1.00022, 1.00001, 0.99973, 1.00001, 1.00026, 1, 1.00026, 1, 1.00026, 1, 1.0006, 0.99973, 0.99977, 0.99973, 1, 0.99982, 1.00022, 1.00026, 1.00001, 0.99973, 1.00026, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 1.00034, 0.99977, 1, 0.99997, 1.00026, 1.00078, 1.00036, 0.99973, 1.00013, 1.0006, 0.99977, 0.99977, 0.99988, 0.85148, 1.00001, 1.00026, 0.99977, 1.00022, 1.0006, 0.99977, 1.00001, 0.99999, 0.99977, 1.00069, 1.00022, 0.99977, 1.00001, 0.99984, 1.00026, 1.00001, 1.00024, 1.00001, 0.9999, 1, 1.0006, 1.00001, 1.00041, 0.99962, 1.00026, 1.0006, 0.99995, 1.00041, 0.99942, 0.99973, 0.99927, 1.00082, 0.99902, 1.00026, 1.00087, 1.0006, 1.00069, 0.99973, 0.99867, 0.99973, 0.9993, 1.00026, 1.00049, 1.00056, 1, 0.99988, 0.99935, 0.99995, 0.99954, 1.00055, 0.99945, 1.00032, 1.0006, 0.99995, 1.00026, 0.99995, 1.00032, 1.00001, 1.00008, 0.99971, 1.00019, 0.9994, 1.00001, 1.0006, 1.00044, 0.99973, 1.00023, 1.00047, 1, 0.99942, 0.99561, 0.99989, 1.00035, 0.99977, 1.00035, 0.99977, 1.00019, 0.99944, 1.00001, 1.00021, 0.99926, 1.00035, 1.00035, 0.99942, 1.00048, 0.99999, 0.99977, 1.00022, 1.00035, 1.00001, 0.99977, 1.00026, 0.99989, 1.00057, 1.00001, 0.99936, 1.00052, 1.00012, 0.99996, 1.00043, 1, 1.00035, 0.9994, 0.99976, 1.00035, 0.99973, 1.00052, 1.00041, 1.00119, 1.00037, 0.99973, 1.00002, 0.99986, 1.00041, 1.00041, 0.99902, 0.9996, 1.00034, 0.99999, 1.00026, 0.99999, 1.00026, 0.99973, 1.00052, 0.99973, 1, 0.99973, 1.00041, 1.00075, 0.9994, 1.0003, 0.99999, 1, 1.00041, 0.99955, 1, 0.99915, 0.99973, 0.99973, 1.00026, 1.00119, 0.99955, 0.99973, 1.0006, 0.99911, 1.0006, 1.00026, 0.99972, 1.00026, 0.99902, 1.00041, 0.99973, 0.99999, 1, 1, 1.00038, 1.0005, 1.00016, 1.00022, 1.00016, 1.00022, 1.00016, 1.00022, 1.00001, 0.99973, 1, 1, 0.99973, 1, 1, 0.99955, 1.0006, 1.0006, 1.0006, 1.0006, 1, 1, 1, 0.99973, 0.99973, 0.99972, 1, 1, 1.00106, 0.99999, 0.99998, 0.99998, 0.99999, 0.99998, 1.66475, 1, 0.99973, 0.99973, 1.00023, 0.99973, 0.99971, 1.00047, 1.00023, 1, 0.99991, 0.99984, 1.00002, 1.00002, 1.00002, 1.00002, 1, 1, 1, 1, 1, 1, 1, 0.99972, 1, 1.20985, 1.39713, 1.00003, 1.00031, 1.00015, 1, 0.99561, 1.00027, 1.00031, 1.00031, 0.99915, 1.00031, 1.00031, 0.99999, 1.00003, 0.99999, 0.99999, 1.41144, 1.6, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.40579, 1.40579, 1.36625, 0.99999, 1, 0.99861, 0.99861, 1, 1.00026, 1.00026, 1.00026, 1.00026, 0.99972, 0.99999, 0.99999, 0.99999, 0.99999, 1.40483, 1, 0.99977, 1.00054, 1, 1, 0.99953, 0.99962, 1.00042, 0.9995, 1, 1, 1, 1, 1, 1, 1, 1, 0.99998, 0.99998, 0.99998, 0.99998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.HelveticaBoldFactors = HelveticaBoldFactors;
var HelveticaBoldMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.HelveticaBoldMetrics = HelveticaBoldMetrics;
var HelveticaBoldItalicFactors = [0.76116, 1, 1, 1.0006, 0.99998, 0.99974, 0.99973, 0.99973, 0.99982, 0.99977, 1.00087, 0.99998, 0.99998, 0.99959, 1.00003, 1.0006, 0.99998, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99998, 1, 1.00003, 1.00003, 1.00003, 1.00026, 0.9999, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00026, 1.00022, 0.99977, 1.0006, 0.99973, 0.99977, 1.00026, 0.99999, 0.99977, 1.00022, 1.00001, 1.00022, 0.99977, 1.00001, 1.00026, 0.99977, 1.00001, 1.00016, 1.00001, 1.00001, 1.00026, 0.99998, 1.0006, 0.99998, 1.00003, 0.99973, 0.99998, 0.99973, 1.00026, 0.99973, 1.00026, 0.99973, 0.99998, 1.00026, 1.00026, 1.0006, 1.0006, 0.99973, 1.0006, 0.99982, 1.00026, 1.00026, 1.00026, 1.00026, 0.99959, 0.99973, 0.99998, 1.00026, 0.99973, 1.00022, 0.99973, 0.99973, 1, 0.99959, 1.00077, 0.99959, 1.00003, 0.99998, 0.99973, 0.99973, 0.99973, 0.99973, 1.00077, 0.99973, 0.99998, 1.00025, 0.99968, 0.99973, 1.00003, 1.00025, 0.60299, 1.00024, 1.06409, 1, 1, 0.99998, 1, 0.99973, 1.0006, 0.99998, 1, 0.99936, 0.99973, 1.00002, 1.00002, 1.00002, 1.00026, 0.99977, 0.99977, 0.99977, 0.99977, 0.99977, 0.99977, 1, 0.99977, 1.00001, 1.00001, 1.00001, 1.00001, 1.0006, 1.0006, 1.0006, 1.0006, 0.99977, 0.99977, 1.00022, 1.00022, 1.00022, 1.00022, 1.00022, 1.00003, 1.00022, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00001, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99982, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 1.06409, 1.00026, 1.00026, 1.00026, 1.00026, 1.00026, 0.99973, 1.00026, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 1.0044, 0.99977, 1.00026, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 0.99971, 0.99973, 0.99973, 1.0006, 0.99977, 0.99973, 0.99973, 1.00026, 1.0006, 1.00026, 1.0006, 1.00026, 1.01011, 1.00026, 0.99999, 1.00026, 1.0006, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.9993, 0.9998, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1.00022, 1.00026, 1, 1.00016, 0.99977, 0.99959, 0.99977, 0.99959, 0.99977, 0.99959, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00026, 0.99998, 1.00026, 0.8121, 1.00026, 0.99998, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 0.99977, 1.00026, 1.00016, 1.00022, 1.00001, 0.99973, 1.00001, 1.00026, 1, 1.00026, 1, 1.00026, 1, 1.0006, 0.99973, 0.99977, 0.99973, 1, 0.99982, 1.00022, 1.00026, 1.00001, 0.99973, 1.00026, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99977, 1, 1, 1.00026, 0.99969, 0.99972, 0.99981, 0.9998, 1.0006, 0.99977, 0.99977, 1.00022, 0.91155, 1.00001, 1.00026, 0.99977, 1.00022, 1.0006, 0.99977, 1.00001, 0.99999, 0.99977, 0.99966, 1.00022, 1.00032, 1.00001, 0.99944, 1.00026, 1.00001, 0.99968, 1.00001, 1.00047, 1, 1.0006, 1.00001, 0.99981, 1.00101, 1.00026, 1.0006, 0.99948, 0.99981, 1.00064, 0.99973, 0.99942, 1.00101, 1.00061, 1.00026, 1.00069, 1.0006, 1.00014, 0.99973, 1.01322, 0.99973, 1.00065, 1.00026, 1.00012, 0.99923, 1, 1.00064, 1.00076, 0.99948, 1.00055, 1.00063, 1.00007, 0.99943, 1.0006, 0.99948, 1.00026, 0.99948, 0.99943, 1.00001, 1.00001, 1.00029, 1.00038, 1.00035, 1.00001, 1.0006, 1.0006, 0.99973, 0.99978, 1.00001, 1.00057, 0.99989, 0.99967, 0.99964, 0.99967, 0.99977, 0.99999, 0.99977, 1.00038, 0.99977, 1.00001, 0.99973, 1.00066, 0.99967, 0.99967, 1.00041, 0.99998, 0.99999, 0.99977, 1.00022, 0.99967, 1.00001, 0.99977, 1.00026, 0.99964, 1.00031, 1.00001, 0.99999, 0.99999, 1, 1.00023, 1, 1, 0.99999, 1.00035, 1.00001, 0.99999, 0.99973, 0.99977, 0.99999, 1.00058, 0.99973, 0.99973, 0.99955, 0.9995, 1.00026, 1.00026, 1.00032, 0.99989, 1.00034, 0.99999, 1.00026, 1.00026, 1.00026, 0.99973, 0.45998, 0.99973, 1.00026, 0.99973, 1.00001, 0.99999, 0.99982, 0.99994, 0.99996, 1, 1.00042, 1.00044, 1.00029, 1.00023, 0.99973, 0.99973, 1.00026, 0.99949, 1.00002, 0.99973, 1.0006, 1.0006, 1.0006, 0.99975, 1.00026, 1.00026, 1.00032, 0.98685, 0.99973, 1.00026, 1, 1, 0.99966, 1.00044, 1.00016, 1.00022, 1.00016, 1.00022, 1.00016, 1.00022, 1.00001, 0.99973, 1, 1, 0.99973, 1, 1, 0.99955, 1.0006, 1.0006, 1.0006, 1.0006, 1, 1, 1, 0.99973, 0.99973, 0.99972, 1, 1, 1.00106, 0.99999, 0.99998, 0.99998, 0.99999, 0.99998, 1.66475, 1, 0.99973, 0.99973, 1, 0.99973, 0.99971, 0.99978, 1, 1, 0.99991, 0.99984, 1.00002, 1.00002, 1.00002, 1.00002, 1.00098, 1, 1, 1, 1.00049, 1, 1, 0.99972, 1, 1.20985, 1.39713, 1.00003, 1.00031, 1.00015, 1, 0.99561, 1.00027, 1.00031, 1.00031, 0.99915, 1.00031, 1.00031, 0.99999, 1.00003, 0.99999, 0.99999, 1.41144, 1.6, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.40579, 1.40579, 1.36625, 0.99999, 1, 0.99861, 0.99861, 1, 1.00026, 1.00026, 1.00026, 1.00026, 0.99972, 0.99999, 0.99999, 0.99999, 0.99999, 1.40483, 1, 0.99977, 1.00054, 1, 1, 0.99953, 0.99962, 1.00042, 0.9995, 1, 1, 1, 1, 1, 1, 1, 1, 0.99998, 0.99998, 0.99998, 0.99998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.HelveticaBoldItalicFactors = HelveticaBoldItalicFactors;
var HelveticaBoldItalicMetrics = {
  lineHeight: 1.35,
  lineGap: 0.2
};
exports.HelveticaBoldItalicMetrics = HelveticaBoldItalicMetrics;
var HelveticaItalicFactors = [0.76116, 1, 1, 1.0006, 1.0006, 1.00006, 0.99973, 0.99973, 0.99982, 1.00001, 1.00043, 0.99998, 0.99998, 0.99959, 1.00003, 1.0006, 0.99998, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1, 1.00003, 1.00003, 1.00003, 0.99973, 0.99987, 1.00001, 1.00001, 0.99977, 0.99977, 1.00001, 1.00026, 1.00022, 0.99977, 1.0006, 1, 1.00001, 0.99973, 0.99999, 0.99977, 1.00022, 1.00001, 1.00022, 0.99977, 1.00001, 1.00026, 0.99977, 1.00001, 1.00016, 1.00001, 1.00001, 1.00026, 1.0006, 1.0006, 1.0006, 0.99949, 0.99973, 0.99998, 0.99973, 0.99973, 1, 0.99973, 0.99973, 1.0006, 0.99973, 0.99973, 0.99924, 0.99924, 1, 0.99924, 0.99999, 0.99973, 0.99973, 0.99973, 0.99973, 0.99998, 1, 1.0006, 0.99973, 1, 0.99977, 1, 1, 1, 1.00005, 1.0009, 1.00005, 1.00003, 0.99998, 0.99973, 0.99973, 0.99973, 0.99973, 1.0009, 0.99973, 0.99998, 1.00025, 0.99968, 0.99973, 1.00003, 1.00025, 0.60299, 1.00024, 1.06409, 1, 1, 0.99998, 1, 0.9998, 1.0006, 0.99998, 1, 0.99936, 0.99973, 1.00002, 1.00002, 1.00002, 1.00026, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1, 0.99977, 1.00001, 1.00001, 1.00001, 1.00001, 1.0006, 1.0006, 1.0006, 1.0006, 0.99977, 0.99977, 1.00022, 1.00022, 1.00022, 1.00022, 1.00022, 1.00003, 1.00022, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00001, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99982, 1, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.06409, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 1, 0.99973, 1, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 0.99977, 1, 0.99977, 1, 0.99977, 1, 0.99977, 1, 0.99977, 1.0288, 0.99977, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 0.99924, 1.0006, 1.0006, 0.99946, 1.00034, 1, 0.99924, 1.00001, 1, 1, 0.99973, 0.99924, 0.99973, 0.99924, 0.99973, 1.06311, 0.99973, 1.00024, 0.99973, 0.99924, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.00041, 0.9998, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1, 1.00016, 0.99977, 0.99998, 0.99977, 0.99998, 0.99977, 0.99998, 1.00001, 1, 1.00001, 1, 1.00001, 1, 1.00001, 1, 1.00026, 1.0006, 1.00026, 0.89547, 1.00026, 1.0006, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.00016, 0.99977, 1.00001, 1, 1.00001, 1.00026, 1, 1.00026, 1, 1.00026, 1, 0.99924, 0.99973, 1.00001, 0.99973, 1, 0.99982, 1.00022, 1.00026, 1.00001, 1, 1.00026, 1.0006, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 1.00001, 1, 1.00054, 0.99977, 1.00084, 1.00007, 0.99973, 1.00013, 0.99924, 1.00001, 1.00001, 0.99945, 0.91221, 1.00001, 1.00026, 0.99977, 1.00022, 1.0006, 1.00001, 1.00001, 0.99999, 0.99977, 0.99933, 1.00022, 1.00054, 1.00001, 1.00065, 1.00026, 1.00001, 1.0001, 1.00001, 1.00052, 1, 1.0006, 1.00001, 0.99945, 0.99897, 0.99968, 0.99924, 1.00036, 0.99945, 0.99949, 1, 1.0006, 0.99897, 0.99918, 0.99968, 0.99911, 0.99924, 1, 0.99962, 1.01487, 1, 1.0005, 0.99973, 1.00012, 1.00043, 1, 0.99995, 0.99994, 1.00036, 0.99947, 1.00019, 1.00063, 1.00025, 0.99924, 1.00036, 0.99973, 1.00036, 1.00025, 1.00001, 1.00001, 1.00027, 1.0001, 1.00068, 1.00001, 1.0006, 1.0006, 1, 1.00008, 0.99957, 0.99972, 0.9994, 0.99954, 0.99975, 1.00051, 1.00001, 1.00019, 1.00001, 1.0001, 0.99986, 1.00001, 1.00001, 1.00038, 0.99954, 0.99954, 0.9994, 1.00066, 0.99999, 0.99977, 1.00022, 1.00054, 1.00001, 0.99977, 1.00026, 0.99975, 1.0001, 1.00001, 0.99993, 0.9995, 0.99955, 1.00016, 0.99978, 0.99974, 1.00019, 1.00022, 0.99955, 1.00053, 0.99973, 1.00089, 1.00005, 0.99967, 1.00048, 0.99973, 1.00002, 1.00034, 0.99973, 0.99973, 0.99964, 1.00006, 1.00066, 0.99947, 0.99973, 0.98894, 0.99973, 1, 0.44898, 1, 0.99946, 1, 1.00039, 1.00082, 0.99991, 0.99991, 0.99985, 1.00022, 1.00023, 1.00061, 1.00006, 0.99966, 0.99973, 0.99973, 0.99973, 1.00019, 1.0008, 1, 0.99924, 0.99924, 0.99924, 0.99983, 1.00044, 0.99973, 0.99964, 0.98332, 1, 0.99973, 1, 1, 0.99962, 0.99895, 1.00016, 0.99977, 1.00016, 0.99977, 1.00016, 0.99977, 1.00001, 1, 1, 1, 0.99973, 1, 1, 0.99955, 0.99924, 0.99924, 0.99924, 0.99924, 0.99998, 0.99998, 0.99998, 0.99973, 0.99973, 0.99972, 1, 1, 1.00267, 0.99999, 0.99998, 0.99998, 1, 0.99998, 1.66475, 1, 0.99973, 0.99973, 1.00023, 0.99973, 1.00423, 0.99925, 0.99999, 1, 0.99991, 0.99984, 1.00002, 1.00002, 1.00002, 1.00002, 1.00049, 1, 1.00245, 1, 1, 1, 1, 0.96329, 1, 1.20985, 1.39713, 1.00003, 0.8254, 1.00015, 1, 1.00035, 1.00027, 1.00031, 1.00031, 1.00003, 1.00031, 1.00031, 0.99999, 1.00003, 0.99999, 0.99999, 1.41144, 1.6, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.40579, 1.40579, 1.36625, 0.99999, 1, 0.99861, 0.99861, 1, 1.00026, 1.00026, 1.00026, 1.00026, 0.95317, 0.99999, 0.99999, 0.99999, 0.99999, 1.40483, 1, 0.99977, 1.00054, 1, 1, 0.99953, 0.99962, 1.00042, 0.9995, 1, 1, 1, 1, 1, 1, 1, 1, 0.99998, 0.99998, 0.99998, 0.99998, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.HelveticaItalicFactors = HelveticaItalicFactors;
var HelveticaItalicMetrics = {
  lineHeight: 1.35,
  lineGap: 0.2
};
exports.HelveticaItalicMetrics = HelveticaItalicMetrics;
var HelveticaRegularFactors = [0.76116, 1, 1, 1.0006, 1.0006, 1.00006, 0.99973, 0.99973, 0.99982, 1.00001, 1.00043, 0.99998, 0.99998, 0.99959, 1.00003, 1.0006, 0.99998, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1, 1.00003, 1.00003, 1.00003, 0.99973, 0.99987, 1.00001, 1.00001, 0.99977, 0.99977, 1.00001, 1.00026, 1.00022, 0.99977, 1.0006, 1, 1.00001, 0.99973, 0.99999, 0.99977, 1.00022, 1.00001, 1.00022, 0.99977, 1.00001, 1.00026, 0.99977, 1.00001, 1.00016, 1.00001, 1.00001, 1.00026, 1.0006, 1.0006, 1.0006, 0.99949, 0.99973, 0.99998, 0.99973, 0.99973, 1, 0.99973, 0.99973, 1.0006, 0.99973, 0.99973, 0.99924, 0.99924, 1, 0.99924, 0.99999, 0.99973, 0.99973, 0.99973, 0.99973, 0.99998, 1, 1.0006, 0.99973, 1, 0.99977, 1, 1, 1, 1.00005, 1.0009, 1.00005, 1.00003, 0.99998, 0.99973, 0.99973, 0.99973, 0.99973, 1.0009, 0.99973, 0.99998, 1.00025, 0.99968, 0.99973, 1.00003, 1.00025, 0.60299, 1.00024, 1.06409, 1, 1, 0.99998, 1, 0.9998, 1.0006, 0.99998, 1, 0.99936, 0.99973, 1.00002, 1.00002, 1.00002, 1.00026, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1, 0.99977, 1.00001, 1.00001, 1.00001, 1.00001, 1.0006, 1.0006, 1.0006, 1.0006, 0.99977, 0.99977, 1.00022, 1.00022, 1.00022, 1.00022, 1.00022, 1.00003, 1.00022, 0.99977, 0.99977, 0.99977, 0.99977, 1.00001, 1.00001, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99982, 1, 0.99973, 0.99973, 0.99973, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 0.99973, 1.06409, 1.00026, 0.99973, 0.99973, 0.99973, 0.99973, 1, 0.99973, 1, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 0.99977, 1, 0.99977, 1, 0.99977, 1, 0.99977, 1, 0.99977, 1.04596, 0.99977, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00001, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 1.0006, 0.99924, 1.0006, 1.0006, 1.00019, 1.00034, 1, 0.99924, 1.00001, 1, 1, 0.99973, 0.99924, 0.99973, 0.99924, 0.99973, 1.02572, 0.99973, 1.00005, 0.99973, 0.99924, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99999, 0.9998, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1.00022, 0.99973, 1, 1.00016, 0.99977, 0.99998, 0.99977, 0.99998, 0.99977, 0.99998, 1.00001, 1, 1.00001, 1, 1.00001, 1, 1.00001, 1, 1.00026, 1.0006, 1.00026, 0.84533, 1.00026, 1.0006, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 0.99977, 0.99973, 1.00016, 0.99977, 1.00001, 1, 1.00001, 1.00026, 1, 1.00026, 1, 1.00026, 1, 0.99924, 0.99973, 1.00001, 0.99973, 1, 0.99982, 1.00022, 1.00026, 1.00001, 1, 1.00026, 1.0006, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99998, 0.99928, 1, 0.99977, 1.00013, 1.00055, 0.99947, 0.99945, 0.99941, 0.99924, 1.00001, 1.00001, 1.0004, 0.91621, 1.00001, 1.00026, 0.99977, 1.00022, 1.0006, 1.00001, 1.00005, 0.99999, 0.99977, 1.00015, 1.00022, 0.99977, 1.00001, 0.99973, 1.00026, 1.00001, 1.00019, 1.00001, 0.99946, 1, 1.0006, 1.00001, 0.99978, 1.00045, 0.99973, 0.99924, 1.00023, 0.99978, 0.99966, 1, 1.00065, 1.00045, 1.00019, 0.99973, 0.99973, 0.99924, 1, 1, 0.96499, 1, 1.00055, 0.99973, 1.00008, 1.00027, 1, 0.9997, 0.99995, 1.00023, 0.99933, 1.00019, 1.00015, 1.00031, 0.99924, 1.00023, 0.99973, 1.00023, 1.00031, 1.00001, 0.99928, 1.00029, 1.00092, 1.00035, 1.00001, 1.0006, 1.0006, 1, 0.99988, 0.99975, 1, 1.00082, 0.99561, 0.9996, 1.00035, 1.00001, 0.99962, 1.00001, 1.00092, 0.99964, 1.00001, 0.99963, 0.99999, 1.00035, 1.00035, 1.00082, 0.99962, 0.99999, 0.99977, 1.00022, 1.00035, 1.00001, 0.99977, 1.00026, 0.9996, 0.99967, 1.00001, 1.00034, 1.00074, 1.00054, 1.00053, 1.00063, 0.99971, 0.99962, 1.00035, 0.99975, 0.99977, 0.99973, 1.00043, 0.99953, 1.0007, 0.99915, 0.99973, 1.00008, 0.99892, 1.00073, 1.00073, 1.00114, 0.99915, 1.00073, 0.99955, 0.99973, 1.00092, 0.99973, 1, 0.99998, 1, 1.0003, 1, 1.00043, 1.00001, 0.99969, 1.0003, 1, 1.00035, 1.00001, 0.9995, 1, 1.00092, 0.99973, 0.99973, 0.99973, 1.0007, 0.9995, 1, 0.99924, 1.0006, 0.99924, 0.99972, 1.00062, 0.99973, 1.00114, 1.00073, 1, 0.99955, 1, 1, 1.00047, 0.99968, 1.00016, 0.99977, 1.00016, 0.99977, 1.00016, 0.99977, 1.00001, 1, 1, 1, 0.99973, 1, 1, 0.99955, 0.99924, 0.99924, 0.99924, 0.99924, 0.99998, 0.99998, 0.99998, 0.99973, 0.99973, 0.99972, 1, 1, 1.00267, 0.99999, 0.99998, 0.99998, 1, 0.99998, 1.66475, 1, 0.99973, 0.99973, 1.00023, 0.99973, 0.99971, 0.99925, 1.00023, 1, 0.99991, 0.99984, 1.00002, 1.00002, 1.00002, 1.00002, 1, 1, 1, 1, 1, 1, 1, 0.96329, 1, 1.20985, 1.39713, 1.00003, 0.8254, 1.00015, 1, 1.00035, 1.00027, 1.00031, 1.00031, 0.99915, 1.00031, 1.00031, 0.99999, 1.00003, 0.99999, 0.99999, 1.41144, 1.6, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.41144, 1.40579, 1.40579, 1.36625, 0.99999, 1, 0.99861, 0.99861, 1, 1.00026, 1.00026, 1.00026, 1.00026, 0.95317, 0.99999, 0.99999, 0.99999, 0.99999, 1.40483, 1, 0.99977, 1.00054, 1, 1, 0.99953, 0.99962, 1.00042, 0.9995, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.HelveticaRegularFactors = HelveticaRegularFactors;
var HelveticaRegularMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.HelveticaRegularMetrics = HelveticaRegularMetrics;

/***/ }),
/* 157 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LiberationSansRegularWidths = exports.LiberationSansRegularMapping = exports.LiberationSansItalicWidths = exports.LiberationSansItalicMapping = exports.LiberationSansBoldWidths = exports.LiberationSansBoldMapping = exports.LiberationSansBoldItalicWidths = exports.LiberationSansBoldItalicMapping = void 0;
var LiberationSansBoldWidths = [365, 0, 333, 278, 333, 474, 556, 556, 889, 722, 238, 333, 333, 389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 333, 333, 584, 584, 584, 611, 975, 722, 722, 722, 722, 667, 611, 778, 722, 278, 556, 722, 611, 833, 722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 333, 278, 333, 584, 556, 333, 556, 611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 611, 611, 611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 389, 280, 389, 584, 333, 556, 556, 556, 556, 280, 556, 333, 737, 370, 556, 584, 737, 552, 400, 549, 333, 333, 333, 576, 556, 278, 333, 333, 365, 556, 834, 834, 834, 611, 722, 722, 722, 722, 722, 722, 1000, 722, 667, 667, 667, 667, 278, 278, 278, 278, 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611, 556, 556, 556, 556, 556, 556, 889, 556, 556, 556, 556, 556, 278, 278, 278, 278, 611, 611, 611, 611, 611, 611, 611, 549, 611, 611, 611, 611, 611, 556, 611, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 719, 722, 611, 667, 556, 667, 556, 667, 556, 667, 556, 667, 556, 778, 611, 778, 611, 778, 611, 778, 611, 722, 611, 722, 611, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 785, 556, 556, 278, 722, 556, 556, 611, 278, 611, 278, 611, 385, 611, 479, 611, 278, 722, 611, 722, 611, 722, 611, 708, 723, 611, 778, 611, 778, 611, 778, 611, 1000, 944, 722, 389, 722, 389, 722, 389, 667, 556, 667, 556, 667, 556, 667, 556, 611, 333, 611, 479, 611, 333, 722, 611, 722, 611, 722, 611, 722, 611, 722, 611, 722, 611, 944, 778, 667, 556, 667, 611, 500, 611, 500, 611, 500, 278, 556, 722, 556, 1000, 889, 778, 611, 667, 556, 611, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 465, 722, 333, 853, 906, 474, 825, 927, 838, 278, 722, 722, 601, 719, 667, 611, 722, 778, 278, 722, 667, 833, 722, 644, 778, 722, 667, 600, 611, 667, 821, 667, 809, 802, 278, 667, 615, 451, 611, 278, 582, 615, 610, 556, 606, 475, 460, 611, 541, 278, 558, 556, 612, 556, 445, 611, 766, 619, 520, 684, 446, 582, 715, 576, 753, 845, 278, 582, 611, 582, 845, 667, 669, 885, 567, 711, 667, 278, 276, 556, 1094, 1062, 875, 610, 722, 622, 719, 722, 719, 722, 567, 712, 667, 904, 626, 719, 719, 610, 702, 833, 722, 778, 719, 667, 722, 611, 622, 854, 667, 730, 703, 1005, 1019, 870, 979, 719, 711, 1031, 719, 556, 618, 615, 417, 635, 556, 709, 497, 615, 615, 500, 635, 740, 604, 611, 604, 611, 556, 490, 556, 875, 556, 615, 581, 833, 844, 729, 854, 615, 552, 854, 583, 556, 556, 611, 417, 552, 556, 278, 281, 278, 969, 906, 611, 500, 615, 556, 604, 778, 611, 487, 447, 944, 778, 944, 778, 944, 778, 667, 556, 333, 333, 556, 1000, 1000, 552, 278, 278, 278, 278, 500, 500, 500, 556, 556, 350, 1000, 1000, 240, 479, 333, 333, 604, 333, 167, 396, 556, 556, 1094, 556, 885, 489, 1115, 1000, 768, 600, 834, 834, 834, 834, 1000, 500, 1000, 500, 1000, 500, 500, 494, 612, 823, 713, 584, 549, 713, 979, 722, 274, 549, 549, 583, 549, 549, 604, 584, 604, 604, 708, 625, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 729, 604, 604, 354, 354, 1000, 990, 990, 990, 990, 494, 604, 604, 604, 604, 354, 1021, 1052, 917, 750, 750, 531, 656, 594, 510, 500, 750, 750, 611, 611, 333, 333, 333, 333, 333, 333, 333, 333, 222, 222, 333, 333, 333, 333, 333, 333, 333, 333];
exports.LiberationSansBoldWidths = LiberationSansBoldWidths;
var LiberationSansBoldMapping = [-1, -1, -1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 402, 506, 507, 508, 509, 510, 511, 536, 537, 538, 539, 710, 711, 713, 728, 729, 730, 731, 732, 733, 900, 901, 902, 903, 904, 905, 906, 908, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1138, 1139, 1168, 1169, 7808, 7809, 7810, 7811, 7812, 7813, 7922, 7923, 8208, 8209, 8211, 8212, 8213, 8215, 8216, 8217, 8218, 8219, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8242, 8243, 8249, 8250, 8252, 8254, 8260, 8319, 8355, 8356, 8359, 8364, 8453, 8467, 8470, 8482, 8486, 8494, 8539, 8540, 8541, 8542, 8592, 8593, 8594, 8595, 8596, 8597, 8616, 8706, 8710, 8719, 8721, 8722, 8730, 8734, 8735, 8745, 8747, 8776, 8800, 8801, 8804, 8805, 8962, 8976, 8992, 8993, 9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9552, 9553, 9554, 9555, 9556, 9557, 9558, 9559, 9560, 9561, 9562, 9563, 9564, 9565, 9566, 9567, 9568, 9569, 9570, 9571, 9572, 9573, 9574, 9575, 9576, 9577, 9578, 9579, 9580, 9600, 9604, 9608, 9612, 9616, 9617, 9618, 9619, 9632, 9633, 9642, 9643, 9644, 9650, 9658, 9660, 9668, 9674, 9675, 9679, 9688, 9689, 9702, 9786, 9787, 9788, 9792, 9794, 9824, 9827, 9829, 9830, 9834, 9835, 9836, 61441, 61442, 61445, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
exports.LiberationSansBoldMapping = LiberationSansBoldMapping;
var LiberationSansBoldItalicWidths = [365, 0, 333, 278, 333, 474, 556, 556, 889, 722, 238, 333, 333, 389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 333, 333, 584, 584, 584, 611, 975, 722, 722, 722, 722, 667, 611, 778, 722, 278, 556, 722, 611, 833, 722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 333, 278, 333, 584, 556, 333, 556, 611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 611, 611, 611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 389, 280, 389, 584, 333, 556, 556, 556, 556, 280, 556, 333, 737, 370, 556, 584, 737, 552, 400, 549, 333, 333, 333, 576, 556, 278, 333, 333, 365, 556, 834, 834, 834, 611, 722, 722, 722, 722, 722, 722, 1000, 722, 667, 667, 667, 667, 278, 278, 278, 278, 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611, 556, 556, 556, 556, 556, 556, 889, 556, 556, 556, 556, 556, 278, 278, 278, 278, 611, 611, 611, 611, 611, 611, 611, 549, 611, 611, 611, 611, 611, 556, 611, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 740, 722, 611, 667, 556, 667, 556, 667, 556, 667, 556, 667, 556, 778, 611, 778, 611, 778, 611, 778, 611, 722, 611, 722, 611, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 782, 556, 556, 278, 722, 556, 556, 611, 278, 611, 278, 611, 396, 611, 479, 611, 278, 722, 611, 722, 611, 722, 611, 708, 723, 611, 778, 611, 778, 611, 778, 611, 1000, 944, 722, 389, 722, 389, 722, 389, 667, 556, 667, 556, 667, 556, 667, 556, 611, 333, 611, 479, 611, 333, 722, 611, 722, 611, 722, 611, 722, 611, 722, 611, 722, 611, 944, 778, 667, 556, 667, 611, 500, 611, 500, 611, 500, 278, 556, 722, 556, 1000, 889, 778, 611, 667, 556, 611, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 722, 333, 854, 906, 473, 844, 930, 847, 278, 722, 722, 610, 671, 667, 611, 722, 778, 278, 722, 667, 833, 722, 657, 778, 718, 667, 590, 611, 667, 822, 667, 829, 781, 278, 667, 620, 479, 611, 278, 591, 620, 621, 556, 610, 479, 492, 611, 558, 278, 566, 556, 603, 556, 450, 611, 712, 605, 532, 664, 409, 591, 704, 578, 773, 834, 278, 591, 611, 591, 834, 667, 667, 886, 614, 719, 667, 278, 278, 556, 1094, 1042, 854, 622, 719, 677, 719, 722, 708, 722, 614, 722, 667, 927, 643, 719, 719, 615, 687, 833, 722, 778, 719, 667, 722, 611, 677, 781, 667, 729, 708, 979, 989, 854, 1000, 708, 719, 1042, 729, 556, 619, 604, 534, 618, 556, 736, 510, 611, 611, 507, 622, 740, 604, 611, 611, 611, 556, 889, 556, 885, 556, 646, 583, 889, 935, 707, 854, 594, 552, 865, 589, 556, 556, 611, 469, 563, 556, 278, 278, 278, 969, 906, 611, 507, 619, 556, 611, 778, 611, 575, 467, 944, 778, 944, 778, 944, 778, 667, 556, 333, 333, 556, 1000, 1000, 552, 278, 278, 278, 278, 500, 500, 500, 556, 556, 350, 1000, 1000, 240, 479, 333, 333, 604, 333, 167, 396, 556, 556, 1104, 556, 885, 516, 1146, 1000, 768, 600, 834, 834, 834, 834, 999, 500, 1000, 500, 1000, 500, 500, 494, 612, 823, 713, 584, 549, 713, 979, 722, 274, 549, 549, 583, 549, 549, 604, 584, 604, 604, 708, 625, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 729, 604, 604, 354, 354, 1000, 990, 990, 990, 990, 494, 604, 604, 604, 604, 354, 1021, 1052, 917, 750, 750, 531, 656, 594, 510, 500, 750, 750, 611, 611, 333, 333, 333, 333, 333, 333, 333, 333, 222, 222, 333, 333, 333, 333, 333, 333, 333, 333];
exports.LiberationSansBoldItalicWidths = LiberationSansBoldItalicWidths;
var LiberationSansBoldItalicMapping = [-1, -1, -1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 402, 506, 507, 508, 509, 510, 511, 536, 537, 538, 539, 710, 711, 713, 728, 729, 730, 731, 732, 733, 900, 901, 902, 903, 904, 905, 906, 908, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1138, 1139, 1168, 1169, 7808, 7809, 7810, 7811, 7812, 7813, 7922, 7923, 8208, 8209, 8211, 8212, 8213, 8215, 8216, 8217, 8218, 8219, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8242, 8243, 8249, 8250, 8252, 8254, 8260, 8319, 8355, 8356, 8359, 8364, 8453, 8467, 8470, 8482, 8486, 8494, 8539, 8540, 8541, 8542, 8592, 8593, 8594, 8595, 8596, 8597, 8616, 8706, 8710, 8719, 8721, 8722, 8730, 8734, 8735, 8745, 8747, 8776, 8800, 8801, 8804, 8805, 8962, 8976, 8992, 8993, 9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9552, 9553, 9554, 9555, 9556, 9557, 9558, 9559, 9560, 9561, 9562, 9563, 9564, 9565, 9566, 9567, 9568, 9569, 9570, 9571, 9572, 9573, 9574, 9575, 9576, 9577, 9578, 9579, 9580, 9600, 9604, 9608, 9612, 9616, 9617, 9618, 9619, 9632, 9633, 9642, 9643, 9644, 9650, 9658, 9660, 9668, 9674, 9675, 9679, 9688, 9689, 9702, 9786, 9787, 9788, 9792, 9794, 9824, 9827, 9829, 9830, 9834, 9835, 9836, 61441, 61442, 61445, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
exports.LiberationSansBoldItalicMapping = LiberationSansBoldItalicMapping;
var LiberationSansItalicWidths = [365, 0, 333, 278, 278, 355, 556, 556, 889, 667, 191, 333, 333, 389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 278, 278, 584, 584, 584, 556, 1015, 667, 667, 722, 722, 667, 611, 778, 722, 278, 500, 667, 556, 833, 722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 278, 278, 278, 469, 556, 333, 556, 556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 556, 556, 556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 334, 260, 334, 584, 333, 556, 556, 556, 556, 260, 556, 333, 737, 370, 556, 584, 737, 552, 400, 549, 333, 333, 333, 576, 537, 278, 333, 333, 365, 556, 834, 834, 834, 611, 667, 667, 667, 667, 667, 667, 1000, 722, 667, 667, 667, 667, 278, 278, 278, 278, 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611, 556, 556, 556, 556, 556, 556, 889, 500, 556, 556, 556, 556, 278, 278, 278, 278, 556, 556, 556, 556, 556, 556, 556, 549, 611, 556, 556, 556, 556, 500, 556, 500, 667, 556, 667, 556, 667, 556, 722, 500, 722, 500, 722, 500, 722, 500, 722, 625, 722, 556, 667, 556, 667, 556, 667, 556, 667, 556, 667, 556, 778, 556, 778, 556, 778, 556, 778, 556, 722, 556, 722, 556, 278, 278, 278, 278, 278, 278, 278, 222, 278, 278, 733, 444, 500, 222, 667, 500, 500, 556, 222, 556, 222, 556, 281, 556, 400, 556, 222, 722, 556, 722, 556, 722, 556, 615, 723, 556, 778, 556, 778, 556, 778, 556, 1000, 944, 722, 333, 722, 333, 722, 333, 667, 500, 667, 500, 667, 500, 667, 500, 611, 278, 611, 354, 611, 278, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 944, 722, 667, 500, 667, 611, 500, 611, 500, 611, 500, 222, 556, 667, 556, 1000, 889, 778, 611, 667, 500, 611, 278, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 667, 278, 789, 846, 389, 794, 865, 775, 222, 667, 667, 570, 671, 667, 611, 722, 778, 278, 667, 667, 833, 722, 648, 778, 725, 667, 600, 611, 667, 837, 667, 831, 761, 278, 667, 570, 439, 555, 222, 550, 570, 571, 500, 556, 439, 463, 555, 542, 222, 500, 492, 548, 500, 447, 556, 670, 573, 486, 603, 374, 550, 652, 546, 728, 779, 222, 550, 556, 550, 779, 667, 667, 843, 544, 708, 667, 278, 278, 500, 1066, 982, 844, 589, 715, 639, 724, 667, 651, 667, 544, 704, 667, 917, 614, 715, 715, 589, 686, 833, 722, 778, 725, 667, 722, 611, 639, 795, 667, 727, 673, 920, 923, 805, 886, 651, 694, 1022, 682, 556, 562, 522, 493, 553, 556, 688, 465, 556, 556, 472, 564, 686, 550, 556, 556, 556, 500, 833, 500, 835, 500, 572, 518, 830, 851, 621, 736, 526, 492, 752, 534, 556, 556, 556, 378, 496, 500, 222, 222, 222, 910, 828, 556, 472, 565, 500, 556, 778, 556, 492, 339, 944, 722, 944, 722, 944, 722, 667, 500, 333, 333, 556, 1000, 1000, 552, 222, 222, 222, 222, 333, 333, 333, 556, 556, 350, 1000, 1000, 188, 354, 333, 333, 500, 333, 167, 365, 556, 556, 1094, 556, 885, 323, 1083, 1000, 768, 600, 834, 834, 834, 834, 1000, 500, 998, 500, 1000, 500, 500, 494, 612, 823, 713, 584, 549, 713, 979, 719, 274, 549, 549, 584, 549, 549, 604, 584, 604, 604, 708, 625, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 729, 604, 604, 354, 354, 1000, 990, 990, 990, 990, 494, 604, 604, 604, 604, 354, 1021, 1052, 917, 750, 750, 531, 656, 594, 510, 500, 750, 750, 500, 500, 333, 333, 333, 333, 333, 333, 333, 333, 222, 222, 294, 294, 324, 324, 316, 328, 398, 285];
exports.LiberationSansItalicWidths = LiberationSansItalicWidths;
var LiberationSansItalicMapping = [-1, -1, -1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 402, 506, 507, 508, 509, 510, 511, 536, 537, 538, 539, 710, 711, 713, 728, 729, 730, 731, 732, 733, 900, 901, 902, 903, 904, 905, 906, 908, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1138, 1139, 1168, 1169, 7808, 7809, 7810, 7811, 7812, 7813, 7922, 7923, 8208, 8209, 8211, 8212, 8213, 8215, 8216, 8217, 8218, 8219, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8242, 8243, 8249, 8250, 8252, 8254, 8260, 8319, 8355, 8356, 8359, 8364, 8453, 8467, 8470, 8482, 8486, 8494, 8539, 8540, 8541, 8542, 8592, 8593, 8594, 8595, 8596, 8597, 8616, 8706, 8710, 8719, 8721, 8722, 8730, 8734, 8735, 8745, 8747, 8776, 8800, 8801, 8804, 8805, 8962, 8976, 8992, 8993, 9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9552, 9553, 9554, 9555, 9556, 9557, 9558, 9559, 9560, 9561, 9562, 9563, 9564, 9565, 9566, 9567, 9568, 9569, 9570, 9571, 9572, 9573, 9574, 9575, 9576, 9577, 9578, 9579, 9580, 9600, 9604, 9608, 9612, 9616, 9617, 9618, 9619, 9632, 9633, 9642, 9643, 9644, 9650, 9658, 9660, 9668, 9674, 9675, 9679, 9688, 9689, 9702, 9786, 9787, 9788, 9792, 9794, 9824, 9827, 9829, 9830, 9834, 9835, 9836, 61441, 61442, 61445, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
exports.LiberationSansItalicMapping = LiberationSansItalicMapping;
var LiberationSansRegularWidths = [365, 0, 333, 278, 278, 355, 556, 556, 889, 667, 191, 333, 333, 389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 278, 278, 584, 584, 584, 556, 1015, 667, 667, 722, 722, 667, 611, 778, 722, 278, 500, 667, 556, 833, 722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 278, 278, 278, 469, 556, 333, 556, 556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 556, 556, 556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 334, 260, 334, 584, 333, 556, 556, 556, 556, 260, 556, 333, 737, 370, 556, 584, 737, 552, 400, 549, 333, 333, 333, 576, 537, 278, 333, 333, 365, 556, 834, 834, 834, 611, 667, 667, 667, 667, 667, 667, 1000, 722, 667, 667, 667, 667, 278, 278, 278, 278, 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611, 556, 556, 556, 556, 556, 556, 889, 500, 556, 556, 556, 556, 278, 278, 278, 278, 556, 556, 556, 556, 556, 556, 556, 549, 611, 556, 556, 556, 556, 500, 556, 500, 667, 556, 667, 556, 667, 556, 722, 500, 722, 500, 722, 500, 722, 500, 722, 615, 722, 556, 667, 556, 667, 556, 667, 556, 667, 556, 667, 556, 778, 556, 778, 556, 778, 556, 778, 556, 722, 556, 722, 556, 278, 278, 278, 278, 278, 278, 278, 222, 278, 278, 735, 444, 500, 222, 667, 500, 500, 556, 222, 556, 222, 556, 292, 556, 334, 556, 222, 722, 556, 722, 556, 722, 556, 604, 723, 556, 778, 556, 778, 556, 778, 556, 1000, 944, 722, 333, 722, 333, 722, 333, 667, 500, 667, 500, 667, 500, 667, 500, 611, 278, 611, 375, 611, 278, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 722, 556, 944, 722, 667, 500, 667, 611, 500, 611, 500, 611, 500, 222, 556, 667, 556, 1000, 889, 778, 611, 667, 500, 611, 278, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 667, 278, 784, 838, 384, 774, 855, 752, 222, 667, 667, 551, 668, 667, 611, 722, 778, 278, 667, 668, 833, 722, 650, 778, 722, 667, 618, 611, 667, 798, 667, 835, 748, 278, 667, 578, 446, 556, 222, 547, 578, 575, 500, 557, 446, 441, 556, 556, 222, 500, 500, 576, 500, 448, 556, 690, 569, 482, 617, 395, 547, 648, 525, 713, 781, 222, 547, 556, 547, 781, 667, 667, 865, 542, 719, 667, 278, 278, 500, 1057, 1010, 854, 583, 722, 635, 719, 667, 656, 667, 542, 677, 667, 923, 604, 719, 719, 583, 656, 833, 722, 778, 719, 667, 722, 611, 635, 760, 667, 740, 667, 917, 938, 792, 885, 656, 719, 1010, 722, 556, 573, 531, 365, 583, 556, 669, 458, 559, 559, 438, 583, 688, 552, 556, 542, 556, 500, 458, 500, 823, 500, 573, 521, 802, 823, 625, 719, 521, 510, 750, 542, 556, 556, 556, 365, 510, 500, 222, 278, 222, 906, 812, 556, 438, 559, 500, 552, 778, 556, 489, 411, 944, 722, 944, 722, 944, 722, 667, 500, 333, 333, 556, 1000, 1000, 552, 222, 222, 222, 222, 333, 333, 333, 556, 556, 350, 1000, 1000, 188, 354, 333, 333, 500, 333, 167, 365, 556, 556, 1094, 556, 885, 323, 1073, 1000, 768, 600, 834, 834, 834, 834, 1000, 500, 1000, 500, 1000, 500, 500, 494, 612, 823, 713, 584, 549, 713, 979, 719, 274, 549, 549, 583, 549, 549, 604, 584, 604, 604, 708, 625, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 708, 729, 604, 604, 354, 354, 1000, 990, 990, 990, 990, 494, 604, 604, 604, 604, 354, 1021, 1052, 917, 750, 750, 531, 656, 594, 510, 500, 750, 750, 500, 500, 333, 333, 333, 333, 333, 333, 333, 333, 222, 222, 294, 294, 324, 324, 316, 328, 398, 285];
exports.LiberationSansRegularWidths = LiberationSansRegularWidths;
var LiberationSansRegularMapping = [-1, -1, -1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 402, 506, 507, 508, 509, 510, 511, 536, 537, 538, 539, 710, 711, 713, 728, 729, 730, 731, 732, 733, 900, 901, 902, 903, 904, 905, 906, 908, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1138, 1139, 1168, 1169, 7808, 7809, 7810, 7811, 7812, 7813, 7922, 7923, 8208, 8209, 8211, 8212, 8213, 8215, 8216, 8217, 8218, 8219, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8242, 8243, 8249, 8250, 8252, 8254, 8260, 8319, 8355, 8356, 8359, 8364, 8453, 8467, 8470, 8482, 8486, 8494, 8539, 8540, 8541, 8542, 8592, 8593, 8594, 8595, 8596, 8597, 8616, 8706, 8710, 8719, 8721, 8722, 8730, 8734, 8735, 8745, 8747, 8776, 8800, 8801, 8804, 8805, 8962, 8976, 8992, 8993, 9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9552, 9553, 9554, 9555, 9556, 9557, 9558, 9559, 9560, 9561, 9562, 9563, 9564, 9565, 9566, 9567, 9568, 9569, 9570, 9571, 9572, 9573, 9574, 9575, 9576, 9577, 9578, 9579, 9580, 9600, 9604, 9608, 9612, 9616, 9617, 9618, 9619, 9632, 9633, 9642, 9643, 9644, 9650, 9658, 9660, 9668, 9674, 9675, 9679, 9688, 9689, 9702, 9786, 9787, 9788, 9792, 9794, 9824, 9827, 9829, 9830, 9834, 9835, 9836, 61441, 61442, 61445, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1];
exports.LiberationSansRegularMapping = LiberationSansRegularMapping;

/***/ }),
/* 158 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MyriadProRegularMetrics = exports.MyriadProRegularFactors = exports.MyriadProItalicMetrics = exports.MyriadProItalicFactors = exports.MyriadProBoldMetrics = exports.MyriadProBoldItalicMetrics = exports.MyriadProBoldItalicFactors = exports.MyriadProBoldFactors = void 0;
var MyriadProBoldFactors = [1.36898, 1, 1, 0.72706, 0.80479, 0.83734, 0.98894, 0.99793, 0.9897, 0.93884, 0.86209, 0.94292, 0.94292, 1.16661, 1.02058, 0.93582, 0.96694, 0.93582, 1.19137, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.99793, 0.78076, 0.78076, 1.02058, 1.02058, 1.02058, 0.72851, 0.78966, 0.90838, 0.83637, 0.82391, 0.96376, 0.80061, 0.86275, 0.8768, 0.95407, 1.0258, 0.73901, 0.85022, 0.83655, 1.0156, 0.95546, 0.92179, 0.87107, 0.92179, 0.82114, 0.8096, 0.89713, 0.94438, 0.95353, 0.94083, 0.91905, 0.90406, 0.9446, 0.94292, 1.18777, 0.94292, 1.02058, 0.89903, 0.90088, 0.94938, 0.97898, 0.81093, 0.97571, 0.94938, 1.024, 0.9577, 0.95933, 0.98621, 1.0474, 0.97455, 0.98981, 0.9672, 0.95933, 0.9446, 0.97898, 0.97407, 0.97646, 0.78036, 1.10208, 0.95442, 0.95298, 0.97579, 0.9332, 0.94039, 0.938, 0.80687, 1.01149, 0.80687, 1.02058, 0.80479, 0.99793, 0.99793, 0.99793, 0.99793, 1.01149, 1.00872, 0.90088, 0.91882, 1.0213, 0.8361, 1.02058, 0.62295, 0.54324, 0.89022, 1.08595, 1, 1, 0.90088, 1, 0.97455, 0.93582, 0.90088, 1, 1.05686, 0.8361, 0.99642, 0.99642, 0.99642, 0.72851, 0.90838, 0.90838, 0.90838, 0.90838, 0.90838, 0.90838, 0.868, 0.82391, 0.80061, 0.80061, 0.80061, 0.80061, 1.0258, 1.0258, 1.0258, 1.0258, 0.97484, 0.95546, 0.92179, 0.92179, 0.92179, 0.92179, 0.92179, 1.02058, 0.92179, 0.94438, 0.94438, 0.94438, 0.94438, 0.90406, 0.86958, 0.98225, 0.94938, 0.94938, 0.94938, 0.94938, 0.94938, 0.94938, 0.9031, 0.81093, 0.94938, 0.94938, 0.94938, 0.94938, 0.98621, 0.98621, 0.98621, 0.98621, 0.93969, 0.95933, 0.9446, 0.9446, 0.9446, 0.9446, 0.9446, 1.08595, 0.9446, 0.95442, 0.95442, 0.95442, 0.95442, 0.94039, 0.97898, 0.94039, 0.90838, 0.94938, 0.90838, 0.94938, 0.90838, 0.94938, 0.82391, 0.81093, 0.82391, 0.81093, 0.82391, 0.81093, 0.82391, 0.81093, 0.96376, 0.84313, 0.97484, 0.97571, 0.80061, 0.94938, 0.80061, 0.94938, 0.80061, 0.94938, 0.80061, 0.94938, 0.80061, 0.94938, 0.8768, 0.9577, 0.8768, 0.9577, 0.8768, 0.9577, 1, 1, 0.95407, 0.95933, 0.97069, 0.95933, 1.0258, 0.98621, 1.0258, 0.98621, 1.0258, 0.98621, 1.0258, 0.98621, 1.0258, 0.98621, 0.887, 1.01591, 0.73901, 1.0474, 1, 1, 0.97455, 0.83655, 0.98981, 1, 1, 0.83655, 0.73977, 0.83655, 0.73903, 0.84638, 1.033, 0.95546, 0.95933, 1, 1, 0.95546, 0.95933, 0.8271, 0.95417, 0.95933, 0.92179, 0.9446, 0.92179, 0.9446, 0.92179, 0.9446, 0.936, 0.91964, 0.82114, 0.97646, 1, 1, 0.82114, 0.97646, 0.8096, 0.78036, 0.8096, 0.78036, 1, 1, 0.8096, 0.78036, 1, 1, 0.89713, 0.77452, 0.89713, 1.10208, 0.94438, 0.95442, 0.94438, 0.95442, 0.94438, 0.95442, 0.94438, 0.95442, 0.94438, 0.95442, 0.94438, 0.95442, 0.94083, 0.97579, 0.90406, 0.94039, 0.90406, 0.9446, 0.938, 0.9446, 0.938, 0.9446, 0.938, 1, 0.99793, 0.90838, 0.94938, 0.868, 0.9031, 0.92179, 0.9446, 1, 1, 0.89713, 1.10208, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90989, 0.9358, 0.91945, 0.83181, 0.75261, 0.87992, 0.82976, 0.96034, 0.83689, 0.97268, 1.0078, 0.90838, 0.83637, 0.8019, 0.90157, 0.80061, 0.9446, 0.95407, 0.92436, 1.0258, 0.85022, 0.97153, 1.0156, 0.95546, 0.89192, 0.92179, 0.92361, 0.87107, 0.96318, 0.89713, 0.93704, 0.95638, 0.91905, 0.91709, 0.92796, 1.0258, 0.93704, 0.94836, 1.0373, 0.95933, 1.0078, 0.95871, 0.94836, 0.96174, 0.92601, 0.9498, 0.98607, 0.95776, 0.95933, 1.05453, 1.0078, 0.98275, 0.9314, 0.95617, 0.91701, 1.05993, 0.9446, 0.78367, 0.9553, 1, 0.86832, 1.0128, 0.95871, 0.99394, 0.87548, 0.96361, 0.86774, 1.0078, 0.95871, 0.9446, 0.95871, 0.86774, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.94083, 0.97579, 0.94083, 0.97579, 0.94083, 0.97579, 0.90406, 0.94039, 0.96694, 1, 0.89903, 1, 1, 1, 0.93582, 0.93582, 0.93582, 1, 0.908, 0.908, 0.918, 0.94219, 0.94219, 0.96544, 1, 1.285, 1, 1, 0.81079, 0.81079, 1, 1, 0.74854, 1, 1, 1, 1, 0.99793, 1, 1, 1, 0.65, 1, 1.36145, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.17173, 1, 0.80535, 0.76169, 1.02058, 1.0732, 1.05486, 1, 1, 1.30692, 1.08595, 1.08595, 1, 1.08595, 1.08595, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.16161, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.MyriadProBoldFactors = MyriadProBoldFactors;
var MyriadProBoldMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.MyriadProBoldMetrics = MyriadProBoldMetrics;
var MyriadProBoldItalicFactors = [1.36898, 1, 1, 0.66227, 0.80779, 0.81625, 0.97276, 0.97276, 0.97733, 0.92222, 0.83266, 0.94292, 0.94292, 1.16148, 1.02058, 0.93582, 0.96694, 0.93582, 1.17337, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.97276, 0.78076, 0.78076, 1.02058, 1.02058, 1.02058, 0.71541, 0.76813, 0.85576, 0.80591, 0.80729, 0.94299, 0.77512, 0.83655, 0.86523, 0.92222, 0.98621, 0.71743, 0.81698, 0.79726, 0.98558, 0.92222, 0.90637, 0.83809, 0.90637, 0.80729, 0.76463, 0.86275, 0.90699, 0.91605, 0.9154, 0.85308, 0.85458, 0.90531, 0.94292, 1.21296, 0.94292, 1.02058, 0.89903, 1.18616, 0.99613, 0.91677, 0.78216, 0.91677, 0.90083, 0.98796, 0.9135, 0.92168, 0.95381, 0.98981, 0.95298, 0.95381, 0.93459, 0.92168, 0.91513, 0.92004, 0.91677, 0.95077, 0.748, 1.04502, 0.91677, 0.92061, 0.94236, 0.89544, 0.89364, 0.9, 0.80687, 0.8578, 0.80687, 1.02058, 0.80779, 0.97276, 0.97276, 0.97276, 0.97276, 0.8578, 0.99973, 1.18616, 0.91339, 1.08074, 0.82891, 1.02058, 0.55509, 0.71526, 0.89022, 1.08595, 1, 1, 1.18616, 1, 0.96736, 0.93582, 1.18616, 1, 1.04864, 0.82711, 0.99043, 0.99043, 0.99043, 0.71541, 0.85576, 0.85576, 0.85576, 0.85576, 0.85576, 0.85576, 0.845, 0.80729, 0.77512, 0.77512, 0.77512, 0.77512, 0.98621, 0.98621, 0.98621, 0.98621, 0.95961, 0.92222, 0.90637, 0.90637, 0.90637, 0.90637, 0.90637, 1.02058, 0.90251, 0.90699, 0.90699, 0.90699, 0.90699, 0.85458, 0.83659, 0.94951, 0.99613, 0.99613, 0.99613, 0.99613, 0.99613, 0.99613, 0.85811, 0.78216, 0.90083, 0.90083, 0.90083, 0.90083, 0.95381, 0.95381, 0.95381, 0.95381, 0.9135, 0.92168, 0.91513, 0.91513, 0.91513, 0.91513, 0.91513, 1.08595, 0.91677, 0.91677, 0.91677, 0.91677, 0.91677, 0.89364, 0.92332, 0.89364, 0.85576, 0.99613, 0.85576, 0.99613, 0.85576, 0.99613, 0.80729, 0.78216, 0.80729, 0.78216, 0.80729, 0.78216, 0.80729, 0.78216, 0.94299, 0.76783, 0.95961, 0.91677, 0.77512, 0.90083, 0.77512, 0.90083, 0.77512, 0.90083, 0.77512, 0.90083, 0.77512, 0.90083, 0.86523, 0.9135, 0.86523, 0.9135, 0.86523, 0.9135, 1, 1, 0.92222, 0.92168, 0.92222, 0.92168, 0.98621, 0.95381, 0.98621, 0.95381, 0.98621, 0.95381, 0.98621, 0.95381, 0.98621, 0.95381, 0.86036, 0.97096, 0.71743, 0.98981, 1, 1, 0.95298, 0.79726, 0.95381, 1, 1, 0.79726, 0.6894, 0.79726, 0.74321, 0.81691, 1.0006, 0.92222, 0.92168, 1, 1, 0.92222, 0.92168, 0.79464, 0.92098, 0.92168, 0.90637, 0.91513, 0.90637, 0.91513, 0.90637, 0.91513, 0.909, 0.87514, 0.80729, 0.95077, 1, 1, 0.80729, 0.95077, 0.76463, 0.748, 0.76463, 0.748, 1, 1, 0.76463, 0.748, 1, 1, 0.86275, 0.72651, 0.86275, 1.04502, 0.90699, 0.91677, 0.90699, 0.91677, 0.90699, 0.91677, 0.90699, 0.91677, 0.90699, 0.91677, 0.90699, 0.91677, 0.9154, 0.94236, 0.85458, 0.89364, 0.85458, 0.90531, 0.9, 0.90531, 0.9, 0.90531, 0.9, 1, 0.97276, 0.85576, 0.99613, 0.845, 0.85811, 0.90251, 0.91677, 1, 1, 0.86275, 1.04502, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.18616, 1.00899, 1.30628, 0.85576, 0.80178, 0.66862, 0.7927, 0.69323, 0.88127, 0.72459, 0.89711, 0.95381, 0.85576, 0.80591, 0.7805, 0.94729, 0.77512, 0.90531, 0.92222, 0.90637, 0.98621, 0.81698, 0.92655, 0.98558, 0.92222, 0.85359, 0.90637, 0.90976, 0.83809, 0.94523, 0.86275, 0.83509, 0.93157, 0.85308, 0.83392, 0.92346, 0.98621, 0.83509, 0.92886, 0.91324, 0.92168, 0.95381, 0.90646, 0.92886, 0.90557, 0.86847, 0.90276, 0.91324, 0.86842, 0.92168, 0.99531, 0.95381, 0.9224, 0.85408, 0.92699, 0.86847, 1.0051, 0.91513, 0.80487, 0.93481, 1, 0.88159, 1.05214, 0.90646, 0.97355, 0.81539, 0.89398, 0.85923, 0.95381, 0.90646, 0.91513, 0.90646, 0.85923, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.9154, 0.94236, 0.9154, 0.94236, 0.9154, 0.94236, 0.85458, 0.89364, 0.96694, 1, 0.89903, 1, 1, 1, 0.91782, 0.91782, 0.91782, 1, 0.896, 0.896, 0.896, 0.9332, 0.9332, 0.95973, 1, 1.26, 1, 1, 0.80479, 0.80178, 1, 1, 0.85633, 1, 1, 1, 1, 0.97276, 1, 1, 1, 0.698, 1, 1.36145, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.14542, 1, 0.79199, 0.78694, 1.02058, 1.03493, 1.05486, 1, 1, 1.23026, 1.08595, 1.08595, 1, 1.08595, 1.08595, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.20006, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.MyriadProBoldItalicFactors = MyriadProBoldItalicFactors;
var MyriadProBoldItalicMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.MyriadProBoldItalicMetrics = MyriadProBoldItalicMetrics;
var MyriadProItalicFactors = [1.36898, 1, 1, 0.65507, 0.84943, 0.85639, 0.88465, 0.88465, 0.86936, 0.88307, 0.86948, 0.85283, 0.85283, 1.06383, 1.02058, 0.75945, 0.9219, 0.75945, 1.17337, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.88465, 0.75945, 0.75945, 1.02058, 1.02058, 1.02058, 0.69046, 0.70926, 0.85158, 0.77812, 0.76852, 0.89591, 0.70466, 0.76125, 0.80094, 0.86822, 0.83864, 0.728, 0.77212, 0.79475, 0.93637, 0.87514, 0.8588, 0.76013, 0.8588, 0.72421, 0.69866, 0.77598, 0.85991, 0.80811, 0.87832, 0.78112, 0.77512, 0.8562, 1.0222, 1.18417, 1.0222, 1.27014, 0.89903, 1.15012, 0.93859, 0.94399, 0.846, 0.94399, 0.81453, 1.0186, 0.94219, 0.96017, 1.03075, 1.02175, 0.912, 1.03075, 0.96998, 0.96017, 0.93859, 0.94399, 0.94399, 0.95493, 0.746, 1.12658, 0.94578, 0.91, 0.979, 0.882, 0.882, 0.83, 0.85034, 0.83537, 0.85034, 1.02058, 0.70869, 0.88465, 0.88465, 0.88465, 0.88465, 0.83537, 0.90083, 1.15012, 0.9161, 0.94565, 0.73541, 1.02058, 0.53609, 0.69353, 0.79519, 1.08595, 1, 1, 1.15012, 1, 0.91974, 0.75945, 1.15012, 1, 0.9446, 0.73361, 0.9005, 0.9005, 0.9005, 0.62864, 0.85158, 0.85158, 0.85158, 0.85158, 0.85158, 0.85158, 0.773, 0.76852, 0.70466, 0.70466, 0.70466, 0.70466, 0.83864, 0.83864, 0.83864, 0.83864, 0.90561, 0.87514, 0.8588, 0.8588, 0.8588, 0.8588, 0.8588, 1.02058, 0.85751, 0.85991, 0.85991, 0.85991, 0.85991, 0.77512, 0.76013, 0.88075, 0.93859, 0.93859, 0.93859, 0.93859, 0.93859, 0.93859, 0.8075, 0.846, 0.81453, 0.81453, 0.81453, 0.81453, 0.82424, 0.82424, 0.82424, 0.82424, 0.9278, 0.96017, 0.93859, 0.93859, 0.93859, 0.93859, 0.93859, 1.08595, 0.8562, 0.94578, 0.94578, 0.94578, 0.94578, 0.882, 0.94578, 0.882, 0.85158, 0.93859, 0.85158, 0.93859, 0.85158, 0.93859, 0.76852, 0.846, 0.76852, 0.846, 0.76852, 0.846, 0.76852, 0.846, 0.89591, 0.8544, 0.90561, 0.94399, 0.70466, 0.81453, 0.70466, 0.81453, 0.70466, 0.81453, 0.70466, 0.81453, 0.70466, 0.81453, 0.80094, 0.94219, 0.80094, 0.94219, 0.80094, 0.94219, 1, 1, 0.86822, 0.96017, 0.86822, 0.96017, 0.83864, 0.82424, 0.83864, 0.82424, 0.83864, 0.82424, 0.83864, 1.03075, 0.83864, 0.82424, 0.81402, 1.02738, 0.728, 1.02175, 1, 1, 0.912, 0.79475, 1.03075, 1, 1, 0.79475, 0.83911, 0.79475, 0.66266, 0.80553, 1.06676, 0.87514, 0.96017, 1, 1, 0.87514, 0.96017, 0.86865, 0.87396, 0.96017, 0.8588, 0.93859, 0.8588, 0.93859, 0.8588, 0.93859, 0.867, 0.84759, 0.72421, 0.95493, 1, 1, 0.72421, 0.95493, 0.69866, 0.746, 0.69866, 0.746, 1, 1, 0.69866, 0.746, 1, 1, 0.77598, 0.88417, 0.77598, 1.12658, 0.85991, 0.94578, 0.85991, 0.94578, 0.85991, 0.94578, 0.85991, 0.94578, 0.85991, 0.94578, 0.85991, 0.94578, 0.87832, 0.979, 0.77512, 0.882, 0.77512, 0.8562, 0.83, 0.8562, 0.83, 0.8562, 0.83, 1, 0.88465, 0.85158, 0.93859, 0.773, 0.8075, 0.85751, 0.8562, 1, 1, 0.77598, 1.12658, 1.15012, 1.15012, 1.15012, 1.15012, 1.15012, 1.15313, 1.15012, 1.15012, 1.15012, 1.08106, 1.03901, 0.85158, 0.77025, 0.62264, 0.7646, 0.65351, 0.86026, 0.69461, 0.89947, 1.03075, 0.85158, 0.77812, 0.76449, 0.88836, 0.70466, 0.8562, 0.86822, 0.8588, 0.83864, 0.77212, 0.85308, 0.93637, 0.87514, 0.82352, 0.8588, 0.85701, 0.76013, 0.89058, 0.77598, 0.8156, 0.82565, 0.78112, 0.77899, 0.89386, 0.83864, 0.8156, 0.9486, 0.92388, 0.96186, 1.03075, 0.91123, 0.9486, 0.93298, 0.878, 0.93942, 0.92388, 0.84596, 0.96186, 0.95119, 1.03075, 0.922, 0.88787, 0.95829, 0.88, 0.93559, 0.93859, 0.78815, 0.93758, 1, 0.89217, 1.03737, 0.91123, 0.93969, 0.77487, 0.85769, 0.86799, 1.03075, 0.91123, 0.93859, 0.91123, 0.86799, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.87832, 0.979, 0.87832, 0.979, 0.87832, 0.979, 0.77512, 0.882, 0.9219, 1, 0.89903, 1, 1, 1, 0.87321, 0.87321, 0.87321, 1, 1.027, 1.027, 1.027, 0.86847, 0.86847, 0.79121, 1, 1.124, 1, 1, 0.73572, 0.73572, 1, 1, 0.85034, 1, 1, 1, 1, 0.88465, 1, 1, 1, 0.669, 1, 1.36145, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.04828, 1, 0.74948, 0.75187, 1.02058, 0.98391, 1.02119, 1, 1, 1.06233, 1.08595, 1.08595, 1, 1.08595, 1.08595, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05233, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.MyriadProItalicFactors = MyriadProItalicFactors;
var MyriadProItalicMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.MyriadProItalicMetrics = MyriadProItalicMetrics;
var MyriadProRegularFactors = [1.36898, 1, 1, 0.76305, 0.82784, 0.94935, 0.89364, 0.92241, 0.89073, 0.90706, 0.98472, 0.85283, 0.85283, 1.0664, 1.02058, 0.74505, 0.9219, 0.74505, 1.23456, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.92241, 0.74505, 0.74505, 1.02058, 1.02058, 1.02058, 0.73002, 0.72601, 0.91755, 0.8126, 0.80314, 0.92222, 0.73764, 0.79726, 0.83051, 0.90284, 0.86023, 0.74, 0.8126, 0.84869, 0.96518, 0.91115, 0.8858, 0.79761, 0.8858, 0.74498, 0.73914, 0.81363, 0.89591, 0.83659, 0.89633, 0.85608, 0.8111, 0.90531, 1.0222, 1.22736, 1.0222, 1.27014, 0.89903, 0.90088, 0.86667, 1.0231, 0.896, 1.01411, 0.90083, 1.05099, 1.00512, 0.99793, 1.05326, 1.09377, 0.938, 1.06226, 1.00119, 0.99793, 0.98714, 1.0231, 1.01231, 0.98196, 0.792, 1.19137, 0.99074, 0.962, 1.01915, 0.926, 0.942, 0.856, 0.85034, 0.92006, 0.85034, 1.02058, 0.69067, 0.92241, 0.92241, 0.92241, 0.92241, 0.92006, 0.9332, 0.90088, 0.91882, 0.93484, 0.75339, 1.02058, 0.56866, 0.54324, 0.79519, 1.08595, 1, 1, 0.90088, 1, 0.95325, 0.74505, 0.90088, 1, 0.97198, 0.75339, 0.91009, 0.91009, 0.91009, 0.66466, 0.91755, 0.91755, 0.91755, 0.91755, 0.91755, 0.91755, 0.788, 0.80314, 0.73764, 0.73764, 0.73764, 0.73764, 0.86023, 0.86023, 0.86023, 0.86023, 0.92915, 0.91115, 0.8858, 0.8858, 0.8858, 0.8858, 0.8858, 1.02058, 0.8858, 0.89591, 0.89591, 0.89591, 0.89591, 0.8111, 0.79611, 0.89713, 0.86667, 0.86667, 0.86667, 0.86667, 0.86667, 0.86667, 0.86936, 0.896, 0.90083, 0.90083, 0.90083, 0.90083, 0.84224, 0.84224, 0.84224, 0.84224, 0.97276, 0.99793, 0.98714, 0.98714, 0.98714, 0.98714, 0.98714, 1.08595, 0.89876, 0.99074, 0.99074, 0.99074, 0.99074, 0.942, 1.0231, 0.942, 0.91755, 0.86667, 0.91755, 0.86667, 0.91755, 0.86667, 0.80314, 0.896, 0.80314, 0.896, 0.80314, 0.896, 0.80314, 0.896, 0.92222, 0.93372, 0.92915, 1.01411, 0.73764, 0.90083, 0.73764, 0.90083, 0.73764, 0.90083, 0.73764, 0.90083, 0.73764, 0.90083, 0.83051, 1.00512, 0.83051, 1.00512, 0.83051, 1.00512, 1, 1, 0.90284, 0.99793, 0.90976, 0.99793, 0.86023, 0.84224, 0.86023, 0.84224, 0.86023, 0.84224, 0.86023, 1.05326, 0.86023, 0.84224, 0.82873, 1.07469, 0.74, 1.09377, 1, 1, 0.938, 0.84869, 1.06226, 1, 1, 0.84869, 0.83704, 0.84869, 0.81441, 0.85588, 1.08927, 0.91115, 0.99793, 1, 1, 0.91115, 0.99793, 0.91887, 0.90991, 0.99793, 0.8858, 0.98714, 0.8858, 0.98714, 0.8858, 0.98714, 0.894, 0.91434, 0.74498, 0.98196, 1, 1, 0.74498, 0.98196, 0.73914, 0.792, 0.73914, 0.792, 1, 1, 0.73914, 0.792, 1, 1, 0.81363, 0.904, 0.81363, 1.19137, 0.89591, 0.99074, 0.89591, 0.99074, 0.89591, 0.99074, 0.89591, 0.99074, 0.89591, 0.99074, 0.89591, 0.99074, 0.89633, 1.01915, 0.8111, 0.942, 0.8111, 0.90531, 0.856, 0.90531, 0.856, 0.90531, 0.856, 1, 0.92241, 0.91755, 0.86667, 0.788, 0.86936, 0.8858, 0.89876, 1, 1, 0.81363, 1.19137, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90088, 0.90388, 1.03901, 0.92138, 0.78105, 0.7154, 0.86169, 0.80513, 0.94007, 0.82528, 0.98612, 1.06226, 0.91755, 0.8126, 0.81884, 0.92819, 0.73764, 0.90531, 0.90284, 0.8858, 0.86023, 0.8126, 0.91172, 0.96518, 0.91115, 0.83089, 0.8858, 0.87791, 0.79761, 0.89297, 0.81363, 0.88157, 0.89992, 0.85608, 0.81992, 0.94307, 0.86023, 0.88157, 0.95308, 0.98699, 0.99793, 1.06226, 0.95817, 0.95308, 0.97358, 0.928, 0.98088, 0.98699, 0.92761, 0.99793, 0.96017, 1.06226, 0.986, 0.944, 0.95978, 0.938, 0.96705, 0.98714, 0.80442, 0.98972, 1, 0.89762, 1.04552, 0.95817, 0.99007, 0.87064, 0.91879, 0.88888, 1.06226, 0.95817, 0.98714, 0.95817, 0.88888, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.89633, 1.01915, 0.89633, 1.01915, 0.89633, 1.01915, 0.8111, 0.942, 0.9219, 1, 0.89903, 1, 1, 1, 0.93173, 0.93173, 0.93173, 1, 1.06304, 1.06304, 1.06904, 0.89903, 0.89903, 0.80549, 1, 1.156, 1, 1, 0.76575, 0.76575, 1, 1, 0.72458, 1, 1, 1, 1, 0.92241, 1, 1, 1, 0.619, 1, 1.36145, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.07257, 1, 0.74705, 0.71119, 1.02058, 1.024, 1.02119, 1, 1, 1.1536, 1.08595, 1.08595, 1, 1.08595, 1.08595, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05638, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.MyriadProRegularFactors = MyriadProRegularFactors;
var MyriadProRegularMetrics = {
  lineHeight: 1.2,
  lineGap: 0.2
};
exports.MyriadProRegularMetrics = MyriadProRegularMetrics;

/***/ }),
/* 159 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SegoeuiRegularMetrics = exports.SegoeuiRegularFactors = exports.SegoeuiItalicMetrics = exports.SegoeuiItalicFactors = exports.SegoeuiBoldMetrics = exports.SegoeuiBoldItalicMetrics = exports.SegoeuiBoldItalicFactors = exports.SegoeuiBoldFactors = void 0;
var SegoeuiBoldFactors = [1.76738, 1, 1, 0.99297, 0.9824, 1.04016, 1.06497, 1.03424, 0.97529, 1.17647, 1.23203, 1.1085, 1.1085, 1.16939, 1.2107, 0.9754, 1.21408, 0.9754, 1.59578, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 1.03424, 0.81378, 0.81378, 1.2107, 1.2107, 1.2107, 0.71703, 0.97847, 0.97363, 0.88776, 0.8641, 1.02096, 0.79795, 0.85132, 0.914, 1.06085, 1.1406, 0.8007, 0.89858, 0.83693, 1.14889, 1.09398, 0.97489, 0.92094, 0.97489, 0.90399, 0.84041, 0.95923, 1.00135, 1, 1.06467, 0.98243, 0.90996, 0.99361, 1.1085, 1.56942, 1.1085, 1.2107, 0.74627, 0.94282, 0.96752, 1.01519, 0.86304, 1.01359, 0.97278, 1.15103, 1.01359, 0.98561, 1.02285, 1.02285, 1.00527, 1.02285, 1.0302, 0.99041, 1.0008, 1.01519, 1.01359, 1.02258, 0.79104, 1.16862, 0.99041, 0.97454, 1.02511, 0.99298, 0.96752, 0.95801, 0.94856, 1.16579, 0.94856, 1.2107, 0.9824, 1.03424, 1.03424, 1, 1.03424, 1.16579, 0.8727, 1.3871, 1.18622, 1.10818, 1.04478, 1.2107, 1.18622, 0.75155, 0.94994, 1.28826, 1.21408, 1.21408, 0.91056, 1, 0.91572, 0.9754, 0.64663, 1.18328, 1.24866, 1.04478, 1.14169, 1.15749, 1.17389, 0.71703, 0.97363, 0.97363, 0.97363, 0.97363, 0.97363, 0.97363, 0.93506, 0.8641, 0.79795, 0.79795, 0.79795, 0.79795, 1.1406, 1.1406, 1.1406, 1.1406, 1.02096, 1.09398, 0.97426, 0.97426, 0.97426, 0.97426, 0.97426, 1.2107, 0.97489, 1.00135, 1.00135, 1.00135, 1.00135, 0.90996, 0.92094, 1.02798, 0.96752, 0.96752, 0.96752, 0.96752, 0.96752, 0.96752, 0.93136, 0.86304, 0.97278, 0.97278, 0.97278, 0.97278, 1.02285, 1.02285, 1.02285, 1.02285, 0.97122, 0.99041, 1, 1, 1, 1, 1, 1.28826, 1.0008, 0.99041, 0.99041, 0.99041, 0.99041, 0.96752, 1.01519, 0.96752, 0.97363, 0.96752, 0.97363, 0.96752, 0.97363, 0.96752, 0.8641, 0.86304, 0.8641, 0.86304, 0.8641, 0.86304, 0.8641, 0.86304, 1.02096, 1.03057, 1.02096, 1.03517, 0.79795, 0.97278, 0.79795, 0.97278, 0.79795, 0.97278, 0.79795, 0.97278, 0.79795, 0.97278, 0.914, 1.01359, 0.914, 1.01359, 0.914, 1.01359, 1, 1, 1.06085, 0.98561, 1.06085, 1.00879, 1.1406, 1.02285, 1.1406, 1.02285, 1.1406, 1.02285, 1.1406, 1.02285, 1.1406, 1.02285, 0.97138, 1.08692, 0.8007, 1.02285, 1, 1, 1.00527, 0.83693, 1.02285, 1, 1, 0.83693, 0.9455, 0.83693, 0.90418, 0.83693, 1.13005, 1.09398, 0.99041, 1, 1, 1.09398, 0.99041, 0.96692, 1.09251, 0.99041, 0.97489, 1.0008, 0.97489, 1.0008, 0.97489, 1.0008, 0.93994, 0.97931, 0.90399, 1.02258, 1, 1, 0.90399, 1.02258, 0.84041, 0.79104, 0.84041, 0.79104, 0.84041, 0.79104, 0.84041, 0.79104, 1, 1, 0.95923, 1.07034, 0.95923, 1.16862, 1.00135, 0.99041, 1.00135, 0.99041, 1.00135, 0.99041, 1.00135, 0.99041, 1.00135, 0.99041, 1.00135, 0.99041, 1.06467, 1.02511, 0.90996, 0.96752, 0.90996, 0.99361, 0.95801, 0.99361, 0.95801, 0.99361, 0.95801, 1.07733, 1.03424, 0.97363, 0.96752, 0.93506, 0.93136, 0.97489, 1.0008, 1, 1, 0.95923, 1.16862, 1.15103, 1.15103, 1.01173, 1.03959, 0.75953, 0.81378, 0.79912, 1.15103, 1.21994, 0.95161, 0.87815, 1.01149, 0.81525, 0.7676, 0.98167, 1.01134, 1.02546, 0.84097, 1.03089, 1.18102, 0.97363, 0.88776, 0.85134, 0.97826, 0.79795, 0.99361, 1.06085, 0.97489, 1.1406, 0.89858, 1.0388, 1.14889, 1.09398, 0.86039, 0.97489, 1.0595, 0.92094, 0.94793, 0.95923, 0.90996, 0.99346, 0.98243, 1.02112, 0.95493, 1.1406, 0.90996, 1.03574, 1.02597, 1.0008, 1.18102, 1.06628, 1.03574, 1.0192, 1.01932, 1.00886, 0.97531, 1.0106, 1.0008, 1.13189, 1.18102, 1.02277, 0.98683, 1.0016, 0.99561, 1.07237, 1.0008, 0.90434, 0.99921, 0.93803, 0.8965, 1.23085, 1.06628, 1.04983, 0.96268, 1.0499, 0.98439, 1.18102, 1.06628, 1.0008, 1.06628, 0.98439, 0.79795, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.09466, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.97278, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.02065, 1, 1, 1, 1, 1, 1, 1.06467, 1.02511, 1.06467, 1.02511, 1.06467, 1.02511, 0.90996, 0.96752, 1, 1.21408, 0.89903, 1, 1, 0.75155, 1.04394, 1.04394, 1.04394, 1.04394, 0.98633, 0.98633, 0.98633, 0.73047, 0.73047, 1.20642, 0.91211, 1.25635, 1.222, 1.02956, 1.03372, 1.03372, 0.96039, 1.24633, 1, 1.12454, 0.93503, 1.03424, 1.19687, 1.03424, 1, 1, 1, 0.771, 1, 1, 1.15749, 1.15749, 1.15749, 1.10948, 0.86279, 0.94434, 0.86279, 0.94434, 0.86182, 1, 1, 1.16897, 1, 0.96085, 0.90137, 1.2107, 1.18416, 1.13973, 0.69825, 0.9716, 2.10339, 1.29004, 1.29004, 1.21172, 1.29004, 1.29004, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.42603, 1, 0.99862, 0.99862, 1, 0.87025, 0.87025, 0.87025, 0.87025, 1.18874, 1.42603, 1, 1.42603, 1.42603, 0.99862, 1, 1, 1, 1, 1, 1.2886, 1.04315, 1.15296, 1.34163, 1, 1, 1, 1.09193, 1.09193, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.SegoeuiBoldFactors = SegoeuiBoldFactors;
var SegoeuiBoldMetrics = {
  lineHeight: 1.33008,
  lineGap: 0
};
exports.SegoeuiBoldMetrics = SegoeuiBoldMetrics;
var SegoeuiBoldItalicFactors = [1.76738, 1, 1, 0.98946, 1.03959, 1.04016, 1.02809, 1.036, 0.97639, 1.10953, 1.23203, 1.11144, 1.11144, 1.16939, 1.21237, 0.9754, 1.21261, 0.9754, 1.59754, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 1.036, 0.81378, 0.81378, 1.21237, 1.21237, 1.21237, 0.73541, 0.97847, 0.97363, 0.89723, 0.87897, 1.0426, 0.79429, 0.85292, 0.91149, 1.05815, 1.1406, 0.79631, 0.90128, 0.83853, 1.04396, 1.10615, 0.97552, 0.94436, 0.97552, 0.88641, 0.80527, 0.96083, 1.00135, 1, 1.06777, 0.9817, 0.91142, 0.99361, 1.11144, 1.57293, 1.11144, 1.21237, 0.74627, 1.31818, 1.06585, 0.97042, 0.83055, 0.97042, 0.93503, 1.1261, 0.97042, 0.97922, 1.14236, 0.94552, 1.01054, 1.14236, 1.02471, 0.97922, 0.94165, 0.97042, 0.97042, 1.0276, 0.78929, 1.1261, 0.97922, 0.95874, 1.02197, 0.98507, 0.96752, 0.97168, 0.95107, 1.16579, 0.95107, 1.21237, 1.03959, 1.036, 1.036, 1, 1.036, 1.16579, 0.87357, 1.31818, 1.18754, 1.26781, 1.05356, 1.21237, 1.18622, 0.79487, 0.94994, 1.29004, 1.24047, 1.24047, 1.31818, 1, 0.91484, 0.9754, 1.31818, 1.1349, 1.24866, 1.05356, 1.13934, 1.15574, 1.17389, 0.73541, 0.97363, 0.97363, 0.97363, 0.97363, 0.97363, 0.97363, 0.94385, 0.87897, 0.79429, 0.79429, 0.79429, 0.79429, 1.1406, 1.1406, 1.1406, 1.1406, 1.0426, 1.10615, 0.97552, 0.97552, 0.97552, 0.97552, 0.97552, 1.21237, 0.97552, 1.00135, 1.00135, 1.00135, 1.00135, 0.91142, 0.94436, 0.98721, 1.06585, 1.06585, 1.06585, 1.06585, 1.06585, 1.06585, 0.96705, 0.83055, 0.93503, 0.93503, 0.93503, 0.93503, 1.14236, 1.14236, 1.14236, 1.14236, 0.93125, 0.97922, 0.94165, 0.94165, 0.94165, 0.94165, 0.94165, 1.29004, 0.94165, 0.97922, 0.97922, 0.97922, 0.97922, 0.96752, 0.97042, 0.96752, 0.97363, 1.06585, 0.97363, 1.06585, 0.97363, 1.06585, 0.87897, 0.83055, 0.87897, 0.83055, 0.87897, 0.83055, 0.87897, 0.83055, 1.0426, 1.0033, 1.0426, 0.97042, 0.79429, 0.93503, 0.79429, 0.93503, 0.79429, 0.93503, 0.79429, 0.93503, 0.79429, 0.93503, 0.91149, 0.97042, 0.91149, 0.97042, 0.91149, 0.97042, 1, 1, 1.05815, 0.97922, 1.05815, 0.97922, 1.1406, 1.14236, 1.1406, 1.14236, 1.1406, 1.14236, 1.1406, 1.14236, 1.1406, 1.14236, 0.97441, 1.04302, 0.79631, 1.01582, 1, 1, 1.01054, 0.83853, 1.14236, 1, 1, 0.83853, 1.09125, 0.83853, 0.90418, 0.83853, 1.19508, 1.10615, 0.97922, 1, 1, 1.10615, 0.97922, 1.01034, 1.10466, 0.97922, 0.97552, 0.94165, 0.97552, 0.94165, 0.97552, 0.94165, 0.91602, 0.91981, 0.88641, 1.0276, 1, 1, 0.88641, 1.0276, 0.80527, 0.78929, 0.80527, 0.78929, 0.80527, 0.78929, 0.80527, 0.78929, 1, 1, 0.96083, 1.05403, 0.95923, 1.16862, 1.00135, 0.97922, 1.00135, 0.97922, 1.00135, 0.97922, 1.00135, 0.97922, 1.00135, 0.97922, 1.00135, 0.97922, 1.06777, 1.02197, 0.91142, 0.96752, 0.91142, 0.99361, 0.97168, 0.99361, 0.97168, 0.99361, 0.97168, 1.23199, 1.036, 0.97363, 1.06585, 0.94385, 0.96705, 0.97552, 0.94165, 1, 1, 0.96083, 1.1261, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 1.31818, 0.95161, 1.27126, 1.00811, 0.83284, 0.77702, 0.99137, 0.95253, 1.0347, 0.86142, 1.07205, 1.14236, 0.97363, 0.89723, 0.86869, 1.09818, 0.79429, 0.99361, 1.05815, 0.97552, 1.1406, 0.90128, 1.06662, 1.04396, 1.10615, 0.84918, 0.97552, 1.04694, 0.94436, 0.98015, 0.96083, 0.91142, 1.00356, 0.9817, 1.01945, 0.98999, 1.1406, 0.91142, 1.04961, 0.9898, 1.00639, 1.14236, 1.07514, 1.04961, 0.99607, 1.02897, 1.008, 0.9898, 0.95134, 1.00639, 1.11121, 1.14236, 1.00518, 0.97981, 1.02186, 1, 1.08578, 0.94165, 0.99314, 0.98387, 0.93028, 0.93377, 1.35125, 1.07514, 1.10687, 0.93491, 1.04232, 1.00351, 1.14236, 1.07514, 0.94165, 1.07514, 1.00351, 0.79429, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.09097, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.93503, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.96609, 1, 1, 1, 1, 1, 1, 1.06777, 1.02197, 1.06777, 1.02197, 1.06777, 1.02197, 0.91142, 0.96752, 1, 1.21261, 0.89903, 1, 1, 0.75155, 1.04745, 1.04745, 1.04745, 1.04394, 0.98633, 0.98633, 0.98633, 0.72959, 0.72959, 1.20502, 0.91406, 1.26514, 1.222, 1.02956, 1.03372, 1.03372, 0.96039, 1.24633, 1, 1.09125, 0.93327, 1.03336, 1.16541, 1.036, 1, 1, 1, 0.771, 1, 1, 1.15574, 1.15574, 1.15574, 1.15574, 0.86364, 0.94434, 0.86279, 0.94434, 0.86224, 1, 1, 1.16798, 1, 0.96085, 0.90068, 1.21237, 1.18416, 1.13904, 0.69825, 0.9716, 2.10339, 1.29004, 1.29004, 1.21339, 1.29004, 1.29004, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.42603, 1, 0.99862, 0.99862, 1, 0.87025, 0.87025, 0.87025, 0.87025, 1.18775, 1.42603, 1, 1.42603, 1.42603, 0.99862, 1, 1, 1, 1, 1, 1.2886, 1.04315, 1.15296, 1.34163, 1, 1, 1, 1.13269, 1.13269, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.SegoeuiBoldItalicFactors = SegoeuiBoldItalicFactors;
var SegoeuiBoldItalicMetrics = {
  lineHeight: 1.33008,
  lineGap: 0
};
exports.SegoeuiBoldItalicMetrics = SegoeuiBoldItalicMetrics;
var SegoeuiItalicFactors = [1.76738, 1, 1, 0.98946, 1.14763, 1.05365, 1.06234, 0.96927, 0.92586, 1.15373, 1.18414, 0.91349, 0.91349, 1.07403, 1.17308, 0.78383, 1.20088, 0.78383, 1.42531, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.78383, 0.78383, 1.17308, 1.17308, 1.17308, 0.77349, 0.94565, 0.94729, 0.85944, 0.88506, 0.9858, 0.74817, 0.80016, 0.88449, 0.98039, 0.95782, 0.69238, 0.89898, 0.83231, 0.98183, 1.03989, 0.96924, 0.86237, 0.96924, 0.80595, 0.74524, 0.86091, 0.95402, 0.94143, 0.98448, 0.8858, 0.83089, 0.93285, 1.0949, 1.39016, 1.0949, 1.45994, 0.74627, 1.04839, 0.97454, 0.97454, 0.87207, 0.97454, 0.87533, 1.06151, 0.97454, 1.00176, 1.16484, 1.08132, 0.98047, 1.16484, 1.02989, 1.01054, 0.96225, 0.97454, 0.97454, 1.06598, 0.79004, 1.16344, 1.00351, 0.94629, 0.9973, 0.91016, 0.96777, 0.9043, 0.91082, 0.92481, 0.91082, 1.17308, 0.95748, 0.96927, 0.96927, 1, 0.96927, 0.92481, 0.80597, 1.04839, 1.23393, 1.1781, 0.9245, 1.17308, 1.20808, 0.63218, 0.94261, 1.24822, 1.09971, 1.09971, 1.04839, 1, 0.85273, 0.78032, 1.04839, 1.09971, 1.22326, 0.9245, 1.09836, 1.13525, 1.15222, 0.70424, 0.94729, 0.94729, 0.94729, 0.94729, 0.94729, 0.94729, 0.85498, 0.88506, 0.74817, 0.74817, 0.74817, 0.74817, 0.95782, 0.95782, 0.95782, 0.95782, 0.9858, 1.03989, 0.96924, 0.96924, 0.96924, 0.96924, 0.96924, 1.17308, 0.96924, 0.95402, 0.95402, 0.95402, 0.95402, 0.83089, 0.86237, 0.88409, 0.97454, 0.97454, 0.97454, 0.97454, 0.97454, 0.97454, 0.92916, 0.87207, 0.87533, 0.87533, 0.87533, 0.87533, 0.93146, 0.93146, 0.93146, 0.93146, 0.93854, 1.01054, 0.96225, 0.96225, 0.96225, 0.96225, 0.96225, 1.24822, 0.8761, 1.00351, 1.00351, 1.00351, 1.00351, 0.96777, 0.97454, 0.96777, 0.94729, 0.97454, 0.94729, 0.97454, 0.94729, 0.97454, 0.88506, 0.87207, 0.88506, 0.87207, 0.88506, 0.87207, 0.88506, 0.87207, 0.9858, 0.95391, 0.9858, 0.97454, 0.74817, 0.87533, 0.74817, 0.87533, 0.74817, 0.87533, 0.74817, 0.87533, 0.74817, 0.87533, 0.88449, 0.97454, 0.88449, 0.97454, 0.88449, 0.97454, 1, 1, 0.98039, 1.00176, 0.98039, 1.00176, 0.95782, 0.93146, 0.95782, 0.93146, 0.95782, 0.93146, 0.95782, 1.16484, 0.95782, 0.93146, 0.84421, 1.12761, 0.69238, 1.08132, 1, 1, 0.98047, 0.83231, 1.16484, 1, 1, 0.84723, 1.04861, 0.84723, 0.78755, 0.83231, 1.23736, 1.03989, 1.01054, 1, 1, 1.03989, 1.01054, 0.9857, 1.03849, 1.01054, 0.96924, 0.96225, 0.96924, 0.96225, 0.96924, 0.96225, 0.92383, 0.90171, 0.80595, 1.06598, 1, 1, 0.80595, 1.06598, 0.74524, 0.79004, 0.74524, 0.79004, 0.74524, 0.79004, 0.74524, 0.79004, 1, 1, 0.86091, 1.02759, 0.85771, 1.16344, 0.95402, 1.00351, 0.95402, 1.00351, 0.95402, 1.00351, 0.95402, 1.00351, 0.95402, 1.00351, 0.95402, 1.00351, 0.98448, 0.9973, 0.83089, 0.96777, 0.83089, 0.93285, 0.9043, 0.93285, 0.9043, 0.93285, 0.9043, 1.31868, 0.96927, 0.94729, 0.97454, 0.85498, 0.92916, 0.96924, 0.8761, 1, 1, 0.86091, 1.16344, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 1.04839, 0.81965, 0.81965, 0.94729, 0.78032, 0.71022, 0.90883, 0.84171, 0.99877, 0.77596, 1.05734, 1.2, 0.94729, 0.85944, 0.82791, 0.9607, 0.74817, 0.93285, 0.98039, 0.96924, 0.95782, 0.89898, 0.98316, 0.98183, 1.03989, 0.78614, 0.96924, 0.97642, 0.86237, 0.86075, 0.86091, 0.83089, 0.90082, 0.8858, 0.97296, 1.01284, 0.95782, 0.83089, 1.0976, 1.04, 1.03342, 1.2, 1.0675, 1.0976, 0.98205, 1.03809, 1.05097, 1.04, 0.95364, 1.03342, 1.05401, 1.2, 1.02148, 1.0119, 1.04724, 1.0127, 1.02732, 0.96225, 0.8965, 0.97783, 0.93574, 0.94818, 1.30679, 1.0675, 1.11826, 0.99821, 1.0557, 1.0326, 1.2, 1.0675, 0.96225, 1.0675, 1.0326, 0.74817, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.03754, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.87533, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.98705, 1, 1, 1, 1, 1, 1, 0.98448, 0.9973, 0.98448, 0.9973, 0.98448, 0.9973, 0.83089, 0.96777, 1, 1.20088, 0.89903, 1, 1, 0.75155, 0.94945, 0.94945, 0.94945, 0.94945, 1.12317, 1.12317, 1.12317, 0.67603, 0.67603, 1.15621, 0.73584, 1.21191, 1.22135, 1.06483, 0.94868, 0.94868, 0.95996, 1.24633, 1, 1.07497, 0.87709, 0.96927, 1.01473, 0.96927, 1, 1, 1, 0.77295, 1, 1, 1.09836, 1.09836, 1.09836, 1.01522, 0.86321, 0.94434, 0.8649, 0.94434, 0.86182, 1, 1, 1.083, 1, 0.91578, 0.86438, 1.17308, 1.18416, 1.14589, 0.69825, 0.97622, 1.96791, 1.24822, 1.24822, 1.17308, 1.24822, 1.24822, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.42603, 1, 0.99862, 0.99862, 1, 0.87025, 0.87025, 0.87025, 0.87025, 1.17984, 1.42603, 1, 1.42603, 1.42603, 0.99862, 1, 1, 1, 1, 1, 1.2886, 1.04315, 1.15296, 1.34163, 1, 1, 1, 1.10742, 1.10742, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.SegoeuiItalicFactors = SegoeuiItalicFactors;
var SegoeuiItalicMetrics = {
  lineHeight: 1.33008,
  lineGap: 0
};
exports.SegoeuiItalicMetrics = SegoeuiItalicMetrics;
var SegoeuiRegularFactors = [1.76738, 1, 1, 0.98594, 1.02285, 1.10454, 1.06234, 0.96927, 0.92037, 1.19985, 1.2046, 0.90616, 0.90616, 1.07152, 1.1714, 0.78032, 1.20088, 0.78032, 1.40246, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.96927, 0.78032, 0.78032, 1.1714, 1.1714, 1.1714, 0.80597, 0.94084, 0.96706, 0.85944, 0.85734, 0.97093, 0.75842, 0.79936, 0.88198, 0.9831, 0.95782, 0.71387, 0.86969, 0.84636, 1.07796, 1.03584, 0.96924, 0.83968, 0.96924, 0.82826, 0.79649, 0.85771, 0.95132, 0.93119, 0.98965, 0.88433, 0.8287, 0.93365, 1.08612, 1.3638, 1.08612, 1.45786, 0.74627, 0.80499, 0.91484, 1.05707, 0.92383, 1.05882, 0.9403, 1.12654, 1.05882, 1.01756, 1.09011, 1.09011, 0.99414, 1.09011, 1.034, 1.01756, 1.05356, 1.05707, 1.05882, 1.04399, 0.84863, 1.21968, 1.01756, 0.95801, 1.00068, 0.91797, 0.96777, 0.9043, 0.90351, 0.92105, 0.90351, 1.1714, 0.85337, 0.96927, 0.96927, 0.99912, 0.96927, 0.92105, 0.80597, 1.2434, 1.20808, 1.05937, 0.90957, 1.1714, 1.20808, 0.75155, 0.94261, 1.24644, 1.09971, 1.09971, 0.84751, 1, 0.85273, 0.78032, 0.61584, 1.05425, 1.17914, 0.90957, 1.08665, 1.11593, 1.14169, 0.73381, 0.96706, 0.96706, 0.96706, 0.96706, 0.96706, 0.96706, 0.86035, 0.85734, 0.75842, 0.75842, 0.75842, 0.75842, 0.95782, 0.95782, 0.95782, 0.95782, 0.97093, 1.03584, 0.96924, 0.96924, 0.96924, 0.96924, 0.96924, 1.1714, 0.96924, 0.95132, 0.95132, 0.95132, 0.95132, 0.8287, 0.83968, 0.89049, 0.91484, 0.91484, 0.91484, 0.91484, 0.91484, 0.91484, 0.93575, 0.92383, 0.9403, 0.9403, 0.9403, 0.9403, 0.8717, 0.8717, 0.8717, 0.8717, 1.00527, 1.01756, 1.05356, 1.05356, 1.05356, 1.05356, 1.05356, 1.24644, 0.95923, 1.01756, 1.01756, 1.01756, 1.01756, 0.96777, 1.05707, 0.96777, 0.96706, 0.91484, 0.96706, 0.91484, 0.96706, 0.91484, 0.85734, 0.92383, 0.85734, 0.92383, 0.85734, 0.92383, 0.85734, 0.92383, 0.97093, 1.0969, 0.97093, 1.05882, 0.75842, 0.9403, 0.75842, 0.9403, 0.75842, 0.9403, 0.75842, 0.9403, 0.75842, 0.9403, 0.88198, 1.05882, 0.88198, 1.05882, 0.88198, 1.05882, 1, 1, 0.9831, 1.01756, 0.9831, 1.01756, 0.95782, 0.8717, 0.95782, 0.8717, 0.95782, 0.8717, 0.95782, 1.09011, 0.95782, 0.8717, 0.84784, 1.11551, 0.71387, 1.09011, 1, 1, 0.99414, 0.84636, 1.09011, 1, 1, 0.84636, 1.0536, 0.84636, 0.94298, 0.84636, 1.23297, 1.03584, 1.01756, 1, 1, 1.03584, 1.01756, 1.00323, 1.03444, 1.01756, 0.96924, 1.05356, 0.96924, 1.05356, 0.96924, 1.05356, 0.93066, 0.98293, 0.82826, 1.04399, 1, 1, 0.82826, 1.04399, 0.79649, 0.84863, 0.79649, 0.84863, 0.79649, 0.84863, 0.79649, 0.84863, 1, 1, 0.85771, 1.17318, 0.85771, 1.21968, 0.95132, 1.01756, 0.95132, 1.01756, 0.95132, 1.01756, 0.95132, 1.01756, 0.95132, 1.01756, 0.95132, 1.01756, 0.98965, 1.00068, 0.8287, 0.96777, 0.8287, 0.93365, 0.9043, 0.93365, 0.9043, 0.93365, 0.9043, 1.08571, 0.96927, 0.96706, 0.91484, 0.86035, 0.93575, 0.96924, 0.95923, 1, 1, 0.85771, 1.21968, 1.11437, 1.11437, 0.93109, 0.91202, 0.60411, 0.84164, 0.55572, 1.01173, 0.97361, 0.81818, 0.81818, 0.96635, 0.78032, 0.72727, 0.92366, 0.98601, 1.03405, 0.77968, 1.09799, 1.2, 0.96706, 0.85944, 0.85638, 0.96491, 0.75842, 0.93365, 0.9831, 0.96924, 0.95782, 0.86969, 0.94152, 1.07796, 1.03584, 0.78437, 0.96924, 0.98715, 0.83968, 0.83491, 0.85771, 0.8287, 0.94492, 0.88433, 0.9287, 1.0098, 0.95782, 0.8287, 1.0625, 0.98248, 1.03424, 1.2, 1.01071, 1.0625, 0.95246, 1.03809, 1.04912, 0.98248, 1.00221, 1.03424, 1.05443, 1.2, 1.04785, 0.99609, 1.00169, 1.05176, 0.99346, 1.05356, 0.9087, 1.03004, 0.95542, 0.93117, 1.23362, 1.01071, 1.07831, 1.02512, 1.05205, 1.03502, 1.2, 1.01071, 1.05356, 1.01071, 1.03502, 0.75842, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.03719, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.9403, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.04021, 1, 1, 1, 1, 1, 1, 0.98965, 1.00068, 0.98965, 1.00068, 0.98965, 1.00068, 0.8287, 0.96777, 1, 1.20088, 0.89903, 1, 1, 0.75155, 1.03077, 1.03077, 1.03077, 1.03077, 1.13196, 1.13196, 1.13196, 0.67428, 0.67428, 1.16039, 0.73291, 1.20996, 1.22135, 1.06483, 0.94868, 0.94868, 0.95996, 1.24633, 1, 1.07497, 0.87796, 0.96927, 1.01518, 0.96927, 1, 1, 1, 0.77295, 1, 1, 1.10539, 1.10539, 1.11358, 1.06967, 0.86279, 0.94434, 0.86279, 0.94434, 0.86182, 1, 1, 1.083, 1, 0.91578, 0.86507, 1.1714, 1.18416, 1.14589, 0.69825, 0.97622, 1.9697, 1.24822, 1.24822, 1.17238, 1.24822, 1.24822, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.42603, 1, 0.99862, 0.99862, 1, 0.87025, 0.87025, 0.87025, 0.87025, 1.18083, 1.42603, 1, 1.42603, 1.42603, 0.99862, 1, 1, 1, 1, 1, 1.2886, 1.04315, 1.15296, 1.34163, 1, 1, 1, 1.10938, 1.10938, 1, 1, 1, 1.05425, 1.09971, 1.09971, 1.09971, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
exports.SegoeuiRegularFactors = SegoeuiRegularFactors;
var SegoeuiRegularMetrics = {
  lineHeight: 1.33008,
  lineGap: 0
};
exports.SegoeuiRegularMetrics = SegoeuiRegularMetrics;

/***/ }),
/* 160 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SEAC_ANALYSIS_ENABLED = exports.MacStandardGlyphOrdering = exports.FontFlags = void 0;
exports.getFontType = getFontType;
exports.normalizeFontName = normalizeFontName;
exports.recoverGlyphName = recoverGlyphName;
exports.type1FontGlyphMapping = type1FontGlyphMapping;

var _util = __w_pdfjs_require__(4);

var _encodings = __w_pdfjs_require__(161);

var _glyphlist = __w_pdfjs_require__(162);

var _unicode = __w_pdfjs_require__(163);

var SEAC_ANALYSIS_ENABLED = true;
exports.SEAC_ANALYSIS_ENABLED = SEAC_ANALYSIS_ENABLED;
var FontFlags = {
  FixedPitch: 1,
  Serif: 2,
  Symbolic: 4,
  Script: 8,
  Nonsymbolic: 32,
  Italic: 64,
  AllCap: 65536,
  SmallCap: 131072,
  ForceBold: 262144
};
exports.FontFlags = FontFlags;
var MacStandardGlyphOrdering = [".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"];
exports.MacStandardGlyphOrdering = MacStandardGlyphOrdering;

function getFontType(type, subtype) {
  var isStandardFont = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  switch (type) {
    case "Type1":
      if (isStandardFont) {
        return _util.FontType.TYPE1STANDARD;
      }

      return subtype === "Type1C" ? _util.FontType.TYPE1C : _util.FontType.TYPE1;

    case "CIDFontType0":
      return subtype === "CIDFontType0C" ? _util.FontType.CIDFONTTYPE0C : _util.FontType.CIDFONTTYPE0;

    case "OpenType":
      return _util.FontType.OPENTYPE;

    case "TrueType":
      return _util.FontType.TRUETYPE;

    case "CIDFontType2":
      return _util.FontType.CIDFONTTYPE2;

    case "MMType1":
      return _util.FontType.MMTYPE1;

    case "Type0":
      return _util.FontType.TYPE0;

    default:
      return _util.FontType.UNKNOWN;
  }
}

function recoverGlyphName(name, glyphsUnicodeMap) {
  if (glyphsUnicodeMap[name] !== undefined) {
    return name;
  }

  var unicode = (0, _unicode.getUnicodeForGlyph)(name, glyphsUnicodeMap);

  if (unicode !== -1) {
    for (var key in glyphsUnicodeMap) {
      if (glyphsUnicodeMap[key] === unicode) {
        return key;
      }
    }
  }

  (0, _util.info)("Unable to recover a standard glyph name for: " + name);
  return name;
}

function type1FontGlyphMapping(properties, builtInEncoding, glyphNames) {
  var charCodeToGlyphId = Object.create(null);
  var glyphId, charCode, baseEncoding;
  var isSymbolicFont = !!(properties.flags & FontFlags.Symbolic);

  if (properties.isInternalFont) {
    baseEncoding = builtInEncoding;

    for (charCode = 0; charCode < baseEncoding.length; charCode++) {
      glyphId = glyphNames.indexOf(baseEncoding[charCode]);

      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0;
      }
    }
  } else if (properties.baseEncodingName) {
    baseEncoding = (0, _encodings.getEncoding)(properties.baseEncodingName);

    for (charCode = 0; charCode < baseEncoding.length; charCode++) {
      glyphId = glyphNames.indexOf(baseEncoding[charCode]);

      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0;
      }
    }
  } else if (isSymbolicFont) {
    for (charCode in builtInEncoding) {
      charCodeToGlyphId[charCode] = builtInEncoding[charCode];
    }
  } else {
    baseEncoding = _encodings.StandardEncoding;

    for (charCode = 0; charCode < baseEncoding.length; charCode++) {
      glyphId = glyphNames.indexOf(baseEncoding[charCode]);

      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0;
      }
    }
  }

  var differences = properties.differences;
  var glyphsUnicodeMap;

  if (differences) {
    for (charCode in differences) {
      var glyphName = differences[charCode];
      glyphId = glyphNames.indexOf(glyphName);

      if (glyphId === -1) {
        if (!glyphsUnicodeMap) {
          glyphsUnicodeMap = (0, _glyphlist.getGlyphsUnicode)();
        }

        var standardGlyphName = recoverGlyphName(glyphName, glyphsUnicodeMap);

        if (standardGlyphName !== glyphName) {
          glyphId = glyphNames.indexOf(standardGlyphName);
        }
      }

      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0;
      }
    }
  }

  return charCodeToGlyphId;
}

function normalizeFontName(name) {
  return name.replace(/[,_]/g, "-").replace(/\s/g, "");
}

/***/ }),
/* 161 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ZapfDingbatsEncoding = exports.WinAnsiEncoding = exports.SymbolSetEncoding = exports.StandardEncoding = exports.MacRomanEncoding = exports.ExpertEncoding = void 0;
exports.getEncoding = getEncoding;
var ExpertEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclamsmall", "Hungarumlautsmall", "", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "comma", "hyphen", "period", "fraction", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "colon", "semicolon", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "", "", "", "isuperior", "", "", "lsuperior", "msuperior", "nsuperior", "osuperior", "", "", "rsuperior", "ssuperior", "tsuperior", "", "ff", "fi", "fl", "ffi", "ffl", "parenleftinferior", "", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "exclamdownsmall", "centoldstyle", "Lslashsmall", "", "", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "", "Dotaccentsmall", "", "", "Macronsmall", "", "", "figuredash", "hypheninferior", "", "", "Ogoneksmall", "Ringsmall", "Cedillasmall", "", "", "", "onequarter", "onehalf", "threequarters", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "", "", "zerosuperior", "onesuperior", "twosuperior", "threesuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall"];
exports.ExpertEncoding = ExpertEncoding;
var MacExpertEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclamsmall", "Hungarumlautsmall", "centoldstyle", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "comma", "hyphen", "period", "fraction", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "colon", "semicolon", "", "threequartersemdash", "", "questionsmall", "", "", "", "", "Ethsmall", "", "", "onequarter", "onehalf", "threequarters", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "", "", "", "", "", "", "ff", "fi", "fl", "ffi", "ffl", "parenleftinferior", "", "parenrightinferior", "Circumflexsmall", "hypheninferior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "", "", "asuperior", "centsuperior", "", "", "", "", "Aacutesmall", "Agravesmall", "Acircumflexsmall", "Adieresissmall", "Atildesmall", "Aringsmall", "Ccedillasmall", "Eacutesmall", "Egravesmall", "Ecircumflexsmall", "Edieresissmall", "Iacutesmall", "Igravesmall", "Icircumflexsmall", "Idieresissmall", "Ntildesmall", "Oacutesmall", "Ogravesmall", "Ocircumflexsmall", "Odieresissmall", "Otildesmall", "Uacutesmall", "Ugravesmall", "Ucircumflexsmall", "Udieresissmall", "", "eightsuperior", "fourinferior", "threeinferior", "sixinferior", "eightinferior", "seveninferior", "Scaronsmall", "", "centinferior", "twoinferior", "", "Dieresissmall", "", "Caronsmall", "osuperior", "fiveinferior", "", "commainferior", "periodinferior", "Yacutesmall", "", "dollarinferior", "", "", "Thornsmall", "", "nineinferior", "zeroinferior", "Zcaronsmall", "AEsmall", "Oslashsmall", "questiondownsmall", "oneinferior", "Lslashsmall", "", "", "", "", "", "", "Cedillasmall", "", "", "", "", "", "OEsmall", "figuredash", "hyphensuperior", "", "", "", "", "exclamdownsmall", "", "Ydieresissmall", "", "onesuperior", "twosuperior", "threesuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "ninesuperior", "zerosuperior", "", "esuperior", "rsuperior", "tsuperior", "", "", "isuperior", "ssuperior", "dsuperior", "", "", "", "", "", "lsuperior", "Ogoneksmall", "Brevesmall", "Macronsmall", "bsuperior", "nsuperior", "msuperior", "commasuperior", "periodsuperior", "Dotaccentsmall", "Ringsmall", "", "", "", ""];
var MacRomanEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "space", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron"];
exports.MacRomanEncoding = MacRomanEncoding;
var StandardEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "", "endash", "dagger", "daggerdbl", "periodcentered", "", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "", "questiondown", "", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "", "ring", "cedilla", "", "hungarumlaut", "ogonek", "caron", "emdash", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "AE", "", "ordfeminine", "", "", "", "", "Lslash", "Oslash", "OE", "ordmasculine", "", "", "", "", "", "ae", "", "", "", "dotlessi", "", "", "lslash", "oslash", "oe", "germandbls", "", "", "", ""];
exports.StandardEncoding = StandardEncoding;
var WinAnsiEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "bullet", "Euro", "bullet", "quotesinglbase", "florin", "quotedblbase", "ellipsis", "dagger", "daggerdbl", "circumflex", "perthousand", "Scaron", "guilsinglleft", "OE", "bullet", "Zcaron", "bullet", "bullet", "quoteleft", "quoteright", "quotedblleft", "quotedblright", "bullet", "endash", "emdash", "tilde", "trademark", "scaron", "guilsinglright", "oe", "bullet", "zcaron", "Ydieresis", "space", "exclamdown", "cent", "sterling", "currency", "yen", "brokenbar", "section", "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered", "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered", "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis", "eth", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis"];
exports.WinAnsiEncoding = WinAnsiEncoding;
var SymbolSetEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclam", "universal", "numbersign", "existential", "percent", "ampersand", "suchthat", "parenleft", "parenright", "asteriskmath", "plus", "comma", "minus", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "congruent", "Alpha", "Beta", "Chi", "Delta", "Epsilon", "Phi", "Gamma", "Eta", "Iota", "theta1", "Kappa", "Lambda", "Mu", "Nu", "Omicron", "Pi", "Theta", "Rho", "Sigma", "Tau", "Upsilon", "sigma1", "Omega", "Xi", "Psi", "Zeta", "bracketleft", "therefore", "bracketright", "perpendicular", "underscore", "radicalex", "alpha", "beta", "chi", "delta", "epsilon", "phi", "gamma", "eta", "iota", "phi1", "kappa", "lambda", "mu", "nu", "omicron", "pi", "theta", "rho", "sigma", "tau", "upsilon", "omega1", "omega", "xi", "psi", "zeta", "braceleft", "bar", "braceright", "similar", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "Euro", "Upsilon1", "minute", "lessequal", "fraction", "infinity", "florin", "club", "diamond", "heart", "spade", "arrowboth", "arrowleft", "arrowup", "arrowright", "arrowdown", "degree", "plusminus", "second", "greaterequal", "multiply", "proportional", "partialdiff", "bullet", "divide", "notequal", "equivalence", "approxequal", "ellipsis", "arrowvertex", "arrowhorizex", "carriagereturn", "aleph", "Ifraktur", "Rfraktur", "weierstrass", "circlemultiply", "circleplus", "emptyset", "intersection", "union", "propersuperset", "reflexsuperset", "notsubset", "propersubset", "reflexsubset", "element", "notelement", "angle", "gradient", "registerserif", "copyrightserif", "trademarkserif", "product", "radical", "dotmath", "logicalnot", "logicaland", "logicalor", "arrowdblboth", "arrowdblleft", "arrowdblup", "arrowdblright", "arrowdbldown", "lozenge", "angleleft", "registersans", "copyrightsans", "trademarksans", "summation", "parenlefttp", "parenleftex", "parenleftbt", "bracketlefttp", "bracketleftex", "bracketleftbt", "bracelefttp", "braceleftmid", "braceleftbt", "braceex", "", "angleright", "integral", "integraltp", "integralex", "integralbt", "parenrighttp", "parenrightex", "parenrightbt", "bracketrighttp", "bracketrightex", "bracketrightbt", "bracerighttp", "bracerightmid", "bracerightbt", ""];
exports.SymbolSetEncoding = SymbolSetEncoding;
var ZapfDingbatsEncoding = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "a1", "a2", "a202", "a3", "a4", "a5", "a119", "a118", "a117", "a11", "a12", "a13", "a14", "a15", "a16", "a105", "a17", "a18", "a19", "a20", "a21", "a22", "a23", "a24", "a25", "a26", "a27", "a28", "a6", "a7", "a8", "a9", "a10", "a29", "a30", "a31", "a32", "a33", "a34", "a35", "a36", "a37", "a38", "a39", "a40", "a41", "a42", "a43", "a44", "a45", "a46", "a47", "a48", "a49", "a50", "a51", "a52", "a53", "a54", "a55", "a56", "a57", "a58", "a59", "a60", "a61", "a62", "a63", "a64", "a65", "a66", "a67", "a68", "a69", "a70", "a71", "a72", "a73", "a74", "a203", "a75", "a204", "a76", "a77", "a78", "a79", "a81", "a82", "a83", "a84", "a97", "a98", "a99", "a100", "", "a89", "a90", "a93", "a94", "a91", "a92", "a205", "a85", "a206", "a86", "a87", "a88", "a95", "a96", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "a101", "a102", "a103", "a104", "a106", "a107", "a108", "a112", "a111", "a110", "a109", "a120", "a121", "a122", "a123", "a124", "a125", "a126", "a127", "a128", "a129", "a130", "a131", "a132", "a133", "a134", "a135", "a136", "a137", "a138", "a139", "a140", "a141", "a142", "a143", "a144", "a145", "a146", "a147", "a148", "a149", "a150", "a151", "a152", "a153", "a154", "a155", "a156", "a157", "a158", "a159", "a160", "a161", "a163", "a164", "a196", "a165", "a192", "a166", "a167", "a168", "a169", "a170", "a171", "a172", "a173", "a162", "a174", "a175", "a176", "a177", "a178", "a179", "a193", "a180", "a199", "a181", "a200", "a182", "", "a201", "a183", "a184", "a197", "a185", "a194", "a198", "a186", "a195", "a187", "a188", "a189", "a190", "a191", ""];
exports.ZapfDingbatsEncoding = ZapfDingbatsEncoding;

function getEncoding(encodingName) {
  switch (encodingName) {
    case "WinAnsiEncoding":
      return WinAnsiEncoding;

    case "StandardEncoding":
      return StandardEncoding;

    case "MacRomanEncoding":
      return MacRomanEncoding;

    case "SymbolSetEncoding":
      return SymbolSetEncoding;

    case "ZapfDingbatsEncoding":
      return ZapfDingbatsEncoding;

    case "ExpertEncoding":
      return ExpertEncoding;

    case "MacExpertEncoding":
      return MacExpertEncoding;

    default:
      return null;
  }
}

/***/ }),
/* 162 */
/***/ ((__unused_webpack_module, __webpack_exports__, __w_pdfjs_require__) => {

"use strict";
__w_pdfjs_require__.r(__webpack_exports__);
/* harmony export */ __w_pdfjs_require__.d(__webpack_exports__, {
/* harmony export */   "getDingbatsGlyphsUnicode": () => (/* binding */ getDingbatsGlyphsUnicode),
/* harmony export */   "getGlyphsUnicode": () => (/* binding */ getGlyphsUnicode)
/* harmony export */ });
/* harmony import */ var _core_utils_js__WEBPACK_IMPORTED_MODULE_0__ = __w_pdfjs_require__(150);

const getGlyphsUnicode = (0,_core_utils_js__WEBPACK_IMPORTED_MODULE_0__.getArrayLookupTableFactory)(function () {
 return [
  "A",
  0x0041,
  "AE",
  0x00c6,
  "AEacute",
  0x01fc,
  "AEmacron",
  0x01e2,
  "AEsmall",
  0xf7e6,
  "Aacute",
  0x00c1,
  "Aacutesmall",
  0xf7e1,
  "Abreve",
  0x0102,
  "Abreveacute",
  0x1eae,
  "Abrevecyrillic",
  0x04d0,
  "Abrevedotbelow",
  0x1eb6,
  "Abrevegrave",
  0x1eb0,
  "Abrevehookabove",
  0x1eb2,
  "Abrevetilde",
  0x1eb4,
  "Acaron",
  0x01cd,
  "Acircle",
  0x24b6,
  "Acircumflex",
  0x00c2,
  "Acircumflexacute",
  0x1ea4,
  "Acircumflexdotbelow",
  0x1eac,
  "Acircumflexgrave",
  0x1ea6,
  "Acircumflexhookabove",
  0x1ea8,
  "Acircumflexsmall",
  0xf7e2,
  "Acircumflextilde",
  0x1eaa,
  "Acute",
  0xf6c9,
  "Acutesmall",
  0xf7b4,
  "Acyrillic",
  0x0410,
  "Adblgrave",
  0x0200,
  "Adieresis",
  0x00c4,
  "Adieresiscyrillic",
  0x04d2,
  "Adieresismacron",
  0x01de,
  "Adieresissmall",
  0xf7e4,
  "Adotbelow",
  0x1ea0,
  "Adotmacron",
  0x01e0,
  "Agrave",
  0x00c0,
  "Agravesmall",
  0xf7e0,
  "Ahookabove",
  0x1ea2,
  "Aiecyrillic",
  0x04d4,
  "Ainvertedbreve",
  0x0202,
  "Alpha",
  0x0391,
  "Alphatonos",
  0x0386,
  "Amacron",
  0x0100,
  "Amonospace",
  0xff21,
  "Aogonek",
  0x0104,
  "Aring",
  0x00c5,
  "Aringacute",
  0x01fa,
  "Aringbelow",
  0x1e00,
  "Aringsmall",
  0xf7e5,
  "Asmall",
  0xf761,
  "Atilde",
  0x00c3,
  "Atildesmall",
  0xf7e3,
  "Aybarmenian",
  0x0531,
  "B",
  0x0042,
  "Bcircle",
  0x24b7,
  "Bdotaccent",
  0x1e02,
  "Bdotbelow",
  0x1e04,
  "Becyrillic",
  0x0411,
  "Benarmenian",
  0x0532,
  "Beta",
  0x0392,
  "Bhook",
  0x0181,
  "Blinebelow",
  0x1e06,
  "Bmonospace",
  0xff22,
  "Brevesmall",
  0xf6f4,
  "Bsmall",
  0xf762,
  "Btopbar",
  0x0182,
  "C",
  0x0043,
  "Caarmenian",
  0x053e,
  "Cacute",
  0x0106,
  "Caron",
  0xf6ca,
  "Caronsmall",
  0xf6f5,
  "Ccaron",
  0x010c,
  "Ccedilla",
  0x00c7,
  "Ccedillaacute",
  0x1e08,
  "Ccedillasmall",
  0xf7e7,
  "Ccircle",
  0x24b8,
  "Ccircumflex",
  0x0108,
  "Cdot",
  0x010a,
  "Cdotaccent",
  0x010a,
  "Cedillasmall",
  0xf7b8,
  "Chaarmenian",
  0x0549,
  "Cheabkhasiancyrillic",
  0x04bc,
  "Checyrillic",
  0x0427,
  "Chedescenderabkhasiancyrillic",
  0x04be,
  "Chedescendercyrillic",
  0x04b6,
  "Chedieresiscyrillic",
  0x04f4,
  "Cheharmenian",
  0x0543,
  "Chekhakassiancyrillic",
  0x04cb,
  "Cheverticalstrokecyrillic",
  0x04b8,
  "Chi",
  0x03a7,
  "Chook",
  0x0187,
  "Circumflexsmall",
  0xf6f6,
  "Cmonospace",
  0xff23,
  "Coarmenian",
  0x0551,
  "Csmall",
  0xf763,
  "D",
  0x0044,
  "DZ",
  0x01f1,
  "DZcaron",
  0x01c4,
  "Daarmenian",
  0x0534,
  "Dafrican",
  0x0189,
  "Dcaron",
  0x010e,
  "Dcedilla",
  0x1e10,
  "Dcircle",
  0x24b9,
  "Dcircumflexbelow",
  0x1e12,
  "Dcroat",
  0x0110,
  "Ddotaccent",
  0x1e0a,
  "Ddotbelow",
  0x1e0c,
  "Decyrillic",
  0x0414,
  "Deicoptic",
  0x03ee,
  "Delta",
  0x2206,
  "Deltagreek",
  0x0394,
  "Dhook",
  0x018a,
  "Dieresis",
  0xf6cb,
  "DieresisAcute",
  0xf6cc,
  "DieresisGrave",
  0xf6cd,
  "Dieresissmall",
  0xf7a8,
  "Digammagreek",
  0x03dc,
  "Djecyrillic",
  0x0402,
  "Dlinebelow",
  0x1e0e,
  "Dmonospace",
  0xff24,
  "Dotaccentsmall",
  0xf6f7,
  "Dslash",
  0x0110,
  "Dsmall",
  0xf764,
  "Dtopbar",
  0x018b,
  "Dz",
  0x01f2,
  "Dzcaron",
  0x01c5,
  "Dzeabkhasiancyrillic",
  0x04e0,
  "Dzecyrillic",
  0x0405,
  "Dzhecyrillic",
  0x040f,
  "E",
  0x0045,
  "Eacute",
  0x00c9,
  "Eacutesmall",
  0xf7e9,
  "Ebreve",
  0x0114,
  "Ecaron",
  0x011a,
  "Ecedillabreve",
  0x1e1c,
  "Echarmenian",
  0x0535,
  "Ecircle",
  0x24ba,
  "Ecircumflex",
  0x00ca,
  "Ecircumflexacute",
  0x1ebe,
  "Ecircumflexbelow",
  0x1e18,
  "Ecircumflexdotbelow",
  0x1ec6,
  "Ecircumflexgrave",
  0x1ec0,
  "Ecircumflexhookabove",
  0x1ec2,
  "Ecircumflexsmall",
  0xf7ea,
  "Ecircumflextilde",
  0x1ec4,
  "Ecyrillic",
  0x0404,
  "Edblgrave",
  0x0204,
  "Edieresis",
  0x00cb,
  "Edieresissmall",
  0xf7eb,
  "Edot",
  0x0116,
  "Edotaccent",
  0x0116,
  "Edotbelow",
  0x1eb8,
  "Efcyrillic",
  0x0424,
  "Egrave",
  0x00c8,
  "Egravesmall",
  0xf7e8,
  "Eharmenian",
  0x0537,
  "Ehookabove",
  0x1eba,
  "Eightroman",
  0x2167,
  "Einvertedbreve",
  0x0206,
  "Eiotifiedcyrillic",
  0x0464,
  "Elcyrillic",
  0x041b,
  "Elevenroman",
  0x216a,
  "Emacron",
  0x0112,
  "Emacronacute",
  0x1e16,
  "Emacrongrave",
  0x1e14,
  "Emcyrillic",
  0x041c,
  "Emonospace",
  0xff25,
  "Encyrillic",
  0x041d,
  "Endescendercyrillic",
  0x04a2,
  "Eng",
  0x014a,
  "Enghecyrillic",
  0x04a4,
  "Enhookcyrillic",
  0x04c7,
  "Eogonek",
  0x0118,
  "Eopen",
  0x0190,
  "Epsilon",
  0x0395,
  "Epsilontonos",
  0x0388,
  "Ercyrillic",
  0x0420,
  "Ereversed",
  0x018e,
  "Ereversedcyrillic",
  0x042d,
  "Escyrillic",
  0x0421,
  "Esdescendercyrillic",
  0x04aa,
  "Esh",
  0x01a9,
  "Esmall",
  0xf765,
  "Eta",
  0x0397,
  "Etarmenian",
  0x0538,
  "Etatonos",
  0x0389,
  "Eth",
  0x00d0,
  "Ethsmall",
  0xf7f0,
  "Etilde",
  0x1ebc,
  "Etildebelow",
  0x1e1a,
  "Euro",
  0x20ac,
  "Ezh",
  0x01b7,
  "Ezhcaron",
  0x01ee,
  "Ezhreversed",
  0x01b8,
  "F",
  0x0046,
  "Fcircle",
  0x24bb,
  "Fdotaccent",
  0x1e1e,
  "Feharmenian",
  0x0556,
  "Feicoptic",
  0x03e4,
  "Fhook",
  0x0191,
  "Fitacyrillic",
  0x0472,
  "Fiveroman",
  0x2164,
  "Fmonospace",
  0xff26,
  "Fourroman",
  0x2163,
  "Fsmall",
  0xf766,
  "G",
  0x0047,
  "GBsquare",
  0x3387,
  "Gacute",
  0x01f4,
  "Gamma",
  0x0393,
  "Gammaafrican",
  0x0194,
  "Gangiacoptic",
  0x03ea,
  "Gbreve",
  0x011e,
  "Gcaron",
  0x01e6,
  "Gcedilla",
  0x0122,
  "Gcircle",
  0x24bc,
  "Gcircumflex",
  0x011c,
  "Gcommaaccent",
  0x0122,
  "Gdot",
  0x0120,
  "Gdotaccent",
  0x0120,
  "Gecyrillic",
  0x0413,
  "Ghadarmenian",
  0x0542,
  "Ghemiddlehookcyrillic",
  0x0494,
  "Ghestrokecyrillic",
  0x0492,
  "Gheupturncyrillic",
  0x0490,
  "Ghook",
  0x0193,
  "Gimarmenian",
  0x0533,
  "Gjecyrillic",
  0x0403,
  "Gmacron",
  0x1e20,
  "Gmonospace",
  0xff27,
  "Grave",
  0xf6ce,
  "Gravesmall",
  0xf760,
  "Gsmall",
  0xf767,
  "Gsmallhook",
  0x029b,
  "Gstroke",
  0x01e4,
  "H",
  0x0048,
  "H18533",
  0x25cf,
  "H18543",
  0x25aa,
  "H18551",
  0x25ab,
  "H22073",
  0x25a1,
  "HPsquare",
  0x33cb,
  "Haabkhasiancyrillic",
  0x04a8,
  "Hadescendercyrillic",
  0x04b2,
  "Hardsigncyrillic",
  0x042a,
  "Hbar",
  0x0126,
  "Hbrevebelow",
  0x1e2a,
  "Hcedilla",
  0x1e28,
  "Hcircle",
  0x24bd,
  "Hcircumflex",
  0x0124,
  "Hdieresis",
  0x1e26,
  "Hdotaccent",
  0x1e22,
  "Hdotbelow",
  0x1e24,
  "Hmonospace",
  0xff28,
  "Hoarmenian",
  0x0540,
  "Horicoptic",
  0x03e8,
  "Hsmall",
  0xf768,
  "Hungarumlaut",
  0xf6cf,
  "Hungarumlautsmall",
  0xf6f8,
  "Hzsquare",
  0x3390,
  "I",
  0x0049,
  "IAcyrillic",
  0x042f,
  "IJ",
  0x0132,
  "IUcyrillic",
  0x042e,
  "Iacute",
  0x00cd,
  "Iacutesmall",
  0xf7ed,
  "Ibreve",
  0x012c,
  "Icaron",
  0x01cf,
  "Icircle",
  0x24be,
  "Icircumflex",
  0x00ce,
  "Icircumflexsmall",
  0xf7ee,
  "Icyrillic",
  0x0406,
  "Idblgrave",
  0x0208,
  "Idieresis",
  0x00cf,
  "Idieresisacute",
  0x1e2e,
  "Idieresiscyrillic",
  0x04e4,
  "Idieresissmall",
  0xf7ef,
  "Idot",
  0x0130,
  "Idotaccent",
  0x0130,
  "Idotbelow",
  0x1eca,
  "Iebrevecyrillic",
  0x04d6,
  "Iecyrillic",
  0x0415,
  "Ifraktur",
  0x2111,
  "Igrave",
  0x00cc,
  "Igravesmall",
  0xf7ec,
  "Ihookabove",
  0x1ec8,
  "Iicyrillic",
  0x0418,
  "Iinvertedbreve",
  0x020a,
  "Iishortcyrillic",
  0x0419,
  "Imacron",
  0x012a,
  "Imacroncyrillic",
  0x04e2,
  "Imonospace",
  0xff29,
  "Iniarmenian",
  0x053b,
  "Iocyrillic",
  0x0401,
  "Iogonek",
  0x012e,
  "Iota",
  0x0399,
  "Iotaafrican",
  0x0196,
  "Iotadieresis",
  0x03aa,
  "Iotatonos",
  0x038a,
  "Ismall",
  0xf769,
  "Istroke",
  0x0197,
  "Itilde",
  0x0128,
  "Itildebelow",
  0x1e2c,
  "Izhitsacyrillic",
  0x0474,
  "Izhitsadblgravecyrillic",
  0x0476,
  "J",
  0x004a,
  "Jaarmenian",
  0x0541,
  "Jcircle",
  0x24bf,
  "Jcircumflex",
  0x0134,
  "Jecyrillic",
  0x0408,
  "Jheharmenian",
  0x054b,
  "Jmonospace",
  0xff2a,
  "Jsmall",
  0xf76a,
  "K",
  0x004b,
  "KBsquare",
  0x3385,
  "KKsquare",
  0x33cd,
  "Kabashkircyrillic",
  0x04a0,
  "Kacute",
  0x1e30,
  "Kacyrillic",
  0x041a,
  "Kadescendercyrillic",
  0x049a,
  "Kahookcyrillic",
  0x04c3,
  "Kappa",
  0x039a,
  "Kastrokecyrillic",
  0x049e,
  "Kaverticalstrokecyrillic",
  0x049c,
  "Kcaron",
  0x01e8,
  "Kcedilla",
  0x0136,
  "Kcircle",
  0x24c0,
  "Kcommaaccent",
  0x0136,
  "Kdotbelow",
  0x1e32,
  "Keharmenian",
  0x0554,
  "Kenarmenian",
  0x053f,
  "Khacyrillic",
  0x0425,
  "Kheicoptic",
  0x03e6,
  "Khook",
  0x0198,
  "Kjecyrillic",
  0x040c,
  "Klinebelow",
  0x1e34,
  "Kmonospace",
  0xff2b,
  "Koppacyrillic",
  0x0480,
  "Koppagreek",
  0x03de,
  "Ksicyrillic",
  0x046e,
  "Ksmall",
  0xf76b,
  "L",
  0x004c,
  "LJ",
  0x01c7,
  "LL",
  0xf6bf,
  "Lacute",
  0x0139,
  "Lambda",
  0x039b,
  "Lcaron",
  0x013d,
  "Lcedilla",
  0x013b,
  "Lcircle",
  0x24c1,
  "Lcircumflexbelow",
  0x1e3c,
  "Lcommaaccent",
  0x013b,
  "Ldot",
  0x013f,
  "Ldotaccent",
  0x013f,
  "Ldotbelow",
  0x1e36,
  "Ldotbelowmacron",
  0x1e38,
  "Liwnarmenian",
  0x053c,
  "Lj",
  0x01c8,
  "Ljecyrillic",
  0x0409,
  "Llinebelow",
  0x1e3a,
  "Lmonospace",
  0xff2c,
  "Lslash",
  0x0141,
  "Lslashsmall",
  0xf6f9,
  "Lsmall",
  0xf76c,
  "M",
  0x004d,
  "MBsquare",
  0x3386,
  "Macron",
  0xf6d0,
  "Macronsmall",
  0xf7af,
  "Macute",
  0x1e3e,
  "Mcircle",
  0x24c2,
  "Mdotaccent",
  0x1e40,
  "Mdotbelow",
  0x1e42,
  "Menarmenian",
  0x0544,
  "Mmonospace",
  0xff2d,
  "Msmall",
  0xf76d,
  "Mturned",
  0x019c,
  "Mu",
  0x039c,
  "N",
  0x004e,
  "NJ",
  0x01ca,
  "Nacute",
  0x0143,
  "Ncaron",
  0x0147,
  "Ncedilla",
  0x0145,
  "Ncircle",
  0x24c3,
  "Ncircumflexbelow",
  0x1e4a,
  "Ncommaaccent",
  0x0145,
  "Ndotaccent",
  0x1e44,
  "Ndotbelow",
  0x1e46,
  "Nhookleft",
  0x019d,
  "Nineroman",
  0x2168,
  "Nj",
  0x01cb,
  "Njecyrillic",
  0x040a,
  "Nlinebelow",
  0x1e48,
  "Nmonospace",
  0xff2e,
  "Nowarmenian",
  0x0546,
  "Nsmall",
  0xf76e,
  "Ntilde",
  0x00d1,
  "Ntildesmall",
  0xf7f1,
  "Nu",
  0x039d,
  "O",
  0x004f,
  "OE",
  0x0152,
  "OEsmall",
  0xf6fa,
  "Oacute",
  0x00d3,
  "Oacutesmall",
  0xf7f3,
  "Obarredcyrillic",
  0x04e8,
  "Obarreddieresiscyrillic",
  0x04ea,
  "Obreve",
  0x014e,
  "Ocaron",
  0x01d1,
  "Ocenteredtilde",
  0x019f,
  "Ocircle",
  0x24c4,
  "Ocircumflex",
  0x00d4,
  "Ocircumflexacute",
  0x1ed0,
  "Ocircumflexdotbelow",
  0x1ed8,
  "Ocircumflexgrave",
  0x1ed2,
  "Ocircumflexhookabove",
  0x1ed4,
  "Ocircumflexsmall",
  0xf7f4,
  "Ocircumflextilde",
  0x1ed6,
  "Ocyrillic",
  0x041e,
  "Odblacute",
  0x0150,
  "Odblgrave",
  0x020c,
  "Odieresis",
  0x00d6,
  "Odieresiscyrillic",
  0x04e6,
  "Odieresissmall",
  0xf7f6,
  "Odotbelow",
  0x1ecc,
  "Ogoneksmall",
  0xf6fb,
  "Ograve",
  0x00d2,
  "Ogravesmall",
  0xf7f2,
  "Oharmenian",
  0x0555,
  "Ohm",
  0x2126,
  "Ohookabove",
  0x1ece,
  "Ohorn",
  0x01a0,
  "Ohornacute",
  0x1eda,
  "Ohorndotbelow",
  0x1ee2,
  "Ohorngrave",
  0x1edc,
  "Ohornhookabove",
  0x1ede,
  "Ohorntilde",
  0x1ee0,
  "Ohungarumlaut",
  0x0150,
  "Oi",
  0x01a2,
  "Oinvertedbreve",
  0x020e,
  "Omacron",
  0x014c,
  "Omacronacute",
  0x1e52,
  "Omacrongrave",
  0x1e50,
  "Omega",
  0x2126,
  "Omegacyrillic",
  0x0460,
  "Omegagreek",
  0x03a9,
  "Omegaroundcyrillic",
  0x047a,
  "Omegatitlocyrillic",
  0x047c,
  "Omegatonos",
  0x038f,
  "Omicron",
  0x039f,
  "Omicrontonos",
  0x038c,
  "Omonospace",
  0xff2f,
  "Oneroman",
  0x2160,
  "Oogonek",
  0x01ea,
  "Oogonekmacron",
  0x01ec,
  "Oopen",
  0x0186,
  "Oslash",
  0x00d8,
  "Oslashacute",
  0x01fe,
  "Oslashsmall",
  0xf7f8,
  "Osmall",
  0xf76f,
  "Ostrokeacute",
  0x01fe,
  "Otcyrillic",
  0x047e,
  "Otilde",
  0x00d5,
  "Otildeacute",
  0x1e4c,
  "Otildedieresis",
  0x1e4e,
  "Otildesmall",
  0xf7f5,
  "P",
  0x0050,
  "Pacute",
  0x1e54,
  "Pcircle",
  0x24c5,
  "Pdotaccent",
  0x1e56,
  "Pecyrillic",
  0x041f,
  "Peharmenian",
  0x054a,
  "Pemiddlehookcyrillic",
  0x04a6,
  "Phi",
  0x03a6,
  "Phook",
  0x01a4,
  "Pi",
  0x03a0,
  "Piwrarmenian",
  0x0553,
  "Pmonospace",
  0xff30,
  "Psi",
  0x03a8,
  "Psicyrillic",
  0x0470,
  "Psmall",
  0xf770,
  "Q",
  0x0051,
  "Qcircle",
  0x24c6,
  "Qmonospace",
  0xff31,
  "Qsmall",
  0xf771,
  "R",
  0x0052,
  "Raarmenian",
  0x054c,
  "Racute",
  0x0154,
  "Rcaron",
  0x0158,
  "Rcedilla",
  0x0156,
  "Rcircle",
  0x24c7,
  "Rcommaaccent",
  0x0156,
  "Rdblgrave",
  0x0210,
  "Rdotaccent",
  0x1e58,
  "Rdotbelow",
  0x1e5a,
  "Rdotbelowmacron",
  0x1e5c,
  "Reharmenian",
  0x0550,
  "Rfraktur",
  0x211c,
  "Rho",
  0x03a1,
  "Ringsmall",
  0xf6fc,
  "Rinvertedbreve",
  0x0212,
  "Rlinebelow",
  0x1e5e,
  "Rmonospace",
  0xff32,
  "Rsmall",
  0xf772,
  "Rsmallinverted",
  0x0281,
  "Rsmallinvertedsuperior",
  0x02b6,
  "S",
  0x0053,
  "SF010000",
  0x250c,
  "SF020000",
  0x2514,
  "SF030000",
  0x2510,
  "SF040000",
  0x2518,
  "SF050000",
  0x253c,
  "SF060000",
  0x252c,
  "SF070000",
  0x2534,
  "SF080000",
  0x251c,
  "SF090000",
  0x2524,
  "SF100000",
  0x2500,
  "SF110000",
  0x2502,
  "SF190000",
  0x2561,
  "SF200000",
  0x2562,
  "SF210000",
  0x2556,
  "SF220000",
  0x2555,
  "SF230000",
  0x2563,
  "SF240000",
  0x2551,
  "SF250000",
  0x2557,
  "SF260000",
  0x255d,
  "SF270000",
  0x255c,
  "SF280000",
  0x255b,
  "SF360000",
  0x255e,
  "SF370000",
  0x255f,
  "SF380000",
  0x255a,
  "SF390000",
  0x2554,
  "SF400000",
  0x2569,
  "SF410000",
  0x2566,
  "SF420000",
  0x2560,
  "SF430000",
  0x2550,
  "SF440000",
  0x256c,
  "SF450000",
  0x2567,
  "SF460000",
  0x2568,
  "SF470000",
  0x2564,
  "SF480000",
  0x2565,
  "SF490000",
  0x2559,
  "SF500000",
  0x2558,
  "SF510000",
  0x2552,
  "SF520000",
  0x2553,
  "SF530000",
  0x256b,
  "SF540000",
  0x256a,
  "Sacute",
  0x015a,
  "Sacutedotaccent",
  0x1e64,
  "Sampigreek",
  0x03e0,
  "Scaron",
  0x0160,
  "Scarondotaccent",
  0x1e66,
  "Scaronsmall",
  0xf6fd,
  "Scedilla",
  0x015e,
  "Schwa",
  0x018f,
  "Schwacyrillic",
  0x04d8,
  "Schwadieresiscyrillic",
  0x04da,
  "Scircle",
  0x24c8,
  "Scircumflex",
  0x015c,
  "Scommaaccent",
  0x0218,
  "Sdotaccent",
  0x1e60,
  "Sdotbelow",
  0x1e62,
  "Sdotbelowdotaccent",
  0x1e68,
  "Seharmenian",
  0x054d,
  "Sevenroman",
  0x2166,
  "Shaarmenian",
  0x0547,
  "Shacyrillic",
  0x0428,
  "Shchacyrillic",
  0x0429,
  "Sheicoptic",
  0x03e2,
  "Shhacyrillic",
  0x04ba,
  "Shimacoptic",
  0x03ec,
  "Sigma",
  0x03a3,
  "Sixroman",
  0x2165,
  "Smonospace",
  0xff33,
  "Softsigncyrillic",
  0x042c,
  "Ssmall",
  0xf773,
  "Stigmagreek",
  0x03da,
  "T",
  0x0054,
  "Tau",
  0x03a4,
  "Tbar",
  0x0166,
  "Tcaron",
  0x0164,
  "Tcedilla",
  0x0162,
  "Tcircle",
  0x24c9,
  "Tcircumflexbelow",
  0x1e70,
  "Tcommaaccent",
  0x0162,
  "Tdotaccent",
  0x1e6a,
  "Tdotbelow",
  0x1e6c,
  "Tecyrillic",
  0x0422,
  "Tedescendercyrillic",
  0x04ac,
  "Tenroman",
  0x2169,
  "Tetsecyrillic",
  0x04b4,
  "Theta",
  0x0398,
  "Thook",
  0x01ac,
  "Thorn",
  0x00de,
  "Thornsmall",
  0xf7fe,
  "Threeroman",
  0x2162,
  "Tildesmall",
  0xf6fe,
  "Tiwnarmenian",
  0x054f,
  "Tlinebelow",
  0x1e6e,
  "Tmonospace",
  0xff34,
  "Toarmenian",
  0x0539,
  "Tonefive",
  0x01bc,
  "Tonesix",
  0x0184,
  "Tonetwo",
  0x01a7,
  "Tretroflexhook",
  0x01ae,
  "Tsecyrillic",
  0x0426,
  "Tshecyrillic",
  0x040b,
  "Tsmall",
  0xf774,
  "Twelveroman",
  0x216b,
  "Tworoman",
  0x2161,
  "U",
  0x0055,
  "Uacute",
  0x00da,
  "Uacutesmall",
  0xf7fa,
  "Ubreve",
  0x016c,
  "Ucaron",
  0x01d3,
  "Ucircle",
  0x24ca,
  "Ucircumflex",
  0x00db,
  "Ucircumflexbelow",
  0x1e76,
  "Ucircumflexsmall",
  0xf7fb,
  "Ucyrillic",
  0x0423,
  "Udblacute",
  0x0170,
  "Udblgrave",
  0x0214,
  "Udieresis",
  0x00dc,
  "Udieresisacute",
  0x01d7,
  "Udieresisbelow",
  0x1e72,
  "Udieresiscaron",
  0x01d9,
  "Udieresiscyrillic",
  0x04f0,
  "Udieresisgrave",
  0x01db,
  "Udieresismacron",
  0x01d5,
  "Udieresissmall",
  0xf7fc,
  "Udotbelow",
  0x1ee4,
  "Ugrave",
  0x00d9,
  "Ugravesmall",
  0xf7f9,
  "Uhookabove",
  0x1ee6,
  "Uhorn",
  0x01af,
  "Uhornacute",
  0x1ee8,
  "Uhorndotbelow",
  0x1ef0,
  "Uhorngrave",
  0x1eea,
  "Uhornhookabove",
  0x1eec,
  "Uhorntilde",
  0x1eee,
  "Uhungarumlaut",
  0x0170,
  "Uhungarumlautcyrillic",
  0x04f2,
  "Uinvertedbreve",
  0x0216,
  "Ukcyrillic",
  0x0478,
  "Umacron",
  0x016a,
  "Umacroncyrillic",
  0x04ee,
  "Umacrondieresis",
  0x1e7a,
  "Umonospace",
  0xff35,
  "Uogonek",
  0x0172,
  "Upsilon",
  0x03a5,
  "Upsilon1",
  0x03d2,
  "Upsilonacutehooksymbolgreek",
  0x03d3,
  "Upsilonafrican",
  0x01b1,
  "Upsilondieresis",
  0x03ab,
  "Upsilondieresishooksymbolgreek",
  0x03d4,
  "Upsilonhooksymbol",
  0x03d2,
  "Upsilontonos",
  0x038e,
  "Uring",
  0x016e,
  "Ushortcyrillic",
  0x040e,
  "Usmall",
  0xf775,
  "Ustraightcyrillic",
  0x04ae,
  "Ustraightstrokecyrillic",
  0x04b0,
  "Utilde",
  0x0168,
  "Utildeacute",
  0x1e78,
  "Utildebelow",
  0x1e74,
  "V",
  0x0056,
  "Vcircle",
  0x24cb,
  "Vdotbelow",
  0x1e7e,
  "Vecyrillic",
  0x0412,
  "Vewarmenian",
  0x054e,
  "Vhook",
  0x01b2,
  "Vmonospace",
  0xff36,
  "Voarmenian",
  0x0548,
  "Vsmall",
  0xf776,
  "Vtilde",
  0x1e7c,
  "W",
  0x0057,
  "Wacute",
  0x1e82,
  "Wcircle",
  0x24cc,
  "Wcircumflex",
  0x0174,
  "Wdieresis",
  0x1e84,
  "Wdotaccent",
  0x1e86,
  "Wdotbelow",
  0x1e88,
  "Wgrave",
  0x1e80,
  "Wmonospace",
  0xff37,
  "Wsmall",
  0xf777,
  "X",
  0x0058,
  "Xcircle",
  0x24cd,
  "Xdieresis",
  0x1e8c,
  "Xdotaccent",
  0x1e8a,
  "Xeharmenian",
  0x053d,
  "Xi",
  0x039e,
  "Xmonospace",
  0xff38,
  "Xsmall",
  0xf778,
  "Y",
  0x0059,
  "Yacute",
  0x00dd,
  "Yacutesmall",
  0xf7fd,
  "Yatcyrillic",
  0x0462,
  "Ycircle",
  0x24ce,
  "Ycircumflex",
  0x0176,
  "Ydieresis",
  0x0178,
  "Ydieresissmall",
  0xf7ff,
  "Ydotaccent",
  0x1e8e,
  "Ydotbelow",
  0x1ef4,
  "Yericyrillic",
  0x042b,
  "Yerudieresiscyrillic",
  0x04f8,
  "Ygrave",
  0x1ef2,
  "Yhook",
  0x01b3,
  "Yhookabove",
  0x1ef6,
  "Yiarmenian",
  0x0545,
  "Yicyrillic",
  0x0407,
  "Yiwnarmenian",
  0x0552,
  "Ymonospace",
  0xff39,
  "Ysmall",
  0xf779,
  "Ytilde",
  0x1ef8,
  "Yusbigcyrillic",
  0x046a,
  "Yusbigiotifiedcyrillic",
  0x046c,
  "Yuslittlecyrillic",
  0x0466,
  "Yuslittleiotifiedcyrillic",
  0x0468,
  "Z",
  0x005a,
  "Zaarmenian",
  0x0536,
  "Zacute",
  0x0179,
  "Zcaron",
  0x017d,
  "Zcaronsmall",
  0xf6ff,
  "Zcircle",
  0x24cf,
  "Zcircumflex",
  0x1e90,
  "Zdot",
  0x017b,
  "Zdotaccent",
  0x017b,
  "Zdotbelow",
  0x1e92,
  "Zecyrillic",
  0x0417,
  "Zedescendercyrillic",
  0x0498,
  "Zedieresiscyrillic",
  0x04de,
  "Zeta",
  0x0396,
  "Zhearmenian",
  0x053a,
  "Zhebrevecyrillic",
  0x04c1,
  "Zhecyrillic",
  0x0416,
  "Zhedescendercyrillic",
  0x0496,
  "Zhedieresiscyrillic",
  0x04dc,
  "Zlinebelow",
  0x1e94,
  "Zmonospace",
  0xff3a,
  "Zsmall",
  0xf77a,
  "Zstroke",
  0x01b5,
  "a",
  0x0061,
  "aabengali",
  0x0986,
  "aacute",
  0x00e1,
  "aadeva",
  0x0906,
  "aagujarati",
  0x0a86,
  "aagurmukhi",
  0x0a06,
  "aamatragurmukhi",
  0x0a3e,
  "aarusquare",
  0x3303,
  "aavowelsignbengali",
  0x09be,
  "aavowelsigndeva",
  0x093e,
  "aavowelsigngujarati",
  0x0abe,
  "abbreviationmarkarmenian",
  0x055f,
  "abbreviationsigndeva",
  0x0970,
  "abengali",
  0x0985,
  "abopomofo",
  0x311a,
  "abreve",
  0x0103,
  "abreveacute",
  0x1eaf,
  "abrevecyrillic",
  0x04d1,
  "abrevedotbelow",
  0x1eb7,
  "abrevegrave",
  0x1eb1,
  "abrevehookabove",
  0x1eb3,
  "abrevetilde",
  0x1eb5,
  "acaron",
  0x01ce,
  "acircle",
  0x24d0,
  "acircumflex",
  0x00e2,
  "acircumflexacute",
  0x1ea5,
  "acircumflexdotbelow",
  0x1ead,
  "acircumflexgrave",
  0x1ea7,
  "acircumflexhookabove",
  0x1ea9,
  "acircumflextilde",
  0x1eab,
  "acute",
  0x00b4,
  "acutebelowcmb",
  0x0317,
  "acutecmb",
  0x0301,
  "acutecomb",
  0x0301,
  "acutedeva",
  0x0954,
  "acutelowmod",
  0x02cf,
  "acutetonecmb",
  0x0341,
  "acyrillic",
  0x0430,
  "adblgrave",
  0x0201,
  "addakgurmukhi",
  0x0a71,
  "adeva",
  0x0905,
  "adieresis",
  0x00e4,
  "adieresiscyrillic",
  0x04d3,
  "adieresismacron",
  0x01df,
  "adotbelow",
  0x1ea1,
  "adotmacron",
  0x01e1,
  "ae",
  0x00e6,
  "aeacute",
  0x01fd,
  "aekorean",
  0x3150,
  "aemacron",
  0x01e3,
  "afii00208",
  0x2015,
  "afii08941",
  0x20a4,
  "afii10017",
  0x0410,
  "afii10018",
  0x0411,
  "afii10019",
  0x0412,
  "afii10020",
  0x0413,
  "afii10021",
  0x0414,
  "afii10022",
  0x0415,
  "afii10023",
  0x0401,
  "afii10024",
  0x0416,
  "afii10025",
  0x0417,
  "afii10026",
  0x0418,
  "afii10027",
  0x0419,
  "afii10028",
  0x041a,
  "afii10029",
  0x041b,
  "afii10030",
  0x041c,
  "afii10031",
  0x041d,
  "afii10032",
  0x041e,
  "afii10033",
  0x041f,
  "afii10034",
  0x0420,
  "afii10035",
  0x0421,
  "afii10036",
  0x0422,
  "afii10037",
  0x0423,
  "afii10038",
  0x0424,
  "afii10039",
  0x0425,
  "afii10040",
  0x0426,
  "afii10041",
  0x0427,
  "afii10042",
  0x0428,
  "afii10043",
  0x0429,
  "afii10044",
  0x042a,
  "afii10045",
  0x042b,
  "afii10046",
  0x042c,
  "afii10047",
  0x042d,
  "afii10048",
  0x042e,
  "afii10049",
  0x042f,
  "afii10050",
  0x0490,
  "afii10051",
  0x0402,
  "afii10052",
  0x0403,
  "afii10053",
  0x0404,
  "afii10054",
  0x0405,
  "afii10055",
  0x0406,
  "afii10056",
  0x0407,
  "afii10057",
  0x0408,
  "afii10058",
  0x0409,
  "afii10059",
  0x040a,
  "afii10060",
  0x040b,
  "afii10061",
  0x040c,
  "afii10062",
  0x040e,
  "afii10063",
  0xf6c4,
  "afii10064",
  0xf6c5,
  "afii10065",
  0x0430,
  "afii10066",
  0x0431,
  "afii10067",
  0x0432,
  "afii10068",
  0x0433,
  "afii10069",
  0x0434,
  "afii10070",
  0x0435,
  "afii10071",
  0x0451,
  "afii10072",
  0x0436,
  "afii10073",
  0x0437,
  "afii10074",
  0x0438,
  "afii10075",
  0x0439,
  "afii10076",
  0x043a,
  "afii10077",
  0x043b,
  "afii10078",
  0x043c,
  "afii10079",
  0x043d,
  "afii10080",
  0x043e,
  "afii10081",
  0x043f,
  "afii10082",
  0x0440,
  "afii10083",
  0x0441,
  "afii10084",
  0x0442,
  "afii10085",
  0x0443,
  "afii10086",
  0x0444,
  "afii10087",
  0x0445,
  "afii10088",
  0x0446,
  "afii10089",
  0x0447,
  "afii10090",
  0x0448,
  "afii10091",
  0x0449,
  "afii10092",
  0x044a,
  "afii10093",
  0x044b,
  "afii10094",
  0x044c,
  "afii10095",
  0x044d,
  "afii10096",
  0x044e,
  "afii10097",
  0x044f,
  "afii10098",
  0x0491,
  "afii10099",
  0x0452,
  "afii10100",
  0x0453,
  "afii10101",
  0x0454,
  "afii10102",
  0x0455,
  "afii10103",
  0x0456,
  "afii10104",
  0x0457,
  "afii10105",
  0x0458,
  "afii10106",
  0x0459,
  "afii10107",
  0x045a,
  "afii10108",
  0x045b,
  "afii10109",
  0x045c,
  "afii10110",
  0x045e,
  "afii10145",
  0x040f,
  "afii10146",
  0x0462,
  "afii10147",
  0x0472,
  "afii10148",
  0x0474,
  "afii10192",
  0xf6c6,
  "afii10193",
  0x045f,
  "afii10194",
  0x0463,
  "afii10195",
  0x0473,
  "afii10196",
  0x0475,
  "afii10831",
  0xf6c7,
  "afii10832",
  0xf6c8,
  "afii10846",
  0x04d9,
  "afii299",
  0x200e,
  "afii300",
  0x200f,
  "afii301",
  0x200d,
  "afii57381",
  0x066a,
  "afii57388",
  0x060c,
  "afii57392",
  0x0660,
  "afii57393",
  0x0661,
  "afii57394",
  0x0662,
  "afii57395",
  0x0663,
  "afii57396",
  0x0664,
  "afii57397",
  0x0665,
  "afii57398",
  0x0666,
  "afii57399",
  0x0667,
  "afii57400",
  0x0668,
  "afii57401",
  0x0669,
  "afii57403",
  0x061b,
  "afii57407",
  0x061f,
  "afii57409",
  0x0621,
  "afii57410",
  0x0622,
  "afii57411",
  0x0623,
  "afii57412",
  0x0624,
  "afii57413",
  0x0625,
  "afii57414",
  0x0626,
  "afii57415",
  0x0627,
  "afii57416",
  0x0628,
  "afii57417",
  0x0629,
  "afii57418",
  0x062a,
  "afii57419",
  0x062b,
  "afii57420",
  0x062c,
  "afii57421",
  0x062d,
  "afii57422",
  0x062e,
  "afii57423",
  0x062f,
  "afii57424",
  0x0630,
  "afii57425",
  0x0631,
  "afii57426",
  0x0632,
  "afii57427",
  0x0633,
  "afii57428",
  0x0634,
  "afii57429",
  0x0635,
  "afii57430",
  0x0636,
  "afii57431",
  0x0637,
  "afii57432",
  0x0638,
  "afii57433",
  0x0639,
  "afii57434",
  0x063a,
  "afii57440",
  0x0640,
  "afii57441",
  0x0641,
  "afii57442",
  0x0642,
  "afii57443",
  0x0643,
  "afii57444",
  0x0644,
  "afii57445",
  0x0645,
  "afii57446",
  0x0646,
  "afii57448",
  0x0648,
  "afii57449",
  0x0649,
  "afii57450",
  0x064a,
  "afii57451",
  0x064b,
  "afii57452",
  0x064c,
  "afii57453",
  0x064d,
  "afii57454",
  0x064e,
  "afii57455",
  0x064f,
  "afii57456",
  0x0650,
  "afii57457",
  0x0651,
  "afii57458",
  0x0652,
  "afii57470",
  0x0647,
  "afii57505",
  0x06a4,
  "afii57506",
  0x067e,
  "afii57507",
  0x0686,
  "afii57508",
  0x0698,
  "afii57509",
  0x06af,
  "afii57511",
  0x0679,
  "afii57512",
  0x0688,
  "afii57513",
  0x0691,
  "afii57514",
  0x06ba,
  "afii57519",
  0x06d2,
  "afii57534",
  0x06d5,
  "afii57636",
  0x20aa,
  "afii57645",
  0x05be,
  "afii57658",
  0x05c3,
  "afii57664",
  0x05d0,
  "afii57665",
  0x05d1,
  "afii57666",
  0x05d2,
  "afii57667",
  0x05d3,
  "afii57668",
  0x05d4,
  "afii57669",
  0x05d5,
  "afii57670",
  0x05d6,
  "afii57671",
  0x05d7,
  "afii57672",
  0x05d8,
  "afii57673",
  0x05d9,
  "afii57674",
  0x05da,
  "afii57675",
  0x05db,
  "afii57676",
  0x05dc,
  "afii57677",
  0x05dd,
  "afii57678",
  0x05de,
  "afii57679",
  0x05df,
  "afii57680",
  0x05e0,
  "afii57681",
  0x05e1,
  "afii57682",
  0x05e2,
  "afii57683",
  0x05e3,
  "afii57684",
  0x05e4,
  "afii57685",
  0x05e5,
  "afii57686",
  0x05e6,
  "afii57687",
  0x05e7,
  "afii57688",
  0x05e8,
  "afii57689",
  0x05e9,
  "afii57690",
  0x05ea,
  "afii57694",
  0xfb2a,
  "afii57695",
  0xfb2b,
  "afii57700",
  0xfb4b,
  "afii57705",
  0xfb1f,
  "afii57716",
  0x05f0,
  "afii57717",
  0x05f1,
  "afii57718",
  0x05f2,
  "afii57723",
  0xfb35,
  "afii57793",
  0x05b4,
  "afii57794",
  0x05b5,
  "afii57795",
  0x05b6,
  "afii57796",
  0x05bb,
  "afii57797",
  0x05b8,
  "afii57798",
  0x05b7,
  "afii57799",
  0x05b0,
  "afii57800",
  0x05b2,
  "afii57801",
  0x05b1,
  "afii57802",
  0x05b3,
  "afii57803",
  0x05c2,
  "afii57804",
  0x05c1,
  "afii57806",
  0x05b9,
  "afii57807",
  0x05bc,
  "afii57839",
  0x05bd,
  "afii57841",
  0x05bf,
  "afii57842",
  0x05c0,
  "afii57929",
  0x02bc,
  "afii61248",
  0x2105,
  "afii61289",
  0x2113,
  "afii61352",
  0x2116,
  "afii61573",
  0x202c,
  "afii61574",
  0x202d,
  "afii61575",
  0x202e,
  "afii61664",
  0x200c,
  "afii63167",
  0x066d,
  "afii64937",
  0x02bd,
  "agrave",
  0x00e0,
  "agujarati",
  0x0a85,
  "agurmukhi",
  0x0a05,
  "ahiragana",
  0x3042,
  "ahookabove",
  0x1ea3,
  "aibengali",
  0x0990,
  "aibopomofo",
  0x311e,
  "aideva",
  0x0910,
  "aiecyrillic",
  0x04d5,
  "aigujarati",
  0x0a90,
  "aigurmukhi",
  0x0a10,
  "aimatragurmukhi",
  0x0a48,
  "ainarabic",
  0x0639,
  "ainfinalarabic",
  0xfeca,
  "aininitialarabic",
  0xfecb,
  "ainmedialarabic",
  0xfecc,
  "ainvertedbreve",
  0x0203,
  "aivowelsignbengali",
  0x09c8,
  "aivowelsigndeva",
  0x0948,
  "aivowelsigngujarati",
  0x0ac8,
  "akatakana",
  0x30a2,
  "akatakanahalfwidth",
  0xff71,
  "akorean",
  0x314f,
  "alef",
  0x05d0,
  "alefarabic",
  0x0627,
  "alefdageshhebrew",
  0xfb30,
  "aleffinalarabic",
  0xfe8e,
  "alefhamzaabovearabic",
  0x0623,
  "alefhamzaabovefinalarabic",
  0xfe84,
  "alefhamzabelowarabic",
  0x0625,
  "alefhamzabelowfinalarabic",
  0xfe88,
  "alefhebrew",
  0x05d0,
  "aleflamedhebrew",
  0xfb4f,
  "alefmaddaabovearabic",
  0x0622,
  "alefmaddaabovefinalarabic",
  0xfe82,
  "alefmaksuraarabic",
  0x0649,
  "alefmaksurafinalarabic",
  0xfef0,
  "alefmaksurainitialarabic",
  0xfef3,
  "alefmaksuramedialarabic",
  0xfef4,
  "alefpatahhebrew",
  0xfb2e,
  "alefqamatshebrew",
  0xfb2f,
  "aleph",
  0x2135,
  "allequal",
  0x224c,
  "alpha",
  0x03b1,
  "alphatonos",
  0x03ac,
  "amacron",
  0x0101,
  "amonospace",
  0xff41,
  "ampersand",
  0x0026,
  "ampersandmonospace",
  0xff06,
  "ampersandsmall",
  0xf726,
  "amsquare",
  0x33c2,
  "anbopomofo",
  0x3122,
  "angbopomofo",
  0x3124,
  "angbracketleft",
  0x3008,
  "angbracketright",
  0x3009,
  "angkhankhuthai",
  0x0e5a,
  "angle",
  0x2220,
  "anglebracketleft",
  0x3008,
  "anglebracketleftvertical",
  0xfe3f,
  "anglebracketright",
  0x3009,
  "anglebracketrightvertical",
  0xfe40,
  "angleleft",
  0x2329,
  "angleright",
  0x232a,
  "angstrom",
  0x212b,
  "anoteleia",
  0x0387,
  "anudattadeva",
  0x0952,
  "anusvarabengali",
  0x0982,
  "anusvaradeva",
  0x0902,
  "anusvaragujarati",
  0x0a82,
  "aogonek",
  0x0105,
  "apaatosquare",
  0x3300,
  "aparen",
  0x249c,
  "apostrophearmenian",
  0x055a,
  "apostrophemod",
  0x02bc,
  "apple",
  0xf8ff,
  "approaches",
  0x2250,
  "approxequal",
  0x2248,
  "approxequalorimage",
  0x2252,
  "approximatelyequal",
  0x2245,
  "araeaekorean",
  0x318e,
  "araeakorean",
  0x318d,
  "arc",
  0x2312,
  "arighthalfring",
  0x1e9a,
  "aring",
  0x00e5,
  "aringacute",
  0x01fb,
  "aringbelow",
  0x1e01,
  "arrowboth",
  0x2194,
  "arrowdashdown",
  0x21e3,
  "arrowdashleft",
  0x21e0,
  "arrowdashright",
  0x21e2,
  "arrowdashup",
  0x21e1,
  "arrowdblboth",
  0x21d4,
  "arrowdbldown",
  0x21d3,
  "arrowdblleft",
  0x21d0,
  "arrowdblright",
  0x21d2,
  "arrowdblup",
  0x21d1,
  "arrowdown",
  0x2193,
  "arrowdownleft",
  0x2199,
  "arrowdownright",
  0x2198,
  "arrowdownwhite",
  0x21e9,
  "arrowheaddownmod",
  0x02c5,
  "arrowheadleftmod",
  0x02c2,
  "arrowheadrightmod",
  0x02c3,
  "arrowheadupmod",
  0x02c4,
  "arrowhorizex",
  0xf8e7,
  "arrowleft",
  0x2190,
  "arrowleftdbl",
  0x21d0,
  "arrowleftdblstroke",
  0x21cd,
  "arrowleftoverright",
  0x21c6,
  "arrowleftwhite",
  0x21e6,
  "arrowright",
  0x2192,
  "arrowrightdblstroke",
  0x21cf,
  "arrowrightheavy",
  0x279e,
  "arrowrightoverleft",
  0x21c4,
  "arrowrightwhite",
  0x21e8,
  "arrowtableft",
  0x21e4,
  "arrowtabright",
  0x21e5,
  "arrowup",
  0x2191,
  "arrowupdn",
  0x2195,
  "arrowupdnbse",
  0x21a8,
  "arrowupdownbase",
  0x21a8,
  "arrowupleft",
  0x2196,
  "arrowupleftofdown",
  0x21c5,
  "arrowupright",
  0x2197,
  "arrowupwhite",
  0x21e7,
  "arrowvertex",
  0xf8e6,
  "asciicircum",
  0x005e,
  "asciicircummonospace",
  0xff3e,
  "asciitilde",
  0x007e,
  "asciitildemonospace",
  0xff5e,
  "ascript",
  0x0251,
  "ascriptturned",
  0x0252,
  "asmallhiragana",
  0x3041,
  "asmallkatakana",
  0x30a1,
  "asmallkatakanahalfwidth",
  0xff67,
  "asterisk",
  0x002a,
  "asteriskaltonearabic",
  0x066d,
  "asteriskarabic",
  0x066d,
  "asteriskmath",
  0x2217,
  "asteriskmonospace",
  0xff0a,
  "asterisksmall",
  0xfe61,
  "asterism",
  0x2042,
  "asuperior",
  0xf6e9,
  "asymptoticallyequal",
  0x2243,
  "at",
  0x0040,
  "atilde",
  0x00e3,
  "atmonospace",
  0xff20,
  "atsmall",
  0xfe6b,
  "aturned",
  0x0250,
  "aubengali",
  0x0994,
  "aubopomofo",
  0x3120,
  "audeva",
  0x0914,
  "augujarati",
  0x0a94,
  "augurmukhi",
  0x0a14,
  "aulengthmarkbengali",
  0x09d7,
  "aumatragurmukhi",
  0x0a4c,
  "auvowelsignbengali",
  0x09cc,
  "auvowelsigndeva",
  0x094c,
  "auvowelsigngujarati",
  0x0acc,
  "avagrahadeva",
  0x093d,
  "aybarmenian",
  0x0561,
  "ayin",
  0x05e2,
  "ayinaltonehebrew",
  0xfb20,
  "ayinhebrew",
  0x05e2,
  "b",
  0x0062,
  "babengali",
  0x09ac,
  "backslash",
  0x005c,
  "backslashmonospace",
  0xff3c,
  "badeva",
  0x092c,
  "bagujarati",
  0x0aac,
  "bagurmukhi",
  0x0a2c,
  "bahiragana",
  0x3070,
  "bahtthai",
  0x0e3f,
  "bakatakana",
  0x30d0,
  "bar",
  0x007c,
  "barmonospace",
  0xff5c,
  "bbopomofo",
  0x3105,
  "bcircle",
  0x24d1,
  "bdotaccent",
  0x1e03,
  "bdotbelow",
  0x1e05,
  "beamedsixteenthnotes",
  0x266c,
  "because",
  0x2235,
  "becyrillic",
  0x0431,
  "beharabic",
  0x0628,
  "behfinalarabic",
  0xfe90,
  "behinitialarabic",
  0xfe91,
  "behiragana",
  0x3079,
  "behmedialarabic",
  0xfe92,
  "behmeeminitialarabic",
  0xfc9f,
  "behmeemisolatedarabic",
  0xfc08,
  "behnoonfinalarabic",
  0xfc6d,
  "bekatakana",
  0x30d9,
  "benarmenian",
  0x0562,
  "bet",
  0x05d1,
  "beta",
  0x03b2,
  "betasymbolgreek",
  0x03d0,
  "betdagesh",
  0xfb31,
  "betdageshhebrew",
  0xfb31,
  "bethebrew",
  0x05d1,
  "betrafehebrew",
  0xfb4c,
  "bhabengali",
  0x09ad,
  "bhadeva",
  0x092d,
  "bhagujarati",
  0x0aad,
  "bhagurmukhi",
  0x0a2d,
  "bhook",
  0x0253,
  "bihiragana",
  0x3073,
  "bikatakana",
  0x30d3,
  "bilabialclick",
  0x0298,
  "bindigurmukhi",
  0x0a02,
  "birusquare",
  0x3331,
  "blackcircle",
  0x25cf,
  "blackdiamond",
  0x25c6,
  "blackdownpointingtriangle",
  0x25bc,
  "blackleftpointingpointer",
  0x25c4,
  "blackleftpointingtriangle",
  0x25c0,
  "blacklenticularbracketleft",
  0x3010,
  "blacklenticularbracketleftvertical",
  0xfe3b,
  "blacklenticularbracketright",
  0x3011,
  "blacklenticularbracketrightvertical",
  0xfe3c,
  "blacklowerlefttriangle",
  0x25e3,
  "blacklowerrighttriangle",
  0x25e2,
  "blackrectangle",
  0x25ac,
  "blackrightpointingpointer",
  0x25ba,
  "blackrightpointingtriangle",
  0x25b6,
  "blacksmallsquare",
  0x25aa,
  "blacksmilingface",
  0x263b,
  "blacksquare",
  0x25a0,
  "blackstar",
  0x2605,
  "blackupperlefttriangle",
  0x25e4,
  "blackupperrighttriangle",
  0x25e5,
  "blackuppointingsmalltriangle",
  0x25b4,
  "blackuppointingtriangle",
  0x25b2,
  "blank",
  0x2423,
  "blinebelow",
  0x1e07,
  "block",
  0x2588,
  "bmonospace",
  0xff42,
  "bobaimaithai",
  0x0e1a,
  "bohiragana",
  0x307c,
  "bokatakana",
  0x30dc,
  "bparen",
  0x249d,
  "bqsquare",
  0x33c3,
  "braceex",
  0xf8f4,
  "braceleft",
  0x007b,
  "braceleftbt",
  0xf8f3,
  "braceleftmid",
  0xf8f2,
  "braceleftmonospace",
  0xff5b,
  "braceleftsmall",
  0xfe5b,
  "bracelefttp",
  0xf8f1,
  "braceleftvertical",
  0xfe37,
  "braceright",
  0x007d,
  "bracerightbt",
  0xf8fe,
  "bracerightmid",
  0xf8fd,
  "bracerightmonospace",
  0xff5d,
  "bracerightsmall",
  0xfe5c,
  "bracerighttp",
  0xf8fc,
  "bracerightvertical",
  0xfe38,
  "bracketleft",
  0x005b,
  "bracketleftbt",
  0xf8f0,
  "bracketleftex",
  0xf8ef,
  "bracketleftmonospace",
  0xff3b,
  "bracketlefttp",
  0xf8ee,
  "bracketright",
  0x005d,
  "bracketrightbt",
  0xf8fb,
  "bracketrightex",
  0xf8fa,
  "bracketrightmonospace",
  0xff3d,
  "bracketrighttp",
  0xf8f9,
  "breve",
  0x02d8,
  "brevebelowcmb",
  0x032e,
  "brevecmb",
  0x0306,
  "breveinvertedbelowcmb",
  0x032f,
  "breveinvertedcmb",
  0x0311,
  "breveinverteddoublecmb",
  0x0361,
  "bridgebelowcmb",
  0x032a,
  "bridgeinvertedbelowcmb",
  0x033a,
  "brokenbar",
  0x00a6,
  "bstroke",
  0x0180,
  "bsuperior",
  0xf6ea,
  "btopbar",
  0x0183,
  "buhiragana",
  0x3076,
  "bukatakana",
  0x30d6,
  "bullet",
  0x2022,
  "bulletinverse",
  0x25d8,
  "bulletoperator",
  0x2219,
  "bullseye",
  0x25ce,
  "c",
  0x0063,
  "caarmenian",
  0x056e,
  "cabengali",
  0x099a,
  "cacute",
  0x0107,
  "cadeva",
  0x091a,
  "cagujarati",
  0x0a9a,
  "cagurmukhi",
  0x0a1a,
  "calsquare",
  0x3388,
  "candrabindubengali",
  0x0981,
  "candrabinducmb",
  0x0310,
  "candrabindudeva",
  0x0901,
  "candrabindugujarati",
  0x0a81,
  "capslock",
  0x21ea,
  "careof",
  0x2105,
  "caron",
  0x02c7,
  "caronbelowcmb",
  0x032c,
  "caroncmb",
  0x030c,
  "carriagereturn",
  0x21b5,
  "cbopomofo",
  0x3118,
  "ccaron",
  0x010d,
  "ccedilla",
  0x00e7,
  "ccedillaacute",
  0x1e09,
  "ccircle",
  0x24d2,
  "ccircumflex",
  0x0109,
  "ccurl",
  0x0255,
  "cdot",
  0x010b,
  "cdotaccent",
  0x010b,
  "cdsquare",
  0x33c5,
  "cedilla",
  0x00b8,
  "cedillacmb",
  0x0327,
  "cent",
  0x00a2,
  "centigrade",
  0x2103,
  "centinferior",
  0xf6df,
  "centmonospace",
  0xffe0,
  "centoldstyle",
  0xf7a2,
  "centsuperior",
  0xf6e0,
  "chaarmenian",
  0x0579,
  "chabengali",
  0x099b,
  "chadeva",
  0x091b,
  "chagujarati",
  0x0a9b,
  "chagurmukhi",
  0x0a1b,
  "chbopomofo",
  0x3114,
  "cheabkhasiancyrillic",
  0x04bd,
  "checkmark",
  0x2713,
  "checyrillic",
  0x0447,
  "chedescenderabkhasiancyrillic",
  0x04bf,
  "chedescendercyrillic",
  0x04b7,
  "chedieresiscyrillic",
  0x04f5,
  "cheharmenian",
  0x0573,
  "chekhakassiancyrillic",
  0x04cc,
  "cheverticalstrokecyrillic",
  0x04b9,
  "chi",
  0x03c7,
  "chieuchacirclekorean",
  0x3277,
  "chieuchaparenkorean",
  0x3217,
  "chieuchcirclekorean",
  0x3269,
  "chieuchkorean",
  0x314a,
  "chieuchparenkorean",
  0x3209,
  "chochangthai",
  0x0e0a,
  "chochanthai",
  0x0e08,
  "chochingthai",
  0x0e09,
  "chochoethai",
  0x0e0c,
  "chook",
  0x0188,
  "cieucacirclekorean",
  0x3276,
  "cieucaparenkorean",
  0x3216,
  "cieuccirclekorean",
  0x3268,
  "cieuckorean",
  0x3148,
  "cieucparenkorean",
  0x3208,
  "cieucuparenkorean",
  0x321c,
  "circle",
  0x25cb,
  "circlecopyrt",
  0x00a9,
  "circlemultiply",
  0x2297,
  "circleot",
  0x2299,
  "circleplus",
  0x2295,
  "circlepostalmark",
  0x3036,
  "circlewithlefthalfblack",
  0x25d0,
  "circlewithrighthalfblack",
  0x25d1,
  "circumflex",
  0x02c6,
  "circumflexbelowcmb",
  0x032d,
  "circumflexcmb",
  0x0302,
  "clear",
  0x2327,
  "clickalveolar",
  0x01c2,
  "clickdental",
  0x01c0,
  "clicklateral",
  0x01c1,
  "clickretroflex",
  0x01c3,
  "club",
  0x2663,
  "clubsuitblack",
  0x2663,
  "clubsuitwhite",
  0x2667,
  "cmcubedsquare",
  0x33a4,
  "cmonospace",
  0xff43,
  "cmsquaredsquare",
  0x33a0,
  "coarmenian",
  0x0581,
  "colon",
  0x003a,
  "colonmonetary",
  0x20a1,
  "colonmonospace",
  0xff1a,
  "colonsign",
  0x20a1,
  "colonsmall",
  0xfe55,
  "colontriangularhalfmod",
  0x02d1,
  "colontriangularmod",
  0x02d0,
  "comma",
  0x002c,
  "commaabovecmb",
  0x0313,
  "commaaboverightcmb",
  0x0315,
  "commaaccent",
  0xf6c3,
  "commaarabic",
  0x060c,
  "commaarmenian",
  0x055d,
  "commainferior",
  0xf6e1,
  "commamonospace",
  0xff0c,
  "commareversedabovecmb",
  0x0314,
  "commareversedmod",
  0x02bd,
  "commasmall",
  0xfe50,
  "commasuperior",
  0xf6e2,
  "commaturnedabovecmb",
  0x0312,
  "commaturnedmod",
  0x02bb,
  "compass",
  0x263c,
  "congruent",
  0x2245,
  "contourintegral",
  0x222e,
  "control",
  0x2303,
  "controlACK",
  0x0006,
  "controlBEL",
  0x0007,
  "controlBS",
  0x0008,
  "controlCAN",
  0x0018,
  "controlCR",
  0x000d,
  "controlDC1",
  0x0011,
  "controlDC2",
  0x0012,
  "controlDC3",
  0x0013,
  "controlDC4",
  0x0014,
  "controlDEL",
  0x007f,
  "controlDLE",
  0x0010,
  "controlEM",
  0x0019,
  "controlENQ",
  0x0005,
  "controlEOT",
  0x0004,
  "controlESC",
  0x001b,
  "controlETB",
  0x0017,
  "controlETX",
  0x0003,
  "controlFF",
  0x000c,
  "controlFS",
  0x001c,
  "controlGS",
  0x001d,
  "controlHT",
  0x0009,
  "controlLF",
  0x000a,
  "controlNAK",
  0x0015,
  "controlNULL",
  0x0000,
  "controlRS",
  0x001e,
  "controlSI",
  0x000f,
  "controlSO",
  0x000e,
  "controlSOT",
  0x0002,
  "controlSTX",
  0x0001,
  "controlSUB",
  0x001a,
  "controlSYN",
  0x0016,
  "controlUS",
  0x001f,
  "controlVT",
  0x000b,
  "copyright",
  0x00a9,
  "copyrightsans",
  0xf8e9,
  "copyrightserif",
  0xf6d9,
  "cornerbracketleft",
  0x300c,
  "cornerbracketlefthalfwidth",
  0xff62,
  "cornerbracketleftvertical",
  0xfe41,
  "cornerbracketright",
  0x300d,
  "cornerbracketrighthalfwidth",
  0xff63,
  "cornerbracketrightvertical",
  0xfe42,
  "corporationsquare",
  0x337f,
  "cosquare",
  0x33c7,
  "coverkgsquare",
  0x33c6,
  "cparen",
  0x249e,
  "cruzeiro",
  0x20a2,
  "cstretched",
  0x0297,
  "curlyand",
  0x22cf,
  "curlyor",
  0x22ce,
  "currency",
  0x00a4,
  "cyrBreve",
  0xf6d1,
  "cyrFlex",
  0xf6d2,
  "cyrbreve",
  0xf6d4,
  "cyrflex",
  0xf6d5,
  "d",
  0x0064,
  "daarmenian",
  0x0564,
  "dabengali",
  0x09a6,
  "dadarabic",
  0x0636,
  "dadeva",
  0x0926,
  "dadfinalarabic",
  0xfebe,
  "dadinitialarabic",
  0xfebf,
  "dadmedialarabic",
  0xfec0,
  "dagesh",
  0x05bc,
  "dageshhebrew",
  0x05bc,
  "dagger",
  0x2020,
  "daggerdbl",
  0x2021,
  "dagujarati",
  0x0aa6,
  "dagurmukhi",
  0x0a26,
  "dahiragana",
  0x3060,
  "dakatakana",
  0x30c0,
  "dalarabic",
  0x062f,
  "dalet",
  0x05d3,
  "daletdagesh",
  0xfb33,
  "daletdageshhebrew",
  0xfb33,
  "dalethebrew",
  0x05d3,
  "dalfinalarabic",
  0xfeaa,
  "dammaarabic",
  0x064f,
  "dammalowarabic",
  0x064f,
  "dammatanaltonearabic",
  0x064c,
  "dammatanarabic",
  0x064c,
  "danda",
  0x0964,
  "dargahebrew",
  0x05a7,
  "dargalefthebrew",
  0x05a7,
  "dasiapneumatacyrilliccmb",
  0x0485,
  "dblGrave",
  0xf6d3,
  "dblanglebracketleft",
  0x300a,
  "dblanglebracketleftvertical",
  0xfe3d,
  "dblanglebracketright",
  0x300b,
  "dblanglebracketrightvertical",
  0xfe3e,
  "dblarchinvertedbelowcmb",
  0x032b,
  "dblarrowleft",
  0x21d4,
  "dblarrowright",
  0x21d2,
  "dbldanda",
  0x0965,
  "dblgrave",
  0xf6d6,
  "dblgravecmb",
  0x030f,
  "dblintegral",
  0x222c,
  "dbllowline",
  0x2017,
  "dbllowlinecmb",
  0x0333,
  "dbloverlinecmb",
  0x033f,
  "dblprimemod",
  0x02ba,
  "dblverticalbar",
  0x2016,
  "dblverticallineabovecmb",
  0x030e,
  "dbopomofo",
  0x3109,
  "dbsquare",
  0x33c8,
  "dcaron",
  0x010f,
  "dcedilla",
  0x1e11,
  "dcircle",
  0x24d3,
  "dcircumflexbelow",
  0x1e13,
  "dcroat",
  0x0111,
  "ddabengali",
  0x09a1,
  "ddadeva",
  0x0921,
  "ddagujarati",
  0x0aa1,
  "ddagurmukhi",
  0x0a21,
  "ddalarabic",
  0x0688,
  "ddalfinalarabic",
  0xfb89,
  "dddhadeva",
  0x095c,
  "ddhabengali",
  0x09a2,
  "ddhadeva",
  0x0922,
  "ddhagujarati",
  0x0aa2,
  "ddhagurmukhi",
  0x0a22,
  "ddotaccent",
  0x1e0b,
  "ddotbelow",
  0x1e0d,
  "decimalseparatorarabic",
  0x066b,
  "decimalseparatorpersian",
  0x066b,
  "decyrillic",
  0x0434,
  "degree",
  0x00b0,
  "dehihebrew",
  0x05ad,
  "dehiragana",
  0x3067,
  "deicoptic",
  0x03ef,
  "dekatakana",
  0x30c7,
  "deleteleft",
  0x232b,
  "deleteright",
  0x2326,
  "delta",
  0x03b4,
  "deltaturned",
  0x018d,
  "denominatorminusonenumeratorbengali",
  0x09f8,
  "dezh",
  0x02a4,
  "dhabengali",
  0x09a7,
  "dhadeva",
  0x0927,
  "dhagujarati",
  0x0aa7,
  "dhagurmukhi",
  0x0a27,
  "dhook",
  0x0257,
  "dialytikatonos",
  0x0385,
  "dialytikatonoscmb",
  0x0344,
  "diamond",
  0x2666,
  "diamondsuitwhite",
  0x2662,
  "dieresis",
  0x00a8,
  "dieresisacute",
  0xf6d7,
  "dieresisbelowcmb",
  0x0324,
  "dieresiscmb",
  0x0308,
  "dieresisgrave",
  0xf6d8,
  "dieresistonos",
  0x0385,
  "dihiragana",
  0x3062,
  "dikatakana",
  0x30c2,
  "dittomark",
  0x3003,
  "divide",
  0x00f7,
  "divides",
  0x2223,
  "divisionslash",
  0x2215,
  "djecyrillic",
  0x0452,
  "dkshade",
  0x2593,
  "dlinebelow",
  0x1e0f,
  "dlsquare",
  0x3397,
  "dmacron",
  0x0111,
  "dmonospace",
  0xff44,
  "dnblock",
  0x2584,
  "dochadathai",
  0x0e0e,
  "dodekthai",
  0x0e14,
  "dohiragana",
  0x3069,
  "dokatakana",
  0x30c9,
  "dollar",
  0x0024,
  "dollarinferior",
  0xf6e3,
  "dollarmonospace",
  0xff04,
  "dollaroldstyle",
  0xf724,
  "dollarsmall",
  0xfe69,
  "dollarsuperior",
  0xf6e4,
  "dong",
  0x20ab,
  "dorusquare",
  0x3326,
  "dotaccent",
  0x02d9,
  "dotaccentcmb",
  0x0307,
  "dotbelowcmb",
  0x0323,
  "dotbelowcomb",
  0x0323,
  "dotkatakana",
  0x30fb,
  "dotlessi",
  0x0131,
  "dotlessj",
  0xf6be,
  "dotlessjstrokehook",
  0x0284,
  "dotmath",
  0x22c5,
  "dottedcircle",
  0x25cc,
  "doubleyodpatah",
  0xfb1f,
  "doubleyodpatahhebrew",
  0xfb1f,
  "downtackbelowcmb",
  0x031e,
  "downtackmod",
  0x02d5,
  "dparen",
  0x249f,
  "dsuperior",
  0xf6eb,
  "dtail",
  0x0256,
  "dtopbar",
  0x018c,
  "duhiragana",
  0x3065,
  "dukatakana",
  0x30c5,
  "dz",
  0x01f3,
  "dzaltone",
  0x02a3,
  "dzcaron",
  0x01c6,
  "dzcurl",
  0x02a5,
  "dzeabkhasiancyrillic",
  0x04e1,
  "dzecyrillic",
  0x0455,
  "dzhecyrillic",
  0x045f,
  "e",
  0x0065,
  "eacute",
  0x00e9,
  "earth",
  0x2641,
  "ebengali",
  0x098f,
  "ebopomofo",
  0x311c,
  "ebreve",
  0x0115,
  "ecandradeva",
  0x090d,
  "ecandragujarati",
  0x0a8d,
  "ecandravowelsigndeva",
  0x0945,
  "ecandravowelsigngujarati",
  0x0ac5,
  "ecaron",
  0x011b,
  "ecedillabreve",
  0x1e1d,
  "echarmenian",
  0x0565,
  "echyiwnarmenian",
  0x0587,
  "ecircle",
  0x24d4,
  "ecircumflex",
  0x00ea,
  "ecircumflexacute",
  0x1ebf,
  "ecircumflexbelow",
  0x1e19,
  "ecircumflexdotbelow",
  0x1ec7,
  "ecircumflexgrave",
  0x1ec1,
  "ecircumflexhookabove",
  0x1ec3,
  "ecircumflextilde",
  0x1ec5,
  "ecyrillic",
  0x0454,
  "edblgrave",
  0x0205,
  "edeva",
  0x090f,
  "edieresis",
  0x00eb,
  "edot",
  0x0117,
  "edotaccent",
  0x0117,
  "edotbelow",
  0x1eb9,
  "eegurmukhi",
  0x0a0f,
  "eematragurmukhi",
  0x0a47,
  "efcyrillic",
  0x0444,
  "egrave",
  0x00e8,
  "egujarati",
  0x0a8f,
  "eharmenian",
  0x0567,
  "ehbopomofo",
  0x311d,
  "ehiragana",
  0x3048,
  "ehookabove",
  0x1ebb,
  "eibopomofo",
  0x311f,
  "eight",
  0x0038,
  "eightarabic",
  0x0668,
  "eightbengali",
  0x09ee,
  "eightcircle",
  0x2467,
  "eightcircleinversesansserif",
  0x2791,
  "eightdeva",
  0x096e,
  "eighteencircle",
  0x2471,
  "eighteenparen",
  0x2485,
  "eighteenperiod",
  0x2499,
  "eightgujarati",
  0x0aee,
  "eightgurmukhi",
  0x0a6e,
  "eighthackarabic",
  0x0668,
  "eighthangzhou",
  0x3028,
  "eighthnotebeamed",
  0x266b,
  "eightideographicparen",
  0x3227,
  "eightinferior",
  0x2088,
  "eightmonospace",
  0xff18,
  "eightoldstyle",
  0xf738,
  "eightparen",
  0x247b,
  "eightperiod",
  0x248f,
  "eightpersian",
  0x06f8,
  "eightroman",
  0x2177,
  "eightsuperior",
  0x2078,
  "eightthai",
  0x0e58,
  "einvertedbreve",
  0x0207,
  "eiotifiedcyrillic",
  0x0465,
  "ekatakana",
  0x30a8,
  "ekatakanahalfwidth",
  0xff74,
  "ekonkargurmukhi",
  0x0a74,
  "ekorean",
  0x3154,
  "elcyrillic",
  0x043b,
  "element",
  0x2208,
  "elevencircle",
  0x246a,
  "elevenparen",
  0x247e,
  "elevenperiod",
  0x2492,
  "elevenroman",
  0x217a,
  "ellipsis",
  0x2026,
  "ellipsisvertical",
  0x22ee,
  "emacron",
  0x0113,
  "emacronacute",
  0x1e17,
  "emacrongrave",
  0x1e15,
  "emcyrillic",
  0x043c,
  "emdash",
  0x2014,
  "emdashvertical",
  0xfe31,
  "emonospace",
  0xff45,
  "emphasismarkarmenian",
  0x055b,
  "emptyset",
  0x2205,
  "enbopomofo",
  0x3123,
  "encyrillic",
  0x043d,
  "endash",
  0x2013,
  "endashvertical",
  0xfe32,
  "endescendercyrillic",
  0x04a3,
  "eng",
  0x014b,
  "engbopomofo",
  0x3125,
  "enghecyrillic",
  0x04a5,
  "enhookcyrillic",
  0x04c8,
  "enspace",
  0x2002,
  "eogonek",
  0x0119,
  "eokorean",
  0x3153,
  "eopen",
  0x025b,
  "eopenclosed",
  0x029a,
  "eopenreversed",
  0x025c,
  "eopenreversedclosed",
  0x025e,
  "eopenreversedhook",
  0x025d,
  "eparen",
  0x24a0,
  "epsilon",
  0x03b5,
  "epsilontonos",
  0x03ad,
  "equal",
  0x003d,
  "equalmonospace",
  0xff1d,
  "equalsmall",
  0xfe66,
  "equalsuperior",
  0x207c,
  "equivalence",
  0x2261,
  "erbopomofo",
  0x3126,
  "ercyrillic",
  0x0440,
  "ereversed",
  0x0258,
  "ereversedcyrillic",
  0x044d,
  "escyrillic",
  0x0441,
  "esdescendercyrillic",
  0x04ab,
  "esh",
  0x0283,
  "eshcurl",
  0x0286,
  "eshortdeva",
  0x090e,
  "eshortvowelsigndeva",
  0x0946,
  "eshreversedloop",
  0x01aa,
  "eshsquatreversed",
  0x0285,
  "esmallhiragana",
  0x3047,
  "esmallkatakana",
  0x30a7,
  "esmallkatakanahalfwidth",
  0xff6a,
  "estimated",
  0x212e,
  "esuperior",
  0xf6ec,
  "eta",
  0x03b7,
  "etarmenian",
  0x0568,
  "etatonos",
  0x03ae,
  "eth",
  0x00f0,
  "etilde",
  0x1ebd,
  "etildebelow",
  0x1e1b,
  "etnahtafoukhhebrew",
  0x0591,
  "etnahtafoukhlefthebrew",
  0x0591,
  "etnahtahebrew",
  0x0591,
  "etnahtalefthebrew",
  0x0591,
  "eturned",
  0x01dd,
  "eukorean",
  0x3161,
  "euro",
  0x20ac,
  "evowelsignbengali",
  0x09c7,
  "evowelsigndeva",
  0x0947,
  "evowelsigngujarati",
  0x0ac7,
  "exclam",
  0x0021,
  "exclamarmenian",
  0x055c,
  "exclamdbl",
  0x203c,
  "exclamdown",
  0x00a1,
  "exclamdownsmall",
  0xf7a1,
  "exclammonospace",
  0xff01,
  "exclamsmall",
  0xf721,
  "existential",
  0x2203,
  "ezh",
  0x0292,
  "ezhcaron",
  0x01ef,
  "ezhcurl",
  0x0293,
  "ezhreversed",
  0x01b9,
  "ezhtail",
  0x01ba,
  "f",
  0x0066,
  "fadeva",
  0x095e,
  "fagurmukhi",
  0x0a5e,
  "fahrenheit",
  0x2109,
  "fathaarabic",
  0x064e,
  "fathalowarabic",
  0x064e,
  "fathatanarabic",
  0x064b,
  "fbopomofo",
  0x3108,
  "fcircle",
  0x24d5,
  "fdotaccent",
  0x1e1f,
  "feharabic",
  0x0641,
  "feharmenian",
  0x0586,
  "fehfinalarabic",
  0xfed2,
  "fehinitialarabic",
  0xfed3,
  "fehmedialarabic",
  0xfed4,
  "feicoptic",
  0x03e5,
  "female",
  0x2640,
  "ff",
  0xfb00,
  "f_f",
  0xfb00,
  "ffi",
  0xfb03,
  "ffl",
  0xfb04,
  "fi",
  0xfb01,
  "fifteencircle",
  0x246e,
  "fifteenparen",
  0x2482,
  "fifteenperiod",
  0x2496,
  "figuredash",
  0x2012,
  "filledbox",
  0x25a0,
  "filledrect",
  0x25ac,
  "finalkaf",
  0x05da,
  "finalkafdagesh",
  0xfb3a,
  "finalkafdageshhebrew",
  0xfb3a,
  "finalkafhebrew",
  0x05da,
  "finalmem",
  0x05dd,
  "finalmemhebrew",
  0x05dd,
  "finalnun",
  0x05df,
  "finalnunhebrew",
  0x05df,
  "finalpe",
  0x05e3,
  "finalpehebrew",
  0x05e3,
  "finaltsadi",
  0x05e5,
  "finaltsadihebrew",
  0x05e5,
  "firsttonechinese",
  0x02c9,
  "fisheye",
  0x25c9,
  "fitacyrillic",
  0x0473,
  "five",
  0x0035,
  "fivearabic",
  0x0665,
  "fivebengali",
  0x09eb,
  "fivecircle",
  0x2464,
  "fivecircleinversesansserif",
  0x278e,
  "fivedeva",
  0x096b,
  "fiveeighths",
  0x215d,
  "fivegujarati",
  0x0aeb,
  "fivegurmukhi",
  0x0a6b,
  "fivehackarabic",
  0x0665,
  "fivehangzhou",
  0x3025,
  "fiveideographicparen",
  0x3224,
  "fiveinferior",
  0x2085,
  "fivemonospace",
  0xff15,
  "fiveoldstyle",
  0xf735,
  "fiveparen",
  0x2478,
  "fiveperiod",
  0x248c,
  "fivepersian",
  0x06f5,
  "fiveroman",
  0x2174,
  "fivesuperior",
  0x2075,
  "fivethai",
  0x0e55,
  "fl",
  0xfb02,
  "florin",
  0x0192,
  "fmonospace",
  0xff46,
  "fmsquare",
  0x3399,
  "fofanthai",
  0x0e1f,
  "fofathai",
  0x0e1d,
  "fongmanthai",
  0x0e4f,
  "forall",
  0x2200,
  "four",
  0x0034,
  "fourarabic",
  0x0664,
  "fourbengali",
  0x09ea,
  "fourcircle",
  0x2463,
  "fourcircleinversesansserif",
  0x278d,
  "fourdeva",
  0x096a,
  "fourgujarati",
  0x0aea,
  "fourgurmukhi",
  0x0a6a,
  "fourhackarabic",
  0x0664,
  "fourhangzhou",
  0x3024,
  "fourideographicparen",
  0x3223,
  "fourinferior",
  0x2084,
  "fourmonospace",
  0xff14,
  "fournumeratorbengali",
  0x09f7,
  "fouroldstyle",
  0xf734,
  "fourparen",
  0x2477,
  "fourperiod",
  0x248b,
  "fourpersian",
  0x06f4,
  "fourroman",
  0x2173,
  "foursuperior",
  0x2074,
  "fourteencircle",
  0x246d,
  "fourteenparen",
  0x2481,
  "fourteenperiod",
  0x2495,
  "fourthai",
  0x0e54,
  "fourthtonechinese",
  0x02cb,
  "fparen",
  0x24a1,
  "fraction",
  0x2044,
  "franc",
  0x20a3,
  "g",
  0x0067,
  "gabengali",
  0x0997,
  "gacute",
  0x01f5,
  "gadeva",
  0x0917,
  "gafarabic",
  0x06af,
  "gaffinalarabic",
  0xfb93,
  "gafinitialarabic",
  0xfb94,
  "gafmedialarabic",
  0xfb95,
  "gagujarati",
  0x0a97,
  "gagurmukhi",
  0x0a17,
  "gahiragana",
  0x304c,
  "gakatakana",
  0x30ac,
  "gamma",
  0x03b3,
  "gammalatinsmall",
  0x0263,
  "gammasuperior",
  0x02e0,
  "gangiacoptic",
  0x03eb,
  "gbopomofo",
  0x310d,
  "gbreve",
  0x011f,
  "gcaron",
  0x01e7,
  "gcedilla",
  0x0123,
  "gcircle",
  0x24d6,
  "gcircumflex",
  0x011d,
  "gcommaaccent",
  0x0123,
  "gdot",
  0x0121,
  "gdotaccent",
  0x0121,
  "gecyrillic",
  0x0433,
  "gehiragana",
  0x3052,
  "gekatakana",
  0x30b2,
  "geometricallyequal",
  0x2251,
  "gereshaccenthebrew",
  0x059c,
  "gereshhebrew",
  0x05f3,
  "gereshmuqdamhebrew",
  0x059d,
  "germandbls",
  0x00df,
  "gershayimaccenthebrew",
  0x059e,
  "gershayimhebrew",
  0x05f4,
  "getamark",
  0x3013,
  "ghabengali",
  0x0998,
  "ghadarmenian",
  0x0572,
  "ghadeva",
  0x0918,
  "ghagujarati",
  0x0a98,
  "ghagurmukhi",
  0x0a18,
  "ghainarabic",
  0x063a,
  "ghainfinalarabic",
  0xfece,
  "ghaininitialarabic",
  0xfecf,
  "ghainmedialarabic",
  0xfed0,
  "ghemiddlehookcyrillic",
  0x0495,
  "ghestrokecyrillic",
  0x0493,
  "gheupturncyrillic",
  0x0491,
  "ghhadeva",
  0x095a,
  "ghhagurmukhi",
  0x0a5a,
  "ghook",
  0x0260,
  "ghzsquare",
  0x3393,
  "gihiragana",
  0x304e,
  "gikatakana",
  0x30ae,
  "gimarmenian",
  0x0563,
  "gimel",
  0x05d2,
  "gimeldagesh",
  0xfb32,
  "gimeldageshhebrew",
  0xfb32,
  "gimelhebrew",
  0x05d2,
  "gjecyrillic",
  0x0453,
  "glottalinvertedstroke",
  0x01be,
  "glottalstop",
  0x0294,
  "glottalstopinverted",
  0x0296,
  "glottalstopmod",
  0x02c0,
  "glottalstopreversed",
  0x0295,
  "glottalstopreversedmod",
  0x02c1,
  "glottalstopreversedsuperior",
  0x02e4,
  "glottalstopstroke",
  0x02a1,
  "glottalstopstrokereversed",
  0x02a2,
  "gmacron",
  0x1e21,
  "gmonospace",
  0xff47,
  "gohiragana",
  0x3054,
  "gokatakana",
  0x30b4,
  "gparen",
  0x24a2,
  "gpasquare",
  0x33ac,
  "gradient",
  0x2207,
  "grave",
  0x0060,
  "gravebelowcmb",
  0x0316,
  "gravecmb",
  0x0300,
  "gravecomb",
  0x0300,
  "gravedeva",
  0x0953,
  "gravelowmod",
  0x02ce,
  "gravemonospace",
  0xff40,
  "gravetonecmb",
  0x0340,
  "greater",
  0x003e,
  "greaterequal",
  0x2265,
  "greaterequalorless",
  0x22db,
  "greatermonospace",
  0xff1e,
  "greaterorequivalent",
  0x2273,
  "greaterorless",
  0x2277,
  "greateroverequal",
  0x2267,
  "greatersmall",
  0xfe65,
  "gscript",
  0x0261,
  "gstroke",
  0x01e5,
  "guhiragana",
  0x3050,
  "guillemotleft",
  0x00ab,
  "guillemotright",
  0x00bb,
  "guilsinglleft",
  0x2039,
  "guilsinglright",
  0x203a,
  "gukatakana",
  0x30b0,
  "guramusquare",
  0x3318,
  "gysquare",
  0x33c9,
  "h",
  0x0068,
  "haabkhasiancyrillic",
  0x04a9,
  "haaltonearabic",
  0x06c1,
  "habengali",
  0x09b9,
  "hadescendercyrillic",
  0x04b3,
  "hadeva",
  0x0939,
  "hagujarati",
  0x0ab9,
  "hagurmukhi",
  0x0a39,
  "haharabic",
  0x062d,
  "hahfinalarabic",
  0xfea2,
  "hahinitialarabic",
  0xfea3,
  "hahiragana",
  0x306f,
  "hahmedialarabic",
  0xfea4,
  "haitusquare",
  0x332a,
  "hakatakana",
  0x30cf,
  "hakatakanahalfwidth",
  0xff8a,
  "halantgurmukhi",
  0x0a4d,
  "hamzaarabic",
  0x0621,
  "hamzalowarabic",
  0x0621,
  "hangulfiller",
  0x3164,
  "hardsigncyrillic",
  0x044a,
  "harpoonleftbarbup",
  0x21bc,
  "harpoonrightbarbup",
  0x21c0,
  "hasquare",
  0x33ca,
  "hatafpatah",
  0x05b2,
  "hatafpatah16",
  0x05b2,
  "hatafpatah23",
  0x05b2,
  "hatafpatah2f",
  0x05b2,
  "hatafpatahhebrew",
  0x05b2,
  "hatafpatahnarrowhebrew",
  0x05b2,
  "hatafpatahquarterhebrew",
  0x05b2,
  "hatafpatahwidehebrew",
  0x05b2,
  "hatafqamats",
  0x05b3,
  "hatafqamats1b",
  0x05b3,
  "hatafqamats28",
  0x05b3,
  "hatafqamats34",
  0x05b3,
  "hatafqamatshebrew",
  0x05b3,
  "hatafqamatsnarrowhebrew",
  0x05b3,
  "hatafqamatsquarterhebrew",
  0x05b3,
  "hatafqamatswidehebrew",
  0x05b3,
  "hatafsegol",
  0x05b1,
  "hatafsegol17",
  0x05b1,
  "hatafsegol24",
  0x05b1,
  "hatafsegol30",
  0x05b1,
  "hatafsegolhebrew",
  0x05b1,
  "hatafsegolnarrowhebrew",
  0x05b1,
  "hatafsegolquarterhebrew",
  0x05b1,
  "hatafsegolwidehebrew",
  0x05b1,
  "hbar",
  0x0127,
  "hbopomofo",
  0x310f,
  "hbrevebelow",
  0x1e2b,
  "hcedilla",
  0x1e29,
  "hcircle",
  0x24d7,
  "hcircumflex",
  0x0125,
  "hdieresis",
  0x1e27,
  "hdotaccent",
  0x1e23,
  "hdotbelow",
  0x1e25,
  "he",
  0x05d4,
  "heart",
  0x2665,
  "heartsuitblack",
  0x2665,
  "heartsuitwhite",
  0x2661,
  "hedagesh",
  0xfb34,
  "hedageshhebrew",
  0xfb34,
  "hehaltonearabic",
  0x06c1,
  "heharabic",
  0x0647,
  "hehebrew",
  0x05d4,
  "hehfinalaltonearabic",
  0xfba7,
  "hehfinalalttwoarabic",
  0xfeea,
  "hehfinalarabic",
  0xfeea,
  "hehhamzaabovefinalarabic",
  0xfba5,
  "hehhamzaaboveisolatedarabic",
  0xfba4,
  "hehinitialaltonearabic",
  0xfba8,
  "hehinitialarabic",
  0xfeeb,
  "hehiragana",
  0x3078,
  "hehmedialaltonearabic",
  0xfba9,
  "hehmedialarabic",
  0xfeec,
  "heiseierasquare",
  0x337b,
  "hekatakana",
  0x30d8,
  "hekatakanahalfwidth",
  0xff8d,
  "hekutaarusquare",
  0x3336,
  "henghook",
  0x0267,
  "herutusquare",
  0x3339,
  "het",
  0x05d7,
  "hethebrew",
  0x05d7,
  "hhook",
  0x0266,
  "hhooksuperior",
  0x02b1,
  "hieuhacirclekorean",
  0x327b,
  "hieuhaparenkorean",
  0x321b,
  "hieuhcirclekorean",
  0x326d,
  "hieuhkorean",
  0x314e,
  "hieuhparenkorean",
  0x320d,
  "hihiragana",
  0x3072,
  "hikatakana",
  0x30d2,
  "hikatakanahalfwidth",
  0xff8b,
  "hiriq",
  0x05b4,
  "hiriq14",
  0x05b4,
  "hiriq21",
  0x05b4,
  "hiriq2d",
  0x05b4,
  "hiriqhebrew",
  0x05b4,
  "hiriqnarrowhebrew",
  0x05b4,
  "hiriqquarterhebrew",
  0x05b4,
  "hiriqwidehebrew",
  0x05b4,
  "hlinebelow",
  0x1e96,
  "hmonospace",
  0xff48,
  "hoarmenian",
  0x0570,
  "hohipthai",
  0x0e2b,
  "hohiragana",
  0x307b,
  "hokatakana",
  0x30db,
  "hokatakanahalfwidth",
  0xff8e,
  "holam",
  0x05b9,
  "holam19",
  0x05b9,
  "holam26",
  0x05b9,
  "holam32",
  0x05b9,
  "holamhebrew",
  0x05b9,
  "holamnarrowhebrew",
  0x05b9,
  "holamquarterhebrew",
  0x05b9,
  "holamwidehebrew",
  0x05b9,
  "honokhukthai",
  0x0e2e,
  "hookabovecomb",
  0x0309,
  "hookcmb",
  0x0309,
  "hookpalatalizedbelowcmb",
  0x0321,
  "hookretroflexbelowcmb",
  0x0322,
  "hoonsquare",
  0x3342,
  "horicoptic",
  0x03e9,
  "horizontalbar",
  0x2015,
  "horncmb",
  0x031b,
  "hotsprings",
  0x2668,
  "house",
  0x2302,
  "hparen",
  0x24a3,
  "hsuperior",
  0x02b0,
  "hturned",
  0x0265,
  "huhiragana",
  0x3075,
  "huiitosquare",
  0x3333,
  "hukatakana",
  0x30d5,
  "hukatakanahalfwidth",
  0xff8c,
  "hungarumlaut",
  0x02dd,
  "hungarumlautcmb",
  0x030b,
  "hv",
  0x0195,
  "hyphen",
  0x002d,
  "hypheninferior",
  0xf6e5,
  "hyphenmonospace",
  0xff0d,
  "hyphensmall",
  0xfe63,
  "hyphensuperior",
  0xf6e6,
  "hyphentwo",
  0x2010,
  "i",
  0x0069,
  "iacute",
  0x00ed,
  "iacyrillic",
  0x044f,
  "ibengali",
  0x0987,
  "ibopomofo",
  0x3127,
  "ibreve",
  0x012d,
  "icaron",
  0x01d0,
  "icircle",
  0x24d8,
  "icircumflex",
  0x00ee,
  "icyrillic",
  0x0456,
  "idblgrave",
  0x0209,
  "ideographearthcircle",
  0x328f,
  "ideographfirecircle",
  0x328b,
  "ideographicallianceparen",
  0x323f,
  "ideographiccallparen",
  0x323a,
  "ideographiccentrecircle",
  0x32a5,
  "ideographicclose",
  0x3006,
  "ideographiccomma",
  0x3001,
  "ideographiccommaleft",
  0xff64,
  "ideographiccongratulationparen",
  0x3237,
  "ideographiccorrectcircle",
  0x32a3,
  "ideographicearthparen",
  0x322f,
  "ideographicenterpriseparen",
  0x323d,
  "ideographicexcellentcircle",
  0x329d,
  "ideographicfestivalparen",
  0x3240,
  "ideographicfinancialcircle",
  0x3296,
  "ideographicfinancialparen",
  0x3236,
  "ideographicfireparen",
  0x322b,
  "ideographichaveparen",
  0x3232,
  "ideographichighcircle",
  0x32a4,
  "ideographiciterationmark",
  0x3005,
  "ideographiclaborcircle",
  0x3298,
  "ideographiclaborparen",
  0x3238,
  "ideographicleftcircle",
  0x32a7,
  "ideographiclowcircle",
  0x32a6,
  "ideographicmedicinecircle",
  0x32a9,
  "ideographicmetalparen",
  0x322e,
  "ideographicmoonparen",
  0x322a,
  "ideographicnameparen",
  0x3234,
  "ideographicperiod",
  0x3002,
  "ideographicprintcircle",
  0x329e,
  "ideographicreachparen",
  0x3243,
  "ideographicrepresentparen",
  0x3239,
  "ideographicresourceparen",
  0x323e,
  "ideographicrightcircle",
  0x32a8,
  "ideographicsecretcircle",
  0x3299,
  "ideographicselfparen",
  0x3242,
  "ideographicsocietyparen",
  0x3233,
  "ideographicspace",
  0x3000,
  "ideographicspecialparen",
  0x3235,
  "ideographicstockparen",
  0x3231,
  "ideographicstudyparen",
  0x323b,
  "ideographicsunparen",
  0x3230,
  "ideographicsuperviseparen",
  0x323c,
  "ideographicwaterparen",
  0x322c,
  "ideographicwoodparen",
  0x322d,
  "ideographiczero",
  0x3007,
  "ideographmetalcircle",
  0x328e,
  "ideographmooncircle",
  0x328a,
  "ideographnamecircle",
  0x3294,
  "ideographsuncircle",
  0x3290,
  "ideographwatercircle",
  0x328c,
  "ideographwoodcircle",
  0x328d,
  "ideva",
  0x0907,
  "idieresis",
  0x00ef,
  "idieresisacute",
  0x1e2f,
  "idieresiscyrillic",
  0x04e5,
  "idotbelow",
  0x1ecb,
  "iebrevecyrillic",
  0x04d7,
  "iecyrillic",
  0x0435,
  "ieungacirclekorean",
  0x3275,
  "ieungaparenkorean",
  0x3215,
  "ieungcirclekorean",
  0x3267,
  "ieungkorean",
  0x3147,
  "ieungparenkorean",
  0x3207,
  "igrave",
  0x00ec,
  "igujarati",
  0x0a87,
  "igurmukhi",
  0x0a07,
  "ihiragana",
  0x3044,
  "ihookabove",
  0x1ec9,
  "iibengali",
  0x0988,
  "iicyrillic",
  0x0438,
  "iideva",
  0x0908,
  "iigujarati",
  0x0a88,
  "iigurmukhi",
  0x0a08,
  "iimatragurmukhi",
  0x0a40,
  "iinvertedbreve",
  0x020b,
  "iishortcyrillic",
  0x0439,
  "iivowelsignbengali",
  0x09c0,
  "iivowelsigndeva",
  0x0940,
  "iivowelsigngujarati",
  0x0ac0,
  "ij",
  0x0133,
  "ikatakana",
  0x30a4,
  "ikatakanahalfwidth",
  0xff72,
  "ikorean",
  0x3163,
  "ilde",
  0x02dc,
  "iluyhebrew",
  0x05ac,
  "imacron",
  0x012b,
  "imacroncyrillic",
  0x04e3,
  "imageorapproximatelyequal",
  0x2253,
  "imatragurmukhi",
  0x0a3f,
  "imonospace",
  0xff49,
  "increment",
  0x2206,
  "infinity",
  0x221e,
  "iniarmenian",
  0x056b,
  "integral",
  0x222b,
  "integralbottom",
  0x2321,
  "integralbt",
  0x2321,
  "integralex",
  0xf8f5,
  "integraltop",
  0x2320,
  "integraltp",
  0x2320,
  "intersection",
  0x2229,
  "intisquare",
  0x3305,
  "invbullet",
  0x25d8,
  "invcircle",
  0x25d9,
  "invsmileface",
  0x263b,
  "iocyrillic",
  0x0451,
  "iogonek",
  0x012f,
  "iota",
  0x03b9,
  "iotadieresis",
  0x03ca,
  "iotadieresistonos",
  0x0390,
  "iotalatin",
  0x0269,
  "iotatonos",
  0x03af,
  "iparen",
  0x24a4,
  "irigurmukhi",
  0x0a72,
  "ismallhiragana",
  0x3043,
  "ismallkatakana",
  0x30a3,
  "ismallkatakanahalfwidth",
  0xff68,
  "issharbengali",
  0x09fa,
  "istroke",
  0x0268,
  "isuperior",
  0xf6ed,
  "iterationhiragana",
  0x309d,
  "iterationkatakana",
  0x30fd,
  "itilde",
  0x0129,
  "itildebelow",
  0x1e2d,
  "iubopomofo",
  0x3129,
  "iucyrillic",
  0x044e,
  "ivowelsignbengali",
  0x09bf,
  "ivowelsigndeva",
  0x093f,
  "ivowelsigngujarati",
  0x0abf,
  "izhitsacyrillic",
  0x0475,
  "izhitsadblgravecyrillic",
  0x0477,
  "j",
  0x006a,
  "jaarmenian",
  0x0571,
  "jabengali",
  0x099c,
  "jadeva",
  0x091c,
  "jagujarati",
  0x0a9c,
  "jagurmukhi",
  0x0a1c,
  "jbopomofo",
  0x3110,
  "jcaron",
  0x01f0,
  "jcircle",
  0x24d9,
  "jcircumflex",
  0x0135,
  "jcrossedtail",
  0x029d,
  "jdotlessstroke",
  0x025f,
  "jecyrillic",
  0x0458,
  "jeemarabic",
  0x062c,
  "jeemfinalarabic",
  0xfe9e,
  "jeeminitialarabic",
  0xfe9f,
  "jeemmedialarabic",
  0xfea0,
  "jeharabic",
  0x0698,
  "jehfinalarabic",
  0xfb8b,
  "jhabengali",
  0x099d,
  "jhadeva",
  0x091d,
  "jhagujarati",
  0x0a9d,
  "jhagurmukhi",
  0x0a1d,
  "jheharmenian",
  0x057b,
  "jis",
  0x3004,
  "jmonospace",
  0xff4a,
  "jparen",
  0x24a5,
  "jsuperior",
  0x02b2,
  "k",
  0x006b,
  "kabashkircyrillic",
  0x04a1,
  "kabengali",
  0x0995,
  "kacute",
  0x1e31,
  "kacyrillic",
  0x043a,
  "kadescendercyrillic",
  0x049b,
  "kadeva",
  0x0915,
  "kaf",
  0x05db,
  "kafarabic",
  0x0643,
  "kafdagesh",
  0xfb3b,
  "kafdageshhebrew",
  0xfb3b,
  "kaffinalarabic",
  0xfeda,
  "kafhebrew",
  0x05db,
  "kafinitialarabic",
  0xfedb,
  "kafmedialarabic",
  0xfedc,
  "kafrafehebrew",
  0xfb4d,
  "kagujarati",
  0x0a95,
  "kagurmukhi",
  0x0a15,
  "kahiragana",
  0x304b,
  "kahookcyrillic",
  0x04c4,
  "kakatakana",
  0x30ab,
  "kakatakanahalfwidth",
  0xff76,
  "kappa",
  0x03ba,
  "kappasymbolgreek",
  0x03f0,
  "kapyeounmieumkorean",
  0x3171,
  "kapyeounphieuphkorean",
  0x3184,
  "kapyeounpieupkorean",
  0x3178,
  "kapyeounssangpieupkorean",
  0x3179,
  "karoriisquare",
  0x330d,
  "kashidaautoarabic",
  0x0640,
  "kashidaautonosidebearingarabic",
  0x0640,
  "kasmallkatakana",
  0x30f5,
  "kasquare",
  0x3384,
  "kasraarabic",
  0x0650,
  "kasratanarabic",
  0x064d,
  "kastrokecyrillic",
  0x049f,
  "katahiraprolongmarkhalfwidth",
  0xff70,
  "kaverticalstrokecyrillic",
  0x049d,
  "kbopomofo",
  0x310e,
  "kcalsquare",
  0x3389,
  "kcaron",
  0x01e9,
  "kcedilla",
  0x0137,
  "kcircle",
  0x24da,
  "kcommaaccent",
  0x0137,
  "kdotbelow",
  0x1e33,
  "keharmenian",
  0x0584,
  "kehiragana",
  0x3051,
  "kekatakana",
  0x30b1,
  "kekatakanahalfwidth",
  0xff79,
  "kenarmenian",
  0x056f,
  "kesmallkatakana",
  0x30f6,
  "kgreenlandic",
  0x0138,
  "khabengali",
  0x0996,
  "khacyrillic",
  0x0445,
  "khadeva",
  0x0916,
  "khagujarati",
  0x0a96,
  "khagurmukhi",
  0x0a16,
  "khaharabic",
  0x062e,
  "khahfinalarabic",
  0xfea6,
  "khahinitialarabic",
  0xfea7,
  "khahmedialarabic",
  0xfea8,
  "kheicoptic",
  0x03e7,
  "khhadeva",
  0x0959,
  "khhagurmukhi",
  0x0a59,
  "khieukhacirclekorean",
  0x3278,
  "khieukhaparenkorean",
  0x3218,
  "khieukhcirclekorean",
  0x326a,
  "khieukhkorean",
  0x314b,
  "khieukhparenkorean",
  0x320a,
  "khokhaithai",
  0x0e02,
  "khokhonthai",
  0x0e05,
  "khokhuatthai",
  0x0e03,
  "khokhwaithai",
  0x0e04,
  "khomutthai",
  0x0e5b,
  "khook",
  0x0199,
  "khorakhangthai",
  0x0e06,
  "khzsquare",
  0x3391,
  "kihiragana",
  0x304d,
  "kikatakana",
  0x30ad,
  "kikatakanahalfwidth",
  0xff77,
  "kiroguramusquare",
  0x3315,
  "kiromeetorusquare",
  0x3316,
  "kirosquare",
  0x3314,
  "kiyeokacirclekorean",
  0x326e,
  "kiyeokaparenkorean",
  0x320e,
  "kiyeokcirclekorean",
  0x3260,
  "kiyeokkorean",
  0x3131,
  "kiyeokparenkorean",
  0x3200,
  "kiyeoksioskorean",
  0x3133,
  "kjecyrillic",
  0x045c,
  "klinebelow",
  0x1e35,
  "klsquare",
  0x3398,
  "kmcubedsquare",
  0x33a6,
  "kmonospace",
  0xff4b,
  "kmsquaredsquare",
  0x33a2,
  "kohiragana",
  0x3053,
  "kohmsquare",
  0x33c0,
  "kokaithai",
  0x0e01,
  "kokatakana",
  0x30b3,
  "kokatakanahalfwidth",
  0xff7a,
  "kooposquare",
  0x331e,
  "koppacyrillic",
  0x0481,
  "koreanstandardsymbol",
  0x327f,
  "koroniscmb",
  0x0343,
  "kparen",
  0x24a6,
  "kpasquare",
  0x33aa,
  "ksicyrillic",
  0x046f,
  "ktsquare",
  0x33cf,
  "kturned",
  0x029e,
  "kuhiragana",
  0x304f,
  "kukatakana",
  0x30af,
  "kukatakanahalfwidth",
  0xff78,
  "kvsquare",
  0x33b8,
  "kwsquare",
  0x33be,
  "l",
  0x006c,
  "labengali",
  0x09b2,
  "lacute",
  0x013a,
  "ladeva",
  0x0932,
  "lagujarati",
  0x0ab2,
  "lagurmukhi",
  0x0a32,
  "lakkhangyaothai",
  0x0e45,
  "lamaleffinalarabic",
  0xfefc,
  "lamalefhamzaabovefinalarabic",
  0xfef8,
  "lamalefhamzaaboveisolatedarabic",
  0xfef7,
  "lamalefhamzabelowfinalarabic",
  0xfefa,
  "lamalefhamzabelowisolatedarabic",
  0xfef9,
  "lamalefisolatedarabic",
  0xfefb,
  "lamalefmaddaabovefinalarabic",
  0xfef6,
  "lamalefmaddaaboveisolatedarabic",
  0xfef5,
  "lamarabic",
  0x0644,
  "lambda",
  0x03bb,
  "lambdastroke",
  0x019b,
  "lamed",
  0x05dc,
  "lameddagesh",
  0xfb3c,
  "lameddageshhebrew",
  0xfb3c,
  "lamedhebrew",
  0x05dc,
  "lamfinalarabic",
  0xfede,
  "lamhahinitialarabic",
  0xfcca,
  "laminitialarabic",
  0xfedf,
  "lamjeeminitialarabic",
  0xfcc9,
  "lamkhahinitialarabic",
  0xfccb,
  "lamlamhehisolatedarabic",
  0xfdf2,
  "lammedialarabic",
  0xfee0,
  "lammeemhahinitialarabic",
  0xfd88,
  "lammeeminitialarabic",
  0xfccc,
  "largecircle",
  0x25ef,
  "lbar",
  0x019a,
  "lbelt",
  0x026c,
  "lbopomofo",
  0x310c,
  "lcaron",
  0x013e,
  "lcedilla",
  0x013c,
  "lcircle",
  0x24db,
  "lcircumflexbelow",
  0x1e3d,
  "lcommaaccent",
  0x013c,
  "ldot",
  0x0140,
  "ldotaccent",
  0x0140,
  "ldotbelow",
  0x1e37,
  "ldotbelowmacron",
  0x1e39,
  "leftangleabovecmb",
  0x031a,
  "lefttackbelowcmb",
  0x0318,
  "less",
  0x003c,
  "lessequal",
  0x2264,
  "lessequalorgreater",
  0x22da,
  "lessmonospace",
  0xff1c,
  "lessorequivalent",
  0x2272,
  "lessorgreater",
  0x2276,
  "lessoverequal",
  0x2266,
  "lesssmall",
  0xfe64,
  "lezh",
  0x026e,
  "lfblock",
  0x258c,
  "lhookretroflex",
  0x026d,
  "lira",
  0x20a4,
  "liwnarmenian",
  0x056c,
  "lj",
  0x01c9,
  "ljecyrillic",
  0x0459,
  "ll",
  0xf6c0,
  "lladeva",
  0x0933,
  "llagujarati",
  0x0ab3,
  "llinebelow",
  0x1e3b,
  "llladeva",
  0x0934,
  "llvocalicbengali",
  0x09e1,
  "llvocalicdeva",
  0x0961,
  "llvocalicvowelsignbengali",
  0x09e3,
  "llvocalicvowelsigndeva",
  0x0963,
  "lmiddletilde",
  0x026b,
  "lmonospace",
  0xff4c,
  "lmsquare",
  0x33d0,
  "lochulathai",
  0x0e2c,
  "logicaland",
  0x2227,
  "logicalnot",
  0x00ac,
  "logicalnotreversed",
  0x2310,
  "logicalor",
  0x2228,
  "lolingthai",
  0x0e25,
  "longs",
  0x017f,
  "lowlinecenterline",
  0xfe4e,
  "lowlinecmb",
  0x0332,
  "lowlinedashed",
  0xfe4d,
  "lozenge",
  0x25ca,
  "lparen",
  0x24a7,
  "lslash",
  0x0142,
  "lsquare",
  0x2113,
  "lsuperior",
  0xf6ee,
  "ltshade",
  0x2591,
  "luthai",
  0x0e26,
  "lvocalicbengali",
  0x098c,
  "lvocalicdeva",
  0x090c,
  "lvocalicvowelsignbengali",
  0x09e2,
  "lvocalicvowelsigndeva",
  0x0962,
  "lxsquare",
  0x33d3,
  "m",
  0x006d,
  "mabengali",
  0x09ae,
  "macron",
  0x00af,
  "macronbelowcmb",
  0x0331,
  "macroncmb",
  0x0304,
  "macronlowmod",
  0x02cd,
  "macronmonospace",
  0xffe3,
  "macute",
  0x1e3f,
  "madeva",
  0x092e,
  "magujarati",
  0x0aae,
  "magurmukhi",
  0x0a2e,
  "mahapakhhebrew",
  0x05a4,
  "mahapakhlefthebrew",
  0x05a4,
  "mahiragana",
  0x307e,
  "maichattawalowleftthai",
  0xf895,
  "maichattawalowrightthai",
  0xf894,
  "maichattawathai",
  0x0e4b,
  "maichattawaupperleftthai",
  0xf893,
  "maieklowleftthai",
  0xf88c,
  "maieklowrightthai",
  0xf88b,
  "maiekthai",
  0x0e48,
  "maiekupperleftthai",
  0xf88a,
  "maihanakatleftthai",
  0xf884,
  "maihanakatthai",
  0x0e31,
  "maitaikhuleftthai",
  0xf889,
  "maitaikhuthai",
  0x0e47,
  "maitholowleftthai",
  0xf88f,
  "maitholowrightthai",
  0xf88e,
  "maithothai",
  0x0e49,
  "maithoupperleftthai",
  0xf88d,
  "maitrilowleftthai",
  0xf892,
  "maitrilowrightthai",
  0xf891,
  "maitrithai",
  0x0e4a,
  "maitriupperleftthai",
  0xf890,
  "maiyamokthai",
  0x0e46,
  "makatakana",
  0x30de,
  "makatakanahalfwidth",
  0xff8f,
  "male",
  0x2642,
  "mansyonsquare",
  0x3347,
  "maqafhebrew",
  0x05be,
  "mars",
  0x2642,
  "masoracirclehebrew",
  0x05af,
  "masquare",
  0x3383,
  "mbopomofo",
  0x3107,
  "mbsquare",
  0x33d4,
  "mcircle",
  0x24dc,
  "mcubedsquare",
  0x33a5,
  "mdotaccent",
  0x1e41,
  "mdotbelow",
  0x1e43,
  "meemarabic",
  0x0645,
  "meemfinalarabic",
  0xfee2,
  "meeminitialarabic",
  0xfee3,
  "meemmedialarabic",
  0xfee4,
  "meemmeeminitialarabic",
  0xfcd1,
  "meemmeemisolatedarabic",
  0xfc48,
  "meetorusquare",
  0x334d,
  "mehiragana",
  0x3081,
  "meizierasquare",
  0x337e,
  "mekatakana",
  0x30e1,
  "mekatakanahalfwidth",
  0xff92,
  "mem",
  0x05de,
  "memdagesh",
  0xfb3e,
  "memdageshhebrew",
  0xfb3e,
  "memhebrew",
  0x05de,
  "menarmenian",
  0x0574,
  "merkhahebrew",
  0x05a5,
  "merkhakefulahebrew",
  0x05a6,
  "merkhakefulalefthebrew",
  0x05a6,
  "merkhalefthebrew",
  0x05a5,
  "mhook",
  0x0271,
  "mhzsquare",
  0x3392,
  "middledotkatakanahalfwidth",
  0xff65,
  "middot",
  0x00b7,
  "mieumacirclekorean",
  0x3272,
  "mieumaparenkorean",
  0x3212,
  "mieumcirclekorean",
  0x3264,
  "mieumkorean",
  0x3141,
  "mieumpansioskorean",
  0x3170,
  "mieumparenkorean",
  0x3204,
  "mieumpieupkorean",
  0x316e,
  "mieumsioskorean",
  0x316f,
  "mihiragana",
  0x307f,
  "mikatakana",
  0x30df,
  "mikatakanahalfwidth",
  0xff90,
  "minus",
  0x2212,
  "minusbelowcmb",
  0x0320,
  "minuscircle",
  0x2296,
  "minusmod",
  0x02d7,
  "minusplus",
  0x2213,
  "minute",
  0x2032,
  "miribaarusquare",
  0x334a,
  "mirisquare",
  0x3349,
  "mlonglegturned",
  0x0270,
  "mlsquare",
  0x3396,
  "mmcubedsquare",
  0x33a3,
  "mmonospace",
  0xff4d,
  "mmsquaredsquare",
  0x339f,
  "mohiragana",
  0x3082,
  "mohmsquare",
  0x33c1,
  "mokatakana",
  0x30e2,
  "mokatakanahalfwidth",
  0xff93,
  "molsquare",
  0x33d6,
  "momathai",
  0x0e21,
  "moverssquare",
  0x33a7,
  "moverssquaredsquare",
  0x33a8,
  "mparen",
  0x24a8,
  "mpasquare",
  0x33ab,
  "mssquare",
  0x33b3,
  "msuperior",
  0xf6ef,
  "mturned",
  0x026f,
  "mu",
  0x00b5,
  "mu1",
  0x00b5,
  "muasquare",
  0x3382,
  "muchgreater",
  0x226b,
  "muchless",
  0x226a,
  "mufsquare",
  0x338c,
  "mugreek",
  0x03bc,
  "mugsquare",
  0x338d,
  "muhiragana",
  0x3080,
  "mukatakana",
  0x30e0,
  "mukatakanahalfwidth",
  0xff91,
  "mulsquare",
  0x3395,
  "multiply",
  0x00d7,
  "mumsquare",
  0x339b,
  "munahhebrew",
  0x05a3,
  "munahlefthebrew",
  0x05a3,
  "musicalnote",
  0x266a,
  "musicalnotedbl",
  0x266b,
  "musicflatsign",
  0x266d,
  "musicsharpsign",
  0x266f,
  "mussquare",
  0x33b2,
  "muvsquare",
  0x33b6,
  "muwsquare",
  0x33bc,
  "mvmegasquare",
  0x33b9,
  "mvsquare",
  0x33b7,
  "mwmegasquare",
  0x33bf,
  "mwsquare",
  0x33bd,
  "n",
  0x006e,
  "nabengali",
  0x09a8,
  "nabla",
  0x2207,
  "nacute",
  0x0144,
  "nadeva",
  0x0928,
  "nagujarati",
  0x0aa8,
  "nagurmukhi",
  0x0a28,
  "nahiragana",
  0x306a,
  "nakatakana",
  0x30ca,
  "nakatakanahalfwidth",
  0xff85,
  "napostrophe",
  0x0149,
  "nasquare",
  0x3381,
  "nbopomofo",
  0x310b,
  "nbspace",
  0x00a0,
  "ncaron",
  0x0148,
  "ncedilla",
  0x0146,
  "ncircle",
  0x24dd,
  "ncircumflexbelow",
  0x1e4b,
  "ncommaaccent",
  0x0146,
  "ndotaccent",
  0x1e45,
  "ndotbelow",
  0x1e47,
  "nehiragana",
  0x306d,
  "nekatakana",
  0x30cd,
  "nekatakanahalfwidth",
  0xff88,
  "newsheqelsign",
  0x20aa,
  "nfsquare",
  0x338b,
  "ngabengali",
  0x0999,
  "ngadeva",
  0x0919,
  "ngagujarati",
  0x0a99,
  "ngagurmukhi",
  0x0a19,
  "ngonguthai",
  0x0e07,
  "nhiragana",
  0x3093,
  "nhookleft",
  0x0272,
  "nhookretroflex",
  0x0273,
  "nieunacirclekorean",
  0x326f,
  "nieunaparenkorean",
  0x320f,
  "nieuncieuckorean",
  0x3135,
  "nieuncirclekorean",
  0x3261,
  "nieunhieuhkorean",
  0x3136,
  "nieunkorean",
  0x3134,
  "nieunpansioskorean",
  0x3168,
  "nieunparenkorean",
  0x3201,
  "nieunsioskorean",
  0x3167,
  "nieuntikeutkorean",
  0x3166,
  "nihiragana",
  0x306b,
  "nikatakana",
  0x30cb,
  "nikatakanahalfwidth",
  0xff86,
  "nikhahitleftthai",
  0xf899,
  "nikhahitthai",
  0x0e4d,
  "nine",
  0x0039,
  "ninearabic",
  0x0669,
  "ninebengali",
  0x09ef,
  "ninecircle",
  0x2468,
  "ninecircleinversesansserif",
  0x2792,
  "ninedeva",
  0x096f,
  "ninegujarati",
  0x0aef,
  "ninegurmukhi",
  0x0a6f,
  "ninehackarabic",
  0x0669,
  "ninehangzhou",
  0x3029,
  "nineideographicparen",
  0x3228,
  "nineinferior",
  0x2089,
  "ninemonospace",
  0xff19,
  "nineoldstyle",
  0xf739,
  "nineparen",
  0x247c,
  "nineperiod",
  0x2490,
  "ninepersian",
  0x06f9,
  "nineroman",
  0x2178,
  "ninesuperior",
  0x2079,
  "nineteencircle",
  0x2472,
  "nineteenparen",
  0x2486,
  "nineteenperiod",
  0x249a,
  "ninethai",
  0x0e59,
  "nj",
  0x01cc,
  "njecyrillic",
  0x045a,
  "nkatakana",
  0x30f3,
  "nkatakanahalfwidth",
  0xff9d,
  "nlegrightlong",
  0x019e,
  "nlinebelow",
  0x1e49,
  "nmonospace",
  0xff4e,
  "nmsquare",
  0x339a,
  "nnabengali",
  0x09a3,
  "nnadeva",
  0x0923,
  "nnagujarati",
  0x0aa3,
  "nnagurmukhi",
  0x0a23,
  "nnnadeva",
  0x0929,
  "nohiragana",
  0x306e,
  "nokatakana",
  0x30ce,
  "nokatakanahalfwidth",
  0xff89,
  "nonbreakingspace",
  0x00a0,
  "nonenthai",
  0x0e13,
  "nonuthai",
  0x0e19,
  "noonarabic",
  0x0646,
  "noonfinalarabic",
  0xfee6,
  "noonghunnaarabic",
  0x06ba,
  "noonghunnafinalarabic",
  0xfb9f,
  "nooninitialarabic",
  0xfee7,
  "noonjeeminitialarabic",
  0xfcd2,
  "noonjeemisolatedarabic",
  0xfc4b,
  "noonmedialarabic",
  0xfee8,
  "noonmeeminitialarabic",
  0xfcd5,
  "noonmeemisolatedarabic",
  0xfc4e,
  "noonnoonfinalarabic",
  0xfc8d,
  "notcontains",
  0x220c,
  "notelement",
  0x2209,
  "notelementof",
  0x2209,
  "notequal",
  0x2260,
  "notgreater",
  0x226f,
  "notgreaternorequal",
  0x2271,
  "notgreaternorless",
  0x2279,
  "notidentical",
  0x2262,
  "notless",
  0x226e,
  "notlessnorequal",
  0x2270,
  "notparallel",
  0x2226,
  "notprecedes",
  0x2280,
  "notsubset",
  0x2284,
  "notsucceeds",
  0x2281,
  "notsuperset",
  0x2285,
  "nowarmenian",
  0x0576,
  "nparen",
  0x24a9,
  "nssquare",
  0x33b1,
  "nsuperior",
  0x207f,
  "ntilde",
  0x00f1,
  "nu",
  0x03bd,
  "nuhiragana",
  0x306c,
  "nukatakana",
  0x30cc,
  "nukatakanahalfwidth",
  0xff87,
  "nuktabengali",
  0x09bc,
  "nuktadeva",
  0x093c,
  "nuktagujarati",
  0x0abc,
  "nuktagurmukhi",
  0x0a3c,
  "numbersign",
  0x0023,
  "numbersignmonospace",
  0xff03,
  "numbersignsmall",
  0xfe5f,
  "numeralsigngreek",
  0x0374,
  "numeralsignlowergreek",
  0x0375,
  "numero",
  0x2116,
  "nun",
  0x05e0,
  "nundagesh",
  0xfb40,
  "nundageshhebrew",
  0xfb40,
  "nunhebrew",
  0x05e0,
  "nvsquare",
  0x33b5,
  "nwsquare",
  0x33bb,
  "nyabengali",
  0x099e,
  "nyadeva",
  0x091e,
  "nyagujarati",
  0x0a9e,
  "nyagurmukhi",
  0x0a1e,
  "o",
  0x006f,
  "oacute",
  0x00f3,
  "oangthai",
  0x0e2d,
  "obarred",
  0x0275,
  "obarredcyrillic",
  0x04e9,
  "obarreddieresiscyrillic",
  0x04eb,
  "obengali",
  0x0993,
  "obopomofo",
  0x311b,
  "obreve",
  0x014f,
  "ocandradeva",
  0x0911,
  "ocandragujarati",
  0x0a91,
  "ocandravowelsigndeva",
  0x0949,
  "ocandravowelsigngujarati",
  0x0ac9,
  "ocaron",
  0x01d2,
  "ocircle",
  0x24de,
  "ocircumflex",
  0x00f4,
  "ocircumflexacute",
  0x1ed1,
  "ocircumflexdotbelow",
  0x1ed9,
  "ocircumflexgrave",
  0x1ed3,
  "ocircumflexhookabove",
  0x1ed5,
  "ocircumflextilde",
  0x1ed7,
  "ocyrillic",
  0x043e,
  "odblacute",
  0x0151,
  "odblgrave",
  0x020d,
  "odeva",
  0x0913,
  "odieresis",
  0x00f6,
  "odieresiscyrillic",
  0x04e7,
  "odotbelow",
  0x1ecd,
  "oe",
  0x0153,
  "oekorean",
  0x315a,
  "ogonek",
  0x02db,
  "ogonekcmb",
  0x0328,
  "ograve",
  0x00f2,
  "ogujarati",
  0x0a93,
  "oharmenian",
  0x0585,
  "ohiragana",
  0x304a,
  "ohookabove",
  0x1ecf,
  "ohorn",
  0x01a1,
  "ohornacute",
  0x1edb,
  "ohorndotbelow",
  0x1ee3,
  "ohorngrave",
  0x1edd,
  "ohornhookabove",
  0x1edf,
  "ohorntilde",
  0x1ee1,
  "ohungarumlaut",
  0x0151,
  "oi",
  0x01a3,
  "oinvertedbreve",
  0x020f,
  "okatakana",
  0x30aa,
  "okatakanahalfwidth",
  0xff75,
  "okorean",
  0x3157,
  "olehebrew",
  0x05ab,
  "omacron",
  0x014d,
  "omacronacute",
  0x1e53,
  "omacrongrave",
  0x1e51,
  "omdeva",
  0x0950,
  "omega",
  0x03c9,
  "omega1",
  0x03d6,
  "omegacyrillic",
  0x0461,
  "omegalatinclosed",
  0x0277,
  "omegaroundcyrillic",
  0x047b,
  "omegatitlocyrillic",
  0x047d,
  "omegatonos",
  0x03ce,
  "omgujarati",
  0x0ad0,
  "omicron",
  0x03bf,
  "omicrontonos",
  0x03cc,
  "omonospace",
  0xff4f,
  "one",
  0x0031,
  "onearabic",
  0x0661,
  "onebengali",
  0x09e7,
  "onecircle",
  0x2460,
  "onecircleinversesansserif",
  0x278a,
  "onedeva",
  0x0967,
  "onedotenleader",
  0x2024,
  "oneeighth",
  0x215b,
  "onefitted",
  0xf6dc,
  "onegujarati",
  0x0ae7,
  "onegurmukhi",
  0x0a67,
  "onehackarabic",
  0x0661,
  "onehalf",
  0x00bd,
  "onehangzhou",
  0x3021,
  "oneideographicparen",
  0x3220,
  "oneinferior",
  0x2081,
  "onemonospace",
  0xff11,
  "onenumeratorbengali",
  0x09f4,
  "oneoldstyle",
  0xf731,
  "oneparen",
  0x2474,
  "oneperiod",
  0x2488,
  "onepersian",
  0x06f1,
  "onequarter",
  0x00bc,
  "oneroman",
  0x2170,
  "onesuperior",
  0x00b9,
  "onethai",
  0x0e51,
  "onethird",
  0x2153,
  "oogonek",
  0x01eb,
  "oogonekmacron",
  0x01ed,
  "oogurmukhi",
  0x0a13,
  "oomatragurmukhi",
  0x0a4b,
  "oopen",
  0x0254,
  "oparen",
  0x24aa,
  "openbullet",
  0x25e6,
  "option",
  0x2325,
  "ordfeminine",
  0x00aa,
  "ordmasculine",
  0x00ba,
  "orthogonal",
  0x221f,
  "oshortdeva",
  0x0912,
  "oshortvowelsigndeva",
  0x094a,
  "oslash",
  0x00f8,
  "oslashacute",
  0x01ff,
  "osmallhiragana",
  0x3049,
  "osmallkatakana",
  0x30a9,
  "osmallkatakanahalfwidth",
  0xff6b,
  "ostrokeacute",
  0x01ff,
  "osuperior",
  0xf6f0,
  "otcyrillic",
  0x047f,
  "otilde",
  0x00f5,
  "otildeacute",
  0x1e4d,
  "otildedieresis",
  0x1e4f,
  "oubopomofo",
  0x3121,
  "overline",
  0x203e,
  "overlinecenterline",
  0xfe4a,
  "overlinecmb",
  0x0305,
  "overlinedashed",
  0xfe49,
  "overlinedblwavy",
  0xfe4c,
  "overlinewavy",
  0xfe4b,
  "overscore",
  0x00af,
  "ovowelsignbengali",
  0x09cb,
  "ovowelsigndeva",
  0x094b,
  "ovowelsigngujarati",
  0x0acb,
  "p",
  0x0070,
  "paampssquare",
  0x3380,
  "paasentosquare",
  0x332b,
  "pabengali",
  0x09aa,
  "pacute",
  0x1e55,
  "padeva",
  0x092a,
  "pagedown",
  0x21df,
  "pageup",
  0x21de,
  "pagujarati",
  0x0aaa,
  "pagurmukhi",
  0x0a2a,
  "pahiragana",
  0x3071,
  "paiyannoithai",
  0x0e2f,
  "pakatakana",
  0x30d1,
  "palatalizationcyrilliccmb",
  0x0484,
  "palochkacyrillic",
  0x04c0,
  "pansioskorean",
  0x317f,
  "paragraph",
  0x00b6,
  "parallel",
  0x2225,
  "parenleft",
  0x0028,
  "parenleftaltonearabic",
  0xfd3e,
  "parenleftbt",
  0xf8ed,
  "parenleftex",
  0xf8ec,
  "parenleftinferior",
  0x208d,
  "parenleftmonospace",
  0xff08,
  "parenleftsmall",
  0xfe59,
  "parenleftsuperior",
  0x207d,
  "parenlefttp",
  0xf8eb,
  "parenleftvertical",
  0xfe35,
  "parenright",
  0x0029,
  "parenrightaltonearabic",
  0xfd3f,
  "parenrightbt",
  0xf8f8,
  "parenrightex",
  0xf8f7,
  "parenrightinferior",
  0x208e,
  "parenrightmonospace",
  0xff09,
  "parenrightsmall",
  0xfe5a,
  "parenrightsuperior",
  0x207e,
  "parenrighttp",
  0xf8f6,
  "parenrightvertical",
  0xfe36,
  "partialdiff",
  0x2202,
  "paseqhebrew",
  0x05c0,
  "pashtahebrew",
  0x0599,
  "pasquare",
  0x33a9,
  "patah",
  0x05b7,
  "patah11",
  0x05b7,
  "patah1d",
  0x05b7,
  "patah2a",
  0x05b7,
  "patahhebrew",
  0x05b7,
  "patahnarrowhebrew",
  0x05b7,
  "patahquarterhebrew",
  0x05b7,
  "patahwidehebrew",
  0x05b7,
  "pazerhebrew",
  0x05a1,
  "pbopomofo",
  0x3106,
  "pcircle",
  0x24df,
  "pdotaccent",
  0x1e57,
  "pe",
  0x05e4,
  "pecyrillic",
  0x043f,
  "pedagesh",
  0xfb44,
  "pedageshhebrew",
  0xfb44,
  "peezisquare",
  0x333b,
  "pefinaldageshhebrew",
  0xfb43,
  "peharabic",
  0x067e,
  "peharmenian",
  0x057a,
  "pehebrew",
  0x05e4,
  "pehfinalarabic",
  0xfb57,
  "pehinitialarabic",
  0xfb58,
  "pehiragana",
  0x307a,
  "pehmedialarabic",
  0xfb59,
  "pekatakana",
  0x30da,
  "pemiddlehookcyrillic",
  0x04a7,
  "perafehebrew",
  0xfb4e,
  "percent",
  0x0025,
  "percentarabic",
  0x066a,
  "percentmonospace",
  0xff05,
  "percentsmall",
  0xfe6a,
  "period",
  0x002e,
  "periodarmenian",
  0x0589,
  "periodcentered",
  0x00b7,
  "periodhalfwidth",
  0xff61,
  "periodinferior",
  0xf6e7,
  "periodmonospace",
  0xff0e,
  "periodsmall",
  0xfe52,
  "periodsuperior",
  0xf6e8,
  "perispomenigreekcmb",
  0x0342,
  "perpendicular",
  0x22a5,
  "perthousand",
  0x2030,
  "peseta",
  0x20a7,
  "pfsquare",
  0x338a,
  "phabengali",
  0x09ab,
  "phadeva",
  0x092b,
  "phagujarati",
  0x0aab,
  "phagurmukhi",
  0x0a2b,
  "phi",
  0x03c6,
  "phi1",
  0x03d5,
  "phieuphacirclekorean",
  0x327a,
  "phieuphaparenkorean",
  0x321a,
  "phieuphcirclekorean",
  0x326c,
  "phieuphkorean",
  0x314d,
  "phieuphparenkorean",
  0x320c,
  "philatin",
  0x0278,
  "phinthuthai",
  0x0e3a,
  "phisymbolgreek",
  0x03d5,
  "phook",
  0x01a5,
  "phophanthai",
  0x0e1e,
  "phophungthai",
  0x0e1c,
  "phosamphaothai",
  0x0e20,
  "pi",
  0x03c0,
  "pieupacirclekorean",
  0x3273,
  "pieupaparenkorean",
  0x3213,
  "pieupcieuckorean",
  0x3176,
  "pieupcirclekorean",
  0x3265,
  "pieupkiyeokkorean",
  0x3172,
  "pieupkorean",
  0x3142,
  "pieupparenkorean",
  0x3205,
  "pieupsioskiyeokkorean",
  0x3174,
  "pieupsioskorean",
  0x3144,
  "pieupsiostikeutkorean",
  0x3175,
  "pieupthieuthkorean",
  0x3177,
  "pieuptikeutkorean",
  0x3173,
  "pihiragana",
  0x3074,
  "pikatakana",
  0x30d4,
  "pisymbolgreek",
  0x03d6,
  "piwrarmenian",
  0x0583,
  "plus",
  0x002b,
  "plusbelowcmb",
  0x031f,
  "pluscircle",
  0x2295,
  "plusminus",
  0x00b1,
  "plusmod",
  0x02d6,
  "plusmonospace",
  0xff0b,
  "plussmall",
  0xfe62,
  "plussuperior",
  0x207a,
  "pmonospace",
  0xff50,
  "pmsquare",
  0x33d8,
  "pohiragana",
  0x307d,
  "pointingindexdownwhite",
  0x261f,
  "pointingindexleftwhite",
  0x261c,
  "pointingindexrightwhite",
  0x261e,
  "pointingindexupwhite",
  0x261d,
  "pokatakana",
  0x30dd,
  "poplathai",
  0x0e1b,
  "postalmark",
  0x3012,
  "postalmarkface",
  0x3020,
  "pparen",
  0x24ab,
  "precedes",
  0x227a,
  "prescription",
  0x211e,
  "primemod",
  0x02b9,
  "primereversed",
  0x2035,
  "product",
  0x220f,
  "projective",
  0x2305,
  "prolongedkana",
  0x30fc,
  "propellor",
  0x2318,
  "propersubset",
  0x2282,
  "propersuperset",
  0x2283,
  "proportion",
  0x2237,
  "proportional",
  0x221d,
  "psi",
  0x03c8,
  "psicyrillic",
  0x0471,
  "psilipneumatacyrilliccmb",
  0x0486,
  "pssquare",
  0x33b0,
  "puhiragana",
  0x3077,
  "pukatakana",
  0x30d7,
  "pvsquare",
  0x33b4,
  "pwsquare",
  0x33ba,
  "q",
  0x0071,
  "qadeva",
  0x0958,
  "qadmahebrew",
  0x05a8,
  "qafarabic",
  0x0642,
  "qaffinalarabic",
  0xfed6,
  "qafinitialarabic",
  0xfed7,
  "qafmedialarabic",
  0xfed8,
  "qamats",
  0x05b8,
  "qamats10",
  0x05b8,
  "qamats1a",
  0x05b8,
  "qamats1c",
  0x05b8,
  "qamats27",
  0x05b8,
  "qamats29",
  0x05b8,
  "qamats33",
  0x05b8,
  "qamatsde",
  0x05b8,
  "qamatshebrew",
  0x05b8,
  "qamatsnarrowhebrew",
  0x05b8,
  "qamatsqatanhebrew",
  0x05b8,
  "qamatsqatannarrowhebrew",
  0x05b8,
  "qamatsqatanquarterhebrew",
  0x05b8,
  "qamatsqatanwidehebrew",
  0x05b8,
  "qamatsquarterhebrew",
  0x05b8,
  "qamatswidehebrew",
  0x05b8,
  "qarneyparahebrew",
  0x059f,
  "qbopomofo",
  0x3111,
  "qcircle",
  0x24e0,
  "qhook",
  0x02a0,
  "qmonospace",
  0xff51,
  "qof",
  0x05e7,
  "qofdagesh",
  0xfb47,
  "qofdageshhebrew",
  0xfb47,
  "qofhebrew",
  0x05e7,
  "qparen",
  0x24ac,
  "quarternote",
  0x2669,
  "qubuts",
  0x05bb,
  "qubuts18",
  0x05bb,
  "qubuts25",
  0x05bb,
  "qubuts31",
  0x05bb,
  "qubutshebrew",
  0x05bb,
  "qubutsnarrowhebrew",
  0x05bb,
  "qubutsquarterhebrew",
  0x05bb,
  "qubutswidehebrew",
  0x05bb,
  "question",
  0x003f,
  "questionarabic",
  0x061f,
  "questionarmenian",
  0x055e,
  "questiondown",
  0x00bf,
  "questiondownsmall",
  0xf7bf,
  "questiongreek",
  0x037e,
  "questionmonospace",
  0xff1f,
  "questionsmall",
  0xf73f,
  "quotedbl",
  0x0022,
  "quotedblbase",
  0x201e,
  "quotedblleft",
  0x201c,
  "quotedblmonospace",
  0xff02,
  "quotedblprime",
  0x301e,
  "quotedblprimereversed",
  0x301d,
  "quotedblright",
  0x201d,
  "quoteleft",
  0x2018,
  "quoteleftreversed",
  0x201b,
  "quotereversed",
  0x201b,
  "quoteright",
  0x2019,
  "quoterightn",
  0x0149,
  "quotesinglbase",
  0x201a,
  "quotesingle",
  0x0027,
  "quotesinglemonospace",
  0xff07,
  "r",
  0x0072,
  "raarmenian",
  0x057c,
  "rabengali",
  0x09b0,
  "racute",
  0x0155,
  "radeva",
  0x0930,
  "radical",
  0x221a,
  "radicalex",
  0xf8e5,
  "radoverssquare",
  0x33ae,
  "radoverssquaredsquare",
  0x33af,
  "radsquare",
  0x33ad,
  "rafe",
  0x05bf,
  "rafehebrew",
  0x05bf,
  "ragujarati",
  0x0ab0,
  "ragurmukhi",
  0x0a30,
  "rahiragana",
  0x3089,
  "rakatakana",
  0x30e9,
  "rakatakanahalfwidth",
  0xff97,
  "ralowerdiagonalbengali",
  0x09f1,
  "ramiddlediagonalbengali",
  0x09f0,
  "ramshorn",
  0x0264,
  "ratio",
  0x2236,
  "rbopomofo",
  0x3116,
  "rcaron",
  0x0159,
  "rcedilla",
  0x0157,
  "rcircle",
  0x24e1,
  "rcommaaccent",
  0x0157,
  "rdblgrave",
  0x0211,
  "rdotaccent",
  0x1e59,
  "rdotbelow",
  0x1e5b,
  "rdotbelowmacron",
  0x1e5d,
  "referencemark",
  0x203b,
  "reflexsubset",
  0x2286,
  "reflexsuperset",
  0x2287,
  "registered",
  0x00ae,
  "registersans",
  0xf8e8,
  "registerserif",
  0xf6da,
  "reharabic",
  0x0631,
  "reharmenian",
  0x0580,
  "rehfinalarabic",
  0xfeae,
  "rehiragana",
  0x308c,
  "rekatakana",
  0x30ec,
  "rekatakanahalfwidth",
  0xff9a,
  "resh",
  0x05e8,
  "reshdageshhebrew",
  0xfb48,
  "reshhebrew",
  0x05e8,
  "reversedtilde",
  0x223d,
  "reviahebrew",
  0x0597,
  "reviamugrashhebrew",
  0x0597,
  "revlogicalnot",
  0x2310,
  "rfishhook",
  0x027e,
  "rfishhookreversed",
  0x027f,
  "rhabengali",
  0x09dd,
  "rhadeva",
  0x095d,
  "rho",
  0x03c1,
  "rhook",
  0x027d,
  "rhookturned",
  0x027b,
  "rhookturnedsuperior",
  0x02b5,
  "rhosymbolgreek",
  0x03f1,
  "rhotichookmod",
  0x02de,
  "rieulacirclekorean",
  0x3271,
  "rieulaparenkorean",
  0x3211,
  "rieulcirclekorean",
  0x3263,
  "rieulhieuhkorean",
  0x3140,
  "rieulkiyeokkorean",
  0x313a,
  "rieulkiyeoksioskorean",
  0x3169,
  "rieulkorean",
  0x3139,
  "rieulmieumkorean",
  0x313b,
  "rieulpansioskorean",
  0x316c,
  "rieulparenkorean",
  0x3203,
  "rieulphieuphkorean",
  0x313f,
  "rieulpieupkorean",
  0x313c,
  "rieulpieupsioskorean",
  0x316b,
  "rieulsioskorean",
  0x313d,
  "rieulthieuthkorean",
  0x313e,
  "rieultikeutkorean",
  0x316a,
  "rieulyeorinhieuhkorean",
  0x316d,
  "rightangle",
  0x221f,
  "righttackbelowcmb",
  0x0319,
  "righttriangle",
  0x22bf,
  "rihiragana",
  0x308a,
  "rikatakana",
  0x30ea,
  "rikatakanahalfwidth",
  0xff98,
  "ring",
  0x02da,
  "ringbelowcmb",
  0x0325,
  "ringcmb",
  0x030a,
  "ringhalfleft",
  0x02bf,
  "ringhalfleftarmenian",
  0x0559,
  "ringhalfleftbelowcmb",
  0x031c,
  "ringhalfleftcentered",
  0x02d3,
  "ringhalfright",
  0x02be,
  "ringhalfrightbelowcmb",
  0x0339,
  "ringhalfrightcentered",
  0x02d2,
  "rinvertedbreve",
  0x0213,
  "rittorusquare",
  0x3351,
  "rlinebelow",
  0x1e5f,
  "rlongleg",
  0x027c,
  "rlonglegturned",
  0x027a,
  "rmonospace",
  0xff52,
  "rohiragana",
  0x308d,
  "rokatakana",
  0x30ed,
  "rokatakanahalfwidth",
  0xff9b,
  "roruathai",
  0x0e23,
  "rparen",
  0x24ad,
  "rrabengali",
  0x09dc,
  "rradeva",
  0x0931,
  "rragurmukhi",
  0x0a5c,
  "rreharabic",
  0x0691,
  "rrehfinalarabic",
  0xfb8d,
  "rrvocalicbengali",
  0x09e0,
  "rrvocalicdeva",
  0x0960,
  "rrvocalicgujarati",
  0x0ae0,
  "rrvocalicvowelsignbengali",
  0x09c4,
  "rrvocalicvowelsigndeva",
  0x0944,
  "rrvocalicvowelsigngujarati",
  0x0ac4,
  "rsuperior",
  0xf6f1,
  "rtblock",
  0x2590,
  "rturned",
  0x0279,
  "rturnedsuperior",
  0x02b4,
  "ruhiragana",
  0x308b,
  "rukatakana",
  0x30eb,
  "rukatakanahalfwidth",
  0xff99,
  "rupeemarkbengali",
  0x09f2,
  "rupeesignbengali",
  0x09f3,
  "rupiah",
  0xf6dd,
  "ruthai",
  0x0e24,
  "rvocalicbengali",
  0x098b,
  "rvocalicdeva",
  0x090b,
  "rvocalicgujarati",
  0x0a8b,
  "rvocalicvowelsignbengali",
  0x09c3,
  "rvocalicvowelsigndeva",
  0x0943,
  "rvocalicvowelsigngujarati",
  0x0ac3,
  "s",
  0x0073,
  "sabengali",
  0x09b8,
  "sacute",
  0x015b,
  "sacutedotaccent",
  0x1e65,
  "sadarabic",
  0x0635,
  "sadeva",
  0x0938,
  "sadfinalarabic",
  0xfeba,
  "sadinitialarabic",
  0xfebb,
  "sadmedialarabic",
  0xfebc,
  "sagujarati",
  0x0ab8,
  "sagurmukhi",
  0x0a38,
  "sahiragana",
  0x3055,
  "sakatakana",
  0x30b5,
  "sakatakanahalfwidth",
  0xff7b,
  "sallallahoualayhewasallamarabic",
  0xfdfa,
  "samekh",
  0x05e1,
  "samekhdagesh",
  0xfb41,
  "samekhdageshhebrew",
  0xfb41,
  "samekhhebrew",
  0x05e1,
  "saraaathai",
  0x0e32,
  "saraaethai",
  0x0e41,
  "saraaimaimalaithai",
  0x0e44,
  "saraaimaimuanthai",
  0x0e43,
  "saraamthai",
  0x0e33,
  "saraathai",
  0x0e30,
  "saraethai",
  0x0e40,
  "saraiileftthai",
  0xf886,
  "saraiithai",
  0x0e35,
  "saraileftthai",
  0xf885,
  "saraithai",
  0x0e34,
  "saraothai",
  0x0e42,
  "saraueeleftthai",
  0xf888,
  "saraueethai",
  0x0e37,
  "saraueleftthai",
  0xf887,
  "sarauethai",
  0x0e36,
  "sarauthai",
  0x0e38,
  "sarauuthai",
  0x0e39,
  "sbopomofo",
  0x3119,
  "scaron",
  0x0161,
  "scarondotaccent",
  0x1e67,
  "scedilla",
  0x015f,
  "schwa",
  0x0259,
  "schwacyrillic",
  0x04d9,
  "schwadieresiscyrillic",
  0x04db,
  "schwahook",
  0x025a,
  "scircle",
  0x24e2,
  "scircumflex",
  0x015d,
  "scommaaccent",
  0x0219,
  "sdotaccent",
  0x1e61,
  "sdotbelow",
  0x1e63,
  "sdotbelowdotaccent",
  0x1e69,
  "seagullbelowcmb",
  0x033c,
  "second",
  0x2033,
  "secondtonechinese",
  0x02ca,
  "section",
  0x00a7,
  "seenarabic",
  0x0633,
  "seenfinalarabic",
  0xfeb2,
  "seeninitialarabic",
  0xfeb3,
  "seenmedialarabic",
  0xfeb4,
  "segol",
  0x05b6,
  "segol13",
  0x05b6,
  "segol1f",
  0x05b6,
  "segol2c",
  0x05b6,
  "segolhebrew",
  0x05b6,
  "segolnarrowhebrew",
  0x05b6,
  "segolquarterhebrew",
  0x05b6,
  "segoltahebrew",
  0x0592,
  "segolwidehebrew",
  0x05b6,
  "seharmenian",
  0x057d,
  "sehiragana",
  0x305b,
  "sekatakana",
  0x30bb,
  "sekatakanahalfwidth",
  0xff7e,
  "semicolon",
  0x003b,
  "semicolonarabic",
  0x061b,
  "semicolonmonospace",
  0xff1b,
  "semicolonsmall",
  0xfe54,
  "semivoicedmarkkana",
  0x309c,
  "semivoicedmarkkanahalfwidth",
  0xff9f,
  "sentisquare",
  0x3322,
  "sentosquare",
  0x3323,
  "seven",
  0x0037,
  "sevenarabic",
  0x0667,
  "sevenbengali",
  0x09ed,
  "sevencircle",
  0x2466,
  "sevencircleinversesansserif",
  0x2790,
  "sevendeva",
  0x096d,
  "seveneighths",
  0x215e,
  "sevengujarati",
  0x0aed,
  "sevengurmukhi",
  0x0a6d,
  "sevenhackarabic",
  0x0667,
  "sevenhangzhou",
  0x3027,
  "sevenideographicparen",
  0x3226,
  "seveninferior",
  0x2087,
  "sevenmonospace",
  0xff17,
  "sevenoldstyle",
  0xf737,
  "sevenparen",
  0x247a,
  "sevenperiod",
  0x248e,
  "sevenpersian",
  0x06f7,
  "sevenroman",
  0x2176,
  "sevensuperior",
  0x2077,
  "seventeencircle",
  0x2470,
  "seventeenparen",
  0x2484,
  "seventeenperiod",
  0x2498,
  "seventhai",
  0x0e57,
  "sfthyphen",
  0x00ad,
  "shaarmenian",
  0x0577,
  "shabengali",
  0x09b6,
  "shacyrillic",
  0x0448,
  "shaddaarabic",
  0x0651,
  "shaddadammaarabic",
  0xfc61,
  "shaddadammatanarabic",
  0xfc5e,
  "shaddafathaarabic",
  0xfc60,
  "shaddakasraarabic",
  0xfc62,
  "shaddakasratanarabic",
  0xfc5f,
  "shade",
  0x2592,
  "shadedark",
  0x2593,
  "shadelight",
  0x2591,
  "shademedium",
  0x2592,
  "shadeva",
  0x0936,
  "shagujarati",
  0x0ab6,
  "shagurmukhi",
  0x0a36,
  "shalshelethebrew",
  0x0593,
  "shbopomofo",
  0x3115,
  "shchacyrillic",
  0x0449,
  "sheenarabic",
  0x0634,
  "sheenfinalarabic",
  0xfeb6,
  "sheeninitialarabic",
  0xfeb7,
  "sheenmedialarabic",
  0xfeb8,
  "sheicoptic",
  0x03e3,
  "sheqel",
  0x20aa,
  "sheqelhebrew",
  0x20aa,
  "sheva",
  0x05b0,
  "sheva115",
  0x05b0,
  "sheva15",
  0x05b0,
  "sheva22",
  0x05b0,
  "sheva2e",
  0x05b0,
  "shevahebrew",
  0x05b0,
  "shevanarrowhebrew",
  0x05b0,
  "shevaquarterhebrew",
  0x05b0,
  "shevawidehebrew",
  0x05b0,
  "shhacyrillic",
  0x04bb,
  "shimacoptic",
  0x03ed,
  "shin",
  0x05e9,
  "shindagesh",
  0xfb49,
  "shindageshhebrew",
  0xfb49,
  "shindageshshindot",
  0xfb2c,
  "shindageshshindothebrew",
  0xfb2c,
  "shindageshsindot",
  0xfb2d,
  "shindageshsindothebrew",
  0xfb2d,
  "shindothebrew",
  0x05c1,
  "shinhebrew",
  0x05e9,
  "shinshindot",
  0xfb2a,
  "shinshindothebrew",
  0xfb2a,
  "shinsindot",
  0xfb2b,
  "shinsindothebrew",
  0xfb2b,
  "shook",
  0x0282,
  "sigma",
  0x03c3,
  "sigma1",
  0x03c2,
  "sigmafinal",
  0x03c2,
  "sigmalunatesymbolgreek",
  0x03f2,
  "sihiragana",
  0x3057,
  "sikatakana",
  0x30b7,
  "sikatakanahalfwidth",
  0xff7c,
  "siluqhebrew",
  0x05bd,
  "siluqlefthebrew",
  0x05bd,
  "similar",
  0x223c,
  "sindothebrew",
  0x05c2,
  "siosacirclekorean",
  0x3274,
  "siosaparenkorean",
  0x3214,
  "sioscieuckorean",
  0x317e,
  "sioscirclekorean",
  0x3266,
  "sioskiyeokkorean",
  0x317a,
  "sioskorean",
  0x3145,
  "siosnieunkorean",
  0x317b,
  "siosparenkorean",
  0x3206,
  "siospieupkorean",
  0x317d,
  "siostikeutkorean",
  0x317c,
  "six",
  0x0036,
  "sixarabic",
  0x0666,
  "sixbengali",
  0x09ec,
  "sixcircle",
  0x2465,
  "sixcircleinversesansserif",
  0x278f,
  "sixdeva",
  0x096c,
  "sixgujarati",
  0x0aec,
  "sixgurmukhi",
  0x0a6c,
  "sixhackarabic",
  0x0666,
  "sixhangzhou",
  0x3026,
  "sixideographicparen",
  0x3225,
  "sixinferior",
  0x2086,
  "sixmonospace",
  0xff16,
  "sixoldstyle",
  0xf736,
  "sixparen",
  0x2479,
  "sixperiod",
  0x248d,
  "sixpersian",
  0x06f6,
  "sixroman",
  0x2175,
  "sixsuperior",
  0x2076,
  "sixteencircle",
  0x246f,
  "sixteencurrencydenominatorbengali",
  0x09f9,
  "sixteenparen",
  0x2483,
  "sixteenperiod",
  0x2497,
  "sixthai",
  0x0e56,
  "slash",
  0x002f,
  "slashmonospace",
  0xff0f,
  "slong",
  0x017f,
  "slongdotaccent",
  0x1e9b,
  "smileface",
  0x263a,
  "smonospace",
  0xff53,
  "sofpasuqhebrew",
  0x05c3,
  "softhyphen",
  0x00ad,
  "softsigncyrillic",
  0x044c,
  "sohiragana",
  0x305d,
  "sokatakana",
  0x30bd,
  "sokatakanahalfwidth",
  0xff7f,
  "soliduslongoverlaycmb",
  0x0338,
  "solidusshortoverlaycmb",
  0x0337,
  "sorusithai",
  0x0e29,
  "sosalathai",
  0x0e28,
  "sosothai",
  0x0e0b,
  "sosuathai",
  0x0e2a,
  "space",
  0x0020,
  "spacehackarabic",
  0x0020,
  "spade",
  0x2660,
  "spadesuitblack",
  0x2660,
  "spadesuitwhite",
  0x2664,
  "sparen",
  0x24ae,
  "squarebelowcmb",
  0x033b,
  "squarecc",
  0x33c4,
  "squarecm",
  0x339d,
  "squarediagonalcrosshatchfill",
  0x25a9,
  "squarehorizontalfill",
  0x25a4,
  "squarekg",
  0x338f,
  "squarekm",
  0x339e,
  "squarekmcapital",
  0x33ce,
  "squareln",
  0x33d1,
  "squarelog",
  0x33d2,
  "squaremg",
  0x338e,
  "squaremil",
  0x33d5,
  "squaremm",
  0x339c,
  "squaremsquared",
  0x33a1,
  "squareorthogonalcrosshatchfill",
  0x25a6,
  "squareupperlefttolowerrightfill",
  0x25a7,
  "squareupperrighttolowerleftfill",
  0x25a8,
  "squareverticalfill",
  0x25a5,
  "squarewhitewithsmallblack",
  0x25a3,
  "srsquare",
  0x33db,
  "ssabengali",
  0x09b7,
  "ssadeva",
  0x0937,
  "ssagujarati",
  0x0ab7,
  "ssangcieuckorean",
  0x3149,
  "ssanghieuhkorean",
  0x3185,
  "ssangieungkorean",
  0x3180,
  "ssangkiyeokkorean",
  0x3132,
  "ssangnieunkorean",
  0x3165,
  "ssangpieupkorean",
  0x3143,
  "ssangsioskorean",
  0x3146,
  "ssangtikeutkorean",
  0x3138,
  "ssuperior",
  0xf6f2,
  "sterling",
  0x00a3,
  "sterlingmonospace",
  0xffe1,
  "strokelongoverlaycmb",
  0x0336,
  "strokeshortoverlaycmb",
  0x0335,
  "subset",
  0x2282,
  "subsetnotequal",
  0x228a,
  "subsetorequal",
  0x2286,
  "succeeds",
  0x227b,
  "suchthat",
  0x220b,
  "suhiragana",
  0x3059,
  "sukatakana",
  0x30b9,
  "sukatakanahalfwidth",
  0xff7d,
  "sukunarabic",
  0x0652,
  "summation",
  0x2211,
  "sun",
  0x263c,
  "superset",
  0x2283,
  "supersetnotequal",
  0x228b,
  "supersetorequal",
  0x2287,
  "svsquare",
  0x33dc,
  "syouwaerasquare",
  0x337c,
  "t",
  0x0074,
  "tabengali",
  0x09a4,
  "tackdown",
  0x22a4,
  "tackleft",
  0x22a3,
  "tadeva",
  0x0924,
  "tagujarati",
  0x0aa4,
  "tagurmukhi",
  0x0a24,
  "taharabic",
  0x0637,
  "tahfinalarabic",
  0xfec2,
  "tahinitialarabic",
  0xfec3,
  "tahiragana",
  0x305f,
  "tahmedialarabic",
  0xfec4,
  "taisyouerasquare",
  0x337d,
  "takatakana",
  0x30bf,
  "takatakanahalfwidth",
  0xff80,
  "tatweelarabic",
  0x0640,
  "tau",
  0x03c4,
  "tav",
  0x05ea,
  "tavdages",
  0xfb4a,
  "tavdagesh",
  0xfb4a,
  "tavdageshhebrew",
  0xfb4a,
  "tavhebrew",
  0x05ea,
  "tbar",
  0x0167,
  "tbopomofo",
  0x310a,
  "tcaron",
  0x0165,
  "tccurl",
  0x02a8,
  "tcedilla",
  0x0163,
  "tcheharabic",
  0x0686,
  "tchehfinalarabic",
  0xfb7b,
  "tchehinitialarabic",
  0xfb7c,
  "tchehmedialarabic",
  0xfb7d,
  "tcircle",
  0x24e3,
  "tcircumflexbelow",
  0x1e71,
  "tcommaaccent",
  0x0163,
  "tdieresis",
  0x1e97,
  "tdotaccent",
  0x1e6b,
  "tdotbelow",
  0x1e6d,
  "tecyrillic",
  0x0442,
  "tedescendercyrillic",
  0x04ad,
  "teharabic",
  0x062a,
  "tehfinalarabic",
  0xfe96,
  "tehhahinitialarabic",
  0xfca2,
  "tehhahisolatedarabic",
  0xfc0c,
  "tehinitialarabic",
  0xfe97,
  "tehiragana",
  0x3066,
  "tehjeeminitialarabic",
  0xfca1,
  "tehjeemisolatedarabic",
  0xfc0b,
  "tehmarbutaarabic",
  0x0629,
  "tehmarbutafinalarabic",
  0xfe94,
  "tehmedialarabic",
  0xfe98,
  "tehmeeminitialarabic",
  0xfca4,
  "tehmeemisolatedarabic",
  0xfc0e,
  "tehnoonfinalarabic",
  0xfc73,
  "tekatakana",
  0x30c6,
  "tekatakanahalfwidth",
  0xff83,
  "telephone",
  0x2121,
  "telephoneblack",
  0x260e,
  "telishagedolahebrew",
  0x05a0,
  "telishaqetanahebrew",
  0x05a9,
  "tencircle",
  0x2469,
  "tenideographicparen",
  0x3229,
  "tenparen",
  0x247d,
  "tenperiod",
  0x2491,
  "tenroman",
  0x2179,
  "tesh",
  0x02a7,
  "tet",
  0x05d8,
  "tetdagesh",
  0xfb38,
  "tetdageshhebrew",
  0xfb38,
  "tethebrew",
  0x05d8,
  "tetsecyrillic",
  0x04b5,
  "tevirhebrew",
  0x059b,
  "tevirlefthebrew",
  0x059b,
  "thabengali",
  0x09a5,
  "thadeva",
  0x0925,
  "thagujarati",
  0x0aa5,
  "thagurmukhi",
  0x0a25,
  "thalarabic",
  0x0630,
  "thalfinalarabic",
  0xfeac,
  "thanthakhatlowleftthai",
  0xf898,
  "thanthakhatlowrightthai",
  0xf897,
  "thanthakhatthai",
  0x0e4c,
  "thanthakhatupperleftthai",
  0xf896,
  "theharabic",
  0x062b,
  "thehfinalarabic",
  0xfe9a,
  "thehinitialarabic",
  0xfe9b,
  "thehmedialarabic",
  0xfe9c,
  "thereexists",
  0x2203,
  "therefore",
  0x2234,
  "theta",
  0x03b8,
  "theta1",
  0x03d1,
  "thetasymbolgreek",
  0x03d1,
  "thieuthacirclekorean",
  0x3279,
  "thieuthaparenkorean",
  0x3219,
  "thieuthcirclekorean",
  0x326b,
  "thieuthkorean",
  0x314c,
  "thieuthparenkorean",
  0x320b,
  "thirteencircle",
  0x246c,
  "thirteenparen",
  0x2480,
  "thirteenperiod",
  0x2494,
  "thonangmonthothai",
  0x0e11,
  "thook",
  0x01ad,
  "thophuthaothai",
  0x0e12,
  "thorn",
  0x00fe,
  "thothahanthai",
  0x0e17,
  "thothanthai",
  0x0e10,
  "thothongthai",
  0x0e18,
  "thothungthai",
  0x0e16,
  "thousandcyrillic",
  0x0482,
  "thousandsseparatorarabic",
  0x066c,
  "thousandsseparatorpersian",
  0x066c,
  "three",
  0x0033,
  "threearabic",
  0x0663,
  "threebengali",
  0x09e9,
  "threecircle",
  0x2462,
  "threecircleinversesansserif",
  0x278c,
  "threedeva",
  0x0969,
  "threeeighths",
  0x215c,
  "threegujarati",
  0x0ae9,
  "threegurmukhi",
  0x0a69,
  "threehackarabic",
  0x0663,
  "threehangzhou",
  0x3023,
  "threeideographicparen",
  0x3222,
  "threeinferior",
  0x2083,
  "threemonospace",
  0xff13,
  "threenumeratorbengali",
  0x09f6,
  "threeoldstyle",
  0xf733,
  "threeparen",
  0x2476,
  "threeperiod",
  0x248a,
  "threepersian",
  0x06f3,
  "threequarters",
  0x00be,
  "threequartersemdash",
  0xf6de,
  "threeroman",
  0x2172,
  "threesuperior",
  0x00b3,
  "threethai",
  0x0e53,
  "thzsquare",
  0x3394,
  "tihiragana",
  0x3061,
  "tikatakana",
  0x30c1,
  "tikatakanahalfwidth",
  0xff81,
  "tikeutacirclekorean",
  0x3270,
  "tikeutaparenkorean",
  0x3210,
  "tikeutcirclekorean",
  0x3262,
  "tikeutkorean",
  0x3137,
  "tikeutparenkorean",
  0x3202,
  "tilde",
  0x02dc,
  "tildebelowcmb",
  0x0330,
  "tildecmb",
  0x0303,
  "tildecomb",
  0x0303,
  "tildedoublecmb",
  0x0360,
  "tildeoperator",
  0x223c,
  "tildeoverlaycmb",
  0x0334,
  "tildeverticalcmb",
  0x033e,
  "timescircle",
  0x2297,
  "tipehahebrew",
  0x0596,
  "tipehalefthebrew",
  0x0596,
  "tippigurmukhi",
  0x0a70,
  "titlocyrilliccmb",
  0x0483,
  "tiwnarmenian",
  0x057f,
  "tlinebelow",
  0x1e6f,
  "tmonospace",
  0xff54,
  "toarmenian",
  0x0569,
  "tohiragana",
  0x3068,
  "tokatakana",
  0x30c8,
  "tokatakanahalfwidth",
  0xff84,
  "tonebarextrahighmod",
  0x02e5,
  "tonebarextralowmod",
  0x02e9,
  "tonebarhighmod",
  0x02e6,
  "tonebarlowmod",
  0x02e8,
  "tonebarmidmod",
  0x02e7,
  "tonefive",
  0x01bd,
  "tonesix",
  0x0185,
  "tonetwo",
  0x01a8,
  "tonos",
  0x0384,
  "tonsquare",
  0x3327,
  "topatakthai",
  0x0e0f,
  "tortoiseshellbracketleft",
  0x3014,
  "tortoiseshellbracketleftsmall",
  0xfe5d,
  "tortoiseshellbracketleftvertical",
  0xfe39,
  "tortoiseshellbracketright",
  0x3015,
  "tortoiseshellbracketrightsmall",
  0xfe5e,
  "tortoiseshellbracketrightvertical",
  0xfe3a,
  "totaothai",
  0x0e15,
  "tpalatalhook",
  0x01ab,
  "tparen",
  0x24af,
  "trademark",
  0x2122,
  "trademarksans",
  0xf8ea,
  "trademarkserif",
  0xf6db,
  "tretroflexhook",
  0x0288,
  "triagdn",
  0x25bc,
  "triaglf",
  0x25c4,
  "triagrt",
  0x25ba,
  "triagup",
  0x25b2,
  "ts",
  0x02a6,
  "tsadi",
  0x05e6,
  "tsadidagesh",
  0xfb46,
  "tsadidageshhebrew",
  0xfb46,
  "tsadihebrew",
  0x05e6,
  "tsecyrillic",
  0x0446,
  "tsere",
  0x05b5,
  "tsere12",
  0x05b5,
  "tsere1e",
  0x05b5,
  "tsere2b",
  0x05b5,
  "tserehebrew",
  0x05b5,
  "tserenarrowhebrew",
  0x05b5,
  "tserequarterhebrew",
  0x05b5,
  "tserewidehebrew",
  0x05b5,
  "tshecyrillic",
  0x045b,
  "tsuperior",
  0xf6f3,
  "ttabengali",
  0x099f,
  "ttadeva",
  0x091f,
  "ttagujarati",
  0x0a9f,
  "ttagurmukhi",
  0x0a1f,
  "tteharabic",
  0x0679,
  "ttehfinalarabic",
  0xfb67,
  "ttehinitialarabic",
  0xfb68,
  "ttehmedialarabic",
  0xfb69,
  "tthabengali",
  0x09a0,
  "tthadeva",
  0x0920,
  "tthagujarati",
  0x0aa0,
  "tthagurmukhi",
  0x0a20,
  "tturned",
  0x0287,
  "tuhiragana",
  0x3064,
  "tukatakana",
  0x30c4,
  "tukatakanahalfwidth",
  0xff82,
  "tusmallhiragana",
  0x3063,
  "tusmallkatakana",
  0x30c3,
  "tusmallkatakanahalfwidth",
  0xff6f,
  "twelvecircle",
  0x246b,
  "twelveparen",
  0x247f,
  "twelveperiod",
  0x2493,
  "twelveroman",
  0x217b,
  "twentycircle",
  0x2473,
  "twentyhangzhou",
  0x5344,
  "twentyparen",
  0x2487,
  "twentyperiod",
  0x249b,
  "two",
  0x0032,
  "twoarabic",
  0x0662,
  "twobengali",
  0x09e8,
  "twocircle",
  0x2461,
  "twocircleinversesansserif",
  0x278b,
  "twodeva",
  0x0968,
  "twodotenleader",
  0x2025,
  "twodotleader",
  0x2025,
  "twodotleadervertical",
  0xfe30,
  "twogujarati",
  0x0ae8,
  "twogurmukhi",
  0x0a68,
  "twohackarabic",
  0x0662,
  "twohangzhou",
  0x3022,
  "twoideographicparen",
  0x3221,
  "twoinferior",
  0x2082,
  "twomonospace",
  0xff12,
  "twonumeratorbengali",
  0x09f5,
  "twooldstyle",
  0xf732,
  "twoparen",
  0x2475,
  "twoperiod",
  0x2489,
  "twopersian",
  0x06f2,
  "tworoman",
  0x2171,
  "twostroke",
  0x01bb,
  "twosuperior",
  0x00b2,
  "twothai",
  0x0e52,
  "twothirds",
  0x2154,
  "u",
  0x0075,
  "uacute",
  0x00fa,
  "ubar",
  0x0289,
  "ubengali",
  0x0989,
  "ubopomofo",
  0x3128,
  "ubreve",
  0x016d,
  "ucaron",
  0x01d4,
  "ucircle",
  0x24e4,
  "ucircumflex",
  0x00fb,
  "ucircumflexbelow",
  0x1e77,
  "ucyrillic",
  0x0443,
  "udattadeva",
  0x0951,
  "udblacute",
  0x0171,
  "udblgrave",
  0x0215,
  "udeva",
  0x0909,
  "udieresis",
  0x00fc,
  "udieresisacute",
  0x01d8,
  "udieresisbelow",
  0x1e73,
  "udieresiscaron",
  0x01da,
  "udieresiscyrillic",
  0x04f1,
  "udieresisgrave",
  0x01dc,
  "udieresismacron",
  0x01d6,
  "udotbelow",
  0x1ee5,
  "ugrave",
  0x00f9,
  "ugujarati",
  0x0a89,
  "ugurmukhi",
  0x0a09,
  "uhiragana",
  0x3046,
  "uhookabove",
  0x1ee7,
  "uhorn",
  0x01b0,
  "uhornacute",
  0x1ee9,
  "uhorndotbelow",
  0x1ef1,
  "uhorngrave",
  0x1eeb,
  "uhornhookabove",
  0x1eed,
  "uhorntilde",
  0x1eef,
  "uhungarumlaut",
  0x0171,
  "uhungarumlautcyrillic",
  0x04f3,
  "uinvertedbreve",
  0x0217,
  "ukatakana",
  0x30a6,
  "ukatakanahalfwidth",
  0xff73,
  "ukcyrillic",
  0x0479,
  "ukorean",
  0x315c,
  "umacron",
  0x016b,
  "umacroncyrillic",
  0x04ef,
  "umacrondieresis",
  0x1e7b,
  "umatragurmukhi",
  0x0a41,
  "umonospace",
  0xff55,
  "underscore",
  0x005f,
  "underscoredbl",
  0x2017,
  "underscoremonospace",
  0xff3f,
  "underscorevertical",
  0xfe33,
  "underscorewavy",
  0xfe4f,
  "union",
  0x222a,
  "universal",
  0x2200,
  "uogonek",
  0x0173,
  "uparen",
  0x24b0,
  "upblock",
  0x2580,
  "upperdothebrew",
  0x05c4,
  "upsilon",
  0x03c5,
  "upsilondieresis",
  0x03cb,
  "upsilondieresistonos",
  0x03b0,
  "upsilonlatin",
  0x028a,
  "upsilontonos",
  0x03cd,
  "uptackbelowcmb",
  0x031d,
  "uptackmod",
  0x02d4,
  "uragurmukhi",
  0x0a73,
  "uring",
  0x016f,
  "ushortcyrillic",
  0x045e,
  "usmallhiragana",
  0x3045,
  "usmallkatakana",
  0x30a5,
  "usmallkatakanahalfwidth",
  0xff69,
  "ustraightcyrillic",
  0x04af,
  "ustraightstrokecyrillic",
  0x04b1,
  "utilde",
  0x0169,
  "utildeacute",
  0x1e79,
  "utildebelow",
  0x1e75,
  "uubengali",
  0x098a,
  "uudeva",
  0x090a,
  "uugujarati",
  0x0a8a,
  "uugurmukhi",
  0x0a0a,
  "uumatragurmukhi",
  0x0a42,
  "uuvowelsignbengali",
  0x09c2,
  "uuvowelsigndeva",
  0x0942,
  "uuvowelsigngujarati",
  0x0ac2,
  "uvowelsignbengali",
  0x09c1,
  "uvowelsigndeva",
  0x0941,
  "uvowelsigngujarati",
  0x0ac1,
  "v",
  0x0076,
  "vadeva",
  0x0935,
  "vagujarati",
  0x0ab5,
  "vagurmukhi",
  0x0a35,
  "vakatakana",
  0x30f7,
  "vav",
  0x05d5,
  "vavdagesh",
  0xfb35,
  "vavdagesh65",
  0xfb35,
  "vavdageshhebrew",
  0xfb35,
  "vavhebrew",
  0x05d5,
  "vavholam",
  0xfb4b,
  "vavholamhebrew",
  0xfb4b,
  "vavvavhebrew",
  0x05f0,
  "vavyodhebrew",
  0x05f1,
  "vcircle",
  0x24e5,
  "vdotbelow",
  0x1e7f,
  "vecyrillic",
  0x0432,
  "veharabic",
  0x06a4,
  "vehfinalarabic",
  0xfb6b,
  "vehinitialarabic",
  0xfb6c,
  "vehmedialarabic",
  0xfb6d,
  "vekatakana",
  0x30f9,
  "venus",
  0x2640,
  "verticalbar",
  0x007c,
  "verticallineabovecmb",
  0x030d,
  "verticallinebelowcmb",
  0x0329,
  "verticallinelowmod",
  0x02cc,
  "verticallinemod",
  0x02c8,
  "vewarmenian",
  0x057e,
  "vhook",
  0x028b,
  "vikatakana",
  0x30f8,
  "viramabengali",
  0x09cd,
  "viramadeva",
  0x094d,
  "viramagujarati",
  0x0acd,
  "visargabengali",
  0x0983,
  "visargadeva",
  0x0903,
  "visargagujarati",
  0x0a83,
  "vmonospace",
  0xff56,
  "voarmenian",
  0x0578,
  "voicediterationhiragana",
  0x309e,
  "voicediterationkatakana",
  0x30fe,
  "voicedmarkkana",
  0x309b,
  "voicedmarkkanahalfwidth",
  0xff9e,
  "vokatakana",
  0x30fa,
  "vparen",
  0x24b1,
  "vtilde",
  0x1e7d,
  "vturned",
  0x028c,
  "vuhiragana",
  0x3094,
  "vukatakana",
  0x30f4,
  "w",
  0x0077,
  "wacute",
  0x1e83,
  "waekorean",
  0x3159,
  "wahiragana",
  0x308f,
  "wakatakana",
  0x30ef,
  "wakatakanahalfwidth",
  0xff9c,
  "wakorean",
  0x3158,
  "wasmallhiragana",
  0x308e,
  "wasmallkatakana",
  0x30ee,
  "wattosquare",
  0x3357,
  "wavedash",
  0x301c,
  "wavyunderscorevertical",
  0xfe34,
  "wawarabic",
  0x0648,
  "wawfinalarabic",
  0xfeee,
  "wawhamzaabovearabic",
  0x0624,
  "wawhamzaabovefinalarabic",
  0xfe86,
  "wbsquare",
  0x33dd,
  "wcircle",
  0x24e6,
  "wcircumflex",
  0x0175,
  "wdieresis",
  0x1e85,
  "wdotaccent",
  0x1e87,
  "wdotbelow",
  0x1e89,
  "wehiragana",
  0x3091,
  "weierstrass",
  0x2118,
  "wekatakana",
  0x30f1,
  "wekorean",
  0x315e,
  "weokorean",
  0x315d,
  "wgrave",
  0x1e81,
  "whitebullet",
  0x25e6,
  "whitecircle",
  0x25cb,
  "whitecircleinverse",
  0x25d9,
  "whitecornerbracketleft",
  0x300e,
  "whitecornerbracketleftvertical",
  0xfe43,
  "whitecornerbracketright",
  0x300f,
  "whitecornerbracketrightvertical",
  0xfe44,
  "whitediamond",
  0x25c7,
  "whitediamondcontainingblacksmalldiamond",
  0x25c8,
  "whitedownpointingsmalltriangle",
  0x25bf,
  "whitedownpointingtriangle",
  0x25bd,
  "whiteleftpointingsmalltriangle",
  0x25c3,
  "whiteleftpointingtriangle",
  0x25c1,
  "whitelenticularbracketleft",
  0x3016,
  "whitelenticularbracketright",
  0x3017,
  "whiterightpointingsmalltriangle",
  0x25b9,
  "whiterightpointingtriangle",
  0x25b7,
  "whitesmallsquare",
  0x25ab,
  "whitesmilingface",
  0x263a,
  "whitesquare",
  0x25a1,
  "whitestar",
  0x2606,
  "whitetelephone",
  0x260f,
  "whitetortoiseshellbracketleft",
  0x3018,
  "whitetortoiseshellbracketright",
  0x3019,
  "whiteuppointingsmalltriangle",
  0x25b5,
  "whiteuppointingtriangle",
  0x25b3,
  "wihiragana",
  0x3090,
  "wikatakana",
  0x30f0,
  "wikorean",
  0x315f,
  "wmonospace",
  0xff57,
  "wohiragana",
  0x3092,
  "wokatakana",
  0x30f2,
  "wokatakanahalfwidth",
  0xff66,
  "won",
  0x20a9,
  "wonmonospace",
  0xffe6,
  "wowaenthai",
  0x0e27,
  "wparen",
  0x24b2,
  "wring",
  0x1e98,
  "wsuperior",
  0x02b7,
  "wturned",
  0x028d,
  "wynn",
  0x01bf,
  "x",
  0x0078,
  "xabovecmb",
  0x033d,
  "xbopomofo",
  0x3112,
  "xcircle",
  0x24e7,
  "xdieresis",
  0x1e8d,
  "xdotaccent",
  0x1e8b,
  "xeharmenian",
  0x056d,
  "xi",
  0x03be,
  "xmonospace",
  0xff58,
  "xparen",
  0x24b3,
  "xsuperior",
  0x02e3,
  "y",
  0x0079,
  "yaadosquare",
  0x334e,
  "yabengali",
  0x09af,
  "yacute",
  0x00fd,
  "yadeva",
  0x092f,
  "yaekorean",
  0x3152,
  "yagujarati",
  0x0aaf,
  "yagurmukhi",
  0x0a2f,
  "yahiragana",
  0x3084,
  "yakatakana",
  0x30e4,
  "yakatakanahalfwidth",
  0xff94,
  "yakorean",
  0x3151,
  "yamakkanthai",
  0x0e4e,
  "yasmallhiragana",
  0x3083,
  "yasmallkatakana",
  0x30e3,
  "yasmallkatakanahalfwidth",
  0xff6c,
  "yatcyrillic",
  0x0463,
  "ycircle",
  0x24e8,
  "ycircumflex",
  0x0177,
  "ydieresis",
  0x00ff,
  "ydotaccent",
  0x1e8f,
  "ydotbelow",
  0x1ef5,
  "yeharabic",
  0x064a,
  "yehbarreearabic",
  0x06d2,
  "yehbarreefinalarabic",
  0xfbaf,
  "yehfinalarabic",
  0xfef2,
  "yehhamzaabovearabic",
  0x0626,
  "yehhamzaabovefinalarabic",
  0xfe8a,
  "yehhamzaaboveinitialarabic",
  0xfe8b,
  "yehhamzaabovemedialarabic",
  0xfe8c,
  "yehinitialarabic",
  0xfef3,
  "yehmedialarabic",
  0xfef4,
  "yehmeeminitialarabic",
  0xfcdd,
  "yehmeemisolatedarabic",
  0xfc58,
  "yehnoonfinalarabic",
  0xfc94,
  "yehthreedotsbelowarabic",
  0x06d1,
  "yekorean",
  0x3156,
  "yen",
  0x00a5,
  "yenmonospace",
  0xffe5,
  "yeokorean",
  0x3155,
  "yeorinhieuhkorean",
  0x3186,
  "yerahbenyomohebrew",
  0x05aa,
  "yerahbenyomolefthebrew",
  0x05aa,
  "yericyrillic",
  0x044b,
  "yerudieresiscyrillic",
  0x04f9,
  "yesieungkorean",
  0x3181,
  "yesieungpansioskorean",
  0x3183,
  "yesieungsioskorean",
  0x3182,
  "yetivhebrew",
  0x059a,
  "ygrave",
  0x1ef3,
  "yhook",
  0x01b4,
  "yhookabove",
  0x1ef7,
  "yiarmenian",
  0x0575,
  "yicyrillic",
  0x0457,
  "yikorean",
  0x3162,
  "yinyang",
  0x262f,
  "yiwnarmenian",
  0x0582,
  "ymonospace",
  0xff59,
  "yod",
  0x05d9,
  "yoddagesh",
  0xfb39,
  "yoddageshhebrew",
  0xfb39,
  "yodhebrew",
  0x05d9,
  "yodyodhebrew",
  0x05f2,
  "yodyodpatahhebrew",
  0xfb1f,
  "yohiragana",
  0x3088,
  "yoikorean",
  0x3189,
  "yokatakana",
  0x30e8,
  "yokatakanahalfwidth",
  0xff96,
  "yokorean",
  0x315b,
  "yosmallhiragana",
  0x3087,
  "yosmallkatakana",
  0x30e7,
  "yosmallkatakanahalfwidth",
  0xff6e,
  "yotgreek",
  0x03f3,
  "yoyaekorean",
  0x3188,
  "yoyakorean",
  0x3187,
  "yoyakthai",
  0x0e22,
  "yoyingthai",
  0x0e0d,
  "yparen",
  0x24b4,
  "ypogegrammeni",
  0x037a,
  "ypogegrammenigreekcmb",
  0x0345,
  "yr",
  0x01a6,
  "yring",
  0x1e99,
  "ysuperior",
  0x02b8,
  "ytilde",
  0x1ef9,
  "yturned",
  0x028e,
  "yuhiragana",
  0x3086,
  "yuikorean",
  0x318c,
  "yukatakana",
  0x30e6,
  "yukatakanahalfwidth",
  0xff95,
  "yukorean",
  0x3160,
  "yusbigcyrillic",
  0x046b,
  "yusbigiotifiedcyrillic",
  0x046d,
  "yuslittlecyrillic",
  0x0467,
  "yuslittleiotifiedcyrillic",
  0x0469,
  "yusmallhiragana",
  0x3085,
  "yusmallkatakana",
  0x30e5,
  "yusmallkatakanahalfwidth",
  0xff6d,
  "yuyekorean",
  0x318b,
  "yuyeokorean",
  0x318a,
  "yyabengali",
  0x09df,
  "yyadeva",
  0x095f,
  "z",
  0x007a,
  "zaarmenian",
  0x0566,
  "zacute",
  0x017a,
  "zadeva",
  0x095b,
  "zagurmukhi",
  0x0a5b,
  "zaharabic",
  0x0638,
  "zahfinalarabic",
  0xfec6,
  "zahinitialarabic",
  0xfec7,
  "zahiragana",
  0x3056,
  "zahmedialarabic",
  0xfec8,
  "zainarabic",
  0x0632,
  "zainfinalarabic",
  0xfeb0,
  "zakatakana",
  0x30b6,
  "zaqefgadolhebrew",
  0x0595,
  "zaqefqatanhebrew",
  0x0594,
  "zarqahebrew",
  0x0598,
  "zayin",
  0x05d6,
  "zayindagesh",
  0xfb36,
  "zayindageshhebrew",
  0xfb36,
  "zayinhebrew",
  0x05d6,
  "zbopomofo",
  0x3117,
  "zcaron",
  0x017e,
  "zcircle",
  0x24e9,
  "zcircumflex",
  0x1e91,
  "zcurl",
  0x0291,
  "zdot",
  0x017c,
  "zdotaccent",
  0x017c,
  "zdotbelow",
  0x1e93,
  "zecyrillic",
  0x0437,
  "zedescendercyrillic",
  0x0499,
  "zedieresiscyrillic",
  0x04df,
  "zehiragana",
  0x305c,
  "zekatakana",
  0x30bc,
  "zero",
  0x0030,
  "zeroarabic",
  0x0660,
  "zerobengali",
  0x09e6,
  "zerodeva",
  0x0966,
  "zerogujarati",
  0x0ae6,
  "zerogurmukhi",
  0x0a66,
  "zerohackarabic",
  0x0660,
  "zeroinferior",
  0x2080,
  "zeromonospace",
  0xff10,
  "zerooldstyle",
  0xf730,
  "zeropersian",
  0x06f0,
  "zerosuperior",
  0x2070,
  "zerothai",
  0x0e50,
  "zerowidthjoiner",
  0xfeff,
  "zerowidthnonjoiner",
  0x200c,
  "zerowidthspace",
  0x200b,
  "zeta",
  0x03b6,
  "zhbopomofo",
  0x3113,
  "zhearmenian",
  0x056a,
  "zhebrevecyrillic",
  0x04c2,
  "zhecyrillic",
  0x0436,
  "zhedescendercyrillic",
  0x0497,
  "zhedieresiscyrillic",
  0x04dd,
  "zihiragana",
  0x3058,
  "zikatakana",
  0x30b8,
  "zinorhebrew",
  0x05ae,
  "zlinebelow",
  0x1e95,
  "zmonospace",
  0xff5a,
  "zohiragana",
  0x305e,
  "zokatakana",
  0x30be,
  "zparen",
  0x24b5,
  "zretroflexhook",
  0x0290,
  "zstroke",
  0x01b6,
  "zuhiragana",
  0x305a,
  "zukatakana",
  0x30ba,
  ".notdef",
  0x0000,
  "angbracketleftbig",
  0x2329,
  "angbracketleftBig",
  0x2329,
  "angbracketleftbigg",
  0x2329,
  "angbracketleftBigg",
  0x2329,
  "angbracketrightBig",
  0x232a,
  "angbracketrightbig",
  0x232a,
  "angbracketrightBigg",
  0x232a,
  "angbracketrightbigg",
  0x232a,
  "arrowhookleft",
  0x21aa,
  "arrowhookright",
  0x21a9,
  "arrowlefttophalf",
  0x21bc,
  "arrowleftbothalf",
  0x21bd,
  "arrownortheast",
  0x2197,
  "arrownorthwest",
  0x2196,
  "arrowrighttophalf",
  0x21c0,
  "arrowrightbothalf",
  0x21c1,
  "arrowsoutheast",
  0x2198,
  "arrowsouthwest",
  0x2199,
  "backslashbig",
  0x2216,
  "backslashBig",
  0x2216,
  "backslashBigg",
  0x2216,
  "backslashbigg",
  0x2216,
  "bardbl",
  0x2016,
  "bracehtipdownleft",
  0xfe37,
  "bracehtipdownright",
  0xfe37,
  "bracehtipupleft",
  0xfe38,
  "bracehtipupright",
  0xfe38,
  "braceleftBig",
  0x007b,
  "braceleftbig",
  0x007b,
  "braceleftbigg",
  0x007b,
  "braceleftBigg",
  0x007b,
  "bracerightBig",
  0x007d,
  "bracerightbig",
  0x007d,
  "bracerightbigg",
  0x007d,
  "bracerightBigg",
  0x007d,
  "bracketleftbig",
  0x005b,
  "bracketleftBig",
  0x005b,
  "bracketleftbigg",
  0x005b,
  "bracketleftBigg",
  0x005b,
  "bracketrightBig",
  0x005d,
  "bracketrightbig",
  0x005d,
  "bracketrightbigg",
  0x005d,
  "bracketrightBigg",
  0x005d,
  "ceilingleftbig",
  0x2308,
  "ceilingleftBig",
  0x2308,
  "ceilingleftBigg",
  0x2308,
  "ceilingleftbigg",
  0x2308,
  "ceilingrightbig",
  0x2309,
  "ceilingrightBig",
  0x2309,
  "ceilingrightbigg",
  0x2309,
  "ceilingrightBigg",
  0x2309,
  "circledotdisplay",
  0x2299,
  "circledottext",
  0x2299,
  "circlemultiplydisplay",
  0x2297,
  "circlemultiplytext",
  0x2297,
  "circleplusdisplay",
  0x2295,
  "circleplustext",
  0x2295,
  "contintegraldisplay",
  0x222e,
  "contintegraltext",
  0x222e,
  "coproductdisplay",
  0x2210,
  "coproducttext",
  0x2210,
  "floorleftBig",
  0x230a,
  "floorleftbig",
  0x230a,
  "floorleftbigg",
  0x230a,
  "floorleftBigg",
  0x230a,
  "floorrightbig",
  0x230b,
  "floorrightBig",
  0x230b,
  "floorrightBigg",
  0x230b,
  "floorrightbigg",
  0x230b,
  "hatwide",
  0x0302,
  "hatwider",
  0x0302,
  "hatwidest",
  0x0302,
  "intercal",
  0x1d40,
  "integraldisplay",
  0x222b,
  "integraltext",
  0x222b,
  "intersectiondisplay",
  0x22c2,
  "intersectiontext",
  0x22c2,
  "logicalanddisplay",
  0x2227,
  "logicalandtext",
  0x2227,
  "logicalordisplay",
  0x2228,
  "logicalortext",
  0x2228,
  "parenleftBig",
  0x0028,
  "parenleftbig",
  0x0028,
  "parenleftBigg",
  0x0028,
  "parenleftbigg",
  0x0028,
  "parenrightBig",
  0x0029,
  "parenrightbig",
  0x0029,
  "parenrightBigg",
  0x0029,
  "parenrightbigg",
  0x0029,
  "prime",
  0x2032,
  "productdisplay",
  0x220f,
  "producttext",
  0x220f,
  "radicalbig",
  0x221a,
  "radicalBig",
  0x221a,
  "radicalBigg",
  0x221a,
  "radicalbigg",
  0x221a,
  "radicalbt",
  0x221a,
  "radicaltp",
  0x221a,
  "radicalvertex",
  0x221a,
  "slashbig",
  0x002f,
  "slashBig",
  0x002f,
  "slashBigg",
  0x002f,
  "slashbigg",
  0x002f,
  "summationdisplay",
  0x2211,
  "summationtext",
  0x2211,
  "tildewide",
  0x02dc,
  "tildewider",
  0x02dc,
  "tildewidest",
  0x02dc,
  "uniondisplay",
  0x22c3,
  "unionmultidisplay",
  0x228e,
  "unionmultitext",
  0x228e,
  "unionsqdisplay",
  0x2294,
  "unionsqtext",
  0x2294,
  "uniontext",
  0x22c3,
  "vextenddouble",
  0x2225,
  "vextendsingle",
  0x2223
 ];
});
const getDingbatsGlyphsUnicode = (0,_core_utils_js__WEBPACK_IMPORTED_MODULE_0__.getArrayLookupTableFactory)(function () {
 return [
  "space",
  0x0020,
  "a1",
  0x2701,
  "a2",
  0x2702,
  "a202",
  0x2703,
  "a3",
  0x2704,
  "a4",
  0x260e,
  "a5",
  0x2706,
  "a119",
  0x2707,
  "a118",
  0x2708,
  "a117",
  0x2709,
  "a11",
  0x261b,
  "a12",
  0x261e,
  "a13",
  0x270c,
  "a14",
  0x270d,
  "a15",
  0x270e,
  "a16",
  0x270f,
  "a105",
  0x2710,
  "a17",
  0x2711,
  "a18",
  0x2712,
  "a19",
  0x2713,
  "a20",
  0x2714,
  "a21",
  0x2715,
  "a22",
  0x2716,
  "a23",
  0x2717,
  "a24",
  0x2718,
  "a25",
  0x2719,
  "a26",
  0x271a,
  "a27",
  0x271b,
  "a28",
  0x271c,
  "a6",
  0x271d,
  "a7",
  0x271e,
  "a8",
  0x271f,
  "a9",
  0x2720,
  "a10",
  0x2721,
  "a29",
  0x2722,
  "a30",
  0x2723,
  "a31",
  0x2724,
  "a32",
  0x2725,
  "a33",
  0x2726,
  "a34",
  0x2727,
  "a35",
  0x2605,
  "a36",
  0x2729,
  "a37",
  0x272a,
  "a38",
  0x272b,
  "a39",
  0x272c,
  "a40",
  0x272d,
  "a41",
  0x272e,
  "a42",
  0x272f,
  "a43",
  0x2730,
  "a44",
  0x2731,
  "a45",
  0x2732,
  "a46",
  0x2733,
  "a47",
  0x2734,
  "a48",
  0x2735,
  "a49",
  0x2736,
  "a50",
  0x2737,
  "a51",
  0x2738,
  "a52",
  0x2739,
  "a53",
  0x273a,
  "a54",
  0x273b,
  "a55",
  0x273c,
  "a56",
  0x273d,
  "a57",
  0x273e,
  "a58",
  0x273f,
  "a59",
  0x2740,
  "a60",
  0x2741,
  "a61",
  0x2742,
  "a62",
  0x2743,
  "a63",
  0x2744,
  "a64",
  0x2745,
  "a65",
  0x2746,
  "a66",
  0x2747,
  "a67",
  0x2748,
  "a68",
  0x2749,
  "a69",
  0x274a,
  "a70",
  0x274b,
  "a71",
  0x25cf,
  "a72",
  0x274d,
  "a73",
  0x25a0,
  "a74",
  0x274f,
  "a203",
  0x2750,
  "a75",
  0x2751,
  "a204",
  0x2752,
  "a76",
  0x25b2,
  "a77",
  0x25bc,
  "a78",
  0x25c6,
  "a79",
  0x2756,
  "a81",
  0x25d7,
  "a82",
  0x2758,
  "a83",
  0x2759,
  "a84",
  0x275a,
  "a97",
  0x275b,
  "a98",
  0x275c,
  "a99",
  0x275d,
  "a100",
  0x275e,
  "a101",
  0x2761,
  "a102",
  0x2762,
  "a103",
  0x2763,
  "a104",
  0x2764,
  "a106",
  0x2765,
  "a107",
  0x2766,
  "a108",
  0x2767,
  "a112",
  0x2663,
  "a111",
  0x2666,
  "a110",
  0x2665,
  "a109",
  0x2660,
  "a120",
  0x2460,
  "a121",
  0x2461,
  "a122",
  0x2462,
  "a123",
  0x2463,
  "a124",
  0x2464,
  "a125",
  0x2465,
  "a126",
  0x2466,
  "a127",
  0x2467,
  "a128",
  0x2468,
  "a129",
  0x2469,
  "a130",
  0x2776,
  "a131",
  0x2777,
  "a132",
  0x2778,
  "a133",
  0x2779,
  "a134",
  0x277a,
  "a135",
  0x277b,
  "a136",
  0x277c,
  "a137",
  0x277d,
  "a138",
  0x277e,
  "a139",
  0x277f,
  "a140",
  0x2780,
  "a141",
  0x2781,
  "a142",
  0x2782,
  "a143",
  0x2783,
  "a144",
  0x2784,
  "a145",
  0x2785,
  "a146",
  0x2786,
  "a147",
  0x2787,
  "a148",
  0x2788,
  "a149",
  0x2789,
  "a150",
  0x278a,
  "a151",
  0x278b,
  "a152",
  0x278c,
  "a153",
  0x278d,
  "a154",
  0x278e,
  "a155",
  0x278f,
  "a156",
  0x2790,
  "a157",
  0x2791,
  "a158",
  0x2792,
  "a159",
  0x2793,
  "a160",
  0x2794,
  "a161",
  0x2192,
  "a163",
  0x2194,
  "a164",
  0x2195,
  "a196",
  0x2798,
  "a165",
  0x2799,
  "a192",
  0x279a,
  "a166",
  0x279b,
  "a167",
  0x279c,
  "a168",
  0x279d,
  "a169",
  0x279e,
  "a170",
  0x279f,
  "a171",
  0x27a0,
  "a172",
  0x27a1,
  "a173",
  0x27a2,
  "a162",
  0x27a3,
  "a174",
  0x27a4,
  "a175",
  0x27a5,
  "a176",
  0x27a6,
  "a177",
  0x27a7,
  "a178",
  0x27a8,
  "a179",
  0x27a9,
  "a193",
  0x27aa,
  "a180",
  0x27ab,
  "a199",
  0x27ac,
  "a181",
  0x27ad,
  "a200",
  0x27ae,
  "a182",
  0x27af,
  "a201",
  0x27b1,
  "a183",
  0x27b2,
  "a184",
  0x27b3,
  "a197",
  0x27b4,
  "a185",
  0x27b5,
  "a194",
  0x27b6,
  "a198",
  0x27b7,
  "a186",
  0x27b8,
  "a195",
  0x27b9,
  "a187",
  0x27ba,
  "a188",
  0x27bb,
  "a189",
  0x27bc,
  "a190",
  0x27bd,
  "a191",
  0x27be,
  "a89",
  0x2768,
  "a90",
  0x2769,
  "a93",
  0x276a,
  "a94",
  0x276b,
  "a91",
  0x276c,
  "a92",
  0x276d,
  "a205",
  0x276e,
  "a85",
  0x276f,
  "a206",
  0x2770,
  "a86",
  0x2771,
  "a87",
  0x2772,
  "a88",
  0x2773,
  "a95",
  0x2774,
  "a96",
  0x2775,
  ".notdef",
  0x0000
 ];
});


/***/ }),
/* 163 */
/***/ ((__unused_webpack_module, __webpack_exports__, __w_pdfjs_require__) => {

"use strict";
__w_pdfjs_require__.r(__webpack_exports__);
/* harmony export */ __w_pdfjs_require__.d(__webpack_exports__, {
/* harmony export */   "clearUnicodeCaches": () => (/* binding */ clearUnicodeCaches),
/* harmony export */   "getCharUnicodeCategory": () => (/* binding */ getCharUnicodeCategory),
/* harmony export */   "getNormalizedUnicodes": () => (/* binding */ getNormalizedUnicodes),
/* harmony export */   "getUnicodeForGlyph": () => (/* binding */ getUnicodeForGlyph),
/* harmony export */   "getUnicodeRangeFor": () => (/* binding */ getUnicodeRangeFor),
/* harmony export */   "mapSpecialUnicodeValues": () => (/* binding */ mapSpecialUnicodeValues),
/* harmony export */   "reverseIfRtl": () => (/* binding */ reverseIfRtl)
/* harmony export */ });
/* harmony import */ var _core_utils_js__WEBPACK_IMPORTED_MODULE_0__ = __w_pdfjs_require__(150);

const getSpecialPUASymbols = (0,_core_utils_js__WEBPACK_IMPORTED_MODULE_0__.getLookupTableFactory)(function (t) {
 t[63721] = 0x00a9;
 t[63193] = 0x00a9;
 t[63720] = 0x00ae;
 t[63194] = 0x00ae;
 t[63722] = 0x2122;
 t[63195] = 0x2122;
 t[63729] = 0x23a7;
 t[63730] = 0x23a8;
 t[63731] = 0x23a9;
 t[63740] = 0x23ab;
 t[63741] = 0x23ac;
 t[63742] = 0x23ad;
 t[63726] = 0x23a1;
 t[63727] = 0x23a2;
 t[63728] = 0x23a3;
 t[63737] = 0x23a4;
 t[63738] = 0x23a5;
 t[63739] = 0x23a6;
 t[63723] = 0x239b;
 t[63724] = 0x239c;
 t[63725] = 0x239d;
 t[63734] = 0x239e;
 t[63735] = 0x239f;
 t[63736] = 0x23a0;
});
function mapSpecialUnicodeValues(code) {
 if (code >= 0xfff0 && code <= 0xffff) {
  return 0;
 } else if (code >= 0xf600 && code <= 0xf8ff) {
  return getSpecialPUASymbols()[code] || code;
 } else if (code === 0x00ad) {
  return 0x002d;
 }
 return code;
}
function getUnicodeForGlyph(name, glyphsUnicodeMap) {
 let unicode = glyphsUnicodeMap[name];
 if (unicode !== undefined) {
  return unicode;
 }
 if (!name) {
  return -1;
 }
 if (name[0] === "u") {
  const nameLen = name.length;
  let hexStr;
  if (nameLen === 7 && name[1] === "n" && name[2] === "i") {
   hexStr = name.substring(3);
  } else if (nameLen >= 5 && nameLen <= 7) {
   hexStr = name.substring(1);
  } else {
   return -1;
  }
  if (hexStr === hexStr.toUpperCase()) {
   unicode = parseInt(hexStr, 16);
   if (unicode >= 0) {
    return unicode;
   }
  }
 }
 return -1;
}
const UnicodeRanges = [
 {
  begin: 0x0000,
  end: 0x007f
 },
 {
  begin: 0x0080,
  end: 0x00ff
 },
 {
  begin: 0x0100,
  end: 0x017f
 },
 {
  begin: 0x0180,
  end: 0x024f
 },
 {
  begin: 0x0250,
  end: 0x02af
 },
 {
  begin: 0x02b0,
  end: 0x02ff
 },
 {
  begin: 0x0300,
  end: 0x036f
 },
 {
  begin: 0x0370,
  end: 0x03ff
 },
 {
  begin: 0x2c80,
  end: 0x2cff
 },
 {
  begin: 0x0400,
  end: 0x04ff
 },
 {
  begin: 0x0530,
  end: 0x058f
 },
 {
  begin: 0x0590,
  end: 0x05ff
 },
 {
  begin: 0xa500,
  end: 0xa63f
 },
 {
  begin: 0x0600,
  end: 0x06ff
 },
 {
  begin: 0x07c0,
  end: 0x07ff
 },
 {
  begin: 0x0900,
  end: 0x097f
 },
 {
  begin: 0x0980,
  end: 0x09ff
 },
 {
  begin: 0x0a00,
  end: 0x0a7f
 },
 {
  begin: 0x0a80,
  end: 0x0aff
 },
 {
  begin: 0x0b00,
  end: 0x0b7f
 },
 {
  begin: 0x0b80,
  end: 0x0bff
 },
 {
  begin: 0x0c00,
  end: 0x0c7f
 },
 {
  begin: 0x0c80,
  end: 0x0cff
 },
 {
  begin: 0x0d00,
  end: 0x0d7f
 },
 {
  begin: 0x0e00,
  end: 0x0e7f
 },
 {
  begin: 0x0e80,
  end: 0x0eff
 },
 {
  begin: 0x10a0,
  end: 0x10ff
 },
 {
  begin: 0x1b00,
  end: 0x1b7f
 },
 {
  begin: 0x1100,
  end: 0x11ff
 },
 {
  begin: 0x1e00,
  end: 0x1eff
 },
 {
  begin: 0x1f00,
  end: 0x1fff
 },
 {
  begin: 0x2000,
  end: 0x206f
 },
 {
  begin: 0x2070,
  end: 0x209f
 },
 {
  begin: 0x20a0,
  end: 0x20cf
 },
 {
  begin: 0x20d0,
  end: 0x20ff
 },
 {
  begin: 0x2100,
  end: 0x214f
 },
 {
  begin: 0x2150,
  end: 0x218f
 },
 {
  begin: 0x2190,
  end: 0x21ff
 },
 {
  begin: 0x2200,
  end: 0x22ff
 },
 {
  begin: 0x2300,
  end: 0x23ff
 },
 {
  begin: 0x2400,
  end: 0x243f
 },
 {
  begin: 0x2440,
  end: 0x245f
 },
 {
  begin: 0x2460,
  end: 0x24ff
 },
 {
  begin: 0x2500,
  end: 0x257f
 },
 {
  begin: 0x2580,
  end: 0x259f
 },
 {
  begin: 0x25a0,
  end: 0x25ff
 },
 {
  begin: 0x2600,
  end: 0x26ff
 },
 {
  begin: 0x2700,
  end: 0x27bf
 },
 {
  begin: 0x3000,
  end: 0x303f
 },
 {
  begin: 0x3040,
  end: 0x309f
 },
 {
  begin: 0x30a0,
  end: 0x30ff
 },
 {
  begin: 0x3100,
  end: 0x312f
 },
 {
  begin: 0x3130,
  end: 0x318f
 },
 {
  begin: 0xa840,
  end: 0xa87f
 },
 {
  begin: 0x3200,
  end: 0x32ff
 },
 {
  begin: 0x3300,
  end: 0x33ff
 },
 {
  begin: 0xac00,
  end: 0xd7af
 },
 {
  begin: 0xd800,
  end: 0xdfff
 },
 {
  begin: 0x10900,
  end: 0x1091f
 },
 {
  begin: 0x4e00,
  end: 0x9fff
 },
 {
  begin: 0xe000,
  end: 0xf8ff
 },
 {
  begin: 0x31c0,
  end: 0x31ef
 },
 {
  begin: 0xfb00,
  end: 0xfb4f
 },
 {
  begin: 0xfb50,
  end: 0xfdff
 },
 {
  begin: 0xfe20,
  end: 0xfe2f
 },
 {
  begin: 0xfe10,
  end: 0xfe1f
 },
 {
  begin: 0xfe50,
  end: 0xfe6f
 },
 {
  begin: 0xfe70,
  end: 0xfeff
 },
 {
  begin: 0xff00,
  end: 0xffef
 },
 {
  begin: 0xfff0,
  end: 0xffff
 },
 {
  begin: 0x0f00,
  end: 0x0fff
 },
 {
  begin: 0x0700,
  end: 0x074f
 },
 {
  begin: 0x0780,
  end: 0x07bf
 },
 {
  begin: 0x0d80,
  end: 0x0dff
 },
 {
  begin: 0x1000,
  end: 0x109f
 },
 {
  begin: 0x1200,
  end: 0x137f
 },
 {
  begin: 0x13a0,
  end: 0x13ff
 },
 {
  begin: 0x1400,
  end: 0x167f
 },
 {
  begin: 0x1680,
  end: 0x169f
 },
 {
  begin: 0x16a0,
  end: 0x16ff
 },
 {
  begin: 0x1780,
  end: 0x17ff
 },
 {
  begin: 0x1800,
  end: 0x18af
 },
 {
  begin: 0x2800,
  end: 0x28ff
 },
 {
  begin: 0xa000,
  end: 0xa48f
 },
 {
  begin: 0x1700,
  end: 0x171f
 },
 {
  begin: 0x10300,
  end: 0x1032f
 },
 {
  begin: 0x10330,
  end: 0x1034f
 },
 {
  begin: 0x10400,
  end: 0x1044f
 },
 {
  begin: 0x1d000,
  end: 0x1d0ff
 },
 {
  begin: 0x1d400,
  end: 0x1d7ff
 },
 {
  begin: 0xff000,
  end: 0xffffd
 },
 {
  begin: 0xfe00,
  end: 0xfe0f
 },
 {
  begin: 0xe0000,
  end: 0xe007f
 },
 {
  begin: 0x1900,
  end: 0x194f
 },
 {
  begin: 0x1950,
  end: 0x197f
 },
 {
  begin: 0x1980,
  end: 0x19df
 },
 {
  begin: 0x1a00,
  end: 0x1a1f
 },
 {
  begin: 0x2c00,
  end: 0x2c5f
 },
 {
  begin: 0x2d30,
  end: 0x2d7f
 },
 {
  begin: 0x4dc0,
  end: 0x4dff
 },
 {
  begin: 0xa800,
  end: 0xa82f
 },
 {
  begin: 0x10000,
  end: 0x1007f
 },
 {
  begin: 0x10140,
  end: 0x1018f
 },
 {
  begin: 0x10380,
  end: 0x1039f
 },
 {
  begin: 0x103a0,
  end: 0x103df
 },
 {
  begin: 0x10450,
  end: 0x1047f
 },
 {
  begin: 0x10480,
  end: 0x104af
 },
 {
  begin: 0x10800,
  end: 0x1083f
 },
 {
  begin: 0x10a00,
  end: 0x10a5f
 },
 {
  begin: 0x1d300,
  end: 0x1d35f
 },
 {
  begin: 0x12000,
  end: 0x123ff
 },
 {
  begin: 0x1d360,
  end: 0x1d37f
 },
 {
  begin: 0x1b80,
  end: 0x1bbf
 },
 {
  begin: 0x1c00,
  end: 0x1c4f
 },
 {
  begin: 0x1c50,
  end: 0x1c7f
 },
 {
  begin: 0xa880,
  end: 0xa8df
 },
 {
  begin: 0xa900,
  end: 0xa92f
 },
 {
  begin: 0xa930,
  end: 0xa95f
 },
 {
  begin: 0xaa00,
  end: 0xaa5f
 },
 {
  begin: 0x10190,
  end: 0x101cf
 },
 {
  begin: 0x101d0,
  end: 0x101ff
 },
 {
  begin: 0x102a0,
  end: 0x102df
 },
 {
  begin: 0x1f030,
  end: 0x1f09f
 }
];
function getUnicodeRangeFor(value) {
 for (let i = 0, ii = UnicodeRanges.length; i < ii; i++) {
  const range = UnicodeRanges[i];
  if (value >= range.begin && value < range.end) {
   return i;
  }
 }
 return -1;
}
function isRTLRangeFor(value) {
 let range = UnicodeRanges[13];
 if (value >= range.begin && value < range.end) {
  return true;
 }
 range = UnicodeRanges[11];
 if (value >= range.begin && value < range.end) {
  return true;
 }
 return false;
}
const getNormalizedUnicodes = (0,_core_utils_js__WEBPACK_IMPORTED_MODULE_0__.getArrayLookupTableFactory)(function () {
 return [
  "\u00A8",
  "\u0020\u0308",
  "\u00AF",
  "\u0020\u0304",
  "\u00B4",
  "\u0020\u0301",
  "\u00B5",
  "\u03BC",
  "\u00B8",
  "\u0020\u0327",
  "\u0132",
  "\u0049\u004A",
  "\u0133",
  "\u0069\u006A",
  "\u013F",
  "\u004C\u00B7",
  "\u0140",
  "\u006C\u00B7",
  "\u0149",
  "\u02BC\u006E",
  "\u017F",
  "\u0073",
  "\u01C4",
  "\u0044\u017D",
  "\u01C5",
  "\u0044\u017E",
  "\u01C6",
  "\u0064\u017E",
  "\u01C7",
  "\u004C\u004A",
  "\u01C8",
  "\u004C\u006A",
  "\u01C9",
  "\u006C\u006A",
  "\u01CA",
  "\u004E\u004A",
  "\u01CB",
  "\u004E\u006A",
  "\u01CC",
  "\u006E\u006A",
  "\u01F1",
  "\u0044\u005A",
  "\u01F2",
  "\u0044\u007A",
  "\u01F3",
  "\u0064\u007A",
  "\u02D8",
  "\u0020\u0306",
  "\u02D9",
  "\u0020\u0307",
  "\u02DA",
  "\u0020\u030A",
  "\u02DB",
  "\u0020\u0328",
  "\u02DC",
  "\u0020\u0303",
  "\u02DD",
  "\u0020\u030B",
  "\u037A",
  "\u0020\u0345",
  "\u0384",
  "\u0020\u0301",
  "\u03D0",
  "\u03B2",
  "\u03D1",
  "\u03B8",
  "\u03D2",
  "\u03A5",
  "\u03D5",
  "\u03C6",
  "\u03D6",
  "\u03C0",
  "\u03F0",
  "\u03BA",
  "\u03F1",
  "\u03C1",
  "\u03F2",
  "\u03C2",
  "\u03F4",
  "\u0398",
  "\u03F5",
  "\u03B5",
  "\u03F9",
  "\u03A3",
  "\u0587",
  "\u0565\u0582",
  "\u0675",
  "\u0627\u0674",
  "\u0676",
  "\u0648\u0674",
  "\u0677",
  "\u06C7\u0674",
  "\u0678",
  "\u064A\u0674",
  "\u0E33",
  "\u0E4D\u0E32",
  "\u0EB3",
  "\u0ECD\u0EB2",
  "\u0EDC",
  "\u0EAB\u0E99",
  "\u0EDD",
  "\u0EAB\u0EA1",
  "\u0F77",
  "\u0FB2\u0F81",
  "\u0F79",
  "\u0FB3\u0F81",
  "\u1E9A",
  "\u0061\u02BE",
  "\u1FBD",
  "\u0020\u0313",
  "\u1FBF",
  "\u0020\u0313",
  "\u1FC0",
  "\u0020\u0342",
  "\u1FFE",
  "\u0020\u0314",
  "\u2002",
  "\u0020",
  "\u2003",
  "\u0020",
  "\u2004",
  "\u0020",
  "\u2005",
  "\u0020",
  "\u2006",
  "\u0020",
  "\u2008",
  "\u0020",
  "\u2009",
  "\u0020",
  "\u200A",
  "\u0020",
  "\u2017",
  "\u0020\u0333",
  "\u2024",
  "\u002E",
  "\u2025",
  "\u002E\u002E",
  "\u2026",
  "\u002E\u002E\u002E",
  "\u2033",
  "\u2032\u2032",
  "\u2034",
  "\u2032\u2032\u2032",
  "\u2036",
  "\u2035\u2035",
  "\u2037",
  "\u2035\u2035\u2035",
  "\u203C",
  "\u0021\u0021",
  "\u203E",
  "\u0020\u0305",
  "\u2047",
  "\u003F\u003F",
  "\u2048",
  "\u003F\u0021",
  "\u2049",
  "\u0021\u003F",
  "\u2057",
  "\u2032\u2032\u2032\u2032",
  "\u205F",
  "\u0020",
  "\u20A8",
  "\u0052\u0073",
  "\u2100",
  "\u0061\u002F\u0063",
  "\u2101",
  "\u0061\u002F\u0073",
  "\u2103",
  "\u00B0\u0043",
  "\u2105",
  "\u0063\u002F\u006F",
  "\u2106",
  "\u0063\u002F\u0075",
  "\u2107",
  "\u0190",
  "\u2109",
  "\u00B0\u0046",
  "\u2116",
  "\u004E\u006F",
  "\u2121",
  "\u0054\u0045\u004C",
  "\u2135",
  "\u05D0",
  "\u2136",
  "\u05D1",
  "\u2137",
  "\u05D2",
  "\u2138",
  "\u05D3",
  "\u213B",
  "\u0046\u0041\u0058",
  "\u2160",
  "\u0049",
  "\u2161",
  "\u0049\u0049",
  "\u2162",
  "\u0049\u0049\u0049",
  "\u2163",
  "\u0049\u0056",
  "\u2164",
  "\u0056",
  "\u2165",
  "\u0056\u0049",
  "\u2166",
  "\u0056\u0049\u0049",
  "\u2167",
  "\u0056\u0049\u0049\u0049",
  "\u2168",
  "\u0049\u0058",
  "\u2169",
  "\u0058",
  "\u216A",
  "\u0058\u0049",
  "\u216B",
  "\u0058\u0049\u0049",
  "\u216C",
  "\u004C",
  "\u216D",
  "\u0043",
  "\u216E",
  "\u0044",
  "\u216F",
  "\u004D",
  "\u2170",
  "\u0069",
  "\u2171",
  "\u0069\u0069",
  "\u2172",
  "\u0069\u0069\u0069",
  "\u2173",
  "\u0069\u0076",
  "\u2174",
  "\u0076",
  "\u2175",
  "\u0076\u0069",
  "\u2176",
  "\u0076\u0069\u0069",
  "\u2177",
  "\u0076\u0069\u0069\u0069",
  "\u2178",
  "\u0069\u0078",
  "\u2179",
  "\u0078",
  "\u217A",
  "\u0078\u0069",
  "\u217B",
  "\u0078\u0069\u0069",
  "\u217C",
  "\u006C",
  "\u217D",
  "\u0063",
  "\u217E",
  "\u0064",
  "\u217F",
  "\u006D",
  "\u222C",
  "\u222B\u222B",
  "\u222D",
  "\u222B\u222B\u222B",
  "\u222F",
  "\u222E\u222E",
  "\u2230",
  "\u222E\u222E\u222E",
  "\u2474",
  "\u0028\u0031\u0029",
  "\u2475",
  "\u0028\u0032\u0029",
  "\u2476",
  "\u0028\u0033\u0029",
  "\u2477",
  "\u0028\u0034\u0029",
  "\u2478",
  "\u0028\u0035\u0029",
  "\u2479",
  "\u0028\u0036\u0029",
  "\u247A",
  "\u0028\u0037\u0029",
  "\u247B",
  "\u0028\u0038\u0029",
  "\u247C",
  "\u0028\u0039\u0029",
  "\u247D",
  "\u0028\u0031\u0030\u0029",
  "\u247E",
  "\u0028\u0031\u0031\u0029",
  "\u247F",
  "\u0028\u0031\u0032\u0029",
  "\u2480",
  "\u0028\u0031\u0033\u0029",
  "\u2481",
  "\u0028\u0031\u0034\u0029",
  "\u2482",
  "\u0028\u0031\u0035\u0029",
  "\u2483",
  "\u0028\u0031\u0036\u0029",
  "\u2484",
  "\u0028\u0031\u0037\u0029",
  "\u2485",
  "\u0028\u0031\u0038\u0029",
  "\u2486",
  "\u0028\u0031\u0039\u0029",
  "\u2487",
  "\u0028\u0032\u0030\u0029",
  "\u2488",
  "\u0031\u002E",
  "\u2489",
  "\u0032\u002E",
  "\u248A",
  "\u0033\u002E",
  "\u248B",
  "\u0034\u002E",
  "\u248C",
  "\u0035\u002E",
  "\u248D",
  "\u0036\u002E",
  "\u248E",
  "\u0037\u002E",
  "\u248F",
  "\u0038\u002E",
  "\u2490",
  "\u0039\u002E",
  "\u2491",
  "\u0031\u0030\u002E",
  "\u2492",
  "\u0031\u0031\u002E",
  "\u2493",
  "\u0031\u0032\u002E",
  "\u2494",
  "\u0031\u0033\u002E",
  "\u2495",
  "\u0031\u0034\u002E",
  "\u2496",
  "\u0031\u0035\u002E",
  "\u2497",
  "\u0031\u0036\u002E",
  "\u2498",
  "\u0031\u0037\u002E",
  "\u2499",
  "\u0031\u0038\u002E",
  "\u249A",
  "\u0031\u0039\u002E",
  "\u249B",
  "\u0032\u0030\u002E",
  "\u249C",
  "\u0028\u0061\u0029",
  "\u249D",
  "\u0028\u0062\u0029",
  "\u249E",
  "\u0028\u0063\u0029",
  "\u249F",
  "\u0028\u0064\u0029",
  "\u24A0",
  "\u0028\u0065\u0029",
  "\u24A1",
  "\u0028\u0066\u0029",
  "\u24A2",
  "\u0028\u0067\u0029",
  "\u24A3",
  "\u0028\u0068\u0029",
  "\u24A4",
  "\u0028\u0069\u0029",
  "\u24A5",
  "\u0028\u006A\u0029",
  "\u24A6",
  "\u0028\u006B\u0029",
  "\u24A7",
  "\u0028\u006C\u0029",
  "\u24A8",
  "\u0028\u006D\u0029",
  "\u24A9",
  "\u0028\u006E\u0029",
  "\u24AA",
  "\u0028\u006F\u0029",
  "\u24AB",
  "\u0028\u0070\u0029",
  "\u24AC",
  "\u0028\u0071\u0029",
  "\u24AD",
  "\u0028\u0072\u0029",
  "\u24AE",
  "\u0028\u0073\u0029",
  "\u24AF",
  "\u0028\u0074\u0029",
  "\u24B0",
  "\u0028\u0075\u0029",
  "\u24B1",
  "\u0028\u0076\u0029",
  "\u24B2",
  "\u0028\u0077\u0029",
  "\u24B3",
  "\u0028\u0078\u0029",
  "\u24B4",
  "\u0028\u0079\u0029",
  "\u24B5",
  "\u0028\u007A\u0029",
  "\u2A0C",
  "\u222B\u222B\u222B\u222B",
  "\u2A74",
  "\u003A\u003A\u003D",
  "\u2A75",
  "\u003D\u003D",
  "\u2A76",
  "\u003D\u003D\u003D",
  "\u2E9F",
  "\u6BCD",
  "\u2EF3",
  "\u9F9F",
  "\u2F00",
  "\u4E00",
  "\u2F01",
  "\u4E28",
  "\u2F02",
  "\u4E36",
  "\u2F03",
  "\u4E3F",
  "\u2F04",
  "\u4E59",
  "\u2F05",
  "\u4E85",
  "\u2F06",
  "\u4E8C",
  "\u2F07",
  "\u4EA0",
  "\u2F08",
  "\u4EBA",
  "\u2F09",
  "\u513F",
  "\u2F0A",
  "\u5165",
  "\u2F0B",
  "\u516B",
  "\u2F0C",
  "\u5182",
  "\u2F0D",
  "\u5196",
  "\u2F0E",
  "\u51AB",
  "\u2F0F",
  "\u51E0",
  "\u2F10",
  "\u51F5",
  "\u2F11",
  "\u5200",
  "\u2F12",
  "\u529B",
  "\u2F13",
  "\u52F9",
  "\u2F14",
  "\u5315",
  "\u2F15",
  "\u531A",
  "\u2F16",
  "\u5338",
  "\u2F17",
  "\u5341",
  "\u2F18",
  "\u535C",
  "\u2F19",
  "\u5369",
  "\u2F1A",
  "\u5382",
  "\u2F1B",
  "\u53B6",
  "\u2F1C",
  "\u53C8",
  "\u2F1D",
  "\u53E3",
  "\u2F1E",
  "\u56D7",
  "\u2F1F",
  "\u571F",
  "\u2F20",
  "\u58EB",
  "\u2F21",
  "\u5902",
  "\u2F22",
  "\u590A",
  "\u2F23",
  "\u5915",
  "\u2F24",
  "\u5927",
  "\u2F25",
  "\u5973",
  "\u2F26",
  "\u5B50",
  "\u2F27",
  "\u5B80",
  "\u2F28",
  "\u5BF8",
  "\u2F29",
  "\u5C0F",
  "\u2F2A",
  "\u5C22",
  "\u2F2B",
  "\u5C38",
  "\u2F2C",
  "\u5C6E",
  "\u2F2D",
  "\u5C71",
  "\u2F2E",
  "\u5DDB",
  "\u2F2F",
  "\u5DE5",
  "\u2F30",
  "\u5DF1",
  "\u2F31",
  "\u5DFE",
  "\u2F32",
  "\u5E72",
  "\u2F33",
  "\u5E7A",
  "\u2F34",
  "\u5E7F",
  "\u2F35",
  "\u5EF4",
  "\u2F36",
  "\u5EFE",
  "\u2F37",
  "\u5F0B",
  "\u2F38",
  "\u5F13",
  "\u2F39",
  "\u5F50",
  "\u2F3A",
  "\u5F61",
  "\u2F3B",
  "\u5F73",
  "\u2F3C",
  "\u5FC3",
  "\u2F3D",
  "\u6208",
  "\u2F3E",
  "\u6236",
  "\u2F3F",
  "\u624B",
  "\u2F40",
  "\u652F",
  "\u2F41",
  "\u6534",
  "\u2F42",
  "\u6587",
  "\u2F43",
  "\u6597",
  "\u2F44",
  "\u65A4",
  "\u2F45",
  "\u65B9",
  "\u2F46",
  "\u65E0",
  "\u2F47",
  "\u65E5",
  "\u2F48",
  "\u66F0",
  "\u2F49",
  "\u6708",
  "\u2F4A",
  "\u6728",
  "\u2F4B",
  "\u6B20",
  "\u2F4C",
  "\u6B62",
  "\u2F4D",
  "\u6B79",
  "\u2F4E",
  "\u6BB3",
  "\u2F4F",
  "\u6BCB",
  "\u2F50",
  "\u6BD4",
  "\u2F51",
  "\u6BDB",
  "\u2F52",
  "\u6C0F",
  "\u2F53",
  "\u6C14",
  "\u2F54",
  "\u6C34",
  "\u2F55",
  "\u706B",
  "\u2F56",
  "\u722A",
  "\u2F57",
  "\u7236",
  "\u2F58",
  "\u723B",
  "\u2F59",
  "\u723F",
  "\u2F5A",
  "\u7247",
  "\u2F5B",
  "\u7259",
  "\u2F5C",
  "\u725B",
  "\u2F5D",
  "\u72AC",
  "\u2F5E",
  "\u7384",
  "\u2F5F",
  "\u7389",
  "\u2F60",
  "\u74DC",
  "\u2F61",
  "\u74E6",
  "\u2F62",
  "\u7518",
  "\u2F63",
  "\u751F",
  "\u2F64",
  "\u7528",
  "\u2F65",
  "\u7530",
  "\u2F66",
  "\u758B",
  "\u2F67",
  "\u7592",
  "\u2F68",
  "\u7676",
  "\u2F69",
  "\u767D",
  "\u2F6A",
  "\u76AE",
  "\u2F6B",
  "\u76BF",
  "\u2F6C",
  "\u76EE",
  "\u2F6D",
  "\u77DB",
  "\u2F6E",
  "\u77E2",
  "\u2F6F",
  "\u77F3",
  "\u2F70",
  "\u793A",
  "\u2F71",
  "\u79B8",
  "\u2F72",
  "\u79BE",
  "\u2F73",
  "\u7A74",
  "\u2F74",
  "\u7ACB",
  "\u2F75",
  "\u7AF9",
  "\u2F76",
  "\u7C73",
  "\u2F77",
  "\u7CF8",
  "\u2F78",
  "\u7F36",
  "\u2F79",
  "\u7F51",
  "\u2F7A",
  "\u7F8A",
  "\u2F7B",
  "\u7FBD",
  "\u2F7C",
  "\u8001",
  "\u2F7D",
  "\u800C",
  "\u2F7E",
  "\u8012",
  "\u2F7F",
  "\u8033",
  "\u2F80",
  "\u807F",
  "\u2F81",
  "\u8089",
  "\u2F82",
  "\u81E3",
  "\u2F83",
  "\u81EA",
  "\u2F84",
  "\u81F3",
  "\u2F85",
  "\u81FC",
  "\u2F86",
  "\u820C",
  "\u2F87",
  "\u821B",
  "\u2F88",
  "\u821F",
  "\u2F89",
  "\u826E",
  "\u2F8A",
  "\u8272",
  "\u2F8B",
  "\u8278",
  "\u2F8C",
  "\u864D",
  "\u2F8D",
  "\u866B",
  "\u2F8E",
  "\u8840",
  "\u2F8F",
  "\u884C",
  "\u2F90",
  "\u8863",
  "\u2F91",
  "\u897E",
  "\u2F92",
  "\u898B",
  "\u2F93",
  "\u89D2",
  "\u2F94",
  "\u8A00",
  "\u2F95",
  "\u8C37",
  "\u2F96",
  "\u8C46",
  "\u2F97",
  "\u8C55",
  "\u2F98",
  "\u8C78",
  "\u2F99",
  "\u8C9D",
  "\u2F9A",
  "\u8D64",
  "\u2F9B",
  "\u8D70",
  "\u2F9C",
  "\u8DB3",
  "\u2F9D",
  "\u8EAB",
  "\u2F9E",
  "\u8ECA",
  "\u2F9F",
  "\u8F9B",
  "\u2FA0",
  "\u8FB0",
  "\u2FA1",
  "\u8FB5",
  "\u2FA2",
  "\u9091",
  "\u2FA3",
  "\u9149",
  "\u2FA4",
  "\u91C6",
  "\u2FA5",
  "\u91CC",
  "\u2FA6",
  "\u91D1",
  "\u2FA7",
  "\u9577",
  "\u2FA8",
  "\u9580",
  "\u2FA9",
  "\u961C",
  "\u2FAA",
  "\u96B6",
  "\u2FAB",
  "\u96B9",
  "\u2FAC",
  "\u96E8",
  "\u2FAD",
  "\u9751",
  "\u2FAE",
  "\u975E",
  "\u2FAF",
  "\u9762",
  "\u2FB0",
  "\u9769",
  "\u2FB1",
  "\u97CB",
  "\u2FB2",
  "\u97ED",
  "\u2FB3",
  "\u97F3",
  "\u2FB4",
  "\u9801",
  "\u2FB5",
  "\u98A8",
  "\u2FB6",
  "\u98DB",
  "\u2FB7",
  "\u98DF",
  "\u2FB8",
  "\u9996",
  "\u2FB9",
  "\u9999",
  "\u2FBA",
  "\u99AC",
  "\u2FBB",
  "\u9AA8",
  "\u2FBC",
  "\u9AD8",
  "\u2FBD",
  "\u9ADF",
  "\u2FBE",
  "\u9B25",
  "\u2FBF",
  "\u9B2F",
  "\u2FC0",
  "\u9B32",
  "\u2FC1",
  "\u9B3C",
  "\u2FC2",
  "\u9B5A",
  "\u2FC3",
  "\u9CE5",
  "\u2FC4",
  "\u9E75",
  "\u2FC5",
  "\u9E7F",
  "\u2FC6",
  "\u9EA5",
  "\u2FC7",
  "\u9EBB",
  "\u2FC8",
  "\u9EC3",
  "\u2FC9",
  "\u9ECD",
  "\u2FCA",
  "\u9ED1",
  "\u2FCB",
  "\u9EF9",
  "\u2FCC",
  "\u9EFD",
  "\u2FCD",
  "\u9F0E",
  "\u2FCE",
  "\u9F13",
  "\u2FCF",
  "\u9F20",
  "\u2FD0",
  "\u9F3B",
  "\u2FD1",
  "\u9F4A",
  "\u2FD2",
  "\u9F52",
  "\u2FD3",
  "\u9F8D",
  "\u2FD4",
  "\u9F9C",
  "\u2FD5",
  "\u9FA0",
  "\u3036",
  "\u3012",
  "\u3038",
  "\u5341",
  "\u3039",
  "\u5344",
  "\u303A",
  "\u5345",
  "\u309B",
  "\u0020\u3099",
  "\u309C",
  "\u0020\u309A",
  "\u3131",
  "\u1100",
  "\u3132",
  "\u1101",
  "\u3133",
  "\u11AA",
  "\u3134",
  "\u1102",
  "\u3135",
  "\u11AC",
  "\u3136",
  "\u11AD",
  "\u3137",
  "\u1103",
  "\u3138",
  "\u1104",
  "\u3139",
  "\u1105",
  "\u313A",
  "\u11B0",
  "\u313B",
  "\u11B1",
  "\u313C",
  "\u11B2",
  "\u313D",
  "\u11B3",
  "\u313E",
  "\u11B4",
  "\u313F",
  "\u11B5",
  "\u3140",
  "\u111A",
  "\u3141",
  "\u1106",
  "\u3142",
  "\u1107",
  "\u3143",
  "\u1108",
  "\u3144",
  "\u1121",
  "\u3145",
  "\u1109",
  "\u3146",
  "\u110A",
  "\u3147",
  "\u110B",
  "\u3148",
  "\u110C",
  "\u3149",
  "\u110D",
  "\u314A",
  "\u110E",
  "\u314B",
  "\u110F",
  "\u314C",
  "\u1110",
  "\u314D",
  "\u1111",
  "\u314E",
  "\u1112",
  "\u314F",
  "\u1161",
  "\u3150",
  "\u1162",
  "\u3151",
  "\u1163",
  "\u3152",
  "\u1164",
  "\u3153",
  "\u1165",
  "\u3154",
  "\u1166",
  "\u3155",
  "\u1167",
  "\u3156",
  "\u1168",
  "\u3157",
  "\u1169",
  "\u3158",
  "\u116A",
  "\u3159",
  "\u116B",
  "\u315A",
  "\u116C",
  "\u315B",
  "\u116D",
  "\u315C",
  "\u116E",
  "\u315D",
  "\u116F",
  "\u315E",
  "\u1170",
  "\u315F",
  "\u1171",
  "\u3160",
  "\u1172",
  "\u3161",
  "\u1173",
  "\u3162",
  "\u1174",
  "\u3163",
  "\u1175",
  "\u3164",
  "\u1160",
  "\u3165",
  "\u1114",
  "\u3166",
  "\u1115",
  "\u3167",
  "\u11C7",
  "\u3168",
  "\u11C8",
  "\u3169",
  "\u11CC",
  "\u316A",
  "\u11CE",
  "\u316B",
  "\u11D3",
  "\u316C",
  "\u11D7",
  "\u316D",
  "\u11D9",
  "\u316E",
  "\u111C",
  "\u316F",
  "\u11DD",
  "\u3170",
  "\u11DF",
  "\u3171",
  "\u111D",
  "\u3172",
  "\u111E",
  "\u3173",
  "\u1120",
  "\u3174",
  "\u1122",
  "\u3175",
  "\u1123",
  "\u3176",
  "\u1127",
  "\u3177",
  "\u1129",
  "\u3178",
  "\u112B",
  "\u3179",
  "\u112C",
  "\u317A",
  "\u112D",
  "\u317B",
  "\u112E",
  "\u317C",
  "\u112F",
  "\u317D",
  "\u1132",
  "\u317E",
  "\u1136",
  "\u317F",
  "\u1140",
  "\u3180",
  "\u1147",
  "\u3181",
  "\u114C",
  "\u3182",
  "\u11F1",
  "\u3183",
  "\u11F2",
  "\u3184",
  "\u1157",
  "\u3185",
  "\u1158",
  "\u3186",
  "\u1159",
  "\u3187",
  "\u1184",
  "\u3188",
  "\u1185",
  "\u3189",
  "\u1188",
  "\u318A",
  "\u1191",
  "\u318B",
  "\u1192",
  "\u318C",
  "\u1194",
  "\u318D",
  "\u119E",
  "\u318E",
  "\u11A1",
  "\u3200",
  "\u0028\u1100\u0029",
  "\u3201",
  "\u0028\u1102\u0029",
  "\u3202",
  "\u0028\u1103\u0029",
  "\u3203",
  "\u0028\u1105\u0029",
  "\u3204",
  "\u0028\u1106\u0029",
  "\u3205",
  "\u0028\u1107\u0029",
  "\u3206",
  "\u0028\u1109\u0029",
  "\u3207",
  "\u0028\u110B\u0029",
  "\u3208",
  "\u0028\u110C\u0029",
  "\u3209",
  "\u0028\u110E\u0029",
  "\u320A",
  "\u0028\u110F\u0029",
  "\u320B",
  "\u0028\u1110\u0029",
  "\u320C",
  "\u0028\u1111\u0029",
  "\u320D",
  "\u0028\u1112\u0029",
  "\u320E",
  "\u0028\u1100\u1161\u0029",
  "\u320F",
  "\u0028\u1102\u1161\u0029",
  "\u3210",
  "\u0028\u1103\u1161\u0029",
  "\u3211",
  "\u0028\u1105\u1161\u0029",
  "\u3212",
  "\u0028\u1106\u1161\u0029",
  "\u3213",
  "\u0028\u1107\u1161\u0029",
  "\u3214",
  "\u0028\u1109\u1161\u0029",
  "\u3215",
  "\u0028\u110B\u1161\u0029",
  "\u3216",
  "\u0028\u110C\u1161\u0029",
  "\u3217",
  "\u0028\u110E\u1161\u0029",
  "\u3218",
  "\u0028\u110F\u1161\u0029",
  "\u3219",
  "\u0028\u1110\u1161\u0029",
  "\u321A",
  "\u0028\u1111\u1161\u0029",
  "\u321B",
  "\u0028\u1112\u1161\u0029",
  "\u321C",
  "\u0028\u110C\u116E\u0029",
  "\u321D",
  "\u0028\u110B\u1169\u110C\u1165\u11AB\u0029",
  "\u321E",
  "\u0028\u110B\u1169\u1112\u116E\u0029",
  "\u3220",
  "\u0028\u4E00\u0029",
  "\u3221",
  "\u0028\u4E8C\u0029",
  "\u3222",
  "\u0028\u4E09\u0029",
  "\u3223",
  "\u0028\u56DB\u0029",
  "\u3224",
  "\u0028\u4E94\u0029",
  "\u3225",
  "\u0028\u516D\u0029",
  "\u3226",
  "\u0028\u4E03\u0029",
  "\u3227",
  "\u0028\u516B\u0029",
  "\u3228",
  "\u0028\u4E5D\u0029",
  "\u3229",
  "\u0028\u5341\u0029",
  "\u322A",
  "\u0028\u6708\u0029",
  "\u322B",
  "\u0028\u706B\u0029",
  "\u322C",
  "\u0028\u6C34\u0029",
  "\u322D",
  "\u0028\u6728\u0029",
  "\u322E",
  "\u0028\u91D1\u0029",
  "\u322F",
  "\u0028\u571F\u0029",
  "\u3230",
  "\u0028\u65E5\u0029",
  "\u3231",
  "\u0028\u682A\u0029",
  "\u3232",
  "\u0028\u6709\u0029",
  "\u3233",
  "\u0028\u793E\u0029",
  "\u3234",
  "\u0028\u540D\u0029",
  "\u3235",
  "\u0028\u7279\u0029",
  "\u3236",
  "\u0028\u8CA1\u0029",
  "\u3237",
  "\u0028\u795D\u0029",
  "\u3238",
  "\u0028\u52B4\u0029",
  "\u3239",
  "\u0028\u4EE3\u0029",
  "\u323A",
  "\u0028\u547C\u0029",
  "\u323B",
  "\u0028\u5B66\u0029",
  "\u323C",
  "\u0028\u76E3\u0029",
  "\u323D",
  "\u0028\u4F01\u0029",
  "\u323E",
  "\u0028\u8CC7\u0029",
  "\u323F",
  "\u0028\u5354\u0029",
  "\u3240",
  "\u0028\u796D\u0029",
  "\u3241",
  "\u0028\u4F11\u0029",
  "\u3242",
  "\u0028\u81EA\u0029",
  "\u3243",
  "\u0028\u81F3\u0029",
  "\u32C0",
  "\u0031\u6708",
  "\u32C1",
  "\u0032\u6708",
  "\u32C2",
  "\u0033\u6708",
  "\u32C3",
  "\u0034\u6708",
  "\u32C4",
  "\u0035\u6708",
  "\u32C5",
  "\u0036\u6708",
  "\u32C6",
  "\u0037\u6708",
  "\u32C7",
  "\u0038\u6708",
  "\u32C8",
  "\u0039\u6708",
  "\u32C9",
  "\u0031\u0030\u6708",
  "\u32CA",
  "\u0031\u0031\u6708",
  "\u32CB",
  "\u0031\u0032\u6708",
  "\u3358",
  "\u0030\u70B9",
  "\u3359",
  "\u0031\u70B9",
  "\u335A",
  "\u0032\u70B9",
  "\u335B",
  "\u0033\u70B9",
  "\u335C",
  "\u0034\u70B9",
  "\u335D",
  "\u0035\u70B9",
  "\u335E",
  "\u0036\u70B9",
  "\u335F",
  "\u0037\u70B9",
  "\u3360",
  "\u0038\u70B9",
  "\u3361",
  "\u0039\u70B9",
  "\u3362",
  "\u0031\u0030\u70B9",
  "\u3363",
  "\u0031\u0031\u70B9",
  "\u3364",
  "\u0031\u0032\u70B9",
  "\u3365",
  "\u0031\u0033\u70B9",
  "\u3366",
  "\u0031\u0034\u70B9",
  "\u3367",
  "\u0031\u0035\u70B9",
  "\u3368",
  "\u0031\u0036\u70B9",
  "\u3369",
  "\u0031\u0037\u70B9",
  "\u336A",
  "\u0031\u0038\u70B9",
  "\u336B",
  "\u0031\u0039\u70B9",
  "\u336C",
  "\u0032\u0030\u70B9",
  "\u336D",
  "\u0032\u0031\u70B9",
  "\u336E",
  "\u0032\u0032\u70B9",
  "\u336F",
  "\u0032\u0033\u70B9",
  "\u3370",
  "\u0032\u0034\u70B9",
  "\u33E0",
  "\u0031\u65E5",
  "\u33E1",
  "\u0032\u65E5",
  "\u33E2",
  "\u0033\u65E5",
  "\u33E3",
  "\u0034\u65E5",
  "\u33E4",
  "\u0035\u65E5",
  "\u33E5",
  "\u0036\u65E5",
  "\u33E6",
  "\u0037\u65E5",
  "\u33E7",
  "\u0038\u65E5",
  "\u33E8",
  "\u0039\u65E5",
  "\u33E9",
  "\u0031\u0030\u65E5",
  "\u33EA",
  "\u0031\u0031\u65E5",
  "\u33EB",
  "\u0031\u0032\u65E5",
  "\u33EC",
  "\u0031\u0033\u65E5",
  "\u33ED",
  "\u0031\u0034\u65E5",
  "\u33EE",
  "\u0031\u0035\u65E5",
  "\u33EF",
  "\u0031\u0036\u65E5",
  "\u33F0",
  "\u0031\u0037\u65E5",
  "\u33F1",
  "\u0031\u0038\u65E5",
  "\u33F2",
  "\u0031\u0039\u65E5",
  "\u33F3",
  "\u0032\u0030\u65E5",
  "\u33F4",
  "\u0032\u0031\u65E5",
  "\u33F5",
  "\u0032\u0032\u65E5",
  "\u33F6",
  "\u0032\u0033\u65E5",
  "\u33F7",
  "\u0032\u0034\u65E5",
  "\u33F8",
  "\u0032\u0035\u65E5",
  "\u33F9",
  "\u0032\u0036\u65E5",
  "\u33FA",
  "\u0032\u0037\u65E5",
  "\u33FB",
  "\u0032\u0038\u65E5",
  "\u33FC",
  "\u0032\u0039\u65E5",
  "\u33FD",
  "\u0033\u0030\u65E5",
  "\u33FE",
  "\u0033\u0031\u65E5",
  "\uFB00",
  "\u0066\u0066",
  "\uFB01",
  "\u0066\u0069",
  "\uFB02",
  "\u0066\u006C",
  "\uFB03",
  "\u0066\u0066\u0069",
  "\uFB04",
  "\u0066\u0066\u006C",
  "\uFB05",
  "\u017F\u0074",
  "\uFB06",
  "\u0073\u0074",
  "\uFB13",
  "\u0574\u0576",
  "\uFB14",
  "\u0574\u0565",
  "\uFB15",
  "\u0574\u056B",
  "\uFB16",
  "\u057E\u0576",
  "\uFB17",
  "\u0574\u056D",
  "\uFB4F",
  "\u05D0\u05DC",
  "\uFB50",
  "\u0671",
  "\uFB51",
  "\u0671",
  "\uFB52",
  "\u067B",
  "\uFB53",
  "\u067B",
  "\uFB54",
  "\u067B",
  "\uFB55",
  "\u067B",
  "\uFB56",
  "\u067E",
  "\uFB57",
  "\u067E",
  "\uFB58",
  "\u067E",
  "\uFB59",
  "\u067E",
  "\uFB5A",
  "\u0680",
  "\uFB5B",
  "\u0680",
  "\uFB5C",
  "\u0680",
  "\uFB5D",
  "\u0680",
  "\uFB5E",
  "\u067A",
  "\uFB5F",
  "\u067A",
  "\uFB60",
  "\u067A",
  "\uFB61",
  "\u067A",
  "\uFB62",
  "\u067F",
  "\uFB63",
  "\u067F",
  "\uFB64",
  "\u067F",
  "\uFB65",
  "\u067F",
  "\uFB66",
  "\u0679",
  "\uFB67",
  "\u0679",
  "\uFB68",
  "\u0679",
  "\uFB69",
  "\u0679",
  "\uFB6A",
  "\u06A4",
  "\uFB6B",
  "\u06A4",
  "\uFB6C",
  "\u06A4",
  "\uFB6D",
  "\u06A4",
  "\uFB6E",
  "\u06A6",
  "\uFB6F",
  "\u06A6",
  "\uFB70",
  "\u06A6",
  "\uFB71",
  "\u06A6",
  "\uFB72",
  "\u0684",
  "\uFB73",
  "\u0684",
  "\uFB74",
  "\u0684",
  "\uFB75",
  "\u0684",
  "\uFB76",
  "\u0683",
  "\uFB77",
  "\u0683",
  "\uFB78",
  "\u0683",
  "\uFB79",
  "\u0683",
  "\uFB7A",
  "\u0686",
  "\uFB7B",
  "\u0686",
  "\uFB7C",
  "\u0686",
  "\uFB7D",
  "\u0686",
  "\uFB7E",
  "\u0687",
  "\uFB7F",
  "\u0687",
  "\uFB80",
  "\u0687",
  "\uFB81",
  "\u0687",
  "\uFB82",
  "\u068D",
  "\uFB83",
  "\u068D",
  "\uFB84",
  "\u068C",
  "\uFB85",
  "\u068C",
  "\uFB86",
  "\u068E",
  "\uFB87",
  "\u068E",
  "\uFB88",
  "\u0688",
  "\uFB89",
  "\u0688",
  "\uFB8A",
  "\u0698",
  "\uFB8B",
  "\u0698",
  "\uFB8C",
  "\u0691",
  "\uFB8D",
  "\u0691",
  "\uFB8E",
  "\u06A9",
  "\uFB8F",
  "\u06A9",
  "\uFB90",
  "\u06A9",
  "\uFB91",
  "\u06A9",
  "\uFB92",
  "\u06AF",
  "\uFB93",
  "\u06AF",
  "\uFB94",
  "\u06AF",
  "\uFB95",
  "\u06AF",
  "\uFB96",
  "\u06B3",
  "\uFB97",
  "\u06B3",
  "\uFB98",
  "\u06B3",
  "\uFB99",
  "\u06B3",
  "\uFB9A",
  "\u06B1",
  "\uFB9B",
  "\u06B1",
  "\uFB9C",
  "\u06B1",
  "\uFB9D",
  "\u06B1",
  "\uFB9E",
  "\u06BA",
  "\uFB9F",
  "\u06BA",
  "\uFBA0",
  "\u06BB",
  "\uFBA1",
  "\u06BB",
  "\uFBA2",
  "\u06BB",
  "\uFBA3",
  "\u06BB",
  "\uFBA4",
  "\u06C0",
  "\uFBA5",
  "\u06C0",
  "\uFBA6",
  "\u06C1",
  "\uFBA7",
  "\u06C1",
  "\uFBA8",
  "\u06C1",
  "\uFBA9",
  "\u06C1",
  "\uFBAA",
  "\u06BE",
  "\uFBAB",
  "\u06BE",
  "\uFBAC",
  "\u06BE",
  "\uFBAD",
  "\u06BE",
  "\uFBAE",
  "\u06D2",
  "\uFBAF",
  "\u06D2",
  "\uFBB0",
  "\u06D3",
  "\uFBB1",
  "\u06D3",
  "\uFBD3",
  "\u06AD",
  "\uFBD4",
  "\u06AD",
  "\uFBD5",
  "\u06AD",
  "\uFBD6",
  "\u06AD",
  "\uFBD7",
  "\u06C7",
  "\uFBD8",
  "\u06C7",
  "\uFBD9",
  "\u06C6",
  "\uFBDA",
  "\u06C6",
  "\uFBDB",
  "\u06C8",
  "\uFBDC",
  "\u06C8",
  "\uFBDD",
  "\u0677",
  "\uFBDE",
  "\u06CB",
  "\uFBDF",
  "\u06CB",
  "\uFBE0",
  "\u06C5",
  "\uFBE1",
  "\u06C5",
  "\uFBE2",
  "\u06C9",
  "\uFBE3",
  "\u06C9",
  "\uFBE4",
  "\u06D0",
  "\uFBE5",
  "\u06D0",
  "\uFBE6",
  "\u06D0",
  "\uFBE7",
  "\u06D0",
  "\uFBE8",
  "\u0649",
  "\uFBE9",
  "\u0649",
  "\uFBEA",
  "\u0626\u0627",
  "\uFBEB",
  "\u0626\u0627",
  "\uFBEC",
  "\u0626\u06D5",
  "\uFBED",
  "\u0626\u06D5",
  "\uFBEE",
  "\u0626\u0648",
  "\uFBEF",
  "\u0626\u0648",
  "\uFBF0",
  "\u0626\u06C7",
  "\uFBF1",
  "\u0626\u06C7",
  "\uFBF2",
  "\u0626\u06C6",
  "\uFBF3",
  "\u0626\u06C6",
  "\uFBF4",
  "\u0626\u06C8",
  "\uFBF5",
  "\u0626\u06C8",
  "\uFBF6",
  "\u0626\u06D0",
  "\uFBF7",
  "\u0626\u06D0",
  "\uFBF8",
  "\u0626\u06D0",
  "\uFBF9",
  "\u0626\u0649",
  "\uFBFA",
  "\u0626\u0649",
  "\uFBFB",
  "\u0626\u0649",
  "\uFBFC",
  "\u06CC",
  "\uFBFD",
  "\u06CC",
  "\uFBFE",
  "\u06CC",
  "\uFBFF",
  "\u06CC",
  "\uFC00",
  "\u0626\u062C",
  "\uFC01",
  "\u0626\u062D",
  "\uFC02",
  "\u0626\u0645",
  "\uFC03",
  "\u0626\u0649",
  "\uFC04",
  "\u0626\u064A",
  "\uFC05",
  "\u0628\u062C",
  "\uFC06",
  "\u0628\u062D",
  "\uFC07",
  "\u0628\u062E",
  "\uFC08",
  "\u0628\u0645",
  "\uFC09",
  "\u0628\u0649",
  "\uFC0A",
  "\u0628\u064A",
  "\uFC0B",
  "\u062A\u062C",
  "\uFC0C",
  "\u062A\u062D",
  "\uFC0D",
  "\u062A\u062E",
  "\uFC0E",
  "\u062A\u0645",
  "\uFC0F",
  "\u062A\u0649",
  "\uFC10",
  "\u062A\u064A",
  "\uFC11",
  "\u062B\u062C",
  "\uFC12",
  "\u062B\u0645",
  "\uFC13",
  "\u062B\u0649",
  "\uFC14",
  "\u062B\u064A",
  "\uFC15",
  "\u062C\u062D",
  "\uFC16",
  "\u062C\u0645",
  "\uFC17",
  "\u062D\u062C",
  "\uFC18",
  "\u062D\u0645",
  "\uFC19",
  "\u062E\u062C",
  "\uFC1A",
  "\u062E\u062D",
  "\uFC1B",
  "\u062E\u0645",
  "\uFC1C",
  "\u0633\u062C",
  "\uFC1D",
  "\u0633\u062D",
  "\uFC1E",
  "\u0633\u062E",
  "\uFC1F",
  "\u0633\u0645",
  "\uFC20",
  "\u0635\u062D",
  "\uFC21",
  "\u0635\u0645",
  "\uFC22",
  "\u0636\u062C",
  "\uFC23",
  "\u0636\u062D",
  "\uFC24",
  "\u0636\u062E",
  "\uFC25",
  "\u0636\u0645",
  "\uFC26",
  "\u0637\u062D",
  "\uFC27",
  "\u0637\u0645",
  "\uFC28",
  "\u0638\u0645",
  "\uFC29",
  "\u0639\u062C",
  "\uFC2A",
  "\u0639\u0645",
  "\uFC2B",
  "\u063A\u062C",
  "\uFC2C",
  "\u063A\u0645",
  "\uFC2D",
  "\u0641\u062C",
  "\uFC2E",
  "\u0641\u062D",
  "\uFC2F",
  "\u0641\u062E",
  "\uFC30",
  "\u0641\u0645",
  "\uFC31",
  "\u0641\u0649",
  "\uFC32",
  "\u0641\u064A",
  "\uFC33",
  "\u0642\u062D",
  "\uFC34",
  "\u0642\u0645",
  "\uFC35",
  "\u0642\u0649",
  "\uFC36",
  "\u0642\u064A",
  "\uFC37",
  "\u0643\u0627",
  "\uFC38",
  "\u0643\u062C",
  "\uFC39",
  "\u0643\u062D",
  "\uFC3A",
  "\u0643\u062E",
  "\uFC3B",
  "\u0643\u0644",
  "\uFC3C",
  "\u0643\u0645",
  "\uFC3D",
  "\u0643\u0649",
  "\uFC3E",
  "\u0643\u064A",
  "\uFC3F",
  "\u0644\u062C",
  "\uFC40",
  "\u0644\u062D",
  "\uFC41",
  "\u0644\u062E",
  "\uFC42",
  "\u0644\u0645",
  "\uFC43",
  "\u0644\u0649",
  "\uFC44",
  "\u0644\u064A",
  "\uFC45",
  "\u0645\u062C",
  "\uFC46",
  "\u0645\u062D",
  "\uFC47",
  "\u0645\u062E",
  "\uFC48",
  "\u0645\u0645",
  "\uFC49",
  "\u0645\u0649",
  "\uFC4A",
  "\u0645\u064A",
  "\uFC4B",
  "\u0646\u062C",
  "\uFC4C",
  "\u0646\u062D",
  "\uFC4D",
  "\u0646\u062E",
  "\uFC4E",
  "\u0646\u0645",
  "\uFC4F",
  "\u0646\u0649",
  "\uFC50",
  "\u0646\u064A",
  "\uFC51",
  "\u0647\u062C",
  "\uFC52",
  "\u0647\u0645",
  "\uFC53",
  "\u0647\u0649",
  "\uFC54",
  "\u0647\u064A",
  "\uFC55",
  "\u064A\u062C",
  "\uFC56",
  "\u064A\u062D",
  "\uFC57",
  "\u064A\u062E",
  "\uFC58",
  "\u064A\u0645",
  "\uFC59",
  "\u064A\u0649",
  "\uFC5A",
  "\u064A\u064A",
  "\uFC5B",
  "\u0630\u0670",
  "\uFC5C",
  "\u0631\u0670",
  "\uFC5D",
  "\u0649\u0670",
  "\uFC5E",
  "\u0020\u064C\u0651",
  "\uFC5F",
  "\u0020\u064D\u0651",
  "\uFC60",
  "\u0020\u064E\u0651",
  "\uFC61",
  "\u0020\u064F\u0651",
  "\uFC62",
  "\u0020\u0650\u0651",
  "\uFC63",
  "\u0020\u0651\u0670",
  "\uFC64",
  "\u0626\u0631",
  "\uFC65",
  "\u0626\u0632",
  "\uFC66",
  "\u0626\u0645",
  "\uFC67",
  "\u0626\u0646",
  "\uFC68",
  "\u0626\u0649",
  "\uFC69",
  "\u0626\u064A",
  "\uFC6A",
  "\u0628\u0631",
  "\uFC6B",
  "\u0628\u0632",
  "\uFC6C",
  "\u0628\u0645",
  "\uFC6D",
  "\u0628\u0646",
  "\uFC6E",
  "\u0628\u0649",
  "\uFC6F",
  "\u0628\u064A",
  "\uFC70",
  "\u062A\u0631",
  "\uFC71",
  "\u062A\u0632",
  "\uFC72",
  "\u062A\u0645",
  "\uFC73",
  "\u062A\u0646",
  "\uFC74",
  "\u062A\u0649",
  "\uFC75",
  "\u062A\u064A",
  "\uFC76",
  "\u062B\u0631",
  "\uFC77",
  "\u062B\u0632",
  "\uFC78",
  "\u062B\u0645",
  "\uFC79",
  "\u062B\u0646",
  "\uFC7A",
  "\u062B\u0649",
  "\uFC7B",
  "\u062B\u064A",
  "\uFC7C",
  "\u0641\u0649",
  "\uFC7D",
  "\u0641\u064A",
  "\uFC7E",
  "\u0642\u0649",
  "\uFC7F",
  "\u0642\u064A",
  "\uFC80",
  "\u0643\u0627",
  "\uFC81",
  "\u0643\u0644",
  "\uFC82",
  "\u0643\u0645",
  "\uFC83",
  "\u0643\u0649",
  "\uFC84",
  "\u0643\u064A",
  "\uFC85",
  "\u0644\u0645",
  "\uFC86",
  "\u0644\u0649",
  "\uFC87",
  "\u0644\u064A",
  "\uFC88",
  "\u0645\u0627",
  "\uFC89",
  "\u0645\u0645",
  "\uFC8A",
  "\u0646\u0631",
  "\uFC8B",
  "\u0646\u0632",
  "\uFC8C",
  "\u0646\u0645",
  "\uFC8D",
  "\u0646\u0646",
  "\uFC8E",
  "\u0646\u0649",
  "\uFC8F",
  "\u0646\u064A",
  "\uFC90",
  "\u0649\u0670",
  "\uFC91",
  "\u064A\u0631",
  "\uFC92",
  "\u064A\u0632",
  "\uFC93",
  "\u064A\u0645",
  "\uFC94",
  "\u064A\u0646",
  "\uFC95",
  "\u064A\u0649",
  "\uFC96",
  "\u064A\u064A",
  "\uFC97",
  "\u0626\u062C",
  "\uFC98",
  "\u0626\u062D",
  "\uFC99",
  "\u0626\u062E",
  "\uFC9A",
  "\u0626\u0645",
  "\uFC9B",
  "\u0626\u0647",
  "\uFC9C",
  "\u0628\u062C",
  "\uFC9D",
  "\u0628\u062D",
  "\uFC9E",
  "\u0628\u062E",
  "\uFC9F",
  "\u0628\u0645",
  "\uFCA0",
  "\u0628\u0647",
  "\uFCA1",
  "\u062A\u062C",
  "\uFCA2",
  "\u062A\u062D",
  "\uFCA3",
  "\u062A\u062E",
  "\uFCA4",
  "\u062A\u0645",
  "\uFCA5",
  "\u062A\u0647",
  "\uFCA6",
  "\u062B\u0645",
  "\uFCA7",
  "\u062C\u062D",
  "\uFCA8",
  "\u062C\u0645",
  "\uFCA9",
  "\u062D\u062C",
  "\uFCAA",
  "\u062D\u0645",
  "\uFCAB",
  "\u062E\u062C",
  "\uFCAC",
  "\u062E\u0645",
  "\uFCAD",
  "\u0633\u062C",
  "\uFCAE",
  "\u0633\u062D",
  "\uFCAF",
  "\u0633\u062E",
  "\uFCB0",
  "\u0633\u0645",
  "\uFCB1",
  "\u0635\u062D",
  "\uFCB2",
  "\u0635\u062E",
  "\uFCB3",
  "\u0635\u0645",
  "\uFCB4",
  "\u0636\u062C",
  "\uFCB5",
  "\u0636\u062D",
  "\uFCB6",
  "\u0636\u062E",
  "\uFCB7",
  "\u0636\u0645",
  "\uFCB8",
  "\u0637\u062D",
  "\uFCB9",
  "\u0638\u0645",
  "\uFCBA",
  "\u0639\u062C",
  "\uFCBB",
  "\u0639\u0645",
  "\uFCBC",
  "\u063A\u062C",
  "\uFCBD",
  "\u063A\u0645",
  "\uFCBE",
  "\u0641\u062C",
  "\uFCBF",
  "\u0641\u062D",
  "\uFCC0",
  "\u0641\u062E",
  "\uFCC1",
  "\u0641\u0645",
  "\uFCC2",
  "\u0642\u062D",
  "\uFCC3",
  "\u0642\u0645",
  "\uFCC4",
  "\u0643\u062C",
  "\uFCC5",
  "\u0643\u062D",
  "\uFCC6",
  "\u0643\u062E",
  "\uFCC7",
  "\u0643\u0644",
  "\uFCC8",
  "\u0643\u0645",
  "\uFCC9",
  "\u0644\u062C",
  "\uFCCA",
  "\u0644\u062D",
  "\uFCCB",
  "\u0644\u062E",
  "\uFCCC",
  "\u0644\u0645",
  "\uFCCD",
  "\u0644\u0647",
  "\uFCCE",
  "\u0645\u062C",
  "\uFCCF",
  "\u0645\u062D",
  "\uFCD0",
  "\u0645\u062E",
  "\uFCD1",
  "\u0645\u0645",
  "\uFCD2",
  "\u0646\u062C",
  "\uFCD3",
  "\u0646\u062D",
  "\uFCD4",
  "\u0646\u062E",
  "\uFCD5",
  "\u0646\u0645",
  "\uFCD6",
  "\u0646\u0647",
  "\uFCD7",
  "\u0647\u062C",
  "\uFCD8",
  "\u0647\u0645",
  "\uFCD9",
  "\u0647\u0670",
  "\uFCDA",
  "\u064A\u062C",
  "\uFCDB",
  "\u064A\u062D",
  "\uFCDC",
  "\u064A\u062E",
  "\uFCDD",
  "\u064A\u0645",
  "\uFCDE",
  "\u064A\u0647",
  "\uFCDF",
  "\u0626\u0645",
  "\uFCE0",
  "\u0626\u0647",
  "\uFCE1",
  "\u0628\u0645",
  "\uFCE2",
  "\u0628\u0647",
  "\uFCE3",
  "\u062A\u0645",
  "\uFCE4",
  "\u062A\u0647",
  "\uFCE5",
  "\u062B\u0645",
  "\uFCE6",
  "\u062B\u0647",
  "\uFCE7",
  "\u0633\u0645",
  "\uFCE8",
  "\u0633\u0647",
  "\uFCE9",
  "\u0634\u0645",
  "\uFCEA",
  "\u0634\u0647",
  "\uFCEB",
  "\u0643\u0644",
  "\uFCEC",
  "\u0643\u0645",
  "\uFCED",
  "\u0644\u0645",
  "\uFCEE",
  "\u0646\u0645",
  "\uFCEF",
  "\u0646\u0647",
  "\uFCF0",
  "\u064A\u0645",
  "\uFCF1",
  "\u064A\u0647",
  "\uFCF2",
  "\u0640\u064E\u0651",
  "\uFCF3",
  "\u0640\u064F\u0651",
  "\uFCF4",
  "\u0640\u0650\u0651",
  "\uFCF5",
  "\u0637\u0649",
  "\uFCF6",
  "\u0637\u064A",
  "\uFCF7",
  "\u0639\u0649",
  "\uFCF8",
  "\u0639\u064A",
  "\uFCF9",
  "\u063A\u0649",
  "\uFCFA",
  "\u063A\u064A",
  "\uFCFB",
  "\u0633\u0649",
  "\uFCFC",
  "\u0633\u064A",
  "\uFCFD",
  "\u0634\u0649",
  "\uFCFE",
  "\u0634\u064A",
  "\uFCFF",
  "\u062D\u0649",
  "\uFD00",
  "\u062D\u064A",
  "\uFD01",
  "\u062C\u0649",
  "\uFD02",
  "\u062C\u064A",
  "\uFD03",
  "\u062E\u0649",
  "\uFD04",
  "\u062E\u064A",
  "\uFD05",
  "\u0635\u0649",
  "\uFD06",
  "\u0635\u064A",
  "\uFD07",
  "\u0636\u0649",
  "\uFD08",
  "\u0636\u064A",
  "\uFD09",
  "\u0634\u062C",
  "\uFD0A",
  "\u0634\u062D",
  "\uFD0B",
  "\u0634\u062E",
  "\uFD0C",
  "\u0634\u0645",
  "\uFD0D",
  "\u0634\u0631",
  "\uFD0E",
  "\u0633\u0631",
  "\uFD0F",
  "\u0635\u0631",
  "\uFD10",
  "\u0636\u0631",
  "\uFD11",
  "\u0637\u0649",
  "\uFD12",
  "\u0637\u064A",
  "\uFD13",
  "\u0639\u0649",
  "\uFD14",
  "\u0639\u064A",
  "\uFD15",
  "\u063A\u0649",
  "\uFD16",
  "\u063A\u064A",
  "\uFD17",
  "\u0633\u0649",
  "\uFD18",
  "\u0633\u064A",
  "\uFD19",
  "\u0634\u0649",
  "\uFD1A",
  "\u0634\u064A",
  "\uFD1B",
  "\u062D\u0649",
  "\uFD1C",
  "\u062D\u064A",
  "\uFD1D",
  "\u062C\u0649",
  "\uFD1E",
  "\u062C\u064A",
  "\uFD1F",
  "\u062E\u0649",
  "\uFD20",
  "\u062E\u064A",
  "\uFD21",
  "\u0635\u0649",
  "\uFD22",
  "\u0635\u064A",
  "\uFD23",
  "\u0636\u0649",
  "\uFD24",
  "\u0636\u064A",
  "\uFD25",
  "\u0634\u062C",
  "\uFD26",
  "\u0634\u062D",
  "\uFD27",
  "\u0634\u062E",
  "\uFD28",
  "\u0634\u0645",
  "\uFD29",
  "\u0634\u0631",
  "\uFD2A",
  "\u0633\u0631",
  "\uFD2B",
  "\u0635\u0631",
  "\uFD2C",
  "\u0636\u0631",
  "\uFD2D",
  "\u0634\u062C",
  "\uFD2E",
  "\u0634\u062D",
  "\uFD2F",
  "\u0634\u062E",
  "\uFD30",
  "\u0634\u0645",
  "\uFD31",
  "\u0633\u0647",
  "\uFD32",
  "\u0634\u0647",
  "\uFD33",
  "\u0637\u0645",
  "\uFD34",
  "\u0633\u062C",
  "\uFD35",
  "\u0633\u062D",
  "\uFD36",
  "\u0633\u062E",
  "\uFD37",
  "\u0634\u062C",
  "\uFD38",
  "\u0634\u062D",
  "\uFD39",
  "\u0634\u062E",
  "\uFD3A",
  "\u0637\u0645",
  "\uFD3B",
  "\u0638\u0645",
  "\uFD3C",
  "\u0627\u064B",
  "\uFD3D",
  "\u0627\u064B",
  "\uFD50",
  "\u062A\u062C\u0645",
  "\uFD51",
  "\u062A\u062D\u062C",
  "\uFD52",
  "\u062A\u062D\u062C",
  "\uFD53",
  "\u062A\u062D\u0645",
  "\uFD54",
  "\u062A\u062E\u0645",
  "\uFD55",
  "\u062A\u0645\u062C",
  "\uFD56",
  "\u062A\u0645\u062D",
  "\uFD57",
  "\u062A\u0645\u062E",
  "\uFD58",
  "\u062C\u0645\u062D",
  "\uFD59",
  "\u062C\u0645\u062D",
  "\uFD5A",
  "\u062D\u0645\u064A",
  "\uFD5B",
  "\u062D\u0645\u0649",
  "\uFD5C",
  "\u0633\u062D\u062C",
  "\uFD5D",
  "\u0633\u062C\u062D",
  "\uFD5E",
  "\u0633\u062C\u0649",
  "\uFD5F",
  "\u0633\u0645\u062D",
  "\uFD60",
  "\u0633\u0645\u062D",
  "\uFD61",
  "\u0633\u0645\u062C",
  "\uFD62",
  "\u0633\u0645\u0645",
  "\uFD63",
  "\u0633\u0645\u0645",
  "\uFD64",
  "\u0635\u062D\u062D",
  "\uFD65",
  "\u0635\u062D\u062D",
  "\uFD66",
  "\u0635\u0645\u0645",
  "\uFD67",
  "\u0634\u062D\u0645",
  "\uFD68",
  "\u0634\u062D\u0645",
  "\uFD69",
  "\u0634\u062C\u064A",
  "\uFD6A",
  "\u0634\u0645\u062E",
  "\uFD6B",
  "\u0634\u0645\u062E",
  "\uFD6C",
  "\u0634\u0645\u0645",
  "\uFD6D",
  "\u0634\u0645\u0645",
  "\uFD6E",
  "\u0636\u062D\u0649",
  "\uFD6F",
  "\u0636\u062E\u0645",
  "\uFD70",
  "\u0636\u062E\u0645",
  "\uFD71",
  "\u0637\u0645\u062D",
  "\uFD72",
  "\u0637\u0645\u062D",
  "\uFD73",
  "\u0637\u0645\u0645",
  "\uFD74",
  "\u0637\u0645\u064A",
  "\uFD75",
  "\u0639\u062C\u0645",
  "\uFD76",
  "\u0639\u0645\u0645",
  "\uFD77",
  "\u0639\u0645\u0645",
  "\uFD78",
  "\u0639\u0645\u0649",
  "\uFD79",
  "\u063A\u0645\u0645",
  "\uFD7A",
  "\u063A\u0645\u064A",
  "\uFD7B",
  "\u063A\u0645\u0649",
  "\uFD7C",
  "\u0641\u062E\u0645",
  "\uFD7D",
  "\u0641\u062E\u0645",
  "\uFD7E",
  "\u0642\u0645\u062D",
  "\uFD7F",
  "\u0642\u0645\u0645",
  "\uFD80",
  "\u0644\u062D\u0645",
  "\uFD81",
  "\u0644\u062D\u064A",
  "\uFD82",
  "\u0644\u062D\u0649",
  "\uFD83",
  "\u0644\u062C\u062C",
  "\uFD84",
  "\u0644\u062C\u062C",
  "\uFD85",
  "\u0644\u062E\u0645",
  "\uFD86",
  "\u0644\u062E\u0645",
  "\uFD87",
  "\u0644\u0645\u062D",
  "\uFD88",
  "\u0644\u0645\u062D",
  "\uFD89",
  "\u0645\u062D\u062C",
  "\uFD8A",
  "\u0645\u062D\u0645",
  "\uFD8B",
  "\u0645\u062D\u064A",
  "\uFD8C",
  "\u0645\u062C\u062D",
  "\uFD8D",
  "\u0645\u062C\u0645",
  "\uFD8E",
  "\u0645\u062E\u062C",
  "\uFD8F",
  "\u0645\u062E\u0645",
  "\uFD92",
  "\u0645\u062C\u062E",
  "\uFD93",
  "\u0647\u0645\u062C",
  "\uFD94",
  "\u0647\u0645\u0645",
  "\uFD95",
  "\u0646\u062D\u0645",
  "\uFD96",
  "\u0646\u062D\u0649",
  "\uFD97",
  "\u0646\u062C\u0645",
  "\uFD98",
  "\u0646\u062C\u0645",
  "\uFD99",
  "\u0646\u062C\u0649",
  "\uFD9A",
  "\u0646\u0645\u064A",
  "\uFD9B",
  "\u0646\u0645\u0649",
  "\uFD9C",
  "\u064A\u0645\u0645",
  "\uFD9D",
  "\u064A\u0645\u0645",
  "\uFD9E",
  "\u0628\u062E\u064A",
  "\uFD9F",
  "\u062A\u062C\u064A",
  "\uFDA0",
  "\u062A\u062C\u0649",
  "\uFDA1",
  "\u062A\u062E\u064A",
  "\uFDA2",
  "\u062A\u062E\u0649",
  "\uFDA3",
  "\u062A\u0645\u064A",
  "\uFDA4",
  "\u062A\u0645\u0649",
  "\uFDA5",
  "\u062C\u0645\u064A",
  "\uFDA6",
  "\u062C\u062D\u0649",
  "\uFDA7",
  "\u062C\u0645\u0649",
  "\uFDA8",
  "\u0633\u062E\u0649",
  "\uFDA9",
  "\u0635\u062D\u064A",
  "\uFDAA",
  "\u0634\u062D\u064A",
  "\uFDAB",
  "\u0636\u062D\u064A",
  "\uFDAC",
  "\u0644\u062C\u064A",
  "\uFDAD",
  "\u0644\u0645\u064A",
  "\uFDAE",
  "\u064A\u062D\u064A",
  "\uFDAF",
  "\u064A\u062C\u064A",
  "\uFDB0",
  "\u064A\u0645\u064A",
  "\uFDB1",
  "\u0645\u0645\u064A",
  "\uFDB2",
  "\u0642\u0645\u064A",
  "\uFDB3",
  "\u0646\u062D\u064A",
  "\uFDB4",
  "\u0642\u0645\u062D",
  "\uFDB5",
  "\u0644\u062D\u0645",
  "\uFDB6",
  "\u0639\u0645\u064A",
  "\uFDB7",
  "\u0643\u0645\u064A",
  "\uFDB8",
  "\u0646\u062C\u062D",
  "\uFDB9",
  "\u0645\u062E\u064A",
  "\uFDBA",
  "\u0644\u062C\u0645",
  "\uFDBB",
  "\u0643\u0645\u0645",
  "\uFDBC",
  "\u0644\u062C\u0645",
  "\uFDBD",
  "\u0646\u062C\u062D",
  "\uFDBE",
  "\u062C\u062D\u064A",
  "\uFDBF",
  "\u062D\u062C\u064A",
  "\uFDC0",
  "\u0645\u062C\u064A",
  "\uFDC1",
  "\u0641\u0645\u064A",
  "\uFDC2",
  "\u0628\u062D\u064A",
  "\uFDC3",
  "\u0643\u0645\u0645",
  "\uFDC4",
  "\u0639\u062C\u0645",
  "\uFDC5",
  "\u0635\u0645\u0645",
  "\uFDC6",
  "\u0633\u062E\u064A",
  "\uFDC7",
  "\u0646\u062C\u064A",
  "\uFE49",
  "\u203E",
  "\uFE4A",
  "\u203E",
  "\uFE4B",
  "\u203E",
  "\uFE4C",
  "\u203E",
  "\uFE4D",
  "\u005F",
  "\uFE4E",
  "\u005F",
  "\uFE4F",
  "\u005F",
  "\uFE80",
  "\u0621",
  "\uFE81",
  "\u0622",
  "\uFE82",
  "\u0622",
  "\uFE83",
  "\u0623",
  "\uFE84",
  "\u0623",
  "\uFE85",
  "\u0624",
  "\uFE86",
  "\u0624",
  "\uFE87",
  "\u0625",
  "\uFE88",
  "\u0625",
  "\uFE89",
  "\u0626",
  "\uFE8A",
  "\u0626",
  "\uFE8B",
  "\u0626",
  "\uFE8C",
  "\u0626",
  "\uFE8D",
  "\u0627",
  "\uFE8E",
  "\u0627",
  "\uFE8F",
  "\u0628",
  "\uFE90",
  "\u0628",
  "\uFE91",
  "\u0628",
  "\uFE92",
  "\u0628",
  "\uFE93",
  "\u0629",
  "\uFE94",
  "\u0629",
  "\uFE95",
  "\u062A",
  "\uFE96",
  "\u062A",
  "\uFE97",
  "\u062A",
  "\uFE98",
  "\u062A",
  "\uFE99",
  "\u062B",
  "\uFE9A",
  "\u062B",
  "\uFE9B",
  "\u062B",
  "\uFE9C",
  "\u062B",
  "\uFE9D",
  "\u062C",
  "\uFE9E",
  "\u062C",
  "\uFE9F",
  "\u062C",
  "\uFEA0",
  "\u062C",
  "\uFEA1",
  "\u062D",
  "\uFEA2",
  "\u062D",
  "\uFEA3",
  "\u062D",
  "\uFEA4",
  "\u062D",
  "\uFEA5",
  "\u062E",
  "\uFEA6",
  "\u062E",
  "\uFEA7",
  "\u062E",
  "\uFEA8",
  "\u062E",
  "\uFEA9",
  "\u062F",
  "\uFEAA",
  "\u062F",
  "\uFEAB",
  "\u0630",
  "\uFEAC",
  "\u0630",
  "\uFEAD",
  "\u0631",
  "\uFEAE",
  "\u0631",
  "\uFEAF",
  "\u0632",
  "\uFEB0",
  "\u0632",
  "\uFEB1",
  "\u0633",
  "\uFEB2",
  "\u0633",
  "\uFEB3",
  "\u0633",
  "\uFEB4",
  "\u0633",
  "\uFEB5",
  "\u0634",
  "\uFEB6",
  "\u0634",
  "\uFEB7",
  "\u0634",
  "\uFEB8",
  "\u0634",
  "\uFEB9",
  "\u0635",
  "\uFEBA",
  "\u0635",
  "\uFEBB",
  "\u0635",
  "\uFEBC",
  "\u0635",
  "\uFEBD",
  "\u0636",
  "\uFEBE",
  "\u0636",
  "\uFEBF",
  "\u0636",
  "\uFEC0",
  "\u0636",
  "\uFEC1",
  "\u0637",
  "\uFEC2",
  "\u0637",
  "\uFEC3",
  "\u0637",
  "\uFEC4",
  "\u0637",
  "\uFEC5",
  "\u0638",
  "\uFEC6",
  "\u0638",
  "\uFEC7",
  "\u0638",
  "\uFEC8",
  "\u0638",
  "\uFEC9",
  "\u0639",
  "\uFECA",
  "\u0639",
  "\uFECB",
  "\u0639",
  "\uFECC",
  "\u0639",
  "\uFECD",
  "\u063A",
  "\uFECE",
  "\u063A",
  "\uFECF",
  "\u063A",
  "\uFED0",
  "\u063A",
  "\uFED1",
  "\u0641",
  "\uFED2",
  "\u0641",
  "\uFED3",
  "\u0641",
  "\uFED4",
  "\u0641",
  "\uFED5",
  "\u0642",
  "\uFED6",
  "\u0642",
  "\uFED7",
  "\u0642",
  "\uFED8",
  "\u0642",
  "\uFED9",
  "\u0643",
  "\uFEDA",
  "\u0643",
  "\uFEDB",
  "\u0643",
  "\uFEDC",
  "\u0643",
  "\uFEDD",
  "\u0644",
  "\uFEDE",
  "\u0644",
  "\uFEDF",
  "\u0644",
  "\uFEE0",
  "\u0644",
  "\uFEE1",
  "\u0645",
  "\uFEE2",
  "\u0645",
  "\uFEE3",
  "\u0645",
  "\uFEE4",
  "\u0645",
  "\uFEE5",
  "\u0646",
  "\uFEE6",
  "\u0646",
  "\uFEE7",
  "\u0646",
  "\uFEE8",
  "\u0646",
  "\uFEE9",
  "\u0647",
  "\uFEEA",
  "\u0647",
  "\uFEEB",
  "\u0647",
  "\uFEEC",
  "\u0647",
  "\uFEED",
  "\u0648",
  "\uFEEE",
  "\u0648",
  "\uFEEF",
  "\u0649",
  "\uFEF0",
  "\u0649",
  "\uFEF1",
  "\u064A",
  "\uFEF2",
  "\u064A",
  "\uFEF3",
  "\u064A",
  "\uFEF4",
  "\u064A",
  "\uFEF5",
  "\u0644\u0622",
  "\uFEF6",
  "\u0644\u0622",
  "\uFEF7",
  "\u0644\u0623",
  "\uFEF8",
  "\u0644\u0623",
  "\uFEF9",
  "\u0644\u0625",
  "\uFEFA",
  "\u0644\u0625",
  "\uFEFB",
  "\u0644\u0627",
  "\uFEFC",
  "\u0644\u0627"
 ];
});
function reverseIfRtl(chars) {
 const charsLength = chars.length;
 if (charsLength <= 1 || !isRTLRangeFor(chars.charCodeAt(0))) {
  return chars;
 }
 const buf = [];
 for (let ii = charsLength - 1; ii >= 0; ii--) {
  buf.push(chars[ii]);
 }
 return buf.join("");
}
const SpecialCharRegExp = new RegExp("^(\\s)|(\\p{Mn})|(\\p{Cf})$", "u");
const CategoryCache = new Map();
function getCharUnicodeCategory(char) {
 const cachedCategory = CategoryCache.get(char);
 if (cachedCategory) {
  return cachedCategory;
 }
 const groups = char.match(SpecialCharRegExp);
 const category = {
  isWhitespace: !!(groups && groups[1]),
  isZeroWidthDiacritic: !!(groups && groups[2]),
  isInvisibleFormatMark: !!(groups && groups[3])
 };
 CategoryCache.set(char, category);
 return category;
}
function clearUnicodeCaches() {
 CategoryCache.clear();
}


/***/ }),
/* 164 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MarkupAnnotation = exports.AnnotationFactory = exports.AnnotationBorderStyle = exports.Annotation = void 0;
exports.getQuadPoints = getQuadPoints;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _core_utils = __w_pdfjs_require__(150);

var _default_appearance = __w_pdfjs_require__(165);

var _primitives = __w_pdfjs_require__(147);

var _base_stream = __w_pdfjs_require__(151);

var _bidi = __w_pdfjs_require__(202);

var _catalog = __w_pdfjs_require__(206);

var _colorspace = __w_pdfjs_require__(166);

var _file_spec = __w_pdfjs_require__(209);

var _object_loader = __w_pdfjs_require__(213);

var _operator_list = __w_pdfjs_require__(204);

var _stream = __w_pdfjs_require__(152);

var _writer = __w_pdfjs_require__(214);

var _factory = __w_pdfjs_require__(217);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var AnnotationFactory = /*#__PURE__*/function () {
  function AnnotationFactory() {
    _classCallCheck(this, AnnotationFactory);
  }

  _createClass(AnnotationFactory, null, [{
    key: "create",
    value: function create(xref, ref, pdfManager, idFactory, collectFields) {
      var _this = this;

      return Promise.all([pdfManager.ensureCatalog("acroForm"), collectFields ? this._getPageIndex(xref, ref, pdfManager) : -1]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            acroForm = _ref2[0],
            pageIndex = _ref2[1];

        return pdfManager.ensure(_this, "_create", [xref, ref, pdfManager, idFactory, acroForm, collectFields, pageIndex]);
      });
    }
  }, {
    key: "_create",
    value: function _create(xref, ref, pdfManager, idFactory, acroForm, collectFields) {
      var pageIndex = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : -1;
      var dict = xref.fetchIfRef(ref);

      if (!(dict instanceof _primitives.Dict)) {
        return undefined;
      }

      var id = ref instanceof _primitives.Ref ? ref.toString() : "annot_".concat(idFactory.createObjId());
      var subtype = dict.get("Subtype");
      subtype = subtype instanceof _primitives.Name ? subtype.name : null;
      var parameters = {
        xref: xref,
        ref: ref,
        dict: dict,
        subtype: subtype,
        id: id,
        pdfManager: pdfManager,
        acroForm: acroForm instanceof _primitives.Dict ? acroForm : _primitives.Dict.empty,
        collectFields: collectFields,
        pageIndex: pageIndex
      };

      switch (subtype) {
        case "Link":
          return new LinkAnnotation(parameters);

        case "Text":
          return new TextAnnotation(parameters);

        case "Widget":
          var fieldType = (0, _core_utils.getInheritableProperty)({
            dict: dict,
            key: "FT"
          });
          fieldType = fieldType instanceof _primitives.Name ? fieldType.name : null;

          switch (fieldType) {
            case "Tx":
              return new TextWidgetAnnotation(parameters);

            case "Btn":
              return new ButtonWidgetAnnotation(parameters);

            case "Ch":
              return new ChoiceWidgetAnnotation(parameters);

            case "Sig":
              return new SignatureWidgetAnnotation(parameters);
          }

          (0, _util.warn)("Unimplemented widget field type \"".concat(fieldType, "\", ") + "falling back to base field type.");
          return new WidgetAnnotation(parameters);

        case "Popup":
          return new PopupAnnotation(parameters);

        case "FreeText":
          return new FreeTextAnnotation(parameters);

        case "Line":
          return new LineAnnotation(parameters);

        case "Square":
          return new SquareAnnotation(parameters);

        case "Circle":
          return new CircleAnnotation(parameters);

        case "PolyLine":
          return new PolylineAnnotation(parameters);

        case "Polygon":
          return new PolygonAnnotation(parameters);

        case "Caret":
          return new CaretAnnotation(parameters);

        case "Ink":
          return new InkAnnotation(parameters);

        case "Highlight":
          return new HighlightAnnotation(parameters);

        case "Underline":
          return new UnderlineAnnotation(parameters);

        case "Squiggly":
          return new SquigglyAnnotation(parameters);

        case "StrikeOut":
          return new StrikeOutAnnotation(parameters);

        case "Stamp":
          return new StampAnnotation(parameters);

        case "FileAttachment":
          return new FileAttachmentAnnotation(parameters);

        default:
          if (!collectFields) {
            if (!subtype) {
              (0, _util.warn)("Annotation is missing the required /Subtype.");
            } else {
              (0, _util.warn)("Unimplemented annotation type \"".concat(subtype, "\", ") + "falling back to base annotation.");
            }
          }

          return new Annotation(parameters);
      }
    }
  }, {
    key: "_getPageIndex",
    value: function () {
      var _getPageIndex2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(xref, ref, pdfManager) {
        var annotDict, pageRef, pageIndex;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return xref.fetchIfRefAsync(ref);

              case 3:
                annotDict = _context.sent;

                if (annotDict instanceof _primitives.Dict) {
                  _context.next = 6;
                  break;
                }

                return _context.abrupt("return", -1);

              case 6:
                pageRef = annotDict.getRaw("P");

                if (pageRef instanceof _primitives.Ref) {
                  _context.next = 9;
                  break;
                }

                return _context.abrupt("return", -1);

              case 9:
                _context.next = 11;
                return pdfManager.ensureCatalog("getPageIndex", [pageRef]);

              case 11:
                pageIndex = _context.sent;
                return _context.abrupt("return", pageIndex);

              case 15:
                _context.prev = 15;
                _context.t0 = _context["catch"](0);
                (0, _util.warn)("_getPageIndex: \"".concat(_context.t0, "\"."));
                return _context.abrupt("return", -1);

              case 19:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 15]]);
      }));

      function _getPageIndex(_x, _x2, _x3) {
        return _getPageIndex2.apply(this, arguments);
      }

      return _getPageIndex;
    }()
  }]);

  return AnnotationFactory;
}();

exports.AnnotationFactory = AnnotationFactory;

function getRgbColor(color) {
  var defaultColor = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new Uint8ClampedArray(3);

  if (!Array.isArray(color)) {
    return defaultColor;
  }

  var rgbColor = defaultColor || new Uint8ClampedArray(3);

  switch (color.length) {
    case 0:
      return null;

    case 1:
      _colorspace.ColorSpace.singletons.gray.getRgbItem(color, 0, rgbColor, 0);

      return rgbColor;

    case 3:
      _colorspace.ColorSpace.singletons.rgb.getRgbItem(color, 0, rgbColor, 0);

      return rgbColor;

    case 4:
      _colorspace.ColorSpace.singletons.cmyk.getRgbItem(color, 0, rgbColor, 0);

      return rgbColor;

    default:
      return defaultColor;
  }
}

function getQuadPoints(dict, rect) {
  if (!dict.has("QuadPoints")) {
    return null;
  }

  var quadPoints = dict.getArray("QuadPoints");

  if (!Array.isArray(quadPoints) || quadPoints.length === 0 || quadPoints.length % 8 > 0) {
    return null;
  }

  var quadPointsLists = [];

  for (var i = 0, ii = quadPoints.length / 8; i < ii; i++) {
    quadPointsLists.push([]);

    for (var j = i * 8, jj = i * 8 + 8; j < jj; j += 2) {
      var x = quadPoints[j];
      var y = quadPoints[j + 1];

      if (rect !== null && (x < rect[0] || x > rect[2] || y < rect[1] || y > rect[3])) {
        return null;
      }

      quadPointsLists[i].push({
        x: x,
        y: y
      });
    }
  }

  return quadPointsLists.map(function (quadPointsList) {
    var _quadPointsList$reduc = quadPointsList.reduce(function (_ref3, quadPoint) {
      var _ref4 = _slicedToArray(_ref3, 4),
          mX = _ref4[0],
          MX = _ref4[1],
          mY = _ref4[2],
          MY = _ref4[3];

      return [Math.min(mX, quadPoint.x), Math.max(MX, quadPoint.x), Math.min(mY, quadPoint.y), Math.max(MY, quadPoint.y)];
    }, [Number.MAX_VALUE, Number.MIN_VALUE, Number.MAX_VALUE, Number.MIN_VALUE]),
        _quadPointsList$reduc2 = _slicedToArray(_quadPointsList$reduc, 4),
        minX = _quadPointsList$reduc2[0],
        maxX = _quadPointsList$reduc2[1],
        minY = _quadPointsList$reduc2[2],
        maxY = _quadPointsList$reduc2[3];

    return [{
      x: minX,
      y: maxY
    }, {
      x: maxX,
      y: maxY
    }, {
      x: minX,
      y: minY
    }, {
      x: maxX,
      y: minY
    }];
  });
}

function getTransformMatrix(rect, bbox, matrix) {
  var _Util$getAxialAligned = _util.Util.getAxialAlignedBoundingBox(bbox, matrix),
      _Util$getAxialAligned2 = _slicedToArray(_Util$getAxialAligned, 4),
      minX = _Util$getAxialAligned2[0],
      minY = _Util$getAxialAligned2[1],
      maxX = _Util$getAxialAligned2[2],
      maxY = _Util$getAxialAligned2[3];

  if (minX === maxX || minY === maxY) {
    return [1, 0, 0, 1, rect[0], rect[1]];
  }

  var xRatio = (rect[2] - rect[0]) / (maxX - minX);
  var yRatio = (rect[3] - rect[1]) / (maxY - minY);
  return [xRatio, 0, 0, yRatio, rect[0] - minX * xRatio, rect[1] - minY * yRatio];
}

var Annotation = /*#__PURE__*/function () {
  function Annotation(params) {
    _classCallCheck(this, Annotation);

    var dict = params.dict;
    this.setTitle(dict.get("T"));
    this.setContents(dict.get("Contents"));
    this.setModificationDate(dict.get("M"));
    this.setFlags(dict.get("F"));
    this.setRectangle(dict.getArray("Rect"));
    this.setColor(dict.getArray("C"));
    this.setBorderStyle(dict);
    this.setAppearance(dict);
    this.setBorderAndBackgroundColors(dict.get("MK"));
    this._streams = [];

    if (this.appearance) {
      this._streams.push(this.appearance);
    }

    this.data = {
      annotationFlags: this.flags,
      borderStyle: this.borderStyle,
      color: this.color,
      backgroundColor: this.backgroundColor,
      borderColor: this.borderColor,
      contentsObj: this._contents,
      hasAppearance: !!this.appearance,
      id: params.id,
      modificationDate: this.modificationDate,
      rect: this.rectangle,
      subtype: params.subtype,
      hasOwnCanvas: false
    };

    if (params.collectFields) {
      var kids = dict.get("Kids");

      if (Array.isArray(kids)) {
        var kidIds = [];

        var _iterator = _createForOfIteratorHelper(kids),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var kid = _step.value;

            if (kid instanceof _primitives.Ref) {
              kidIds.push(kid.toString());
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        if (kidIds.length !== 0) {
          this.data.kidIds = kidIds;
        }
      }

      this.data.actions = (0, _core_utils.collectActions)(params.xref, dict, _util.AnnotationActionEventType);
      this.data.fieldName = this._constructFieldName(dict);
      this.data.pageIndex = params.pageIndex;
    }

    this._fallbackFontDict = null;
  }

  _createClass(Annotation, [{
    key: "_hasFlag",
    value: function _hasFlag(flags, flag) {
      return !!(flags & flag);
    }
  }, {
    key: "_isViewable",
    value: function _isViewable(flags) {
      return !this._hasFlag(flags, _util.AnnotationFlag.INVISIBLE) && !this._hasFlag(flags, _util.AnnotationFlag.NOVIEW);
    }
  }, {
    key: "_isPrintable",
    value: function _isPrintable(flags) {
      return this._hasFlag(flags, _util.AnnotationFlag.PRINT) && !this._hasFlag(flags, _util.AnnotationFlag.INVISIBLE);
    }
  }, {
    key: "mustBeViewed",
    value: function mustBeViewed(annotationStorage) {
      var storageEntry = annotationStorage && annotationStorage.get(this.data.id);

      if (storageEntry && storageEntry.hidden !== undefined) {
        return !storageEntry.hidden;
      }

      return this.viewable && !this._hasFlag(this.flags, _util.AnnotationFlag.HIDDEN);
    }
  }, {
    key: "mustBePrinted",
    value: function mustBePrinted(annotationStorage) {
      var storageEntry = annotationStorage && annotationStorage.get(this.data.id);

      if (storageEntry && storageEntry.print !== undefined) {
        return storageEntry.print;
      }

      return this.printable;
    }
  }, {
    key: "viewable",
    get: function get() {
      if (this.data.quadPoints === null) {
        return false;
      }

      if (this.flags === 0) {
        return true;
      }

      return this._isViewable(this.flags);
    }
  }, {
    key: "printable",
    get: function get() {
      if (this.data.quadPoints === null) {
        return false;
      }

      if (this.flags === 0) {
        return false;
      }

      return this._isPrintable(this.flags);
    }
  }, {
    key: "_parseStringHelper",
    value: function _parseStringHelper(data) {
      var str = typeof data === "string" ? (0, _util.stringToPDFString)(data) : "";
      var dir = str && (0, _bidi.bidi)(str).dir === "rtl" ? "rtl" : "ltr";
      return {
        str: str,
        dir: dir
      };
    }
  }, {
    key: "setTitle",
    value: function setTitle(title) {
      this._title = this._parseStringHelper(title);
    }
  }, {
    key: "setContents",
    value: function setContents(contents) {
      this._contents = this._parseStringHelper(contents);
    }
  }, {
    key: "setModificationDate",
    value: function setModificationDate(modificationDate) {
      this.modificationDate = typeof modificationDate === "string" ? modificationDate : null;
    }
  }, {
    key: "setFlags",
    value: function setFlags(flags) {
      this.flags = Number.isInteger(flags) && flags > 0 ? flags : 0;
    }
  }, {
    key: "hasFlag",
    value: function hasFlag(flag) {
      return this._hasFlag(this.flags, flag);
    }
  }, {
    key: "setRectangle",
    value: function setRectangle(rectangle) {
      if (Array.isArray(rectangle) && rectangle.length === 4) {
        this.rectangle = _util.Util.normalizeRect(rectangle);
      } else {
        this.rectangle = [0, 0, 0, 0];
      }
    }
  }, {
    key: "setColor",
    value: function setColor(color) {
      this.color = getRgbColor(color);
    }
  }, {
    key: "setBorderAndBackgroundColors",
    value: function setBorderAndBackgroundColors(mk) {
      if (mk instanceof _primitives.Dict) {
        this.borderColor = getRgbColor(mk.getArray("BC"), null);
        this.backgroundColor = getRgbColor(mk.getArray("BG"), null);
      } else {
        this.borderColor = this.backgroundColor = null;
      }
    }
  }, {
    key: "setBorderStyle",
    value: function setBorderStyle(borderStyle) {
      this.borderStyle = new AnnotationBorderStyle();

      if (!(borderStyle instanceof _primitives.Dict)) {
        return;
      }

      if (borderStyle.has("BS")) {
        var dict = borderStyle.get("BS");
        var dictType = dict.get("Type");

        if (!dictType || (0, _primitives.isName)(dictType, "Border")) {
          this.borderStyle.setWidth(dict.get("W"), this.rectangle);
          this.borderStyle.setStyle(dict.get("S"));
          this.borderStyle.setDashArray(dict.getArray("D"));
        }
      } else if (borderStyle.has("Border")) {
        var array = borderStyle.getArray("Border");

        if (Array.isArray(array) && array.length >= 3) {
          this.borderStyle.setHorizontalCornerRadius(array[0]);
          this.borderStyle.setVerticalCornerRadius(array[1]);
          this.borderStyle.setWidth(array[2], this.rectangle);

          if (array.length === 4) {
            this.borderStyle.setDashArray(array[3], true);
          }
        }
      } else {
        this.borderStyle.setWidth(0);
      }
    }
  }, {
    key: "setAppearance",
    value: function setAppearance(dict) {
      this.appearance = null;
      var appearanceStates = dict.get("AP");

      if (!(appearanceStates instanceof _primitives.Dict)) {
        return;
      }

      var normalAppearanceState = appearanceStates.get("N");

      if (normalAppearanceState instanceof _base_stream.BaseStream) {
        this.appearance = normalAppearanceState;
        return;
      }

      if (!(normalAppearanceState instanceof _primitives.Dict)) {
        return;
      }

      var as = dict.get("AS");

      if (!(as instanceof _primitives.Name) || !normalAppearanceState.has(as.name)) {
        return;
      }

      this.appearance = normalAppearanceState.get(as.name);
    }
  }, {
    key: "loadResources",
    value: function loadResources(keys, appearance) {
      return appearance.dict.getAsync("Resources").then(function (resources) {
        if (!resources) {
          return undefined;
        }

        var objectLoader = new _object_loader.ObjectLoader(resources, keys, resources.xref);
        return objectLoader.load().then(function () {
          return resources;
        });
      });
    }
  }, {
    key: "getOperatorList",
    value: function getOperatorList(evaluator, task, intent, renderForms, annotationStorage) {
      var _this2 = this;

      var data = this.data;
      var appearance = this.appearance;
      var isUsingOwnCanvas = data.hasOwnCanvas && intent & _util.RenderingIntentFlag.DISPLAY;

      if (!appearance) {
        if (!isUsingOwnCanvas) {
          return Promise.resolve(new _operator_list.OperatorList());
        }

        appearance = new _stream.StringStream("");
        appearance.dict = new _primitives.Dict();
      }

      var appearanceDict = appearance.dict;
      var resourcesPromise = this.loadResources(["ExtGState", "ColorSpace", "Pattern", "Shading", "XObject", "Font"], appearance);
      var bbox = appearanceDict.getArray("BBox") || [0, 0, 1, 1];
      var matrix = appearanceDict.getArray("Matrix") || [1, 0, 0, 1, 0, 0];
      var transform = getTransformMatrix(data.rect, bbox, matrix);
      return resourcesPromise.then(function (resources) {
        var opList = new _operator_list.OperatorList();
        opList.addOp(_util.OPS.beginAnnotation, [data.id, data.rect, transform, matrix, isUsingOwnCanvas]);
        return evaluator.getOperatorList({
          stream: appearance,
          task: task,
          resources: resources,
          operatorList: opList,
          fallbackFontDict: _this2._fallbackFontDict
        }).then(function () {
          opList.addOp(_util.OPS.endAnnotation, []);

          _this2.reset();

          return opList;
        });
      });
    }
  }, {
    key: "save",
    value: function () {
      var _save = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee2(evaluator, task, annotationStorage) {
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                return _context2.abrupt("return", null);

              case 1:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function save(_x4, _x5, _x6) {
        return _save.apply(this, arguments);
      }

      return save;
    }()
  }, {
    key: "getFieldObject",
    value: function getFieldObject() {
      if (this.data.kidIds) {
        return {
          id: this.data.id,
          actions: this.data.actions,
          name: this.data.fieldName,
          strokeColor: this.data.borderColor,
          fillColor: this.data.backgroundColor,
          type: "",
          kidIds: this.data.kidIds,
          page: this.data.pageIndex
        };
      }

      return null;
    }
  }, {
    key: "reset",
    value: function reset() {
      var _iterator2 = _createForOfIteratorHelper(this._streams),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var stream = _step2.value;
          stream.reset();
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }, {
    key: "_constructFieldName",
    value: function _constructFieldName(dict) {
      if (!dict.has("T") && !dict.has("Parent")) {
        (0, _util.warn)("Unknown field name, falling back to empty field name.");
        return "";
      }

      if (!dict.has("Parent")) {
        return (0, _util.stringToPDFString)(dict.get("T"));
      }

      var fieldName = [];

      if (dict.has("T")) {
        fieldName.unshift((0, _util.stringToPDFString)(dict.get("T")));
      }

      var loopDict = dict;
      var visited = new _primitives.RefSet();

      if (dict.objId) {
        visited.put(dict.objId);
      }

      while (loopDict.has("Parent")) {
        loopDict = loopDict.get("Parent");

        if (!(loopDict instanceof _primitives.Dict) || loopDict.objId && visited.has(loopDict.objId)) {
          break;
        }

        if (loopDict.objId) {
          visited.put(loopDict.objId);
        }

        if (loopDict.has("T")) {
          fieldName.unshift((0, _util.stringToPDFString)(loopDict.get("T")));
        }
      }

      return fieldName.join(".");
    }
  }]);

  return Annotation;
}();

exports.Annotation = Annotation;

var AnnotationBorderStyle = /*#__PURE__*/function () {
  function AnnotationBorderStyle() {
    _classCallCheck(this, AnnotationBorderStyle);

    this.width = 1;
    this.style = _util.AnnotationBorderStyleType.SOLID;
    this.dashArray = [3];
    this.horizontalCornerRadius = 0;
    this.verticalCornerRadius = 0;
  }

  _createClass(AnnotationBorderStyle, [{
    key: "setWidth",
    value: function setWidth(width) {
      var rect = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0, 0];

      if (width instanceof _primitives.Name) {
        this.width = 0;
        return;
      }

      if (typeof width === "number") {
        if (width > 0) {
          var maxWidth = (rect[2] - rect[0]) / 2;
          var maxHeight = (rect[3] - rect[1]) / 2;

          if (maxWidth > 0 && maxHeight > 0 && (width > maxWidth || width > maxHeight)) {
            (0, _util.warn)("AnnotationBorderStyle.setWidth - ignoring width: ".concat(width));
            width = 1;
          }
        }

        this.width = width;
      }
    }
  }, {
    key: "setStyle",
    value: function setStyle(style) {
      if (!(style instanceof _primitives.Name)) {
        return;
      }

      switch (style.name) {
        case "S":
          this.style = _util.AnnotationBorderStyleType.SOLID;
          break;

        case "D":
          this.style = _util.AnnotationBorderStyleType.DASHED;
          break;

        case "B":
          this.style = _util.AnnotationBorderStyleType.BEVELED;
          break;

        case "I":
          this.style = _util.AnnotationBorderStyleType.INSET;
          break;

        case "U":
          this.style = _util.AnnotationBorderStyleType.UNDERLINE;
          break;

        default:
          break;
      }
    }
  }, {
    key: "setDashArray",
    value: function setDashArray(dashArray) {
      var forceStyle = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      if (Array.isArray(dashArray) && dashArray.length > 0) {
        var isValid = true;
        var allZeros = true;

        var _iterator3 = _createForOfIteratorHelper(dashArray),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var element = _step3.value;
            var validNumber = +element >= 0;

            if (!validNumber) {
              isValid = false;
              break;
            } else if (element > 0) {
              allZeros = false;
            }
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }

        if (isValid && !allZeros) {
          this.dashArray = dashArray;

          if (forceStyle) {
            this.setStyle(_primitives.Name.get("D"));
          }
        } else {
          this.width = 0;
        }
      } else if (dashArray) {
        this.width = 0;
      }
    }
  }, {
    key: "setHorizontalCornerRadius",
    value: function setHorizontalCornerRadius(radius) {
      if (Number.isInteger(radius)) {
        this.horizontalCornerRadius = radius;
      }
    }
  }, {
    key: "setVerticalCornerRadius",
    value: function setVerticalCornerRadius(radius) {
      if (Number.isInteger(radius)) {
        this.verticalCornerRadius = radius;
      }
    }
  }]);

  return AnnotationBorderStyle;
}();

exports.AnnotationBorderStyle = AnnotationBorderStyle;

var MarkupAnnotation = /*#__PURE__*/function (_Annotation) {
  _inherits(MarkupAnnotation, _Annotation);

  var _super = _createSuper(MarkupAnnotation);

  function MarkupAnnotation(parameters) {
    var _this3;

    _classCallCheck(this, MarkupAnnotation);

    _this3 = _super.call(this, parameters);
    var dict = parameters.dict;

    if (dict.has("IRT")) {
      var rawIRT = dict.getRaw("IRT");
      _this3.data.inReplyTo = rawIRT instanceof _primitives.Ref ? rawIRT.toString() : null;
      var rt = dict.get("RT");
      _this3.data.replyType = rt instanceof _primitives.Name ? rt.name : _util.AnnotationReplyType.REPLY;
    }

    if (_this3.data.replyType === _util.AnnotationReplyType.GROUP) {
      var parent = dict.get("IRT");

      _this3.setTitle(parent.get("T"));

      _this3.data.titleObj = _this3._title;

      _this3.setContents(parent.get("Contents"));

      _this3.data.contentsObj = _this3._contents;

      if (!parent.has("CreationDate")) {
        _this3.data.creationDate = null;
      } else {
        _this3.setCreationDate(parent.get("CreationDate"));

        _this3.data.creationDate = _this3.creationDate;
      }

      if (!parent.has("M")) {
        _this3.data.modificationDate = null;
      } else {
        _this3.setModificationDate(parent.get("M"));

        _this3.data.modificationDate = _this3.modificationDate;
      }

      _this3.data.hasPopup = parent.has("Popup");

      if (!parent.has("C")) {
        _this3.data.color = null;
      } else {
        _this3.setColor(parent.getArray("C"));

        _this3.data.color = _this3.color;
      }
    } else {
      _this3.data.titleObj = _this3._title;

      _this3.setCreationDate(dict.get("CreationDate"));

      _this3.data.creationDate = _this3.creationDate;
      _this3.data.hasPopup = dict.has("Popup");

      if (!dict.has("C")) {
        _this3.data.color = null;
      }
    }

    if (dict.has("RC")) {
      _this3.data.richText = _factory.XFAFactory.getRichTextAsHtml(dict.get("RC"));
    }

    return _this3;
  }

  _createClass(MarkupAnnotation, [{
    key: "setCreationDate",
    value: function setCreationDate(creationDate) {
      this.creationDate = typeof creationDate === "string" ? creationDate : null;
    }
  }, {
    key: "_setDefaultAppearance",
    value: function _setDefaultAppearance(_ref5) {
      var xref = _ref5.xref,
          extra = _ref5.extra,
          strokeColor = _ref5.strokeColor,
          fillColor = _ref5.fillColor,
          blendMode = _ref5.blendMode,
          strokeAlpha = _ref5.strokeAlpha,
          fillAlpha = _ref5.fillAlpha,
          pointsCallback = _ref5.pointsCallback;
      var minX = Number.MAX_VALUE;
      var minY = Number.MAX_VALUE;
      var maxX = Number.MIN_VALUE;
      var maxY = Number.MIN_VALUE;
      var buffer = ["q"];

      if (extra) {
        buffer.push(extra);
      }

      if (strokeColor) {
        buffer.push("".concat(strokeColor[0], " ").concat(strokeColor[1], " ").concat(strokeColor[2], " RG"));
      }

      if (fillColor) {
        buffer.push("".concat(fillColor[0], " ").concat(fillColor[1], " ").concat(fillColor[2], " rg"));
      }

      var pointsArray = this.data.quadPoints;

      if (!pointsArray) {
        pointsArray = [[{
          x: this.rectangle[0],
          y: this.rectangle[3]
        }, {
          x: this.rectangle[2],
          y: this.rectangle[3]
        }, {
          x: this.rectangle[0],
          y: this.rectangle[1]
        }, {
          x: this.rectangle[2],
          y: this.rectangle[1]
        }]];
      }

      var _iterator4 = _createForOfIteratorHelper(pointsArray),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var points = _step4.value;

          var _pointsCallback = pointsCallback(buffer, points),
              _pointsCallback2 = _slicedToArray(_pointsCallback, 4),
              mX = _pointsCallback2[0],
              MX = _pointsCallback2[1],
              mY = _pointsCallback2[2],
              MY = _pointsCallback2[3];

          minX = Math.min(minX, mX);
          maxX = Math.max(maxX, MX);
          minY = Math.min(minY, mY);
          maxY = Math.max(maxY, MY);
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }

      buffer.push("Q");
      var formDict = new _primitives.Dict(xref);
      var appearanceStreamDict = new _primitives.Dict(xref);
      appearanceStreamDict.set("Subtype", _primitives.Name.get("Form"));
      var appearanceStream = new _stream.StringStream(buffer.join(" "));
      appearanceStream.dict = appearanceStreamDict;
      formDict.set("Fm0", appearanceStream);
      var gsDict = new _primitives.Dict(xref);

      if (blendMode) {
        gsDict.set("BM", _primitives.Name.get(blendMode));
      }

      if (typeof strokeAlpha === "number") {
        gsDict.set("CA", strokeAlpha);
      }

      if (typeof fillAlpha === "number") {
        gsDict.set("ca", fillAlpha);
      }

      var stateDict = new _primitives.Dict(xref);
      stateDict.set("GS0", gsDict);
      var resources = new _primitives.Dict(xref);
      resources.set("ExtGState", stateDict);
      resources.set("XObject", formDict);
      var appearanceDict = new _primitives.Dict(xref);
      appearanceDict.set("Resources", resources);
      var bbox = this.data.rect = [minX, minY, maxX, maxY];
      appearanceDict.set("BBox", bbox);
      this.appearance = new _stream.StringStream("/GS0 gs /Fm0 Do");
      this.appearance.dict = appearanceDict;

      this._streams.push(this.appearance, appearanceStream);
    }
  }]);

  return MarkupAnnotation;
}(Annotation);

exports.MarkupAnnotation = MarkupAnnotation;

var WidgetAnnotation = /*#__PURE__*/function (_Annotation2) {
  _inherits(WidgetAnnotation, _Annotation2);

  var _super2 = _createSuper(WidgetAnnotation);

  function WidgetAnnotation(params) {
    var _this4;

    _classCallCheck(this, WidgetAnnotation);

    _this4 = _super2.call(this, params);
    var dict = params.dict;
    var data = _this4.data;
    _this4.ref = params.ref;
    data.annotationType = _util.AnnotationType.WIDGET;

    if (data.fieldName === undefined) {
      data.fieldName = _this4._constructFieldName(dict);
    }

    if (data.actions === undefined) {
      data.actions = (0, _core_utils.collectActions)(params.xref, dict, _util.AnnotationActionEventType);
    }

    var fieldValue = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "V",
      getArray: true
    });
    data.fieldValue = _this4._decodeFormValue(fieldValue);
    var defaultFieldValue = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "DV",
      getArray: true
    });
    data.defaultFieldValue = _this4._decodeFormValue(defaultFieldValue);

    if (fieldValue === undefined && data.defaultFieldValue !== null) {
      data.fieldValue = data.defaultFieldValue;
    }

    data.alternativeText = (0, _util.stringToPDFString)(dict.get("TU") || "");
    var defaultAppearance = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "DA"
    }) || params.acroForm.get("DA");
    _this4._defaultAppearance = typeof defaultAppearance === "string" ? defaultAppearance : "";
    data.defaultAppearanceData = (0, _default_appearance.parseDefaultAppearance)(_this4._defaultAppearance);
    var fieldType = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "FT"
    });
    data.fieldType = fieldType instanceof _primitives.Name ? fieldType.name : null;
    var localResources = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "DR"
    });
    var acroFormResources = params.acroForm.get("DR");

    var appearanceResources = _this4.appearance && _this4.appearance.dict.get("Resources");

    _this4._fieldResources = {
      localResources: localResources,
      acroFormResources: acroFormResources,
      appearanceResources: appearanceResources,
      mergedResources: _primitives.Dict.merge({
        xref: params.xref,
        dictArray: [localResources, appearanceResources, acroFormResources],
        mergeSubDicts: true
      })
    };
    data.fieldFlags = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "Ff"
    });

    if (!Number.isInteger(data.fieldFlags) || data.fieldFlags < 0) {
      data.fieldFlags = 0;
    }

    data.readOnly = _this4.hasFieldFlag(_util.AnnotationFieldFlag.READONLY);
    data.hidden = _this4._hasFlag(data.annotationFlags, _util.AnnotationFlag.HIDDEN);
    return _this4;
  }

  _createClass(WidgetAnnotation, [{
    key: "_decodeFormValue",
    value: function _decodeFormValue(formValue) {
      if (Array.isArray(formValue)) {
        return formValue.filter(function (item) {
          return typeof item === "string";
        }).map(function (item) {
          return (0, _util.stringToPDFString)(item);
        });
      } else if (formValue instanceof _primitives.Name) {
        return (0, _util.stringToPDFString)(formValue.name);
      } else if (typeof formValue === "string") {
        return (0, _util.stringToPDFString)(formValue);
      }

      return null;
    }
  }, {
    key: "hasFieldFlag",
    value: function hasFieldFlag(flag) {
      return !!(this.data.fieldFlags & flag);
    }
  }, {
    key: "getOperatorList",
    value: function getOperatorList(evaluator, task, intent, renderForms, annotationStorage) {
      var _this5 = this;

      if (renderForms && !(this instanceof SignatureWidgetAnnotation)) {
        return Promise.resolve(new _operator_list.OperatorList());
      }

      if (!this._hasText) {
        return _get(_getPrototypeOf(WidgetAnnotation.prototype), "getOperatorList", this).call(this, evaluator, task, intent, renderForms, annotationStorage);
      }

      return this._getAppearance(evaluator, task, annotationStorage).then(function (content) {
        if (_this5.appearance && content === null) {
          return _get(_getPrototypeOf(WidgetAnnotation.prototype), "getOperatorList", _this5).call(_this5, evaluator, task, intent, renderForms, annotationStorage);
        }

        var operatorList = new _operator_list.OperatorList();

        if (!_this5._defaultAppearance || content === null) {
          return operatorList;
        }

        var matrix = [1, 0, 0, 1, 0, 0];
        var bbox = [0, 0, _this5.data.rect[2] - _this5.data.rect[0], _this5.data.rect[3] - _this5.data.rect[1]];
        var transform = getTransformMatrix(_this5.data.rect, bbox, matrix);
        operatorList.addOp(_util.OPS.beginAnnotation, [_this5.data.id, _this5.data.rect, transform, matrix]);
        var stream = new _stream.StringStream(content);
        return evaluator.getOperatorList({
          stream: stream,
          task: task,
          resources: _this5._fieldResources.mergedResources,
          operatorList: operatorList
        }).then(function () {
          operatorList.addOp(_util.OPS.endAnnotation, []);
          return operatorList;
        });
      });
    }
  }, {
    key: "save",
    value: function () {
      var _save2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee3(evaluator, task, annotationStorage) {
        var storageEntry, value, appearance, xref, dict, bbox, xfa, newRef, AP, encrypt, originalTransform, newTransform, appearanceDict, bufferOriginal, bufferNew;
        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                if (annotationStorage) {
                  _context3.next = 2;
                  break;
                }

                return _context3.abrupt("return", null);

              case 2:
                storageEntry = annotationStorage.get(this.data.id);
                value = storageEntry && storageEntry.value;

                if (!(value === this.data.fieldValue || value === undefined)) {
                  _context3.next = 6;
                  break;
                }

                return _context3.abrupt("return", null);

              case 6:
                _context3.next = 8;
                return this._getAppearance(evaluator, task, annotationStorage);

              case 8:
                appearance = _context3.sent;

                if (!(appearance === null)) {
                  _context3.next = 11;
                  break;
                }

                return _context3.abrupt("return", null);

              case 11:
                xref = evaluator.xref;
                dict = xref.fetchIfRef(this.ref);

                if (dict instanceof _primitives.Dict) {
                  _context3.next = 15;
                  break;
                }

                return _context3.abrupt("return", null);

              case 15:
                bbox = [0, 0, this.data.rect[2] - this.data.rect[0], this.data.rect[3] - this.data.rect[1]];
                xfa = {
                  path: (0, _util.stringToPDFString)(dict.get("T") || ""),
                  value: value
                };
                newRef = xref.getNewRef();
                AP = new _primitives.Dict(xref);
                AP.set("N", newRef);
                encrypt = xref.encrypt;
                originalTransform = null;
                newTransform = null;

                if (encrypt) {
                  originalTransform = encrypt.createCipherTransform(this.ref.num, this.ref.gen);
                  newTransform = encrypt.createCipherTransform(newRef.num, newRef.gen);
                  appearance = newTransform.encryptString(appearance);
                }

                dict.set("V", (0, _util.isAscii)(value) ? value : (0, _util.stringToUTF16BEString)(value));
                dict.set("AP", AP);
                dict.set("M", "D:".concat((0, _util.getModificationDate)()));
                appearanceDict = new _primitives.Dict(xref);
                appearanceDict.set("Length", appearance.length);
                appearanceDict.set("Subtype", _primitives.Name.get("Form"));
                appearanceDict.set("Resources", this._getSaveFieldResources(xref));
                appearanceDict.set("BBox", bbox);
                bufferOriginal = ["".concat(this.ref.num, " ").concat(this.ref.gen, " obj\n")];
                (0, _writer.writeDict)(dict, bufferOriginal, originalTransform);
                bufferOriginal.push("\nendobj\n");
                bufferNew = ["".concat(newRef.num, " ").concat(newRef.gen, " obj\n")];
                (0, _writer.writeDict)(appearanceDict, bufferNew, newTransform);
                bufferNew.push(" stream\n", appearance, "\nendstream\nendobj\n");
                return _context3.abrupt("return", [{
                  ref: this.ref,
                  data: bufferOriginal.join(""),
                  xfa: xfa
                }, {
                  ref: newRef,
                  data: bufferNew.join(""),
                  xfa: null
                }]);

              case 39:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function save(_x7, _x8, _x9) {
        return _save2.apply(this, arguments);
      }

      return save;
    }()
  }, {
    key: "_getAppearance",
    value: function () {
      var _getAppearance2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee4(evaluator, task, annotationStorage) {
        var isPassword, storageEntry, value, lineCount, defaultPadding, hPadding, totalHeight, totalWidth, font, _this$_computeFontSiz, _this$_computeFontSiz2, defaultAppearance, fontSize, descent, vPadding, alignment, encodedString, renderedText;

        return _regenerator["default"].wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                isPassword = this.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD);

                if (!(!annotationStorage || isPassword)) {
                  _context4.next = 3;
                  break;
                }

                return _context4.abrupt("return", null);

              case 3:
                storageEntry = annotationStorage.get(this.data.id);
                value = storageEntry && storageEntry.value;

                if (!(value === undefined)) {
                  _context4.next = 7;
                  break;
                }

                return _context4.abrupt("return", null);

              case 7:
                value = value.trim();

                if (!(value === "")) {
                  _context4.next = 10;
                  break;
                }

                return _context4.abrupt("return", "");

              case 10:
                lineCount = -1;

                if (this.data.multiLine) {
                  lineCount = value.split(/\r\n|\r|\n/).length;
                }

                defaultPadding = 2;
                hPadding = defaultPadding;
                totalHeight = this.data.rect[3] - this.data.rect[1];
                totalWidth = this.data.rect[2] - this.data.rect[0];

                if (!this._defaultAppearance) {
                  this.data.defaultAppearanceData = (0, _default_appearance.parseDefaultAppearance)(this._defaultAppearance = "/Helvetica 0 Tf 0 g");
                }

                _context4.next = 19;
                return this._getFontData(evaluator, task);

              case 19:
                font = _context4.sent;
                _this$_computeFontSiz = this._computeFontSize(totalHeight - defaultPadding, totalWidth - 2 * hPadding, value, font, lineCount), _this$_computeFontSiz2 = _slicedToArray(_this$_computeFontSiz, 2), defaultAppearance = _this$_computeFontSiz2[0], fontSize = _this$_computeFontSiz2[1];
                descent = font.descent;

                if (isNaN(descent)) {
                  descent = 0;
                }

                vPadding = defaultPadding + Math.abs(descent) * fontSize;
                alignment = this.data.textAlignment;

                if (!this.data.multiLine) {
                  _context4.next = 27;
                  break;
                }

                return _context4.abrupt("return", this._getMultilineAppearance(defaultAppearance, value, font, fontSize, totalWidth, totalHeight, alignment, hPadding, vPadding));

              case 27:
                encodedString = font.encodeString(value).join("");

                if (!this.data.comb) {
                  _context4.next = 30;
                  break;
                }

                return _context4.abrupt("return", this._getCombAppearance(defaultAppearance, font, encodedString, totalWidth, hPadding, vPadding));

              case 30:
                if (!(alignment === 0 || alignment > 2)) {
                  _context4.next = 32;
                  break;
                }

                return _context4.abrupt("return", "/Tx BMC q BT " + defaultAppearance + " 1 0 0 1 ".concat(hPadding, " ").concat(vPadding, " Tm (").concat((0, _util.escapeString)(encodedString), ") Tj") + " ET Q EMC");

              case 32:
                renderedText = this._renderText(encodedString, font, fontSize, totalWidth, alignment, hPadding, vPadding);
                return _context4.abrupt("return", "/Tx BMC q BT " + defaultAppearance + " 1 0 0 1 0 0 Tm ".concat(renderedText) + " ET Q EMC");

              case 34:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function _getAppearance(_x10, _x11, _x12) {
        return _getAppearance2.apply(this, arguments);
      }

      return _getAppearance;
    }()
  }, {
    key: "_getFontData",
    value: function () {
      var _getFontData2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee5(evaluator, task) {
        var operatorList, initialState, _this$data$defaultApp, fontName, fontSize;

        return _regenerator["default"].wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                operatorList = new _operator_list.OperatorList();
                initialState = {
                  font: null,
                  clone: function clone() {
                    return this;
                  }
                };
                _this$data$defaultApp = this.data.defaultAppearanceData, fontName = _this$data$defaultApp.fontName, fontSize = _this$data$defaultApp.fontSize;
                _context5.next = 5;
                return evaluator.handleSetFont(this._fieldResources.mergedResources, [fontName && _primitives.Name.get(fontName), fontSize], null, operatorList, task, initialState, null);

              case 5:
                return _context5.abrupt("return", initialState.font);

              case 6:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this);
      }));

      function _getFontData(_x13, _x14) {
        return _getFontData2.apply(this, arguments);
      }

      return _getFontData;
    }()
  }, {
    key: "_getTextWidth",
    value: function _getTextWidth(text, font) {
      return font.charsToGlyphs(text).reduce(function (width, glyph) {
        return width + glyph.width;
      }, 0) / 1000;
    }
  }, {
    key: "_computeFontSize",
    value: function _computeFontSize(height, width, text, font, lineCount) {
      var _this6 = this;

      var fontSize = this.data.defaultAppearanceData.fontSize;

      if (!fontSize) {
        var roundWithTwoDigits = function roundWithTwoDigits(x) {
          return Math.floor(x * 100) / 100;
        };

        var LINE_FACTOR = 1.35;

        if (lineCount === -1) {
          var textWidth = this._getTextWidth(text, font);

          fontSize = roundWithTwoDigits(Math.min(height / LINE_FACTOR, width / textWidth));
        } else {
          var lines = text.split(/\r\n?|\n/);
          var cachedLines = [];

          var _iterator5 = _createForOfIteratorHelper(lines),
              _step5;

          try {
            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
              var line = _step5.value;
              var encoded = font.encodeString(line).join("");
              var glyphs = font.charsToGlyphs(encoded);
              var positions = font.getCharPositions(encoded);
              cachedLines.push({
                line: encoded,
                glyphs: glyphs,
                positions: positions
              });
            }
          } catch (err) {
            _iterator5.e(err);
          } finally {
            _iterator5.f();
          }

          var isTooBig = function isTooBig(fsize) {
            var totalHeight = 0;

            var _iterator6 = _createForOfIteratorHelper(cachedLines),
                _step6;

            try {
              for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
                var cache = _step6.value;

                var chunks = _this6._splitLine(null, font, fsize, width, cache);

                totalHeight += chunks.length * fsize;

                if (totalHeight > height) {
                  return true;
                }
              }
            } catch (err) {
              _iterator6.e(err);
            } finally {
              _iterator6.f();
            }

            return false;
          };

          fontSize = 12;
          var lineHeight = fontSize * LINE_FACTOR;
          var numberOfLines = Math.round(height / lineHeight);
          numberOfLines = Math.max(numberOfLines, lineCount);

          while (true) {
            lineHeight = height / numberOfLines;
            fontSize = roundWithTwoDigits(lineHeight / LINE_FACTOR);

            if (isTooBig(fontSize)) {
              numberOfLines++;
              continue;
            }

            break;
          }
        }

        var _this$data$defaultApp2 = this.data.defaultAppearanceData,
            fontName = _this$data$defaultApp2.fontName,
            fontColor = _this$data$defaultApp2.fontColor;
        this._defaultAppearance = (0, _default_appearance.createDefaultAppearance)({
          fontSize: fontSize,
          fontName: fontName,
          fontColor: fontColor
        });
      }

      return [this._defaultAppearance, fontSize];
    }
  }, {
    key: "_renderText",
    value: function _renderText(text, font, fontSize, totalWidth, alignment, hPadding, vPadding) {
      var width = this._getTextWidth(text, font) * fontSize;
      var shift;

      if (alignment === 1) {
        shift = (totalWidth - width) / 2;
      } else if (alignment === 2) {
        shift = totalWidth - width - hPadding;
      } else {
        shift = hPadding;
      }

      shift = shift.toFixed(2);
      vPadding = vPadding.toFixed(2);
      return "".concat(shift, " ").concat(vPadding, " Td (").concat((0, _util.escapeString)(text), ") Tj");
    }
  }, {
    key: "_getSaveFieldResources",
    value: function _getSaveFieldResources(xref) {
      var _this$_fieldResources = this._fieldResources,
          localResources = _this$_fieldResources.localResources,
          appearanceResources = _this$_fieldResources.appearanceResources,
          acroFormResources = _this$_fieldResources.acroFormResources;
      var fontName = this.data.defaultAppearanceData && this.data.defaultAppearanceData.fontName;

      if (!fontName) {
        return localResources || _primitives.Dict.empty;
      }

      for (var _i2 = 0, _arr2 = [localResources, appearanceResources]; _i2 < _arr2.length; _i2++) {
        var resources = _arr2[_i2];

        if (resources instanceof _primitives.Dict) {
          var localFont = resources.get("Font");

          if (localFont instanceof _primitives.Dict && localFont.has(fontName)) {
            return resources;
          }
        }
      }

      if (acroFormResources instanceof _primitives.Dict) {
        var acroFormFont = acroFormResources.get("Font");

        if (acroFormFont instanceof _primitives.Dict && acroFormFont.has(fontName)) {
          var subFontDict = new _primitives.Dict(xref);
          subFontDict.set(fontName, acroFormFont.getRaw(fontName));
          var subResourcesDict = new _primitives.Dict(xref);
          subResourcesDict.set("Font", subFontDict);
          return _primitives.Dict.merge({
            xref: xref,
            dictArray: [subResourcesDict, localResources],
            mergeSubDicts: true
          });
        }
      }

      return localResources || _primitives.Dict.empty;
    }
  }, {
    key: "getFieldObject",
    value: function getFieldObject() {
      return null;
    }
  }]);

  return WidgetAnnotation;
}(Annotation);

var TextWidgetAnnotation = /*#__PURE__*/function (_WidgetAnnotation) {
  _inherits(TextWidgetAnnotation, _WidgetAnnotation);

  var _super3 = _createSuper(TextWidgetAnnotation);

  function TextWidgetAnnotation(params) {
    var _this7;

    _classCallCheck(this, TextWidgetAnnotation);

    _this7 = _super3.call(this, params);
    _this7._hasText = true;
    var dict = params.dict;

    if (typeof _this7.data.fieldValue !== "string") {
      _this7.data.fieldValue = "";
    }

    var alignment = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "Q"
    });

    if (!Number.isInteger(alignment) || alignment < 0 || alignment > 2) {
      alignment = null;
    }

    _this7.data.textAlignment = alignment;
    var maximumLength = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "MaxLen"
    });

    if (!Number.isInteger(maximumLength) || maximumLength < 0) {
      maximumLength = null;
    }

    _this7.data.maxLen = maximumLength;
    _this7.data.multiLine = _this7.hasFieldFlag(_util.AnnotationFieldFlag.MULTILINE);
    _this7.data.comb = _this7.hasFieldFlag(_util.AnnotationFieldFlag.COMB) && !_this7.hasFieldFlag(_util.AnnotationFieldFlag.MULTILINE) && !_this7.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD) && !_this7.hasFieldFlag(_util.AnnotationFieldFlag.FILESELECT) && _this7.data.maxLen !== null;
    return _this7;
  }

  _createClass(TextWidgetAnnotation, [{
    key: "_getCombAppearance",
    value: function _getCombAppearance(defaultAppearance, font, text, width, hPadding, vPadding) {
      var combWidth = (width / this.data.maxLen).toFixed(2);
      var buf = [];
      var positions = font.getCharPositions(text);

      var _iterator7 = _createForOfIteratorHelper(positions),
          _step7;

      try {
        for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
          var _step7$value = _slicedToArray(_step7.value, 2),
              start = _step7$value[0],
              end = _step7$value[1];

          buf.push("(".concat((0, _util.escapeString)(text.substring(start, end)), ") Tj"));
        }
      } catch (err) {
        _iterator7.e(err);
      } finally {
        _iterator7.f();
      }

      var renderedComb = buf.join(" ".concat(combWidth, " 0 Td "));
      return "/Tx BMC q BT " + defaultAppearance + " 1 0 0 1 ".concat(hPadding, " ").concat(vPadding, " Tm ").concat(renderedComb) + " ET Q EMC";
    }
  }, {
    key: "_getMultilineAppearance",
    value: function _getMultilineAppearance(defaultAppearance, text, font, fontSize, width, height, alignment, hPadding, vPadding) {
      var lines = text.split(/\r\n?|\n/);
      var buf = [];
      var totalWidth = width - 2 * hPadding;

      var _iterator8 = _createForOfIteratorHelper(lines),
          _step8;

      try {
        for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
          var line = _step8.value;

          var chunks = this._splitLine(line, font, fontSize, totalWidth);

          var _iterator9 = _createForOfIteratorHelper(chunks),
              _step9;

          try {
            for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
              var chunk = _step9.value;
              var padding = buf.length === 0 ? hPadding : 0;
              buf.push(this._renderText(chunk, font, fontSize, width, alignment, padding, -fontSize));
            }
          } catch (err) {
            _iterator9.e(err);
          } finally {
            _iterator9.f();
          }
        }
      } catch (err) {
        _iterator8.e(err);
      } finally {
        _iterator8.f();
      }

      var renderedText = buf.join("\n");
      return "/Tx BMC q BT " + defaultAppearance + " 1 0 0 1 0 ".concat(height, " Tm ").concat(renderedText) + " ET Q EMC";
    }
  }, {
    key: "_splitLine",
    value: function _splitLine(line, font, fontSize, width) {
      var cache = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};
      line = cache.line || font.encodeString(line).join("");
      var glyphs = cache.glyphs || font.charsToGlyphs(line);

      if (glyphs.length <= 1) {
        return [line];
      }

      var positions = cache.positions || font.getCharPositions(line);
      var scale = fontSize / 1000;
      var chunks = [];
      var lastSpacePosInStringStart = -1,
          lastSpacePosInStringEnd = -1,
          lastSpacePos = -1,
          startChunk = 0,
          currentWidth = 0;

      for (var i = 0, ii = glyphs.length; i < ii; i++) {
        var _positions$i = _slicedToArray(positions[i], 2),
            start = _positions$i[0],
            end = _positions$i[1];

        var glyph = glyphs[i];
        var glyphWidth = glyph.width * scale;

        if (glyph.unicode === " ") {
          if (currentWidth + glyphWidth > width) {
            chunks.push(line.substring(startChunk, start));
            startChunk = start;
            currentWidth = glyphWidth;
            lastSpacePosInStringStart = -1;
            lastSpacePos = -1;
          } else {
            currentWidth += glyphWidth;
            lastSpacePosInStringStart = start;
            lastSpacePosInStringEnd = end;
            lastSpacePos = i;
          }
        } else {
          if (currentWidth + glyphWidth > width) {
            if (lastSpacePosInStringStart !== -1) {
              chunks.push(line.substring(startChunk, lastSpacePosInStringEnd));
              startChunk = lastSpacePosInStringEnd;
              i = lastSpacePos + 1;
              lastSpacePosInStringStart = -1;
              currentWidth = 0;
            } else {
              chunks.push(line.substring(startChunk, start));
              startChunk = start;
              currentWidth = glyphWidth;
            }
          } else {
            currentWidth += glyphWidth;
          }
        }
      }

      if (startChunk < line.length) {
        chunks.push(line.substring(startChunk, line.length));
      }

      return chunks;
    }
  }, {
    key: "getFieldObject",
    value: function getFieldObject() {
      return {
        id: this.data.id,
        value: this.data.fieldValue,
        defaultValue: this.data.defaultFieldValue,
        multiline: this.data.multiLine,
        password: this.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD),
        charLimit: this.data.maxLen,
        comb: this.data.comb,
        editable: !this.data.readOnly,
        hidden: this.data.hidden,
        name: this.data.fieldName,
        rect: this.data.rect,
        actions: this.data.actions,
        page: this.data.pageIndex,
        strokeColor: this.data.borderColor,
        fillColor: this.data.backgroundColor,
        type: "text"
      };
    }
  }]);

  return TextWidgetAnnotation;
}(WidgetAnnotation);

var ButtonWidgetAnnotation = /*#__PURE__*/function (_WidgetAnnotation2) {
  _inherits(ButtonWidgetAnnotation, _WidgetAnnotation2);

  var _super4 = _createSuper(ButtonWidgetAnnotation);

  function ButtonWidgetAnnotation(params) {
    var _this8;

    _classCallCheck(this, ButtonWidgetAnnotation);

    _this8 = _super4.call(this, params);
    _this8.checkedAppearance = null;
    _this8.uncheckedAppearance = null;
    _this8.data.checkBox = !_this8.hasFieldFlag(_util.AnnotationFieldFlag.RADIO) && !_this8.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);
    _this8.data.radioButton = _this8.hasFieldFlag(_util.AnnotationFieldFlag.RADIO) && !_this8.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);
    _this8.data.pushButton = _this8.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);
    _this8.data.isTooltipOnly = false;

    if (_this8.data.checkBox) {
      _this8._processCheckBox(params);
    } else if (_this8.data.radioButton) {
      _this8._processRadioButton(params);
    } else if (_this8.data.pushButton) {
      _this8.data.hasOwnCanvas = true;

      _this8._processPushButton(params);
    } else {
      (0, _util.warn)("Invalid field flags for button widget annotation");
    }

    return _this8;
  }

  _createClass(ButtonWidgetAnnotation, [{
    key: "getOperatorList",
    value: function () {
      var _getOperatorList = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee6(evaluator, task, intent, renderForms, annotationStorage) {
        var value, storageEntry, appearance, savedAppearance, operatorList;
        return _regenerator["default"].wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                if (!this.data.pushButton) {
                  _context6.next = 2;
                  break;
                }

                return _context6.abrupt("return", _get(_getPrototypeOf(ButtonWidgetAnnotation.prototype), "getOperatorList", this).call(this, evaluator, task, intent, false, annotationStorage));

              case 2:
                value = null;

                if (annotationStorage) {
                  storageEntry = annotationStorage.get(this.data.id);
                  value = storageEntry ? storageEntry.value : null;
                }

                if (!(value === null)) {
                  _context6.next = 8;
                  break;
                }

                if (!this.appearance) {
                  _context6.next = 7;
                  break;
                }

                return _context6.abrupt("return", _get(_getPrototypeOf(ButtonWidgetAnnotation.prototype), "getOperatorList", this).call(this, evaluator, task, intent, renderForms, annotationStorage));

              case 7:
                if (this.data.checkBox) {
                  value = this.data.fieldValue === this.data.exportValue;
                } else {
                  value = this.data.fieldValue === this.data.buttonValue;
                }

              case 8:
                appearance = value ? this.checkedAppearance : this.uncheckedAppearance;

                if (!appearance) {
                  _context6.next = 15;
                  break;
                }

                savedAppearance = this.appearance;
                this.appearance = appearance;
                operatorList = _get(_getPrototypeOf(ButtonWidgetAnnotation.prototype), "getOperatorList", this).call(this, evaluator, task, intent, renderForms, annotationStorage);
                this.appearance = savedAppearance;
                return _context6.abrupt("return", operatorList);

              case 15:
                return _context6.abrupt("return", new _operator_list.OperatorList());

              case 16:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6, this);
      }));

      function getOperatorList(_x15, _x16, _x17, _x18, _x19) {
        return _getOperatorList.apply(this, arguments);
      }

      return getOperatorList;
    }()
  }, {
    key: "save",
    value: function () {
      var _save3 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee7(evaluator, task, annotationStorage) {
        return _regenerator["default"].wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                if (!this.data.checkBox) {
                  _context7.next = 2;
                  break;
                }

                return _context7.abrupt("return", this._saveCheckbox(evaluator, task, annotationStorage));

              case 2:
                if (!this.data.radioButton) {
                  _context7.next = 4;
                  break;
                }

                return _context7.abrupt("return", this._saveRadioButton(evaluator, task, annotationStorage));

              case 4:
                return _context7.abrupt("return", null);

              case 5:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this);
      }));

      function save(_x20, _x21, _x22) {
        return _save3.apply(this, arguments);
      }

      return save;
    }()
  }, {
    key: "_saveCheckbox",
    value: function () {
      var _saveCheckbox2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee8(evaluator, task, annotationStorage) {
        var storageEntry, value, defaultValue, dict, xfa, name, encrypt, originalTransform, buffer;
        return _regenerator["default"].wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                if (annotationStorage) {
                  _context8.next = 2;
                  break;
                }

                return _context8.abrupt("return", null);

              case 2:
                storageEntry = annotationStorage.get(this.data.id);
                value = storageEntry && storageEntry.value;

                if (!(value === undefined)) {
                  _context8.next = 6;
                  break;
                }

                return _context8.abrupt("return", null);

              case 6:
                defaultValue = this.data.fieldValue === this.data.exportValue;

                if (!(defaultValue === value)) {
                  _context8.next = 9;
                  break;
                }

                return _context8.abrupt("return", null);

              case 9:
                dict = evaluator.xref.fetchIfRef(this.ref);

                if (dict instanceof _primitives.Dict) {
                  _context8.next = 12;
                  break;
                }

                return _context8.abrupt("return", null);

              case 12:
                xfa = {
                  path: (0, _util.stringToPDFString)(dict.get("T") || ""),
                  value: value ? this.data.exportValue : ""
                };
                name = _primitives.Name.get(value ? this.data.exportValue : "Off");
                dict.set("V", name);
                dict.set("AS", name);
                dict.set("M", "D:".concat((0, _util.getModificationDate)()));
                encrypt = evaluator.xref.encrypt;
                originalTransform = null;

                if (encrypt) {
                  originalTransform = encrypt.createCipherTransform(this.ref.num, this.ref.gen);
                }

                buffer = ["".concat(this.ref.num, " ").concat(this.ref.gen, " obj\n")];
                (0, _writer.writeDict)(dict, buffer, originalTransform);
                buffer.push("\nendobj\n");
                return _context8.abrupt("return", [{
                  ref: this.ref,
                  data: buffer.join(""),
                  xfa: xfa
                }]);

              case 24:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, this);
      }));

      function _saveCheckbox(_x23, _x24, _x25) {
        return _saveCheckbox2.apply(this, arguments);
      }

      return _saveCheckbox;
    }()
  }, {
    key: "_saveRadioButton",
    value: function () {
      var _saveRadioButton2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee9(evaluator, task, annotationStorage) {
        var storageEntry, value, defaultValue, dict, xfa, name, parentBuffer, encrypt, parent, parentTransform, originalTransform, buffer, newRefs;
        return _regenerator["default"].wrap(function _callee9$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                if (annotationStorage) {
                  _context9.next = 2;
                  break;
                }

                return _context9.abrupt("return", null);

              case 2:
                storageEntry = annotationStorage.get(this.data.id);
                value = storageEntry && storageEntry.value;

                if (!(value === undefined)) {
                  _context9.next = 6;
                  break;
                }

                return _context9.abrupt("return", null);

              case 6:
                defaultValue = this.data.fieldValue === this.data.buttonValue;

                if (!(defaultValue === value)) {
                  _context9.next = 9;
                  break;
                }

                return _context9.abrupt("return", null);

              case 9:
                dict = evaluator.xref.fetchIfRef(this.ref);

                if (dict instanceof _primitives.Dict) {
                  _context9.next = 12;
                  break;
                }

                return _context9.abrupt("return", null);

              case 12:
                xfa = {
                  path: (0, _util.stringToPDFString)(dict.get("T") || ""),
                  value: value ? this.data.buttonValue : ""
                };
                name = _primitives.Name.get(value ? this.data.buttonValue : "Off");
                parentBuffer = null;
                encrypt = evaluator.xref.encrypt;

                if (value) {
                  if (this.parent instanceof _primitives.Ref) {
                    parent = evaluator.xref.fetch(this.parent);
                    parentTransform = null;

                    if (encrypt) {
                      parentTransform = encrypt.createCipherTransform(this.parent.num, this.parent.gen);
                    }

                    parent.set("V", name);
                    parentBuffer = ["".concat(this.parent.num, " ").concat(this.parent.gen, " obj\n")];
                    (0, _writer.writeDict)(parent, parentBuffer, parentTransform);
                    parentBuffer.push("\nendobj\n");
                  } else if (this.parent instanceof _primitives.Dict) {
                    this.parent.set("V", name);
                  }
                }

                dict.set("AS", name);
                dict.set("M", "D:".concat((0, _util.getModificationDate)()));
                originalTransform = null;

                if (encrypt) {
                  originalTransform = encrypt.createCipherTransform(this.ref.num, this.ref.gen);
                }

                buffer = ["".concat(this.ref.num, " ").concat(this.ref.gen, " obj\n")];
                (0, _writer.writeDict)(dict, buffer, originalTransform);
                buffer.push("\nendobj\n");
                newRefs = [{
                  ref: this.ref,
                  data: buffer.join(""),
                  xfa: xfa
                }];

                if (parentBuffer !== null) {
                  newRefs.push({
                    ref: this.parent,
                    data: parentBuffer.join(""),
                    xfa: null
                  });
                }

                return _context9.abrupt("return", newRefs);

              case 27:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee9, this);
      }));

      function _saveRadioButton(_x26, _x27, _x28) {
        return _saveRadioButton2.apply(this, arguments);
      }

      return _saveRadioButton;
    }()
  }, {
    key: "_getDefaultCheckedAppearance",
    value: function _getDefaultCheckedAppearance(params, type) {
      var width = this.data.rect[2] - this.data.rect[0];
      var height = this.data.rect[3] - this.data.rect[1];
      var bbox = [0, 0, width, height];
      var FONT_RATIO = 0.8;
      var fontSize = Math.min(width, height) * FONT_RATIO;

      var metrics, _char;

      if (type === "check") {
        metrics = {
          width: 0.755 * fontSize,
          height: 0.705 * fontSize
        };
        _char = "\x33";
      } else if (type === "disc") {
        metrics = {
          width: 0.791 * fontSize,
          height: 0.705 * fontSize
        };
        _char = "\x6C";
      } else {
        (0, _util.unreachable)("_getDefaultCheckedAppearance - unsupported type: ".concat(type));
      }

      var xShift = (width - metrics.width) / 2;
      var yShift = (height - metrics.height) / 2;
      var appearance = "q BT /PdfJsZaDb ".concat(fontSize, " Tf 0 g ").concat(xShift, " ").concat(yShift, " Td (").concat(_char, ") Tj ET Q");
      var appearanceStreamDict = new _primitives.Dict(params.xref);
      appearanceStreamDict.set("FormType", 1);
      appearanceStreamDict.set("Subtype", _primitives.Name.get("Form"));
      appearanceStreamDict.set("Type", _primitives.Name.get("XObject"));
      appearanceStreamDict.set("BBox", bbox);
      appearanceStreamDict.set("Matrix", [1, 0, 0, 1, 0, 0]);
      appearanceStreamDict.set("Length", appearance.length);
      var resources = new _primitives.Dict(params.xref);
      var font = new _primitives.Dict(params.xref);
      font.set("PdfJsZaDb", this.fallbackFontDict);
      resources.set("Font", font);
      appearanceStreamDict.set("Resources", resources);
      this.checkedAppearance = new _stream.StringStream(appearance);
      this.checkedAppearance.dict = appearanceStreamDict;

      this._streams.push(this.checkedAppearance);
    }
  }, {
    key: "_processCheckBox",
    value: function _processCheckBox(params) {
      var customAppearance = params.dict.get("AP");

      if (!(customAppearance instanceof _primitives.Dict)) {
        return;
      }

      var normalAppearance = customAppearance.get("N");

      if (!(normalAppearance instanceof _primitives.Dict)) {
        return;
      }

      var asValue = this._decodeFormValue(params.dict.get("AS"));

      if (typeof asValue === "string") {
        this.data.fieldValue = asValue;
      }

      var yes = this.data.fieldValue !== null && this.data.fieldValue !== "Off" ? this.data.fieldValue : "Yes";
      var exportValues = normalAppearance.getKeys();

      if (exportValues.length === 0) {
        exportValues.push("Off", yes);
      } else if (exportValues.length === 1) {
        if (exportValues[0] === "Off") {
          exportValues.push(yes);
        } else {
          exportValues.unshift("Off");
        }
      } else if (exportValues.includes(yes)) {
        exportValues.length = 0;
        exportValues.push("Off", yes);
      } else {
        var otherYes = exportValues.find(function (v) {
          return v !== "Off";
        });
        exportValues.length = 0;
        exportValues.push("Off", otherYes);
      }

      if (!exportValues.includes(this.data.fieldValue)) {
        this.data.fieldValue = "Off";
      }

      this.data.exportValue = exportValues[1];
      this.checkedAppearance = normalAppearance.get(this.data.exportValue) || null;
      this.uncheckedAppearance = normalAppearance.get("Off") || null;

      if (this.checkedAppearance) {
        this._streams.push(this.checkedAppearance);
      } else {
        this._getDefaultCheckedAppearance(params, "check");
      }

      if (this.uncheckedAppearance) {
        this._streams.push(this.uncheckedAppearance);
      }

      this._fallbackFontDict = this.fallbackFontDict;
    }
  }, {
    key: "_processRadioButton",
    value: function _processRadioButton(params) {
      this.data.fieldValue = this.data.buttonValue = null;
      var fieldParent = params.dict.get("Parent");

      if (fieldParent instanceof _primitives.Dict) {
        this.parent = params.dict.getRaw("Parent");
        var fieldParentValue = fieldParent.get("V");

        if (fieldParentValue instanceof _primitives.Name) {
          this.data.fieldValue = this._decodeFormValue(fieldParentValue);
        }
      }

      var appearanceStates = params.dict.get("AP");

      if (!(appearanceStates instanceof _primitives.Dict)) {
        return;
      }

      var normalAppearance = appearanceStates.get("N");

      if (!(normalAppearance instanceof _primitives.Dict)) {
        return;
      }

      var _iterator10 = _createForOfIteratorHelper(normalAppearance.getKeys()),
          _step10;

      try {
        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
          var key = _step10.value;

          if (key !== "Off") {
            this.data.buttonValue = this._decodeFormValue(key);
            break;
          }
        }
      } catch (err) {
        _iterator10.e(err);
      } finally {
        _iterator10.f();
      }

      this.checkedAppearance = normalAppearance.get(this.data.buttonValue) || null;
      this.uncheckedAppearance = normalAppearance.get("Off") || null;

      if (this.checkedAppearance) {
        this._streams.push(this.checkedAppearance);
      } else {
        this._getDefaultCheckedAppearance(params, "disc");
      }

      if (this.uncheckedAppearance) {
        this._streams.push(this.uncheckedAppearance);
      }

      this._fallbackFontDict = this.fallbackFontDict;
    }
  }, {
    key: "_processPushButton",
    value: function _processPushButton(params) {
      if (!params.dict.has("A") && !params.dict.has("AA") && !this.data.alternativeText) {
        (0, _util.warn)("Push buttons without action dictionaries are not supported");
        return;
      }

      this.data.isTooltipOnly = !params.dict.has("A") && !params.dict.has("AA");

      _catalog.Catalog.parseDestDictionary({
        destDict: params.dict,
        resultObj: this.data,
        docBaseUrl: params.pdfManager.docBaseUrl
      });
    }
  }, {
    key: "getFieldObject",
    value: function getFieldObject() {
      var type = "button";
      var exportValues;

      if (this.data.checkBox) {
        type = "checkbox";
        exportValues = this.data.exportValue;
      } else if (this.data.radioButton) {
        type = "radiobutton";
        exportValues = this.data.buttonValue;
      }

      return {
        id: this.data.id,
        value: this.data.fieldValue || "Off",
        defaultValue: this.data.defaultFieldValue,
        exportValues: exportValues,
        editable: !this.data.readOnly,
        name: this.data.fieldName,
        rect: this.data.rect,
        hidden: this.data.hidden,
        actions: this.data.actions,
        page: this.data.pageIndex,
        strokeColor: this.data.borderColor,
        fillColor: this.data.backgroundColor,
        type: type
      };
    }
  }, {
    key: "fallbackFontDict",
    get: function get() {
      var dict = new _primitives.Dict();
      dict.set("BaseFont", _primitives.Name.get("ZapfDingbats"));
      dict.set("Type", _primitives.Name.get("FallbackType"));
      dict.set("Subtype", _primitives.Name.get("FallbackType"));
      dict.set("Encoding", _primitives.Name.get("ZapfDingbatsEncoding"));
      return (0, _util.shadow)(this, "fallbackFontDict", dict);
    }
  }]);

  return ButtonWidgetAnnotation;
}(WidgetAnnotation);

var ChoiceWidgetAnnotation = /*#__PURE__*/function (_WidgetAnnotation3) {
  _inherits(ChoiceWidgetAnnotation, _WidgetAnnotation3);

  var _super5 = _createSuper(ChoiceWidgetAnnotation);

  function ChoiceWidgetAnnotation(params) {
    var _this9;

    _classCallCheck(this, ChoiceWidgetAnnotation);

    _this9 = _super5.call(this, params);
    _this9.data.options = [];
    var options = (0, _core_utils.getInheritableProperty)({
      dict: params.dict,
      key: "Opt"
    });

    if (Array.isArray(options)) {
      var xref = params.xref;

      for (var i = 0, ii = options.length; i < ii; i++) {
        var option = xref.fetchIfRef(options[i]);
        var isOptionArray = Array.isArray(option);
        _this9.data.options[i] = {
          exportValue: _this9._decodeFormValue(isOptionArray ? xref.fetchIfRef(option[0]) : option),
          displayValue: _this9._decodeFormValue(isOptionArray ? xref.fetchIfRef(option[1]) : option)
        };
      }
    }

    if (typeof _this9.data.fieldValue === "string") {
      _this9.data.fieldValue = [_this9.data.fieldValue];
    } else if (!_this9.data.fieldValue) {
      _this9.data.fieldValue = [];
    }

    _this9.data.combo = _this9.hasFieldFlag(_util.AnnotationFieldFlag.COMBO);
    _this9.data.multiSelect = _this9.hasFieldFlag(_util.AnnotationFieldFlag.MULTISELECT);
    _this9._hasText = true;
    return _this9;
  }

  _createClass(ChoiceWidgetAnnotation, [{
    key: "getFieldObject",
    value: function getFieldObject() {
      var type = this.data.combo ? "combobox" : "listbox";
      var value = this.data.fieldValue.length > 0 ? this.data.fieldValue[0] : null;
      return {
        id: this.data.id,
        value: value,
        defaultValue: this.data.defaultFieldValue,
        editable: !this.data.readOnly,
        name: this.data.fieldName,
        rect: this.data.rect,
        numItems: this.data.fieldValue.length,
        multipleSelection: this.data.multiSelect,
        hidden: this.data.hidden,
        actions: this.data.actions,
        items: this.data.options,
        page: this.data.pageIndex,
        strokeColor: this.data.borderColor,
        fillColor: this.data.backgroundColor,
        type: type
      };
    }
  }]);

  return ChoiceWidgetAnnotation;
}(WidgetAnnotation);

var SignatureWidgetAnnotation = /*#__PURE__*/function (_WidgetAnnotation4) {
  _inherits(SignatureWidgetAnnotation, _WidgetAnnotation4);

  var _super6 = _createSuper(SignatureWidgetAnnotation);

  function SignatureWidgetAnnotation(params) {
    var _this10;

    _classCallCheck(this, SignatureWidgetAnnotation);

    _this10 = _super6.call(this, params);
    _this10.data.fieldValue = null;
    return _this10;
  }

  _createClass(SignatureWidgetAnnotation, [{
    key: "getFieldObject",
    value: function getFieldObject() {
      return {
        id: this.data.id,
        value: null,
        page: this.data.pageIndex,
        type: "signature"
      };
    }
  }]);

  return SignatureWidgetAnnotation;
}(WidgetAnnotation);

var TextAnnotation = /*#__PURE__*/function (_MarkupAnnotation) {
  _inherits(TextAnnotation, _MarkupAnnotation);

  var _super7 = _createSuper(TextAnnotation);

  function TextAnnotation(parameters) {
    var _this11;

    _classCallCheck(this, TextAnnotation);

    var DEFAULT_ICON_SIZE = 22;
    _this11 = _super7.call(this, parameters);
    var dict = parameters.dict;
    _this11.data.annotationType = _util.AnnotationType.TEXT;

    if (_this11.data.hasAppearance) {
      _this11.data.name = "NoIcon";
    } else {
      _this11.data.rect[1] = _this11.data.rect[3] - DEFAULT_ICON_SIZE;
      _this11.data.rect[2] = _this11.data.rect[0] + DEFAULT_ICON_SIZE;
      _this11.data.name = dict.has("Name") ? dict.get("Name").name : "Note";
    }

    if (dict.has("State")) {
      _this11.data.state = dict.get("State") || null;
      _this11.data.stateModel = dict.get("StateModel") || null;
    } else {
      _this11.data.state = null;
      _this11.data.stateModel = null;
    }

    return _this11;
  }

  return _createClass(TextAnnotation);
}(MarkupAnnotation);

var LinkAnnotation = /*#__PURE__*/function (_Annotation3) {
  _inherits(LinkAnnotation, _Annotation3);

  var _super8 = _createSuper(LinkAnnotation);

  function LinkAnnotation(params) {
    var _this12;

    _classCallCheck(this, LinkAnnotation);

    _this12 = _super8.call(this, params);
    _this12.data.annotationType = _util.AnnotationType.LINK;
    var quadPoints = getQuadPoints(params.dict, _this12.rectangle);

    if (quadPoints) {
      _this12.data.quadPoints = quadPoints;
    }

    _catalog.Catalog.parseDestDictionary({
      destDict: params.dict,
      resultObj: _this12.data,
      docBaseUrl: params.pdfManager.docBaseUrl
    });

    return _this12;
  }

  return _createClass(LinkAnnotation);
}(Annotation);

var PopupAnnotation = /*#__PURE__*/function (_Annotation4) {
  _inherits(PopupAnnotation, _Annotation4);

  var _super9 = _createSuper(PopupAnnotation);

  function PopupAnnotation(parameters) {
    var _this13;

    _classCallCheck(this, PopupAnnotation);

    _this13 = _super9.call(this, parameters);
    _this13.data.annotationType = _util.AnnotationType.POPUP;
    var parentItem = parameters.dict.get("Parent");

    if (!parentItem) {
      (0, _util.warn)("Popup annotation has a missing or invalid parent annotation.");
      return _possibleConstructorReturn(_this13);
    }

    var parentSubtype = parentItem.get("Subtype");
    _this13.data.parentType = parentSubtype instanceof _primitives.Name ? parentSubtype.name : null;
    var rawParent = parameters.dict.getRaw("Parent");
    _this13.data.parentId = rawParent instanceof _primitives.Ref ? rawParent.toString() : null;
    var parentRect = parentItem.getArray("Rect");

    if (Array.isArray(parentRect) && parentRect.length === 4) {
      _this13.data.parentRect = _util.Util.normalizeRect(parentRect);
    } else {
      _this13.data.parentRect = [0, 0, 0, 0];
    }

    var rt = parentItem.get("RT");

    if ((0, _primitives.isName)(rt, _util.AnnotationReplyType.GROUP)) {
      parentItem = parentItem.get("IRT");
    }

    if (!parentItem.has("M")) {
      _this13.data.modificationDate = null;
    } else {
      _this13.setModificationDate(parentItem.get("M"));

      _this13.data.modificationDate = _this13.modificationDate;
    }

    if (!parentItem.has("C")) {
      _this13.data.color = null;
    } else {
      _this13.setColor(parentItem.getArray("C"));

      _this13.data.color = _this13.color;
    }

    if (!_this13.viewable) {
      var parentFlags = parentItem.get("F");

      if (_this13._isViewable(parentFlags)) {
        _this13.setFlags(parentFlags);
      }
    }

    _this13.setTitle(parentItem.get("T"));

    _this13.data.titleObj = _this13._title;

    _this13.setContents(parentItem.get("Contents"));

    _this13.data.contentsObj = _this13._contents;

    if (parentItem.has("RC")) {
      _this13.data.richText = _factory.XFAFactory.getRichTextAsHtml(parentItem.get("RC"));
    }

    return _this13;
  }

  return _createClass(PopupAnnotation);
}(Annotation);

var FreeTextAnnotation = /*#__PURE__*/function (_MarkupAnnotation2) {
  _inherits(FreeTextAnnotation, _MarkupAnnotation2);

  var _super10 = _createSuper(FreeTextAnnotation);

  function FreeTextAnnotation(parameters) {
    var _this14;

    _classCallCheck(this, FreeTextAnnotation);

    _this14 = _super10.call(this, parameters);
    _this14.data.annotationType = _util.AnnotationType.FREETEXT;
    return _this14;
  }

  return _createClass(FreeTextAnnotation);
}(MarkupAnnotation);

var LineAnnotation = /*#__PURE__*/function (_MarkupAnnotation3) {
  _inherits(LineAnnotation, _MarkupAnnotation3);

  var _super11 = _createSuper(LineAnnotation);

  function LineAnnotation(parameters) {
    var _this15;

    _classCallCheck(this, LineAnnotation);

    _this15 = _super11.call(this, parameters);
    _this15.data.annotationType = _util.AnnotationType.LINE;
    var lineCoordinates = parameters.dict.getArray("L");
    _this15.data.lineCoordinates = _util.Util.normalizeRect(lineCoordinates);

    if (!_this15.appearance) {
      var strokeColor = _this15.color ? Array.from(_this15.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var fillColor = null,
          interiorColor = parameters.dict.getArray("IC");

      if (interiorColor) {
        interiorColor = getRgbColor(interiorColor, null);
        fillColor = interiorColor ? Array.from(interiorColor).map(function (c) {
          return c / 255;
        }) : null;
      }

      var fillAlpha = fillColor ? strokeAlpha : null;
      var borderWidth = _this15.borderStyle.width || 1,
          borderAdjust = 2 * borderWidth;
      var bbox = [_this15.data.lineCoordinates[0] - borderAdjust, _this15.data.lineCoordinates[1] - borderAdjust, _this15.data.lineCoordinates[2] + borderAdjust, _this15.data.lineCoordinates[3] + borderAdjust];

      if (!_util.Util.intersect(_this15.rectangle, bbox)) {
        _this15.rectangle = bbox;
      }

      _this15._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(borderWidth, " w"),
        strokeColor: strokeColor,
        fillColor: fillColor,
        strokeAlpha: strokeAlpha,
        fillAlpha: fillAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          buffer.push("".concat(lineCoordinates[0], " ").concat(lineCoordinates[1], " m"), "".concat(lineCoordinates[2], " ").concat(lineCoordinates[3], " l"), "S");
          return [points[0].x - borderWidth, points[1].x + borderWidth, points[3].y - borderWidth, points[1].y + borderWidth];
        }
      });
    }

    return _this15;
  }

  return _createClass(LineAnnotation);
}(MarkupAnnotation);

var SquareAnnotation = /*#__PURE__*/function (_MarkupAnnotation4) {
  _inherits(SquareAnnotation, _MarkupAnnotation4);

  var _super12 = _createSuper(SquareAnnotation);

  function SquareAnnotation(parameters) {
    var _this16;

    _classCallCheck(this, SquareAnnotation);

    _this16 = _super12.call(this, parameters);
    _this16.data.annotationType = _util.AnnotationType.SQUARE;

    if (!_this16.appearance) {
      var strokeColor = _this16.color ? Array.from(_this16.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var fillColor = null,
          interiorColor = parameters.dict.getArray("IC");

      if (interiorColor) {
        interiorColor = getRgbColor(interiorColor, null);
        fillColor = interiorColor ? Array.from(interiorColor).map(function (c) {
          return c / 255;
        }) : null;
      }

      var fillAlpha = fillColor ? strokeAlpha : null;

      if (_this16.borderStyle.width === 0 && !fillColor) {
        return _possibleConstructorReturn(_this16);
      }

      _this16._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(_this16.borderStyle.width, " w"),
        strokeColor: strokeColor,
        fillColor: fillColor,
        strokeAlpha: strokeAlpha,
        fillAlpha: fillAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          var x = points[2].x + _this16.borderStyle.width / 2;
          var y = points[2].y + _this16.borderStyle.width / 2;
          var width = points[3].x - points[2].x - _this16.borderStyle.width;
          var height = points[1].y - points[3].y - _this16.borderStyle.width;
          buffer.push("".concat(x, " ").concat(y, " ").concat(width, " ").concat(height, " re"));

          if (fillColor) {
            buffer.push("B");
          } else {
            buffer.push("S");
          }

          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }

    return _this16;
  }

  return _createClass(SquareAnnotation);
}(MarkupAnnotation);

var CircleAnnotation = /*#__PURE__*/function (_MarkupAnnotation5) {
  _inherits(CircleAnnotation, _MarkupAnnotation5);

  var _super13 = _createSuper(CircleAnnotation);

  function CircleAnnotation(parameters) {
    var _this17;

    _classCallCheck(this, CircleAnnotation);

    _this17 = _super13.call(this, parameters);
    _this17.data.annotationType = _util.AnnotationType.CIRCLE;

    if (!_this17.appearance) {
      var strokeColor = _this17.color ? Array.from(_this17.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var fillColor = null;
      var interiorColor = parameters.dict.getArray("IC");

      if (interiorColor) {
        interiorColor = getRgbColor(interiorColor, null);
        fillColor = interiorColor ? Array.from(interiorColor).map(function (c) {
          return c / 255;
        }) : null;
      }

      var fillAlpha = fillColor ? strokeAlpha : null;

      if (_this17.borderStyle.width === 0 && !fillColor) {
        return _possibleConstructorReturn(_this17);
      }

      var controlPointsDistance = 4 / 3 * Math.tan(Math.PI / (2 * 4));

      _this17._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(_this17.borderStyle.width, " w"),
        strokeColor: strokeColor,
        fillColor: fillColor,
        strokeAlpha: strokeAlpha,
        fillAlpha: fillAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          var x0 = points[0].x + _this17.borderStyle.width / 2;
          var y0 = points[0].y - _this17.borderStyle.width / 2;
          var x1 = points[3].x - _this17.borderStyle.width / 2;
          var y1 = points[3].y + _this17.borderStyle.width / 2;
          var xMid = x0 + (x1 - x0) / 2;
          var yMid = y0 + (y1 - y0) / 2;
          var xOffset = (x1 - x0) / 2 * controlPointsDistance;
          var yOffset = (y1 - y0) / 2 * controlPointsDistance;
          buffer.push("".concat(xMid, " ").concat(y1, " m"), "".concat(xMid + xOffset, " ").concat(y1, " ").concat(x1, " ").concat(yMid + yOffset, " ").concat(x1, " ").concat(yMid, " c"), "".concat(x1, " ").concat(yMid - yOffset, " ").concat(xMid + xOffset, " ").concat(y0, " ").concat(xMid, " ").concat(y0, " c"), "".concat(xMid - xOffset, " ").concat(y0, " ").concat(x0, " ").concat(yMid - yOffset, " ").concat(x0, " ").concat(yMid, " c"), "".concat(x0, " ").concat(yMid + yOffset, " ").concat(xMid - xOffset, " ").concat(y1, " ").concat(xMid, " ").concat(y1, " c"), "h");

          if (fillColor) {
            buffer.push("B");
          } else {
            buffer.push("S");
          }

          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }

    return _this17;
  }

  return _createClass(CircleAnnotation);
}(MarkupAnnotation);

var PolylineAnnotation = /*#__PURE__*/function (_MarkupAnnotation6) {
  _inherits(PolylineAnnotation, _MarkupAnnotation6);

  var _super14 = _createSuper(PolylineAnnotation);

  function PolylineAnnotation(parameters) {
    var _this18;

    _classCallCheck(this, PolylineAnnotation);

    _this18 = _super14.call(this, parameters);
    _this18.data.annotationType = _util.AnnotationType.POLYLINE;
    _this18.data.vertices = [];
    var rawVertices = parameters.dict.getArray("Vertices");

    if (!Array.isArray(rawVertices)) {
      return _possibleConstructorReturn(_this18);
    }

    for (var i = 0, ii = rawVertices.length; i < ii; i += 2) {
      _this18.data.vertices.push({
        x: rawVertices[i],
        y: rawVertices[i + 1]
      });
    }

    if (!_this18.appearance) {
      var strokeColor = _this18.color ? Array.from(_this18.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var borderWidth = _this18.borderStyle.width || 1,
          borderAdjust = 2 * borderWidth;
      var bbox = [Infinity, Infinity, -Infinity, -Infinity];

      var _iterator11 = _createForOfIteratorHelper(_this18.data.vertices),
          _step11;

      try {
        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
          var vertex = _step11.value;
          bbox[0] = Math.min(bbox[0], vertex.x - borderAdjust);
          bbox[1] = Math.min(bbox[1], vertex.y - borderAdjust);
          bbox[2] = Math.max(bbox[2], vertex.x + borderAdjust);
          bbox[3] = Math.max(bbox[3], vertex.y + borderAdjust);
        }
      } catch (err) {
        _iterator11.e(err);
      } finally {
        _iterator11.f();
      }

      if (!_util.Util.intersect(_this18.rectangle, bbox)) {
        _this18.rectangle = bbox;
      }

      _this18._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(borderWidth, " w"),
        strokeColor: strokeColor,
        strokeAlpha: strokeAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          var vertices = _this18.data.vertices;

          for (var _i3 = 0, _ii = vertices.length; _i3 < _ii; _i3++) {
            buffer.push("".concat(vertices[_i3].x, " ").concat(vertices[_i3].y, " ").concat(_i3 === 0 ? "m" : "l"));
          }

          buffer.push("S");
          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }

    return _this18;
  }

  return _createClass(PolylineAnnotation);
}(MarkupAnnotation);

var PolygonAnnotation = /*#__PURE__*/function (_PolylineAnnotation) {
  _inherits(PolygonAnnotation, _PolylineAnnotation);

  var _super15 = _createSuper(PolygonAnnotation);

  function PolygonAnnotation(parameters) {
    var _this19;

    _classCallCheck(this, PolygonAnnotation);

    _this19 = _super15.call(this, parameters);
    _this19.data.annotationType = _util.AnnotationType.POLYGON;
    return _this19;
  }

  return _createClass(PolygonAnnotation);
}(PolylineAnnotation);

var CaretAnnotation = /*#__PURE__*/function (_MarkupAnnotation7) {
  _inherits(CaretAnnotation, _MarkupAnnotation7);

  var _super16 = _createSuper(CaretAnnotation);

  function CaretAnnotation(parameters) {
    var _this20;

    _classCallCheck(this, CaretAnnotation);

    _this20 = _super16.call(this, parameters);
    _this20.data.annotationType = _util.AnnotationType.CARET;
    return _this20;
  }

  return _createClass(CaretAnnotation);
}(MarkupAnnotation);

var InkAnnotation = /*#__PURE__*/function (_MarkupAnnotation8) {
  _inherits(InkAnnotation, _MarkupAnnotation8);

  var _super17 = _createSuper(InkAnnotation);

  function InkAnnotation(parameters) {
    var _this21;

    _classCallCheck(this, InkAnnotation);

    _this21 = _super17.call(this, parameters);
    _this21.data.annotationType = _util.AnnotationType.INK;
    _this21.data.inkLists = [];
    var rawInkLists = parameters.dict.getArray("InkList");

    if (!Array.isArray(rawInkLists)) {
      return _possibleConstructorReturn(_this21);
    }

    var xref = parameters.xref;

    for (var i = 0, ii = rawInkLists.length; i < ii; ++i) {
      _this21.data.inkLists.push([]);

      for (var j = 0, jj = rawInkLists[i].length; j < jj; j += 2) {
        _this21.data.inkLists[i].push({
          x: xref.fetchIfRef(rawInkLists[i][j]),
          y: xref.fetchIfRef(rawInkLists[i][j + 1])
        });
      }
    }

    if (!_this21.appearance) {
      var strokeColor = _this21.color ? Array.from(_this21.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var borderWidth = _this21.borderStyle.width || 1,
          borderAdjust = 2 * borderWidth;
      var bbox = [Infinity, Infinity, -Infinity, -Infinity];

      var _iterator12 = _createForOfIteratorHelper(_this21.data.inkLists),
          _step12;

      try {
        for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
          var inkLists = _step12.value;

          var _iterator14 = _createForOfIteratorHelper(inkLists),
              _step14;

          try {
            for (_iterator14.s(); !(_step14 = _iterator14.n()).done;) {
              var vertex = _step14.value;
              bbox[0] = Math.min(bbox[0], vertex.x - borderAdjust);
              bbox[1] = Math.min(bbox[1], vertex.y - borderAdjust);
              bbox[2] = Math.max(bbox[2], vertex.x + borderAdjust);
              bbox[3] = Math.max(bbox[3], vertex.y + borderAdjust);
            }
          } catch (err) {
            _iterator14.e(err);
          } finally {
            _iterator14.f();
          }
        }
      } catch (err) {
        _iterator12.e(err);
      } finally {
        _iterator12.f();
      }

      if (!_util.Util.intersect(_this21.rectangle, bbox)) {
        _this21.rectangle = bbox;
      }

      _this21._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(borderWidth, " w"),
        strokeColor: strokeColor,
        strokeAlpha: strokeAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          var _iterator13 = _createForOfIteratorHelper(_this21.data.inkLists),
              _step13;

          try {
            for (_iterator13.s(); !(_step13 = _iterator13.n()).done;) {
              var inkList = _step13.value;

              for (var _i4 = 0, _ii2 = inkList.length; _i4 < _ii2; _i4++) {
                buffer.push("".concat(inkList[_i4].x, " ").concat(inkList[_i4].y, " ").concat(_i4 === 0 ? "m" : "l"));
              }

              buffer.push("S");
            }
          } catch (err) {
            _iterator13.e(err);
          } finally {
            _iterator13.f();
          }

          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }

    return _this21;
  }

  return _createClass(InkAnnotation);
}(MarkupAnnotation);

var HighlightAnnotation = /*#__PURE__*/function (_MarkupAnnotation9) {
  _inherits(HighlightAnnotation, _MarkupAnnotation9);

  var _super18 = _createSuper(HighlightAnnotation);

  function HighlightAnnotation(parameters) {
    var _this22;

    _classCallCheck(this, HighlightAnnotation);

    _this22 = _super18.call(this, parameters);
    _this22.data.annotationType = _util.AnnotationType.HIGHLIGHT;
    var quadPoints = _this22.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      var resources = _this22.appearance && _this22.appearance.dict.get("Resources");

      if (!_this22.appearance || !(resources && resources.has("ExtGState"))) {
        if (_this22.appearance) {
          (0, _util.warn)("HighlightAnnotation - ignoring built-in appearance stream.");
        }

        var fillColor = _this22.color ? Array.from(_this22.color).map(function (c) {
          return c / 255;
        }) : [1, 1, 0];
        var fillAlpha = parameters.dict.get("CA");

        _this22._setDefaultAppearance({
          xref: parameters.xref,
          fillColor: fillColor,
          blendMode: "Multiply",
          fillAlpha: fillAlpha,
          pointsCallback: function pointsCallback(buffer, points) {
            buffer.push("".concat(points[0].x, " ").concat(points[0].y, " m"), "".concat(points[1].x, " ").concat(points[1].y, " l"), "".concat(points[3].x, " ").concat(points[3].y, " l"), "".concat(points[2].x, " ").concat(points[2].y, " l"), "f");
            return [points[0].x, points[1].x, points[3].y, points[1].y];
          }
        });
      }
    } else {
      _this22.data.hasPopup = false;
    }

    return _this22;
  }

  return _createClass(HighlightAnnotation);
}(MarkupAnnotation);

var UnderlineAnnotation = /*#__PURE__*/function (_MarkupAnnotation10) {
  _inherits(UnderlineAnnotation, _MarkupAnnotation10);

  var _super19 = _createSuper(UnderlineAnnotation);

  function UnderlineAnnotation(parameters) {
    var _this23;

    _classCallCheck(this, UnderlineAnnotation);

    _this23 = _super19.call(this, parameters);
    _this23.data.annotationType = _util.AnnotationType.UNDERLINE;
    var quadPoints = _this23.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      if (!_this23.appearance) {
        var strokeColor = _this23.color ? Array.from(_this23.color).map(function (c) {
          return c / 255;
        }) : [0, 0, 0];
        var strokeAlpha = parameters.dict.get("CA");

        _this23._setDefaultAppearance({
          xref: parameters.xref,
          extra: "[] 0 d 1 w",
          strokeColor: strokeColor,
          strokeAlpha: strokeAlpha,
          pointsCallback: function pointsCallback(buffer, points) {
            buffer.push("".concat(points[2].x, " ").concat(points[2].y, " m"), "".concat(points[3].x, " ").concat(points[3].y, " l"), "S");
            return [points[0].x, points[1].x, points[3].y, points[1].y];
          }
        });
      }
    } else {
      _this23.data.hasPopup = false;
    }

    return _this23;
  }

  return _createClass(UnderlineAnnotation);
}(MarkupAnnotation);

var SquigglyAnnotation = /*#__PURE__*/function (_MarkupAnnotation11) {
  _inherits(SquigglyAnnotation, _MarkupAnnotation11);

  var _super20 = _createSuper(SquigglyAnnotation);

  function SquigglyAnnotation(parameters) {
    var _this24;

    _classCallCheck(this, SquigglyAnnotation);

    _this24 = _super20.call(this, parameters);
    _this24.data.annotationType = _util.AnnotationType.SQUIGGLY;
    var quadPoints = _this24.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      if (!_this24.appearance) {
        var strokeColor = _this24.color ? Array.from(_this24.color).map(function (c) {
          return c / 255;
        }) : [0, 0, 0];
        var strokeAlpha = parameters.dict.get("CA");

        _this24._setDefaultAppearance({
          xref: parameters.xref,
          extra: "[] 0 d 1 w",
          strokeColor: strokeColor,
          strokeAlpha: strokeAlpha,
          pointsCallback: function pointsCallback(buffer, points) {
            var dy = (points[0].y - points[2].y) / 6;
            var shift = dy;
            var x = points[2].x;
            var y = points[2].y;
            var xEnd = points[3].x;
            buffer.push("".concat(x, " ").concat(y + shift, " m"));

            do {
              x += 2;
              shift = shift === 0 ? dy : 0;
              buffer.push("".concat(x, " ").concat(y + shift, " l"));
            } while (x < xEnd);

            buffer.push("S");
            return [points[2].x, xEnd, y - 2 * dy, y + 2 * dy];
          }
        });
      }
    } else {
      _this24.data.hasPopup = false;
    }

    return _this24;
  }

  return _createClass(SquigglyAnnotation);
}(MarkupAnnotation);

var StrikeOutAnnotation = /*#__PURE__*/function (_MarkupAnnotation12) {
  _inherits(StrikeOutAnnotation, _MarkupAnnotation12);

  var _super21 = _createSuper(StrikeOutAnnotation);

  function StrikeOutAnnotation(parameters) {
    var _this25;

    _classCallCheck(this, StrikeOutAnnotation);

    _this25 = _super21.call(this, parameters);
    _this25.data.annotationType = _util.AnnotationType.STRIKEOUT;
    var quadPoints = _this25.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      if (!_this25.appearance) {
        var strokeColor = _this25.color ? Array.from(_this25.color).map(function (c) {
          return c / 255;
        }) : [0, 0, 0];
        var strokeAlpha = parameters.dict.get("CA");

        _this25._setDefaultAppearance({
          xref: parameters.xref,
          extra: "[] 0 d 1 w",
          strokeColor: strokeColor,
          strokeAlpha: strokeAlpha,
          pointsCallback: function pointsCallback(buffer, points) {
            buffer.push("".concat((points[0].x + points[2].x) / 2, " ") + "".concat((points[0].y + points[2].y) / 2, " m"), "".concat((points[1].x + points[3].x) / 2, " ") + "".concat((points[1].y + points[3].y) / 2, " l"), "S");
            return [points[0].x, points[1].x, points[3].y, points[1].y];
          }
        });
      }
    } else {
      _this25.data.hasPopup = false;
    }

    return _this25;
  }

  return _createClass(StrikeOutAnnotation);
}(MarkupAnnotation);

var StampAnnotation = /*#__PURE__*/function (_MarkupAnnotation13) {
  _inherits(StampAnnotation, _MarkupAnnotation13);

  var _super22 = _createSuper(StampAnnotation);

  function StampAnnotation(parameters) {
    var _this26;

    _classCallCheck(this, StampAnnotation);

    _this26 = _super22.call(this, parameters);
    _this26.data.annotationType = _util.AnnotationType.STAMP;
    return _this26;
  }

  return _createClass(StampAnnotation);
}(MarkupAnnotation);

var FileAttachmentAnnotation = /*#__PURE__*/function (_MarkupAnnotation14) {
  _inherits(FileAttachmentAnnotation, _MarkupAnnotation14);

  var _super23 = _createSuper(FileAttachmentAnnotation);

  function FileAttachmentAnnotation(parameters) {
    var _this27;

    _classCallCheck(this, FileAttachmentAnnotation);

    _this27 = _super23.call(this, parameters);
    var file = new _file_spec.FileSpec(parameters.dict.get("FS"), parameters.xref);
    _this27.data.annotationType = _util.AnnotationType.FILEATTACHMENT;
    _this27.data.file = file.serializable;
    return _this27;
  }

  return _createClass(FileAttachmentAnnotation);
}(MarkupAnnotation);

/***/ }),
/* 165 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createDefaultAppearance = createDefaultAppearance;
exports.parseDefaultAppearance = parseDefaultAppearance;

var _util = __w_pdfjs_require__(4);

var _colorspace = __w_pdfjs_require__(166);

var _core_utils = __w_pdfjs_require__(150);

var _evaluator = __w_pdfjs_require__(167);

var _primitives = __w_pdfjs_require__(147);

var _stream = __w_pdfjs_require__(152);

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var DefaultAppearanceEvaluator = /*#__PURE__*/function (_EvaluatorPreprocesso) {
  _inherits(DefaultAppearanceEvaluator, _EvaluatorPreprocesso);

  var _super = _createSuper(DefaultAppearanceEvaluator);

  function DefaultAppearanceEvaluator(str) {
    _classCallCheck(this, DefaultAppearanceEvaluator);

    return _super.call(this, new _stream.StringStream(str));
  }

  _createClass(DefaultAppearanceEvaluator, [{
    key: "parse",
    value: function parse() {
      var operation = {
        fn: 0,
        args: []
      };
      var result = {
        fontSize: 0,
        fontName: "",
        fontColor: new Uint8ClampedArray(3)
      };

      try {
        while (true) {
          operation.args.length = 0;

          if (!this.read(operation)) {
            break;
          }

          if (this.savedStatesDepth !== 0) {
            continue;
          }

          var fn = operation.fn,
              args = operation.args;

          switch (fn | 0) {
            case _util.OPS.setFont:
              var _args = _slicedToArray(args, 2),
                  fontName = _args[0],
                  fontSize = _args[1];

              if (fontName instanceof _primitives.Name) {
                result.fontName = fontName.name;
              }

              if (typeof fontSize === "number" && fontSize > 0) {
                result.fontSize = fontSize;
              }

              break;

            case _util.OPS.setFillRGBColor:
              _colorspace.ColorSpace.singletons.rgb.getRgbItem(args, 0, result.fontColor, 0);

              break;

            case _util.OPS.setFillGray:
              _colorspace.ColorSpace.singletons.gray.getRgbItem(args, 0, result.fontColor, 0);

              break;

            case _util.OPS.setFillColorSpace:
              _colorspace.ColorSpace.singletons.cmyk.getRgbItem(args, 0, result.fontColor, 0);

              break;
          }
        }
      } catch (reason) {
        (0, _util.warn)("parseDefaultAppearance - ignoring errors: \"".concat(reason, "\"."));
      }

      return result;
    }
  }]);

  return DefaultAppearanceEvaluator;
}(_evaluator.EvaluatorPreprocessor);

function parseDefaultAppearance(str) {
  return new DefaultAppearanceEvaluator(str).parse();
}

function createDefaultAppearance(_ref) {
  var fontSize = _ref.fontSize,
      fontName = _ref.fontName,
      fontColor = _ref.fontColor;
  var colorCmd;

  if (fontColor.every(function (c) {
    return c === 0;
  })) {
    colorCmd = "0 g";
  } else {
    colorCmd = Array.from(fontColor).map(function (c) {
      return (c / 255).toFixed(2);
    }).join(" ") + " rg";
  }

  return "/".concat((0, _core_utils.escapePDFName)(fontName), " ").concat(fontSize, " Tf ").concat(colorCmd);
}

/***/ }),
/* 166 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ColorSpace = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _primitives = __w_pdfjs_require__(147);

var _base_stream = __w_pdfjs_require__(151);

var _core_utils = __w_pdfjs_require__(150);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function resizeRgbImage(src, dest, w1, h1, w2, h2, alpha01) {
  var COMPONENTS = 3;
  alpha01 = alpha01 !== 1 ? 0 : alpha01;
  var xRatio = w1 / w2;
  var yRatio = h1 / h2;
  var newIndex = 0,
      oldIndex;
  var xScaled = new Uint16Array(w2);
  var w1Scanline = w1 * COMPONENTS;

  for (var i = 0; i < w2; i++) {
    xScaled[i] = Math.floor(i * xRatio) * COMPONENTS;
  }

  for (var _i = 0; _i < h2; _i++) {
    var py = Math.floor(_i * yRatio) * w1Scanline;

    for (var j = 0; j < w2; j++) {
      oldIndex = py + xScaled[j];
      dest[newIndex++] = src[oldIndex++];
      dest[newIndex++] = src[oldIndex++];
      dest[newIndex++] = src[oldIndex++];
      newIndex += alpha01;
    }
  }
}

var ColorSpace = /*#__PURE__*/function () {
  function ColorSpace(name, numComps) {
    _classCallCheck(this, ColorSpace);

    if (this.constructor === ColorSpace) {
      (0, _util.unreachable)("Cannot initialize ColorSpace.");
    }

    this.name = name;
    this.numComps = numComps;
  }

  _createClass(ColorSpace, [{
    key: "getRgb",
    value: function getRgb(src, srcOffset) {
      var rgb = new Uint8ClampedArray(3);
      this.getRgbItem(src, srcOffset, rgb, 0);
      return rgb;
    }
  }, {
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      (0, _util.unreachable)("Should not call ColorSpace.getRgbItem");
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      (0, _util.unreachable)("Should not call ColorSpace.getRgbBuffer");
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      (0, _util.unreachable)("Should not call ColorSpace.getOutputLength");
    }
  }, {
    key: "isPassthrough",
    value: function isPassthrough(bits) {
      return false;
    }
  }, {
    key: "isDefaultDecode",
    value: function isDefaultDecode(decodeMap, bpc) {
      return ColorSpace.isDefaultDecode(decodeMap, this.numComps);
    }
  }, {
    key: "fillRgb",
    value: function fillRgb(dest, originalWidth, originalHeight, width, height, actualHeight, bpc, comps, alpha01) {
      var count = originalWidth * originalHeight;
      var rgbBuf = null;
      var numComponentColors = 1 << bpc;
      var needsResizing = originalHeight !== height || originalWidth !== width;

      if (this.isPassthrough(bpc)) {
        rgbBuf = comps;
      } else if (this.numComps === 1 && count > numComponentColors && this.name !== "DeviceGray" && this.name !== "DeviceRGB") {
        var allColors = bpc <= 8 ? new Uint8Array(numComponentColors) : new Uint16Array(numComponentColors);

        for (var i = 0; i < numComponentColors; i++) {
          allColors[i] = i;
        }

        var colorMap = new Uint8ClampedArray(numComponentColors * 3);
        this.getRgbBuffer(allColors, 0, numComponentColors, colorMap, 0, bpc, 0);

        if (!needsResizing) {
          var destPos = 0;

          for (var _i2 = 0; _i2 < count; ++_i2) {
            var key = comps[_i2] * 3;
            dest[destPos++] = colorMap[key];
            dest[destPos++] = colorMap[key + 1];
            dest[destPos++] = colorMap[key + 2];
            destPos += alpha01;
          }
        } else {
          rgbBuf = new Uint8Array(count * 3);
          var rgbPos = 0;

          for (var _i3 = 0; _i3 < count; ++_i3) {
            var _key = comps[_i3] * 3;

            rgbBuf[rgbPos++] = colorMap[_key];
            rgbBuf[rgbPos++] = colorMap[_key + 1];
            rgbBuf[rgbPos++] = colorMap[_key + 2];
          }
        }
      } else {
        if (!needsResizing) {
          this.getRgbBuffer(comps, 0, width * actualHeight, dest, 0, bpc, alpha01);
        } else {
          rgbBuf = new Uint8ClampedArray(count * 3);
          this.getRgbBuffer(comps, 0, count, rgbBuf, 0, bpc, 0);
        }
      }

      if (rgbBuf) {
        if (needsResizing) {
          resizeRgbImage(rgbBuf, dest, originalWidth, originalHeight, width, height, alpha01);
        } else {
          var _destPos = 0,
              _rgbPos = 0;

          for (var _i4 = 0, ii = width * actualHeight; _i4 < ii; _i4++) {
            dest[_destPos++] = rgbBuf[_rgbPos++];
            dest[_destPos++] = rgbBuf[_rgbPos++];
            dest[_destPos++] = rgbBuf[_rgbPos++];
            _destPos += alpha01;
          }
        }
      }
    }
  }, {
    key: "usesZeroToOneRange",
    get: function get() {
      return (0, _util.shadow)(this, "usesZeroToOneRange", true);
    }
  }], [{
    key: "_cache",
    value: function _cache(cacheKey, xref, localColorSpaceCache, parsedColorSpace) {
      if (!localColorSpaceCache) {
        throw new Error('ColorSpace._cache - expected "localColorSpaceCache" argument.');
      }

      if (!parsedColorSpace) {
        throw new Error('ColorSpace._cache - expected "parsedColorSpace" argument.');
      }

      var csName, csRef;

      if (cacheKey instanceof _primitives.Ref) {
        csRef = cacheKey;
        cacheKey = xref.fetch(cacheKey);
      }

      if (cacheKey instanceof _primitives.Name) {
        csName = cacheKey.name;
      }

      if (csName || csRef) {
        localColorSpaceCache.set(csName, csRef, parsedColorSpace);
      }
    }
  }, {
    key: "getCached",
    value: function getCached(cacheKey, xref, localColorSpaceCache) {
      if (!localColorSpaceCache) {
        throw new Error('ColorSpace.getCached - expected "localColorSpaceCache" argument.');
      }

      if (cacheKey instanceof _primitives.Ref) {
        var localColorSpace = localColorSpaceCache.getByRef(cacheKey);

        if (localColorSpace) {
          return localColorSpace;
        }

        try {
          cacheKey = xref.fetch(cacheKey);
        } catch (ex) {
          if (ex instanceof _core_utils.MissingDataException) {
            throw ex;
          }
        }
      }

      if (cacheKey instanceof _primitives.Name) {
        var _localColorSpace = localColorSpaceCache.getByName(cacheKey.name);

        if (_localColorSpace) {
          return _localColorSpace;
        }
      }

      return null;
    }
  }, {
    key: "parseAsync",
    value: function () {
      var _parseAsync = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(_ref) {
        var cs, xref, _ref$resources, resources, pdfFunctionFactory, localColorSpaceCache, parsedColorSpace;

        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                cs = _ref.cs, xref = _ref.xref, _ref$resources = _ref.resources, resources = _ref$resources === void 0 ? null : _ref$resources, pdfFunctionFactory = _ref.pdfFunctionFactory, localColorSpaceCache = _ref.localColorSpaceCache;
                parsedColorSpace = this._parse(cs, xref, resources, pdfFunctionFactory);

                this._cache(cs, xref, localColorSpaceCache, parsedColorSpace);

                return _context.abrupt("return", parsedColorSpace);

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function parseAsync(_x) {
        return _parseAsync.apply(this, arguments);
      }

      return parseAsync;
    }()
  }, {
    key: "parse",
    value: function parse(_ref2) {
      var cs = _ref2.cs,
          xref = _ref2.xref,
          _ref2$resources = _ref2.resources,
          resources = _ref2$resources === void 0 ? null : _ref2$resources,
          pdfFunctionFactory = _ref2.pdfFunctionFactory,
          localColorSpaceCache = _ref2.localColorSpaceCache;
      var cachedColorSpace = this.getCached(cs, xref, localColorSpaceCache);

      if (cachedColorSpace) {
        return cachedColorSpace;
      }

      var parsedColorSpace = this._parse(cs, xref, resources, pdfFunctionFactory);

      this._cache(cs, xref, localColorSpaceCache, parsedColorSpace);

      return parsedColorSpace;
    }
  }, {
    key: "_parse",
    value: function _parse(cs, xref) {
      var resources = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      var pdfFunctionFactory = arguments.length > 3 ? arguments[3] : undefined;
      cs = xref.fetchIfRef(cs);

      if (cs instanceof _primitives.Name) {
        switch (cs.name) {
          case "G":
          case "DeviceGray":
            return this.singletons.gray;

          case "RGB":
          case "DeviceRGB":
            return this.singletons.rgb;

          case "CMYK":
          case "DeviceCMYK":
            return this.singletons.cmyk;

          case "Pattern":
            return new PatternCS(null);

          default:
            if (resources instanceof _primitives.Dict) {
              var colorSpaces = resources.get("ColorSpace");

              if (colorSpaces instanceof _primitives.Dict) {
                var resourcesCS = colorSpaces.get(cs.name);

                if (resourcesCS) {
                  if (resourcesCS instanceof _primitives.Name) {
                    return this._parse(resourcesCS, xref, resources, pdfFunctionFactory);
                  }

                  cs = resourcesCS;
                  break;
                }
              }
            }

            throw new _util.FormatError("Unrecognized ColorSpace: ".concat(cs.name));
        }
      }

      if (Array.isArray(cs)) {
        var mode = xref.fetchIfRef(cs[0]).name;
        var params, numComps, baseCS, whitePoint, blackPoint, gamma;

        switch (mode) {
          case "G":
          case "DeviceGray":
            return this.singletons.gray;

          case "RGB":
          case "DeviceRGB":
            return this.singletons.rgb;

          case "CMYK":
          case "DeviceCMYK":
            return this.singletons.cmyk;

          case "CalGray":
            params = xref.fetchIfRef(cs[1]);
            whitePoint = params.getArray("WhitePoint");
            blackPoint = params.getArray("BlackPoint");
            gamma = params.get("Gamma");
            return new CalGrayCS(whitePoint, blackPoint, gamma);

          case "CalRGB":
            params = xref.fetchIfRef(cs[1]);
            whitePoint = params.getArray("WhitePoint");
            blackPoint = params.getArray("BlackPoint");
            gamma = params.getArray("Gamma");
            var matrix = params.getArray("Matrix");
            return new CalRGBCS(whitePoint, blackPoint, gamma, matrix);

          case "ICCBased":
            var stream = xref.fetchIfRef(cs[1]);
            var dict = stream.dict;
            numComps = dict.get("N");
            var alt = dict.get("Alternate");

            if (alt) {
              var altCS = this._parse(alt, xref, resources, pdfFunctionFactory);

              if (altCS.numComps === numComps) {
                return altCS;
              }

              (0, _util.warn)("ICCBased color space: Ignoring incorrect /Alternate entry.");
            }

            if (numComps === 1) {
              return this.singletons.gray;
            } else if (numComps === 3) {
              return this.singletons.rgb;
            } else if (numComps === 4) {
              return this.singletons.cmyk;
            }

            break;

          case "Pattern":
            baseCS = cs[1] || null;

            if (baseCS) {
              baseCS = this._parse(baseCS, xref, resources, pdfFunctionFactory);
            }

            return new PatternCS(baseCS);

          case "I":
          case "Indexed":
            baseCS = this._parse(cs[1], xref, resources, pdfFunctionFactory);
            var hiVal = xref.fetchIfRef(cs[2]) + 1;
            var lookup = xref.fetchIfRef(cs[3]);
            return new IndexedCS(baseCS, hiVal, lookup);

          case "Separation":
          case "DeviceN":
            var name = xref.fetchIfRef(cs[1]);
            numComps = Array.isArray(name) ? name.length : 1;
            baseCS = this._parse(cs[2], xref, resources, pdfFunctionFactory);
            var tintFn = pdfFunctionFactory.create(cs[3]);
            return new AlternateCS(numComps, baseCS, tintFn);

          case "Lab":
            params = xref.fetchIfRef(cs[1]);
            whitePoint = params.getArray("WhitePoint");
            blackPoint = params.getArray("BlackPoint");
            var range = params.getArray("Range");
            return new LabCS(whitePoint, blackPoint, range);

          default:
            throw new _util.FormatError("Unimplemented ColorSpace object: ".concat(mode));
        }
      }

      throw new _util.FormatError("Unrecognized ColorSpace object: ".concat(cs));
    }
  }, {
    key: "isDefaultDecode",
    value: function isDefaultDecode(decode, numComps) {
      if (!Array.isArray(decode)) {
        return true;
      }

      if (numComps * 2 !== decode.length) {
        (0, _util.warn)("The decode map is not the correct length");
        return true;
      }

      for (var i = 0, ii = decode.length; i < ii; i += 2) {
        if (decode[i] !== 0 || decode[i + 1] !== 1) {
          return false;
        }
      }

      return true;
    }
  }, {
    key: "singletons",
    get: function get() {
      return (0, _util.shadow)(this, "singletons", {
        get gray() {
          return (0, _util.shadow)(this, "gray", new DeviceGrayCS());
        },

        get rgb() {
          return (0, _util.shadow)(this, "rgb", new DeviceRgbCS());
        },

        get cmyk() {
          return (0, _util.shadow)(this, "cmyk", new DeviceCmykCS());
        }

      });
    }
  }]);

  return ColorSpace;
}();

exports.ColorSpace = ColorSpace;

var AlternateCS = /*#__PURE__*/function (_ColorSpace) {
  _inherits(AlternateCS, _ColorSpace);

  var _super = _createSuper(AlternateCS);

  function AlternateCS(numComps, base, tintFn) {
    var _this;

    _classCallCheck(this, AlternateCS);

    _this = _super.call(this, "Alternate", numComps);
    _this.base = base;
    _this.tintFn = tintFn;
    _this.tmpBuf = new Float32Array(base.numComps);
    return _this;
  }

  _createClass(AlternateCS, [{
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      var tmpBuf = this.tmpBuf;
      this.tintFn(src, srcOffset, tmpBuf, 0);
      this.base.getRgbItem(tmpBuf, 0, dest, destOffset);
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      var tintFn = this.tintFn;
      var base = this.base;
      var scale = 1 / ((1 << bits) - 1);
      var baseNumComps = base.numComps;
      var usesZeroToOneRange = base.usesZeroToOneRange;
      var isPassthrough = (base.isPassthrough(8) || !usesZeroToOneRange) && alpha01 === 0;
      var pos = isPassthrough ? destOffset : 0;
      var baseBuf = isPassthrough ? dest : new Uint8ClampedArray(baseNumComps * count);
      var numComps = this.numComps;
      var scaled = new Float32Array(numComps);
      var tinted = new Float32Array(baseNumComps);
      var i, j;

      for (i = 0; i < count; i++) {
        for (j = 0; j < numComps; j++) {
          scaled[j] = src[srcOffset++] * scale;
        }

        tintFn(scaled, 0, tinted, 0);

        if (usesZeroToOneRange) {
          for (j = 0; j < baseNumComps; j++) {
            baseBuf[pos++] = tinted[j] * 255;
          }
        } else {
          base.getRgbItem(tinted, 0, baseBuf, pos);
          pos += baseNumComps;
        }
      }

      if (!isPassthrough) {
        base.getRgbBuffer(baseBuf, 0, count, dest, destOffset, 8, alpha01);
      }
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      return this.base.getOutputLength(inputLength * this.base.numComps / this.numComps, alpha01);
    }
  }]);

  return AlternateCS;
}(ColorSpace);

var PatternCS = /*#__PURE__*/function (_ColorSpace2) {
  _inherits(PatternCS, _ColorSpace2);

  var _super2 = _createSuper(PatternCS);

  function PatternCS(baseCS) {
    var _this2;

    _classCallCheck(this, PatternCS);

    _this2 = _super2.call(this, "Pattern", null);
    _this2.base = baseCS;
    return _this2;
  }

  _createClass(PatternCS, [{
    key: "isDefaultDecode",
    value: function isDefaultDecode(decodeMap, bpc) {
      (0, _util.unreachable)("Should not call PatternCS.isDefaultDecode");
    }
  }]);

  return PatternCS;
}(ColorSpace);

var IndexedCS = /*#__PURE__*/function (_ColorSpace3) {
  _inherits(IndexedCS, _ColorSpace3);

  var _super3 = _createSuper(IndexedCS);

  function IndexedCS(base, highVal, lookup) {
    var _this3;

    _classCallCheck(this, IndexedCS);

    _this3 = _super3.call(this, "Indexed", 1);
    _this3.base = base;
    _this3.highVal = highVal;
    var length = base.numComps * highVal;
    _this3.lookup = new Uint8Array(length);

    if (lookup instanceof _base_stream.BaseStream) {
      var bytes = lookup.getBytes(length);

      _this3.lookup.set(bytes);
    } else if (typeof lookup === "string") {
      for (var i = 0; i < length; ++i) {
        _this3.lookup[i] = lookup.charCodeAt(i) & 0xff;
      }
    } else {
      throw new _util.FormatError("IndexedCS - unrecognized lookup table: ".concat(lookup));
    }

    return _this3;
  }

  _createClass(IndexedCS, [{
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      var numComps = this.base.numComps;
      var start = src[srcOffset] * numComps;
      this.base.getRgbBuffer(this.lookup, start, 1, dest, destOffset, 8, 0);
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      var base = this.base;
      var numComps = base.numComps;
      var outputDelta = base.getOutputLength(numComps, alpha01);
      var lookup = this.lookup;

      for (var i = 0; i < count; ++i) {
        var lookupPos = src[srcOffset++] * numComps;
        base.getRgbBuffer(lookup, lookupPos, 1, dest, destOffset, 8, alpha01);
        destOffset += outputDelta;
      }
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      return this.base.getOutputLength(inputLength * this.base.numComps, alpha01);
    }
  }, {
    key: "isDefaultDecode",
    value: function isDefaultDecode(decodeMap, bpc) {
      if (!Array.isArray(decodeMap)) {
        return true;
      }

      if (decodeMap.length !== 2) {
        (0, _util.warn)("Decode map length is not correct");
        return true;
      }

      if (!Number.isInteger(bpc) || bpc < 1) {
        (0, _util.warn)("Bits per component is not correct");
        return true;
      }

      return decodeMap[0] === 0 && decodeMap[1] === (1 << bpc) - 1;
    }
  }]);

  return IndexedCS;
}(ColorSpace);

var DeviceGrayCS = /*#__PURE__*/function (_ColorSpace4) {
  _inherits(DeviceGrayCS, _ColorSpace4);

  var _super4 = _createSuper(DeviceGrayCS);

  function DeviceGrayCS() {
    _classCallCheck(this, DeviceGrayCS);

    return _super4.call(this, "DeviceGray", 1);
  }

  _createClass(DeviceGrayCS, [{
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      var c = src[srcOffset] * 255;
      dest[destOffset] = dest[destOffset + 1] = dest[destOffset + 2] = c;
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      var scale = 255 / ((1 << bits) - 1);
      var j = srcOffset,
          q = destOffset;

      for (var i = 0; i < count; ++i) {
        var c = scale * src[j++];
        dest[q++] = c;
        dest[q++] = c;
        dest[q++] = c;
        q += alpha01;
      }
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      return inputLength * (3 + alpha01);
    }
  }]);

  return DeviceGrayCS;
}(ColorSpace);

var DeviceRgbCS = /*#__PURE__*/function (_ColorSpace5) {
  _inherits(DeviceRgbCS, _ColorSpace5);

  var _super5 = _createSuper(DeviceRgbCS);

  function DeviceRgbCS() {
    _classCallCheck(this, DeviceRgbCS);

    return _super5.call(this, "DeviceRGB", 3);
  }

  _createClass(DeviceRgbCS, [{
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      dest[destOffset] = src[srcOffset] * 255;
      dest[destOffset + 1] = src[srcOffset + 1] * 255;
      dest[destOffset + 2] = src[srcOffset + 2] * 255;
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      if (bits === 8 && alpha01 === 0) {
        dest.set(src.subarray(srcOffset, srcOffset + count * 3), destOffset);
        return;
      }

      var scale = 255 / ((1 << bits) - 1);
      var j = srcOffset,
          q = destOffset;

      for (var i = 0; i < count; ++i) {
        dest[q++] = scale * src[j++];
        dest[q++] = scale * src[j++];
        dest[q++] = scale * src[j++];
        q += alpha01;
      }
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      return inputLength * (3 + alpha01) / 3 | 0;
    }
  }, {
    key: "isPassthrough",
    value: function isPassthrough(bits) {
      return bits === 8;
    }
  }]);

  return DeviceRgbCS;
}(ColorSpace);

var DeviceCmykCS = function DeviceCmykCSClosure() {
  function convertToRgb(src, srcOffset, srcScale, dest, destOffset) {
    var c = src[srcOffset] * srcScale;
    var m = src[srcOffset + 1] * srcScale;
    var y = src[srcOffset + 2] * srcScale;
    var k = src[srcOffset + 3] * srcScale;
    dest[destOffset] = 255 + c * (-4.387332384609988 * c + 54.48615194189176 * m + 18.82290502165302 * y + 212.25662451639585 * k + -285.2331026137004) + m * (1.7149763477362134 * m - 5.6096736904047315 * y + -17.873870861415444 * k - 5.497006427196366) + y * (-2.5217340131683033 * y - 21.248923337353073 * k + 17.5119270841813) + k * (-21.86122147463605 * k - 189.48180835922747);
    dest[destOffset + 1] = 255 + c * (8.841041422036149 * c + 60.118027045597366 * m + 6.871425592049007 * y + 31.159100130055922 * k + -79.2970844816548) + m * (-15.310361306967817 * m + 17.575251261109482 * y + 131.35250912493976 * k - 190.9453302588951) + y * (4.444339102852739 * y + 9.8632861493405 * k - 24.86741582555878) + k * (-20.737325471181034 * k - 187.80453709719578);
    dest[destOffset + 2] = 255 + c * (0.8842522430003296 * c + 8.078677503112928 * m + 30.89978309703729 * y - 0.23883238689178934 * k + -14.183576799673286) + m * (10.49593273432072 * m + 63.02378494754052 * y + 50.606957656360734 * k - 112.23884253719248) + y * (0.03296041114873217 * y + 115.60384449646641 * k + -193.58209356861505) + k * (-22.33816807309886 * k - 180.12613974708367);
  }

  var DeviceCmykCS = /*#__PURE__*/function (_ColorSpace6) {
    _inherits(DeviceCmykCS, _ColorSpace6);

    var _super6 = _createSuper(DeviceCmykCS);

    function DeviceCmykCS() {
      _classCallCheck(this, DeviceCmykCS);

      return _super6.call(this, "DeviceCMYK", 4);
    }

    _createClass(DeviceCmykCS, [{
      key: "getRgbItem",
      value: function getRgbItem(src, srcOffset, dest, destOffset) {
        convertToRgb(src, srcOffset, 1, dest, destOffset);
      }
    }, {
      key: "getRgbBuffer",
      value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
        var scale = 1 / ((1 << bits) - 1);

        for (var i = 0; i < count; i++) {
          convertToRgb(src, srcOffset, scale, dest, destOffset);
          srcOffset += 4;
          destOffset += 3 + alpha01;
        }
      }
    }, {
      key: "getOutputLength",
      value: function getOutputLength(inputLength, alpha01) {
        return inputLength / 4 * (3 + alpha01) | 0;
      }
    }]);

    return DeviceCmykCS;
  }(ColorSpace);

  return DeviceCmykCS;
}();

var CalGrayCS = function CalGrayCSClosure() {
  function convertToRgb(cs, src, srcOffset, dest, destOffset, scale) {
    var A = src[srcOffset] * scale;
    var AG = Math.pow(A, cs.G);
    var L = cs.YW * AG;
    var val = Math.max(295.8 * Math.pow(L, 0.3333333333333333) - 40.8, 0);
    dest[destOffset] = val;
    dest[destOffset + 1] = val;
    dest[destOffset + 2] = val;
  }

  var CalGrayCS = /*#__PURE__*/function (_ColorSpace7) {
    _inherits(CalGrayCS, _ColorSpace7);

    var _super7 = _createSuper(CalGrayCS);

    function CalGrayCS(whitePoint, blackPoint, gamma) {
      var _this4;

      _classCallCheck(this, CalGrayCS);

      _this4 = _super7.call(this, "CalGray", 1);

      if (!whitePoint) {
        throw new _util.FormatError("WhitePoint missing - required for color space CalGray");
      }

      blackPoint = blackPoint || [0, 0, 0];
      gamma = gamma || 1;
      _this4.XW = whitePoint[0];
      _this4.YW = whitePoint[1];
      _this4.ZW = whitePoint[2];
      _this4.XB = blackPoint[0];
      _this4.YB = blackPoint[1];
      _this4.ZB = blackPoint[2];
      _this4.G = gamma;

      if (_this4.XW < 0 || _this4.ZW < 0 || _this4.YW !== 1) {
        throw new _util.FormatError("Invalid WhitePoint components for ".concat(_this4.name) + ", no fallback available");
      }

      if (_this4.XB < 0 || _this4.YB < 0 || _this4.ZB < 0) {
        (0, _util.info)("Invalid BlackPoint for ".concat(_this4.name, ", falling back to default."));
        _this4.XB = _this4.YB = _this4.ZB = 0;
      }

      if (_this4.XB !== 0 || _this4.YB !== 0 || _this4.ZB !== 0) {
        (0, _util.warn)("".concat(_this4.name, ", BlackPoint: XB: ").concat(_this4.XB, ", YB: ").concat(_this4.YB, ", ") + "ZB: ".concat(_this4.ZB, ", only default values are supported."));
      }

      if (_this4.G < 1) {
        (0, _util.info)("Invalid Gamma: ".concat(_this4.G, " for ").concat(_this4.name, ", ") + "falling back to default.");
        _this4.G = 1;
      }

      return _this4;
    }

    _createClass(CalGrayCS, [{
      key: "getRgbItem",
      value: function getRgbItem(src, srcOffset, dest, destOffset) {
        convertToRgb(this, src, srcOffset, dest, destOffset, 1);
      }
    }, {
      key: "getRgbBuffer",
      value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
        var scale = 1 / ((1 << bits) - 1);

        for (var i = 0; i < count; ++i) {
          convertToRgb(this, src, srcOffset, dest, destOffset, scale);
          srcOffset += 1;
          destOffset += 3 + alpha01;
        }
      }
    }, {
      key: "getOutputLength",
      value: function getOutputLength(inputLength, alpha01) {
        return inputLength * (3 + alpha01);
      }
    }]);

    return CalGrayCS;
  }(ColorSpace);

  return CalGrayCS;
}();

var CalRGBCS = function CalRGBCSClosure() {
  var BRADFORD_SCALE_MATRIX = new Float32Array([0.8951, 0.2664, -0.1614, -0.7502, 1.7135, 0.0367, 0.0389, -0.0685, 1.0296]);
  var BRADFORD_SCALE_INVERSE_MATRIX = new Float32Array([0.9869929, -0.1470543, 0.1599627, 0.4323053, 0.5183603, 0.0492912, -0.0085287, 0.0400428, 0.9684867]);
  var SRGB_D65_XYZ_TO_RGB_MATRIX = new Float32Array([3.2404542, -1.5371385, -0.4985314, -0.9692660, 1.8760108, 0.0415560, 0.0556434, -0.2040259, 1.0572252]);
  var FLAT_WHITEPOINT_MATRIX = new Float32Array([1, 1, 1]);
  var tempNormalizeMatrix = new Float32Array(3);
  var tempConvertMatrix1 = new Float32Array(3);
  var tempConvertMatrix2 = new Float32Array(3);
  var DECODE_L_CONSTANT = Math.pow((8 + 16) / 116, 3) / 8.0;

  function matrixProduct(a, b, result) {
    result[0] = a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    result[1] = a[3] * b[0] + a[4] * b[1] + a[5] * b[2];
    result[2] = a[6] * b[0] + a[7] * b[1] + a[8] * b[2];
  }

  function convertToFlat(sourceWhitePoint, LMS, result) {
    result[0] = LMS[0] * 1 / sourceWhitePoint[0];
    result[1] = LMS[1] * 1 / sourceWhitePoint[1];
    result[2] = LMS[2] * 1 / sourceWhitePoint[2];
  }

  function convertToD65(sourceWhitePoint, LMS, result) {
    var D65X = 0.95047;
    var D65Y = 1;
    var D65Z = 1.08883;
    result[0] = LMS[0] * D65X / sourceWhitePoint[0];
    result[1] = LMS[1] * D65Y / sourceWhitePoint[1];
    result[2] = LMS[2] * D65Z / sourceWhitePoint[2];
  }

  function sRGBTransferFunction(color) {
    if (color <= 0.0031308) {
      return adjustToRange(0, 1, 12.92 * color);
    }

    if (color >= 0.99554525) {
      return 1;
    }

    return adjustToRange(0, 1, (1 + 0.055) * Math.pow(color, 1 / 2.4) - 0.055);
  }

  function adjustToRange(min, max, value) {
    return Math.max(min, Math.min(max, value));
  }

  function decodeL(L) {
    if (L < 0) {
      return -decodeL(-L);
    }

    if (L > 8.0) {
      return Math.pow((L + 16) / 116, 3);
    }

    return L * DECODE_L_CONSTANT;
  }

  function compensateBlackPoint(sourceBlackPoint, XYZ_Flat, result) {
    if (sourceBlackPoint[0] === 0 && sourceBlackPoint[1] === 0 && sourceBlackPoint[2] === 0) {
      result[0] = XYZ_Flat[0];
      result[1] = XYZ_Flat[1];
      result[2] = XYZ_Flat[2];
      return;
    }

    var zeroDecodeL = decodeL(0);
    var X_DST = zeroDecodeL;
    var X_SRC = decodeL(sourceBlackPoint[0]);
    var Y_DST = zeroDecodeL;
    var Y_SRC = decodeL(sourceBlackPoint[1]);
    var Z_DST = zeroDecodeL;
    var Z_SRC = decodeL(sourceBlackPoint[2]);
    var X_Scale = (1 - X_DST) / (1 - X_SRC);
    var X_Offset = 1 - X_Scale;
    var Y_Scale = (1 - Y_DST) / (1 - Y_SRC);
    var Y_Offset = 1 - Y_Scale;
    var Z_Scale = (1 - Z_DST) / (1 - Z_SRC);
    var Z_Offset = 1 - Z_Scale;
    result[0] = XYZ_Flat[0] * X_Scale + X_Offset;
    result[1] = XYZ_Flat[1] * Y_Scale + Y_Offset;
    result[2] = XYZ_Flat[2] * Z_Scale + Z_Offset;
  }

  function normalizeWhitePointToFlat(sourceWhitePoint, XYZ_In, result) {
    if (sourceWhitePoint[0] === 1 && sourceWhitePoint[2] === 1) {
      result[0] = XYZ_In[0];
      result[1] = XYZ_In[1];
      result[2] = XYZ_In[2];
      return;
    }

    var LMS = result;
    matrixProduct(BRADFORD_SCALE_MATRIX, XYZ_In, LMS);
    var LMS_Flat = tempNormalizeMatrix;
    convertToFlat(sourceWhitePoint, LMS, LMS_Flat);
    matrixProduct(BRADFORD_SCALE_INVERSE_MATRIX, LMS_Flat, result);
  }

  function normalizeWhitePointToD65(sourceWhitePoint, XYZ_In, result) {
    var LMS = result;
    matrixProduct(BRADFORD_SCALE_MATRIX, XYZ_In, LMS);
    var LMS_D65 = tempNormalizeMatrix;
    convertToD65(sourceWhitePoint, LMS, LMS_D65);
    matrixProduct(BRADFORD_SCALE_INVERSE_MATRIX, LMS_D65, result);
  }

  function convertToRgb(cs, src, srcOffset, dest, destOffset, scale) {
    var A = adjustToRange(0, 1, src[srcOffset] * scale);
    var B = adjustToRange(0, 1, src[srcOffset + 1] * scale);
    var C = adjustToRange(0, 1, src[srcOffset + 2] * scale);
    var AGR = A === 1 ? 1 : Math.pow(A, cs.GR);
    var BGG = B === 1 ? 1 : Math.pow(B, cs.GG);
    var CGB = C === 1 ? 1 : Math.pow(C, cs.GB);
    var X = cs.MXA * AGR + cs.MXB * BGG + cs.MXC * CGB;
    var Y = cs.MYA * AGR + cs.MYB * BGG + cs.MYC * CGB;
    var Z = cs.MZA * AGR + cs.MZB * BGG + cs.MZC * CGB;
    var XYZ = tempConvertMatrix1;
    XYZ[0] = X;
    XYZ[1] = Y;
    XYZ[2] = Z;
    var XYZ_Flat = tempConvertMatrix2;
    normalizeWhitePointToFlat(cs.whitePoint, XYZ, XYZ_Flat);
    var XYZ_Black = tempConvertMatrix1;
    compensateBlackPoint(cs.blackPoint, XYZ_Flat, XYZ_Black);
    var XYZ_D65 = tempConvertMatrix2;
    normalizeWhitePointToD65(FLAT_WHITEPOINT_MATRIX, XYZ_Black, XYZ_D65);
    var SRGB = tempConvertMatrix1;
    matrixProduct(SRGB_D65_XYZ_TO_RGB_MATRIX, XYZ_D65, SRGB);
    dest[destOffset] = sRGBTransferFunction(SRGB[0]) * 255;
    dest[destOffset + 1] = sRGBTransferFunction(SRGB[1]) * 255;
    dest[destOffset + 2] = sRGBTransferFunction(SRGB[2]) * 255;
  }

  var CalRGBCS = /*#__PURE__*/function (_ColorSpace8) {
    _inherits(CalRGBCS, _ColorSpace8);

    var _super8 = _createSuper(CalRGBCS);

    function CalRGBCS(whitePoint, blackPoint, gamma, matrix) {
      var _this5;

      _classCallCheck(this, CalRGBCS);

      _this5 = _super8.call(this, "CalRGB", 3);

      if (!whitePoint) {
        throw new _util.FormatError("WhitePoint missing - required for color space CalRGB");
      }

      blackPoint = blackPoint || new Float32Array(3);
      gamma = gamma || new Float32Array([1, 1, 1]);
      matrix = matrix || new Float32Array([1, 0, 0, 0, 1, 0, 0, 0, 1]);
      var XW = whitePoint[0];
      var YW = whitePoint[1];
      var ZW = whitePoint[2];
      _this5.whitePoint = whitePoint;
      var XB = blackPoint[0];
      var YB = blackPoint[1];
      var ZB = blackPoint[2];
      _this5.blackPoint = blackPoint;
      _this5.GR = gamma[0];
      _this5.GG = gamma[1];
      _this5.GB = gamma[2];
      _this5.MXA = matrix[0];
      _this5.MYA = matrix[1];
      _this5.MZA = matrix[2];
      _this5.MXB = matrix[3];
      _this5.MYB = matrix[4];
      _this5.MZB = matrix[5];
      _this5.MXC = matrix[6];
      _this5.MYC = matrix[7];
      _this5.MZC = matrix[8];

      if (XW < 0 || ZW < 0 || YW !== 1) {
        throw new _util.FormatError("Invalid WhitePoint components for ".concat(_this5.name) + ", no fallback available");
      }

      if (XB < 0 || YB < 0 || ZB < 0) {
        (0, _util.info)("Invalid BlackPoint for ".concat(_this5.name, " [").concat(XB, ", ").concat(YB, ", ").concat(ZB, "], ") + "falling back to default.");
        _this5.blackPoint = new Float32Array(3);
      }

      if (_this5.GR < 0 || _this5.GG < 0 || _this5.GB < 0) {
        (0, _util.info)("Invalid Gamma [".concat(_this5.GR, ", ").concat(_this5.GG, ", ").concat(_this5.GB, "] for ") + "".concat(_this5.name, ", falling back to default."));
        _this5.GR = _this5.GG = _this5.GB = 1;
      }

      return _this5;
    }

    _createClass(CalRGBCS, [{
      key: "getRgbItem",
      value: function getRgbItem(src, srcOffset, dest, destOffset) {
        convertToRgb(this, src, srcOffset, dest, destOffset, 1);
      }
    }, {
      key: "getRgbBuffer",
      value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
        var scale = 1 / ((1 << bits) - 1);

        for (var i = 0; i < count; ++i) {
          convertToRgb(this, src, srcOffset, dest, destOffset, scale);
          srcOffset += 3;
          destOffset += 3 + alpha01;
        }
      }
    }, {
      key: "getOutputLength",
      value: function getOutputLength(inputLength, alpha01) {
        return inputLength * (3 + alpha01) / 3 | 0;
      }
    }]);

    return CalRGBCS;
  }(ColorSpace);

  return CalRGBCS;
}();

var LabCS = function LabCSClosure() {
  function fn_g(x) {
    var result;

    if (x >= 6 / 29) {
      result = Math.pow(x, 3);
    } else {
      result = 108 / 841 * (x - 4 / 29);
    }

    return result;
  }

  function decode(value, high1, low2, high2) {
    return low2 + value * (high2 - low2) / high1;
  }

  function convertToRgb(cs, src, srcOffset, maxVal, dest, destOffset) {
    var Ls = src[srcOffset];
    var as = src[srcOffset + 1];
    var bs = src[srcOffset + 2];

    if (maxVal !== false) {
      Ls = decode(Ls, maxVal, 0, 100);
      as = decode(as, maxVal, cs.amin, cs.amax);
      bs = decode(bs, maxVal, cs.bmin, cs.bmax);
    }

    if (as > cs.amax) {
      as = cs.amax;
    } else if (as < cs.amin) {
      as = cs.amin;
    }

    if (bs > cs.bmax) {
      bs = cs.bmax;
    } else if (bs < cs.bmin) {
      bs = cs.bmin;
    }

    var M = (Ls + 16) / 116;
    var L = M + as / 500;
    var N = M - bs / 200;
    var X = cs.XW * fn_g(L);
    var Y = cs.YW * fn_g(M);
    var Z = cs.ZW * fn_g(N);
    var r, g, b;

    if (cs.ZW < 1) {
      r = X * 3.1339 + Y * -1.617 + Z * -0.4906;
      g = X * -0.9785 + Y * 1.916 + Z * 0.0333;
      b = X * 0.072 + Y * -0.229 + Z * 1.4057;
    } else {
      r = X * 3.2406 + Y * -1.5372 + Z * -0.4986;
      g = X * -0.9689 + Y * 1.8758 + Z * 0.0415;
      b = X * 0.0557 + Y * -0.204 + Z * 1.057;
    }

    dest[destOffset] = Math.sqrt(r) * 255;
    dest[destOffset + 1] = Math.sqrt(g) * 255;
    dest[destOffset + 2] = Math.sqrt(b) * 255;
  }

  var LabCS = /*#__PURE__*/function (_ColorSpace9) {
    _inherits(LabCS, _ColorSpace9);

    var _super9 = _createSuper(LabCS);

    function LabCS(whitePoint, blackPoint, range) {
      var _this6;

      _classCallCheck(this, LabCS);

      _this6 = _super9.call(this, "Lab", 3);

      if (!whitePoint) {
        throw new _util.FormatError("WhitePoint missing - required for color space Lab");
      }

      blackPoint = blackPoint || [0, 0, 0];
      range = range || [-100, 100, -100, 100];
      _this6.XW = whitePoint[0];
      _this6.YW = whitePoint[1];
      _this6.ZW = whitePoint[2];
      _this6.amin = range[0];
      _this6.amax = range[1];
      _this6.bmin = range[2];
      _this6.bmax = range[3];
      _this6.XB = blackPoint[0];
      _this6.YB = blackPoint[1];
      _this6.ZB = blackPoint[2];

      if (_this6.XW < 0 || _this6.ZW < 0 || _this6.YW !== 1) {
        throw new _util.FormatError("Invalid WhitePoint components, no fallback available");
      }

      if (_this6.XB < 0 || _this6.YB < 0 || _this6.ZB < 0) {
        (0, _util.info)("Invalid BlackPoint, falling back to default");
        _this6.XB = _this6.YB = _this6.ZB = 0;
      }

      if (_this6.amin > _this6.amax || _this6.bmin > _this6.bmax) {
        (0, _util.info)("Invalid Range, falling back to defaults");
        _this6.amin = -100;
        _this6.amax = 100;
        _this6.bmin = -100;
        _this6.bmax = 100;
      }

      return _this6;
    }

    _createClass(LabCS, [{
      key: "getRgbItem",
      value: function getRgbItem(src, srcOffset, dest, destOffset) {
        convertToRgb(this, src, srcOffset, false, dest, destOffset);
      }
    }, {
      key: "getRgbBuffer",
      value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
        var maxVal = (1 << bits) - 1;

        for (var i = 0; i < count; i++) {
          convertToRgb(this, src, srcOffset, maxVal, dest, destOffset);
          srcOffset += 3;
          destOffset += 3 + alpha01;
        }
      }
    }, {
      key: "getOutputLength",
      value: function getOutputLength(inputLength, alpha01) {
        return inputLength * (3 + alpha01) / 3 | 0;
      }
    }, {
      key: "isDefaultDecode",
      value: function isDefaultDecode(decodeMap, bpc) {
        return true;
      }
    }, {
      key: "usesZeroToOneRange",
      get: function get() {
        return (0, _util.shadow)(this, "usesZeroToOneRange", false);
      }
    }]);

    return LabCS;
  }(ColorSpace);

  return LabCS;
}();

/***/ }),
/* 167 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PartialEvaluator = exports.EvaluatorPreprocessor = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _cmap = __w_pdfjs_require__(168);

var _primitives = __w_pdfjs_require__(147);

var _fonts = __w_pdfjs_require__(186);

var _fonts_utils = __w_pdfjs_require__(160);

var _encodings = __w_pdfjs_require__(161);

var _standard_fonts = __w_pdfjs_require__(189);

var _unicode = __w_pdfjs_require__(163);

var _pattern = __w_pdfjs_require__(198);

var _xfa_fonts = __w_pdfjs_require__(154);

var _to_unicode_map = __w_pdfjs_require__(190);

var _function = __w_pdfjs_require__(199);

var _parser = __w_pdfjs_require__(169);

var _image_utils = __w_pdfjs_require__(201);

var _stream = __w_pdfjs_require__(152);

var _base_stream = __w_pdfjs_require__(151);

var _bidi = __w_pdfjs_require__(202);

var _colorspace = __w_pdfjs_require__(166);

var _decode_stream = __w_pdfjs_require__(171);

var _glyphlist = __w_pdfjs_require__(162);

var _core_utils = __w_pdfjs_require__(150);

var _metrics = __w_pdfjs_require__(193);

var _murmurhash = __w_pdfjs_require__(203);

var _operator_list = __w_pdfjs_require__(204);

var _image = __w_pdfjs_require__(205);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var DefaultPartialEvaluatorOptions = Object.freeze({
  maxImageSize: -1,
  disableFontFace: false,
  ignoreErrors: false,
  isEvalSupported: true,
  fontExtraProperties: false,
  useSystemFonts: true,
  cMapUrl: null,
  standardFontDataUrl: null
});
var PatternType = {
  TILING: 1,
  SHADING: 2
};
var TEXT_CHUNK_BATCH_SIZE = 10;
var deferred = Promise.resolve();

function normalizeBlendMode(value) {
  var parsingArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  if (Array.isArray(value)) {
    for (var i = 0, ii = value.length; i < ii; i++) {
      var maybeBM = normalizeBlendMode(value[i], true);

      if (maybeBM) {
        return maybeBM;
      }
    }

    (0, _util.warn)("Unsupported blend mode Array: ".concat(value));
    return "source-over";
  }

  if (!(value instanceof _primitives.Name)) {
    if (parsingArray) {
      return null;
    }

    return "source-over";
  }

  switch (value.name) {
    case "Normal":
    case "Compatible":
      return "source-over";

    case "Multiply":
      return "multiply";

    case "Screen":
      return "screen";

    case "Overlay":
      return "overlay";

    case "Darken":
      return "darken";

    case "Lighten":
      return "lighten";

    case "ColorDodge":
      return "color-dodge";

    case "ColorBurn":
      return "color-burn";

    case "HardLight":
      return "hard-light";

    case "SoftLight":
      return "soft-light";

    case "Difference":
      return "difference";

    case "Exclusion":
      return "exclusion";

    case "Hue":
      return "hue";

    case "Saturation":
      return "saturation";

    case "Color":
      return "color";

    case "Luminosity":
      return "luminosity";
  }

  if (parsingArray) {
    return null;
  }

  (0, _util.warn)("Unsupported blend mode: ".concat(value.name));
  return "source-over";
}

var TimeSlotManager = /*#__PURE__*/function () {
  function TimeSlotManager() {
    _classCallCheck(this, TimeSlotManager);

    this.reset();
  }

  _createClass(TimeSlotManager, [{
    key: "check",
    value: function check() {
      if (++this.checked < TimeSlotManager.CHECK_TIME_EVERY) {
        return false;
      }

      this.checked = 0;
      return this.endTime <= Date.now();
    }
  }, {
    key: "reset",
    value: function reset() {
      this.endTime = Date.now() + TimeSlotManager.TIME_SLOT_DURATION_MS;
      this.checked = 0;
    }
  }], [{
    key: "TIME_SLOT_DURATION_MS",
    get: function get() {
      return (0, _util.shadow)(this, "TIME_SLOT_DURATION_MS", 20);
    }
  }, {
    key: "CHECK_TIME_EVERY",
    get: function get() {
      return (0, _util.shadow)(this, "CHECK_TIME_EVERY", 100);
    }
  }]);

  return TimeSlotManager;
}();

var PartialEvaluator = /*#__PURE__*/function () {
  function PartialEvaluator(_ref) {
    var xref = _ref.xref,
        handler = _ref.handler,
        pageIndex = _ref.pageIndex,
        idFactory = _ref.idFactory,
        fontCache = _ref.fontCache,
        builtInCMapCache = _ref.builtInCMapCache,
        standardFontDataCache = _ref.standardFontDataCache,
        globalImageCache = _ref.globalImageCache,
        _ref$options = _ref.options,
        options = _ref$options === void 0 ? null : _ref$options;

    _classCallCheck(this, PartialEvaluator);

    this.xref = xref;
    this.handler = handler;
    this.pageIndex = pageIndex;
    this.idFactory = idFactory;
    this.fontCache = fontCache;
    this.builtInCMapCache = builtInCMapCache;
    this.standardFontDataCache = standardFontDataCache;
    this.globalImageCache = globalImageCache;
    this.options = options || DefaultPartialEvaluatorOptions;
    this.parsingType3Font = false;
    this._fetchBuiltInCMapBound = this.fetchBuiltInCMap.bind(this);
  }

  _createClass(PartialEvaluator, [{
    key: "_pdfFunctionFactory",
    get: function get() {
      var pdfFunctionFactory = new _function.PDFFunctionFactory({
        xref: this.xref,
        isEvalSupported: this.options.isEvalSupported
      });
      return (0, _util.shadow)(this, "_pdfFunctionFactory", pdfFunctionFactory);
    }
  }, {
    key: "clone",
    value: function clone() {
      var newOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var newEvaluator = Object.create(this);
      newEvaluator.options = Object.assign(Object.create(null), this.options, newOptions);
      return newEvaluator;
    }
  }, {
    key: "hasBlendModes",
    value: function hasBlendModes(resources, nonBlendModesSet) {
      if (!(resources instanceof _primitives.Dict)) {
        return false;
      }

      if (resources.objId && nonBlendModesSet.has(resources.objId)) {
        return false;
      }

      var processed = new _primitives.RefSet(nonBlendModesSet);

      if (resources.objId) {
        processed.put(resources.objId);
      }

      var nodes = [resources],
          xref = this.xref;

      while (nodes.length) {
        var node = nodes.shift();
        var graphicStates = node.get("ExtGState");

        if (graphicStates instanceof _primitives.Dict) {
          var _iterator = _createForOfIteratorHelper(graphicStates.getRawValues()),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var graphicState = _step.value;

              if (graphicState instanceof _primitives.Ref) {
                if (processed.has(graphicState)) {
                  continue;
                }

                try {
                  graphicState = xref.fetch(graphicState);
                } catch (ex) {
                  processed.put(graphicState);
                  (0, _util.info)("hasBlendModes - ignoring ExtGState: \"".concat(ex, "\"."));
                  continue;
                }
              }

              if (!(graphicState instanceof _primitives.Dict)) {
                continue;
              }

              if (graphicState.objId) {
                processed.put(graphicState.objId);
              }

              var bm = graphicState.get("BM");

              if (bm instanceof _primitives.Name) {
                if (bm.name !== "Normal") {
                  return true;
                }

                continue;
              }

              if (bm !== undefined && Array.isArray(bm)) {
                var _iterator2 = _createForOfIteratorHelper(bm),
                    _step2;

                try {
                  for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                    var element = _step2.value;

                    if (element instanceof _primitives.Name && element.name !== "Normal") {
                      return true;
                    }
                  }
                } catch (err) {
                  _iterator2.e(err);
                } finally {
                  _iterator2.f();
                }
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }

        var xObjects = node.get("XObject");

        if (!(xObjects instanceof _primitives.Dict)) {
          continue;
        }

        var _iterator3 = _createForOfIteratorHelper(xObjects.getRawValues()),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var xObject = _step3.value;

            if (xObject instanceof _primitives.Ref) {
              if (processed.has(xObject)) {
                continue;
              }

              try {
                xObject = xref.fetch(xObject);
              } catch (ex) {
                processed.put(xObject);
                (0, _util.info)("hasBlendModes - ignoring XObject: \"".concat(ex, "\"."));
                continue;
              }
            }

            if (!(xObject instanceof _base_stream.BaseStream)) {
              continue;
            }

            if (xObject.dict.objId) {
              processed.put(xObject.dict.objId);
            }

            var xResources = xObject.dict.get("Resources");

            if (!(xResources instanceof _primitives.Dict)) {
              continue;
            }

            if (xResources.objId && processed.has(xResources.objId)) {
              continue;
            }

            nodes.push(xResources);

            if (xResources.objId) {
              processed.put(xResources.objId);
            }
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      }

      processed.forEach(function (ref) {
        nonBlendModesSet.put(ref);
      });
      return false;
    }
  }, {
    key: "fetchBuiltInCMap",
    value: function () {
      var _fetchBuiltInCMap = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(name) {
        var cachedData, data, url, response;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                cachedData = this.builtInCMapCache.get(name);

                if (!cachedData) {
                  _context.next = 3;
                  break;
                }

                return _context.abrupt("return", cachedData);

              case 3:
                if (!(this.options.cMapUrl !== null)) {
                  _context.next = 19;
                  break;
                }

                url = "".concat(this.options.cMapUrl).concat(name, ".bcmap");
                _context.next = 7;
                return fetch(url);

              case 7:
                response = _context.sent;

                if (response.ok) {
                  _context.next = 10;
                  break;
                }

                throw new Error("fetchBuiltInCMap: failed to fetch file \"".concat(url, "\" with \"").concat(response.statusText, "\"."));

              case 10:
                _context.t0 = Uint8Array;
                _context.next = 13;
                return response.arrayBuffer();

              case 13:
                _context.t1 = _context.sent;
                _context.t2 = new _context.t0(_context.t1);
                _context.t3 = _util.CMapCompressionType.BINARY;
                data = {
                  cMapData: _context.t2,
                  compressionType: _context.t3
                };
                _context.next = 22;
                break;

              case 19:
                _context.next = 21;
                return this.handler.sendWithPromise("FetchBuiltInCMap", {
                  name: name
                });

              case 21:
                data = _context.sent;

              case 22:
                if (data.compressionType !== _util.CMapCompressionType.NONE) {
                  this.builtInCMapCache.set(name, data);
                }

                return _context.abrupt("return", data);

              case 24:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function fetchBuiltInCMap(_x) {
        return _fetchBuiltInCMap.apply(this, arguments);
      }

      return fetchBuiltInCMap;
    }()
  }, {
    key: "fetchStandardFontData",
    value: function () {
      var _fetchStandardFontData = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee2(name) {
        var cachedData, standardFontNameToFileName, filename, data, url, response;
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                cachedData = this.standardFontDataCache.get(name);

                if (!cachedData) {
                  _context2.next = 3;
                  break;
                }

                return _context2.abrupt("return", new _stream.Stream(cachedData));

              case 3:
                if (!(this.options.useSystemFonts && name !== "Symbol" && name !== "ZapfDingbats")) {
                  _context2.next = 5;
                  break;
                }

                return _context2.abrupt("return", null);

              case 5:
                standardFontNameToFileName = (0, _standard_fonts.getFontNameToFileMap)(), filename = standardFontNameToFileName[name];

                if (!(this.options.standardFontDataUrl !== null)) {
                  _context2.next = 20;
                  break;
                }

                url = "".concat(this.options.standardFontDataUrl).concat(filename);
                _context2.next = 10;
                return fetch(url);

              case 10:
                response = _context2.sent;

                if (response.ok) {
                  _context2.next = 15;
                  break;
                }

                (0, _util.warn)("fetchStandardFontData: failed to fetch file \"".concat(url, "\" with \"").concat(response.statusText, "\"."));
                _context2.next = 18;
                break;

              case 15:
                _context2.next = 17;
                return response.arrayBuffer();

              case 17:
                data = _context2.sent;

              case 18:
                _context2.next = 29;
                break;

              case 20:
                _context2.prev = 20;
                _context2.next = 23;
                return this.handler.sendWithPromise("FetchStandardFontData", {
                  filename: filename
                });

              case 23:
                data = _context2.sent;
                _context2.next = 29;
                break;

              case 26:
                _context2.prev = 26;
                _context2.t0 = _context2["catch"](20);
                (0, _util.warn)("fetchStandardFontData: failed to fetch file \"".concat(filename, "\" with \"").concat(_context2.t0, "\"."));

              case 29:
                if (data) {
                  _context2.next = 31;
                  break;
                }

                return _context2.abrupt("return", null);

              case 31:
                this.standardFontDataCache.set(name, data);
                return _context2.abrupt("return", new _stream.Stream(data));

              case 33:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this, [[20, 26]]);
      }));

      function fetchStandardFontData(_x2) {
        return _fetchStandardFontData.apply(this, arguments);
      }

      return fetchStandardFontData;
    }()
  }, {
    key: "buildFormXObject",
    value: function () {
      var _buildFormXObject = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee3(resources, xobj, smask, operatorList, task, initialState, localColorSpaceCache) {
        var dict, matrix, bbox, optionalContent, groupOptions, group, groupSubtype, colorSpace, cs, cachedColorSpace, args;
        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                dict = xobj.dict;
                matrix = dict.getArray("Matrix");
                bbox = dict.getArray("BBox");

                if (Array.isArray(bbox) && bbox.length === 4) {
                  bbox = _util.Util.normalizeRect(bbox);
                } else {
                  bbox = null;
                }

                if (!dict.has("OC")) {
                  _context3.next = 8;
                  break;
                }

                _context3.next = 7;
                return this.parseMarkedContentProps(dict.get("OC"), resources);

              case 7:
                optionalContent = _context3.sent;

              case 8:
                if (optionalContent !== undefined) {
                  operatorList.addOp(_util.OPS.beginMarkedContentProps, ["OC", optionalContent]);
                }

                group = dict.get("Group");

                if (!group) {
                  _context3.next = 29;
                  break;
                }

                groupOptions = {
                  matrix: matrix,
                  bbox: bbox,
                  smask: smask,
                  isolated: false,
                  knockout: false
                };
                groupSubtype = group.get("S");
                colorSpace = null;

                if (!(0, _primitives.isName)(groupSubtype, "Transparency")) {
                  _context3.next = 27;
                  break;
                }

                groupOptions.isolated = group.get("I") || false;
                groupOptions.knockout = group.get("K") || false;

                if (!group.has("CS")) {
                  _context3.next = 27;
                  break;
                }

                cs = group.getRaw("CS");
                cachedColorSpace = _colorspace.ColorSpace.getCached(cs, this.xref, localColorSpaceCache);

                if (!cachedColorSpace) {
                  _context3.next = 24;
                  break;
                }

                colorSpace = cachedColorSpace;
                _context3.next = 27;
                break;

              case 24:
                _context3.next = 26;
                return this.parseColorSpace({
                  cs: cs,
                  resources: resources,
                  localColorSpaceCache: localColorSpaceCache
                });

              case 26:
                colorSpace = _context3.sent;

              case 27:
                if (smask && smask.backdrop) {
                  colorSpace = colorSpace || _colorspace.ColorSpace.singletons.rgb;
                  smask.backdrop = colorSpace.getRgb(smask.backdrop, 0);
                }

                operatorList.addOp(_util.OPS.beginGroup, [groupOptions]);

              case 29:
                args = group ? [matrix, null] : [matrix, bbox];
                operatorList.addOp(_util.OPS.paintFormXObjectBegin, args);
                return _context3.abrupt("return", this.getOperatorList({
                  stream: xobj,
                  task: task,
                  resources: dict.get("Resources") || resources,
                  operatorList: operatorList,
                  initialState: initialState
                }).then(function () {
                  operatorList.addOp(_util.OPS.paintFormXObjectEnd, []);

                  if (group) {
                    operatorList.addOp(_util.OPS.endGroup, [groupOptions]);
                  }

                  if (optionalContent !== undefined) {
                    operatorList.addOp(_util.OPS.endMarkedContent, []);
                  }
                }));

              case 32:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function buildFormXObject(_x3, _x4, _x5, _x6, _x7, _x8, _x9) {
        return _buildFormXObject.apply(this, arguments);
      }

      return buildFormXObject;
    }()
  }, {
    key: "_sendImgData",
    value: function _sendImgData(objId, imgData) {
      var cacheGlobally = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var transfers = imgData ? [imgData.data.buffer] : null;

      if (this.parsingType3Font || cacheGlobally) {
        return this.handler.send("commonobj", [objId, "Image", imgData], transfers);
      }

      return this.handler.send("obj", [objId, this.pageIndex, "Image", imgData], transfers);
    }
  }, {
    key: "buildPaintImageXObject",
    value: function () {
      var _buildPaintImageXObject = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee4(_ref2) {
        var _this = this;

        var resources, image, _ref2$isInline, isInline, operatorList, cacheKey, localImageCache, localColorSpaceCache, dict, imageRef, w, h, maxImageSize, msg, optionalContent, imageMask, interpolate, imgData, args, bitStrideLength, imgArray, decode, softMask, mask, SMALL_IMAGE_DIMENSIONS, imageObj, objId, cacheGlobally;

        return _regenerator["default"].wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                resources = _ref2.resources, image = _ref2.image, _ref2$isInline = _ref2.isInline, isInline = _ref2$isInline === void 0 ? false : _ref2$isInline, operatorList = _ref2.operatorList, cacheKey = _ref2.cacheKey, localImageCache = _ref2.localImageCache, localColorSpaceCache = _ref2.localColorSpaceCache;
                dict = image.dict;
                imageRef = dict.objId;
                w = dict.get("W", "Width");
                h = dict.get("H", "Height");

                if (!(!(w && typeof w === "number") || !(h && typeof h === "number"))) {
                  _context4.next = 8;
                  break;
                }

                (0, _util.warn)("Image dimensions are missing, or not numbers.");
                return _context4.abrupt("return");

              case 8:
                maxImageSize = this.options.maxImageSize;

                if (!(maxImageSize !== -1 && w * h > maxImageSize)) {
                  _context4.next = 15;
                  break;
                }

                msg = "Image exceeded maximum allowed size and was removed.";

                if (!this.options.ignoreErrors) {
                  _context4.next = 14;
                  break;
                }

                (0, _util.warn)(msg);
                return _context4.abrupt("return");

              case 14:
                throw new Error(msg);

              case 15:
                if (!dict.has("OC")) {
                  _context4.next = 19;
                  break;
                }

                _context4.next = 18;
                return this.parseMarkedContentProps(dict.get("OC"), resources);

              case 18:
                optionalContent = _context4.sent;

              case 19:
                if (optionalContent !== undefined) {
                  operatorList.addOp(_util.OPS.beginMarkedContentProps, ["OC", optionalContent]);
                }

                imageMask = dict.get("IM", "ImageMask") || false;
                interpolate = dict.get("I", "Interpolate");

                if (!imageMask) {
                  _context4.next = 33;
                  break;
                }

                bitStrideLength = w + 7 >> 3;
                imgArray = image.getBytes(bitStrideLength * h, true);
                decode = dict.getArray("D", "Decode");
                imgData = _image.PDFImage.createMask({
                  imgArray: imgArray,
                  width: w,
                  height: h,
                  imageIsFromDecodeStream: image instanceof _decode_stream.DecodeStream,
                  inverseDecode: !!decode && decode[0] > 0,
                  interpolate: interpolate
                });
                imgData.cached = !!cacheKey;
                args = [imgData];
                operatorList.addOp(_util.OPS.paintImageMaskXObject, args);

                if (cacheKey) {
                  localImageCache.set(cacheKey, imageRef, {
                    fn: _util.OPS.paintImageMaskXObject,
                    args: args
                  });
                }

                if (optionalContent !== undefined) {
                  operatorList.addOp(_util.OPS.endMarkedContent, []);
                }

                return _context4.abrupt("return");

              case 33:
                softMask = dict.get("SM", "SMask") || false;
                mask = dict.get("Mask") || false;
                SMALL_IMAGE_DIMENSIONS = 200;

                if (!(isInline && !softMask && !mask && w + h < SMALL_IMAGE_DIMENSIONS)) {
                  _context4.next = 42;
                  break;
                }

                imageObj = new _image.PDFImage({
                  xref: this.xref,
                  res: resources,
                  image: image,
                  isInline: isInline,
                  pdfFunctionFactory: this._pdfFunctionFactory,
                  localColorSpaceCache: localColorSpaceCache
                });
                imgData = imageObj.createImageData(true);
                operatorList.addOp(_util.OPS.paintInlineImageXObject, [imgData]);

                if (optionalContent !== undefined) {
                  operatorList.addOp(_util.OPS.endMarkedContent, []);
                }

                return _context4.abrupt("return");

              case 42:
                objId = "img_".concat(this.idFactory.createObjId()), cacheGlobally = false;

                if (this.parsingType3Font) {
                  objId = "".concat(this.idFactory.getDocId(), "_type3_").concat(objId);
                } else if (imageRef) {
                  cacheGlobally = this.globalImageCache.shouldCache(imageRef, this.pageIndex);

                  if (cacheGlobally) {
                    objId = "".concat(this.idFactory.getDocId(), "_").concat(objId);
                  }
                }

                operatorList.addDependency(objId);
                args = [objId, w, h];

                _image.PDFImage.buildImage({
                  xref: this.xref,
                  res: resources,
                  image: image,
                  isInline: isInline,
                  pdfFunctionFactory: this._pdfFunctionFactory,
                  localColorSpaceCache: localColorSpaceCache
                }).then(function (imageObj) {
                  imgData = imageObj.createImageData(false);

                  if (cacheKey && imageRef && cacheGlobally) {
                    _this.globalImageCache.addByteSize(imageRef, imgData.data.length);
                  }

                  return _this._sendImgData(objId, imgData, cacheGlobally);
                })["catch"](function (reason) {
                  (0, _util.warn)("Unable to decode image \"".concat(objId, "\": \"").concat(reason, "\"."));
                  return _this._sendImgData(objId, null, cacheGlobally);
                });

                operatorList.addOp(_util.OPS.paintImageXObject, args);

                if (cacheKey) {
                  localImageCache.set(cacheKey, imageRef, {
                    fn: _util.OPS.paintImageXObject,
                    args: args
                  });

                  if (imageRef) {
                    (0, _util.assert)(!isInline, "Cannot cache an inline image globally.");
                    this.globalImageCache.addPageIndex(imageRef, this.pageIndex);

                    if (cacheGlobally) {
                      this.globalImageCache.setData(imageRef, {
                        objId: objId,
                        fn: _util.OPS.paintImageXObject,
                        args: args,
                        byteSize: 0
                      });
                    }
                  }
                }

                if (optionalContent !== undefined) {
                  operatorList.addOp(_util.OPS.endMarkedContent, []);
                }

              case 50:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function buildPaintImageXObject(_x10) {
        return _buildPaintImageXObject.apply(this, arguments);
      }

      return buildPaintImageXObject;
    }()
  }, {
    key: "handleSMask",
    value: function handleSMask(smask, resources, operatorList, task, stateManager, localColorSpaceCache) {
      var smaskContent = smask.get("G");
      var smaskOptions = {
        subtype: smask.get("S").name,
        backdrop: smask.get("BC")
      };
      var transferObj = smask.get("TR");

      if ((0, _function.isPDFFunction)(transferObj)) {
        var transferFn = this._pdfFunctionFactory.create(transferObj);

        var transferMap = new Uint8Array(256);
        var tmp = new Float32Array(1);

        for (var i = 0; i < 256; i++) {
          tmp[0] = i / 255;
          transferFn(tmp, 0, tmp, 0);
          transferMap[i] = tmp[0] * 255 | 0;
        }

        smaskOptions.transferMap = transferMap;
      }

      return this.buildFormXObject(resources, smaskContent, smaskOptions, operatorList, task, stateManager.state.clone(), localColorSpaceCache);
    }
  }, {
    key: "handleTransferFunction",
    value: function handleTransferFunction(tr) {
      var transferArray;

      if (Array.isArray(tr)) {
        transferArray = tr;
      } else if ((0, _function.isPDFFunction)(tr)) {
        transferArray = [tr];
      } else {
        return null;
      }

      var transferMaps = [];
      var numFns = 0,
          numEffectfulFns = 0;

      var _iterator4 = _createForOfIteratorHelper(transferArray),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var entry = _step4.value;
          var transferObj = this.xref.fetchIfRef(entry);
          numFns++;

          if ((0, _primitives.isName)(transferObj, "Identity")) {
            transferMaps.push(null);
            continue;
          } else if (!(0, _function.isPDFFunction)(transferObj)) {
            return null;
          }

          var transferFn = this._pdfFunctionFactory.create(transferObj);

          var transferMap = new Uint8Array(256),
              tmp = new Float32Array(1);

          for (var j = 0; j < 256; j++) {
            tmp[0] = j / 255;
            transferFn(tmp, 0, tmp, 0);
            transferMap[j] = tmp[0] * 255 | 0;
          }

          transferMaps.push(transferMap);
          numEffectfulFns++;
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }

      if (!(numFns === 1 || numFns === 4)) {
        return null;
      }

      if (numEffectfulFns === 0) {
        return null;
      }

      return transferMaps;
    }
  }, {
    key: "handleTilingType",
    value: function handleTilingType(fn, color, resources, pattern, patternDict, operatorList, task, localTilingPatternCache) {
      var _this2 = this;

      var tilingOpList = new _operator_list.OperatorList();

      var patternResources = _primitives.Dict.merge({
        xref: this.xref,
        dictArray: [patternDict.get("Resources"), resources]
      });

      return this.getOperatorList({
        stream: pattern,
        task: task,
        resources: patternResources,
        operatorList: tilingOpList
      }).then(function () {
        var operatorListIR = tilingOpList.getIR();
        var tilingPatternIR = (0, _pattern.getTilingPatternIR)(operatorListIR, patternDict, color);
        operatorList.addDependencies(tilingOpList.dependencies);
        operatorList.addOp(fn, tilingPatternIR);

        if (patternDict.objId) {
          localTilingPatternCache.set(null, patternDict.objId, {
            operatorListIR: operatorListIR,
            dict: patternDict
          });
        }
      })["catch"](function (reason) {
        if (reason instanceof _util.AbortException) {
          return;
        }

        if (_this2.options.ignoreErrors) {
          _this2.handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorTilingPattern
          });

          (0, _util.warn)("handleTilingType - ignoring pattern: \"".concat(reason, "\"."));
          return;
        }

        throw reason;
      });
    }
  }, {
    key: "handleSetFont",
    value: function handleSetFont(resources, fontArgs, fontRef, operatorList, task, state) {
      var _this3 = this;

      var fallbackFontDict = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
      var cssFontInfo = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : null;
      var fontName = fontArgs && fontArgs[0] instanceof _primitives.Name ? fontArgs[0].name : null;
      return this.loadFont(fontName, fontRef, resources, fallbackFontDict, cssFontInfo).then(function (translated) {
        if (!translated.font.isType3Font) {
          return translated;
        }

        return translated.loadType3Data(_this3, resources, task).then(function () {
          operatorList.addDependencies(translated.type3Dependencies);
          return translated;
        })["catch"](function (reason) {
          _this3.handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorFontLoadType3
          });

          return new TranslatedFont({
            loadedName: "g_font_error",
            font: new _fonts.ErrorFont("Type3 font load error: ".concat(reason)),
            dict: translated.font,
            evaluatorOptions: _this3.options
          });
        });
      }).then(function (translated) {
        state.font = translated.font;
        translated.send(_this3.handler);
        return translated.loadedName;
      });
    }
  }, {
    key: "handleText",
    value: function handleText(chars, state) {
      var font = state.font;
      var glyphs = font.charsToGlyphs(chars);

      if (font.data) {
        var isAddToPathSet = !!(state.textRenderingMode & _util.TextRenderingMode.ADD_TO_PATH_FLAG);

        if (isAddToPathSet || state.fillColorSpace.name === "Pattern" || font.disableFontFace || this.options.disableFontFace) {
          PartialEvaluator.buildFontPaths(font, glyphs, this.handler, this.options);
        }
      }

      return glyphs;
    }
  }, {
    key: "ensureStateFont",
    value: function ensureStateFont(state) {
      if (state.font) {
        return;
      }

      var reason = new _util.FormatError("Missing setFont (Tf) operator before text rendering operator.");

      if (this.options.ignoreErrors) {
        this.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorFontState
        });
        (0, _util.warn)("ensureStateFont: \"".concat(reason, "\"."));
        return;
      }

      throw reason;
    }
  }, {
    key: "setGState",
    value: function () {
      var _setGState = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee5(_ref3) {
        var _this4 = this;

        var resources, gState, operatorList, cacheKey, task, stateManager, localGStateCache, localColorSpaceCache, gStateRef, isSimpleGState, gStateObj, gStateKeys, promise, _loop, i, ii;

        return _regenerator["default"].wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                resources = _ref3.resources, gState = _ref3.gState, operatorList = _ref3.operatorList, cacheKey = _ref3.cacheKey, task = _ref3.task, stateManager = _ref3.stateManager, localGStateCache = _ref3.localGStateCache, localColorSpaceCache = _ref3.localColorSpaceCache;
                gStateRef = gState.objId;
                isSimpleGState = true;
                gStateObj = [];
                gStateKeys = gState.getKeys();
                promise = Promise.resolve();

                _loop = function _loop(i, ii) {
                  var key = gStateKeys[i];
                  var value = gState.get(key);

                  switch (key) {
                    case "Type":
                      break;

                    case "LW":
                    case "LC":
                    case "LJ":
                    case "ML":
                    case "D":
                    case "RI":
                    case "FL":
                    case "CA":
                    case "ca":
                      gStateObj.push([key, value]);
                      break;

                    case "Font":
                      isSimpleGState = false;
                      promise = promise.then(function () {
                        return _this4.handleSetFont(resources, null, value[0], operatorList, task, stateManager.state).then(function (loadedName) {
                          operatorList.addDependency(loadedName);
                          gStateObj.push([key, [loadedName, value[1]]]);
                        });
                      });
                      break;

                    case "BM":
                      gStateObj.push([key, normalizeBlendMode(value)]);
                      break;

                    case "SMask":
                      if ((0, _primitives.isName)(value, "None")) {
                        gStateObj.push([key, false]);
                        break;
                      }

                      if (value instanceof _primitives.Dict) {
                        isSimpleGState = false;
                        promise = promise.then(function () {
                          return _this4.handleSMask(value, resources, operatorList, task, stateManager, localColorSpaceCache);
                        });
                        gStateObj.push([key, true]);
                      } else {
                        (0, _util.warn)("Unsupported SMask type");
                      }

                      break;

                    case "TR":
                      var transferMaps = _this4.handleTransferFunction(value);

                      gStateObj.push([key, transferMaps]);
                      break;

                    case "OP":
                    case "op":
                    case "OPM":
                    case "BG":
                    case "BG2":
                    case "UCR":
                    case "UCR2":
                    case "TR2":
                    case "HT":
                    case "SM":
                    case "SA":
                    case "AIS":
                    case "TK":
                      (0, _util.info)("graphic state operator " + key);
                      break;

                    default:
                      (0, _util.info)("Unknown graphic state operator " + key);
                      break;
                  }
                };

                for (i = 0, ii = gStateKeys.length; i < ii; i++) {
                  _loop(i, ii);
                }

                return _context5.abrupt("return", promise.then(function () {
                  if (gStateObj.length > 0) {
                    operatorList.addOp(_util.OPS.setGState, [gStateObj]);
                  }

                  if (isSimpleGState) {
                    localGStateCache.set(cacheKey, gStateRef, gStateObj);
                  }
                }));

              case 9:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5);
      }));

      function setGState(_x11) {
        return _setGState.apply(this, arguments);
      }

      return setGState;
    }()
  }, {
    key: "loadFont",
    value: function loadFont(fontName, font, resources) {
      var _this5 = this;

      var fallbackFontDict = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
      var cssFontInfo = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;

      var errorFont = /*#__PURE__*/function () {
        var _ref4 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee6() {
          return _regenerator["default"].wrap(function _callee6$(_context6) {
            while (1) {
              switch (_context6.prev = _context6.next) {
                case 0:
                  return _context6.abrupt("return", new TranslatedFont({
                    loadedName: "g_font_error",
                    font: new _fonts.ErrorFont("Font \"".concat(fontName, "\" is not available.")),
                    dict: font,
                    evaluatorOptions: _this5.options
                  }));

                case 1:
                case "end":
                  return _context6.stop();
              }
            }
          }, _callee6);
        }));

        return function errorFont() {
          return _ref4.apply(this, arguments);
        };
      }();

      var xref = this.xref;
      var fontRef;

      if (font) {
        if (!(font instanceof _primitives.Ref)) {
          throw new _util.FormatError('The "font" object should be a reference.');
        }

        fontRef = font;
      } else {
        var fontRes = resources.get("Font");

        if (fontRes) {
          fontRef = fontRes.getRaw(fontName);
        }
      }

      if (!fontRef) {
        var partialMsg = "Font \"".concat(fontName || font && font.toString(), "\" is not available");

        if (!this.options.ignoreErrors && !this.parsingType3Font) {
          (0, _util.warn)("".concat(partialMsg, "."));
          return errorFont();
        }

        this.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorFontMissing
        });
        (0, _util.warn)("".concat(partialMsg, " -- attempting to fallback to a default font."));

        if (fallbackFontDict) {
          fontRef = fallbackFontDict;
        } else {
          fontRef = PartialEvaluator.fallbackFontDict;
        }
      }

      if (this.parsingType3Font && this.type3FontRefs.has(fontRef)) {
        return errorFont();
      }

      if (this.fontCache.has(fontRef)) {
        return this.fontCache.get(fontRef);
      }

      font = xref.fetchIfRef(fontRef);

      if (!(font instanceof _primitives.Dict)) {
        return errorFont();
      }

      if (font.cacheKey && this.fontCache.has(font.cacheKey)) {
        return this.fontCache.get(font.cacheKey);
      }

      var fontCapability = (0, _util.createPromiseCapability)();
      var preEvaluatedFont;

      try {
        preEvaluatedFont = this.preEvaluateFont(font);
        preEvaluatedFont.cssFontInfo = cssFontInfo;
      } catch (reason) {
        (0, _util.warn)("loadFont - preEvaluateFont failed: \"".concat(reason, "\"."));
        return errorFont();
      }

      var _preEvaluatedFont = preEvaluatedFont,
          descriptor = _preEvaluatedFont.descriptor,
          hash = _preEvaluatedFont.hash;
      var fontRefIsRef = fontRef instanceof _primitives.Ref;
      var fontID;

      if (fontRefIsRef) {
        fontID = "f".concat(fontRef.toString());
      }

      if (hash && descriptor instanceof _primitives.Dict) {
        if (!descriptor.fontAliases) {
          descriptor.fontAliases = Object.create(null);
        }

        var fontAliases = descriptor.fontAliases;

        if (fontAliases[hash]) {
          var aliasFontRef = fontAliases[hash].aliasRef;

          if (fontRefIsRef && aliasFontRef && this.fontCache.has(aliasFontRef)) {
            this.fontCache.putAlias(fontRef, aliasFontRef);
            return this.fontCache.get(fontRef);
          }
        } else {
          fontAliases[hash] = {
            fontID: this.idFactory.createFontId()
          };
        }

        if (fontRefIsRef) {
          fontAliases[hash].aliasRef = fontRef;
        }

        fontID = fontAliases[hash].fontID;
      }

      if (fontRefIsRef) {
        this.fontCache.put(fontRef, fontCapability.promise);
      } else {
        if (!fontID) {
          fontID = this.idFactory.createFontId();
        }

        font.cacheKey = "cacheKey_".concat(fontID);
        this.fontCache.put(font.cacheKey, fontCapability.promise);
      }

      (0, _util.assert)(fontID && fontID.startsWith("f"), 'The "fontID" must be (correctly) defined.');
      font.loadedName = "".concat(this.idFactory.getDocId(), "_").concat(fontID);
      this.translateFont(preEvaluatedFont).then(function (translatedFont) {
        if (translatedFont.fontType !== undefined) {
          xref.stats.addFontType(translatedFont.fontType);
        }

        fontCapability.resolve(new TranslatedFont({
          loadedName: font.loadedName,
          font: translatedFont,
          dict: font,
          evaluatorOptions: _this5.options
        }));
      })["catch"](function (reason) {
        _this5.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorFontTranslate
        });

        (0, _util.warn)("loadFont - translateFont failed: \"".concat(reason, "\"."));

        try {
          var fontFile3 = descriptor && descriptor.get("FontFile3");
          var subtype = fontFile3 && fontFile3.get("Subtype");
          var fontType = (0, _fonts_utils.getFontType)(preEvaluatedFont.type, subtype && subtype.name);

          if (fontType !== undefined) {
            xref.stats.addFontType(fontType);
          }
        } catch (ex) {}

        fontCapability.resolve(new TranslatedFont({
          loadedName: font.loadedName,
          font: new _fonts.ErrorFont(reason instanceof Error ? reason.message : reason),
          dict: font,
          evaluatorOptions: _this5.options
        }));
      });
      return fontCapability.promise;
    }
  }, {
    key: "buildPath",
    value: function buildPath(operatorList, fn, args) {
      var parsingText = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      var lastIndex = operatorList.length - 1;

      if (!args) {
        args = [];
      }

      if (lastIndex < 0 || operatorList.fnArray[lastIndex] !== _util.OPS.constructPath) {
        if (parsingText) {
          (0, _util.warn)("Encountered path operator \"".concat(fn, "\" inside of a text object."));
          operatorList.addOp(_util.OPS.save, null);
        }

        operatorList.addOp(_util.OPS.constructPath, [[fn], args]);

        if (parsingText) {
          operatorList.addOp(_util.OPS.restore, null);
        }
      } else {
        var opArgs = operatorList.argsArray[lastIndex];
        opArgs[0].push(fn);
        Array.prototype.push.apply(opArgs[1], args);
      }
    }
  }, {
    key: "parseColorSpace",
    value: function parseColorSpace(_ref5) {
      var _this6 = this;

      var cs = _ref5.cs,
          resources = _ref5.resources,
          localColorSpaceCache = _ref5.localColorSpaceCache;
      return _colorspace.ColorSpace.parseAsync({
        cs: cs,
        xref: this.xref,
        resources: resources,
        pdfFunctionFactory: this._pdfFunctionFactory,
        localColorSpaceCache: localColorSpaceCache
      })["catch"](function (reason) {
        if (reason instanceof _util.AbortException) {
          return null;
        }

        if (_this6.options.ignoreErrors) {
          _this6.handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorColorSpace
          });

          (0, _util.warn)("parseColorSpace - ignoring ColorSpace: \"".concat(reason, "\"."));
          return null;
        }

        throw reason;
      });
    }
  }, {
    key: "parseShading",
    value: function parseShading(_ref6) {
      var shading = _ref6.shading,
          resources = _ref6.resources,
          localColorSpaceCache = _ref6.localColorSpaceCache,
          localShadingPatternCache = _ref6.localShadingPatternCache;
      var id = localShadingPatternCache.get(shading);

      if (!id) {
        var shadingFill = _pattern.Pattern.parseShading(shading, this.xref, resources, this.handler, this._pdfFunctionFactory, localColorSpaceCache);

        var patternIR = shadingFill.getIR();
        id = "pattern_".concat(this.idFactory.createObjId());
        localShadingPatternCache.set(shading, id);
        this.handler.send("obj", [id, this.pageIndex, "Pattern", patternIR]);
      }

      return id;
    }
  }, {
    key: "handleColorN",
    value: function handleColorN(operatorList, fn, args, cs, patterns, resources, task, localColorSpaceCache, localTilingPatternCache, localShadingPatternCache) {
      var patternName = args.pop();

      if (patternName instanceof _primitives.Name) {
        var rawPattern = patterns.getRaw(patternName.name);
        var localTilingPattern = rawPattern instanceof _primitives.Ref && localTilingPatternCache.getByRef(rawPattern);

        if (localTilingPattern) {
          try {
            var color = cs.base ? cs.base.getRgb(args, 0) : null;
            var tilingPatternIR = (0, _pattern.getTilingPatternIR)(localTilingPattern.operatorListIR, localTilingPattern.dict, color);
            operatorList.addOp(fn, tilingPatternIR);
            return undefined;
          } catch (ex) {}
        }

        var pattern = this.xref.fetchIfRef(rawPattern);

        if (pattern) {
          var dict = pattern instanceof _base_stream.BaseStream ? pattern.dict : pattern;
          var typeNum = dict.get("PatternType");

          if (typeNum === PatternType.TILING) {
            var _color = cs.base ? cs.base.getRgb(args, 0) : null;

            return this.handleTilingType(fn, _color, resources, pattern, dict, operatorList, task, localTilingPatternCache);
          } else if (typeNum === PatternType.SHADING) {
            var shading = dict.get("Shading");
            var matrix = dict.getArray("Matrix");
            var objId = this.parseShading({
              shading: shading,
              resources: resources,
              localColorSpaceCache: localColorSpaceCache,
              localShadingPatternCache: localShadingPatternCache
            });
            operatorList.addOp(fn, ["Shading", objId, matrix]);
            return undefined;
          }

          throw new _util.FormatError("Unknown PatternType: ".concat(typeNum));
        }
      }

      throw new _util.FormatError("Unknown PatternName: ".concat(patternName));
    }
  }, {
    key: "_parseVisibilityExpression",
    value: function _parseVisibilityExpression(array, nestingCounter, currentResult) {
      var MAX_NESTING = 10;

      if (++nestingCounter > MAX_NESTING) {
        (0, _util.warn)("Visibility expression is too deeply nested");
        return;
      }

      var length = array.length;
      var operator = this.xref.fetchIfRef(array[0]);

      if (length < 2 || !(operator instanceof _primitives.Name)) {
        (0, _util.warn)("Invalid visibility expression");
        return;
      }

      switch (operator.name) {
        case "And":
        case "Or":
        case "Not":
          currentResult.push(operator.name);
          break;

        default:
          (0, _util.warn)("Invalid operator ".concat(operator.name, " in visibility expression"));
          return;
      }

      for (var i = 1; i < length; i++) {
        var raw = array[i];
        var object = this.xref.fetchIfRef(raw);

        if (Array.isArray(object)) {
          var nestedResult = [];
          currentResult.push(nestedResult);

          this._parseVisibilityExpression(object, nestingCounter, nestedResult);
        } else if (raw instanceof _primitives.Ref) {
          currentResult.push(raw.toString());
        }
      }
    }
  }, {
    key: "parseMarkedContentProps",
    value: function () {
      var _parseMarkedContentProps = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee7(contentProperties, resources) {
        var optionalContent, properties, optionalContentType, expression, result, optionalContentGroups, groupIds, _iterator5, _step5, ocg;

        return _regenerator["default"].wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                if (!(contentProperties instanceof _primitives.Name)) {
                  _context7.next = 5;
                  break;
                }

                properties = resources.get("Properties");
                optionalContent = properties.get(contentProperties.name);
                _context7.next = 10;
                break;

              case 5:
                if (!(contentProperties instanceof _primitives.Dict)) {
                  _context7.next = 9;
                  break;
                }

                optionalContent = contentProperties;
                _context7.next = 10;
                break;

              case 9:
                throw new _util.FormatError("Optional content properties malformed.");

              case 10:
                optionalContentType = optionalContent.get("Type").name;

                if (!(optionalContentType === "OCG")) {
                  _context7.next = 15;
                  break;
                }

                return _context7.abrupt("return", {
                  type: optionalContentType,
                  id: optionalContent.objId
                });

              case 15:
                if (!(optionalContentType === "OCMD")) {
                  _context7.next = 31;
                  break;
                }

                expression = optionalContent.get("VE");

                if (!Array.isArray(expression)) {
                  _context7.next = 22;
                  break;
                }

                result = [];

                this._parseVisibilityExpression(expression, 0, result);

                if (!(result.length > 0)) {
                  _context7.next = 22;
                  break;
                }

                return _context7.abrupt("return", {
                  type: "OCMD",
                  expression: result
                });

              case 22:
                optionalContentGroups = optionalContent.get("OCGs");

                if (!(Array.isArray(optionalContentGroups) || optionalContentGroups instanceof _primitives.Dict)) {
                  _context7.next = 29;
                  break;
                }

                groupIds = [];

                if (Array.isArray(optionalContentGroups)) {
                  _iterator5 = _createForOfIteratorHelper(optionalContentGroups);

                  try {
                    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                      ocg = _step5.value;
                      groupIds.push(ocg.toString());
                    }
                  } catch (err) {
                    _iterator5.e(err);
                  } finally {
                    _iterator5.f();
                  }
                } else {
                  groupIds.push(optionalContentGroups.objId);
                }

                return _context7.abrupt("return", {
                  type: optionalContentType,
                  ids: groupIds,
                  policy: optionalContent.get("P") instanceof _primitives.Name ? optionalContent.get("P").name : null,
                  expression: null
                });

              case 29:
                if (!(optionalContentGroups instanceof _primitives.Ref)) {
                  _context7.next = 31;
                  break;
                }

                return _context7.abrupt("return", {
                  type: optionalContentType,
                  id: optionalContentGroups.toString()
                });

              case 31:
                return _context7.abrupt("return", null);

              case 32:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this);
      }));

      function parseMarkedContentProps(_x12, _x13) {
        return _parseMarkedContentProps.apply(this, arguments);
      }

      return parseMarkedContentProps;
    }()
  }, {
    key: "getOperatorList",
    value: function getOperatorList(_ref7) {
      var _this7 = this;

      var stream = _ref7.stream,
          task = _ref7.task,
          resources = _ref7.resources,
          operatorList = _ref7.operatorList,
          _ref7$initialState = _ref7.initialState,
          initialState = _ref7$initialState === void 0 ? null : _ref7$initialState,
          _ref7$fallbackFontDic = _ref7.fallbackFontDict,
          fallbackFontDict = _ref7$fallbackFontDic === void 0 ? null : _ref7$fallbackFontDic;
      resources = resources || _primitives.Dict.empty;
      initialState = initialState || new EvalState();

      if (!operatorList) {
        throw new Error('getOperatorList: missing "operatorList" parameter');
      }

      var self = this;
      var xref = this.xref;
      var parsingText = false;
      var localImageCache = new _image_utils.LocalImageCache();
      var localColorSpaceCache = new _image_utils.LocalColorSpaceCache();
      var localGStateCache = new _image_utils.LocalGStateCache();
      var localTilingPatternCache = new _image_utils.LocalTilingPatternCache();
      var localShadingPatternCache = new Map();

      var xobjs = resources.get("XObject") || _primitives.Dict.empty;

      var patterns = resources.get("Pattern") || _primitives.Dict.empty;

      var stateManager = new StateManager(initialState);
      var preprocessor = new EvaluatorPreprocessor(stream, xref, stateManager);
      var timeSlotManager = new TimeSlotManager();

      function closePendingRestoreOPS(argument) {
        for (var i = 0, ii = preprocessor.savedStatesDepth; i < ii; i++) {
          operatorList.addOp(_util.OPS.restore, []);
        }
      }

      return new Promise(function promiseBody(resolve, reject) {
        var next = function next(promise) {
          Promise.all([promise, operatorList.ready]).then(function () {
            try {
              promiseBody(resolve, reject);
            } catch (ex) {
              reject(ex);
            }
          }, reject);
        };

        task.ensureNotTerminated();
        timeSlotManager.reset();
        var operation = {};
        var stop, i, ii, cs, name, isValidName;

        while (!(stop = timeSlotManager.check())) {
          operation.args = null;

          if (!preprocessor.read(operation)) {
            break;
          }

          var args = operation.args;
          var fn = operation.fn;

          switch (fn | 0) {
            case _util.OPS.paintXObject:
              isValidName = args[0] instanceof _primitives.Name;
              name = args[0].name;

              if (isValidName) {
                var localImage = localImageCache.getByName(name);

                if (localImage) {
                  operatorList.addOp(localImage.fn, localImage.args);
                  args = null;
                  continue;
                }
              }

              next(new Promise(function (resolveXObject, rejectXObject) {
                if (!isValidName) {
                  throw new _util.FormatError("XObject must be referred to by name.");
                }

                var xobj = xobjs.getRaw(name);

                if (xobj instanceof _primitives.Ref) {
                  var _localImage = localImageCache.getByRef(xobj);

                  if (_localImage) {
                    operatorList.addOp(_localImage.fn, _localImage.args);
                    resolveXObject();
                    return;
                  }

                  var globalImage = self.globalImageCache.getData(xobj, self.pageIndex);

                  if (globalImage) {
                    operatorList.addDependency(globalImage.objId);
                    operatorList.addOp(globalImage.fn, globalImage.args);
                    resolveXObject();
                    return;
                  }

                  xobj = xref.fetch(xobj);
                }

                if (!(xobj instanceof _base_stream.BaseStream)) {
                  throw new _util.FormatError("XObject should be a stream");
                }

                var type = xobj.dict.get("Subtype");

                if (!(type instanceof _primitives.Name)) {
                  throw new _util.FormatError("XObject should have a Name subtype");
                }

                if (type.name === "Form") {
                  stateManager.save();
                  self.buildFormXObject(resources, xobj, null, operatorList, task, stateManager.state.clone(), localColorSpaceCache).then(function () {
                    stateManager.restore();
                    resolveXObject();
                  }, rejectXObject);
                  return;
                } else if (type.name === "Image") {
                  self.buildPaintImageXObject({
                    resources: resources,
                    image: xobj,
                    operatorList: operatorList,
                    cacheKey: name,
                    localImageCache: localImageCache,
                    localColorSpaceCache: localColorSpaceCache
                  }).then(resolveXObject, rejectXObject);
                  return;
                } else if (type.name === "PS") {
                  (0, _util.info)("Ignored XObject subtype PS");
                } else {
                  throw new _util.FormatError("Unhandled XObject subtype ".concat(type.name));
                }

                resolveXObject();
              })["catch"](function (reason) {
                if (reason instanceof _util.AbortException) {
                  return;
                }

                if (self.options.ignoreErrors) {
                  self.handler.send("UnsupportedFeature", {
                    featureId: _util.UNSUPPORTED_FEATURES.errorXObject
                  });
                  (0, _util.warn)("getOperatorList - ignoring XObject: \"".concat(reason, "\"."));
                  return;
                }

                throw reason;
              }));
              return;

            case _util.OPS.setFont:
              var fontSize = args[1];
              next(self.handleSetFont(resources, args, null, operatorList, task, stateManager.state, fallbackFontDict).then(function (loadedName) {
                operatorList.addDependency(loadedName);
                operatorList.addOp(_util.OPS.setFont, [loadedName, fontSize]);
              }));
              return;

            case _util.OPS.beginText:
              parsingText = true;
              break;

            case _util.OPS.endText:
              parsingText = false;
              break;

            case _util.OPS.endInlineImage:
              var cacheKey = args[0].cacheKey;

              if (cacheKey) {
                var _localImage2 = localImageCache.getByName(cacheKey);

                if (_localImage2) {
                  operatorList.addOp(_localImage2.fn, _localImage2.args);
                  args = null;
                  continue;
                }
              }

              next(self.buildPaintImageXObject({
                resources: resources,
                image: args[0],
                isInline: true,
                operatorList: operatorList,
                cacheKey: cacheKey,
                localImageCache: localImageCache,
                localColorSpaceCache: localColorSpaceCache
              }));
              return;

            case _util.OPS.showText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              args[0] = self.handleText(args[0], stateManager.state);
              break;

            case _util.OPS.showSpacedText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              var arr = args[0];
              var combinedGlyphs = [];
              var arrLength = arr.length;
              var state = stateManager.state;

              for (i = 0; i < arrLength; ++i) {
                var arrItem = arr[i];

                if (typeof arrItem === "string") {
                  Array.prototype.push.apply(combinedGlyphs, self.handleText(arrItem, state));
                } else if (typeof arrItem === "number") {
                  combinedGlyphs.push(arrItem);
                }
              }

              args[0] = combinedGlyphs;
              fn = _util.OPS.showText;
              break;

            case _util.OPS.nextLineShowText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              operatorList.addOp(_util.OPS.nextLine);
              args[0] = self.handleText(args[0], stateManager.state);
              fn = _util.OPS.showText;
              break;

            case _util.OPS.nextLineSetSpacingShowText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              operatorList.addOp(_util.OPS.nextLine);
              operatorList.addOp(_util.OPS.setWordSpacing, [args.shift()]);
              operatorList.addOp(_util.OPS.setCharSpacing, [args.shift()]);
              args[0] = self.handleText(args[0], stateManager.state);
              fn = _util.OPS.showText;
              break;

            case _util.OPS.setTextRenderingMode:
              stateManager.state.textRenderingMode = args[0];
              break;

            case _util.OPS.setFillColorSpace:
              {
                var cachedColorSpace = _colorspace.ColorSpace.getCached(args[0], xref, localColorSpaceCache);

                if (cachedColorSpace) {
                  stateManager.state.fillColorSpace = cachedColorSpace;
                  continue;
                }

                next(self.parseColorSpace({
                  cs: args[0],
                  resources: resources,
                  localColorSpaceCache: localColorSpaceCache
                }).then(function (colorSpace) {
                  if (colorSpace) {
                    stateManager.state.fillColorSpace = colorSpace;
                  }
                }));
                return;
              }

            case _util.OPS.setStrokeColorSpace:
              {
                var _cachedColorSpace = _colorspace.ColorSpace.getCached(args[0], xref, localColorSpaceCache);

                if (_cachedColorSpace) {
                  stateManager.state.strokeColorSpace = _cachedColorSpace;
                  continue;
                }

                next(self.parseColorSpace({
                  cs: args[0],
                  resources: resources,
                  localColorSpaceCache: localColorSpaceCache
                }).then(function (colorSpace) {
                  if (colorSpace) {
                    stateManager.state.strokeColorSpace = colorSpace;
                  }
                }));
                return;
              }

            case _util.OPS.setFillColor:
              cs = stateManager.state.fillColorSpace;
              args = cs.getRgb(args, 0);
              fn = _util.OPS.setFillRGBColor;
              break;

            case _util.OPS.setStrokeColor:
              cs = stateManager.state.strokeColorSpace;
              args = cs.getRgb(args, 0);
              fn = _util.OPS.setStrokeRGBColor;
              break;

            case _util.OPS.setFillGray:
              stateManager.state.fillColorSpace = _colorspace.ColorSpace.singletons.gray;
              args = _colorspace.ColorSpace.singletons.gray.getRgb(args, 0);
              fn = _util.OPS.setFillRGBColor;
              break;

            case _util.OPS.setStrokeGray:
              stateManager.state.strokeColorSpace = _colorspace.ColorSpace.singletons.gray;
              args = _colorspace.ColorSpace.singletons.gray.getRgb(args, 0);
              fn = _util.OPS.setStrokeRGBColor;
              break;

            case _util.OPS.setFillCMYKColor:
              stateManager.state.fillColorSpace = _colorspace.ColorSpace.singletons.cmyk;
              args = _colorspace.ColorSpace.singletons.cmyk.getRgb(args, 0);
              fn = _util.OPS.setFillRGBColor;
              break;

            case _util.OPS.setStrokeCMYKColor:
              stateManager.state.strokeColorSpace = _colorspace.ColorSpace.singletons.cmyk;
              args = _colorspace.ColorSpace.singletons.cmyk.getRgb(args, 0);
              fn = _util.OPS.setStrokeRGBColor;
              break;

            case _util.OPS.setFillRGBColor:
              stateManager.state.fillColorSpace = _colorspace.ColorSpace.singletons.rgb;
              args = _colorspace.ColorSpace.singletons.rgb.getRgb(args, 0);
              break;

            case _util.OPS.setStrokeRGBColor:
              stateManager.state.strokeColorSpace = _colorspace.ColorSpace.singletons.rgb;
              args = _colorspace.ColorSpace.singletons.rgb.getRgb(args, 0);
              break;

            case _util.OPS.setFillColorN:
              cs = stateManager.state.fillColorSpace;

              if (cs.name === "Pattern") {
                next(self.handleColorN(operatorList, _util.OPS.setFillColorN, args, cs, patterns, resources, task, localColorSpaceCache, localTilingPatternCache, localShadingPatternCache));
                return;
              }

              args = cs.getRgb(args, 0);
              fn = _util.OPS.setFillRGBColor;
              break;

            case _util.OPS.setStrokeColorN:
              cs = stateManager.state.strokeColorSpace;

              if (cs.name === "Pattern") {
                next(self.handleColorN(operatorList, _util.OPS.setStrokeColorN, args, cs, patterns, resources, task, localColorSpaceCache, localTilingPatternCache, localShadingPatternCache));
                return;
              }

              args = cs.getRgb(args, 0);
              fn = _util.OPS.setStrokeRGBColor;
              break;

            case _util.OPS.shadingFill:
              var shadingRes = resources.get("Shading");

              if (!shadingRes) {
                throw new _util.FormatError("No shading resource found");
              }

              var shading = shadingRes.get(args[0].name);

              if (!shading) {
                throw new _util.FormatError("No shading object found");
              }

              var patternId = self.parseShading({
                shading: shading,
                resources: resources,
                localColorSpaceCache: localColorSpaceCache,
                localShadingPatternCache: localShadingPatternCache
              });
              args = [patternId];
              fn = _util.OPS.shadingFill;
              break;

            case _util.OPS.setGState:
              isValidName = args[0] instanceof _primitives.Name;
              name = args[0].name;

              if (isValidName) {
                var localGStateObj = localGStateCache.getByName(name);

                if (localGStateObj) {
                  if (localGStateObj.length > 0) {
                    operatorList.addOp(_util.OPS.setGState, [localGStateObj]);
                  }

                  args = null;
                  continue;
                }
              }

              next(new Promise(function (resolveGState, rejectGState) {
                if (!isValidName) {
                  throw new _util.FormatError("GState must be referred to by name.");
                }

                var extGState = resources.get("ExtGState");

                if (!(extGState instanceof _primitives.Dict)) {
                  throw new _util.FormatError("ExtGState should be a dictionary.");
                }

                var gState = extGState.get(name);

                if (!(gState instanceof _primitives.Dict)) {
                  throw new _util.FormatError("GState should be a dictionary.");
                }

                self.setGState({
                  resources: resources,
                  gState: gState,
                  operatorList: operatorList,
                  cacheKey: name,
                  task: task,
                  stateManager: stateManager,
                  localGStateCache: localGStateCache,
                  localColorSpaceCache: localColorSpaceCache
                }).then(resolveGState, rejectGState);
              })["catch"](function (reason) {
                if (reason instanceof _util.AbortException) {
                  return;
                }

                if (self.options.ignoreErrors) {
                  self.handler.send("UnsupportedFeature", {
                    featureId: _util.UNSUPPORTED_FEATURES.errorExtGState
                  });
                  (0, _util.warn)("getOperatorList - ignoring ExtGState: \"".concat(reason, "\"."));
                  return;
                }

                throw reason;
              }));
              return;

            case _util.OPS.moveTo:
            case _util.OPS.lineTo:
            case _util.OPS.curveTo:
            case _util.OPS.curveTo2:
            case _util.OPS.curveTo3:
            case _util.OPS.closePath:
            case _util.OPS.rectangle:
              self.buildPath(operatorList, fn, args, parsingText);
              continue;

            case _util.OPS.markPoint:
            case _util.OPS.markPointProps:
            case _util.OPS.beginCompat:
            case _util.OPS.endCompat:
              continue;

            case _util.OPS.beginMarkedContentProps:
              if (!(args[0] instanceof _primitives.Name)) {
                (0, _util.warn)("Expected name for beginMarkedContentProps arg0=".concat(args[0]));
                continue;
              }

              if (args[0].name === "OC") {
                next(self.parseMarkedContentProps(args[1], resources).then(function (data) {
                  operatorList.addOp(_util.OPS.beginMarkedContentProps, ["OC", data]);
                })["catch"](function (reason) {
                  if (reason instanceof _util.AbortException) {
                    return;
                  }

                  if (self.options.ignoreErrors) {
                    self.handler.send("UnsupportedFeature", {
                      featureId: _util.UNSUPPORTED_FEATURES.errorMarkedContent
                    });
                    (0, _util.warn)("getOperatorList - ignoring beginMarkedContentProps: \"".concat(reason, "\"."));
                    return;
                  }

                  throw reason;
                }));
                return;
              }

              args = [args[0].name, args[1] instanceof _primitives.Dict ? args[1].get("MCID") : null];
              break;

            case _util.OPS.beginMarkedContent:
            case _util.OPS.endMarkedContent:
            default:
              if (args !== null) {
                for (i = 0, ii = args.length; i < ii; i++) {
                  if (args[i] instanceof _primitives.Dict) {
                    break;
                  }
                }

                if (i < ii) {
                  (0, _util.warn)("getOperatorList - ignoring operator: " + fn);
                  continue;
                }
              }

          }

          operatorList.addOp(fn, args);
        }

        if (stop) {
          next(deferred);
          return;
        }

        closePendingRestoreOPS();
        resolve();
      })["catch"](function (reason) {
        if (reason instanceof _util.AbortException) {
          return;
        }

        if (_this7.options.ignoreErrors) {
          _this7.handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorOperatorList
          });

          (0, _util.warn)("getOperatorList - ignoring errors during \"".concat(task.name, "\" ") + "task: \"".concat(reason, "\"."));
          closePendingRestoreOPS();
          return;
        }

        throw reason;
      });
    }
  }, {
    key: "getTextContent",
    value: function getTextContent(_ref8) {
      var _this8 = this;

      var stream = _ref8.stream,
          task = _ref8.task,
          resources = _ref8.resources,
          _ref8$stateManager = _ref8.stateManager,
          stateManager = _ref8$stateManager === void 0 ? null : _ref8$stateManager,
          _ref8$combineTextItem = _ref8.combineTextItems,
          combineTextItems = _ref8$combineTextItem === void 0 ? false : _ref8$combineTextItem,
          _ref8$includeMarkedCo = _ref8.includeMarkedContent,
          includeMarkedContent = _ref8$includeMarkedCo === void 0 ? false : _ref8$includeMarkedCo,
          sink = _ref8.sink,
          _ref8$seenStyles = _ref8.seenStyles,
          seenStyles = _ref8$seenStyles === void 0 ? new Set() : _ref8$seenStyles,
          viewBox = _ref8.viewBox;
      resources = resources || _primitives.Dict.empty;
      stateManager = stateManager || new StateManager(new TextState());
      var NormalizedUnicodes = (0, _unicode.getNormalizedUnicodes)();
      var textContent = {
        items: [],
        styles: Object.create(null)
      };
      var textContentItem = {
        initialized: false,
        str: [],
        totalWidth: 0,
        totalHeight: 0,
        width: 0,
        height: 0,
        vertical: false,
        prevTransform: null,
        textAdvanceScale: 0,
        spaceInFlowMin: 0,
        spaceInFlowMax: 0,
        trackingSpaceMin: Infinity,
        negativeSpaceMax: -Infinity,
        transform: null,
        fontName: null,
        hasEOL: false
      };
      var TRACKING_SPACE_FACTOR = 0.1;
      var NEGATIVE_SPACE_FACTOR = -0.2;
      var SPACE_IN_FLOW_MIN_FACTOR = 0.1;
      var SPACE_IN_FLOW_MAX_FACTOR = 0.6;
      var self = this;
      var xref = this.xref;
      var showSpacedTextBuffer = [];
      var xobjs = null;
      var emptyXObjectCache = new _image_utils.LocalImageCache();
      var emptyGStateCache = new _image_utils.LocalGStateCache();
      var preprocessor = new EvaluatorPreprocessor(stream, xref, stateManager);
      var textState;

      function getCurrentTextTransform() {
        var font = textState.font;
        var tsm = [textState.fontSize * textState.textHScale, 0, 0, textState.fontSize, 0, textState.textRise];

        if (font.isType3Font && (textState.fontSize <= 1 || font.isCharBBox) && !(0, _util.isArrayEqual)(textState.fontMatrix, _util.FONT_IDENTITY_MATRIX)) {
          var glyphHeight = font.bbox[3] - font.bbox[1];

          if (glyphHeight > 0) {
            tsm[3] *= glyphHeight * textState.fontMatrix[3];
          }
        }

        return _util.Util.transform(textState.ctm, _util.Util.transform(textState.textMatrix, tsm));
      }

      function ensureTextContentItem() {
        if (textContentItem.initialized) {
          return textContentItem;
        }

        var font = textState.font,
            loadedName = font.loadedName;

        if (!seenStyles.has(loadedName)) {
          seenStyles.add(loadedName);
          textContent.styles[loadedName] = {
            fontFamily: font.fallbackName,
            ascent: font.ascent,
            descent: font.descent,
            vertical: font.vertical
          };
        }

        textContentItem.fontName = loadedName;
        var trm = textContentItem.transform = getCurrentTextTransform();

        if (!font.vertical) {
          textContentItem.width = textContentItem.totalWidth = 0;
          textContentItem.height = textContentItem.totalHeight = Math.hypot(trm[2], trm[3]);
          textContentItem.vertical = false;
        } else {
          textContentItem.width = textContentItem.totalWidth = Math.hypot(trm[0], trm[1]);
          textContentItem.height = textContentItem.totalHeight = 0;
          textContentItem.vertical = true;
        }

        var scaleLineX = Math.hypot(textState.textLineMatrix[0], textState.textLineMatrix[1]);
        var scaleCtmX = Math.hypot(textState.ctm[0], textState.ctm[1]);
        textContentItem.textAdvanceScale = scaleCtmX * scaleLineX;
        textContentItem.trackingSpaceMin = textState.fontSize * TRACKING_SPACE_FACTOR;
        textContentItem.negativeSpaceMax = textState.fontSize * NEGATIVE_SPACE_FACTOR;
        textContentItem.spaceInFlowMin = textState.fontSize * SPACE_IN_FLOW_MIN_FACTOR;
        textContentItem.spaceInFlowMax = textState.fontSize * SPACE_IN_FLOW_MAX_FACTOR;
        textContentItem.hasEOL = false;
        textContentItem.initialized = true;
        return textContentItem;
      }

      function updateAdvanceScale() {
        if (!textContentItem.initialized) {
          return;
        }

        var scaleLineX = Math.hypot(textState.textLineMatrix[0], textState.textLineMatrix[1]);
        var scaleCtmX = Math.hypot(textState.ctm[0], textState.ctm[1]);
        var scaleFactor = scaleCtmX * scaleLineX;

        if (scaleFactor === textContentItem.textAdvanceScale) {
          return;
        }

        if (!textContentItem.vertical) {
          textContentItem.totalWidth += textContentItem.width * textContentItem.textAdvanceScale;
          textContentItem.width = 0;
        } else {
          textContentItem.totalHeight += textContentItem.height * textContentItem.textAdvanceScale;
          textContentItem.height = 0;
        }

        textContentItem.textAdvanceScale = scaleFactor;
      }

      function runBidiTransform(textChunk) {
        var text = textChunk.str.join("");
        var bidiResult = (0, _bidi.bidi)(text, -1, textChunk.vertical);
        return {
          str: bidiResult.str,
          dir: bidiResult.dir,
          width: Math.abs(textChunk.totalWidth),
          height: Math.abs(textChunk.totalHeight),
          transform: textChunk.transform,
          fontName: textChunk.fontName,
          hasEOL: textChunk.hasEOL
        };
      }

      function handleSetFont(fontName, fontRef) {
        return self.loadFont(fontName, fontRef, resources).then(function (translated) {
          if (!translated.font.isType3Font) {
            return translated;
          }

          return translated.loadType3Data(self, resources, task)["catch"](function () {}).then(function () {
            return translated;
          });
        }).then(function (translated) {
          textState.font = translated.font;
          textState.fontMatrix = translated.font.fontMatrix || _util.FONT_IDENTITY_MATRIX;
        });
      }

      function applyInverseRotation(x, y, matrix) {
        var scale = Math.hypot(matrix[0], matrix[1]);
        return [(matrix[0] * x + matrix[1] * y) / scale, (matrix[2] * x + matrix[3] * y) / scale];
      }

      function compareWithLastPosition() {
        var currentTransform = getCurrentTextTransform();
        var posX = currentTransform[4];
        var posY = currentTransform[5];
        var shiftedX = posX - viewBox[0];
        var shiftedY = posY - viewBox[1];

        if (shiftedX < 0 || shiftedX > viewBox[2] || shiftedY < 0 || shiftedY > viewBox[3]) {
          return false;
        }

        if (!combineTextItems || !textState.font || !textContentItem.prevTransform) {
          return true;
        }

        var lastPosX = textContentItem.prevTransform[4];
        var lastPosY = textContentItem.prevTransform[5];

        if (lastPosX === posX && lastPosY === posY) {
          return true;
        }

        var rotate = -1;

        if (currentTransform[0] && currentTransform[1] === 0 && currentTransform[2] === 0) {
          rotate = currentTransform[0] > 0 ? 0 : 180;
        } else if (currentTransform[1] && currentTransform[0] === 0 && currentTransform[3] === 0) {
          rotate = currentTransform[1] > 0 ? 90 : 270;
        }

        switch (rotate) {
          case 0:
            break;

          case 90:
            var _ref9 = [posY, posX];
            posX = _ref9[0];
            posY = _ref9[1];
            var _ref10 = [lastPosY, lastPosX];
            lastPosX = _ref10[0];
            lastPosY = _ref10[1];
            break;

          case 180:
            var _ref11 = [-posX, -posY, -lastPosX, -lastPosY];
            posX = _ref11[0];
            posY = _ref11[1];
            lastPosX = _ref11[2];
            lastPosY = _ref11[3];
            break;

          case 270:
            var _ref12 = [-posY, -posX];
            posX = _ref12[0];
            posY = _ref12[1];
            var _ref13 = [-lastPosY, -lastPosX];
            lastPosX = _ref13[0];
            lastPosY = _ref13[1];
            break;

          default:
            var _applyInverseRotation = applyInverseRotation(posX, posY, currentTransform);

            var _applyInverseRotation2 = _slicedToArray(_applyInverseRotation, 2);

            posX = _applyInverseRotation2[0];
            posY = _applyInverseRotation2[1];

            var _applyInverseRotation3 = applyInverseRotation(lastPosX, lastPosY, textContentItem.prevTransform);

            var _applyInverseRotation4 = _slicedToArray(_applyInverseRotation3, 2);

            lastPosX = _applyInverseRotation4[0];
            lastPosY = _applyInverseRotation4[1];
        }

        if (textState.font.vertical) {
          var _advanceY = (lastPosY - posY) / textContentItem.textAdvanceScale;

          var _advanceX = posX - lastPosX;

          var _textOrientation = Math.sign(textContentItem.height);

          if (_advanceY < _textOrientation * textContentItem.negativeSpaceMax) {
            if (Math.abs(_advanceX) > 0.5 * textContentItem.width) {
              appendEOL();
              return true;
            }

            flushTextContentItem();
            return true;
          }

          if (Math.abs(_advanceX) > textContentItem.width) {
            appendEOL();
            return true;
          }

          if (_advanceY <= _textOrientation * textContentItem.trackingSpaceMin) {
            textContentItem.height += _advanceY;
          } else if (!addFakeSpaces(_advanceY, textContentItem.prevTransform, _textOrientation)) {
            if (textContentItem.str.length === 0) {
              textContent.items.push({
                str: " ",
                dir: "ltr",
                width: 0,
                height: Math.abs(_advanceY),
                transform: textContentItem.prevTransform,
                fontName: textContentItem.fontName,
                hasEOL: false
              });
            } else {
              textContentItem.height += _advanceY;
            }
          }

          return true;
        }

        var advanceX = (posX - lastPosX) / textContentItem.textAdvanceScale;
        var advanceY = posY - lastPosY;
        var textOrientation = Math.sign(textContentItem.width);

        if (advanceX < textOrientation * textContentItem.negativeSpaceMax) {
          if (Math.abs(advanceY) > 0.5 * textContentItem.height) {
            appendEOL();
            return true;
          }

          flushTextContentItem();
          return true;
        }

        if (Math.abs(advanceY) > textContentItem.height) {
          appendEOL();
          return true;
        }

        if (advanceX <= textOrientation * textContentItem.trackingSpaceMin) {
          textContentItem.width += advanceX;
        } else if (!addFakeSpaces(advanceX, textContentItem.prevTransform, textOrientation)) {
          if (textContentItem.str.length === 0) {
            textContent.items.push({
              str: " ",
              dir: "ltr",
              width: Math.abs(advanceX),
              height: 0,
              transform: textContentItem.prevTransform,
              fontName: textContentItem.fontName,
              hasEOL: false
            });
          } else {
            textContentItem.width += advanceX;
          }
        }

        return true;
      }

      function buildTextContentItem(_ref14) {
        var chars = _ref14.chars,
            extraSpacing = _ref14.extraSpacing;
        var font = textState.font;

        if (!chars) {
          var charSpacing = textState.charSpacing + extraSpacing;

          if (charSpacing) {
            if (!font.vertical) {
              textState.translateTextMatrix(charSpacing * textState.textHScale, 0);
            } else {
              textState.translateTextMatrix(0, -charSpacing);
            }
          }

          return;
        }

        var glyphs = font.charsToGlyphs(chars);
        var scale = textState.fontMatrix[0] * textState.fontSize;

        for (var i = 0, ii = glyphs.length; i < ii; i++) {
          var glyph = glyphs[i];

          if (glyph.isInvisibleFormatMark) {
            continue;
          }

          var _charSpacing = textState.charSpacing + (i + 1 === ii ? extraSpacing : 0);

          var glyphWidth = glyph.width;

          if (font.vertical) {
            glyphWidth = glyph.vmetric ? glyph.vmetric[0] : -glyphWidth;
          }

          var scaledDim = glyphWidth * scale;

          if (glyph.isWhitespace && (i === 0 || i + 1 === ii || glyphs[i - 1].isWhitespace || glyphs[i + 1].isWhitespace || extraSpacing)) {
            if (!font.vertical) {
              _charSpacing += scaledDim + textState.wordSpacing;
              textState.translateTextMatrix(_charSpacing * textState.textHScale, 0);
            } else {
              _charSpacing += -scaledDim + textState.wordSpacing;
              textState.translateTextMatrix(0, -_charSpacing);
            }

            continue;
          }

          if (!compareWithLastPosition()) {
            continue;
          }

          var textChunk = ensureTextContentItem();

          if (glyph.isZeroWidthDiacritic) {
            scaledDim = 0;
          }

          if (!font.vertical) {
            scaledDim *= textState.textHScale;
            textState.translateTextMatrix(scaledDim, 0);
            textChunk.width += scaledDim;
          } else {
            textState.translateTextMatrix(0, scaledDim);
            scaledDim = Math.abs(scaledDim);
            textChunk.height += scaledDim;
          }

          if (scaledDim) {
            textChunk.prevTransform = getCurrentTextTransform();
          }

          if (glyph.isWhitespace) {
            textChunk.str.push(" ");
          } else {
            var glyphUnicode = glyph.unicode;
            glyphUnicode = NormalizedUnicodes[glyphUnicode] || glyphUnicode;
            glyphUnicode = (0, _unicode.reverseIfRtl)(glyphUnicode);
            textChunk.str.push(glyphUnicode);
          }

          if (_charSpacing) {
            if (!font.vertical) {
              textState.translateTextMatrix(_charSpacing * textState.textHScale, 0);
            } else {
              textState.translateTextMatrix(0, -_charSpacing);
            }
          }
        }
      }

      function appendEOL() {
        if (textContentItem.initialized) {
          textContentItem.hasEOL = true;
          flushTextContentItem();
        } else {
          textContent.items.push({
            str: "",
            dir: "ltr",
            width: 0,
            height: 0,
            transform: getCurrentTextTransform(),
            fontName: textState.font.loadedName,
            hasEOL: true
          });
        }
      }

      function addFakeSpaces(width, transf, textOrientation) {
        if (textOrientation * textContentItem.spaceInFlowMin <= width && width <= textOrientation * textContentItem.spaceInFlowMax) {
          if (textContentItem.initialized) {
            textContentItem.str.push(" ");
          }

          return false;
        }

        var fontName = textContentItem.fontName;
        var height = 0;

        if (textContentItem.vertical) {
          height = width;
          width = 0;
        }

        flushTextContentItem();
        textContent.items.push({
          str: " ",
          dir: "ltr",
          width: Math.abs(width),
          height: Math.abs(height),
          transform: transf || getCurrentTextTransform(),
          fontName: fontName,
          hasEOL: false
        });
        return true;
      }

      function flushTextContentItem() {
        if (!textContentItem.initialized || !textContentItem.str) {
          return;
        }

        if (!textContentItem.vertical) {
          textContentItem.totalWidth += textContentItem.width * textContentItem.textAdvanceScale;
        } else {
          textContentItem.totalHeight += textContentItem.height * textContentItem.textAdvanceScale;
        }

        textContent.items.push(runBidiTransform(textContentItem));
        textContentItem.initialized = false;
        textContentItem.str.length = 0;
      }

      function enqueueChunk() {
        var batch = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
        var length = textContent.items.length;

        if (length === 0) {
          return;
        }

        if (batch && length < TEXT_CHUNK_BATCH_SIZE) {
          return;
        }

        sink.enqueue(textContent, length);
        textContent.items = [];
        textContent.styles = Object.create(null);
      }

      var timeSlotManager = new TimeSlotManager();
      return new Promise(function promiseBody(resolve, reject) {
        var next = function next(promise) {
          enqueueChunk(true);
          Promise.all([promise, sink.ready]).then(function () {
            try {
              promiseBody(resolve, reject);
            } catch (ex) {
              reject(ex);
            }
          }, reject);
        };

        task.ensureNotTerminated();
        timeSlotManager.reset();
        var operation = {};
        var stop,
            args = [];

        while (!(stop = timeSlotManager.check())) {
          args.length = 0;
          operation.args = args;

          if (!preprocessor.read(operation)) {
            break;
          }

          textState = stateManager.state;
          var fn = operation.fn;
          args = operation.args;

          switch (fn | 0) {
            case _util.OPS.setFont:
              var fontNameArg = args[0].name,
                  fontSizeArg = args[1];

              if (textState.font && fontNameArg === textState.fontName && fontSizeArg === textState.fontSize) {
                break;
              }

              flushTextContentItem();
              textState.fontName = fontNameArg;
              textState.fontSize = fontSizeArg;
              next(handleSetFont(fontNameArg, null));
              return;

            case _util.OPS.setTextRise:
              textState.textRise = args[0];
              break;

            case _util.OPS.setHScale:
              textState.textHScale = args[0] / 100;
              break;

            case _util.OPS.setLeading:
              textState.leading = args[0];
              break;

            case _util.OPS.moveText:
              textState.translateTextLineMatrix(args[0], args[1]);
              textState.textMatrix = textState.textLineMatrix.slice();
              break;

            case _util.OPS.setLeadingMoveText:
              textState.leading = -args[1];
              textState.translateTextLineMatrix(args[0], args[1]);
              textState.textMatrix = textState.textLineMatrix.slice();
              break;

            case _util.OPS.nextLine:
              textState.carriageReturn();
              break;

            case _util.OPS.setTextMatrix:
              textState.setTextMatrix(args[0], args[1], args[2], args[3], args[4], args[5]);
              textState.setTextLineMatrix(args[0], args[1], args[2], args[3], args[4], args[5]);
              updateAdvanceScale();
              break;

            case _util.OPS.setCharSpacing:
              textState.charSpacing = args[0];
              break;

            case _util.OPS.setWordSpacing:
              textState.wordSpacing = args[0];
              break;

            case _util.OPS.beginText:
              textState.textMatrix = _util.IDENTITY_MATRIX.slice();
              textState.textLineMatrix = _util.IDENTITY_MATRIX.slice();
              break;

            case _util.OPS.showSpacedText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              var spaceFactor = (textState.font.vertical ? 1 : -1) * textState.fontSize / 1000;
              var elements = args[0];

              for (var i = 0, ii = elements.length; i < ii - 1; i++) {
                var _item = elements[i];

                if (typeof _item === "string") {
                  showSpacedTextBuffer.push(_item);
                } else if (typeof _item === "number" && _item !== 0) {
                  var str = showSpacedTextBuffer.join("");
                  showSpacedTextBuffer.length = 0;
                  buildTextContentItem({
                    chars: str,
                    extraSpacing: _item * spaceFactor
                  });
                }
              }

              var item = elements[elements.length - 1];

              if (typeof item === "string") {
                showSpacedTextBuffer.push(item);
              }

              if (showSpacedTextBuffer.length > 0) {
                var _str = showSpacedTextBuffer.join("");

                showSpacedTextBuffer.length = 0;
                buildTextContentItem({
                  chars: _str,
                  extraSpacing: 0
                });
              }

              break;

            case _util.OPS.showText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              buildTextContentItem({
                chars: args[0],
                extraSpacing: 0
              });
              break;

            case _util.OPS.nextLineShowText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              textState.carriageReturn();
              buildTextContentItem({
                chars: args[0],
                extraSpacing: 0
              });
              break;

            case _util.OPS.nextLineSetSpacingShowText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              textState.wordSpacing = args[0];
              textState.charSpacing = args[1];
              textState.carriageReturn();
              buildTextContentItem({
                chars: args[2],
                extraSpacing: 0
              });
              break;

            case _util.OPS.paintXObject:
              flushTextContentItem();

              if (!xobjs) {
                xobjs = resources.get("XObject") || _primitives.Dict.empty;
              }

              var isValidName = args[0] instanceof _primitives.Name;
              var name = args[0].name;

              if (isValidName && emptyXObjectCache.getByName(name)) {
                break;
              }

              next(new Promise(function (resolveXObject, rejectXObject) {
                if (!isValidName) {
                  throw new _util.FormatError("XObject must be referred to by name.");
                }

                var xobj = xobjs.getRaw(name);

                if (xobj instanceof _primitives.Ref) {
                  if (emptyXObjectCache.getByRef(xobj)) {
                    resolveXObject();
                    return;
                  }

                  var globalImage = self.globalImageCache.getData(xobj, self.pageIndex);

                  if (globalImage) {
                    resolveXObject();
                    return;
                  }

                  xobj = xref.fetch(xobj);
                }

                if (!(xobj instanceof _base_stream.BaseStream)) {
                  throw new _util.FormatError("XObject should be a stream");
                }

                var type = xobj.dict.get("Subtype");

                if (!(type instanceof _primitives.Name)) {
                  throw new _util.FormatError("XObject should have a Name subtype");
                }

                if (type.name !== "Form") {
                  emptyXObjectCache.set(name, xobj.dict.objId, true);
                  resolveXObject();
                  return;
                }

                var currentState = stateManager.state.clone();
                var xObjStateManager = new StateManager(currentState);
                var matrix = xobj.dict.getArray("Matrix");

                if (Array.isArray(matrix) && matrix.length === 6) {
                  xObjStateManager.transform(matrix);
                }

                enqueueChunk();
                var sinkWrapper = {
                  enqueueInvoked: false,
                  enqueue: function enqueue(chunk, size) {
                    this.enqueueInvoked = true;
                    sink.enqueue(chunk, size);
                  },

                  get desiredSize() {
                    return sink.desiredSize;
                  },

                  get ready() {
                    return sink.ready;
                  }

                };
                self.getTextContent({
                  stream: xobj,
                  task: task,
                  resources: xobj.dict.get("Resources") || resources,
                  stateManager: xObjStateManager,
                  combineTextItems: combineTextItems,
                  includeMarkedContent: includeMarkedContent,
                  sink: sinkWrapper,
                  seenStyles: seenStyles,
                  viewBox: viewBox
                }).then(function () {
                  if (!sinkWrapper.enqueueInvoked) {
                    emptyXObjectCache.set(name, xobj.dict.objId, true);
                  }

                  resolveXObject();
                }, rejectXObject);
              })["catch"](function (reason) {
                if (reason instanceof _util.AbortException) {
                  return;
                }

                if (self.options.ignoreErrors) {
                  (0, _util.warn)("getTextContent - ignoring XObject: \"".concat(reason, "\"."));
                  return;
                }

                throw reason;
              }));
              return;

            case _util.OPS.setGState:
              isValidName = args[0] instanceof _primitives.Name;
              name = args[0].name;

              if (isValidName && emptyGStateCache.getByName(name)) {
                break;
              }

              next(new Promise(function (resolveGState, rejectGState) {
                if (!isValidName) {
                  throw new _util.FormatError("GState must be referred to by name.");
                }

                var extGState = resources.get("ExtGState");

                if (!(extGState instanceof _primitives.Dict)) {
                  throw new _util.FormatError("ExtGState should be a dictionary.");
                }

                var gState = extGState.get(name);

                if (!(gState instanceof _primitives.Dict)) {
                  throw new _util.FormatError("GState should be a dictionary.");
                }

                var gStateFont = gState.get("Font");

                if (!gStateFont) {
                  emptyGStateCache.set(name, gState.objId, true);
                  resolveGState();
                  return;
                }

                flushTextContentItem();
                textState.fontName = null;
                textState.fontSize = gStateFont[1];
                handleSetFont(null, gStateFont[0]).then(resolveGState, rejectGState);
              })["catch"](function (reason) {
                if (reason instanceof _util.AbortException) {
                  return;
                }

                if (self.options.ignoreErrors) {
                  (0, _util.warn)("getTextContent - ignoring ExtGState: \"".concat(reason, "\"."));
                  return;
                }

                throw reason;
              }));
              return;

            case _util.OPS.beginMarkedContent:
              if (includeMarkedContent) {
                textContent.items.push({
                  type: "beginMarkedContent",
                  tag: args[0] instanceof _primitives.Name ? args[0].name : null
                });
              }

              break;

            case _util.OPS.beginMarkedContentProps:
              if (includeMarkedContent) {
                flushTextContentItem();
                var mcid = null;

                if (args[1] instanceof _primitives.Dict) {
                  mcid = args[1].get("MCID");
                }

                textContent.items.push({
                  type: "beginMarkedContentProps",
                  id: Number.isInteger(mcid) ? "".concat(self.idFactory.getPageObjId(), "_mcid").concat(mcid) : null,
                  tag: args[0] instanceof _primitives.Name ? args[0].name : null
                });
              }

              break;

            case _util.OPS.endMarkedContent:
              if (includeMarkedContent) {
                flushTextContentItem();
                textContent.items.push({
                  type: "endMarkedContent"
                });
              }

              break;
          }

          if (textContent.items.length >= sink.desiredSize) {
            stop = true;
            break;
          }
        }

        if (stop) {
          next(deferred);
          return;
        }

        flushTextContentItem();
        enqueueChunk();
        resolve();
      })["catch"](function (reason) {
        if (reason instanceof _util.AbortException) {
          return;
        }

        if (_this8.options.ignoreErrors) {
          (0, _util.warn)("getTextContent - ignoring errors during \"".concat(task.name, "\" ") + "task: \"".concat(reason, "\"."));
          flushTextContentItem();
          enqueueChunk();
          return;
        }

        throw reason;
      });
    }
  }, {
    key: "extractDataStructures",
    value: function extractDataStructures(dict, baseDict, properties) {
      var _this9 = this;

      var xref = this.xref;
      var cidToGidBytes;
      var toUnicodePromise = this.readToUnicode(properties.toUnicode || dict.get("ToUnicode") || baseDict.get("ToUnicode"));

      if (properties.composite) {
        var cidSystemInfo = dict.get("CIDSystemInfo");

        if (cidSystemInfo instanceof _primitives.Dict) {
          properties.cidSystemInfo = {
            registry: (0, _util.stringToPDFString)(cidSystemInfo.get("Registry")),
            ordering: (0, _util.stringToPDFString)(cidSystemInfo.get("Ordering")),
            supplement: cidSystemInfo.get("Supplement")
          };
        }

        var cidToGidMap = dict.get("CIDToGIDMap");

        if (cidToGidMap instanceof _base_stream.BaseStream) {
          cidToGidBytes = cidToGidMap.getBytes();
        }
      }

      var differences = [];
      var baseEncodingName = null;
      var encoding;

      if (dict.has("Encoding")) {
        encoding = dict.get("Encoding");

        if (encoding instanceof _primitives.Dict) {
          baseEncodingName = encoding.get("BaseEncoding");
          baseEncodingName = baseEncodingName instanceof _primitives.Name ? baseEncodingName.name : null;

          if (encoding.has("Differences")) {
            var diffEncoding = encoding.get("Differences");
            var index = 0;

            for (var j = 0, jj = diffEncoding.length; j < jj; j++) {
              var data = xref.fetchIfRef(diffEncoding[j]);

              if (typeof data === "number") {
                index = data;
              } else if (data instanceof _primitives.Name) {
                differences[index++] = data.name;
              } else {
                throw new _util.FormatError("Invalid entry in 'Differences' array: ".concat(data));
              }
            }
          }
        } else if (encoding instanceof _primitives.Name) {
          baseEncodingName = encoding.name;
        } else {
          throw new _util.FormatError("Encoding is not a Name nor a Dict");
        }

        if (baseEncodingName !== "MacRomanEncoding" && baseEncodingName !== "MacExpertEncoding" && baseEncodingName !== "WinAnsiEncoding") {
          baseEncodingName = null;
        }
      }

      if (baseEncodingName) {
        properties.defaultEncoding = (0, _encodings.getEncoding)(baseEncodingName);
      } else {
        var isSymbolicFont = !!(properties.flags & _fonts_utils.FontFlags.Symbolic);
        var isNonsymbolicFont = !!(properties.flags & _fonts_utils.FontFlags.Nonsymbolic);
        encoding = _encodings.StandardEncoding;

        if (properties.type === "TrueType" && !isNonsymbolicFont) {
          encoding = _encodings.WinAnsiEncoding;
        }

        if (isSymbolicFont) {
          encoding = _encodings.MacRomanEncoding;

          if (!properties.file || properties.isInternalFont) {
            if (/Symbol/i.test(properties.name)) {
              encoding = _encodings.SymbolSetEncoding;
            } else if (/Dingbats|Wingdings/i.test(properties.name)) {
              encoding = _encodings.ZapfDingbatsEncoding;
            }
          }
        }

        properties.defaultEncoding = encoding;
      }

      properties.differences = differences;
      properties.baseEncodingName = baseEncodingName;
      properties.hasEncoding = !!baseEncodingName || differences.length > 0;
      properties.dict = dict;
      return toUnicodePromise.then(function (readToUnicode) {
        properties.toUnicode = readToUnicode;
        return _this9.buildToUnicode(properties);
      }).then(function (builtToUnicode) {
        properties.toUnicode = builtToUnicode;

        if (cidToGidBytes) {
          properties.cidToGidMap = _this9.readCidToGidMap(cidToGidBytes, builtToUnicode);
        }

        return properties;
      });
    }
  }, {
    key: "_simpleFontToUnicode",
    value: function _simpleFontToUnicode(properties) {
      var forceGlyphs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      (0, _util.assert)(!properties.composite, "Must be a simple font.");
      var toUnicode = [];
      var encoding = properties.defaultEncoding.slice();
      var baseEncodingName = properties.baseEncodingName;
      var differences = properties.differences;

      for (var charcode in differences) {
        var glyphName = differences[charcode];

        if (glyphName === ".notdef") {
          continue;
        }

        encoding[charcode] = glyphName;
      }

      var glyphsUnicodeMap = (0, _glyphlist.getGlyphsUnicode)();

      for (var _charcode in encoding) {
        var _glyphName = encoding[_charcode];

        if (_glyphName === "") {
          continue;
        } else if (glyphsUnicodeMap[_glyphName] === undefined) {
          var code = 0;

          switch (_glyphName[0]) {
            case "G":
              if (_glyphName.length === 3) {
                code = parseInt(_glyphName.substring(1), 16);
              }

              break;

            case "g":
              if (_glyphName.length === 5) {
                code = parseInt(_glyphName.substring(1), 16);
              }

              break;

            case "C":
            case "c":
              if (_glyphName.length >= 3 && _glyphName.length <= 4) {
                var codeStr = _glyphName.substring(1);

                if (forceGlyphs) {
                  code = parseInt(codeStr, 16);
                  break;
                }

                code = +codeStr;

                if (Number.isNaN(code) && Number.isInteger(parseInt(codeStr, 16))) {
                  return this._simpleFontToUnicode(properties, true);
                }
              }

              break;

            default:
              var unicode = (0, _unicode.getUnicodeForGlyph)(_glyphName, glyphsUnicodeMap);

              if (unicode !== -1) {
                code = unicode;
              }

          }

          if (code > 0 && code <= 0x10ffff && Number.isInteger(code)) {
            if (baseEncodingName && code === +_charcode) {
              var baseEncoding = (0, _encodings.getEncoding)(baseEncodingName);

              if (baseEncoding && (_glyphName = baseEncoding[_charcode])) {
                toUnicode[_charcode] = String.fromCharCode(glyphsUnicodeMap[_glyphName]);
                continue;
              }
            }

            toUnicode[_charcode] = String.fromCodePoint(code);
          }

          continue;
        }

        toUnicode[_charcode] = String.fromCharCode(glyphsUnicodeMap[_glyphName]);
      }

      return toUnicode;
    }
  }, {
    key: "buildToUnicode",
    value: function () {
      var _buildToUnicode = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee8(properties) {
        var _properties$cidSystem, registry, ordering, ucs2CMapName, ucs2CMap, toUnicode;

        return _regenerator["default"].wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                properties.hasIncludedToUnicodeMap = !!properties.toUnicode && properties.toUnicode.length > 0;

                if (!properties.hasIncludedToUnicodeMap) {
                  _context8.next = 4;
                  break;
                }

                if (!properties.composite && properties.hasEncoding) {
                  properties.fallbackToUnicode = this._simpleFontToUnicode(properties);
                }

                return _context8.abrupt("return", properties.toUnicode);

              case 4:
                if (properties.composite) {
                  _context8.next = 6;
                  break;
                }

                return _context8.abrupt("return", new _to_unicode_map.ToUnicodeMap(this._simpleFontToUnicode(properties)));

              case 6:
                if (!(properties.composite && (properties.cMap.builtInCMap && !(properties.cMap instanceof _cmap.IdentityCMap) || properties.cidSystemInfo.registry === "Adobe" && (properties.cidSystemInfo.ordering === "GB1" || properties.cidSystemInfo.ordering === "CNS1" || properties.cidSystemInfo.ordering === "Japan1" || properties.cidSystemInfo.ordering === "Korea1")))) {
                  _context8.next = 15;
                  break;
                }

                _properties$cidSystem = properties.cidSystemInfo, registry = _properties$cidSystem.registry, ordering = _properties$cidSystem.ordering;
                ucs2CMapName = _primitives.Name.get("".concat(registry, "-").concat(ordering, "-UCS2"));
                _context8.next = 11;
                return _cmap.CMapFactory.create({
                  encoding: ucs2CMapName,
                  fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                  useCMap: null
                });

              case 11:
                ucs2CMap = _context8.sent;
                toUnicode = [];
                properties.cMap.forEach(function (charcode, cid) {
                  if (cid > 0xffff) {
                    throw new _util.FormatError("Max size of CID is 65,535");
                  }

                  var ucs2 = ucs2CMap.lookup(cid);

                  if (ucs2) {
                    toUnicode[charcode] = String.fromCharCode((ucs2.charCodeAt(0) << 8) + ucs2.charCodeAt(1));
                  }
                });
                return _context8.abrupt("return", new _to_unicode_map.ToUnicodeMap(toUnicode));

              case 15:
                return _context8.abrupt("return", new _to_unicode_map.IdentityToUnicodeMap(properties.firstChar, properties.lastChar));

              case 16:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, this);
      }));

      function buildToUnicode(_x14) {
        return _buildToUnicode.apply(this, arguments);
      }

      return buildToUnicode;
    }()
  }, {
    key: "readToUnicode",
    value: function readToUnicode(cmapObj) {
      var _this10 = this;

      if (!cmapObj) {
        return Promise.resolve(null);
      }

      if (cmapObj instanceof _primitives.Name) {
        return _cmap.CMapFactory.create({
          encoding: cmapObj,
          fetchBuiltInCMap: this._fetchBuiltInCMapBound,
          useCMap: null
        }).then(function (cmap) {
          if (cmap instanceof _cmap.IdentityCMap) {
            return new _to_unicode_map.IdentityToUnicodeMap(0, 0xffff);
          }

          return new _to_unicode_map.ToUnicodeMap(cmap.getMap());
        });
      } else if (cmapObj instanceof _base_stream.BaseStream) {
        return _cmap.CMapFactory.create({
          encoding: cmapObj,
          fetchBuiltInCMap: this._fetchBuiltInCMapBound,
          useCMap: null
        }).then(function (cmap) {
          if (cmap instanceof _cmap.IdentityCMap) {
            return new _to_unicode_map.IdentityToUnicodeMap(0, 0xffff);
          }

          var map = new Array(cmap.length);
          cmap.forEach(function (charCode, token) {
            if (typeof token === "number") {
              map[charCode] = String.fromCodePoint(token);
              return;
            }

            var str = [];

            for (var k = 0; k < token.length; k += 2) {
              var w1 = token.charCodeAt(k) << 8 | token.charCodeAt(k + 1);

              if ((w1 & 0xf800) !== 0xd800) {
                str.push(w1);
                continue;
              }

              k += 2;
              var w2 = token.charCodeAt(k) << 8 | token.charCodeAt(k + 1);
              str.push(((w1 & 0x3ff) << 10) + (w2 & 0x3ff) + 0x10000);
            }

            map[charCode] = String.fromCodePoint.apply(String, str);
          });
          return new _to_unicode_map.ToUnicodeMap(map);
        }, function (reason) {
          if (reason instanceof _util.AbortException) {
            return null;
          }

          if (_this10.options.ignoreErrors) {
            _this10.handler.send("UnsupportedFeature", {
              featureId: _util.UNSUPPORTED_FEATURES.errorFontToUnicode
            });

            (0, _util.warn)("readToUnicode - ignoring ToUnicode data: \"".concat(reason, "\"."));
            return null;
          }

          throw reason;
        });
      }

      return Promise.resolve(null);
    }
  }, {
    key: "readCidToGidMap",
    value: function readCidToGidMap(glyphsData, toUnicode) {
      var result = [];

      for (var j = 0, jj = glyphsData.length; j < jj; j++) {
        var glyphID = glyphsData[j++] << 8 | glyphsData[j];
        var code = j >> 1;

        if (glyphID === 0 && !toUnicode.has(code)) {
          continue;
        }

        result[code] = glyphID;
      }

      return result;
    }
  }, {
    key: "extractWidths",
    value: function extractWidths(dict, descriptor, properties) {
      var xref = this.xref;
      var glyphsWidths = [];
      var defaultWidth = 0;
      var glyphsVMetrics = [];
      var defaultVMetrics;
      var i, ii, j, jj, start, code, widths;

      if (properties.composite) {
        defaultWidth = dict.has("DW") ? dict.get("DW") : 1000;
        widths = dict.get("W");

        if (widths) {
          for (i = 0, ii = widths.length; i < ii; i++) {
            start = xref.fetchIfRef(widths[i++]);
            code = xref.fetchIfRef(widths[i]);

            if (Array.isArray(code)) {
              for (j = 0, jj = code.length; j < jj; j++) {
                glyphsWidths[start++] = xref.fetchIfRef(code[j]);
              }
            } else {
              var width = xref.fetchIfRef(widths[++i]);

              for (j = start; j <= code; j++) {
                glyphsWidths[j] = width;
              }
            }
          }
        }

        if (properties.vertical) {
          var vmetrics = dict.getArray("DW2") || [880, -1000];
          defaultVMetrics = [vmetrics[1], defaultWidth * 0.5, vmetrics[0]];
          vmetrics = dict.get("W2");

          if (vmetrics) {
            for (i = 0, ii = vmetrics.length; i < ii; i++) {
              start = xref.fetchIfRef(vmetrics[i++]);
              code = xref.fetchIfRef(vmetrics[i]);

              if (Array.isArray(code)) {
                for (j = 0, jj = code.length; j < jj; j++) {
                  glyphsVMetrics[start++] = [xref.fetchIfRef(code[j++]), xref.fetchIfRef(code[j++]), xref.fetchIfRef(code[j])];
                }
              } else {
                var vmetric = [xref.fetchIfRef(vmetrics[++i]), xref.fetchIfRef(vmetrics[++i]), xref.fetchIfRef(vmetrics[++i])];

                for (j = start; j <= code; j++) {
                  glyphsVMetrics[j] = vmetric;
                }
              }
            }
          }
        }
      } else {
        var firstChar = properties.firstChar;
        widths = dict.get("Widths");

        if (widths) {
          j = firstChar;

          for (i = 0, ii = widths.length; i < ii; i++) {
            glyphsWidths[j++] = xref.fetchIfRef(widths[i]);
          }

          defaultWidth = parseFloat(descriptor.get("MissingWidth")) || 0;
        } else {
          var baseFontName = dict.get("BaseFont");

          if (baseFontName instanceof _primitives.Name) {
            var metrics = this.getBaseFontMetrics(baseFontName.name);
            glyphsWidths = this.buildCharCodeToWidth(metrics.widths, properties);
            defaultWidth = metrics.defaultWidth;
          }
        }
      }

      var isMonospace = true;
      var firstWidth = defaultWidth;

      for (var glyph in glyphsWidths) {
        var glyphWidth = glyphsWidths[glyph];

        if (!glyphWidth) {
          continue;
        }

        if (!firstWidth) {
          firstWidth = glyphWidth;
          continue;
        }

        if (firstWidth !== glyphWidth) {
          isMonospace = false;
          break;
        }
      }

      if (isMonospace) {
        properties.flags |= _fonts_utils.FontFlags.FixedPitch;
      }

      properties.defaultWidth = defaultWidth;
      properties.widths = glyphsWidths;
      properties.defaultVMetrics = defaultVMetrics;
      properties.vmetrics = glyphsVMetrics;
    }
  }, {
    key: "isSerifFont",
    value: function isSerifFont(baseFontName) {
      var fontNameWoStyle = baseFontName.split("-")[0];
      return fontNameWoStyle in (0, _standard_fonts.getSerifFonts)() || fontNameWoStyle.search(/serif/gi) !== -1;
    }
  }, {
    key: "getBaseFontMetrics",
    value: function getBaseFontMetrics(name) {
      var defaultWidth = 0;
      var widths = Object.create(null);
      var monospace = false;
      var stdFontMap = (0, _standard_fonts.getStdFontMap)();
      var lookupName = stdFontMap[name] || name;
      var Metrics = (0, _metrics.getMetrics)();

      if (!(lookupName in Metrics)) {
        if (this.isSerifFont(name)) {
          lookupName = "Times-Roman";
        } else {
          lookupName = "Helvetica";
        }
      }

      var glyphWidths = Metrics[lookupName];

      if (typeof glyphWidths === "number") {
        defaultWidth = glyphWidths;
        monospace = true;
      } else {
        widths = glyphWidths();
      }

      return {
        defaultWidth: defaultWidth,
        monospace: monospace,
        widths: widths
      };
    }
  }, {
    key: "buildCharCodeToWidth",
    value: function buildCharCodeToWidth(widthsByGlyphName, properties) {
      var widths = Object.create(null);
      var differences = properties.differences;
      var encoding = properties.defaultEncoding;

      for (var charCode = 0; charCode < 256; charCode++) {
        if (charCode in differences && widthsByGlyphName[differences[charCode]]) {
          widths[charCode] = widthsByGlyphName[differences[charCode]];
          continue;
        }

        if (charCode in encoding && widthsByGlyphName[encoding[charCode]]) {
          widths[charCode] = widthsByGlyphName[encoding[charCode]];
          continue;
        }
      }

      return widths;
    }
  }, {
    key: "preEvaluateFont",
    value: function preEvaluateFont(dict) {
      var baseDict = dict;
      var type = dict.get("Subtype");

      if (!(type instanceof _primitives.Name)) {
        throw new _util.FormatError("invalid font Subtype");
      }

      var composite = false;
      var hash, toUnicode;

      if (type.name === "Type0") {
        var df = dict.get("DescendantFonts");

        if (!df) {
          throw new _util.FormatError("Descendant fonts are not specified");
        }

        dict = Array.isArray(df) ? this.xref.fetchIfRef(df[0]) : df;

        if (!(dict instanceof _primitives.Dict)) {
          throw new _util.FormatError("Descendant font is not a dictionary.");
        }

        type = dict.get("Subtype");

        if (!(type instanceof _primitives.Name)) {
          throw new _util.FormatError("invalid font Subtype");
        }

        composite = true;
      }

      var firstChar = dict.get("FirstChar") || 0,
          lastChar = dict.get("LastChar") || (composite ? 0xffff : 0xff);
      var descriptor = dict.get("FontDescriptor");

      if (descriptor) {
        hash = new _murmurhash.MurmurHash3_64();
        var encoding = baseDict.getRaw("Encoding");

        if (encoding instanceof _primitives.Name) {
          hash.update(encoding.name);
        } else if (encoding instanceof _primitives.Ref) {
          hash.update(encoding.toString());
        } else if (encoding instanceof _primitives.Dict) {
          var _iterator6 = _createForOfIteratorHelper(encoding.getRawValues()),
              _step6;

          try {
            for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
              var entry = _step6.value;

              if (entry instanceof _primitives.Name) {
                hash.update(entry.name);
              } else if (entry instanceof _primitives.Ref) {
                hash.update(entry.toString());
              } else if (Array.isArray(entry)) {
                var diffLength = entry.length,
                    diffBuf = new Array(diffLength);

                for (var j = 0; j < diffLength; j++) {
                  var diffEntry = entry[j];

                  if (diffEntry instanceof _primitives.Name) {
                    diffBuf[j] = diffEntry.name;
                  } else if (typeof diffEntry === "number" || diffEntry instanceof _primitives.Ref) {
                    diffBuf[j] = diffEntry.toString();
                  }
                }

                hash.update(diffBuf.join());
              }
            }
          } catch (err) {
            _iterator6.e(err);
          } finally {
            _iterator6.f();
          }
        }

        hash.update("".concat(firstChar, "-").concat(lastChar));
        toUnicode = dict.get("ToUnicode") || baseDict.get("ToUnicode");

        if (toUnicode instanceof _base_stream.BaseStream) {
          var stream = toUnicode.str || toUnicode;
          var uint8array = stream.buffer ? new Uint8Array(stream.buffer.buffer, 0, stream.bufferLength) : new Uint8Array(stream.bytes.buffer, stream.start, stream.end - stream.start);
          hash.update(uint8array);
        } else if (toUnicode instanceof _primitives.Name) {
          hash.update(toUnicode.name);
        }

        var widths = dict.get("Widths") || baseDict.get("Widths");

        if (Array.isArray(widths)) {
          var widthsBuf = [];

          var _iterator7 = _createForOfIteratorHelper(widths),
              _step7;

          try {
            for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
              var _entry = _step7.value;

              if (typeof _entry === "number" || _entry instanceof _primitives.Ref) {
                widthsBuf.push(_entry.toString());
              }
            }
          } catch (err) {
            _iterator7.e(err);
          } finally {
            _iterator7.f();
          }

          hash.update(widthsBuf.join());
        }

        if (composite) {
          hash.update("compositeFont");
          var compositeWidths = dict.get("W") || baseDict.get("W");

          if (Array.isArray(compositeWidths)) {
            var _widthsBuf = [];

            var _iterator8 = _createForOfIteratorHelper(compositeWidths),
                _step8;

            try {
              for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
                var _entry2 = _step8.value;

                if (typeof _entry2 === "number" || _entry2 instanceof _primitives.Ref) {
                  _widthsBuf.push(_entry2.toString());
                } else if (Array.isArray(_entry2)) {
                  var subWidthsBuf = [];

                  var _iterator9 = _createForOfIteratorHelper(_entry2),
                      _step9;

                  try {
                    for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
                      var element = _step9.value;

                      if (typeof element === "number" || element instanceof _primitives.Ref) {
                        subWidthsBuf.push(element.toString());
                      }
                    }
                  } catch (err) {
                    _iterator9.e(err);
                  } finally {
                    _iterator9.f();
                  }

                  _widthsBuf.push("[".concat(subWidthsBuf.join(), "]"));
                }
              }
            } catch (err) {
              _iterator8.e(err);
            } finally {
              _iterator8.f();
            }

            hash.update(_widthsBuf.join());
          }

          var cidToGidMap = dict.getRaw("CIDToGIDMap") || baseDict.getRaw("CIDToGIDMap");

          if (cidToGidMap instanceof _primitives.Name) {
            hash.update(cidToGidMap.name);
          } else if (cidToGidMap instanceof _primitives.Ref) {
            hash.update(cidToGidMap.toString());
          } else if (cidToGidMap instanceof _base_stream.BaseStream) {
            hash.update(cidToGidMap.peekBytes());
          }
        }
      }

      return {
        descriptor: descriptor,
        dict: dict,
        baseDict: baseDict,
        composite: composite,
        type: type.name,
        firstChar: firstChar,
        lastChar: lastChar,
        toUnicode: toUnicode,
        hash: hash ? hash.hexdigest() : ""
      };
    }
  }, {
    key: "translateFont",
    value: function () {
      var _translateFont = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee9(_ref15) {
        var _this11 = this;

        var descriptor, dict, baseDict, composite, type, firstChar, lastChar, toUnicode, cssFontInfo, isType3Font, properties, baseFontName, metrics, fontNameWoStyle, flags, widths, standardFontName, file, fontName, baseFont, fontNameStr, baseFontStr, fontFile, subtype, length1, length2, length3, isStandardFont, isInternalFont, glyphScaleFactors, subtypeEntry, _standardFontName, _standardFontName2, cidEncoding, cMap;

        return _regenerator["default"].wrap(function _callee9$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                descriptor = _ref15.descriptor, dict = _ref15.dict, baseDict = _ref15.baseDict, composite = _ref15.composite, type = _ref15.type, firstChar = _ref15.firstChar, lastChar = _ref15.lastChar, toUnicode = _ref15.toUnicode, cssFontInfo = _ref15.cssFontInfo;
                isType3Font = type === "Type3";

                if (descriptor) {
                  _context9.next = 27;
                  break;
                }

                if (!isType3Font) {
                  _context9.next = 9;
                  break;
                }

                descriptor = new _primitives.Dict(null);
                descriptor.set("FontName", _primitives.Name.get(type));
                descriptor.set("FontBBox", dict.getArray("FontBBox") || [0, 0, 0, 0]);
                _context9.next = 27;
                break;

              case 9:
                baseFontName = dict.get("BaseFont");

                if (baseFontName instanceof _primitives.Name) {
                  _context9.next = 12;
                  break;
                }

                throw new _util.FormatError("Base font is not specified");

              case 12:
                baseFontName = baseFontName.name.replace(/[,_]/g, "-");
                metrics = this.getBaseFontMetrics(baseFontName);
                fontNameWoStyle = baseFontName.split("-")[0];
                flags = (this.isSerifFont(fontNameWoStyle) ? _fonts_utils.FontFlags.Serif : 0) | (metrics.monospace ? _fonts_utils.FontFlags.FixedPitch : 0) | ((0, _standard_fonts.getSymbolsFonts)()[fontNameWoStyle] ? _fonts_utils.FontFlags.Symbolic : _fonts_utils.FontFlags.Nonsymbolic);
                properties = {
                  type: type,
                  name: baseFontName,
                  loadedName: baseDict.loadedName,
                  widths: metrics.widths,
                  defaultWidth: metrics.defaultWidth,
                  isSimulatedFlags: true,
                  flags: flags,
                  firstChar: firstChar,
                  lastChar: lastChar,
                  toUnicode: toUnicode,
                  xHeight: 0,
                  capHeight: 0,
                  italicAngle: 0,
                  isType3Font: isType3Font
                };
                widths = dict.get("Widths");
                standardFontName = (0, _standard_fonts.getStandardFontName)(baseFontName);
                file = null;

                if (!standardFontName) {
                  _context9.next = 26;
                  break;
                }

                properties.isStandardFont = true;
                _context9.next = 24;
                return this.fetchStandardFontData(standardFontName);

              case 24:
                file = _context9.sent;
                properties.isInternalFont = !!file;

              case 26:
                return _context9.abrupt("return", this.extractDataStructures(dict, dict, properties).then(function (newProperties) {
                  if (widths) {
                    var glyphWidths = [];
                    var j = firstChar;

                    for (var i = 0, ii = widths.length; i < ii; i++) {
                      glyphWidths[j++] = _this11.xref.fetchIfRef(widths[i]);
                    }

                    newProperties.widths = glyphWidths;
                  } else {
                    newProperties.widths = _this11.buildCharCodeToWidth(metrics.widths, newProperties);
                  }

                  return new _fonts.Font(baseFontName, file, newProperties);
                }));

              case 27:
                fontName = descriptor.get("FontName");
                baseFont = dict.get("BaseFont");

                if (typeof fontName === "string") {
                  fontName = _primitives.Name.get(fontName);
                }

                if (typeof baseFont === "string") {
                  baseFont = _primitives.Name.get(baseFont);
                }

                if (!isType3Font) {
                  fontNameStr = fontName && fontName.name;
                  baseFontStr = baseFont && baseFont.name;

                  if (fontNameStr !== baseFontStr) {
                    (0, _util.info)("The FontDescriptor's FontName is \"".concat(fontNameStr, "\" but ") + "should be the same as the Font's BaseFont \"".concat(baseFontStr, "\"."));

                    if (fontNameStr && baseFontStr && baseFontStr.startsWith(fontNameStr)) {
                      fontName = baseFont;
                    }
                  }
                }

                fontName = fontName || baseFont;

                if (fontName instanceof _primitives.Name) {
                  _context9.next = 35;
                  break;
                }

                throw new _util.FormatError("invalid font name");

              case 35:
                _context9.prev = 35;
                fontFile = descriptor.get("FontFile", "FontFile2", "FontFile3");
                _context9.next = 45;
                break;

              case 39:
                _context9.prev = 39;
                _context9.t0 = _context9["catch"](35);

                if (this.options.ignoreErrors) {
                  _context9.next = 43;
                  break;
                }

                throw _context9.t0;

              case 43:
                (0, _util.war